/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.input.AbstractButtonInputProvider;
import components.input.PointerInputProvider;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import platform.DisplayWindow;

public class MouseInput
extends AbstractButtonInputProvider
implements PointerInputProvider {
    final DisplayWindow displayWindow;
    private final int[][] buttonMap = new int[2][38];
    int x;
    int y;
    boolean onScreen;
    boolean leftButton;
    boolean rightButton;
    boolean middleButton;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MouseInput.this.leftButton = false;
                MouseInput.this.x = MouseInput.this.displayWindow.toScreenX(mouseEvent.getX());
                MouseInput.this.y = MouseInput.this.displayWindow.toScreenY(mouseEvent.getY());
            }
            if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                MouseInput.this.middleButton = false;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                MouseInput.this.rightButton = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MouseInput.this.x = MouseInput.this.displayWindow.toScreenX(mouseEvent.getX());
                MouseInput.this.y = MouseInput.this.displayWindow.toScreenY(mouseEvent.getY());
                MouseInput.this.leftButton = true;
            }
            if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                MouseInput.this.middleButton = true;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                MouseInput.this.rightButton = true;
            }
            MouseInput.this.fireButtonPressed();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MouseInput.this.onScreen = true;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MouseInput.this.onScreen = false;
        }
    };
    private final MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MouseInput.this.x = MouseInput.this.displayWindow.toScreenX(mouseEvent.getX());
            MouseInput.this.y = MouseInput.this.displayWindow.toScreenY(mouseEvent.getY());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MouseInput.this.x = MouseInput.this.displayWindow.toScreenX(mouseEvent.getX());
            MouseInput.this.y = MouseInput.this.displayWindow.toScreenY(mouseEvent.getY());
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MouseInput.this.leftButton = true;
            }
        }
    };

    public MouseInput(DisplayWindow displayWindow) {
        this.displayWindow = displayWindow;
        displayWindow.addMouseListener(this.mouseListener);
        displayWindow.addMouseMotionListener(this.mouseMotionListener);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public boolean isOnScreen() {
        return this.onScreen;
    }

    @Override
    public void frameFinished() {
    }

    @Override
    public int[] getButtonMap(int n) {
        return (int[])this.buttonMap[n].clone();
    }

    @Override
    public void setButtonMap(int[][] nArray) {
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length && n < this.buttonMap.length) {
                if (nArray[n] != null) {
                    this.buttonMap[n] = (int[])nArray[n].clone();
                }
                ++n;
            }
        }
    }

    @Override
    public void setRequireWindowFocus(boolean bl) {
    }

    private boolean isButtonDown(int n, int n2) {
        if (n2 < this.buttonMap[n].length && this.buttonMap[n][n2] >= 0) {
            switch (this.buttonMap[n][n2]) {
                case 0: {
                    return this.leftButton;
                }
                case 1: {
                    return this.rightButton;
                }
                case 2: {
                    return this.middleButton;
                }
            }
        }
        return false;
    }

    @Override
    protected void fireButtonPressed() {
        super.fireButtonPressed();
    }

    @Override
    public boolean isButtonDown(int n) {
        return this.isButtonDown(0, n) || this.isButtonDown(1, n);
    }
}

