/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.input.SMSInputDevice;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jinput.JInputHandler;
import platform.Emulicious;
import system.EmulatableSystem;
import system.MasterSystem;

public class InputSetupDialog
extends JDialog {
    private static final Border focusBorder = BorderFactory.createLineBorder(Color.BLACK);
    private static final String[] gbButtonNames = new String[]{"A", "B", "Select", "Start", "Right", "Left", "Up", "Down"};
    private static final Button[][] smsButtonsA = new Button[][]{new Button[0], {new Button("Up", 8), new Button("Down", 9), new Button("Left", 10), new Button("Right", 11), new Button("1", 12), new Button("2", 13)}, {new Button("Up", 8), new Button("Down", 9), new Button("Left", 10), new Button("Right", 11), new Button("A", 25), new Button("B", 12), new Button("C", 13), new Button("Start", 24)}, {new Button("Up", 8), new Button("Down", 9), new Button("Left", 10), new Button("Right", 11), new Button("A", 25), new Button("B", 12), new Button("C", 13), new Button("Start", 24), new Button("Mode", 29), new Button("X", 30), new Button("Y", 31), new Button("Z", 32)}, {new Button("Trigger", 12)}, {new Button("1", 10), new Button("2", 9), new Button("3", 11)}};
    private static final Button[][] smsButtonsB = new Button[][]{new Button[0], {new Button("Up", 14), new Button("Down", 15), new Button("Left", 16), new Button("Right", 17), new Button("1", 18), new Button("2", 19)}, {new Button("Up", 14), new Button("Down", 15), new Button("Left", 16), new Button("Right", 17), new Button("A", 27), new Button("B", 18), new Button("C", 19), new Button("Start", 26)}, {new Button("Up", 14), new Button("Down", 15), new Button("Left", 16), new Button("Right", 17), new Button("A", 27), new Button("B", 18), new Button("C", 19), new Button("Start", 26), new Button("Mode", 33), new Button("X", 34), new Button("Y", 35), new Button("Z", 36)}, {new Button("Trigger", 18)}, {new Button("1", 16), new Button("2", 15), new Button("3", 17)}};
    private static final Button[] smsConsoleButtons = new Button[]{new Button("Reset Button", 20), new Button("Pause", 23), new Button("GG Start", 28), new Button("GG X-Terminator Reset", 37)};
    private int[][][] buttonMap;
    private boolean applyChanges;
    private final KeyListener[] jinputListeners;
    private final JComboBox<String>[] gamepadSelections = new JComboBox[4];
    private final JCheckBox requireWindowFocus;
    private final JComboBox<String>[] deviceSelections = new JComboBox[4];
    private final JSlider[] thresholds = new JSlider[4];
    private final JCheckBox[] gamepadKeyboard = new JCheckBox[4];
    private final JRadioButton[][] assignments = new JRadioButton[4][2];
    private ActionListener gbButtonsActionListener;
    private ActionListener smsButtonsActionListener;

    public InputSetupDialog(JFrame jFrame, String[] stringArray, int[][][] nArray, boolean bl, EmulatableSystem emulatableSystem) {
        super(jFrame, String.valueOf(Emulicious.TITLE) + " - Input Settings", true);
        Serializable serializable;
        this.setIconImages(jFrame.getIconImages());
        JTabbedPane jTabbedPane = new JTabbedPane();
        int n = 0;
        while (n < this.gamepadSelections.length) {
            this.gamepadSelections[n] = InputSetupDialog.createGamepadSelection(stringArray);
            ++n;
        }
        n = 0;
        while (n < this.deviceSelections.length) {
            this.deviceSelections[n] = new JComboBox<String>(SMSInputDevice.DEVICE_NAMES);
            ++n;
        }
        n = 0;
        while (n < this.thresholds.length) {
            this.thresholds[n] = new JSlider(10, 99);
            ++n;
        }
        n = 0;
        while (n < this.gamepadKeyboard.length) {
            this.gamepadKeyboard[n] = new JCheckBox("Also Use Keyboard");
            ++n;
        }
        this.jinputListeners = new KeyListener[this.gamepadSelections[0].getItemCount()];
        n = 0;
        while (n < this.assignments.length) {
            final int n2 = n;
            serializable = new ButtonGroup();
            int n3 = 0;
            while (n3 < this.assignments[n].length) {
                this.assignments[n][n3] = new JRadioButton(Integer.toString(n3), n3 == 0);
                ((ButtonGroup)serializable).add(this.assignments[n][n3]);
                this.assignments[n][n3].addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            if (n2 == 0) {
                                InputSetupDialog.this.updateGBbuttons();
                            } else {
                                InputSetupDialog.this.updateSMSbuttons();
                            }
                        }
                    }
                });
                ++n3;
            }
            ++n;
        }
        this.buttonMap = nArray;
        jTabbedPane.addTab("Game Boy (Color)", this.createGBKeySetup());
        jTabbedPane.addTab("Mastersystem / Game Gear", this.createSMSKeySetup());
        if (emulatableSystem instanceof MasterSystem) {
            jTabbedPane.setSelectedIndex(1);
        } else {
            jTabbedPane.setSelectedIndex(0);
        }
        this.add(jTabbedPane);
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton("OK");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputSetupDialog.this.applyChanges = true;
                InputSetupDialog.this.close();
            }
        });
        serializable = new JButton("Cancel");
        jPanel.add((Component)serializable);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputSetupDialog.this.close();
            }
        });
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    final JDialog jDialog = new JDialog((Dialog)InputSetupDialog.this, true);
                    jDialog.setUndecorated(true);
                    jDialog.setSize(0, 0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jDialog.dispose();
                        }
                    });
                    jDialog.setVisible(true);
                }
            });
        }
        this.requireWindowFocus = new JCheckBox("Require Window Focus", bl);
        jPanel.add(this.requireWindowFocus);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    private void close() {
        int n = 0;
        while (n < this.jinputListeners.length) {
            this.setJInputListener(n, null);
            ++n;
        }
        this.dispose();
    }

    public boolean isApplyChanges() {
        return this.applyChanges;
    }

    public boolean isRequireWindowFocus() {
        return this.requireWindowFocus.isSelected();
    }

    public int getSMSPlayerAselectedDevice() {
        return this.deviceSelections[1].getSelectedIndex();
    }

    public int getSMSPlayerBselectedDevice() {
        return this.deviceSelections[2].getSelectedIndex();
    }

    public int getThreshold(int n) {
        return this.thresholds[n].getValue();
    }

    public boolean isGamepadKeyboard(int n) {
        return this.gamepadKeyboard[n].isSelected();
    }

    public int getSelectedGamepad(int n) {
        return this.gamepadSelections[n].getSelectedIndex() - 1;
    }

    private void setJInputListener(int n, KeyListener keyListener) {
        if (n < 0) {
            return;
        }
        if (this.jinputListeners[n] != null) {
            JInputHandler.removeKeyListener(n, this.jinputListeners[n]);
        }
        if (keyListener != null) {
            JInputHandler.addKeyListener(n, keyListener);
        }
        this.jinputListeners[n] = keyListener;
    }

    private static JPanel setEmulatedInputDeviceBorder(JComponent jComponent) {
        return InputSetupDialog.setTitledBorder(jComponent, "Emulated Input Device");
    }

    private static JPanel setInputDeviceBorder(JComponent jComponent) {
        return InputSetupDialog.setTitledBorder(jComponent, "Input Device");
    }

    private static JPanel setTitledBorder(JComponent jComponent, String string) {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        if (jComponent instanceof JPanel) {
            jPanel = (JPanel)jComponent;
        } else {
            jPanel = new JPanel();
            jPanel.add(jComponent);
        }
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JPanel createGBKeySetup() {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JPanel jPanel2 = new JPanel(new GridLayout(5, 4, 10, 10));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.gbButtonsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputSetupDialog.this.updateGBbuttonPanel(jPanel2);
            }
        };
        jPanel.add((Component)this.createGamepadSelectionPanel("GBGamepad", null, 0, this.gbButtonsActionListener), "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "Center");
        this.updateGBbuttonPanel(jPanel2);
        return jPanel;
    }

    private void updateGBbuttonPanel(JPanel jPanel) {
        jPanel.removeAll();
        jPanel.add(new JLabel());
        this.addAssignmentsRow(jPanel, 0);
        jPanel.add(new JLabel());
        int n = 0;
        while (n < gbButtonNames.length) {
            int n2 = n / 2 + 4 * (n % 2);
            jPanel.add(new JLabel(gbButtonNames[n2]));
            jPanel.add(this.createKeySelector(0, n2));
            ++n;
        }
        jPanel.revalidate();
        jPanel.repaint();
        this.thresholds[0].setValue(Emulicious.getProperties().getInt("GBGamepadThreshold", 50));
        this.gamepadKeyboard[0].setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("GBGamepadKeyboard")));
        this.gamepadKeyboard[0].getParent().setVisible(this.gamepadSelections[0].getSelectedIndex() > 0);
        this.pack();
    }

    private static JComboBox<String> createGamepadSelection(String[] stringArray) {
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = "Keyboard";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        return jComboBox;
    }

    private JPanel createSMSKeySetup() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Player A"));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Player B"));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Console Buttons"));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        final JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        final JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        final JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.smsButtonsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputSetupDialog.this.updateSMSbuttonPanels(jPanel5, jPanel6, jPanel7);
            }
        };
        jPanel2.add((Component)this.createGamepadSelectionPanel("SMSGamepadA", "SMSInputDeviceA", 1, this.smsButtonsActionListener), "North");
        jPanel2.add((Component)jPanel5, "South");
        jPanel3.add((Component)this.createGamepadSelectionPanel("SMSGamepadB", "SMSInputDeviceB", 2, this.smsButtonsActionListener), "North");
        jPanel3.add((Component)jPanel6, "South");
        jPanel4.add((Component)this.createGamepadSelectionPanel("SMSbuttonsGamepad", null, 3, this.smsButtonsActionListener), "North");
        jPanel4.add((Component)jPanel7, "South");
        this.updateSMSbuttonPanels(jPanel5, jPanel6, jPanel7);
        return jPanel;
    }

    private void updateGBbuttons() {
        if (this.gbButtonsActionListener != null) {
            this.gbButtonsActionListener.actionPerformed(null);
        }
    }

    private void updateSMSbuttons() {
        if (this.smsButtonsActionListener != null) {
            this.smsButtonsActionListener.actionPerformed(null);
        }
    }

    private void clearAssignments(int n) {
        this.clearAssignments(n, 0);
        this.clearAssignments(n, 1);
    }

    private void clearAssignments(int n, int n2) {
        int[] nArray = this.getButtonMap(n, n2);
        switch (n) {
            case 0: {
                int n3 = 0;
                while (n3 < gbButtonNames.length) {
                    nArray[n3] = -1;
                    ++n3;
                }
                this.updateGBbuttons();
                break;
            }
            case 1: {
                Button[][] buttonArray = smsButtonsA;
                int n4 = smsButtonsA.length;
                int n5 = 0;
                while (n5 < n4) {
                    Button[] buttonArray2;
                    Button[] buttonArray3 = buttonArray2 = buttonArray[n5];
                    int n6 = buttonArray2.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Button button = buttonArray3[n7];
                        nArray[button.getId()] = -1;
                        ++n7;
                    }
                    ++n5;
                }
                this.updateSMSbuttons();
                break;
            }
            case 2: {
                Button[][] buttonArray = smsButtonsB;
                int n8 = smsButtonsB.length;
                int n9 = 0;
                while (n9 < n8) {
                    Button[] buttonArray4;
                    Button[] buttonArray5 = buttonArray4 = buttonArray[n9];
                    int n10 = buttonArray4.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        Button button = buttonArray5[n11];
                        nArray[button.getId()] = -1;
                        ++n11;
                    }
                    ++n9;
                }
                this.updateSMSbuttons();
                break;
            }
            case 3: {
                Button[] buttonArray = smsConsoleButtons;
                int n12 = smsConsoleButtons.length;
                int n13 = 0;
                while (n13 < n12) {
                    Button button = buttonArray[n13];
                    nArray[button.getId()] = -1;
                    ++n13;
                }
                this.updateSMSbuttons();
            }
        }
    }

    private void resetAssignments(int n) {
        int[][] nArrayArray = new int[][]{this.getButtonMap(n, 0), this.getButtonMap(n, 1)};
        int n2 = this.getSelectedGamepad(n);
        switch (n) {
            case 0: {
                int n3 = 0;
                while (n3 < gbButtonNames.length) {
                    nArrayArray[0][n3] = -1;
                    nArrayArray[1][n3] = -1;
                    ++n3;
                }
                if (n2 < 0) {
                    nArrayArray[0][0] = 83;
                    nArrayArray[0][1] = 65;
                    nArrayArray[0][2] = 16;
                    nArrayArray[0][3] = 10;
                    nArrayArray[0][4] = 39;
                    nArrayArray[0][5] = 37;
                    nArrayArray[0][6] = 38;
                    nArrayArray[0][7] = 40;
                } else {
                    nArrayArray[0][4] = JInputHandler.getPovRight(n2);
                    nArrayArray[0][5] = JInputHandler.getPovLeft(n2);
                    nArrayArray[0][6] = JInputHandler.getPovUp(n2);
                    nArrayArray[0][7] = JInputHandler.getPovDown(n2);
                    nArrayArray[0][3] = JInputHandler.getStartButton(n2);
                    nArrayArray[0][2] = JInputHandler.getSelectButton(n2);
                    nArrayArray[0][0] = JInputHandler.getAButton(n2);
                    nArrayArray[0][1] = JInputHandler.getBButton(n2);
                    nArrayArray[1][4] = JInputHandler.getStickRight(n2);
                    nArrayArray[1][5] = JInputHandler.getStickLeft(n2);
                    nArrayArray[1][6] = JInputHandler.getStickUp(n2);
                    nArrayArray[1][7] = JInputHandler.getStickDown(n2);
                }
                this.updateGBbuttons();
                break;
            }
            case 1: {
                Button[][] buttonArray = smsButtonsA;
                int n4 = smsButtonsA.length;
                int n5 = 0;
                while (n5 < n4) {
                    Button[] buttonArray2;
                    Button[] buttonArray3 = buttonArray2 = buttonArray[n5];
                    int n6 = buttonArray2.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Button button = buttonArray3[n7];
                        nArrayArray[0][button.getId()] = -1;
                        nArrayArray[1][button.getId()] = -1;
                        ++n7;
                    }
                    ++n5;
                }
                if (n2 < 0) {
                    nArrayArray[0][8] = 38;
                    nArrayArray[0][9] = 40;
                    nArrayArray[0][10] = 37;
                    nArrayArray[0][11] = 39;
                    nArrayArray[0][12] = 65;
                    nArrayArray[0][13] = 83;
                } else {
                    nArrayArray[0][8] = JInputHandler.getPovUp(n2);
                    nArrayArray[0][9] = JInputHandler.getPovDown(n2);
                    nArrayArray[0][10] = JInputHandler.getPovLeft(n2);
                    nArrayArray[0][11] = JInputHandler.getPovRight(n2);
                    nArrayArray[0][12] = JInputHandler.getAButton(n2);
                    nArrayArray[0][13] = JInputHandler.getBButton(n2);
                    nArrayArray[1][8] = JInputHandler.getStickUp(n2);
                    nArrayArray[1][9] = JInputHandler.getStickDown(n2);
                    nArrayArray[1][10] = JInputHandler.getStickLeft(n2);
                    nArrayArray[1][11] = JInputHandler.getStickRight(n2);
                }
                this.updateSMSbuttons();
                break;
            }
            case 2: {
                Button[][] buttonArray = smsButtonsB;
                int n8 = smsButtonsB.length;
                int n9 = 0;
                while (n9 < n8) {
                    Button[] buttonArray4;
                    Button[] buttonArray5 = buttonArray4 = buttonArray[n9];
                    int n10 = buttonArray4.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        Button button = buttonArray5[n11];
                        nArrayArray[0][button.getId()] = -1;
                        nArrayArray[1][button.getId()] = -1;
                        ++n11;
                    }
                    ++n9;
                }
                if (n2 < 0) {
                    nArrayArray[0][14] = 73;
                    nArrayArray[0][15] = 75;
                    nArrayArray[0][16] = 74;
                    nArrayArray[0][17] = 76;
                    nArrayArray[0][18] = 71;
                    nArrayArray[0][19] = 72;
                } else {
                    nArrayArray[0][14] = JInputHandler.getPovUp(n2);
                    nArrayArray[0][15] = JInputHandler.getPovDown(n2);
                    nArrayArray[0][16] = JInputHandler.getPovLeft(n2);
                    nArrayArray[0][17] = JInputHandler.getPovRight(n2);
                    nArrayArray[0][18] = JInputHandler.getAButton(n2);
                    nArrayArray[0][19] = JInputHandler.getBButton(n2);
                    nArrayArray[1][14] = JInputHandler.getStickUp(n2);
                    nArrayArray[1][15] = JInputHandler.getStickDown(n2);
                    nArrayArray[1][16] = JInputHandler.getStickLeft(n2);
                    nArrayArray[1][17] = JInputHandler.getStickRight(n2);
                }
                this.updateSMSbuttons();
                break;
            }
            case 3: {
                Button[] buttonArray = smsConsoleButtons;
                int n12 = smsConsoleButtons.length;
                int n13 = 0;
                while (n13 < n12) {
                    Button button = buttonArray[n13];
                    nArrayArray[0][button.getId()] = -1;
                    nArrayArray[1][button.getId()] = -1;
                    ++n13;
                }
                if (n2 < 0) {
                    nArrayArray[0][23] = 10;
                    nArrayArray[0][28] = 10;
                } else {
                    nArrayArray[0][23] = JInputHandler.getStartButton(n2);
                    nArrayArray[0][28] = JInputHandler.getStartButton(n2);
                }
                this.updateSMSbuttons();
            }
        }
    }

    private int getSelectedAssignment(int n) {
        if (this.assignments[n][1].isSelected()) {
            return 1;
        }
        return 0;
    }

    private JPanel createGamepadSelectionPanel(String string, String string2, final int n, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(this.gamepadSelections[n], "North");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 10, 10));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputSetupDialog.this.clearAssignments(n);
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Default");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputSetupDialog.this.resetAssignments(n);
            }
        });
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel();
        jPanel4.add((Component)jPanel5, "North");
        final JLabel jLabel = new JLabel(String.valueOf(Integer.toString(this.thresholds[n].getValue())) + '%');
        this.thresholds[n].addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jLabel.setText(String.valueOf(Integer.toString(InputSetupDialog.this.thresholds[n].getValue())) + '%');
                int n2 = InputSetupDialog.this.gamepadSelections[n].getSelectedIndex() - 1;
                if (n2 >= 0) {
                    JInputHandler.setThreshold(n2, (float)InputSetupDialog.this.thresholds[n].getValue() / 100.0f);
                }
            }
        });
        jPanel5.add(new JLabel("Stick Threshold: "));
        jPanel5.add(jLabel);
        jPanel5.add(this.thresholds[n]);
        jPanel4.add(this.gamepadKeyboard[n]);
        jPanel.add((Component)InputSetupDialog.setInputDeviceBorder(jPanel2), "North");
        int n2 = Emulicious.getProperties().getInt(string, -1) + 1;
        if (n2 < 0 || n2 >= this.gamepadSelections[n].getItemCount()) {
            n2 = 0;
        }
        this.gamepadSelections[n].setSelectedIndex(n2);
        this.gamepadSelections[n].addActionListener(actionListener);
        if (string2 != null) {
            jPanel.add((Component)InputSetupDialog.setEmulatedInputDeviceBorder(this.deviceSelections[n]), "South");
            int n3 = Emulicious.getProperties().getInt(string2, 0);
            if (n3 < 0 || n3 >= SMSInputDevice.DEVICE_NAMES.length) {
                n3 = 0;
            }
            this.deviceSelections[n].setSelectedIndex(n3);
            this.deviceSelections[n].addActionListener(actionListener);
        }
        return jPanel;
    }

    private void updateSMSbuttonPanels(JPanel jPanel, JPanel jPanel2, JPanel jPanel3) {
        Button[] buttonArray = smsButtonsA[this.deviceSelections[1].getSelectedIndex()];
        Button[] buttonArray2 = smsButtonsB[this.deviceSelections[2].getSelectedIndex()];
        int n = Math.max(Math.max(buttonArray.length, buttonArray2.length), 5);
        jPanel.removeAll();
        jPanel.setLayout(new GridLayout(1 + n, 2, 10, 10));
        if (buttonArray.length > 0) {
            this.addAssignmentsRow(jPanel, 1);
        }
        Button[] buttonArray3 = buttonArray;
        int n2 = buttonArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Button button = buttonArray3[n3];
            jPanel.add(new JLabel(button.getName()));
            jPanel.add(this.createKeySelector(1, button.getId()));
            ++n3;
        }
        int n4 = buttonArray.length;
        while (n4 < n) {
            jPanel.add(new JLabel());
            jPanel.add(new JLabel());
            ++n4;
        }
        jPanel.revalidate();
        jPanel.repaint();
        jPanel2.removeAll();
        jPanel2.setLayout(new GridLayout(1 + n, 2, 10, 10));
        if (buttonArray2.length > 0) {
            this.addAssignmentsRow(jPanel2, 2);
        }
        buttonArray3 = buttonArray2;
        n2 = buttonArray2.length;
        n3 = 0;
        while (n3 < n2) {
            Button button = buttonArray3[n3];
            jPanel2.add(new JLabel(button.getName()));
            jPanel2.add(this.createKeySelector(2, button.getId()));
            ++n3;
        }
        int n5 = buttonArray2.length;
        while (n5 < n) {
            jPanel2.add(new JLabel());
            jPanel2.add(new JLabel());
            ++n5;
        }
        jPanel2.revalidate();
        jPanel2.repaint();
        jPanel3.removeAll();
        jPanel3.setLayout(new GridLayout(1 + n, 2, 10, 10));
        this.addAssignmentsRow(jPanel3, 3);
        jPanel3.add(new JLabel());
        jPanel3.add(new JLabel());
        buttonArray3 = smsConsoleButtons;
        n2 = smsConsoleButtons.length;
        n3 = 0;
        while (n3 < n2) {
            Button button = buttonArray3[n3];
            jPanel3.add(new JLabel(button.getName()));
            jPanel3.add(this.createKeySelector(3, button.getId()));
            ++n3;
        }
        int n6 = smsConsoleButtons.length + 1;
        while (n6 < n) {
            jPanel3.add(new JLabel());
            jPanel3.add(new JLabel());
            ++n6;
        }
        jPanel3.revalidate();
        jPanel3.repaint();
        this.thresholds[1].setValue(Emulicious.getProperties().getInt("SMSGamepadAThreshold", 50));
        this.gamepadKeyboard[1].setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("SMSGamepadAKeyboard")));
        this.gamepadKeyboard[1].getParent().setVisible(this.gamepadSelections[1].getSelectedIndex() > 0);
        this.thresholds[2].setValue(Emulicious.getProperties().getInt("SMSGamepadBThreshold", 50));
        this.gamepadKeyboard[2].setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("SMSGamepadBKeyboard")));
        this.gamepadKeyboard[2].getParent().setVisible(this.gamepadSelections[2].getSelectedIndex() > 0);
        this.thresholds[3].setValue(Emulicious.getProperties().getInt("SMSbuttonsThreshold", 50));
        this.gamepadKeyboard[3].setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("SMSbuttonsKeyboard")));
        this.gamepadKeyboard[3].getParent().setVisible(this.gamepadSelections[3].getSelectedIndex() > 0);
        this.pack();
    }

    private void addAssignmentsRow(JPanel jPanel, int n) {
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.assignments[n][0]);
        jPanel2.add(this.assignments[n][1]);
        jPanel.add(new JLabel("Assignment"));
        jPanel.add(jPanel2);
    }

    private String getButtonName(int n, int n2) {
        if (n2 < 0) {
            return "<Unassigned>";
        }
        int n3 = this.getSelectedGamepad(n);
        if (n3 < 0) {
            return KeyEvent.getKeyText(n2);
        }
        return JInputHandler.getComponentName(n3, n2);
    }

    private int[] getButtonMap(int n, int n2) {
        int n3 = this.getSelectedGamepad(n);
        if (n3 < 0) {
            return this.buttonMap[0][n2];
        }
        return this.buttonMap[1 + n3][n2];
    }

    private JButton createKeySelector(final int n, final int n2) {
        final int n3 = this.getSelectedAssignment(n);
        final JButton jButton = new JButton(this.getButtonName(n, this.getButtonMap(n, n3)[n2]));
        final Border border = jButton.getBorder();
        jButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jButton.setBorder(focusBorder);
                InputSetupDialog.this.setJInputListener(InputSetupDialog.this.getSelectedGamepad(n), new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        ((InputSetupDialog)(this).InputSetupDialog.this).getButtonMap((int)n, (int)n3)[n2] = keyEvent.getKeyCode();
                        jButton.setText(InputSetupDialog.this.getButtonName(n, keyEvent.getKeyCode()));
                        InputSetupDialog.this.requestFocus();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jButton.setBorder(border);
                InputSetupDialog.this.setJInputListener(InputSetupDialog.this.getSelectedGamepad(n), null);
            }
        });
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (InputSetupDialog.this.getSelectedGamepad(n) != -1) {
                    return;
                }
                ((InputSetupDialog)InputSetupDialog.this).getButtonMap((int)n, (int)n3)[n2] = keyEvent.getKeyCode();
                jButton.setText(InputSetupDialog.this.getButtonName(n, keyEvent.getKeyCode()));
                InputSetupDialog.this.requestFocus();
            }
        });
        return jButton;
    }

    private static class Button {
        private final String name;
        private final int id;

        public Button(String string, int n) {
            this.name = string;
            this.id = n;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

