/*
 * Decompiled with CFR 0.152.
 */
package dap;

import dap.DebugAdapter;
import dap.base.DebugAdapterBaseProtocol;
import dap.base.DebugAdapterProtocolMessage;
import dap.base.DebugAdapterProtocolMessageHandler;
import dap.messages.Event;
import dap.messages.ProtocolMessage;
import dap.messages.Request;
import dap.messages.Response;
import dap.messages.events.BreakpointEvent;
import dap.messages.events.CapabilitiesEvent;
import dap.messages.events.ContinuedEvent;
import dap.messages.events.InitializedEvent;
import dap.messages.events.OutputEvent;
import dap.messages.events.StoppedEvent;
import dap.messages.events.TerminatedEvent;
import dap.messages.requests.AttachRequest;
import dap.messages.requests.ContinueRequest;
import dap.messages.requests.DisconnectRequest;
import dap.messages.requests.EvaluateRequest;
import dap.messages.requests.GoToRequest;
import dap.messages.requests.InitializeRequest;
import dap.messages.requests.LaunchRequest;
import dap.messages.requests.NextRequest;
import dap.messages.requests.PauseRequest;
import dap.messages.requests.RestartFrameRequest;
import dap.messages.requests.ReverseContinueRequest;
import dap.messages.requests.ScopesRequest;
import dap.messages.requests.SetBreakpointsRequest;
import dap.messages.requests.SetExceptionBreakpoints;
import dap.messages.requests.SourceRequest;
import dap.messages.requests.StackTraceRequest;
import dap.messages.requests.StepBackRequest;
import dap.messages.requests.StepInRequest;
import dap.messages.requests.StepOutRequest;
import dap.messages.requests.ThreadsRequest;
import dap.messages.requests.VariablesRequest;
import dap.messages.responses.AttachResponse;
import dap.messages.responses.ContinueResponse;
import dap.messages.responses.DisconnectResponse;
import dap.messages.responses.ErrorResponse;
import dap.messages.responses.EvaluateResponse;
import dap.messages.responses.InitializeResponse;
import dap.messages.responses.LaunchResponse;
import dap.messages.responses.NextResponse;
import dap.messages.responses.PauseResponse;
import dap.messages.responses.RestartFrameResponse;
import dap.messages.responses.ReverseContinueResponse;
import dap.messages.responses.ScopesResponse;
import dap.messages.responses.SetBreakpointsResponse;
import dap.messages.responses.SetExceptionBreakpointsResponse;
import dap.messages.responses.SourceResponse;
import dap.messages.responses.StackTraceResponse;
import dap.messages.responses.StepBackResponse;
import dap.messages.responses.StepInResponse;
import dap.messages.responses.StepOutResponse;
import dap.messages.responses.ThreadsResponse;
import dap.messages.responses.VariablesResponse;
import dap.types.Breakpoint;
import dap.types.DebugThread;
import dap.types.EvaluateResult;
import dap.types.Message;
import dap.types.Scope;
import dap.types.SourceResult;
import dap.types.StackFrame;
import dap.types.Variable;
import java.io.IOException;
import java.util.Map;

class DebugAdapterProtocol {
    private static final boolean DEBUG = false;
    private final DebugAdapterBaseProtocol baseProtocol;

    public DebugAdapterProtocol(int n, final DebugAdapter debugAdapter) throws IOException {
        if (debugAdapter == null) {
            throw new IllegalArgumentException("debugAdapter must not be null");
        }
        this.baseProtocol = new DebugAdapterBaseProtocol(n, new DebugAdapterProtocolMessageHandler(){

            @Override
            public void handleMessage(DebugAdapterProtocolMessage debugAdapterProtocolMessage) {
                ProtocolMessage protocolMessage = ProtocolMessage.from(debugAdapterProtocolMessage);
                if (protocolMessage instanceof Request) {
                    try {
                        if (protocolMessage instanceof InitializeRequest) {
                            InitializeRequest initializeRequest = (InitializeRequest)protocolMessage;
                            DebugAdapter.Capabilities capabilities = debugAdapter.initialize(initializeRequest);
                            DebugAdapterProtocol.this.sendMessage(new InitializeResponse(initializeRequest, null, capabilities));
                        } else if (protocolMessage instanceof DisconnectRequest) {
                            DisconnectRequest disconnectRequest = (DisconnectRequest)protocolMessage;
                            debugAdapter.disconnect(disconnectRequest.isRestart(), disconnectRequest.getTerminateDebuggee());
                            DebugAdapterProtocol.this.sendMessage(new DisconnectResponse(disconnectRequest, null));
                            DebugAdapterProtocol.this.stop();
                        } else if (protocolMessage instanceof SetExceptionBreakpoints) {
                            SetExceptionBreakpoints setExceptionBreakpoints = (SetExceptionBreakpoints)protocolMessage;
                            Breakpoint[] breakpointArray = debugAdapter.setExceptionBreakpoints(setExceptionBreakpoints.getFilters());
                            DebugAdapterProtocol.this.sendMessage(new SetExceptionBreakpointsResponse(setExceptionBreakpoints, null, breakpointArray));
                        } else if (protocolMessage instanceof LaunchRequest) {
                            LaunchRequest launchRequest = (LaunchRequest)protocolMessage;
                            String string = debugAdapter.launch(launchRequest.isNoDebug(), launchRequest.getArguments());
                            DebugAdapterProtocol.this.sendMessage(new LaunchResponse(launchRequest, string));
                        } else if (protocolMessage instanceof ThreadsRequest) {
                            ThreadsRequest threadsRequest = (ThreadsRequest)protocolMessage;
                            DebugThread[] debugThreadArray = debugAdapter.getThreads();
                            DebugAdapterProtocol.this.sendMessage(new ThreadsResponse(threadsRequest, null, debugThreadArray));
                        } else if (protocolMessage instanceof SetBreakpointsRequest) {
                            SetBreakpointsRequest setBreakpointsRequest = (SetBreakpointsRequest)protocolMessage;
                            Breakpoint[] breakpointArray = debugAdapter.setBreakpoints(setBreakpointsRequest.getSource(), setBreakpointsRequest.getBreakpoints(), setBreakpointsRequest.getLines(), setBreakpointsRequest.isSourceModified());
                            DebugAdapterProtocol.this.sendMessage(new SetBreakpointsResponse(setBreakpointsRequest, null, breakpointArray));
                        } else if (protocolMessage instanceof ContinueRequest) {
                            ContinueRequest continueRequest = (ContinueRequest)protocolMessage;
                            boolean bl = debugAdapter.resume(continueRequest.getThreadId());
                            DebugAdapterProtocol.this.sendMessage(new ContinueResponse(continueRequest, null, bl));
                        } else if (protocolMessage instanceof PauseRequest) {
                            PauseRequest pauseRequest = (PauseRequest)protocolMessage;
                            debugAdapter.pause(pauseRequest.getThreadId());
                            DebugAdapterProtocol.this.sendMessage(new PauseResponse(pauseRequest, null));
                        } else if (protocolMessage instanceof NextRequest) {
                            NextRequest nextRequest = (NextRequest)protocolMessage;
                            debugAdapter.next(nextRequest.getThreadId(), nextRequest.getGranularity());
                            DebugAdapterProtocol.this.sendMessage(new NextResponse(nextRequest, null));
                        } else if (protocolMessage instanceof StepInRequest) {
                            StepInRequest stepInRequest = (StepInRequest)protocolMessage;
                            debugAdapter.stepIn(stepInRequest.getThreadId(), stepInRequest.getGranularity());
                            DebugAdapterProtocol.this.sendMessage(new StepInResponse(stepInRequest, null));
                        } else if (protocolMessage instanceof StepOutRequest) {
                            StepOutRequest stepOutRequest = (StepOutRequest)protocolMessage;
                            debugAdapter.stepOut(stepOutRequest.getThreadId(), stepOutRequest.getGranularity());
                            DebugAdapterProtocol.this.sendMessage(new StepOutResponse(stepOutRequest, null));
                        } else if (protocolMessage instanceof StepBackRequest) {
                            StepBackRequest stepBackRequest = (StepBackRequest)protocolMessage;
                            debugAdapter.stepBack(stepBackRequest.getThreadId(), stepBackRequest.getGranularity());
                            DebugAdapterProtocol.this.sendMessage(new StepBackResponse(stepBackRequest, null));
                        } else if (protocolMessage instanceof ReverseContinueRequest) {
                            ReverseContinueRequest reverseContinueRequest = (ReverseContinueRequest)protocolMessage;
                            debugAdapter.reverseContinue(reverseContinueRequest.getThreadId());
                            DebugAdapterProtocol.this.sendMessage(new ReverseContinueResponse(reverseContinueRequest, null));
                        } else if (protocolMessage instanceof RestartFrameRequest) {
                            RestartFrameRequest restartFrameRequest = (RestartFrameRequest)protocolMessage;
                            debugAdapter.restartFrame(restartFrameRequest.getThreadId());
                            DebugAdapterProtocol.this.sendMessage(new RestartFrameResponse(restartFrameRequest, null));
                        } else if (protocolMessage instanceof GoToRequest) {
                            GoToRequest goToRequest = (GoToRequest)protocolMessage;
                            debugAdapter.goTo(goToRequest.getThreadId(), goToRequest.getTargetId());
                            DebugAdapterProtocol.this.sendMessage(new RestartFrameResponse(goToRequest, null));
                        } else if (protocolMessage instanceof StackTraceRequest) {
                            StackTraceRequest stackTraceRequest = (StackTraceRequest)protocolMessage;
                            StackFrame[] stackFrameArray = debugAdapter.getStackFrames(stackTraceRequest.getThreadId(), stackTraceRequest.getStartFrame(), stackTraceRequest.getLevels(), stackTraceRequest.getStackFrameFormat());
                            DebugAdapterProtocol.this.sendMessage(new StackTraceResponse(stackTraceRequest, null, stackFrameArray));
                        } else if (protocolMessage instanceof ScopesRequest) {
                            ScopesRequest scopesRequest = (ScopesRequest)protocolMessage;
                            Scope[] scopeArray = debugAdapter.getScopes(scopesRequest.getFrameId());
                            DebugAdapterProtocol.this.sendMessage(new ScopesResponse(scopesRequest, null, scopeArray));
                        } else if (protocolMessage instanceof VariablesRequest) {
                            VariablesRequest variablesRequest = (VariablesRequest)protocolMessage;
                            Variable[] variableArray = debugAdapter.getVariables(variablesRequest.getVariablesReference(), variablesRequest.getFilter(), variablesRequest.getStart(), variablesRequest.getCount(), variablesRequest.getFormat());
                            DebugAdapterProtocol.this.sendMessage(new VariablesResponse(variablesRequest, null, variableArray));
                        } else if (protocolMessage instanceof AttachRequest) {
                            AttachRequest attachRequest = (AttachRequest)protocolMessage;
                            debugAdapter.attach(attachRequest.getArguments());
                            DebugAdapterProtocol.this.sendMessage(new AttachResponse(attachRequest, null));
                        } else if (protocolMessage instanceof SourceRequest) {
                            SourceRequest sourceRequest = (SourceRequest)protocolMessage;
                            SourceResult sourceResult = debugAdapter.getSource(sourceRequest.getSource(), sourceRequest.getSourceReference());
                            DebugAdapterProtocol.this.sendMessage(new SourceResponse(sourceRequest, null, sourceResult));
                        } else if (protocolMessage instanceof EvaluateRequest) {
                            EvaluateRequest evaluateRequest = (EvaluateRequest)protocolMessage;
                            EvaluateResult evaluateResult = debugAdapter.evaluate(evaluateRequest.getExpression(), evaluateRequest.getFrameId(), evaluateRequest.getContext(), evaluateRequest.getFormat());
                            DebugAdapterProtocol.this.sendMessage(new EvaluateResponse(evaluateRequest, null, evaluateResult));
                        }
                    }
                    catch (Exception exception) {
                        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                        String string = stackTraceElementArray != null && stackTraceElementArray.length > 0 ? stackTraceElementArray[0].toString() : null;
                        DebugAdapterProtocol.this.sendMessage(new ErrorResponse((Request)protocolMessage, "exception", new Message(1, "Error handling request " + protocolMessage.getClass().getSimpleName() + ": " + exception.getClass().getSimpleName() + (exception.getLocalizedMessage() != null ? " : " + exception.getLocalizedMessage() : "") + (string != null ? "\n" + string : ""), true)));
                        exception.printStackTrace();
                    }
                } else if (protocolMessage instanceof Response) {
                    System.out.println("Response received: " + protocolMessage);
                } else if (protocolMessage instanceof Event) {
                    System.out.println("Event received: " + protocolMessage);
                }
            }
        });
    }

    void stop() {
        this.baseProtocol.stop();
    }

    void close() {
        this.baseProtocol.close();
    }

    void sendMessage(ProtocolMessage protocolMessage) {
        this.baseProtocol.sendMessage(protocolMessage);
    }

    void sendInitializedEvent() {
        this.sendMessage(new InitializedEvent());
    }

    void sendStoppedEvent(StoppedEvent.Reason reason, int n) {
        this.sendMessage(new StoppedEvent(reason, n));
    }

    void sendStoppedEvent(StoppedEvent.Reason reason, String string, int n, String string2) {
        this.sendMessage(new StoppedEvent(reason, string, n, string2));
    }

    void sendStoppedEvent(StoppedEvent.Reason reason, String string, int n, Boolean bl, String string2, Boolean bl2) {
        this.sendMessage(new StoppedEvent(reason, string, n, bl, string2, bl2));
    }

    void sendContinuedEvent(int n) {
        this.sendMessage(new ContinuedEvent(n));
    }

    void sendContinuedEvent(int n, Boolean bl) {
        this.sendMessage(new ContinuedEvent(n, bl));
    }

    void sendBreakpointEvent(BreakpointEvent.Reason reason, Breakpoint breakpoint) {
        this.sendMessage(new BreakpointEvent(reason, breakpoint));
    }

    void sendTerminatedEvent() {
        this.sendMessage(new TerminatedEvent());
    }

    void sendOutputEvent(String string) {
        this.sendMessage(new OutputEvent(string));
    }

    void sendCapabilitiesEvent(Map<String, Object> map) {
        this.sendMessage(new CapabilitiesEvent(map));
    }

    boolean isConnected() {
        return this.baseProtocol.isConnected();
    }
}

