/*
 * Decompiled with CFR 0.152.
 */
package components.input;

import components.input.AbstractSMSInputDevice;
import components.input.ButtonInputProvider;
import components.input.PointerInputProvider;

public class SegaGraphicBoard
extends AbstractSMSInputDevice {
    private static final int[][] BUTTON_IDENTIFIERS = new int[][]{{10, 9, 11}, {16, 15, 17}};
    private final int[] buttonIdentifiers;
    private final ButtonInputProvider buttonInputProvider;
    private final PointerInputProvider pointerInputProvider;
    private int state;

    public SegaGraphicBoard(int n, ButtonInputProvider buttonInputProvider, PointerInputProvider pointerInputProvider) {
        super(BUTTON_IDENTIFIERS[n & 1].length);
        if (buttonInputProvider == null) {
            throw new IllegalArgumentException("buttonInputProvider must not be null");
        }
        if (pointerInputProvider == null) {
            throw new IllegalArgumentException("pointerInputProvider must not be null");
        }
        this.buttonInputProvider = buttonInputProvider;
        this.pointerInputProvider = pointerInputProvider;
        this.buttonIdentifiers = BUTTON_IDENTIFIERS[n & 1];
    }

    private int getPressure() {
        return this.pointerInputProvider.isOnScreen() ? 253 : 0;
    }

    private int getX() {
        if (!this.pointerInputProvider.isOnScreen()) {
            return 0;
        }
        return this.pointerInputProvider.getX() - 4;
    }

    private int getY() {
        if (!this.pointerInputProvider.isOnScreen()) {
            return 42;
        }
        return this.pointerInputProvider.getY() + 32 + 4;
    }

    @Override
    public int readData(int n) {
        int n2 = 192;
        if (!this.pointerInputProvider.isOnScreen()) {
            n2 |= 0x10;
        }
        if (this.isTRhigh()) {
            return 0x20 | n2;
        }
        if (this.state == 0) {
            n2 |= 8;
            int n3 = 0;
            while (n3 < this.buttonIdentifiers.length) {
                if (!this.isButtonDown(n3)) {
                    n2 |= 1 << n3;
                }
                ++n3;
            }
            return n2;
        }
        switch (this.state) {
            case 1: {
                return this.getPressure() >> 4;
            }
            case 2: {
                return this.getPressure() & 0xF;
            }
            case 3: {
                return this.getX() >> 4;
            }
            case 4: {
                return this.getX() & 0xF;
            }
            case 5: {
                return this.getY() >> 4;
            }
            case 6: {
                return this.getY() & 0xF;
            }
        }
        return n2;
    }

    @Override
    protected void handleRisingEdgeTR(int n) {
        this.state = 0;
    }

    @Override
    protected void handleRisingEdgeTH(int n) {
        if (!this.isTRhigh() && this.state < 6) {
            ++this.state;
        }
    }

    @Override
    protected void handleFallingEdgeTH(int n) {
        if (!this.isTRhigh() && this.state < 6) {
            ++this.state;
        }
    }

    @Override
    protected boolean isButtonPressed(int n) {
        return this.buttonInputProvider.isButtonDown(this.buttonIdentifiers[n]);
    }
}

