/*
 * Decompiled with CFR 0.152.
 */
package components.cpu;

import components.cpu.CpuInfo;

public class Z80Info
implements CpuInfo {
    private static final int[] CYCLES = new int[]{4, 10, 7, 6, 4, 4, 7, 4, 4, 11, 7, 6, 4, 4, 7, 4, 8, 10, 7, 6, 4, 4, 7, 4, 12, 11, 7, 6, 4, 4, 7, 4, 7, 10, 16, 6, 4, 4, 7, 4, 7, 11, 16, 6, 4, 4, 7, 4, 7, 10, 13, 6, 11, 11, 10, 4, 7, 11, 13, 6, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 7, 7, 7, 7, 7, 7, 4, 7, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 5, 10, 10, 10, 10, 11, 7, 11, 5, 10, 10, 4, 10, 17, 7, 11, 5, 10, 10, 11, 10, 11, 7, 11, 5, 4, 10, 11, 10, 4, 7, 11, 5, 10, 10, 19, 10, 11, 7, 11, 5, 4, 10, 4, 10, 4, 7, 11, 5, 10, 10, 4, 10, 11, 7, 11, 5, 6, 10, 4, 10, 4, 7, 11};
    private static final int[] CYCLES_CB = new int[]{4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4};
    private static final int[] CYCLES_ED = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 11, 16, 4, 10, 4, 5, 8, 8, 11, 16, 4, 10, 4, 5, 8, 8, 11, 16, 4, 10, 4, 5, 8, 8, 11, 16, 4, 10, 4, 5, 8, 8, 11, 16, 4, 10, 4, 14, 8, 8, 11, 16, 4, 10, 4, 14, 8, 8, 11, 16, 4, 10, 4, 4, 8, 8, 11, 16, 4, 10, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 12, 12, 9, 12, 4, 4, 4, 4, 12, 12, 9, 12, 4, 4, 4, 4, 12, 12, 9, 12, 4, 4, 4, 4, 12, 12, 9, 12, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static Z80Info instance;

    private static int getCyclesDDorFD(int n, int n2) {
        if (n2 == 203) {
            return (n & 0xC0) == 64 ? 16 : 19;
        }
        switch (n) {
            case 9: {
                return 11;
            }
            case 25: {
                return 11;
            }
            case 33: {
                return 10;
            }
            case 34: {
                return 16;
            }
            case 35: {
                return 6;
            }
            case 36: {
                return 4;
            }
            case 37: {
                return 4;
            }
            case 38: {
                return 7;
            }
            case 41: {
                return 11;
            }
            case 42: {
                return 16;
            }
            case 43: {
                return 6;
            }
            case 44: {
                return 4;
            }
            case 45: {
                return 4;
            }
            case 46: {
                return 7;
            }
            case 52: {
                return 19;
            }
            case 53: {
                return 19;
            }
            case 54: {
                return 15;
            }
            case 57: {
                return 11;
            }
            case 68: {
                return 4;
            }
            case 69: {
                return 4;
            }
            case 70: {
                return 15;
            }
            case 76: {
                return 4;
            }
            case 77: {
                return 4;
            }
            case 78: {
                return 15;
            }
            case 84: {
                return 4;
            }
            case 85: {
                return 4;
            }
            case 86: {
                return 15;
            }
            case 92: {
                return 4;
            }
            case 93: {
                return 4;
            }
            case 94: {
                return 15;
            }
            case 96: {
                return 4;
            }
            case 97: {
                return 4;
            }
            case 98: {
                return 4;
            }
            case 99: {
                return 4;
            }
            case 100: {
                return 4;
            }
            case 101: {
                return 4;
            }
            case 102: {
                return 15;
            }
            case 103: {
                return 4;
            }
            case 104: {
                return 4;
            }
            case 105: {
                return 4;
            }
            case 106: {
                return 4;
            }
            case 107: {
                return 4;
            }
            case 108: {
                return 4;
            }
            case 109: {
                return 4;
            }
            case 110: {
                return 15;
            }
            case 111: {
                return 4;
            }
            case 112: {
                return 15;
            }
            case 113: {
                return 15;
            }
            case 114: {
                return 15;
            }
            case 115: {
                return 15;
            }
            case 116: {
                return 15;
            }
            case 117: {
                return 15;
            }
            case 119: {
                return 15;
            }
            case 124: {
                return 4;
            }
            case 125: {
                return 4;
            }
            case 126: {
                return 15;
            }
            case 132: {
                return 4;
            }
            case 133: {
                return 4;
            }
            case 134: {
                return 15;
            }
            case 140: {
                return 4;
            }
            case 141: {
                return 4;
            }
            case 142: {
                return 15;
            }
            case 148: {
                return 4;
            }
            case 149: {
                return 4;
            }
            case 150: {
                return 15;
            }
            case 156: {
                return 4;
            }
            case 157: {
                return 4;
            }
            case 158: {
                return 15;
            }
            case 164: {
                return 4;
            }
            case 165: {
                return 4;
            }
            case 166: {
                return 15;
            }
            case 172: {
                return 4;
            }
            case 173: {
                return 4;
            }
            case 174: {
                return 15;
            }
            case 180: {
                return 4;
            }
            case 181: {
                return 4;
            }
            case 182: {
                return 15;
            }
            case 188: {
                return 4;
            }
            case 189: {
                return 4;
            }
            case 190: {
                return 15;
            }
            case 225: {
                return 10;
            }
            case 227: {
                return 19;
            }
            case 229: {
                return 11;
            }
            case 233: {
                return 4;
            }
            case 249: {
                return 6;
            }
        }
        throw new IllegalArgumentException(String.format("%02X", n));
    }

    public static Z80Info getInstance() {
        if (instance == null) {
            instance = new Z80Info();
        }
        return instance;
    }

    protected Z80Info() {
    }

    @Override
    public int getMinCycles(int n, int n2) {
        if ((n2 & 0xDF00) == 56576) {
            return this.getMinCycles(221, 0) + Z80Info.getCyclesDDorFD(n, n2 & 0xFF);
        }
        if ((n2 & 0xDF) == 221) {
            return this.getMinCycles(221, 0) + Z80Info.getCyclesDDorFD(n, 0);
        }
        if (n2 == 203) {
            return this.getMinCycles(203, 0) + CYCLES_CB[n & 0xFF];
        }
        if (n2 == 237) {
            return this.getMinCycles(237, 0) + CYCLES_ED[n & 0xFF];
        }
        return CYCLES[n & 0xFF];
    }

    @Override
    public int getMaxCycles(int n, int n2) {
        if (n2 > 0) {
            if (n2 == 237 && (n & 0xF4) == 176) {
                return this.getMinCycles(n, n2) + 5;
            }
            return this.getMinCycles(n, n2);
        }
        switch (n) {
            case 16: {
                return this.getMinCycles(n, n2) + 5;
            }
            case 32: 
            case 40: 
            case 48: 
            case 56: {
                return this.getMinCycles(n, n2) + 5;
            }
            case 192: 
            case 200: 
            case 208: 
            case 216: 
            case 224: 
            case 232: 
            case 240: 
            case 248: {
                return this.getMinCycles(n, n2) + 6;
            }
            case 196: 
            case 204: 
            case 212: 
            case 220: 
            case 228: 
            case 236: 
            case 244: 
            case 252: {
                return this.getMinCycles(n, n2) + 7;
            }
        }
        return this.getMinCycles(n, n2);
    }

    public int getWaitCycles() {
        return 0;
    }
}

