/*
 * Decompiled with CFR 0.152.
 */
package components.cartridge;

import components.cartridge.Cartridge;
import components.cartridge.Mapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.HashSet;
import patching.IPS;
import util.io.IOUtilities;

public class SMSCartridge
extends Cartridge {
    private int[] ram = new int[0];
    private final int MASK_BANK;
    private int frame3ROMPageNumber;
    private int frame2ROMPageNumber;
    private int frame1ROMPageNumber;
    private int frame0ROMPageNumber;
    private int ramPageNumber;
    private boolean ramWriteProtect;
    private boolean ramEnabled;
    private boolean ramChanged;
    protected long lastWriteMillis;
    private boolean sgROM;
    private boolean smsMode;
    private static final HashSet<Integer> checksumsHiComNin1mapper = new HashSet<Integer>(Arrays.asList(-1733361098, 1858068931, -2119996849, -1926403747, -2101306537, 1082715828, -72793784, -2093758354, 15302815));
    private static final HashSet<Integer> checksumsKoreanSuperGameMapper = new HashSet<Integer>(Arrays.asList(1310730914, -1168300170, -1472085833));
    private static final HashSet<Integer> checksumsKoreanSuperGameMapper2 = new HashSet<Integer>(Arrays.asList(951297839, -754621294, -1425543980, 215877944, -1029982003, 1712060140, -344485666, -424850101));
    private static final HashSet<Integer> checksumsKoreanSuperGameMapper3 = new HashSet<Integer>(Arrays.asList(461985489, -638616215));
    private static final HashSet<Integer> checksumsJaemiissneunMapper = new HashSet<Integer>(Arrays.asList(-166825492, 1401962855, 2137420933, -1062442666));
    private Mapper mapper = new AutoDetectMapper();

    public SMSCartridge(int[] nArray) {
        super(SMSCartridge.ensureMinimumRomSize(nArray, 16384));
        int n;
        if (!this.sgROM && nArray.length <= 49152) {
            this.mapper = new NoMapper();
        }
        if (!this.hasSEGAbranding()) {
            n = this.calcCRC32();
            if (n == -307152825) {
                System.out.println("Super Game 45 mapper detected");
                this.mapper = new SuperGame45Mapper();
            } else if (n == 2094339175) {
                System.out.println("Zemina 4-in-1 mapper detected");
                this.mapper = new Zemina4in1mapper();
            } else if (n == -1852093586) {
                System.out.println("Mega Mode Super Game 30 mapper detected");
                this.mapper = new MegaModeSuperGame30mapper();
            } else if (n == -1059022682) {
                System.out.println("Jiphap mapper detected");
                this.mapper = new JiphapMapper();
            } else if (checksumsHiComNin1mapper.contains(n)) {
                System.out.println("Hi-Com N in 1 mapper detected");
                this.mapper = new HiComNin1mapper();
            } else if (checksumsKoreanSuperGameMapper.contains(n)) {
                System.out.println("Korean Super Game mapper detected");
                this.mapper = new KoreanSuperGameMapper();
            } else if (checksumsKoreanSuperGameMapper2.contains(n)) {
                System.out.println("Korean Super Game mapper 2 detected");
                this.mapper = new KoreanSuperGameMapper2();
            } else if (checksumsKoreanSuperGameMapper3.contains(n)) {
                System.out.println("Korean Super Game mapper 3 detected");
                this.mapper = new KoreanSuperGameMapper3();
            } else if (checksumsJaemiissneunMapper.contains(n)) {
                System.out.println("Jaemiissneun mapper detected");
                this.mapper = new JaemiissneunMapper();
            } else if (nArray.length == 131072 && nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[122880] == 243 && nArray[122881] == 237 && nArray[122882] == 86) {
                this.mapper = new NemesisMapper();
            }
        }
        n = (nArray.length - 1) / 16384;
        while ((n & n + 1) != 0) {
            ++n;
        }
        this.MASK_BANK = n;
        this.reset();
    }

    public SMSCartridge(String string, IPS iPS) throws IOException {
        super(string, iPS);
        this.sgROM = string.endsWith(".sg") || string.endsWith(".sc");
        this.smsMode = string.contains("[S]") || string.toLowerCase().endsWith(".sms");
        this.readRAMfromFile();
        if ((this.rom.length & 0x3FF) == 512) {
            this.rom = Arrays.copyOfRange(this.rom, 512, this.rom.length);
            System.out.println("Header removed");
        }
        this.rom = SMSCartridge.ensureMinimumRomSize(this.rom, 16384);
        if ((this.rom.length & 0x3FFF) != 0) {
            int[] nArray = new int[this.rom.length + (16384 - (this.rom.length & 0x3FFF))];
            Arrays.fill(nArray, 255);
            System.arraycopy(this.rom, 0, nArray, 0, this.rom.length);
            this.rom = nArray;
        }
        if (!this.sgROM && this.rom.length <= 49152) {
            this.mapper = new NoMapper();
        }
        if (!this.hasSEGAbranding()) {
            int n = this.calcCRC32();
            if (n == -307152825) {
                System.out.println("Super Game 45 mapper detected");
                this.mapper = new SuperGame45Mapper();
            } else if (n == 2094339175) {
                System.out.println("Zemina 4-in-1 mapper detected");
                this.mapper = new Zemina4in1mapper();
            } else if (n == -1852093586) {
                System.out.println("Mega Mode Super Game 30 mapper detected");
                this.mapper = new MegaModeSuperGame30mapper();
            } else if (n == -1059022682) {
                System.out.println("Jiphap mapper detected");
                this.mapper = new JiphapMapper();
            } else if (checksumsHiComNin1mapper.contains(n)) {
                System.out.println("Hi-Com N in 1 mapper detected");
                this.mapper = new HiComNin1mapper();
            } else if (checksumsKoreanSuperGameMapper.contains(n)) {
                System.out.println("Korean Super Game mapper detected");
                this.mapper = new KoreanSuperGameMapper();
            } else if (checksumsKoreanSuperGameMapper2.contains(n)) {
                System.out.println("Korean Super Game mapper 2 detected");
                this.mapper = new KoreanSuperGameMapper2();
            } else if (checksumsKoreanSuperGameMapper3.contains(n)) {
                System.out.println("Korean Super Game mapper 3 detected");
                this.mapper = new KoreanSuperGameMapper3();
            } else if (checksumsJaemiissneunMapper.contains(n)) {
                System.out.println("Jaemiissneun mapper detected");
                this.mapper = new JaemiissneunMapper();
            } else if (this.rom.length == 131072 && this.rom[0] == 0 && this.rom[1] == 0 && this.rom[2] == 0 && this.rom[122880] == 243 && this.rom[122881] == 237 && this.rom[122882] == 86) {
                this.mapper = new NemesisMapper();
            }
        }
        int n = (this.rom.length - 1) / 16384;
        while ((n & n + 1) != 0) {
            ++n;
        }
        this.MASK_BANK = n;
        this.reset();
    }

    public String getBranding() {
        String string = "";
        int n = 32752;
        while (n < 32760 && n < this.rom.length) {
            string = String.valueOf(string) + (char)this.rom[n];
            ++n;
        }
        return string;
    }

    public boolean hasCodemastersHeader() {
        if (this.rom.length < 32768 || this.rom[32736] <= 0 || this.rom[32736] > this.rom.length / 16384) {
            return false;
        }
        int n = 32737;
        while (n < 32742) {
            if ((this.rom[n] & 0xF) >= 10 || (this.rom[n] & 0xF0) >= 160) {
                return false;
            }
            ++n;
        }
        n = 32746;
        while (n < 32752) {
            if (this.rom[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasSEGAbranding() {
        return "TMR SEGA".equals(this.getBranding());
    }

    public int getChecksum() {
        return this.rom[32763] << 8 | this.rom[32762];
    }

    public String getProductCode() {
        return String.format("%d%04X", this.rom[32766] >> 4, this.rom[32765] << 8 | this.rom[32764]);
    }

    public int getVersion() {
        return this.rom[32766] & 0xF;
    }

    public int getRegion() {
        return this.rom[Short.MAX_VALUE] >> 4;
    }

    public int getROMsizeID() {
        return this.rom[Short.MAX_VALUE] & 0xF;
    }

    public boolean isSmsMode() {
        return this.smsMode;
    }

    @Override
    public boolean isROMaddress(int n) {
        return this.mapper.isROMaddress(n);
    }

    @Override
    public boolean isSRAMaddress(int n) {
        return this.mapper.isSRAMaddress(n);
    }

    @Override
    public int mapAddress(int n) {
        return this.mapper.mapAddress(n);
    }

    @Override
    public int mapAddress(int n, int n2) {
        return this.mapper.mapAddress(n, n2);
    }

    @Override
    public void setBank0(int n) {
        this.frame0ROMPageNumber = n & this.MASK_BANK;
    }

    @Override
    public void setBank1(int n) {
        this.frame1ROMPageNumber = n & this.MASK_BANK;
    }

    @Override
    public void setBank2(int n) {
        this.frame2ROMPageNumber = n & this.MASK_BANK;
    }

    @Override
    public void setBank3(int n) {
        this.frame3ROMPageNumber = n & this.MASK_BANK;
    }

    @Override
    public void setSRAMenabled(boolean bl) {
        this.ramEnabled = bl;
    }

    @Override
    public void setSRAMbank(int n) {
        this.ramPageNumber = n;
    }

    @Override
    public int getBank0() {
        return this.frame0ROMPageNumber;
    }

    @Override
    public int getBank1() {
        return this.frame1ROMPageNumber;
    }

    @Override
    public int getBank2() {
        return this.frame2ROMPageNumber;
    }

    @Override
    public int getBank3() {
        return this.frame3ROMPageNumber;
    }

    @Override
    public int getBank(int n) {
        return this.mapper.getBank(n);
    }

    @Override
    public void setBank(int n, int n2) {
        if (n < 16384) {
            this.setBank0(n2);
        } else if (n < 32768) {
            this.setBank1(n2);
        } else if (n < 49152) {
            this.setBank2(n2);
        }
    }

    @Override
    public int getBankSize() {
        return this.mapper instanceof KoreanMsxMapper || this.mapper instanceof Total128mapper ? 8192 : 16384;
    }

    @Override
    public boolean isSRAMenabled() {
        return this.ramEnabled;
    }

    @Override
    public int getSRAMbank() {
        return this.ramPageNumber;
    }

    @Override
    public void shutdown() {
        this.writeRAMtoFile();
    }

    public int getMapper() {
        if (this.mapper instanceof NoMapper) {
            return 10;
        }
        if (this.mapper instanceof Total128mapper) {
            return 9;
        }
        if (this.mapper instanceof KoreanMsxMapper) {
            return 8;
        }
        if (this.mapper instanceof DbMapper) {
            return 6;
        }
        if (this.mapper instanceof HiComNin1mapper) {
            return 5;
        }
        if (this.mapper instanceof FourPakAllActionMapper) {
            return 4;
        }
        if (this.mapper instanceof KoreanMapper) {
            return 3;
        }
        if (this.mapper instanceof CodemastersMapper) {
            return 2;
        }
        if (this.mapper instanceof SegaMapper) {
            return 1;
        }
        if (!(this.mapper instanceof AutoDetectMapper)) {
            return 0;
        }
        AutoDetectMapper autoDetectMapper = (AutoDetectMapper)this.mapper;
        return autoDetectMapper.getMapper();
    }

    public String getMapperName() {
        if (this.mapper instanceof AutoDetectMapper) {
            if (((AutoDetectMapper)this.mapper).dahjeeAdapter) {
                return "Dahjee Adapter";
            }
            return "";
        }
        String string = this.mapper.getClass().getSimpleName();
        String string2 = string.substring(0, string.length() - "Mapper".length());
        return String.valueOf(string2) + " Mapper";
    }

    @Override
    public boolean readRAMfromFile(File file) {
        try {
            byte[] byArray = IOUtilities.toByteArray(new FileInputStream(file));
            if (this.ram == null || this.ram.length != byArray.length) {
                this.ram = new int[byArray.length];
            }
            int n = 0;
            while (n < this.ram.length) {
                this.ram[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    protected void writeRAMtoFile() {
        if (!this.ramChanged) {
            return;
        }
        if (this.ramFilename != null) {
            try {
                File file = this.makeRAMfile();
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[this.ram.length];
                int n = 0;
                while (n < byArray.length) {
                    byArray[n] = (byte)this.ram[n];
                    ++n;
                }
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.ramChanged = false;
    }

    @Override
    public boolean hasSRAM() {
        return this.ram != null && this.ram.length > 0;
    }

    @Override
    public int[] getSRAM() {
        return this.ram;
    }

    @Override
    public void reset() {
        this.writeRAMtoFile();
        this.ramEnabled = false;
        this.ramWriteProtect = false;
        this.mapper.reset();
    }

    @Override
    public int readByte(int n, int n2) {
        if (this.cheatHandler != null) {
            int n3;
            int n4;
            if (n == 56) {
                this.cheatHandler.applyCheats();
            }
            if ((n4 = this.cheatHandler.readCheat(n, n3 = this.mapper.readByte(n))) >= 0) {
                return n4;
            }
            return n3;
        }
        return this.mapper.readByte(n);
    }

    @Override
    public void processWrite(int n, int n2, int n3) {
        this.mapper.processWrite(n, n2);
    }

    public boolean isSEGAmapper() {
        return this.getMapper() == 1;
    }

    public boolean isDBMapper() {
        return this.getMapper() == 6;
    }

    public int getDBbankShift() {
        if (this.mapper instanceof DbMapper) {
            return ((DbMapper)this.mapper).getBankShift();
        }
        return 0;
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getFrame3ROMPageNumber() {
                return SMSCartridge.this.frame3ROMPageNumber;
            }

            @Override
            public int getFrame2ROMPageNumber() {
                return SMSCartridge.this.frame2ROMPageNumber;
            }

            @Override
            public int getFrame1ROMPageNumber() {
                return SMSCartridge.this.frame1ROMPageNumber;
            }

            @Override
            public int getFrame0ROMPageNumber() {
                return SMSCartridge.this.frame0ROMPageNumber;
            }

            @Override
            public int getRamPageNumber() {
                return SMSCartridge.this.ramPageNumber;
            }

            @Override
            public boolean isRamWriteProtect() {
                return SMSCartridge.this.ramWriteProtect;
            }

            @Override
            public boolean isRamEnabled() {
                return SMSCartridge.this.ramEnabled;
            }

            @Override
            public int[] getRAM() {
                return SMSCartridge.this.ram;
            }
        };
    }

    public void setState(State state, boolean bl) {
        this.frame3ROMPageNumber = state.getFrame3ROMPageNumber();
        this.frame2ROMPageNumber = state.getFrame2ROMPageNumber();
        this.frame1ROMPageNumber = state.getFrame1ROMPageNumber();
        this.frame0ROMPageNumber = state.getFrame0ROMPageNumber();
        this.ramPageNumber = state.getRamPageNumber();
        this.ramWriteProtect = state.isRamWriteProtect();
        this.ramEnabled = state.isRamEnabled();
        if (this.ramEnabled) {
            this.enableShutdownHook();
        }
        if (this.ramEnabled && this.ram.length < 16384 * (this.ramPageNumber + 1)) {
            int[] nArray = this.ram;
            this.ram = new int[16384 * (this.ramPageNumber + 1)];
            Arrays.fill(this.ram, 255);
            System.arraycopy(nArray, 0, this.ram, 0, nArray.length);
            if (nArray.length > 0) {
                System.out.println(String.valueOf(nArray.length) + " bytes of RAM copied.");
            }
        }
        if (!bl || this.ramEnabled) {
            System.arraycopy(state.getRAM(), 0, this.ram, 0, Math.min(this.ram.length, state.getRAM().length));
        }
    }

    public class AutoDetectMapper
    implements Mapper {
        private int segaMapperWrites;
        private int dbSequence;
        private boolean dahjeeAdapter;
        private boolean notDahjeeAdapater;

        @Override
        public boolean isROMaddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return !this.dahjeeAdapter || n < 8192;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return !SMSCartridge.this.ramEnabled;
                }
            }
            return false;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return SMSCartridge.this.hasSRAM() && n < 49152 && !this.isROMaddress(n);
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    if (this.dahjeeAdapter && n >= 8192) {
                        return 0;
                    }
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled) {
                        return SMSCartridge.this.ramPageNumber;
                    }
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    if (this.dahjeeAdapter && n >= 8192) {
                        return n & 0x1FFF;
                    }
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled) {
                        return 16384 * SMSCartridge.this.ramPageNumber | n & 0x3FFF;
                    }
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 0: {
                    if (this.dahjeeAdapter && n >= 8192) {
                        return n & 0x1FFF;
                    }
                    return 16384 * n2 | n;
                }
                case 1: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled) {
                        return 16384 * n2 | n & 0x3FFF;
                    }
                    return 16384 * n2 | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            if (SMSCartridge.this.rom.length > 32768) {
                SMSCartridge.this.frame2ROMPageNumber = 2;
            }
            if (SMSCartridge.this.rom.length > 16384) {
                SMSCartridge.this.frame1ROMPageNumber = 1;
            }
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.ramPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    if (this.dahjeeAdapter && n >= 8192) {
                        return SMSCartridge.this.ram[n & 0x1FFF];
                    }
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame0ROMPageNumber | n];
                }
                case 1: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled) {
                        return SMSCartridge.this.ram[16384 * SMSCartridge.this.ramPageNumber | n & 0x3FFF];
                    }
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (SMSCartridge.this.ramEnabled && !SMSCartridge.this.ramWriteProtect && n >= 32768 && n < 49152) {
                SMSCartridge.this.mapper = new SegaMapper();
                if (SMSCartridge.this.ram[SMSCartridge.this.ramPageNumber * 16384 | n & 0x3FFF] != n2) {
                    SMSCartridge.this.ramChanged = true;
                }
                ((SMSCartridge)SMSCartridge.this).ram[((SMSCartridge)SMSCartridge.this).ramPageNumber * 16384 | n & 0x3FFF] = n2;
            }
            if (SMSCartridge.this.sgROM) {
                if (!(this.notDahjeeAdapater || this.dahjeeAdapter || n != 15104 && n != 15157)) {
                    this.notDahjeeAdapater = true;
                }
                if (!this.notDahjeeAdapater && n < 16384 && n >= 8192) {
                    if (SMSCartridge.this.ram.length < 8192) {
                        System.out.println("Dahjee Adapter detected");
                        SMSCartridge.this.ram = new int[8192];
                        this.dahjeeAdapter = true;
                    }
                    ((SMSCartridge)SMSCartridge.this).ram[n & 0x1FFF] = n2;
                    return;
                }
                if (SMSCartridge.this.rom.length > 32768) {
                    return;
                }
                if (!SMSCartridge.this.ramEnabled && n >= 32768 && n < 49152) {
                    System.out.println("SG-1000 RAM Extension detected");
                    SMSCartridge.this.ramEnabled = true;
                    SMSCartridge.this.enableShutdownHook();
                    if (SMSCartridge.this.ram.length < 16384) {
                        SMSCartridge.this.ram = new int[16384];
                        Arrays.fill(SMSCartridge.this.ram, 255);
                    }
                    if (SMSCartridge.this.ram[n & 0x3FFF] != n2) {
                        SMSCartridge.this.ramChanged = true;
                    }
                    ((SMSCartridge)SMSCartridge.this).ram[n & 0x3FFF] = n2;
                }
                return;
            }
            if (n <= 3 && !SMSCartridge.this.hasSEGAbranding() && !SMSCartridge.this.hasCodemastersHeader()) {
                System.out.println("Korean MSX mapper detected");
                SMSCartridge.this.mapper = new KoreanMsxMapper();
            } else if (n == 8192 && n2 == 31 && !SMSCartridge.this.hasCodemastersHeader()) {
                System.out.println("Total 128 mapper detected");
                SMSCartridge.this.mapper = new Total128mapper();
            } else if (n <= 32768 && (n & 0x3FFF) == 0) {
                if (SMSCartridge.this.ramEnabled) {
                    SMSCartridge.this.mapper = new SegaMapper();
                    SMSCartridge.this.mapper.processWrite(n, n2);
                    return;
                }
                switch (n) {
                    case 0: {
                        return;
                    }
                    case 16384: {
                        if (SMSCartridge.this.frame1ROMPageNumber != n2) break;
                        return;
                    }
                    case 32768: {
                        if (SMSCartridge.this.frame2ROMPageNumber != (n2 & SMSCartridge.this.MASK_BANK)) break;
                        return;
                    }
                }
                System.out.println("Codemasters mapper detected");
                SMSCartridge.this.mapper = new CodemastersMapper();
            } else if (this.segaMapperWrites <= 0 && (n == 16382 || n == Short.MAX_VALUE)) {
                System.out.println("4 Pak All Action Mapper detected");
                SMSCartridge.this.mapper = new FourPakAllActionMapper();
            } else if (this.segaMapperWrites <= 0 && !SMSCartridge.this.ramEnabled && n == 40960) {
                System.out.println("Korean mapper detected");
                SMSCartridge.this.mapper = new KoreanMapper();
            } else if (n >= 65532) {
                if (!(++this.segaMapperWrites < 3 || this.segaMapperWrites < 5 && SMSCartridge.this.hasCodemastersHeader())) {
                    SMSCartridge.this.mapper = new SegaMapper();
                }
                switch (n & 3) {
                    case 0: {
                        long l;
                        if (SMSCartridge.this.ramEnabled && (n2 & 8) == 0 && (l = System.currentTimeMillis()) - SMSCartridge.this.lastWriteMillis >= 5000L) {
                            SMSCartridge.this.writeRAMtoFile();
                            SMSCartridge.this.lastWriteMillis = l;
                        }
                        SMSCartridge.this.ramWriteProtect = (n2 & 0x10) != 0;
                        SMSCartridge.this.ramEnabled = (n2 & 8) != 0;
                        if (SMSCartridge.this.ramEnabled) {
                            SMSCartridge.this.enableShutdownHook();
                        }
                        SMSCartridge.this.ramPageNumber = (n2 & 4) >> 2;
                        if (SMSCartridge.this.ramEnabled && SMSCartridge.this.ram.length < 16384 * (SMSCartridge.this.ramPageNumber + 1)) {
                            int[] nArray = SMSCartridge.this.ram;
                            SMSCartridge.this.ram = new int[16384 * (SMSCartridge.this.ramPageNumber + 1)];
                            Arrays.fill(SMSCartridge.this.ram, 255);
                            System.arraycopy(nArray, 0, SMSCartridge.this.ram, 0, nArray.length);
                            if (nArray.length > 0) {
                                System.out.println(String.valueOf(nArray.length) + " bytes of RAM copied.");
                            }
                        }
                        if ((n2 & 0xFFFFFF73) == 0) break;
                        System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
                        --this.segaMapperWrites;
                        break;
                    }
                    case 1: {
                        SMSCartridge.this.frame0ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                        if (SMSCartridge.this.frame0ROMPageNumber != 0) {
                            SMSCartridge.this.mapper = new SegaMapper();
                        } else {
                            --this.segaMapperWrites;
                        }
                        this.dbSequence = this.dbSequence & 0x3C | (n2 & 0xC0) >> 6;
                        break;
                    }
                    case 2: {
                        SMSCartridge.this.frame1ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                        if (SMSCartridge.this.frame1ROMPageNumber > 1) {
                            SMSCartridge.this.mapper = new SegaMapper();
                        }
                        this.dbSequence = this.dbSequence & 0x33 | (n2 & 0xC0) >> 4;
                        break;
                    }
                    case 3: {
                        SMSCartridge.this.frame2ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                        if (SMSCartridge.this.frame2ROMPageNumber > 2) {
                            SMSCartridge.this.mapper = new SegaMapper();
                        }
                        this.dbSequence = this.dbSequence & 0xF | (n2 & 0xC0) >> 2;
                        break;
                    }
                    default: {
                        System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
                    }
                }
                if (this.dbSequence == 45) {
                    System.out.println("DB Mapper detected");
                    SMSCartridge.this.mapper = new DbMapper();
                }
            }
            if (!(SMSCartridge.this.mapper instanceof AutoDetectMapper)) {
                SMSCartridge.this.mapper.processWrite(n, n2);
            }
        }

        public int getMapper() {
            if (this.dahjeeAdapter) {
                return 7;
            }
            return 0;
        }
    }

    public class CodemastersMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return !SMSCartridge.this.ramEnabled || n < 40960;
                }
            }
            return false;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return SMSCartridge.this.hasSRAM() && n < 49152 && !this.isROMaddress(n);
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled && n >= 40960) {
                        return 0;
                    }
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled && n >= 40960) {
                        return n & 0x1FFF;
                    }
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * n2 | n;
                }
                case 1: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled && n >= 40960) {
                        return n & 0x1FFF;
                    }
                    return 16384 * n2 | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            if (SMSCartridge.this.rom.length > 16384) {
                SMSCartridge.this.frame1ROMPageNumber = 1;
            }
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame2ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame0ROMPageNumber | n];
                }
                case 1: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled && n >= 40960) {
                        return SMSCartridge.this.ram[n & 0x1FFF];
                    }
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (SMSCartridge.this.ramEnabled && !SMSCartridge.this.ramWriteProtect && n >= 40960 && n < 49152) {
                if (SMSCartridge.this.ram[n & 0x1FFF] != n2) {
                    SMSCartridge.this.ramChanged = true;
                }
                ((SMSCartridge)SMSCartridge.this).ram[n & 0x1FFF] = n2;
            }
            if (n <= 32768 && (n & 0x3FFF) == 0) {
                switch (n) {
                    case 0: {
                        SMSCartridge.this.frame0ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                        break;
                    }
                    case 16384: {
                        if ((n2 & 0x80) != 0) {
                            SMSCartridge.this.ramEnabled = true;
                            SMSCartridge.this.enableShutdownHook();
                            if (SMSCartridge.this.ram.length >= 8192) break;
                            SMSCartridge.this.ram = new int[8192];
                            Arrays.fill(SMSCartridge.this.ram, 255);
                            break;
                        }
                        SMSCartridge.this.frame1ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.ramEnabled = false;
                        break;
                    }
                    case 32768: {
                        SMSCartridge.this.frame2ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                    }
                }
            }
        }
    }

    public class DbMapper
    implements Mapper {
        private int dbSequence = 45;
        private int bankShift;

        public int getBankShift() {
            return this.bankShift;
        }

        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 16384 * n2 | n & 0x3FFF;
        }

        @Override
        public void reset() {
            if (SMSCartridge.this.rom.length > 32768) {
                SMSCartridge.this.frame2ROMPageNumber = 2;
            }
            if (SMSCartridge.this.rom.length > 16384) {
                SMSCartridge.this.frame1ROMPageNumber = 1;
            }
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.ramPageNumber = 0;
            this.dbSequence = 0;
            this.bankShift = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame0ROMPageNumber | n];
                }
                case 1: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n >= 65532) {
                switch (n & 3) {
                    case 0: {
                        if (this.dbSequence != 45) break;
                        this.bankShift = n2 & 0x3F;
                        SMSCartridge.this.frame0ROMPageNumber = this.bankShift + SMSCartridge.this.frame0ROMPageNumber & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.frame1ROMPageNumber = this.bankShift + SMSCartridge.this.frame1ROMPageNumber & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.frame2ROMPageNumber = this.bankShift + SMSCartridge.this.frame2ROMPageNumber & SMSCartridge.this.MASK_BANK;
                        this.dbSequence = 0;
                        break;
                    }
                    case 1: {
                        SMSCartridge.this.frame0ROMPageNumber = this.bankShift + n2 & SMSCartridge.this.MASK_BANK;
                        this.dbSequence = this.dbSequence & 0x3C | (n2 & 0xC0) >> 6;
                        break;
                    }
                    case 2: {
                        SMSCartridge.this.frame1ROMPageNumber = this.bankShift + n2 & SMSCartridge.this.MASK_BANK;
                        this.dbSequence = this.dbSequence & 0x33 | (n2 & 0xC0) >> 4;
                        break;
                    }
                    case 3: {
                        SMSCartridge.this.frame2ROMPageNumber = this.bankShift + n2 & SMSCartridge.this.MASK_BANK;
                        this.dbSequence = this.dbSequence & 0xF | (n2 & 0xC0) >> 2;
                        break;
                    }
                    default: {
                        System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
                    }
                }
            }
        }
    }

    public class FourPakAllActionMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 16384 * n2 | n & 0x3FFF;
        }

        @Override
        public void reset() {
            if (SMSCartridge.this.rom.length > 32768) {
                SMSCartridge.this.frame2ROMPageNumber = 2;
            }
            if (SMSCartridge.this.rom.length > 16384) {
                SMSCartridge.this.frame1ROMPageNumber = 1;
            }
            SMSCartridge.this.frame0ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame0ROMPageNumber | n];
                }
                case 1: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n == 16382) {
                SMSCartridge.this.frame0ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
            } else if (n == Short.MAX_VALUE) {
                SMSCartridge.this.frame1ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
            } else if (n == 49151) {
                SMSCartridge.this.frame2ROMPageNumber = (SMSCartridge.this.frame0ROMPageNumber & 0x30) + n2 & SMSCartridge.this.MASK_BANK;
            }
        }
    }

    public class HiComNin1mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 16384 * n2 | n & 0x3FFF;
        }

        @Override
        public void reset() {
            if (SMSCartridge.this.rom.length > 16384) {
                SMSCartridge.this.frame1ROMPageNumber = 1;
            }
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame2ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame0ROMPageNumber | n];
                }
                case 1: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n == 65535) {
                SMSCartridge.this.frame0ROMPageNumber = n2 * 2 & SMSCartridge.this.MASK_BANK;
                SMSCartridge.this.frame1ROMPageNumber = n2 * 2 + 1 & SMSCartridge.this.MASK_BANK;
            }
        }
    }

    public class JaemiissneunMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n & 0x3FFF;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 1: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * n2 | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 1;
            SMSCartridge.this.frame2ROMPageNumber = 1;
        }

        @Override
        public int readByte(int n) {
            return SMSCartridge.this.rom[this.mapAddress(n)];
        }

        @Override
        public void processWrite(int n, int n2) {
            if ((n |= 0x4010) == 65525) {
                SMSCartridge.this.frame0ROMPageNumber = n2 << 1 & SMSCartridge.this.MASK_BANK;
                SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + 1;
                SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + 1;
            } else if (n == 65534) {
                SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + (n2 & 0x1F) & SMSCartridge.this.MASK_BANK;
            } else if (n == 65535) {
                SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + (n2 & 0x1F) & SMSCartridge.this.MASK_BANK;
            }
        }
    }

    public class JiphapMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n & 0x3FFF;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 1: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * n2 | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 1;
            SMSCartridge.this.frame2ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            return SMSCartridge.this.rom[this.mapAddress(n)];
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n == 65530) {
                SMSCartridge.this.frame0ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + 1;
                SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber;
            } else if (n == 65534) {
                SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + (n2 & 0xF) & SMSCartridge.this.MASK_BANK;
            } else if (n == 65535) {
                SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + (n2 & 0xF) & SMSCartridge.this.MASK_BANK;
            }
        }
    }

    public class KoreanMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 16384 * n2 | n & 0x3FFF;
        }

        @Override
        public void reset() {
            if (SMSCartridge.this.rom.length > 32768) {
                SMSCartridge.this.frame2ROMPageNumber = 2;
            }
            if (SMSCartridge.this.rom.length > 16384) {
                SMSCartridge.this.frame1ROMPageNumber = 1;
            }
            SMSCartridge.this.frame0ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame0ROMPageNumber | n];
                }
                case 1: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n == 40960) {
                SMSCartridge.this.frame2ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
            }
        }
    }

    public class KoreanMsxMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return 0;
                }
                case 2: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 3: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 4: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
                case 5: {
                    return SMSCartridge.this.frame3ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return n;
                }
                case 2: {
                    return 8192 * SMSCartridge.this.frame0ROMPageNumber | n & 0x1FFF;
                }
                case 3: {
                    return 8192 * SMSCartridge.this.frame1ROMPageNumber | n & 0x1FFF;
                }
                case 4: {
                    return 8192 * SMSCartridge.this.frame2ROMPageNumber | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * SMSCartridge.this.frame3ROMPageNumber | n & 0x1FFF;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 8192 * n2 | n & 0x1FFF;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 0;
            SMSCartridge.this.frame2ROMPageNumber = 0;
            SMSCartridge.this.frame3ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return SMSCartridge.this.rom[n];
                }
                case 2: {
                    return SMSCartridge.this.rom[8192 * SMSCartridge.this.frame0ROMPageNumber | n & 0x1FFF];
                }
                case 3: {
                    return SMSCartridge.this.rom[8192 * SMSCartridge.this.frame1ROMPageNumber | n & 0x1FFF];
                }
                case 4: {
                    return SMSCartridge.this.rom[8192 * SMSCartridge.this.frame2ROMPageNumber | n & 0x1FFF];
                }
                case 5: {
                    return SMSCartridge.this.rom[8192 * SMSCartridge.this.frame3ROMPageNumber | n & 0x1FFF];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            switch (n) {
                case 0: {
                    SMSCartridge.this.frame2ROMPageNumber = n2;
                    break;
                }
                case 1: {
                    SMSCartridge.this.frame3ROMPageNumber = n2;
                    break;
                }
                case 2: {
                    SMSCartridge.this.frame0ROMPageNumber = n2;
                    break;
                }
                case 3: {
                    SMSCartridge.this.frame1ROMPageNumber = n2;
                }
            }
        }
    }

    public class KoreanSuperGameMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 2: 
                case 3: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 4: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
                case 5: {
                    return SMSCartridge.this.frame3ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 2: 
                case 3: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 4: {
                    return 8192 * SMSCartridge.this.frame2ROMPageNumber | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * SMSCartridge.this.frame3ROMPageNumber | n & 0x1FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return 16384 * n2 | n;
                }
                case 2: 
                case 3: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 4: {
                    return 8192 * n2 | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * n2 | n & 0x1FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 1;
            SMSCartridge.this.frame2ROMPageNumber = -1;
            SMSCartridge.this.frame3ROMPageNumber = -1;
        }

        @Override
        public int readByte(int n) {
            if ((n = this.mapAddress(n)) < 0) {
                return -1;
            }
            return SMSCartridge.this.rom[n];
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n == 49148) {
                switch (n2 >> 6) {
                    case 0: {
                        SMSCartridge.this.frame0ROMPageNumber = n2 & 0x3E & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + 1;
                        SMSCartridge.this.frame2ROMPageNumber = -1;
                        SMSCartridge.this.frame3ROMPageNumber = -1;
                        break;
                    }
                    case 1: {
                        SMSCartridge.this.frame0ROMPageNumber = n2 & 0x3F & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber;
                        SMSCartridge.this.frame2ROMPageNumber = -1;
                        SMSCartridge.this.frame3ROMPageNumber = -1;
                        break;
                    }
                    case 2: {
                        SMSCartridge.this.frame0ROMPageNumber = 0x20 & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.frame1ROMPageNumber = n2 & 0x3F & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.frame2ROMPageNumber = -1;
                        SMSCartridge.this.frame3ROMPageNumber = -1;
                        break;
                    }
                    case 3: {
                        SMSCartridge.this.frame0ROMPageNumber = 0x20 & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.frame1ROMPageNumber = n2 & 0x3F & SMSCartridge.this.MASK_BANK;
                        SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame1ROMPageNumber * 2 + 1;
                        SMSCartridge.this.frame3ROMPageNumber = SMSCartridge.this.frame1ROMPageNumber * 2;
                    }
                }
            }
        }
    }

    public class KoreanSuperGameMapper2
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 0: {
                    return 0;
                }
                case 1: 
                case 5: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 3: {
                    return SMSCartridge.this.frame3ROMPageNumber;
                }
                case 4: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 0: {
                    return n & 0x1FFF;
                }
                case 1: 
                case 5: {
                    return 8192 * SMSCartridge.this.frame2ROMPageNumber | n & 0x1FFF;
                }
                case 2: {
                    return 8192 * SMSCartridge.this.frame1ROMPageNumber | n & 0x1FFF;
                }
                case 3: {
                    return 8192 * SMSCartridge.this.frame3ROMPageNumber | n & 0x1FFF;
                }
                case 4: {
                    return 8192 * SMSCartridge.this.frame0ROMPageNumber | n & 0x1FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 13) {
                case 0: {
                    return n & 0x1FFF;
                }
                case 1: 
                case 5: {
                    return 8192 * n2 | n & 0x1FFF;
                }
                case 2: {
                    return 8192 * n2 | n & 0x1FFF;
                }
                case 3: {
                    return 8192 * n2 | n & 0x1FFF;
                }
                case 4: {
                    return 8192 * n2 | n & 0x1FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 0;
            SMSCartridge.this.frame2ROMPageNumber = 0;
            SMSCartridge.this.frame3ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            return SMSCartridge.this.rom[this.mapAddress(n)];
        }

        @Override
        public void processWrite(int n, int n2) {
            switch (n >> 8) {
                case 0: {
                    SMSCartridge.this.frame0ROMPageNumber = n2 & (SMSCartridge.this.MASK_BANK << 1 | 1);
                    break;
                }
                case 1: {
                    SMSCartridge.this.frame1ROMPageNumber = n2 & (SMSCartridge.this.MASK_BANK << 1 | 1);
                    break;
                }
                case 2: {
                    SMSCartridge.this.frame2ROMPageNumber = n2 & (SMSCartridge.this.MASK_BANK << 1 | 1);
                    break;
                }
                case 3: {
                    SMSCartridge.this.frame3ROMPageNumber = n2 & (SMSCartridge.this.MASK_BANK << 1 | 1);
                }
            }
        }
    }

    public class KoreanSuperGameMapper3
    implements Mapper {
        private int mapper;
        private int mode;

        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 2: 
                case 3: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 4: 
                case 5: {
                    return SMSCartridge.this.frame2ROMPageNumber * 2 + ((this.mode >> 5 == 4 ? n >> 13 ^ 1 : n >> 13) - 4);
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n & 0x3FFF;
                }
                case 2: 
                case 3: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 4: 
                case 5: {
                    return 8192 * (SMSCartridge.this.frame2ROMPageNumber * 2 + ((this.mode >> 5 == 4 ? n >> 13 ^ 1 : n >> 13) - 4)) | n & 0x1FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 2: 
                case 3: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 4: 
                case 5: {
                    return 8192 * (n2 * 2 + ((this.mode >> 5 == 4 ? n >> 13 ^ 1 : n >> 13) - 4)) | n & 0x1FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            this.mapper = 0;
            this.mode = 0;
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 0;
            SMSCartridge.this.frame2ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            return SMSCartridge.this.rom[this.mapAddress(n)];
        }

        @Override
        public void processWrite(int n, int n2) {
            if ((n & 0xBFFF) == 49139 || (n & 0xBFFF) == 49148) {
                if ((n & 0xF) == 3) {
                    this.mapper = n2;
                } else if ((n & 0xF) == 12) {
                    this.mode = n2;
                }
            }
            int n3 = (this.mode & 0x10) * 4 + (this.mapper & 0x3E);
            switch (this.mode >> 5) {
                case 0: {
                    SMSCartridge.this.frame0ROMPageNumber = n3 + (this.mapper & 1) & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber;
                    SMSCartridge.this.frame2ROMPageNumber = 0xFF & SMSCartridge.this.MASK_BANK;
                    break;
                }
                case 1: {
                    SMSCartridge.this.frame0ROMPageNumber = n3 & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + 1;
                    SMSCartridge.this.frame2ROMPageNumber = 0xFF & SMSCartridge.this.MASK_BANK;
                    break;
                }
                case 2: {
                    SMSCartridge.this.frame0ROMPageNumber = 0x40 & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame1ROMPageNumber = n3 + (this.mapper & 1) & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame2ROMPageNumber = 0xFF & SMSCartridge.this.MASK_BANK;
                    break;
                }
                case 3: {
                    SMSCartridge.this.frame0ROMPageNumber = 0x40 & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame1ROMPageNumber = 0xFE & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame2ROMPageNumber = n3 + (this.mapper & 1) & SMSCartridge.this.MASK_BANK;
                    break;
                }
                case 4: {
                    SMSCartridge.this.frame0ROMPageNumber = 0x40 & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame1ROMPageNumber = n3 + (this.mapper & 1) & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame1ROMPageNumber;
                    break;
                }
                case 5: {
                    SMSCartridge.this.frame0ROMPageNumber = 0x40 & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame1ROMPageNumber = n3 + (this.mapper & 1) & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame1ROMPageNumber ^ 1;
                }
            }
        }
    }

    public class MegaModeSuperGame30mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n & 0x3FFF;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 1: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * n2 | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 1;
            SMSCartridge.this.frame2ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            return SMSCartridge.this.rom[this.mapAddress(n)];
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n == 65520) {
                SMSCartridge.this.frame0ROMPageNumber = n2 << 1 & SMSCartridge.this.MASK_BANK;
                SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + 1;
                SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber;
            } else if (n == 65534) {
                SMSCartridge.this.frame1ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + (n2 & 0xF) & SMSCartridge.this.MASK_BANK;
            } else if (n == 65535) {
                SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame0ROMPageNumber + (n2 & 0xF) & SMSCartridge.this.MASK_BANK;
            }
        }
    }

    public class NemesisMapper
    extends KoreanMsxMapper {
        @Override
        public int mapAddress(int n) {
            if (n < 8192) {
                return 0x1E000 | n & 0x1FFF;
            }
            return super.mapAddress(n);
        }

        @Override
        public int readByte(int n) {
            if (n < 8192) {
                return SMSCartridge.this.rom[0x1E000 | n & 0x1FFF];
            }
            return super.readByte(n);
        }
    }

    public class NoMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            return (SMSCartridge.this.rom.length & SMSCartridge.this.rom.length - 1) != 0 ? n & 0xFFFF : n & SMSCartridge.this.rom.length - 1;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return this.mapAddress(n);
        }

        @Override
        public void reset() {
            if (SMSCartridge.this.rom.length > 32768) {
                SMSCartridge.this.frame2ROMPageNumber = 2;
            }
            if (SMSCartridge.this.rom.length > 16384) {
                SMSCartridge.this.frame1ROMPageNumber = 1;
            }
        }

        @Override
        public int readByte(int n) {
            return SMSCartridge.this.rom[this.mapAddress(n)];
        }

        @Override
        public void processWrite(int n, int n2) {
        }
    }

    public class SegaMapper
    implements Mapper {
        private boolean slot0unprotected;

        @Override
        public boolean isROMaddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return !SMSCartridge.this.ramEnabled;
                }
            }
            return false;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return SMSCartridge.this.hasSRAM() && n < 49152 && !this.isROMaddress(n);
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    if (n < 1024 && !this.slot0unprotected) {
                        return 0;
                    }
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled) {
                        return SMSCartridge.this.ramPageNumber;
                    }
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    if (n < 1024 && !this.slot0unprotected) {
                        return n;
                    }
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled) {
                        return 16384 * SMSCartridge.this.ramPageNumber | n & 0x3FFF;
                    }
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 0: {
                    if (n < 1024 && !this.slot0unprotected) {
                        return n;
                    }
                    return 16384 * n2 | n;
                }
                case 1: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled) {
                        return 16384 * n2 | n & 0x3FFF;
                    }
                    return 16384 * n2 | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            if (SMSCartridge.this.rom.length > 32768) {
                SMSCartridge.this.frame2ROMPageNumber = 2;
            }
            if (SMSCartridge.this.rom.length > 16384) {
                SMSCartridge.this.frame1ROMPageNumber = 1;
            }
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.ramPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    if (n < 1024 && !this.slot0unprotected) {
                        return SMSCartridge.this.rom[n];
                    }
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame0ROMPageNumber | n];
                }
                case 1: {
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    if (SMSCartridge.this.ramEnabled) {
                        return SMSCartridge.this.ram[16384 * SMSCartridge.this.ramPageNumber | n & 0x3FFF];
                    }
                    return SMSCartridge.this.rom[16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (!this.slot0unprotected && n == 32768 && n2 == SMSCartridge.this.frame2ROMPageNumber) {
                this.slot0unprotected = true;
            }
            if (SMSCartridge.this.ramEnabled && !SMSCartridge.this.ramWriteProtect && n >= 32768 && n < 49152) {
                if (SMSCartridge.this.ram[SMSCartridge.this.ramPageNumber * 16384 | n & 0x3FFF] != n2) {
                    SMSCartridge.this.ramChanged = true;
                }
                ((SMSCartridge)SMSCartridge.this).ram[((SMSCartridge)SMSCartridge.this).ramPageNumber * 16384 | n & 0x3FFF] = n2;
            }
            if (n >= 65532) {
                switch (n & 3) {
                    case 0: {
                        long l;
                        if (SMSCartridge.this.ramEnabled && (n2 & 8) == 0 && (l = System.currentTimeMillis()) - SMSCartridge.this.lastWriteMillis >= 5000L) {
                            SMSCartridge.this.writeRAMtoFile();
                            SMSCartridge.this.lastWriteMillis = l;
                        }
                        SMSCartridge.this.ramWriteProtect = (n2 & 0x10) != 0;
                        SMSCartridge.this.ramEnabled = (n2 & 8) != 0;
                        if (SMSCartridge.this.ramEnabled) {
                            SMSCartridge.this.enableShutdownHook();
                        }
                        SMSCartridge.this.ramPageNumber = (n2 & 4) >> 2;
                        if (SMSCartridge.this.ramEnabled && SMSCartridge.this.ram.length < 16384 * (SMSCartridge.this.ramPageNumber + 1)) {
                            int[] nArray = SMSCartridge.this.ram;
                            SMSCartridge.this.ram = new int[16384 * (SMSCartridge.this.ramPageNumber + 1)];
                            Arrays.fill(SMSCartridge.this.ram, 255);
                            System.arraycopy(nArray, 0, SMSCartridge.this.ram, 0, nArray.length);
                            if (nArray.length > 0) {
                                System.out.println(String.valueOf(nArray.length) + " bytes of RAM copied.");
                            }
                        }
                        if ((n2 & 0xFFFFFF73) == 0) break;
                        System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
                        break;
                    }
                    case 1: {
                        SMSCartridge.this.frame0ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                        break;
                    }
                    case 2: {
                        SMSCartridge.this.frame1ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                        break;
                    }
                    case 3: {
                        SMSCartridge.this.frame2ROMPageNumber = n2 & SMSCartridge.this.MASK_BANK;
                        break;
                    }
                    default: {
                        System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
                    }
                }
            }
        }
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getFrame3ROMPageNumber();

        public int getFrame2ROMPageNumber();

        public int getFrame1ROMPageNumber();

        public int getFrame0ROMPageNumber();

        public int getRamPageNumber();

        public boolean isRamWriteProtect();

        public boolean isRamEnabled();

        public int[] getRAM();
    }

    private static class StateClone
    implements State {
        private int frame3ROMPageNumber;
        private int frame2ROMPageNumber;
        private int frame1ROMPageNumber;
        private int frame0ROMPageNumber;
        private int ramPageNumber;
        private boolean ramWriteProtect;
        private boolean ramEnabled;
        private final int[] ram;

        public StateClone(State state) {
            this.ram = new int[state.getRAM().length];
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            this.frame3ROMPageNumber = state.getFrame3ROMPageNumber();
            this.frame2ROMPageNumber = state.getFrame2ROMPageNumber();
            this.frame1ROMPageNumber = state.getFrame1ROMPageNumber();
            this.frame0ROMPageNumber = state.getFrame0ROMPageNumber();
            this.ramPageNumber = state.getRamPageNumber();
            this.ramWriteProtect = state.isRamWriteProtect();
            this.ramEnabled = state.isRamEnabled();
            System.arraycopy(state.getRAM(), 0, this.ram, 0, this.ram.length);
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getFrame3ROMPageNumber() {
            return this.frame3ROMPageNumber;
        }

        @Override
        public int getFrame2ROMPageNumber() {
            return this.frame2ROMPageNumber;
        }

        @Override
        public int getFrame1ROMPageNumber() {
            return this.frame1ROMPageNumber;
        }

        @Override
        public int getFrame0ROMPageNumber() {
            return this.frame0ROMPageNumber;
        }

        @Override
        public int getRamPageNumber() {
            return this.ramPageNumber;
        }

        @Override
        public boolean isRamWriteProtect() {
            return this.ramWriteProtect;
        }

        @Override
        public boolean isRamEnabled() {
            return this.ramEnabled;
        }

        @Override
        public int[] getRAM() {
            return this.ram;
        }
    }

    public class SuperGame45Mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return SMSCartridge.this.frame0ROMPageNumber;
                }
                case 2: 
                case 3: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 4: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
                case 5: {
                    return SMSCartridge.this.frame3ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return 16384 * SMSCartridge.this.frame0ROMPageNumber | n;
                }
                case 2: 
                case 3: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 4: {
                    return 8192 * SMSCartridge.this.frame2ROMPageNumber | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * SMSCartridge.this.frame3ROMPageNumber | n & 0x1FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return 16384 * n2 | n;
                }
                case 2: 
                case 3: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 4: {
                    return 8192 * n2 | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * n2 | n & 0x1FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 1;
            SMSCartridge.this.frame2ROMPageNumber = -1;
            SMSCartridge.this.frame3ROMPageNumber = -1;
        }

        @Override
        public int readByte(int n) {
            if ((n = this.mapAddress(n)) < 0) {
                return -1;
            }
            return SMSCartridge.this.rom[n];
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n == 65534) {
                SMSCartridge.this.frame0ROMPageNumber = ((n2 & 0x40) == 64 ? n2 & 0x1E : 0) & SMSCartridge.this.MASK_BANK;
                SMSCartridge.this.frame1ROMPageNumber = ((n2 & 0x40) == 64 ? n2 & 0x1E | 1 : n2 & 0x1F) & SMSCartridge.this.MASK_BANK;
                SMSCartridge.this.frame2ROMPageNumber = (n2 & 0x60) == 32 ? (n2 & 0x1F) * 2 + 1 & (SMSCartridge.this.MASK_BANK << 1 | 1) : -1;
                SMSCartridge.this.frame3ROMPageNumber = (n2 & 0x60) == 32 ? (n2 & 0x1F) * 2 & (SMSCartridge.this.MASK_BANK << 1 | 1) : -1;
            }
        }
    }

    public class Total128mapper
    implements Mapper {
        private int pageNumber;

        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return 0;
                }
                case 1: 
                case 2: {
                    return this.pageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return n & 0x3FFF;
                }
                case 1: 
                case 2: {
                    return 8192 * this.pageNumber | n - 16384;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 0: {
                    return n & 0x3FFF;
                }
                case 1: 
                case 2: {
                    return 8192 * n2 | n - 16384;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            this.pageNumber = 96;
            SMSCartridge.this.frame1ROMPageNumber = this.pageNumber / 2 & SMSCartridge.this.MASK_BANK;
            SMSCartridge.this.frame2ROMPageNumber = this.pageNumber / 2 + 1 & SMSCartridge.this.MASK_BANK;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    return SMSCartridge.this.rom[n];
                }
                case 1: 
                case 2: {
                    return SMSCartridge.this.rom[8192 * this.pageNumber | n - 16384];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            int n3 = n & 0xE000;
            if (n3 == 8192) {
                this.pageNumber = n2 ^ 0x1F;
                SMSCartridge.this.frame1ROMPageNumber = this.pageNumber / 2 & SMSCartridge.this.MASK_BANK;
                SMSCartridge.this.frame2ROMPageNumber = this.pageNumber / 2 + 1 & SMSCartridge.this.MASK_BANK;
            } else if (n3 == 24576) {
                this.pageNumber = n2;
                SMSCartridge.this.frame1ROMPageNumber = this.pageNumber / 2 & SMSCartridge.this.MASK_BANK;
                SMSCartridge.this.frame2ROMPageNumber = this.pageNumber / 2 + 1 & SMSCartridge.this.MASK_BANK;
            }
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }

    public class Zemina4in1mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 1: {
                    return SMSCartridge.this.frame1ROMPageNumber;
                }
                case 2: {
                    return SMSCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 1: {
                    return 16384 * SMSCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * SMSCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 1: {
                    return 16384 * n2 | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * n2 | n & 0x3FFF;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            SMSCartridge.this.frame0ROMPageNumber = 0;
            SMSCartridge.this.frame1ROMPageNumber = 1;
            SMSCartridge.this.frame2ROMPageNumber = 1;
        }

        @Override
        public int readByte(int n) {
            return SMSCartridge.this.rom[this.mapAddress(n)];
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n == 0) {
                if ((n2 & 0xF0) == 240) {
                    SMSCartridge.this.frame1ROMPageNumber = 1;
                    SMSCartridge.this.frame2ROMPageNumber = 1;
                } else {
                    SMSCartridge.this.frame1ROMPageNumber = ((n2 ^ 0xF0) & 0xF0) >> 3 & SMSCartridge.this.MASK_BANK;
                    SMSCartridge.this.frame2ROMPageNumber = SMSCartridge.this.frame1ROMPageNumber + 1;
                }
            }
        }
    }
}

