/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Timer;

public class FileChangeWatcher {
    private final File file;
    long lastModified;
    long size;
    private Timer timer;

    public FileChangeWatcher(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null.");
        }
        this.file = file;
    }

    public void startWatching(int n, final ActionListener actionListener) {
        if (actionListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.timer != null) {
            throw new IllegalStateException("Already watching.");
        }
        this.lastModified = this.file.lastModified();
        this.size = this.file.length();
        this.timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = FileChangeWatcher.this.getFile();
                long l = file.lastModified();
                long l2 = file.length();
                if ((System.currentTimeMillis() - l) / 1000L > 0L && (FileChangeWatcher.this.size != l2 || FileChangeWatcher.this.lastModified != l)) {
                    actionListener.actionPerformed(actionEvent);
                    FileChangeWatcher.this.size = l2;
                    FileChangeWatcher.this.lastModified = l;
                }
            }
        });
        this.timer.start();
    }

    public void stopWatching() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public File getFile() {
        return this.file;
    }
}

