/*
 * Decompiled with CFR 0.152.
 */
package cheats;

import cheats.Cheat;
import cheats.CheatModel;
import cheats.CheatModelListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractListCheatModel
implements CheatModel {
    private final List<Cheat> cheats = new ArrayList<Cheat>();
    private final List<CheatModelListener> listeners = new ArrayList<CheatModelListener>();

    @Override
    public int getCheatCount() {
        return this.cheats.size();
    }

    @Override
    public Cheat getCheat(int n) {
        return this.cheats.get(n);
    }

    @Override
    public void addCheat(Cheat cheat) {
        this.cheats.add(cheat);
        this.fireCheatAdded(cheat);
    }

    @Override
    public void removeCheat(int n) {
        this.setActive(this.cheats.remove(n), false);
        this.fireCheatRemoved(n);
    }

    @Override
    public void setName(Cheat cheat, String string) {
        int n = this.cheats.indexOf(cheat);
        Cheat cheat2 = AbstractListCheatModel.createCheat(cheat.getAddress(), cheat.getValue(), cheat.getCompare(), cheat.getDomain(), string, cheat.getSize(), cheat.getDisplayType(), cheat.isBigEndian(), cheat.getComparator());
        this.cheats.set(n, cheat2);
        if (this.isActive(cheat)) {
            this.setActive(cheat, false);
            this.setActive(cheat2, true);
        }
        this.fireCheatChanged(n);
    }

    @Override
    public void setAddress(Cheat cheat, int n) {
        int n2 = this.cheats.indexOf(cheat);
        Cheat cheat2 = AbstractListCheatModel.createCheat(n, cheat.getValue(), cheat.getCompare(), cheat.getDomain(), cheat.getName(), cheat.getSize(), cheat.getDisplayType(), cheat.isBigEndian(), cheat.getComparator());
        this.cheats.set(n2, cheat2);
        if (this.isActive(cheat)) {
            this.setActive(cheat, false);
            this.setActive(cheat2, true);
        }
        this.fireCheatChanged(n2);
    }

    @Override
    public void setValue(Cheat cheat, int n) {
        int n2 = this.cheats.indexOf(cheat);
        Cheat cheat2 = AbstractListCheatModel.createCheat(cheat.getAddress(), n, cheat.getCompare(), cheat.getDomain(), cheat.getName(), cheat.getSize(), cheat.getDisplayType(), cheat.isBigEndian(), cheat.getComparator());
        this.cheats.set(n2, cheat2);
        if (this.isActive(cheat)) {
            this.setActive(cheat, false);
            this.setActive(cheat2, true);
        }
        this.fireCheatChanged(n2);
    }

    @Override
    public void setCompare(Cheat cheat, int n) {
        int n2 = this.cheats.indexOf(cheat);
        Cheat cheat2 = AbstractListCheatModel.createCheat(cheat.getAddress(), cheat.getValue(), n, cheat.getDomain(), cheat.getName(), cheat.getSize(), cheat.getDisplayType(), cheat.isBigEndian(), cheat.getComparator());
        this.cheats.set(n2, cheat2);
        if (this.isActive(cheat)) {
            this.setActive(cheat, false);
            this.setActive(cheat2, true);
        }
        this.fireCheatChanged(n2);
    }

    @Override
    public void setComparator(Cheat cheat, Cheat.Comparator comparator) {
        int n = this.cheats.indexOf(cheat);
        Cheat cheat2 = AbstractListCheatModel.createCheat(cheat.getAddress(), cheat.getValue(), cheat.getCompare(), cheat.getDomain(), cheat.getName(), cheat.getSize(), cheat.getDisplayType(), cheat.isBigEndian(), comparator);
        this.cheats.set(n, cheat2);
        if (this.isActive(cheat)) {
            this.setActive(cheat, false);
            this.setActive(cheat2, true);
        }
        this.fireCheatChanged(n);
    }

    private static Cheat createCheat(final int n, final int n2, final int n3, final String string, final String string2, final int n4, final String string3, final boolean bl, final Cheat.Comparator comparator) {
        return new Cheat(){

            @Override
            public boolean isBigEndian() {
                return bl;
            }

            @Override
            public int getValue() {
                return n2;
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public String getName() {
                return string2;
            }

            @Override
            public String getDomain() {
                return string;
            }

            @Override
            public String getDisplayType() {
                return string3;
            }

            @Override
            public int getCompare() {
                return n3;
            }

            @Override
            public Cheat.Comparator getComparator() {
                return comparator;
            }

            @Override
            public int getAddress() {
                return n;
            }
        };
    }

    protected final void fireCheatAdded(Cheat cheat) {
        for (CheatModelListener cheatModelListener : this.listeners) {
            cheatModelListener.cheatAdded(cheat);
        }
    }

    protected final void fireCheatRemoved(int n) {
        for (CheatModelListener cheatModelListener : this.listeners) {
            cheatModelListener.cheatRemoved(n);
        }
    }

    protected final void fireCheatChanged(int n) {
        for (CheatModelListener cheatModelListener : this.listeners) {
            cheatModelListener.cheatChanged(n);
        }
    }

    @Override
    public void addCheatModelListener(CheatModelListener cheatModelListener) {
        if (!this.listeners.contains(cheatModelListener)) {
            this.listeners.add(cheatModelListener);
        }
    }

    @Override
    public void removeCheatModelListener(CheatModelListener cheatModelListener) {
        this.listeners.remove(cheatModelListener);
    }
}

