/*
 * Decompiled with CFR 0.152.
 */
package assembler;

import assembler.MemoryMap;

public abstract class AbstractMemoryMap
implements MemoryMap {
    @Override
    public int resolveAddress(int n, int n2) {
        if (n >= this.getNumberOfSlots()) {
            return n2;
        }
        return n2 - this.getSlotAddress(n >= 0 ? n : this.getDefaultSlot());
    }

    @Override
    public int findSlotForAddress(int n) {
        int n2 = this.getNumberOfSlots();
        int n3 = 0;
        while (n3 < n2) {
            if (n >= this.getSlotAddress(n3) && n < this.getSlotAddress(n3) + this.getSlotSize(n3)) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    protected abstract int getSlotAddress(int var1);

    protected abstract int getSlotSize(int var1);

    protected abstract int getDefaultSlot();

    protected abstract int getNumberOfSlots();
}

