/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.OutputListener;
import components.cartridge.Cartridge;
import components.input.InputDevice;
import events.EventModel;
import java.io.File;
import system.DebuggableSystem;
import system.EmulatableSystem;
import system.RamRomMap;
import system.SystemEventListener;
import util.list.IntList;

public abstract class DebuggableSystemDecorator
implements DebuggableSystem {
    private final DebuggableSystem decoratedSystem;
    private DebuggableSystem system;

    public DebuggableSystemDecorator(DebuggableSystem debuggableSystem) {
        this.system = debuggableSystem;
        this.decoratedSystem = DebuggableSystemDecorator.getDecoratedSystem(debuggableSystem);
    }

    public void setSystem(DebuggableSystem debuggableSystem) {
        if (debuggableSystem == this) {
            throw new IllegalArgumentException("A decorator must not decorate itself");
        }
        if (DebuggableSystemDecorator.getDecoratedSystem(debuggableSystem) != this.getDecoratedSystem()) {
            throw new IllegalArgumentException("The decorated system must not be changed.");
        }
        this.system = debuggableSystem;
    }

    public final DebuggableSystem getDecoratedSystem() {
        return this.decoratedSystem;
    }

    private static DebuggableSystem getDecoratedSystem(DebuggableSystem debuggableSystem) {
        while (debuggableSystem instanceof DebuggableSystemDecorator) {
            DebuggableSystemDecorator debuggableSystemDecorator = (DebuggableSystemDecorator)debuggableSystem;
            debuggableSystem = debuggableSystemDecorator.getSystem();
        }
        return debuggableSystem;
    }

    public DebuggableSystem getSystem() {
        return this.system;
    }

    @Override
    public EmulatableSystem.State getState() {
        return this.system.getState();
    }

    @Override
    public EmulatableSystem.State createMutableState() {
        return this.system.createMutableState();
    }

    @Override
    public final int getMemoryLength() {
        return this.decoratedSystem.getMemoryLength();
    }

    @Override
    public int readByte(int n, int n2) {
        return this.system.readByte(n, n2);
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        this.system.writeByte(n, n2, n3);
    }

    @Override
    public void insertCartridge(Cartridge cartridge) {
        this.system.insertCartridge(cartridge);
    }

    @Override
    public void ejectCartridge() {
        this.system.ejectCartridge();
    }

    @Override
    public void shutdown() {
        this.system.shutdown();
    }

    @Override
    public void setState(EmulatableSystem.State state, boolean bl, boolean bl2) {
        this.system.setState(state, bl, bl2);
    }

    @Override
    public void loadSAV(File file) {
        this.system.loadSAV(file);
    }

    @Override
    public void setInputState(long l) {
        this.system.setInputState(l);
    }

    @Override
    public void reset() {
        this.system.reset();
    }

    @Override
    public int execute(int n) {
        return this.system.execute(n);
    }

    @Override
    public int executeOnce(int n) {
        return this.system.executeOnce(n);
    }

    @Override
    public final int getCyclesPerSecond() {
        return this.decoratedSystem.getCyclesPerSecond();
    }

    @Override
    public final int getCyclesPerFrame() {
        return this.decoratedSystem.getCyclesPerFrame();
    }

    @Override
    public void uninitializeMemory(int n) {
        this.system.uninitializeMemory(n);
    }

    @Override
    public final int[] getRAM() {
        return this.decoratedSystem.getRAM();
    }

    @Override
    public final int[] getSRAM() {
        return this.decoratedSystem.getSRAM();
    }

    @Override
    public final int[] getVRAM() {
        return this.decoratedSystem.getVRAM();
    }

    @Override
    public final int getNumberOfPaletteBytes() {
        return this.decoratedSystem.getNumberOfPaletteBytes();
    }

    @Override
    public final int getNumberOfPaletteEntries() {
        return this.decoratedSystem.getNumberOfPaletteEntries();
    }

    @Override
    public int getPaletteByte(int n) {
        return this.system.getPaletteByte(n);
    }

    @Override
    public void setPaletteByte(int n, int n2) {
        this.system.setPaletteByte(n, n2);
    }

    @Override
    public final String getPaletteName(int n) {
        return this.decoratedSystem.getPaletteName(n);
    }

    @Override
    public final String[] getRegisterNames() {
        return this.decoratedSystem.getRegisterNames();
    }

    @Override
    public final int indexOfPC() {
        return this.decoratedSystem.indexOfPC();
    }

    @Override
    public final int getNumberOfAdditionalMemoryLocations() {
        return this.decoratedSystem.getNumberOfAdditionalMemoryLocations();
    }

    @Override
    public final String getAdditionalMemoryLocationName(int n) {
        return this.decoratedSystem.getAdditionalMemoryLocationName(n);
    }

    @Override
    public final int getAdditionalMemoryLocationLength(int n) {
        return this.decoratedSystem.getAdditionalMemoryLocationLength(n);
    }

    @Override
    public final String getAdditionalMemoryLocationAt(int n) {
        return this.decoratedSystem.getAdditionalMemoryLocationAt(n);
    }

    @Override
    public final boolean isAdditionalMemoryLocationMemoryMapped(String string) {
        return this.decoratedSystem.isAdditionalMemoryLocationMemoryMapped(string);
    }

    @Override
    public final int[] getErrorCodes() {
        return this.decoratedSystem.getErrorCodes();
    }

    @Override
    public int getRegisterValue(int n) {
        return this.system.getRegisterValue(n);
    }

    @Override
    public int getVRAMaddress() {
        return this.system.getVRAMaddress();
    }

    @Override
    public final boolean isAdditionalRegister(int n) {
        return this.decoratedSystem.isAdditionalRegister(n);
    }

    @Override
    public final String getAdditionalRegisterName(int n) {
        return this.decoratedSystem.getAdditionalRegisterName(n);
    }

    @Override
    public int getAdditionalRegisterValue(int n) {
        return this.system.getAdditionalRegisterValue(n);
    }

    @Override
    public final int getAdditionalRegisterSize(int n) {
        return this.decoratedSystem.getAdditionalRegisterSize(n);
    }

    @Override
    public final boolean hasSRAM() {
        return this.decoratedSystem.hasSRAM();
    }

    @Override
    public final boolean isROMaddress(int n) {
        return this.decoratedSystem.isROMaddress(n);
    }

    @Override
    public final boolean isROMaddress(int n, boolean bl) {
        return this.decoratedSystem.isROMaddress(n, bl);
    }

    @Override
    public final boolean isRAMaddress(int n) {
        return this.decoratedSystem.isRAMaddress(n);
    }

    @Override
    public final boolean isRAMaddress(int n, boolean bl) {
        return this.decoratedSystem.isRAMaddress(n, bl);
    }

    @Override
    public final boolean isSRAMaddress(int n) {
        return this.decoratedSystem.isSRAMaddress(n);
    }

    @Override
    public final boolean isVRAMaddress(int n) {
        return this.decoratedSystem.isVRAMaddress(n);
    }

    @Override
    public final int mapAddress(int n) {
        return this.decoratedSystem.mapAddress(n);
    }

    @Override
    public final int mapAddress(int n, int n2) {
        return this.decoratedSystem.mapAddress(n, n2);
    }

    @Override
    public final int mapAddress(int n, int n2, boolean bl) {
        return this.decoratedSystem.mapAddress(n, n2, bl);
    }

    @Override
    public final int mapVirtualAddress(int n) {
        return this.decoratedSystem.mapVirtualAddress(n);
    }

    @Override
    public void plugInInputDevice(int n, InputDevice inputDevice) {
        this.system.plugInInputDevice(n, inputDevice);
    }

    @Override
    public void setAddress(int n, int n2) {
        this.system.setAddress(n, n2);
    }

    @Override
    public final int getPrevPC() {
        return this.decoratedSystem.getPrevPC();
    }

    @Override
    public final int getPC() {
        return this.decoratedSystem.getPC();
    }

    @Override
    public final int getSP() {
        return this.decoratedSystem.getSP();
    }

    @Override
    public final int getStackPointer() {
        return this.decoratedSystem.getStackPointer();
    }

    @Override
    public final int getVirtualAddress() {
        return this.decoratedSystem.getVirtualAddress();
    }

    @Override
    public final int getROMsize() {
        return this.decoratedSystem.getROMsize();
    }

    @Override
    public final int toVirtualAddress(int n) {
        return this.decoratedSystem.toVirtualAddress(n);
    }

    @Override
    public final int peekByte(int n) {
        return this.decoratedSystem.peekByte(n);
    }

    @Override
    public final int getByte(int n) {
        return this.decoratedSystem.getByte(n);
    }

    @Override
    public final int getByte(int n, int n2) {
        return this.decoratedSystem.getByte(n, n2);
    }

    @Override
    public final void pokeByte(int n, int n2) {
        this.decoratedSystem.pokeByte(n, n2);
    }

    @Override
    public final void setByte(int n, int n2, int n3) {
        this.decoratedSystem.setByte(n, n2, n3);
    }

    @Override
    public final String getMemoryName(int n) {
        return this.decoratedSystem.getMemoryName(n);
    }

    @Override
    public void setMemoryAt(int n, int[] nArray) {
        this.system.setMemoryAt(n, nArray);
    }

    public int[] getRegValues() {
        int[] nArray = new int[this.getRegisterNames().length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getRegisterValue(n);
            ++n;
        }
        return nArray;
    }

    @Override
    public void setRegValue(int n, int n2) {
        this.system.setRegValue(n, n2);
    }

    @Override
    public void setAdditionalRegValue(int n, int n2) {
        this.system.setAdditionalRegValue(n, n2);
    }

    @Override
    public final String getAdditionalRegisterDescription(int n) {
        return this.decoratedSystem.getAdditionalRegisterDescription(n);
    }

    @Override
    public final String[] getFlagNames() {
        return this.decoratedSystem.getFlagNames();
    }

    @Override
    public boolean isFlagSet(int n) {
        return this.system.isFlagSet(n);
    }

    @Override
    public void setFlagSet(int n, boolean bl) {
        this.system.setFlagSet(n, bl);
    }

    @Override
    public final int getNumberOfPorts() {
        return this.decoratedSystem.getNumberOfPorts();
    }

    @Override
    public final int getPortExtension() {
        return this.decoratedSystem.getPortExtension();
    }

    @Override
    public final int getRAMlength() {
        return this.decoratedSystem.getRAMlength();
    }

    @Override
    public final IntList getAllRAMaddresses() {
        return this.decoratedSystem.getAllRAMaddresses();
    }

    @Override
    public final int getStackStart() {
        return this.decoratedSystem.getStackStart();
    }

    @Override
    public final int getStackLength() {
        return this.decoratedSystem.getStackLength();
    }

    @Override
    public int getRAMvalue(int n) {
        return this.system.getRAMvalue(n);
    }

    @Override
    public int getBank0() {
        return this.system.getBank0();
    }

    @Override
    public int getBank1() {
        return this.system.getBank1();
    }

    @Override
    public int getBank2() {
        return this.system.getBank2();
    }

    @Override
    public int getBank3() {
        return this.system.getBank3();
    }

    @Override
    public int getBank(int n) {
        return this.system.getBank(n);
    }

    @Override
    public void setBank(int n, int n2) {
        this.system.setBank(n, n2);
    }

    @Override
    public int getRomBankSize() {
        return this.decoratedSystem.getRomBankSize();
    }

    @Override
    public boolean isSRAMenabled() {
        return this.system.isSRAMenabled();
    }

    @Override
    public void setSRAMenabled(boolean bl) {
        this.system.setSRAMenabled(bl);
    }

    @Override
    public int getSRAMbank() {
        return this.system.getSRAMbank();
    }

    @Override
    public int getScanline() {
        return this.system.getScanline();
    }

    @Override
    public boolean isHalted() {
        return this.system.isHalted();
    }

    @Override
    public boolean isVBlank() {
        return this.system.isVBlank();
    }

    @Override
    public boolean isInterruptsEnabled() {
        return this.system.isInterruptsEnabled();
    }

    @Override
    public void setInterruptsEnabled(boolean bl) {
        this.system.setInterruptsEnabled(bl);
    }

    @Override
    public void syncLazyState() {
        this.system.syncLazyState();
    }

    @Override
    public boolean isInterruptAddress(int n) {
        return this.system.isInterruptAddress(n);
    }

    @Override
    public boolean isConditionMet(int n) {
        return this.system.isConditionMet(n);
    }

    @Override
    public boolean canStepOver() {
        return this.system.canStepOver();
    }

    @Override
    public boolean isCartridgeEnabled() {
        return this.system.isCartridgeEnabled();
    }

    @Override
    public boolean isBiosEnabled() {
        return this.system.isBiosEnabled();
    }

    @Override
    public final RamRomMap getRamRomMap() {
        return this.decoratedSystem.getRamRomMap();
    }

    @Override
    public final EventModel createEventModel() {
        return this.decoratedSystem.createEventModel();
    }

    @Override
    public final void addDebugEvent(DebuggableSystem.DebugEvent debugEvent, String string) {
        this.decoratedSystem.addDebugEvent(debugEvent, string);
    }

    @Override
    public void setDebugger(DebuggableSystem debuggableSystem) {
        this.system.setDebugger(debuggableSystem);
    }

    @Override
    public final String cpuAddressToString(int n) {
        return this.decoratedSystem.cpuAddressToString(n);
    }

    @Override
    public final String romAddressToString(int n) {
        return this.decoratedSystem.romAddressToString(n);
    }

    @Override
    public final String ramAddressToString(int n) {
        return this.decoratedSystem.ramAddressToString(n);
    }

    @Override
    public final String vramAddressToString(int n) {
        return this.decoratedSystem.vramAddressToString(n);
    }

    @Override
    public final String sramAddressToString(int n) {
        return this.decoratedSystem.sramAddressToString(n);
    }

    @Override
    public final String palAddressToString(int n) {
        return this.decoratedSystem.palAddressToString(n);
    }

    @Override
    public final String virtualAddressToString(int n) {
        return this.decoratedSystem.virtualAddressToString(n);
    }

    @Override
    public final boolean isRamInitialized(int n) {
        return this.decoratedSystem.isRamInitialized(n);
    }

    @Override
    public final boolean isVramInitialized(int n) {
        return this.decoratedSystem.isVramInitialized(n);
    }

    @Override
    public final boolean isSramInitialized(int n) {
        return this.decoratedSystem.isSramInitialized(n);
    }

    @Override
    public final boolean isCpuMemoryInitialized(int n) {
        return this.decoratedSystem.isCpuMemoryInitialized(n);
    }

    @Override
    public final boolean isPaletteInitialized(int n) {
        return this.decoratedSystem.isPaletteInitialized(n);
    }

    @Override
    public final void addSystemEventListener(SystemEventListener systemEventListener) {
        this.decoratedSystem.addSystemEventListener(systemEventListener);
    }

    @Override
    public final void removeSystemEventListener(SystemEventListener systemEventListener) {
        this.decoratedSystem.removeSystemEventListener(systemEventListener);
    }

    @Override
    public final void addPortListener(OutputListener outputListener) {
        this.decoratedSystem.addPortListener(outputListener);
    }

    @Override
    public final void removePortListener(OutputListener outputListener) {
        this.decoratedSystem.removePortListener(outputListener);
    }
}

