/*
 * Decompiled with CFR 0.152.
 */
package expressions;

public enum BinaryOperator {
    LOGICAL_AND("&&", true),
    LOGICAL_OR("||", true),
    LOGICAL_XOR("^^", true),
    PRODUCT("*", false),
    HIGH_PRODUCT("**", false),
    DIVISION("/", false),
    MODULUS1("#", false),
    MODULUS2("%", false),
    ADDITION("+", false),
    SUBTRACTION("-", false),
    SHIFT_LEFT("<<", false),
    SHIFT_RIGHT(">>", false),
    LESS_THAN("<", true),
    GREATER_THAN(">", true),
    LESS_OR_EQUAL("<=", true),
    GREATER_OR_EQUAL(">=", true),
    EQUALS1("=", true),
    EQUALS2("==", true),
    NOT_EQUALS("!=", true),
    NOT_EQUALS2("<>", true),
    BINARY_AND("&", false),
    BINARY_XOR1("^", false),
    BINARY_XOR2("~", false),
    BINARY_OR("|", false),
    READ_LOCATION("@@", false),
    MAP_BANK(":", false);

    private String symbol;
    private boolean isBoolean;

    private BinaryOperator(String string2, boolean bl) {
        this.symbol = string2;
        this.isBoolean = bl;
    }

    public boolean isBoolean() {
        return this.isBoolean;
    }

    public static BinaryOperator from(String string) {
        BinaryOperator[] binaryOperatorArray = BinaryOperator.values();
        int n = binaryOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryOperator binaryOperator = binaryOperatorArray[n2];
            if (binaryOperator.symbol.equals(string)) {
                return binaryOperator;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown binary operator: " + string);
    }

    public String toString() {
        return this.symbol;
    }
}

