/*
 * Decompiled with CFR 0.152.
 */
package evscript;

import assembler.SourceMap;
import disassembler.Symbols;
import evscript.EvscriptDebugInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import system.DebuggableSystem;

public class EvscriptSourceMap
implements SourceMap {
    private static final File NO_FILE = new File("FILE_DOES_NOT_EXIST");
    private final SourceMap parentSourceMap;
    private final BitSet unmapped = new BitSet();
    private final BitSet next = new BitSet();
    private final Map<Integer, EvscriptDebugInfo.DebugLine> debugLines = new HashMap<Integer, EvscriptDebugInfo.DebugLine>();
    private final DebuggableSystem system;
    private final File rootFolder;
    private final Map<String, File> files = new HashMap<String, File>();
    private final List<String> errors = new ArrayList<String>();

    public EvscriptSourceMap(EvscriptDebugInfo evscriptDebugInfo, SourceMap sourceMap, Map<String, List<Symbols.Symbol>> map, DebuggableSystem debuggableSystem, File file) {
        Symbols.Symbol symbol;
        for (EvscriptDebugInfo.ScriptHandler object : evscriptDebugInfo.getScriptHandlers()) {
            symbol = this.resolveSymbol(object.getStart(), "Script Handler Start symbol", map);
            Symbols.Symbol symbol2 = this.resolveSymbol(object.getNext(), "Script Handler Next symbol", map);
            Symbols.Symbol symbol3 = this.resolveSymbol(object.getEnd(), "Script Handler End symbol", map);
            if (symbol == null || symbol2 == null || symbol3 == null) continue;
            this.next.set(debuggableSystem.mapAddress(symbol2.getAddress(), symbol2.getBank(), true));
            this.unmapped.set(debuggableSystem.mapAddress(symbol.getAddress(), symbol.getBank(), true), debuggableSystem.mapAddress(symbol3.getAddress(), symbol3.getBank(), true));
        }
        if (this.next.cardinality() <= 0) {
            throw new IllegalArgumentException("Failed to load evscript debug file:\n" + this.getErrors());
        }
        for (EvscriptDebugInfo.DebugLine debugLine : evscriptDebugInfo.getDebugLines()) {
            symbol = this.resolveSymbol(debugLine.getLabel(), "Debug Line symbol", map);
            if (symbol == null) continue;
            this.debugLines.put(debuggableSystem.mapAddress(symbol.getAddress(), symbol.getBank(), true), debugLine);
        }
        this.parentSourceMap = sourceMap;
        this.system = debuggableSystem;
        this.rootFolder = file;
    }

    private Symbols.Symbol resolveSymbol(String string, String string2, Map<String, List<Symbols.Symbol>> map) {
        List<Symbols.Symbol> list = map.get(string);
        if (list == null) {
            this.errors.add(String.valueOf(string2) + " '" + string + "' is undefined.");
            return null;
        }
        if (list.size() != 1) {
            this.errors.add(String.valueOf(string2) + " '" + string + "' is ambiguous.");
            return null;
        }
        return list.get(0);
    }

    public String getErrors() {
        if (this.errors.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.errors) {
            stringBuilder.append(string).append('\n');
        }
        return stringBuilder.toString();
    }

    public EvscriptDebugInfo.DebugLine getDebugLine(int n) {
        EvscriptDebugInfo.DebugLine debugLine;
        if (n >= 0 && this.next.get(n) && (debugLine = this.debugLines.get(this.system.getRegisterValue(2))) != null) {
            return debugLine;
        }
        return null;
    }

    private File findFile(String string) {
        File file = this.files.get(string);
        if (file != null) {
            return file != NO_FILE ? file : null;
        }
        file = EvscriptSourceMap.findFile(this.rootFolder, string);
        this.files.put(string, file != null ? file : NO_FILE);
        return file;
    }

    private static File findFile(File file, String string) {
        File file2 = new File(file, string);
        if (file2.exists()) {
            return file2;
        }
        if (file.getParentFile() != null) {
            return EvscriptSourceMap.findFile(file.getParentFile(), string);
        }
        return null;
    }

    @Override
    public int getLineNumberROM(int n) {
        EvscriptDebugInfo.DebugLine debugLine = this.getDebugLine(n);
        if (debugLine != null) {
            return debugLine.getLineNumber() - 1;
        }
        if (!this.unmapped.get(n)) {
            return this.parentSourceMap.getLineNumberROM(n);
        }
        return -1;
    }

    @Override
    public File getFileROM(int n) {
        EvscriptDebugInfo.DebugLine debugLine = this.getDebugLine(n);
        if (debugLine != null) {
            return this.findFile(debugLine.getFilename());
        }
        if (n < 0 || !this.unmapped.get(n)) {
            return this.parentSourceMap.getFileROM(n);
        }
        return null;
    }

    @Override
    public int getAddressROM(File file, int n) {
        if (!file.getName().toLowerCase().endsWith(".evs")) {
            return this.parentSourceMap.getAddressROM(file, n);
        }
        for (EvscriptDebugInfo.DebugLine debugLine : this.debugLines.values()) {
            if (n != debugLine.getLineNumber() - 1 || !file.getName().equals(new File(debugLine.getFilename()).getName())) continue;
            return this.next.nextSetBit(0);
        }
        return -1;
    }
}

