/*
 * Decompiled with CFR 0.152.
 */
package assembler;

import assembler.Z80Instruction;
import assembler.Z80SourceLine;
import java.io.File;

public abstract class AbstractZ80SourceLine
implements Z80SourceLine {
    private final int address;
    private final int size;
    private final int lineNumber;
    private final File file;
    private final String line;
    private final Z80Instruction instruction;
    private final int[] bytePrefix;
    private static final int[] NO_BYTE_PREFIX = new int[0];

    protected AbstractZ80SourceLine(int n, int n2, int n3, File file, CharSequence charSequence, Z80Instruction z80Instruction, int[] nArray) {
        if (n >= 0 && n2 < 0) {
            throw new IllegalArgumentException("size must be positive but was " + n2 + " for line " + charSequence);
        }
        this.address = n;
        this.size = n2;
        this.lineNumber = n3;
        this.file = file;
        this.line = charSequence != null ? charSequence.toString() : null;
        this.instruction = z80Instruction;
        this.bytePrefix = nArray == null ? NO_BYTE_PREFIX : nArray;
    }

    protected static int[] getBytePrefixForInstruction(Z80Instruction z80Instruction) {
        if (z80Instruction.getPrefix() > 0) {
            return new int[]{z80Instruction.getPrefix(), z80Instruction.getOpCode()};
        }
        if (z80Instruction.getOpCode() >= 256) {
            return new int[]{z80Instruction.getOpCode() >> 8, z80Instruction.getOpCode() & 0xFF};
        }
        return new int[]{z80Instruction.getOpCode()};
    }

    protected String getLine() {
        return this.line;
    }

    protected int[] getBytePrefix() {
        return this.bytePrefix;
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Z80Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    public int getFirstByte() {
        if (this.bytePrefix.length <= 0) {
            return -1;
        }
        return this.bytePrefix[0];
    }

    @Override
    public int getPrefixLength() {
        return this.bytePrefix.length;
    }

    @Override
    public int[] getBytes() {
        if (this.instruction != null) {
            int n;
            int[] nArray = new int[this.instruction.getSize()];
            int n2 = 0;
            int n3 = this.instruction.getPrefix();
            if (n3 > 0) {
                nArray[n2++] = n3;
            }
            if ((n = this.instruction.getOpCode()) >= 256) {
                nArray[n2++] = n >> 8;
                if (this.instruction.hasDisplacement()) {
                    nArray[n2++] = this.instruction.getDisplacement() & 0xFF;
                }
            }
            nArray[n2++] = n & 0xFF;
            if (n < 256 && this.instruction.hasDisplacement()) {
                nArray[n2++] = this.instruction.getDisplacement() & 0xFF;
            }
            if (this.instruction.hasArg()) {
                int n4 = this.instruction.getArg();
                int n5 = this.instruction.getArgSize() - 1;
                while (n5 >= 0) {
                    nArray[n2++] = n4 & 0xFF;
                    n4 >>= 8;
                    --n5;
                }
            }
            return nArray;
        }
        return this.bytePrefix;
    }

    @Override
    public boolean startsWith(int[] nArray, int n) {
        if (n < 0 || n + this.getSize() > nArray.length) {
            return false;
        }
        if (this.instruction == null && this.bytePrefix.length == 1 && this.bytePrefix[0] >= 0) {
            int n2 = 0;
            while (n2 < this.getSize()) {
                if (nArray[n + n2] != this.bytePrefix[0]) {
                    return false;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.bytePrefix.length) {
                if (this.bytePrefix[n3] >= 0 && nArray[n + n3] != this.bytePrefix[n3]) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    @Override
    public boolean matchesPrefix(Z80SourceLine z80SourceLine) {
        if (!(z80SourceLine instanceof AbstractZ80SourceLine)) {
            return z80SourceLine.matchesPrefix(this);
        }
        AbstractZ80SourceLine abstractZ80SourceLine = (AbstractZ80SourceLine)z80SourceLine;
        int n = Math.min(this.bytePrefix.length, abstractZ80SourceLine.bytePrefix.length);
        int n2 = 0;
        while (n2 < n) {
            if (this.bytePrefix[n2] != abstractZ80SourceLine.bytePrefix[n2]) {
                return false;
            }
            ++n2;
        }
        return n != 0;
    }

    public String toString() {
        return this.line;
    }
}

