/*
 * Decompiled with CFR 0.152.
 */
package dap;

import dap.DebugAdapter;
import dap.DebugAdapterProtocol;
import dap.messages.events.BreakpointEvent;
import dap.messages.events.StoppedEvent;
import dap.types.Breakpoint;
import dap.types.SteppingGranularity;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractDebugAdapter
implements DebugAdapter {
    protected static final Breakpoint[] NO_BREAKPOINTS = new Breakpoint[0];
    private final DebugAdapterProtocol protocol;

    protected AbstractDebugAdapter(int n) throws IOException {
        this.protocol = new DebugAdapterProtocol(n, this);
    }

    protected void close() {
        this.protocol.close();
    }

    protected void sendInitializedEvent() {
        this.protocol.sendInitializedEvent();
    }

    protected void sendStoppedEvent(StoppedEvent.Reason reason, int n) {
        this.protocol.sendStoppedEvent(reason, n);
    }

    protected void sendStoppedEvent(StoppedEvent.Reason reason, String string, int n, String string2) {
        this.protocol.sendStoppedEvent(reason, string, n, string2);
    }

    protected void sendStoppedEvent(StoppedEvent.Reason reason, String string, int n, Boolean bl, String string2, Boolean bl2) {
        this.protocol.sendStoppedEvent(reason, string, n, bl, string2, bl2);
    }

    protected void sendContinuedEvent(int n) {
        this.protocol.sendContinuedEvent(n);
    }

    protected void sendContinuedEvent(int n, Boolean bl) {
        this.protocol.sendContinuedEvent(n, bl);
    }

    protected void sendBreakpointEvent(BreakpointEvent.Reason reason, Breakpoint breakpoint) {
        this.protocol.sendBreakpointEvent(reason, breakpoint);
    }

    protected void sendTerminatedEvent() {
        this.protocol.sendTerminatedEvent();
    }

    protected void sendOutputEvent(String string) {
        this.protocol.sendOutputEvent(string);
    }

    protected void sendCapabilitiesEvent(Map<String, Object> map) {
        this.protocol.sendCapabilitiesEvent(map);
    }

    protected boolean isConnected() {
        return this.protocol.isConnected();
    }

    @Override
    public void disconnect(boolean bl, Boolean bl2) {
    }

    @Override
    public Breakpoint[] setExceptionBreakpoints(String[] stringArray) {
        return NO_BREAKPOINTS;
    }

    @Override
    public void stepBack(int n, SteppingGranularity steppingGranularity) {
    }

    @Override
    public void reverseContinue(int n) {
    }

    @Override
    public void restartFrame(int n) {
    }

    @Override
    public void goTo(int n, int n2) {
    }
}

