/*
 * Decompiled with CFR 0.152.
 */
package treetable;

import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import treetable.TreeTableModel;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();
    private static final int CHANGED = 0;
    private static final int INSERTED = 1;
    private static final int REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;

    public AbstractTreeTableModel(Object object) {
        this.root = object;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    private void fireTreeNode(final int n, Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        final Object[] objectArray3 = this.listenerList.getListenerList();
        final TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n2 = objectArray3.length - 2;
                while (n2 >= 0) {
                    if (objectArray3[n2] == TreeModelListener.class) {
                        switch (n) {
                            case 0: {
                                ((TreeModelListener)objectArray3[n2 + 1]).treeNodesChanged(treeModelEvent);
                                break;
                            }
                            case 1: {
                                ((TreeModelListener)objectArray3[n2 + 1]).treeNodesInserted(treeModelEvent);
                                break;
                            }
                            case 2: {
                                ((TreeModelListener)objectArray3[n2 + 1]).treeNodesRemoved(treeModelEvent);
                                break;
                            }
                            case 3: {
                                ((TreeModelListener)objectArray3[n2 + 1]).treeStructureChanged(treeModelEvent);
                            }
                        }
                    }
                    n2 -= 2;
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        this.fireTreeNode(0, object, objectArray, nArray, objectArray2);
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        this.fireTreeNode(1, object, objectArray, nArray, objectArray2);
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        this.fireTreeNode(2, object, objectArray, nArray, objectArray2);
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        this.fireTreeNode(3, object, objectArray, nArray, objectArray2);
    }
}

