/*
 * Decompiled with CFR 0.152.
 */
package sstates.gameboy;

import components.cartridge.GBCartridge;
import components.cpu.LR35902;
import components.sound.GBSoundController;
import components.video.GBLCDController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import platform.Emulicious;
import sstates.gameboy.BESSSaveState;
import sstates.gameboy.GBSaveState;
import system.GameBoy;
import system.GameBoyColor;

public class BGBSaveState
extends GBSaveState {
    private static final String BGB_SIGNATURE = "BGB1.0";
    private static final boolean PRINT_UNSUPPORTED_BLOCKS = false;
    private static final int[] LCD_MODE_CYCLES = new int[]{204, 456, 80, 172};
    private static final int CYCLES_PER_LINE = LCD_MODE_CYCLES[1];
    private static final short BESS_VERSION_MAJOR = 1;
    private static final short BESS_VERSION_MINOR = 1;
    private static final String BESS_MODEL_IDENTIFIER_DMG = "GDC ";
    private static final String BESS_MODEL_IDENTIFIER_GBC = "CCE ";
    private static final String BESS_MODEL_IDENTIFIER_SGB = "S   ";
    private byte[] md5;
    protected File romFile;
    private String version;
    protected boolean gbcMode;
    protected boolean gbaMode;
    protected boolean gbchw;
    protected boolean sgbMode;
    protected boolean sgbBootValues;
    protected int af;
    protected int bc;
    protected int de;
    protected int hl;
    protected int pc;
    protected int sp;
    protected boolean ime;
    protected boolean ima;
    protected boolean halted;
    protected boolean stopped;
    protected boolean stopNoBlank;
    protected boolean prevIme;
    protected int lastOpCode;
    protected int clkOpc2;
    protected int clkOpc;
    protected int memTimeReg;
    protected int rjoy;
    protected int sb;
    protected int sc;
    protected int linkStatus;
    protected int div;
    protected int tima;
    protected int tma;
    protected int tac;
    protected int _if;
    protected int ie;
    protected int lcdc;
    protected int stat;
    protected int scy;
    protected int scx;
    protected int ly;
    protected int lyc;
    protected int winy;
    protected int winx;
    protected int dma;
    protected int oamDmaLeft;
    protected int divider;
    protected long totalClks;
    protected int vidTime;
    protected int iLines;
    protected int vidStatus;
    protected int lcdPos;
    protected boolean lcdInt;
    protected boolean delayedLcdInt;
    protected int vidInAcc;
    protected int spriteDuration;
    protected int spriteDuration2;
    protected boolean cpuQuirk;
    protected int[] oam;
    protected int[] hram;
    protected int bgp;
    protected int obp0;
    protected int obp1;
    protected int key1;
    protected int vbk;
    protected int hdma1;
    protected int hdma2;
    protected int hdma3;
    protected int hdma4;
    protected int hdma5;
    protected int ir;
    protected int bcps;
    protected int ocps;
    protected int svbk;
    protected int[] cpal;
    protected boolean dmgBootRomPal;
    protected int[] wram;
    protected int[] vram;
    protected boolean[] wramInitialized;
    protected boolean[] hramInitialized;
    protected boolean oddMode;
    protected int speedSwitchLeft;
    protected boolean hadBootrom;
    protected int readEolQuirkCount;
    protected boolean speedSwitchLastWasHalt;
    protected int regFF72;
    protected int regFF73;
    protected int regFF74;
    protected int regFF75;
    protected int[] s_st1;
    protected int[] s_st2;
    protected int[] s_ch1;
    protected int[] ch3regs;
    protected int[] ch3wave;
    protected int ch3StartTs;
    protected int ch3startSample;
    protected boolean ch3firstSample;
    protected int[] s_st3;
    protected int sgb_xfer_startbit;
    protected int sgb_xfer_busy;
    protected int sgb_xfer_offset;
    protected int[] sgb_xfer_data;
    protected int sgb_joypad_max;
    protected int sgb_joypad_current;
    protected int sgb_joypad_done;
    protected int sgb_screen_frozen;
    protected int[] sgb_chardata;
    protected int[] sgb_pct_map;
    protected int[] sgb_pal2;
    protected int[] sgb_pal;
    protected int[] sgb_rampal;
    protected int sgb_trn_status;
    protected int sgb_trn_select;
    protected int sgb_chr_trn_select;
    protected boolean sgb_hasborder;
    protected int[] sgb_atf;
    protected int[] sgb_attr2;
    protected int[] sgb_attr;
    protected boolean sgb_mltreq_done;
    protected int sgb_packet_max;
    protected int sgb_packet_current;
    protected int[] sgb_packet_data;
    protected boolean sgb_hidden;
    protected boolean sgb_initialBorder;
    protected boolean sgb_palset;
    protected int sgb_pct_prn_time;
    protected int rombank0;
    protected boolean mbcbank0_lockedmode;
    protected int mbc3l;
    protected int[] mbc3t;
    protected int[] mbc3tl;
    protected int romb;
    protected int irombank;
    protected int srmb;
    protected int isrambank;
    protected boolean sramEnable;
    protected int[] sram = new int[0];
    protected boolean mbc1mode;
    protected int rtc_interval;
    protected int rtc_fraction;

    protected BGBSaveState() {
    }

    public BGBSaveState(GameBoy gameBoy, File file, byte[] byArray) {
        if (file == null) {
            throw new IllegalArgumentException("romFile must not be null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("md5 must not be null");
        }
        this.romFile = file;
        this.md5 = byArray;
        this.version = "BGB1.5.x";
        this.gbchw = gameBoy instanceof GameBoyColor;
        GameBoy.State state = gameBoy.getState();
        this.setCPUstate(state.getCPUstate());
        this.rjoy = state.getHRam()[0];
        this.sb = state.getHRam()[1];
        this.sc = state.getHRam()[2];
        this.div = state.getHRam()[4];
        this.tima = state.getHRam()[5];
        this.tma = state.getHRam()[6];
        this.tac = state.getHRam()[7];
        this._if = state.getHRam()[15];
        this.ie = state.getHRam()[255];
        this.regFF72 = state.getHRam()[114];
        this.regFF73 = state.getHRam()[115];
        this.regFF74 = state.getHRam()[116];
        this.regFF75 = state.getHRam()[117];
        this.ir = state.getHRam()[86];
        this.wram = new int[state.getWRam().length];
        System.arraycopy(state.getWRam(), 0, this.wram, 0, this.wram.length);
        this.rjoy = state.getHRam()[0];
        this.divider = state.getCounter() >> 1;
        this.hram = new int[127];
        this.hramInitialized = new boolean[state.getHRamInitialized().length];
        System.arraycopy(state.getHRamInitialized(), 0, this.hramInitialized, 0, this.hramInitialized.length);
        System.arraycopy(state.getHRam(), 128, this.hram, 0, this.hram.length);
        this.setLCDstate(state.getLCDstate());
        this.ch3regs = new int[state.getSoundState().getWavePatternRAM().length];
        System.arraycopy(state.getHRam(), 48, this.ch3regs, 0, this.ch3regs.length);
        this.setSoundState(state.getSoundState());
        this.setCartridgeState(state.getCartridgeState());
        this.svbk = 255;
        this.key1 = 255;
        if (gameBoy instanceof GameBoyColor) {
            boolean bl = this.gbcMode = !state.isDmgMode();
            if (this.gbcMode) {
                this.svbk = state.getRegSVBK();
                int n = this.key1 = state.isDoubleSpeed() ? 254 : 126;
                if (state.isDoubleSpeed()) {
                    this.divider >>= 1;
                }
            } else {
                this.svbk = 1;
                this.wram = Arrays.copyOf(this.wram, 8192);
                this.vram = Arrays.copyOf(this.vram, 8192);
                this.dmgBootRomPal = true;
            }
        }
        this.totalClks = this.divider;
        this.stopped = state.isStopped();
        this.wramInitialized = new boolean[state.getWRamInitialized().length];
        System.arraycopy(state.getWRamInitialized(), 0, this.wramInitialized, 0, this.wramInitialized.length);
    }

    private void setCPUstate(LR35902.State state) {
        this.pc = state.getRegPC();
        this.af = state.getRegAF();
        this.bc = state.getRegBC();
        this.de = state.getRegDE();
        this.hl = state.getRegHL();
        this.sp = state.getRegSP();
        this.ime = state.isFlagIME();
        this.halted = state.isHalted();
    }

    private void setLCDstate(GBLCDController.State state) {
        this.vram = new int[state.getVram().length];
        System.arraycopy(state.getVram(), 0, this.vram, 0, this.vram.length);
        this.winy = state.getRegWY();
        this.winx = state.getRegWX();
        this.stat = state.getRegSTAT();
        this.scy = state.getRegSCY();
        this.scx = state.getRegSCX();
        this.obp1 = state.getRegOBP1();
        this.obp0 = state.getRegOBP0();
        this.lyc = state.getRegLYC();
        this.ly = state.getRegLY();
        this.lcdc = state.getRegLCDC();
        this.dma = state.getRegDMA();
        this.bgp = state.getRegBGP();
        this.lcdInt = true;
        this.vidTime = state.getTimer() / 2;
        this.lcdPos = (this.ly * CYCLES_PER_LINE + (LCD_MODE_CYCLES[this.stat & 3] - state.getTimer())) / 2;
        try {
            int n;
            long l;
            this.vbk = state.getRegVBK();
            this.hdma5 = state.getRegHDMA5();
            this.hdma4 = state.getRegHDMA4();
            this.hdma3 = state.getRegHDMA3();
            this.hdma2 = state.getRegHDMA2();
            this.hdma1 = state.getRegHDMA1();
            this.ocps = state.getRegOBPI();
            this.bcps = state.getRegBGPI();
            this.cpal = new int[128];
            int n2 = 0;
            while (n2 < 64) {
                l = state.getBGP(n2 / 8);
                n = 0;
                while (n < 8) {
                    this.cpal[n2 + n] = (int)(l & 0xFFL);
                    l >>= 8;
                    ++n;
                }
                n2 += 8;
            }
            n2 = 0;
            while (n2 < 64) {
                l = state.getOBP(n2 / 8);
                n = 0;
                while (n < 8) {
                    this.cpal[64 + n2 + n] = (int)(l & 0xFFL);
                    l >>= 8;
                    ++n;
                }
                n2 += 8;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.vbk = 255;
            this.hdma5 = 255;
            this.hdma4 = 255;
            this.hdma3 = 255;
            this.hdma2 = 255;
            this.hdma1 = 255;
            this.ocps = 255;
            this.bcps = 255;
        }
        this.oam = new int[state.getOam().length];
        System.arraycopy(state.getOam(), 0, this.oam, 0, this.oam.length);
    }

    private void setSoundState(GBSoundController.State state) {
        this.ch3regs = new int[state.getWavePatternRAM().length];
        System.arraycopy(state.getWavePatternRAM(), 0, this.ch3regs, 0, state.getWavePatternRAM().length);
        this.ch3wave = new int[this.ch3regs.length];
        System.arraycopy(this.ch3regs, 0, this.ch3wave, 0, this.ch3regs.length);
        this.s_st1 = new int[29];
        this.s_ch1 = new int[88];
        this.s_st2 = new int[3];
        this.s_st1[22] = state.getRegNR50();
        this.s_st1[23] = state.getRegNR51();
        this.s_st1[24] = state.getRegNR52();
        this.s_ch1[83] = state.getRegNR44() >> 6 & 1;
        this.s_st1[21] = state.getRegNR43();
        this.s_ch1[85] = state.getRegNR42();
        this.s_ch1[84] = state.getRegNR41();
        this.s_ch1[57] = state.getRegNR34();
        this.s_ch1[56] = state.getRegNR33();
        this.s_ch1[75] = state.getRegNR32();
        this.s_ch1[74] = state.getRegNR31();
        this.s_st1[26] = state.getRegNR30() >> 7 & 1;
        this.s_ch1[35] = state.getRegNR24();
        this.s_ch1[34] = state.getRegNR23();
        this.s_ch1[41] = state.getRegNR22();
        this.s_ch1[40] = state.getRegNR21();
        this.s_ch1[13] = state.getRegNR14();
        this.s_ch1[12] = state.getRegNR13();
        this.s_ch1[19] = state.getRegNR12();
        this.s_ch1[18] = state.getRegNR11();
        this.s_st1[20] = state.getRegNR10();
        this.s_st2[2] = state.getRegNR52() & 0xF;
        this.s_ch1[16] = state.getRegNR52() & 1;
        this.s_ch1[38] = state.getRegNR52() >> 1 & 1;
        this.s_ch1[82] = state.getRegNR52() >> 3 & 1;
    }

    private void setCartridgeState(GBCartridge.State state) {
        GBCartridge.RegularState regularState = (GBCartridge.RegularState)state;
        this.romb = regularState.getROMBankNumber();
        this.srmb = regularState.getRAMBankNumber();
        this.sramEnable = regularState.isRamEnabled();
        this.mbc1mode = regularState.isModeRam();
        this.sram = new int[state.getRAM().length];
        System.arraycopy(state.getRAM(), 0, this.sram, 0, this.sram.length);
    }

    private static int[] readArray(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        return nArray;
    }

    private static long readLong(byte[] byArray) {
        return ((long)byArray[7] & 0xFFL) << 54 | ((long)byArray[6] & 0xFFL) << 48 | ((long)byArray[5] & 0xFFL) << 40 | ((long)byArray[4] & 0xFFL) << 32 | ((long)byArray[3] & 0xFFL) << 24 | ((long)byArray[2] & 0xFFL) << 16 | ((long)byArray[1] & 0xFFL) << 8 | (long)byArray[0] & 0xFFL;
    }

    private static int readInt(byte[] byArray) {
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    private static int readShort(byte[] byArray) {
        return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public static BGBSaveState from(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BGBSaveState bGBSaveState = new BGBSaveState();
        boolean bl = true;
        byte[] byArray = new byte[4];
        String string = BGBSaveState.readString(bufferedInputStream);
        while (string != null) {
            if (bl && !BGB_SIGNATURE.equals(string)) {
                ((InputStream)bufferedInputStream).close();
                return null;
            }
            bl = false;
            ((InputStream)bufferedInputStream).read(byArray);
            int n = Math.min(((InputStream)bufferedInputStream).available(), BGBSaveState.readInt(byArray));
            byte[] byArray2 = new byte[n];
            ((InputStream)bufferedInputStream).read(byArray2);
            if ("rommd5".equals(string)) {
                bGBSaveState.md5 = byArray2;
            } else if ("romfile".equals(string)) {
                bGBSaveState.romFile = new File(new String(byArray2));
            } else if ("version".equals(string)) {
                bGBSaveState.version = new String(byArray2);
            } else if ("gbcmode".equals(string)) {
                bGBSaveState.gbcMode = byArray2[0] != 0;
            } else if ("gbamode".equals(string)) {
                bGBSaveState.gbaMode = byArray2[0] != 0;
            } else if ("gbchw".equals(string)) {
                bGBSaveState.gbchw = byArray2[0] != 0;
            } else if ("sgbmode".equals(string)) {
                bGBSaveState.sgbMode = byArray2[0] != 0;
            } else if ("sgbbootvalues".equals(string)) {
                bGBSaveState.sgbBootValues = byArray2[0] != 0;
            } else if ("AF".equals(string)) {
                bGBSaveState.af = BGBSaveState.readShort(byArray2);
            } else if ("BC".equals(string)) {
                bGBSaveState.bc = BGBSaveState.readShort(byArray2);
            } else if ("DE".equals(string)) {
                bGBSaveState.de = BGBSaveState.readShort(byArray2);
            } else if ("HL".equals(string)) {
                bGBSaveState.hl = BGBSaveState.readShort(byArray2);
            } else if ("PC".equals(string)) {
                bGBSaveState.pc = BGBSaveState.readShort(byArray2);
            } else if ("SP".equals(string)) {
                bGBSaveState.sp = BGBSaveState.readShort(byArray2);
            } else if ("IME".equals(string)) {
                bGBSaveState.ime = byArray2[0] != 0;
            } else if ("IMA".equals(string)) {
                bGBSaveState.ima = byArray2[0] != 0;
            } else if ("HALT".equals(string)) {
                bGBSaveState.halted = byArray2[0] != 0;
            } else if ("STOP".equals(string)) {
                bGBSaveState.stopped = byArray2[0] != 0;
            } else if ("stopnoblank".equals(string)) {
                bGBSaveState.stopNoBlank = byArray2[0] != 0;
            } else if ("previme".equals(string)) {
                bGBSaveState.prevIme = byArray2[0] != 0;
            } else if ("lastopc".equals(string)) {
                bGBSaveState.lastOpCode = byArray2[0] & 0xFF;
            } else if ("clkopc2".equals(string)) {
                bGBSaveState.clkOpc2 = byArray2[0] & 0xFF;
            } else if ("clkopc".equals(string)) {
                bGBSaveState.clkOpc = byArray2[0] & 0xFF;
            } else if ("memtimereg".equals(string)) {
                bGBSaveState.memTimeReg = byArray2[0] & 0xFF;
            } else if ("RJOY".equals(string)) {
                bGBSaveState.rjoy = byArray2[0] & 0xFF;
            } else if ("SB".equals(string)) {
                bGBSaveState.sb = byArray2[0] & 0xFF;
            } else if ("SC".equals(string)) {
                bGBSaveState.sc = byArray2[0] & 0xFF;
            } else if ("linkstatus".equals(string)) {
                bGBSaveState.linkStatus = byArray2[0] & 0xFF;
            } else if ("DIV".equals(string)) {
                bGBSaveState.div = byArray2[0] & 0xFF;
            } else if ("TIMA".equals(string)) {
                bGBSaveState.tima = byArray2[0] & 0xFF;
            } else if ("TMA".equals(string)) {
                bGBSaveState.tma = byArray2[0] & 0xFF;
            } else if ("TAC".equals(string)) {
                bGBSaveState.tac = byArray2[0] & 0xFF;
            } else if ("IF".equals(string)) {
                bGBSaveState._if = byArray2[0] & 0xFF;
            } else if ("IE".equals(string)) {
                bGBSaveState.ie = byArray2[0] & 0xFF;
            } else if ("LCDC".equals(string)) {
                bGBSaveState.lcdc = byArray2[0] & 0xFF;
            } else if ("STAT".equals(string)) {
                bGBSaveState.stat = byArray2[0] & 0xFF;
            } else if ("SCY".equals(string)) {
                bGBSaveState.scy = byArray2[0] & 0xFF;
            } else if ("SCX".equals(string)) {
                bGBSaveState.scx = byArray2[0] & 0xFF;
            } else if ("LY".equals(string)) {
                bGBSaveState.ly = byArray2[0] & 0xFF;
            } else if ("LYC".equals(string)) {
                bGBSaveState.lyc = byArray2[0] & 0xFF;
            } else if ("WINY".equals(string)) {
                bGBSaveState.winy = byArray2[0] & 0xFF;
            } else if ("WINX".equals(string)) {
                bGBSaveState.winx = byArray2[0] & 0xFF;
            } else if ("DMA".equals(string)) {
                bGBSaveState.dma = byArray2[0] & 0xFF;
            } else if ("oamdmaleft".equals(string)) {
                bGBSaveState.oamDmaLeft = BGBSaveState.readInt(byArray2);
            } else if ("divider".equals(string)) {
                bGBSaveState.divider = BGBSaveState.readInt(byArray2);
            } else if ("totalclks".equals(string)) {
                bGBSaveState.totalClks = BGBSaveState.readLong(byArray2);
            } else if ("vidtime".equals(string)) {
                bGBSaveState.vidTime = BGBSaveState.readInt(byArray2);
            } else if ("ilines".equals(string)) {
                bGBSaveState.iLines = BGBSaveState.readInt(byArray2);
            } else if ("vidstatus".equals(string)) {
                bGBSaveState.vidStatus = BGBSaveState.readInt(byArray2);
            } else if ("lcdpos".equals(string)) {
                bGBSaveState.lcdPos = BGBSaveState.readInt(byArray2);
            } else if ("lcdint".equals(string)) {
                bGBSaveState.lcdInt = byArray2[0] != 0;
            } else if ("delayedlcdint".equals(string)) {
                bGBSaveState.delayedLcdInt = byArray2[0] != 0;
            } else if ("vidinacc".equals(string)) {
                bGBSaveState.vidInAcc = byArray2[0] & 0xFF;
            } else if ("spriteduration".equals(string)) {
                bGBSaveState.spriteDuration = byArray2[0] & 0xFF;
            } else if ("spriteduration2".equals(string)) {
                bGBSaveState.spriteDuration2 = byArray2[0] & 0xFF;
            } else if ("cpuquirk".equals(string)) {
                bGBSaveState.cpuQuirk = byArray2[0] != 0;
            } else if ("OAM".equals(string)) {
                bGBSaveState.oam = BGBSaveState.readArray(byArray2);
            } else if ("HRAM".equals(string)) {
                bGBSaveState.hram = BGBSaveState.readArray(byArray2);
            } else if ("BGP".equals(string)) {
                bGBSaveState.bgp = byArray2[0] & 0xFF;
            } else if ("OBP".equals(string)) {
                bGBSaveState.obp0 = byArray2[0] & 0xFF;
                bGBSaveState.obp1 = byArray2[1] & 0xFF;
            } else if ("dmgbootrompal".equals(string)) {
                bGBSaveState.dmgBootRomPal = byArray2[0] != 0;
            } else if ("KEY1".equals(string)) {
                bGBSaveState.key1 = byArray2[0] & 0xFF;
            } else if ("VBK".equals(string)) {
                bGBSaveState.vbk = byArray2[0] & 0xFF;
            } else if ("HDMA1".equals(string)) {
                bGBSaveState.hdma1 = byArray2[0] & 0xFF;
            } else if ("HDMA2".equals(string)) {
                bGBSaveState.hdma2 = byArray2[0] & 0xFF;
            } else if ("HDMA3".equals(string)) {
                bGBSaveState.hdma3 = byArray2[0] & 0xFF;
            } else if ("HDMA4".equals(string)) {
                bGBSaveState.hdma4 = byArray2[0] & 0xFF;
            } else if ("HDMA5".equals(string)) {
                bGBSaveState.hdma5 = byArray2[0] & 0xFF;
            } else if ("IR".equals(string)) {
                bGBSaveState.ir = byArray2[0] & 0xFF;
            } else if ("BCPS".equals(string)) {
                bGBSaveState.bcps = byArray2[0] & 0xFF;
            } else if ("OCPS".equals(string)) {
                bGBSaveState.ocps = byArray2[0] & 0xFF;
            } else if ("SVBK".equals(string)) {
                bGBSaveState.svbk = byArray2[0] & 0xFF;
            } else if ("CPAL".equals(string)) {
                bGBSaveState.cpal = BGBSaveState.readArray(byArray2);
            } else if ("WRAM".equals(string)) {
                bGBSaveState.wram = BGBSaveState.readArray(byArray2);
            } else if ("VRAM".equals(string)) {
                bGBSaveState.vram = BGBSaveState.readArray(byArray2);
            } else if ("oddmode".equals(string)) {
                bGBSaveState.oddMode = byArray2[0] != 0;
            } else if ("speedswitchleft".equals(string)) {
                bGBSaveState.speedSwitchLeft = BGBSaveState.readInt(byArray2);
            } else if ("readeolquirkcount".equals(string)) {
                bGBSaveState.readEolQuirkCount = byArray2[0] & 0xFF;
            } else if ("speedswitchlastwashalt".equals(string)) {
                bGBSaveState.speedSwitchLastWasHalt = byArray2[0] != 0;
            } else if ("hadbootrom".equals(string)) {
                bGBSaveState.hadBootrom = byArray2[0] != 0;
            } else if ("regff72".equals(string)) {
                bGBSaveState.regFF72 = byArray2[0] & 0xFF;
            } else if ("regff73".equals(string)) {
                bGBSaveState.regFF73 = byArray2[0] & 0xFF;
            } else if ("regff74".equals(string)) {
                bGBSaveState.regFF74 = byArray2[0] & 0xFF;
            } else if ("regff75".equals(string)) {
                bGBSaveState.regFF75 = byArray2[0] & 0xFF;
            } else if ("s_st1".equals(string)) {
                bGBSaveState.s_st1 = BGBSaveState.readArray(byArray2);
            } else if ("s_st2".equals(string)) {
                bGBSaveState.s_st2 = BGBSaveState.readArray(byArray2);
            } else if ("s_ch1".equals(string)) {
                bGBSaveState.s_ch1 = BGBSaveState.readArray(byArray2);
            } else if ("ch3regs".equals(string)) {
                bGBSaveState.ch3regs = BGBSaveState.readArray(byArray2);
            } else if ("ch3wave".equals(string)) {
                bGBSaveState.ch3wave = BGBSaveState.readArray(byArray2);
            } else if ("ch3startts".equals(string)) {
                bGBSaveState.ch3StartTs = BGBSaveState.readInt(byArray2);
            } else if ("ch3startsample".equals(string)) {
                bGBSaveState.ch3startSample = BGBSaveState.readInt(byArray2);
            } else if ("ch3firstsample".equals(string)) {
                bGBSaveState.ch3firstSample = byArray2[0] != 0;
            } else if ("s_st3".equals(string)) {
                bGBSaveState.s_st3 = BGBSaveState.readArray(byArray2);
            } else if ("sgb_xfer_startbit".equals(string)) {
                bGBSaveState.sgb_xfer_startbit = byArray2[0] & 0xFF;
            } else if ("sgb_xfer_busy".equals(string)) {
                bGBSaveState.sgb_xfer_busy = byArray2[0] & 0xFF;
            } else if ("sgb_xfer_offset".equals(string)) {
                bGBSaveState.sgb_xfer_offset = BGBSaveState.readInt(byArray2);
            } else if ("sgb_xfer_data".equals(string)) {
                bGBSaveState.sgb_xfer_data = BGBSaveState.readArray(byArray2);
            } else if ("sgb_joypad_max".equals(string)) {
                bGBSaveState.sgb_joypad_max = BGBSaveState.readInt(byArray2);
            } else if ("sgb_joypad_current".equals(string)) {
                bGBSaveState.sgb_joypad_current = BGBSaveState.readInt(byArray2);
            } else if ("sgb_joypad_done".equals(string)) {
                bGBSaveState.sgb_joypad_done = BGBSaveState.readInt(byArray2);
            } else if ("sgb_screen_frozen".equals(string)) {
                bGBSaveState.sgb_screen_frozen = BGBSaveState.readInt(byArray2);
            } else if ("sgb_chardata".equals(string)) {
                bGBSaveState.sgb_chardata = BGBSaveState.readArray(byArray2);
            } else if ("sgb_pct_map".equals(string)) {
                bGBSaveState.sgb_pct_map = BGBSaveState.readArray(byArray2);
            } else if ("sgb_pal2".equals(string)) {
                bGBSaveState.sgb_pal2 = BGBSaveState.readArray(byArray2);
            } else if ("sgb_pal".equals(string)) {
                bGBSaveState.sgb_pal = BGBSaveState.readArray(byArray2);
            } else if ("sgb_rampal".equals(string)) {
                bGBSaveState.sgb_rampal = BGBSaveState.readArray(byArray2);
            } else if ("sgb_trn_status".equals(string)) {
                bGBSaveState.sgb_trn_status = BGBSaveState.readInt(byArray2);
            } else if ("sgb_trn_select".equals(string)) {
                bGBSaveState.sgb_trn_select = BGBSaveState.readInt(byArray2);
            } else if ("sgb_chr_trn_select".equals(string)) {
                bGBSaveState.sgb_chr_trn_select = BGBSaveState.readInt(byArray2);
            } else if ("sgb_hasborder".equals(string)) {
                bGBSaveState.sgb_hasborder = byArray2[0] != 0;
            } else if ("sgb_atf".equals(string)) {
                bGBSaveState.sgb_atf = BGBSaveState.readArray(byArray2);
            } else if ("sgb_attr2".equals(string)) {
                bGBSaveState.sgb_attr2 = BGBSaveState.readArray(byArray2);
            } else if ("sgb_attr".equals(string)) {
                bGBSaveState.sgb_attr = BGBSaveState.readArray(byArray2);
            } else if ("sgb_mltreq_done".equals(string)) {
                bGBSaveState.sgb_mltreq_done = byArray2[0] != 0;
            } else if ("sgb_packet_max".equals(string)) {
                bGBSaveState.sgb_packet_max = BGBSaveState.readInt(byArray2);
            } else if ("sgb_packet_current".equals(string)) {
                bGBSaveState.sgb_packet_current = BGBSaveState.readInt(byArray2);
            } else if ("sgb_packet_data".equals(string)) {
                bGBSaveState.sgb_packet_data = BGBSaveState.readArray(byArray2);
            } else if ("sgb_hidden".equals(string)) {
                bGBSaveState.sgb_hidden = byArray2[0] != 0;
            } else if ("sgb_initialborder".equals(string)) {
                bGBSaveState.sgb_initialBorder = byArray2[0] != 0;
            } else if ("sgb_palset".equals(string)) {
                bGBSaveState.sgb_palset = byArray2[0] != 0;
            } else if ("sgb_pct_prn_time".equals(string)) {
                bGBSaveState.sgb_pct_prn_time = BGBSaveState.readInt(byArray2);
            } else if ("rombank0".equals(string)) {
                bGBSaveState.rombank0 = BGBSaveState.readInt(byArray2);
            } else if ("mbcbank0_lockedmode".equals(string)) {
                bGBSaveState.mbcbank0_lockedmode = byArray2[0] != 0;
            } else if ("mbc3l".equals(string)) {
                bGBSaveState.mbc3l = byArray2[0] & 0xFF;
            } else if ("mbc3t".equals(string)) {
                bGBSaveState.mbc3t = BGBSaveState.readArray(byArray2);
            } else if ("mbc3tl".equals(string)) {
                bGBSaveState.mbc3tl = BGBSaveState.readArray(byArray2);
            } else if ("ROMB".equals(string)) {
                bGBSaveState.romb = BGBSaveState.readInt(byArray2);
            } else if ("irombank".equals(string)) {
                bGBSaveState.irombank = BGBSaveState.readInt(byArray2);
            } else if ("SRMB".equals(string)) {
                bGBSaveState.srmb = BGBSaveState.readInt(byArray2);
            } else if ("isrambank".equals(string)) {
                bGBSaveState.isrambank = BGBSaveState.readInt(byArray2);
            } else if ("sramenable".equals(string)) {
                bGBSaveState.sramEnable = byArray2[0] != 0;
            } else if ("SRAM".equals(string)) {
                bGBSaveState.sram = BGBSaveState.readArray(byArray2);
            } else if ("mbc1mode".equals(string)) {
                bGBSaveState.mbc1mode = byArray2[0] != 0;
            } else if ("rtc_interval".equals(string)) {
                bGBSaveState.rtc_interval = BGBSaveState.readInt(byArray2);
            } else if ("rtc_fraction".equals(string)) {
                bGBSaveState.rtc_fraction = BGBSaveState.readInt(byArray2);
            }
            string = BGBSaveState.readString(bufferedInputStream);
        }
        ((InputStream)bufferedInputStream).close();
        if (bl) {
            return null;
        }
        if (bGBSaveState.wram == null || bGBSaveState.hram == null) {
            throw new IOException("Savestate is invalid");
        }
        bGBSaveState.wramInitialized = new boolean[bGBSaveState.wram.length];
        Arrays.fill(bGBSaveState.wramInitialized, true);
        bGBSaveState.hramInitialized = new boolean[bGBSaveState.hram.length];
        Arrays.fill(bGBSaveState.hramInitialized, true);
        if (bGBSaveState.romFile == null || !bGBSaveState.romFile.exists()) {
            bGBSaveState.romFile = file2;
        }
        return bGBSaveState;
    }

    private static String readString(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[256];
        int n = 0;
        while (n < byArray.length) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                if (n == 0) break;
                throw new IllegalArgumentException("Unexpected EOF");
            }
            if (n2 == 0) {
                return new String(byArray, 0, n);
            }
            byArray[n] = (byte)n2;
            ++n;
        }
        return null;
    }

    @Override
    public void writeToFile(File file) throws IOException {
        Object object;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ByteBuffer byteBuffer = ByteBuffer.allocate(768).order(ByteOrder.LITTLE_ENDIAN);
        BGBSaveState.putBlockHeader(BGB_SIGNATURE, 0, byteBuffer);
        BGBSaveState.putBlockHeader("rommd5", this.md5.length, byteBuffer);
        int n = BGBSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        bufferedOutputStream.write(this.md5);
        n += this.md5.length;
        BGBSaveState.putBlockHeader("romfile", this.romFile.getName().length(), byteBuffer);
        n += BGBSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        bufferedOutputStream.write(this.romFile.getName().getBytes());
        n += this.romFile.getName().getBytes().length;
        BGBSaveState.putBlockHeader("version", this.version.length(), byteBuffer);
        n += BGBSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        bufferedOutputStream.write(this.version.getBytes());
        n += this.version.length();
        int[] nArray = new int[7];
        n += BGBSaveState.writeBooleanBlock("gbcmode", this.gbcMode, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("gbamode", this.gbaMode, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("gbchw", this.gbchw, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("sgbmode", this.sgbMode, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("sgbbootvalues", this.sgbBootValues, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeShortBlock("AF", this.af, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeShortBlock("BC", this.bc, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeShortBlock("DE", this.de, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeShortBlock("HL", this.hl, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeShortBlock("PC", this.pc, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeShortBlock("SP", this.sp, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("IME", this.ime, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("IMA", this.ima, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("HALT", this.halted, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("STOP", this.stopped, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("stopnoblank", this.stopNoBlank, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("previme", this.prevIme, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("lastopc", this.lastOpCode, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("clkopc2", this.clkOpc2, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("clkopc", this.clkOpc, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("memtimereg", this.memTimeReg, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("RJOY", this.rjoy, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("SB", this.sb, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("SC", this.sc, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("linkstatus", this.linkStatus, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("DIV", this.div, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("TIMA", this.tima, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("TMA", this.tma, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("TAC", this.tac, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("IF", this._if, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("IE", this.ie, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("LCDC", this.lcdc, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("STAT", this.stat, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("SCY", this.scy, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("SCX", this.scx, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("LY", this.ly, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("LYC", this.lyc, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("WINY", this.winy, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("WINX", this.winx, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("DMA", this.dma, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("oamdmaleft", this.oamDmaLeft, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("divider", this.divider, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeLongBlock("totalclks", this.totalClks, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("vidtime", this.vidTime, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("ilines", this.iLines, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("vidstatus", this.vidStatus, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("lcdpos", this.lcdPos, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("lcdint", this.lcdInt, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("delayedlcdint", this.delayedLcdInt, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("vidinacc", this.vidInAcc, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("spriteduration", this.spriteDuration, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("spriteduration2", this.spriteDuration2, byteBuffer, bufferedOutputStream);
        int n2 = (n += BGBSaveState.writeBooleanBlock("cpuquirk", this.cpuQuirk, byteBuffer, bufferedOutputStream)) + "OAM\u0000".length() + 4;
        int n3 = (n += BGBSaveState.writeBlock("OAM", this.oam, byteBuffer, (OutputStream)bufferedOutputStream)) + "HRAM\u0000".length() + 4;
        n += BGBSaveState.writeBlock("HRAM", this.hram, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("BGP", this.bgp, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeShortBlock("OBP", this.obp1 << 8 | this.obp0, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("dmgbootrompal", this.dmgBootRomPal, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("KEY1", this.key1, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("VBK", this.vbk, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("HDMA1", this.hdma1, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("HDMA2", this.hdma2, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("HDMA3", this.hdma3, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("HDMA4", this.hdma4, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("HDMA5", this.hdma5, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("IR", this.ir, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("BCPS", this.bcps, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("OCPS", this.ocps, byteBuffer, bufferedOutputStream);
        int n4 = this.cpal != null ? (n += BGBSaveState.writeByteBlock("SVBK", this.svbk, byteBuffer, bufferedOutputStream)) + "CPAL\u0000".length() + 4 : 0;
        int n5 = n4 >= 0 ? n4 + 64 : 0;
        int n6 = (n += BGBSaveState.writeBlock("CPAL", this.cpal, byteBuffer, (OutputStream)bufferedOutputStream)) + "WRAM\u0000".length() + 4;
        int n7 = (n += BGBSaveState.writeBlock("WRAM", this.wram, byteBuffer, (OutputStream)bufferedOutputStream)) + "VRAM\u0000".length() + 4;
        n += BGBSaveState.writeBlock("VRAM", this.vram, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("oddmode", this.oddMode, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("speedswitchleft", this.speedSwitchLeft, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("readeolquirkcount", this.readEolQuirkCount, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("speedswitchlastwashalt", this.speedSwitchLastWasHalt, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("hadbootrom", this.hadBootrom, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("regff72", this.regFF72, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("regff73", this.regFF73, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("regff74", this.regFF74, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("regff75", this.regFF75, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBlock("s_st1", this.s_st1, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeBlock("s_st2", this.s_st2, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeBlock("s_ch1", this.s_ch1, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeBlock("ch3regs", this.ch3regs, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeBlock("ch3wave", this.ch3wave, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("ch3startts", this.ch3StartTs, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("ch3startsample", this.ch3startSample, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("ch3firstsample", this.ch3firstSample, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBlock("s_st3", this.s_st3, byteBuffer, (OutputStream)bufferedOutputStream);
        if (this.sgb_chardata != null) {
            n += BGBSaveState.writeByteBlock("sgb_xfer_startbit", this.sgb_xfer_startbit, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeByteBlock("sgb_xfer_busy", this.sgb_xfer_busy, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_xfer_offset", this.sgb_xfer_offset, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeBlock("sgb_xfer_data", this.sgb_xfer_data, byteBuffer, (OutputStream)bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_joypad_max", this.sgb_joypad_max, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_joypad_current", this.sgb_joypad_current, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_joypad_done", this.sgb_joypad_done, byteBuffer, bufferedOutputStream);
            nArray[0] = (n += BGBSaveState.writeIntBlock("sgb_screen_frozen", this.sgb_screen_frozen, byteBuffer, bufferedOutputStream)) + "sgb_chardata\u0000".length() + 4;
            nArray[1] = (n += BGBSaveState.writeBlock("sgb_chardata", this.sgb_chardata, byteBuffer, (OutputStream)bufferedOutputStream)) + "sgb_pct_map\u0000".length() + 4;
            nArray[3] = (n += BGBSaveState.writeBlock("sgb_pct_map", this.sgb_pct_map, byteBuffer, (OutputStream)bufferedOutputStream)) + "sgb_pal2\u0000".length() + 4;
            nArray[2] = (n += BGBSaveState.writeBlock("sgb_pal2", this.sgb_pal2, byteBuffer, (OutputStream)bufferedOutputStream)) + "sgb_pal\u0000".length() + 4 + 128;
            nArray[4] = (n += BGBSaveState.writeBlock("sgb_pal", this.sgb_pal, byteBuffer, (OutputStream)bufferedOutputStream)) + "sgb_rampal\u0000".length() + 4;
            n += BGBSaveState.writeBlock("sgb_rampal", this.sgb_rampal, byteBuffer, (OutputStream)bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_trn_status", this.sgb_trn_status, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_trn_select", this.sgb_trn_select, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_chr_trn_select", this.sgb_chr_trn_select, byteBuffer, bufferedOutputStream);
            nArray[6] = (n += BGBSaveState.writeBooleanBlock("sgb_hasborder", this.sgb_hasborder, byteBuffer, bufferedOutputStream)) + "sgb_atf\u0000".length() + 4;
            nArray[5] = (n += BGBSaveState.writeBlock("sgb_atf", this.sgb_atf, byteBuffer, (OutputStream)bufferedOutputStream)) + "sgb_attr2\u0000".length() + 4;
            n += BGBSaveState.writeBlock("sgb_attr2", this.sgb_attr2, byteBuffer, (OutputStream)bufferedOutputStream);
            n += BGBSaveState.writeBlock("sgb_attr", this.sgb_attr, byteBuffer, (OutputStream)bufferedOutputStream);
            n += BGBSaveState.writeBooleanBlock("sgb_mltreq_done", this.sgb_mltreq_done, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_packet_max", this.sgb_packet_max, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_packet_current", this.sgb_packet_current, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeBlock("sgb_packet_data", this.sgb_packet_data, byteBuffer, (OutputStream)bufferedOutputStream);
            n += BGBSaveState.writeBooleanBlock("sgb_hidden", this.sgb_hidden, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeBooleanBlock("sgb_initialborder", this.sgb_initialBorder, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeBooleanBlock("sgb_palset", this.sgb_palset, byteBuffer, bufferedOutputStream);
            n += BGBSaveState.writeIntBlock("sgb_pct_prn_time", this.sgb_pct_prn_time, byteBuffer, bufferedOutputStream);
        }
        n += BGBSaveState.writeIntBlock("rombank0", this.rombank0, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("mbcbank0_lockedmode", this.mbcbank0_lockedmode, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeByteBlock("mbc3l", this.mbc3l, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeBlock("mbc3t", this.mbc3t, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeBlock("mbc3tl", this.mbc3tl, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("ROMB", this.romb, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("irombank", this.irombank, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("SRMB", this.srmb, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("isrambank", this.isrambank, byteBuffer, bufferedOutputStream);
        int n8 = (n += BGBSaveState.writeBooleanBlock("sramenable", this.sramEnable, byteBuffer, bufferedOutputStream)) + "SRAM\u0000".length() + 4;
        n += BGBSaveState.writeBlock("SRAM", this.sram, byteBuffer, (OutputStream)bufferedOutputStream);
        n += BGBSaveState.writeBooleanBlock("mbc1mode", this.mbc1mode, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("rtc_interval", this.rtc_interval, byteBuffer, bufferedOutputStream);
        n += BGBSaveState.writeIntBlock("rtc_fraction", this.rtc_fraction, byteBuffer, bufferedOutputStream);
        BGBSaveState.putBlockHeader(BESSSaveState.Block.NAME, Emulicious.TITLE.length(), byteBuffer);
        byteBuffer.put(Emulicious.TITLE.getBytes());
        BGBSaveState.putBlockHeader(BESSSaveState.Block.CORE, 208, byteBuffer);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)1);
        byteBuffer.put((this.gbchw ? BESS_MODEL_IDENTIFIER_GBC : (this.sgbMode ? BESS_MODEL_IDENTIFIER_SGB : BESS_MODEL_IDENTIFIER_DMG)).getBytes());
        byteBuffer.putShort((short)this.pc);
        byteBuffer.putShort((short)this.af);
        byteBuffer.putShort((short)this.bc);
        byteBuffer.putShort((short)this.de);
        byteBuffer.putShort((short)this.hl);
        byteBuffer.putShort((short)this.sp);
        byteBuffer.put((byte)(this.ime ? 1 : 0));
        byteBuffer.put((byte)this.ie);
        byteBuffer.put((byte)(this.stopped ? 2 : (this.halted ? 1 : 0)));
        byteBuffer.put((byte)0);
        BGBSaveState.putBuffer(this.collectMemoryMapped(new int[128]), byteBuffer);
        byteBuffer.putInt(this.wram.length);
        byteBuffer.putInt(n6);
        byteBuffer.putInt(this.vram.length);
        byteBuffer.putInt(n7);
        byteBuffer.putInt(this.sram != null ? this.sram.length : 0);
        byteBuffer.putInt(n8);
        byteBuffer.putInt(this.oam.length);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(this.hram.length);
        byteBuffer.putInt(n3);
        byteBuffer.putInt(this.cpal != null ? 64 : 0);
        byteBuffer.putInt(n4);
        byteBuffer.putInt(this.cpal != null ? this.cpal.length - 64 : 0);
        byteBuffer.putInt(n5);
        try {
            int[] nArray2;
            object = this.makeCartridgeState().toWriteBased();
            if (object != null && (nArray2 = object.getWrites()) != null) {
                BGBSaveState.putBlockHeader(BESSSaveState.Block.MBC, nArray2.length / 2 * 3, byteBuffer);
                int n9 = 0;
                while (n9 < nArray2.length) {
                    byteBuffer.putShort((short)nArray2[n9]);
                    byteBuffer.put((byte)nArray2[n9 + 1]);
                    n9 += 2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.sgb_chardata != null) {
            object = new int[nArray.length];
            object[0] = this.sgb_chardata.length;
            object[1] = this.sgb_pct_map != null ? this.sgb_pct_map.length : 0;
            object[2] = this.sgb_pal != null ? this.sgb_pal.length - 128 : 0;
            object[3] = this.sgb_pal2 != null ? this.sgb_pal2.length : 0;
            object[4] = this.sgb_rampal != null ? this.sgb_rampal.length : 0;
            object[5] = this.sgb_attr2 != null ? this.sgb_attr2.length : 0;
            object[6] = this.sgb_atf != null ? this.sgb_atf.length : 0;
            BGBSaveState.putBlockHeader(BESSSaveState.Block.SGB, nArray.length * 2 * 4 + 1, byteBuffer);
            int n10 = 0;
            while (n10 < nArray.length) {
                byteBuffer.putInt((int)object[n10]);
                byteBuffer.putInt(nArray[n10]);
                ++n10;
            }
            byteBuffer.put((byte)(Math.max(1, this.sgb_joypad_max) << 4 | this.sgb_joypad_current));
        }
        BGBSaveState.putBlockHeader(BESSSaveState.Block.END, 0, byteBuffer);
        byteBuffer.putInt(n + "BESS\u0000".length() + 4);
        byteBuffer.put("BESS".getBytes());
        object = Arrays.copyOf(byteBuffer.array(), byteBuffer.position());
        byteBuffer.clear();
        BGBSaveState.writeBlock("BESS", (byte[])object, byteBuffer, (OutputStream)bufferedOutputStream);
        bufferedOutputStream.close();
    }

    private static int writeBooleanBlock(String string, boolean bl, ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        return BGBSaveState.writeByteBlock(string, bl ? 1 : 0, byteBuffer, outputStream);
    }

    private static int writeByteBlock(String string, int n, ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        BGBSaveState.putBlockHeader(string, 1, byteBuffer);
        byteBuffer.put((byte)n);
        return BGBSaveState.writeByteBuffer(outputStream, byteBuffer);
    }

    private static int writeShortBlock(String string, int n, ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        BGBSaveState.putBlockHeader(string, 2, byteBuffer);
        byteBuffer.putShort((short)n);
        return BGBSaveState.writeByteBuffer(outputStream, byteBuffer);
    }

    private static int writeIntBlock(String string, int n, ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        BGBSaveState.putBlockHeader(string, 4, byteBuffer);
        byteBuffer.putInt(n);
        return BGBSaveState.writeByteBuffer(outputStream, byteBuffer);
    }

    private static int writeLongBlock(String string, long l, ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        BGBSaveState.putBlockHeader(string, 8, byteBuffer);
        byteBuffer.putLong(l);
        return BGBSaveState.writeByteBuffer(outputStream, byteBuffer);
    }

    private static int writeBlock(String string, int[] nArray, ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        int n = 0;
        if (nArray != null) {
            BGBSaveState.putBlockHeader(string, nArray.length, byteBuffer);
            n += BGBSaveState.writeByteBuffer(outputStream, byteBuffer);
            n += BGBSaveState.writeBuffer(outputStream, nArray);
        }
        return n;
    }

    private static void writeBlock(String string, byte[] byArray, ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            BGBSaveState.putBlockHeader(string, byArray.length, byteBuffer);
            BGBSaveState.writeByteBuffer(outputStream, byteBuffer);
            outputStream.write(byArray);
        }
    }

    private static void putBlockHeader(String string, int n, ByteBuffer byteBuffer) {
        byteBuffer.put(string.getBytes());
        byteBuffer.put((byte)0);
        byteBuffer.putInt(n);
    }

    private static int writeByteBuffer(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        outputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        byteBuffer.clear();
        return n;
    }

    private static int writeBuffer(OutputStream outputStream, int[] nArray) throws IOException {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        outputStream.write(byArray);
        return byArray.length;
    }

    private static void putBuffer(int[] nArray, ByteBuffer byteBuffer) {
        int n = 0;
        while (n < nArray.length) {
            byteBuffer.put((byte)nArray[n]);
            ++n;
        }
    }

    private static void putBlockHeader(BESSSaveState.Block block, int n, ByteBuffer byteBuffer) {
        byteBuffer.put(block.toString().getBytes());
        byteBuffer.putInt(n);
    }

    protected int[] collectMemoryMapped(int[] nArray) {
        int n = 0;
        while (n < 128) {
            nArray[n] = 255;
            ++n;
        }
        nArray[0] = this.rjoy;
        nArray[1] = this.sb;
        nArray[2] = this.sc;
        nArray[4] = this.div;
        nArray[5] = this.tima;
        nArray[6] = this.tma;
        nArray[7] = this.tac;
        nArray[15] = this._if;
        n = 0;
        while (n < this.ch3regs.length) {
            nArray[48 + n] = this.ch3regs[n];
            ++n;
        }
        nArray[74] = this.winy;
        nArray[75] = this.winx;
        nArray[79] = 0xFE | this.vbk;
        nArray[65] = this.stat;
        nArray[66] = this.scy;
        nArray[67] = this.scx;
        nArray[106] = 0x40 | this.ocps;
        nArray[76] = 255;
        nArray[73] = this.obp1;
        nArray[72] = this.obp0;
        nArray[69] = this.lyc;
        nArray[68] = this.ly;
        nArray[64] = this.lcdc;
        nArray[85] = this.hdma5;
        nArray[84] = 255;
        nArray[83] = 255;
        nArray[82] = 255;
        nArray[81] = 255;
        nArray[80] = 255;
        nArray[70] = this.dma;
        nArray[104] = 0x40 | this.bcps;
        nArray[71] = this.bgp;
        nArray[77] = this.key1;
        nArray[112] = 0xF8 | this.svbk;
        nArray[114] = this.regFF72;
        nArray[115] = this.regFF73;
        nArray[116] = this.regFF74;
        nArray[117] = this.regFF75;
        nArray[86] = this.ir;
        nArray[35] = (this.s_ch1[83] & 1) << 6 | 0xBF;
        nArray[34] = this.s_st1[21];
        nArray[33] = this.s_ch1[85];
        nArray[32] = 255;
        nArray[30] = this.s_ch1[57] | 0xBF;
        nArray[29] = 255;
        nArray[28] = this.s_ch1[75] | 0x9F;
        nArray[27] = 255;
        nArray[26] = (this.s_st1[26] & 1) << 7 | 0x7F;
        nArray[25] = this.s_ch1[35] | 0xBF;
        nArray[24] = 255;
        nArray[23] = this.s_ch1[41];
        nArray[22] = this.s_ch1[40] | 0x3F;
        nArray[20] = this.s_ch1[13] | 0xBF;
        nArray[19] = 255;
        nArray[18] = this.s_ch1[19];
        nArray[17] = this.s_ch1[18] | 0x3F;
        nArray[16] = 0x80 | this.s_st1[20];
        nArray[36] = this.s_st1[22];
        nArray[37] = this.s_st1[23];
        nArray[38] = this.s_st1[24];
        return nArray;
    }

    GBCartridge.RegularState makeCartridgeState() {
        return new GBCartridge.UnmodifiableRegularState(){

            @Override
            public GBCartridge.State clone() {
                return this;
            }

            @Override
            public GBCartridge.WriteBasedState toWriteBased() {
                try {
                    GBCartridge gBCartridge = new GBCartridge(BGBSaveState.this.romFile.getPath(), null){

                        @Override
                        protected void enableShutdownHook() {
                        }

                        @Override
                        protected void writeRAMtoFile() {
                        }

                        @Override
                        protected boolean readRAMfromFile() {
                            return false;
                        }
                    };
                    gBCartridge.setState(this, false);
                    return gBCartridge.getState().toWriteBased();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }

            @Override
            public int getROMBankNumber() {
                return BGBSaveState.this.romb;
            }

            @Override
            public int getRAMBankNumber() {
                return BGBSaveState.this.srmb;
            }

            @Override
            public boolean isModeRam() {
                return BGBSaveState.this.mbc1mode;
            }

            @Override
            public boolean isRamEnabled() {
                return BGBSaveState.this.sramEnable;
            }

            @Override
            public int[] getRAM() {
                return BGBSaveState.this.sram;
            }

            @Override
            public int getClockCycles() {
                return 0;
            }

            @Override
            public int getClockSeconds() {
                return 0;
            }

            @Override
            public int getClockMinutes() {
                return 0;
            }

            @Override
            public int getClockLatchedSeconds() {
                return 0;
            }

            @Override
            public int getClockLatchedMinutes() {
                return 0;
            }

            @Override
            public int getClockLatchedHours() {
                return 0;
            }

            @Override
            public int getClockLatchedDays() {
                return 0;
            }

            @Override
            public int getClockLatchedControl() {
                return 0;
            }

            @Override
            public Date getClockLastTime() {
                return null;
            }

            @Override
            public int getClockHours() {
                return 0;
            }

            @Override
            public int getClockDays() {
                return 0;
            }

            @Override
            public int getClockControl() {
                return 0;
            }
        };
    }

    @Override
    public GameBoy.State getState() {
        return new GameBoy.UnmodifiableState(){

            @Override
            public GameBoy.State clone() {
                return this;
            }

            @Override
            public boolean isPrevSTATline() {
                return BGBSaveState.this.lcdInt;
            }

            @Override
            public boolean isDoubleSpeed() {
                return BGBSaveState.this.gbcMode && (BGBSaveState.this.key1 & 0x80) != 0;
            }

            @Override
            public boolean isDmgMode() {
                return !BGBSaveState.this.gbcMode;
            }

            @Override
            public boolean isBootROMenabled() {
                return false;
            }

            @Override
            public boolean isStopped() {
                return BGBSaveState.this.stopped;
            }

            @Override
            public int getDmaCounter() {
                return 0;
            }

            @Override
            public int getDmaSource() {
                return 0;
            }

            @Override
            public int getTimerDMA() {
                return 0;
            }

            @Override
            public boolean isDmaJustStarted() {
                return false;
            }

            @Override
            public boolean isDmaStillRunning() {
                return false;
            }

            @Override
            public int[] getWRam() {
                return BGBSaveState.this.wram;
            }

            @Override
            public GameBoy.TIMAState getTimaState() {
                return GameBoy.TIMAState.REGULAR;
            }

            @Override
            public GBSoundController.State getSoundState() {
                return new GBSoundController.UnmodifiableState(){

                    @Override
                    public GBSoundController.State clone() {
                        return this;
                    }

                    @Override
                    public boolean isWaveChannelJustEnabled() {
                        return false;
                    }

                    @Override
                    public int[] getWavePatternRAM() {
                        int[] nArray = new int[16];
                        int n = 0;
                        while (n < nArray.length) {
                            nArray[n] = (this).BGBSaveState.this.ch3regs[n];
                            ++n;
                        }
                        return nArray;
                    }

                    @Override
                    public int getVolume(int n) {
                        return 0;
                    }

                    @Override
                    public int getSample(int n) {
                        return 0;
                    }

                    @Override
                    public int getLength(int n) {
                        return 0;
                    }

                    @Override
                    public int getRegNR52() {
                        return (this).BGBSaveState.this.s_st1[24];
                    }

                    @Override
                    public int getRegNR51() {
                        return (this).BGBSaveState.this.s_st1[23];
                    }

                    @Override
                    public int getRegNR50() {
                        return (this).BGBSaveState.this.s_st1[22];
                    }

                    @Override
                    public int getRegNR44() {
                        return ((this).BGBSaveState.this.s_ch1[83] & 1) << 6;
                    }

                    @Override
                    public int getRegNR43() {
                        return (this).BGBSaveState.this.s_st1[21];
                    }

                    @Override
                    public int getRegNR42() {
                        return (this).BGBSaveState.this.s_ch1[85];
                    }

                    @Override
                    public int getRegNR41() {
                        return (this).BGBSaveState.this.s_ch1[84];
                    }

                    @Override
                    public int getRegNR34() {
                        return (this).BGBSaveState.this.s_ch1[57];
                    }

                    @Override
                    public int getRegNR33() {
                        return (this).BGBSaveState.this.s_ch1[56];
                    }

                    @Override
                    public int getRegNR32() {
                        return (this).BGBSaveState.this.s_ch1[75];
                    }

                    @Override
                    public int getRegNR31() {
                        return (this).BGBSaveState.this.s_ch1[74];
                    }

                    @Override
                    public int getRegNR30() {
                        return ((this).BGBSaveState.this.s_st1[26] & 1) << 7;
                    }

                    @Override
                    public int getRegNR24() {
                        return (this).BGBSaveState.this.s_ch1[35];
                    }

                    @Override
                    public int getRegNR23() {
                        return (this).BGBSaveState.this.s_ch1[34];
                    }

                    @Override
                    public int getRegNR22() {
                        return (this).BGBSaveState.this.s_ch1[41];
                    }

                    @Override
                    public int getRegNR21() {
                        return (this).BGBSaveState.this.s_ch1[40];
                    }

                    @Override
                    public int getRegNR14() {
                        return (this).BGBSaveState.this.s_ch1[13];
                    }

                    @Override
                    public int getRegNR13() {
                        return (this).BGBSaveState.this.s_ch1[12];
                    }

                    @Override
                    public int getRegNR12() {
                        return (this).BGBSaveState.this.s_ch1[19];
                    }

                    @Override
                    public int getRegNR11() {
                        return (this).BGBSaveState.this.s_ch1[18];
                    }

                    @Override
                    public int getRegNR10() {
                        return (this).BGBSaveState.this.s_st1[20];
                    }

                    @Override
                    public int getNoiseCounter() {
                        return 0;
                    }

                    @Override
                    public int getNoiseCounterOffset() {
                        return 0;
                    }

                    @Override
                    public boolean isNoiseCounterJustReloaded() {
                        return false;
                    }

                    @Override
                    public int getRegLinearFeedbackShift() {
                        return 0;
                    }

                    @Override
                    public int getPhase() {
                        return 0;
                    }

                    @Override
                    public int getOutput(int n) {
                        return 0;
                    }

                    @Override
                    public int getGeneratorPhase(int n) {
                        return 0;
                    }

                    @Override
                    public int getSweepCounter() {
                        return 0;
                    }

                    @Override
                    public int getSweepFrequency() {
                        return 0;
                    }

                    @Override
                    public int getSweepAddend() {
                        return 0;
                    }

                    @Override
                    public int getSweepRestartHold() {
                        return 0;
                    }

                    @Override
                    public boolean isSweepUnshifted() {
                        return false;
                    }

                    @Override
                    public GBSoundController.EnableState getEnableState() {
                        return GBSoundController.EnableState.ENABLED;
                    }

                    @Override
                    public int getDelayEnvelope(int n) {
                        return 0;
                    }

                    @Override
                    public boolean isEnvelopeCanClock(int n) {
                        return false;
                    }

                    @Override
                    public int getCounter(int n) {
                        return 0;
                    }

                    @Override
                    public int getSamples(int n) {
                        return 0;
                    }
                };
            }

            @Override
            public int getSerialCounter() {
                return 0;
            }

            @Override
            public boolean[] getWRamInitialized() {
                return BGBSaveState.this.wramInitialized;
            }

            @Override
            public boolean[] getHRamInitialized() {
                return BGBSaveState.this.hramInitialized;
            }

            @Override
            public int getRegSVBK() {
                return BGBSaveState.this.svbk;
            }

            @Override
            public GBLCDController.State getLCDstate() {
                return new GBLCDController.UnmodifiableState(){

                    @Override
                    public GBLCDController.State clone() {
                        return this;
                    }

                    @Override
                    public boolean isMode3lastCycles() {
                        return false;
                    }

                    @Override
                    public boolean isLineMainPart() {
                        return (this.getRegSTAT() & 3) == 0;
                    }

                    @Override
                    public boolean isLineLastCycle() {
                        return false;
                    }

                    @Override
                    public boolean isFirstFrame() {
                        return false;
                    }

                    @Override
                    public boolean isHdmaReady() {
                        return false;
                    }

                    @Override
                    public boolean isWySatisfied() {
                        return false;
                    }

                    @Override
                    public int getWindowLine() {
                        return 0;
                    }

                    @Override
                    public int[] getVram() {
                        return (this).BGBSaveState.this.vram;
                    }

                    @Override
                    public int getTimer() {
                        return (this).BGBSaveState.this.vidTime * 2;
                    }

                    @Override
                    public int getRegWY() {
                        return (this).BGBSaveState.this.winy;
                    }

                    @Override
                    public int getRegWX() {
                        return (this).BGBSaveState.this.winx;
                    }

                    @Override
                    public int getRegVBK() {
                        return (this).BGBSaveState.this.vbk;
                    }

                    @Override
                    public int getRegSTAT() {
                        return (this).BGBSaveState.this.stat;
                    }

                    @Override
                    public int getRegSCY() {
                        return (this).BGBSaveState.this.scy;
                    }

                    @Override
                    public int getRegSCX() {
                        return (this).BGBSaveState.this.scx;
                    }

                    @Override
                    public int getRegOPRI() {
                        return 0;
                    }

                    @Override
                    public int getRegOBPI() {
                        return (this).BGBSaveState.this.ocps;
                    }

                    @Override
                    public int getRegOBP1() {
                        return (this).BGBSaveState.this.obp1;
                    }

                    @Override
                    public int getRegOBP0() {
                        return (this).BGBSaveState.this.obp0;
                    }

                    @Override
                    public int getRegLYC() {
                        return (this).BGBSaveState.this.lyc;
                    }

                    @Override
                    public int getRegLY() {
                        return (this).BGBSaveState.this.ly;
                    }

                    @Override
                    public int getRegLCDC() {
                        return (this).BGBSaveState.this.lcdc;
                    }

                    @Override
                    public int getRegHDMA5() {
                        return (this).BGBSaveState.this.hdma5;
                    }

                    @Override
                    public int getRegHDMA4() {
                        return (this).BGBSaveState.this.hdma4;
                    }

                    @Override
                    public int getRegHDMA3() {
                        return (this).BGBSaveState.this.hdma3;
                    }

                    @Override
                    public int getRegHDMA2() {
                        return (this).BGBSaveState.this.hdma2;
                    }

                    @Override
                    public int getRegHDMA1() {
                        return (this).BGBSaveState.this.hdma1;
                    }

                    @Override
                    public int getRegDMA() {
                        return (this).BGBSaveState.this.dma;
                    }

                    @Override
                    public int getRegBGPI() {
                        return (this).BGBSaveState.this.bcps;
                    }

                    @Override
                    public int getRegBGP() {
                        return (this).BGBSaveState.this.bgp;
                    }

                    @Override
                    public int[] getOam() {
                        return (this).BGBSaveState.this.oam;
                    }

                    @Override
                    public boolean hasCGBpalettes() {
                        return (this).BGBSaveState.this.cpal != null;
                    }

                    @Override
                    public long getOBP(int n) {
                        if ((this).BGBSaveState.this.cpal == null || (n += 8) * 8 + 7 >= (this).BGBSaveState.this.cpal.length) {
                            return 0L;
                        }
                        return (long)(this).BGBSaveState.this.cpal[n * 8 + 7] << 56 | (long)(this).BGBSaveState.this.cpal[n * 8 + 6] << 48 | (long)(this).BGBSaveState.this.cpal[n * 8 + 5] << 40 | (long)(this).BGBSaveState.this.cpal[n * 8 + 4] << 32 | (long)(this).BGBSaveState.this.cpal[n * 8 + 3] << 24 | (long)(this).BGBSaveState.this.cpal[n * 8 + 2] << 16 | (long)(this).BGBSaveState.this.cpal[n * 8 + 1] << 8 | (long)(this).BGBSaveState.this.cpal[n * 8];
                    }

                    @Override
                    public int getMode3additionalTime() {
                        return 0;
                    }

                    @Override
                    public int getMode() {
                        return (this).BGBSaveState.this.gbcMode ? 128 : 4;
                    }

                    @Override
                    public int getLine153cycles() {
                        return 0;
                    }

                    @Override
                    public long getBGP(int n) {
                        if ((this).BGBSaveState.this.cpal == null || n * 8 + 7 >= (this).BGBSaveState.this.cpal.length) {
                            return 0L;
                        }
                        return (long)(this).BGBSaveState.this.cpal[n * 8 + 7] << 56 | (long)(this).BGBSaveState.this.cpal[n * 8 + 6] << 48 | (long)(this).BGBSaveState.this.cpal[n * 8 + 5] << 40 | (long)(this).BGBSaveState.this.cpal[n * 8 + 4] << 32 | (long)(this).BGBSaveState.this.cpal[n * 8 + 3] << 24 | (long)(this).BGBSaveState.this.cpal[n * 8 + 2] << 16 | (long)(this).BGBSaveState.this.cpal[n * 8 + 1] << 8 | (long)(this).BGBSaveState.this.cpal[n * 8];
                    }
                };
            }

            @Override
            public int[] getHRam() {
                int[] nArray = new int[256];
                BGBSaveState.this.collectMemoryMapped(nArray);
                nArray[255] = BGBSaveState.this.ie;
                System.arraycopy(BGBSaveState.this.hram, 0, nArray, 128, BGBSaveState.this.hram.length);
                return nArray;
            }

            @Override
            public int getCounter() {
                return (BGBSaveState.this.gbcMode && (BGBSaveState.this.key1 & 0x80) != 0 ? BGBSaveState.this.divider << 2 : BGBSaveState.this.divider << 1) & 0xFFFF;
            }

            @Override
            public GBCartridge.State getCartridgeState() {
                return BGBSaveState.this.makeCartridgeState();
            }

            @Override
            public LR35902.State getCPUstate() {
                return new LR35902.UnmodifiableState(){

                    @Override
                    public LR35902.State clone() {
                        return this;
                    }

                    @Override
                    public boolean isSkip() {
                        return (this).BGBSaveState.this.cpuQuirk;
                    }

                    @Override
                    public boolean isJustHalted() {
                        return false;
                    }

                    @Override
                    public boolean isHalted() {
                        return (this).BGBSaveState.this.halted;
                    }

                    @Override
                    public boolean isLockedUp() {
                        return false;
                    }

                    @Override
                    public boolean isFlagIME() {
                        return (this).BGBSaveState.this.ime;
                    }

                    @Override
                    public boolean isAfterEI() {
                        return false;
                    }

                    @Override
                    public int getRegPC() {
                        return (this).BGBSaveState.this.pc;
                    }

                    @Override
                    public int getRegAF() {
                        return (this).BGBSaveState.this.af;
                    }

                    @Override
                    public int getRegBC() {
                        return (this).BGBSaveState.this.bc;
                    }

                    @Override
                    public int getRegDE() {
                        return (this).BGBSaveState.this.de;
                    }

                    @Override
                    public int getRegHL() {
                        return (this).BGBSaveState.this.hl;
                    }

                    @Override
                    public int getRegSP() {
                        return (this).BGBSaveState.this.sp;
                    }

                    @Override
                    public int getCycleCount() {
                        return 0;
                    }
                };
            }
        };
    }

    public static /* bridge */ /* synthetic */ GBSaveState from(File file, File file2) throws IOException {
        return BGBSaveState.from(file, file2);
    }
}

