/*
 * Decompiled with CFR 0.152.
 */
package sdcc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import sdcc.cdb.FunctionRecord;
import sdcc.cdb.LinkerRecord;
import sdcc.cdb.ModuleRecord;
import sdcc.cdb.Record;
import sdcc.cdb.SymbolRecord;
import sdcc.cdb.TypeRecord;

public class CDBParser {
    private static Record parseRecord(String string) {
        if (string.isEmpty()) {
            return null;
        }
        if (string.length() < 2 || string.charAt(1) != ':') {
            System.err.println("Invalid line in CDB file: " + string);
            return null;
        }
        switch (string.charAt(0)) {
            case 'M': {
                return ModuleRecord.from(string.substring(2));
            }
            case 'F': {
                return FunctionRecord.from(string.substring(2));
            }
            case 'S': {
                return SymbolRecord.from(string.substring(2));
            }
            case 'T': {
                return TypeRecord.from(string.substring(2));
            }
            case 'L': {
                return LinkerRecord.from(string.substring(2));
            }
        }
        System.out.println("Unknown record in CDB file: " + string);
        return null;
    }

    public static List<Record> parse(File file) throws FileNotFoundException, IOException {
        return CDBParser.parse(new FileInputStream(file));
    }

    public static List<Record> parse(InputStream inputStream) throws IOException {
        return CDBParser.parse(new InputStreamReader(inputStream));
    }

    public static List<Record> parse(Reader reader) throws IOException {
        ArrayList<Record> arrayList = new ArrayList<Record>();
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String string = bufferedReader.readLine();
        while (string != null) {
            arrayList.add(CDBParser.parseRecord(string));
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return arrayList;
    }

    public static String nextToken(String string, char c) {
        int n = string.indexOf(c);
        return string.substring(0, Math.min(string.length(), n & 0xFFFF));
    }
}

