/*
 * Decompiled with CFR 0.152.
 */
package platform.plotting;

import java.util.Arrays;
import plotting.AbstractPlotModel;
import util.queue.CyclicIntBuffer;

public class DynamicPlotModel
extends AbstractPlotModel {
    private CyclicIntBuffer[] yData = new CyclicIntBuffer[0];
    private CyclicIntBuffer[] xData = new CyclicIntBuffer[0];
    private Integer[] yTypes = new Integer[0];
    private Integer[] xTypes = new Integer[0];

    public DynamicPlotModel(CyclicIntBuffer cyclicIntBuffer) {
        this(cyclicIntBuffer, null, null, null);
    }

    public DynamicPlotModel(CyclicIntBuffer cyclicIntBuffer, Integer n) {
        this(cyclicIntBuffer, n, null, null);
    }

    public DynamicPlotModel(CyclicIntBuffer cyclicIntBuffer, CyclicIntBuffer cyclicIntBuffer2) {
        this(cyclicIntBuffer, null, cyclicIntBuffer2, null);
    }

    public DynamicPlotModel(CyclicIntBuffer cyclicIntBuffer, Integer n, CyclicIntBuffer cyclicIntBuffer2, Integer n2) {
        this.yData = Arrays.copyOf(this.yData, this.yData.length + 1);
        this.yData[this.yData.length - 1] = cyclicIntBuffer;
        this.yTypes = Arrays.copyOf(this.yTypes, this.yTypes.length + 1);
        this.yTypes[this.yTypes.length - 1] = n;
        this.xData = Arrays.copyOf(this.xData, this.xData.length + 1);
        this.xData[this.xData.length - 1] = cyclicIntBuffer2;
        this.xTypes = Arrays.copyOf(this.xTypes, this.xTypes.length + 1);
        this.xTypes[this.xTypes.length - 1] = n2;
    }

    public void add(CyclicIntBuffer cyclicIntBuffer) {
        this.add(cyclicIntBuffer, null, null, null);
    }

    public void add(CyclicIntBuffer cyclicIntBuffer, Integer n) {
        this.add(cyclicIntBuffer, n, null, null);
    }

    public void add(CyclicIntBuffer cyclicIntBuffer, CyclicIntBuffer cyclicIntBuffer2) {
        this.add(cyclicIntBuffer, null, cyclicIntBuffer2, null);
    }

    public void add(CyclicIntBuffer cyclicIntBuffer, Integer n, CyclicIntBuffer cyclicIntBuffer2, Integer n2) {
        this.yData = Arrays.copyOf(this.yData, this.yData.length + 1);
        this.yData[this.yData.length - 1] = cyclicIntBuffer;
        this.yTypes = Arrays.copyOf(this.yTypes, this.yTypes.length + 1);
        this.yTypes[this.yTypes.length - 1] = n;
        this.xData = Arrays.copyOf(this.xData, this.xData.length + 1);
        this.xData[this.xData.length - 1] = cyclicIntBuffer2;
        this.xTypes = Arrays.copyOf(this.xTypes, this.xTypes.length + 1);
        this.xTypes[this.xTypes.length - 1] = n2;
        this.firePlotModelChanged();
    }

    public void set(int n, CyclicIntBuffer cyclicIntBuffer) {
        this.yData[n] = cyclicIntBuffer;
        this.firePlotModelChanged();
    }

    public void set(int n, CyclicIntBuffer cyclicIntBuffer, Integer n2) {
        this.yData[n] = cyclicIntBuffer;
        this.yTypes[n] = n2;
        this.firePlotModelChanged();
    }

    public void set(int n, CyclicIntBuffer cyclicIntBuffer, CyclicIntBuffer cyclicIntBuffer2) {
        this.yData[n] = cyclicIntBuffer;
        this.xData[n] = cyclicIntBuffer2;
        this.firePlotModelChanged();
    }

    public void set(int n, CyclicIntBuffer cyclicIntBuffer, Integer n2, CyclicIntBuffer cyclicIntBuffer2, Integer n3) {
        this.yData[n] = cyclicIntBuffer;
        this.yTypes[n] = n2;
        this.xData[n] = cyclicIntBuffer2;
        this.xTypes[n] = n3;
        this.firePlotModelChanged();
    }

    public void setY(int n, CyclicIntBuffer cyclicIntBuffer) {
        this.yData[n] = cyclicIntBuffer;
        this.firePlotModelChanged();
    }

    public void setYtype(int n, int n2) {
        this.yTypes[n] = n2;
        this.firePlotModelChanged();
    }

    public void setX(int n, CyclicIntBuffer cyclicIntBuffer) {
        this.xData[n] = cyclicIntBuffer;
        this.firePlotModelChanged();
    }

    public void setXtype(int n, int n2) {
        this.xTypes[n] = n2;
        this.firePlotModelChanged();
    }

    @Override
    public int getDataCount() {
        return this.yData.length;
    }

    @Override
    public int getValueCount(int n) {
        CyclicIntBuffer cyclicIntBuffer = this.yData[n];
        if (cyclicIntBuffer != null) {
            return cyclicIntBuffer.size();
        }
        CyclicIntBuffer cyclicIntBuffer2 = this.xData[n];
        if (cyclicIntBuffer2 != null) {
            return cyclicIntBuffer2.size();
        }
        return 0;
    }

    @Override
    public double getX(int n, int n2) {
        CyclicIntBuffer cyclicIntBuffer = this.xData[n];
        if (cyclicIntBuffer == null) {
            return n2;
        }
        return DynamicPlotModel.asType(cyclicIntBuffer.get(n2), this.xTypes[n]);
    }

    @Override
    public double getY(int n, int n2) {
        CyclicIntBuffer cyclicIntBuffer = this.yData[n];
        if (cyclicIntBuffer == null) {
            return n2;
        }
        return DynamicPlotModel.asType(cyclicIntBuffer.get(n2), this.yTypes[n]);
    }

    private static int asType(int n, Integer n2) {
        int n3 = n2 == null ? 129 : n2;
        switch (n3) {
            case 1: {
                return n & 0xFF;
            }
            case 2: {
                return n & 0xFFFF;
            }
            case 129: {
                return (byte)n;
            }
            case 130: {
                return (short)n;
            }
        }
        return n;
    }
}

