/*
 * Decompiled with CFR 0.152.
 */
package platform.plotting;

import java.util.ArrayList;
import plotting.AbstractPlotModel;

public class ArrayPlotModel
extends AbstractPlotModel {
    private int[] data;
    private final ArrayList<Integer> starts = new ArrayList();
    private final ArrayList<Integer> ends = new ArrayList();
    private final ArrayList<Integer> stepSizes = new ArrayList();
    private final ArrayList<Integer> dataTypes = new ArrayList();

    public ArrayPlotModel(int[] nArray) {
        this.setData(nArray);
    }

    public void setData(int[] nArray) {
        this.data = nArray;
    }

    public void add(Integer n, Integer n2) {
        this.add(n, n2, null, null);
    }

    private void add(Integer n, Integer n2, Integer n3, Integer n4) {
        this.starts.add(n);
        this.ends.add(n2);
        this.stepSizes.add(n3);
        this.dataTypes.add(n4);
        this.firePlotModelChanged();
    }

    public void removeLast() {
        this.remove(this.starts.size() - 1);
    }

    public void remove(int n) {
        this.starts.remove(n);
        this.ends.remove(n);
        this.stepSizes.remove(n);
        this.dataTypes.remove(n);
        this.firePlotModelChanged();
    }

    public void setStart(int n, int n2) {
        this.starts.set(n, n2);
        this.firePlotModelChanged();
    }

    public void setEnd(int n, int n2) {
        this.ends.set(n, n2);
        this.firePlotModelChanged();
    }

    public void setStepSize(int n, int n2) {
        this.stepSizes.set(n, n2);
        this.firePlotModelChanged();
    }

    public void setDataType(int n, int n2) {
        this.dataTypes.set(n, n2);
        this.firePlotModelChanged();
    }

    @Override
    public int getDataCount() {
        return this.starts.size();
    }

    @Override
    public int getValueCount(int n) {
        return (this.getEnd(n) - this.getStart(n) + 1 - 1) / this.getStepSize(n) + 1;
    }

    @Override
    public double getX(int n, int n2) {
        return this.getStart(0) + n2 * this.getStepSize(n);
    }

    @Override
    public double getY(int n, int n2) {
        int n3 = this.getStart(n) + n2 * this.getStepSize(n);
        int n4 = this.data[n3];
        if (this.getDataSize(n) >= 2) {
            n4 |= this.data[n3 + 1] << 8;
        }
        return ArrayPlotModel.asType(n4, this.getDataType(n));
    }

    private int getStart(int n) {
        Integer n2 = this.starts.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    private int getEnd(int n) {
        Integer n2 = this.ends.get(n);
        if (n2 == null) {
            return this.getStart(n);
        }
        return n2;
    }

    private int getStepSize(int n) {
        Integer n2 = this.stepSizes.get(n);
        if (n2 == null) {
            return this.getDataSize(n);
        }
        return Math.max(n2 * this.getDataSize(n), 1);
    }

    private int getDataSize(int n) {
        return this.getDataType(n) & 0x7F;
    }

    private int getDataType(int n) {
        Integer n2 = this.dataTypes.get(n);
        if (n2 == null) {
            return 129;
        }
        return n2;
    }

    private static int asType(int n, int n2) {
        switch (n2) {
            case 1: {
                return n & 0xFF;
            }
            case 2: {
                return n & 0xFFFF;
            }
            case 129: {
                return (byte)n;
            }
            case 130: {
                return (short)n;
            }
        }
        return n;
    }
}

