/*
 * Decompiled with CFR 0.152.
 */
package platform;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import platform.DisplayWindow;
import platform.SoundRecorder;

public final class VideoRecorder {
    private static VideoRecorder instance;
    private DisplayWindow displayWindow;
    private String pathToFFMPEG;
    private File romFile;
    private Process recorderProcess;
    private Thread encoderThread;
    private Process encodingProcess;

    private VideoRecorder() {
    }

    public static VideoRecorder getInstance() {
        if (instance == null) {
            instance = new VideoRecorder();
        }
        return instance;
    }

    public static boolean isRecording() {
        return instance != null && VideoRecorder.instance.displayWindow != null;
    }

    public static boolean isEncoding() {
        return instance != null && VideoRecorder.instance.encoderThread != null;
    }

    public static boolean hasTempFiles(File file) {
        File file2 = new File(file, "temp.mp4");
        File file3 = new File(file, "temp.wav");
        return file2.exists() && file3.exists();
    }

    public static boolean canConcatVideos(File file, File file2) {
        String string = "";
        int n = 0;
        while (n <= 1 && new File(file2, String.valueOf(file.getName()) + string + ".mp4").exists()) {
            string = "_" + ++n;
        }
        return n > 1;
    }

    public void startRecording(DisplayWindow displayWindow, File file, Settings settings, int n, String string) throws IOException {
        if (string != null && this.encoderThread == null) {
            File file2 = settings.getDestinationFolder();
            int n2 = settings.getRecordingCompression();
            this.romFile = file;
            this.pathToFFMPEG = string;
            Dimension dimension = displayWindow.getScreenSize(1.0f, settings.isCropBorders());
            String[] stringArray = n2 != 1 ? new String[]{string, "-y", "-f", "rawvideo", "-pixel_format", "rgb24", "-video_size", String.valueOf(dimension.width) + "x" + dimension.height, "-framerate", Integer.toString(n), "-loglevel", "warning", "-i", "pipe:0", "-qp", "0", "-preset", (new String[]{"ultrafast", "medium", "veryslow"})[n2], "-movflags", "+faststart", new File(file2, "temp.mp4").getPath()} : new String[]{string, "-y", "-f", "rawvideo", "-pixel_format", "rgb24", "-video_size", String.valueOf(dimension.width) + "x" + dimension.height, "-framerate", Integer.toString(n), "-loglevel", "warning", "-i", "pipe:0", "-qp", "0", "-movflags", "+faststart", new File(file2, "temp.mp4").getPath()};
            this.recorderProcess = VideoRecorder.launchFFMPEG(stringArray, System.err);
            SoundRecorder soundRecorder = SoundRecorder.getInstance();
            soundRecorder.stopRecording();
            soundRecorder.startRecording(file2, new File("temp"), new boolean[]{true}, true);
            this.displayWindow = displayWindow;
            displayWindow.setScreenRecorderStream(this.recorderProcess.getOutputStream(), settings.isCropBorders());
            return;
        }
    }

    private static void addParameter(List<String> list, String string, int n) {
        VideoRecorder.addParameter(list, string, Integer.toString(n));
    }

    private static void addParameter(List<String> list, String string, String string2) {
        list.add(string);
        list.add(string2);
    }

    public void stopRecording(Settings settings, OutputStream outputStream, Runnable runnable, ProgressListener progressListener) {
        if (this.displayWindow != null && this.encoderThread == null) {
            SoundRecorder.getInstance().stopRecording();
            this.displayWindow.setScreenRecorderStream(null, true);
            this.displayWindow = null;
            this.encodeRecording(this.romFile, settings, outputStream, runnable, progressListener, this.pathToFFMPEG);
        }
    }

    public void encodeRecording(final File file, Settings settings, final OutputStream outputStream, final Runnable runnable, final ProgressListener progressListener, final String string) {
        if (this.displayWindow == null && this.encoderThread == null) {
            final File file2 = settings.getDestinationFolder();
            final float f = settings.getScale();
            final int n = settings.getThreads();
            final float f2 = settings.getPixelAspectRatio();
            final boolean bl = settings.isUseYUV420pColorSpace();
            final String string2 = settings.getEncodingPreset();
            final int n2 = settings.getCRF();
            final String string3 = settings.getAudioCodec();
            this.encoderThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (VideoRecorder.this.recorderProcess != null) {
                        try {
                            VideoRecorder.this.recorderProcess.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    VideoRecorder.this.recorderProcess = null;
                    File file3 = new File(file2, "temp.mp4");
                    File file22 = new File(file2, "temp.wav");
                    String string4 = "";
                    int n3 = 0;
                    while (new File(file2, String.valueOf(file.getName()) + string4 + ".mp4").exists()) {
                        string4 = "_" + ++n3;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    arrayList.add("-y");
                    VideoRecorder.addParameter((List<String>)arrayList, "-i", file3.getPath());
                    VideoRecorder.addParameter((List<String>)arrayList, "-i", file22.getPath());
                    VideoRecorder.addParameter((List<String>)arrayList, "-loglevel", "error");
                    VideoRecorder.addParameter((List<String>)arrayList, "-c:a", string3);
                    if (n >= 0) {
                        VideoRecorder.addParameter((List<String>)arrayList, "-threads", n);
                    }
                    if (Math.abs(f - 1.0f) < 0.01f && Math.abs(f2) - 1.0f < 0.01f && !bl) {
                        VideoRecorder.addParameter((List<String>)arrayList, "-c:v", "copy");
                    } else if (Math.abs(f - 1.0f) < 0.01f && bl) {
                        VideoRecorder.addParameter((List<String>)arrayList, "-vf", "format=yuv420p");
                    } else {
                        VideoRecorder.addParameter((List<String>)arrayList, "-vf", "scale=iw*" + f * f2 + ":ih*" + f + ":flags=neighbor" + (bl ? ",format=yuv420p" : ""));
                    }
                    if (!"medium".equals(string2)) {
                        VideoRecorder.addParameter((List<String>)arrayList, "-preset", string2);
                    }
                    VideoRecorder.addParameter((List<String>)arrayList, "-crf", n2);
                    VideoRecorder.addParameter((List<String>)arrayList, "-progress", "pipe:1");
                    VideoRecorder.addParameter((List<String>)arrayList, "-strict", "experimental");
                    arrayList.add("-movflags");
                    arrayList.add("+faststart");
                    arrayList.add(new File(file2, String.valueOf(file.getName()) + string4 + ".mp4").getPath());
                    Process process = null;
                    try {
                        process = VideoRecorder.launchFFMPEG(arrayList, outputStream, progressListener);
                        VideoRecorder.this.encodingProcess = process;
                    }
                    catch (IOException iOException) {
                        VideoRecorder.this.encoderThread = null;
                        iOException.printStackTrace();
                    }
                    if (process != null) {
                        try {
                            int n22 = process.waitFor();
                            VideoRecorder.this.encoderThread = null;
                            if (n22 != 0) {
                                runnable.run();
                                return;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            VideoRecorder.this.encoderThread = null;
                            return;
                        }
                        file3.delete();
                        file22.delete();
                        VideoRecorder.this.encoderThread = null;
                        if (progressListener != null) {
                            progressListener.progressUpdate("progress", "");
                        }
                    }
                }
            }, "FFMPEG encoder");
            this.encoderThread.start();
        }
    }

    public static void concatVideos(File file, File file2, OutputStream outputStream, Runnable runnable, String string) {
        if (VideoRecorder.canConcatVideos(file, file2)) {
            PrintStream printStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
            File file3 = new File(file2, "concat.txt");
            try {
                PrintStream printStream2 = new PrintStream(new BufferedOutputStream(new FileOutputStream(file3)));
                String string2 = "";
                int n = 0;
                while (new File(file2, String.valueOf(file.getName()) + string2 + ".mp4").exists()) {
                    printStream2.println("file '" + new File(file2, String.valueOf(file.getName()) + string2 + ".mp4").getName() + "'");
                    string2 = "_" + ++n;
                }
                printStream2.close();
                string2 = "";
                n = 0;
                while (new File(file2, String.valueOf(file.getName()) + "_concat" + string2 + ".mp4").exists()) {
                    printStream2.println(new File(file2, String.valueOf(file.getName()) + "_concat" + string2 + ".mp4").getName());
                    string2 = "_" + ++n;
                }
                Process process = VideoRecorder.launchFFMPEG(new String[]{string, "-f", "concat", "-loglevel", "error", "-safe", "0", "-i", file3.getPath(), "-c", "copy", new File(file2, String.valueOf(file.getName()) + "_concat" + string2 + ".mp4").getPath()}, outputStream);
                try {
                    if (process.waitFor() != 0) {
                        runnable.run();
                    }
                    file3.delete();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(printStream);
            }
        }
    }

    private static Process launchFFMPEG(List<String> list, OutputStream outputStream, ProgressListener progressListener) throws IOException {
        return VideoRecorder.launchFFMPEG(list.toArray(new String[list.size()]), outputStream, progressListener);
    }

    private static Process launchFFMPEG(String[] stringArray, OutputStream outputStream) throws IOException {
        return VideoRecorder.launchFFMPEG(stringArray, outputStream, null);
    }

    private static Process launchFFMPEG(String[] stringArray, final OutputStream outputStream, final ProgressListener progressListener) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        final Process process = processBuilder.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PrintStream printStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        printStream.println(string);
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, "FFMPEG stderr reader").start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    if (progressListener != null) {
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            int n = string.indexOf(61);
                            if (n >= 0) {
                                progressListener.progressUpdate(string.substring(0, n), string.substring(n + 1));
                            }
                            string = bufferedReader.readLine();
                        }
                    } else {
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            System.out.println(string);
                            string = bufferedReader.readLine();
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, "FFMPEG stdin reader").start();
        return process;
    }

    public void cancelEncoding() {
        if (this.encodingProcess != null) {
            this.encodingProcess.destroy();
        }
    }

    public static interface ProgressListener {
        public void progressUpdate(String var1, String var2);
    }

    public static interface Settings {
        public File getDestinationFolder();

        public int getRecordingCompression();

        public float getScale();

        public int getThreads();

        public float getPixelAspectRatio();

        public String getEncodingPreset();

        public int getCRF();

        public String getAudioCodec();

        public boolean isCropBorders();

        public boolean isUseYUV420pColorSpace();
    }
}

