/*
 * Decompiled with CFR 0.152.
 */
package platform;

import common.CompatiblePixelBuffer;
import common.IntPixelBuffer;
import common.PixelBuffer;
import components.input.PointerInputProvider;
import components.input.SMSLightPhaser;
import java.awt.AlphaComposite;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import overlays.OverlayModel;
import platform.DisplayWindowOverlayModel;
import platform.MouseInput;

public final class DisplayWindow
extends Canvas {
    public static final int COLOR_WHITE = Color.WHITE.getRGB() & 0xFFFFFF;
    public static final int COLOR_LIGHT_GRAY = Color.LIGHT_GRAY.getRGB() & 0xFFFFFF;
    public static final int COLOR_GRAY = Color.GRAY.getRGB() & 0xFFFFFF;
    public static final int COLOR_DARK_GRAY = Color.DARK_GRAY.getRGB() & 0xFFFFFF;
    public static final int COLOR_BLACK = Color.BLACK.getRGB() & 0xFFFFFF;
    private Cursor invisibleCursor;
    private int width;
    private int height;
    private int viewportX;
    private int viewportY;
    private int viewportW;
    private int viewportH;
    private int pixelsLeftBorder;
    private int pixelsTopBorder;
    private int borderWidth;
    private int borderHeight;
    private PixelBuffer pixelBuffer;
    private int[] scanlinesPixels;
    private int cursor;
    private boolean filterEnabled;
    private boolean scanlines;
    private int frameskip;
    private int framesToSkip;
    private float scale;
    private float desiredScale = 1.0f;
    private float pixelAspectRatio = 1.0f;
    private boolean stretch;
    private boolean integerScaling;
    private boolean frameBlendingDisabled;
    private boolean wasBlend;
    private boolean freezeImage;
    private int frames;
    private BufferStrategy buffer;
    private BufferedImage backBuffer;
    private BufferedImage prevBackBuffer;
    private BufferedImage blendBackBuffer;
    private BufferedImage scanlinesBackBuffer;
    private boolean hardwareAccelerated;
    private final PointerInputProvider[] crosshair = new PointerInputProvider[2];
    private final int[] crosshairRadius = new int[2];
    private boolean hasSelectionCursor;
    private int selectionCursorX;
    private int selectionCursorY;
    private int selectionCursorW;
    private int selectionCursorH;
    private long lastFrameMillis;
    private OutputStream screenRecorderStream;
    private BufferedImage screenRecorderImage;
    private int recordedScreens;
    private boolean screenRecorderCropBorders;
    private volatile boolean recordingScreen = false;
    private DisplayWindowOverlayModel overlays;

    public DisplayWindow() {
        this.setFocusable(false);
        this.setBackground(Color.BLACK);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferCapabilities bufferCapabilities = graphicsConfiguration.getBufferCapabilities();
        this.hardwareAccelerated = bufferCapabilities.isPageFlipping() && !bufferCapabilities.isFullScreenRequired();
    }

    public void init(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.freezeImage = false;
        this.setBorders(0, 0, 0, 0);
        this.viewportX = 0;
        this.viewportY = 0;
        this.viewportW = n;
        this.viewportH = n2;
        if (this.scale < 1.0f) {
            this.scale = 1.0f;
        }
        this.pack();
        if (this.isDisplayable()) {
            this.createBufferStrategy(2);
            this.buffer = this.getBufferStrategy();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        this.backBuffer = graphicsConfiguration.createCompatibleImage(n, n2, 1);
        this.pixelBuffer = DisplayWindow.createPixelBuffer(this.backBuffer);
    }

    private static PixelBuffer createPixelBuffer(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            return new IntPixelBuffer((DataBufferInt)dataBuffer);
        }
        return new CompatiblePixelBuffer(bufferedImage);
    }

    public void setBorders(int n, int n2, int n3, int n4) {
        this.pixelsLeftBorder = n;
        this.pixelsTopBorder = n2;
        this.borderWidth = n + n3;
        this.borderHeight = n2 + n4;
    }

    public boolean isHardwareAccelerated() {
        return this.hardwareAccelerated;
    }

    public void setLightPhaser(int n, SMSLightPhaser sMSLightPhaser, int n2) {
        this.crosshair[n] = sMSLightPhaser == null ? null : sMSLightPhaser.getPointerInputProvider();
        this.crosshairRadius[n] = n2;
        if (this.crosshair[0] instanceof MouseInput || this.crosshair[1] instanceof MouseInput) {
            this.setCursor(this.getInvisibleCursor());
        } else {
            this.setCursor(null);
        }
    }

    public void clearLightPhasers() {
        this.crosshair[0] = null;
        this.crosshair[1] = null;
        this.setCursor(null);
    }

    private Cursor getInvisibleCursor() {
        if (this.invisibleCursor == null) {
            this.invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), "Invisible");
        }
        return this.invisibleCursor;
    }

    public void setHideCursor(boolean bl) {
        if (bl) {
            this.setCursor(this.getInvisibleCursor());
        } else if (this.crosshair[0] == null && this.crosshair[1] == null) {
            this.setCursor(null);
        }
    }

    public void eraseSelectionCursor() {
        this.setSelectionCursor(-1, -1, 0, 0);
    }

    public void setSelectionCursor(int n, int n2, int n3, int n4) {
        if (n != this.selectionCursorX || n2 != this.selectionCursorY || n3 != this.selectionCursorW || n4 != this.selectionCursorH) {
            this.hasSelectionCursor = n3 > 0 && n4 > 0 && n + n3 > 0 && n2 + n4 > 0;
            this.selectionCursorX = this.viewportX + n;
            this.selectionCursorY = this.viewportY + n2;
            this.selectionCursorW = n3;
            this.selectionCursorH = n4;
            if (System.currentTimeMillis() - this.lastFrameMillis > 50L) {
                this.framesToSkip = 0;
                this.renderFrame(false);
                --this.frames;
            }
        }
    }

    public static int toPlatformColor(int n, int n2, int n3) {
        return n << 16 | n2 << 8 | n3;
    }

    public void setWidth(int n) {
        this.setDimensions(n, this.height);
    }

    public void setHeight(int n) {
        this.setDimensions(this.width, n);
    }

    public void setDimensions(int n, int n2) {
        if (this.width != n || this.height != n2) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.backBuffer = graphicsConfiguration.createCompatibleImage(n, n2, 1);
            this.pixelBuffer = DisplayWindow.createPixelBuffer(this.backBuffer);
            this.viewportW = n;
            this.width = n;
            this.viewportH = n2;
            this.height = n2;
            this.pack();
        }
    }

    public Dimension getScreenSize(float f, boolean bl) {
        int[] nArray = DisplayWindow.asFraction(f);
        int n = bl ? this.viewportW - this.borderWidth : this.viewportW;
        int n2 = bl ? this.viewportH - this.borderHeight : this.viewportH;
        return new Dimension(n * nArray[0], n2 * nArray[1]);
    }

    public int toScreenX(int n) {
        if (this.stretch) {
            return (int)((float)n / this.getScaleX() + (float)(this.viewportX - this.pixelsLeftBorder));
        }
        float f = this.getScale() * this.pixelAspectRatio;
        int n2 = (int)((float)this.width * f);
        int n3 = -((int)((float)(this.viewportX - this.pixelsLeftBorder) * f)) + (this.getWidth() - n2) / 2;
        return (int)((float)(n - n3) / f);
    }

    public int toScreenY(int n) {
        if (this.stretch) {
            return (int)((float)n / this.getScaleY() + (float)(this.viewportY - this.pixelsTopBorder));
        }
        int n2 = (int)((float)this.height * this.getScale());
        int n3 = -((int)((float)(this.viewportY - this.pixelsTopBorder) * this.getScale())) + (this.getHeight() - n2) / 2;
        return (int)((float)(n - n3) / this.getScale());
    }

    public int toWindowX(int n) {
        if (this.stretch) {
            return (int)((float)(n - (this.viewportX - this.pixelsLeftBorder)) * this.getScaleX());
        }
        float f = this.getScale() * this.pixelAspectRatio;
        int n2 = (int)((float)this.width * f);
        int n3 = -((int)((float)(this.viewportX - this.pixelsLeftBorder) * f)) + (this.getWidth() - n2) / 2;
        return (int)((float)n * f) + n3;
    }

    public int toWindowY(int n) {
        if (this.stretch) {
            return (int)((float)(n - (this.viewportY - this.pixelsTopBorder)) * this.getScaleY());
        }
        int n2 = (int)((float)this.height * this.getScale());
        int n3 = -((int)((float)(this.viewportY - this.pixelsTopBorder) * this.getScale())) + (this.getHeight() - n2) / 2;
        return (int)((float)n * this.getScale()) + n3;
    }

    private float getScaleX() {
        if (this.viewportW == 0) {
            return this.getScale();
        }
        if (this.integerScaling) {
            return (float)this.getWidth() / ((float)(this.viewportW - this.borderWidth) * this.pixelAspectRatio);
        }
        return (float)this.getWidth() / ((float)this.viewportW * this.pixelAspectRatio);
    }

    private float getScaleY() {
        if (this.viewportH == 0) {
            return this.getScale();
        }
        if (this.integerScaling) {
            return (float)this.getHeight() / (float)(this.viewportH - this.borderHeight);
        }
        return (float)this.getHeight() / (float)this.viewportH;
    }

    public boolean shouldSkipFrame() {
        return this.framesToSkip > 0;
    }

    public void setColor(int n, int n2, int n3) {
        this.setColorDirect(this.pixelsLeftBorder + n, this.pixelsTopBorder + n2, n3);
    }

    public void setColorDirect(int n, int n2, int n3) {
        this.cursor = n2 * this.width + n;
        this.pixelBuffer.setPixel(this.cursor, n3);
    }

    public int getColorDirect(int n, int n2) {
        return this.pixelBuffer.getPixel(n2 * this.width + n);
    }

    public void setNextColor(int n) {
        this.pixelBuffer.setPixel(++this.cursor, n);
    }

    public void skipNextColor() {
        ++this.cursor;
    }

    public void setCursor(int n, int n2) {
        this.setCursorDirect(this.pixelsLeftBorder + n, this.pixelsTopBorder + n2);
    }

    public void setCursorDirect(int n, int n2) {
        this.cursor = n + n2 * this.width - 1;
    }

    public void setColor(int n, int n2, int n3, int n4) {
        this.setColorDirect(this.pixelsLeftBorder + n, this.pixelsTopBorder + n2, n3, n4);
    }

    public void setColorDirect(int n, int n2, int n3, int n4) {
        this.cursor = n + n2 * this.width + n3;
        this.pixelBuffer.fill(n + n2 * this.width, this.cursor, n4);
        --this.cursor;
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.viewportX = n;
        this.viewportY = n2;
        this.viewportW = n3;
        this.viewportH = n4;
        this.pack();
    }

    public void fill(int n) {
        this.pixelBuffer.fill(n);
    }

    public void clear() {
        this.fill(0);
        this.repaint();
    }

    private static int darken(int n, double d) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return DisplayWindow.toPlatformColor((int)((double)n2 * d), (int)((double)n3 * d), (int)((double)n4 * d));
    }

    public void renderFrame(boolean bl) {
        if (this.framesToSkip <= 0) {
            int n;
            int n2;
            int n3;
            int n4;
            Object object;
            Object object2;
            if (this.viewportW <= 0 || this.viewportH <= 0) {
                return;
            }
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            if (this.frameBlendingDisabled) {
                bl = false;
            }
            BufferedImage bufferedImage = this.backBuffer;
            if (bl && this.frameskip <= 0) {
                if (this.blendBackBuffer == null || this.blendBackBuffer.getWidth() != this.backBuffer.getWidth() || this.blendBackBuffer.getHeight() != this.backBuffer.getHeight()) {
                    this.blendBackBuffer = graphicsConfiguration.createCompatibleImage(this.width, this.height, 1);
                }
                object2 = this.blendBackBuffer.createGraphics();
                ((Graphics2D)object2).setComposite(AlphaComposite.getInstance(5, 0.5f));
                ((Graphics)object2).drawImage(bufferedImage, 0, 0, null);
                ((Graphics2D)object2).setComposite(AlphaComposite.getInstance(3, 0.5f));
                ((Graphics)object2).drawImage(this.prevBackBuffer, 0, 0, null);
                ((Graphics)object2).dispose();
                if (this.wasBlend) {
                    bufferedImage = this.blendBackBuffer;
                }
            }
            if ((object2 = this.screenRecorderStream) != null) {
                boolean bl2 = this.screenRecorderCropBorders;
                this.recordingScreen = true;
                this.writeScreenToStream((OutputStream)object2, bl2);
                this.recordingScreen = false;
                if (this.screenRecorderStream != object2) {
                    this.closeRecorderStream((OutputStream)object2);
                }
            }
            this.wasBlend = bl && this.frameskip <= 0;
            float f = Math.min(this.getScaleX(), this.getScaleY());
            this.scale = this.scanlines && f > 1.0f ? (float)((int)f) : f;
            if (this.integerScaling) {
                this.scale = Math.max(1, (int)this.scale);
            }
            f = this.scale;
            int n5 = this.viewportY;
            int n6 = this.viewportH;
            if (this.scanlines && this.scale >= 2.0f) {
                object = this.pixelBuffer.getPixels();
                n4 = this.height;
                int[] nArray = object;
                this.scale = (int)this.scale;
                n3 = (int)this.scale;
                if (n3 >= 6) {
                    n3 = 5;
                }
                bufferedImage = this.scanlinesBackBuffer != null && this.scanlinesBackBuffer.getHeight() == n4 && this.scanlinesBackBuffer.getWidth() == this.width ? this.scanlinesBackBuffer : graphicsConfiguration.createCompatibleImage(this.width, n4 *= n3, 1);
                this.scanlinesBackBuffer = bufferedImage;
                nArray = this.scanlinesPixels != null && this.scanlinesPixels.length == n4 * this.width ? this.scanlinesPixels : new int[n4 * this.width];
                this.scanlinesPixels = nArray;
                n2 = 0;
                while (n2 < this.height) {
                    int n7;
                    int n8;
                    int n9;
                    n = n2 * this.width;
                    int n10 = n3 * n2 * this.width;
                    System.arraycopy(object, n, nArray, n10, this.width);
                    if (n3 >= 5) {
                        n9 = n10 + this.width;
                        n8 = n9 + this.width + this.width;
                        n7 = 0;
                        while (n7 < this.width) {
                            nArray[n9++] = DisplayWindow.darken((int)object[n], 0.8);
                            nArray[n8++] = DisplayWindow.darken((int)object[n], 0.6);
                            ++n7;
                            ++n;
                        }
                        System.arraycopy(nArray, n10 + this.width, nArray, n9, this.width);
                        System.arraycopy(nArray, n10 + 3 * this.width, nArray, n8, this.width);
                    } else if (n3 >= 4) {
                        n9 = n10 + this.width;
                        n8 = n9 + this.width + this.width;
                        n7 = 0;
                        while (n7 < this.width) {
                            nArray[n9++] = DisplayWindow.darken((int)object[n], 0.8);
                            nArray[n8++] = DisplayWindow.darken((int)object[n], 0.6);
                            ++n7;
                            ++n;
                        }
                        System.arraycopy(nArray, n10 + this.width, nArray, n9, this.width);
                    } else if (n3 >= 3) {
                        n9 = n10 + this.width;
                        n8 = n9 + this.width;
                        n7 = 0;
                        while (n7 < this.width) {
                            nArray[n9++] = DisplayWindow.darken((int)object[n], 0.8);
                            nArray[n8++] = DisplayWindow.darken((int)object[n], 0.6);
                            ++n7;
                            ++n;
                        }
                    } else if (n3 >= 2) {
                        n10 += this.width;
                        n9 = 0;
                        while (n9 < this.width) {
                            nArray[n10++] = DisplayWindow.darken((int)object[n++], 0.6666666666666666);
                            ++n9;
                        }
                    }
                    ++n2;
                }
                f /= (float)n3;
                n6 *= n3;
                n5 *= n3;
                System.arraycopy(nArray, 0, ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), 0, nArray.length);
            }
            if (this.crosshair[0] != null || this.crosshair[1] != null) {
                if (this.crosshair[0] != null && this.crosshair[0].isOnScreen()) {
                    object = bufferedImage.createGraphics();
                    n4 = this.crosshair[0].getX() + this.pixelsLeftBorder;
                    int n11 = this.crosshair[0].getY() + this.pixelsTopBorder;
                    ((Graphics)object).setColor(Color.WHITE);
                    ((Graphics)object).drawOval(n4 - this.crosshairRadius[0], (int)((float)(n11 - this.crosshairRadius[0]) * this.scale / f), this.crosshairRadius[0] * 2, (int)((float)(this.crosshairRadius[0] * 2) * this.scale / f));
                    ((Graphics)object).dispose();
                }
                if (this.crosshair[1] != null && this.crosshair[1].isOnScreen()) {
                    object = bufferedImage.createGraphics();
                    n4 = this.crosshair[1].getX() + this.pixelsLeftBorder;
                    int n12 = this.crosshair[1].getY() + this.pixelsTopBorder;
                    ((Graphics)object).setColor(Color.GREEN);
                    ((Graphics)object).drawOval(n4 - this.crosshairRadius[1], (int)((float)(n12 - this.crosshairRadius[1]) * this.scale / f), this.crosshairRadius[1] * 2, (int)((float)(this.crosshairRadius[1] * 2) * this.scale / f));
                    ((Graphics)object).dispose();
                }
            }
            if (this.buffer != null) {
                do {
                    object = this.buffer.getDrawGraphics();
                    if (this.isFilterEnabled() && this.isHardwareAccelerated()) {
                        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    }
                    float f2 = this.scale * this.pixelAspectRatio;
                    int n13 = (int)((float)this.viewportW * f2);
                    n3 = (int)((float)n6 * f);
                    n2 = (this.getWidth() - n13) / 2;
                    n = (this.getHeight() - n3) / 2;
                    ((Graphics)object).setColor(this.getBackground());
                    ((Graphics)object).fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.stretch) {
                        if (this.scanlines && this.scale >= 2.0f) {
                            ((Graphics)object).drawImage(bufferedImage, 0, n, this.getWidth(), n + n3, this.viewportX, n5, this.viewportX + this.viewportW, n5 + n6, null);
                        } else {
                            ((Graphics)object).drawImage(bufferedImage, 0, 0, this.getWidth(), this.getHeight(), this.viewportX, n5, this.viewportX + this.viewportW, n5 + n6, null);
                        }
                    } else {
                        ((Graphics)object).drawImage(bufferedImage, n2, n, n2 + n13, n + n3, this.viewportX, n5, this.viewportX + this.viewportW, n5 + n6, null);
                    }
                    if (this.hasSelectionCursor) {
                        ((Graphics)object).setXORMode(Color.WHITE);
                        ((Graphics)object).drawRect(this.toWindowX(this.selectionCursorX), this.toWindowY(this.selectionCursorY), (int)((float)this.selectionCursorW * (this.stretch ? this.getScaleX() : this.scale) * this.pixelAspectRatio), (int)((float)this.selectionCursorH * f));
                    }
                    this.renderOverlays((Graphics2D)object);
                    ((Graphics)object).dispose();
                } while (this.buffer.contentsRestored());
                if (bl && this.frameskip <= 0) {
                    if (this.prevBackBuffer == null || this.prevBackBuffer.getWidth() != this.backBuffer.getWidth() || this.prevBackBuffer.getHeight() != this.backBuffer.getHeight()) {
                        this.prevBackBuffer = graphicsConfiguration.createCompatibleImage(this.backBuffer.getWidth(), this.backBuffer.getHeight(), 1);
                    }
                    this.backBuffer.copyData(this.prevBackBuffer.getRaster());
                }
                if (!this.freezeImage && !this.buffer.contentsLost()) {
                    this.buffer.show();
                    Toolkit.getDefaultToolkit().sync();
                }
            }
            ++this.frames;
            this.framesToSkip = this.frameskip;
            this.lastFrameMillis = System.currentTimeMillis();
        } else {
            --this.framesToSkip;
        }
    }

    private void renderOverlays(Graphics2D graphics2D) {
        if (this.overlays == null) {
            return;
        }
        this.overlays.onBeforeRender();
        int n = this.overlays.getOverlayCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.overlays.isVisible(n2)) {
                int n3;
                int n4;
                int n5;
                int n6;
                graphics2D.setColor(this.overlays.getColor(n2));
                if (this.overlays.useWindowCoords(n2)) {
                    n6 = this.overlays.getX(n2);
                    n5 = this.overlays.getY(n2);
                    n4 = this.overlays.getWidth(n2);
                    n3 = this.overlays.getHeight(n2);
                } else {
                    n6 = this.toWindowX(this.overlays.getX(n2));
                    n5 = this.toWindowY(this.overlays.getY(n2));
                    n4 = this.toWindowX(this.overlays.getX(n2) + this.overlays.getWidth(n2)) - n6;
                    n3 = this.toWindowY(this.overlays.getY(n2) + this.overlays.getHeight(n2)) - n5;
                }
                graphics2D.setStroke(this.overlays.getStroke(n2));
                switch (this.overlays.getType(n2)) {
                    case ELLIPSE: {
                        if (this.overlays.isFill(n2)) {
                            graphics2D.fillOval(n6, n5, n4, n3);
                            break;
                        }
                        graphics2D.drawOval(n6, n5, n4, n3);
                        break;
                    }
                    case LINE: {
                        graphics2D.drawLine(n6, n5, n6 + n4, n5 + n3);
                        break;
                    }
                    case RECTANGLE: {
                        if (this.overlays.isFill(n2)) {
                            graphics2D.fillRect(n6, n5, n4, n3);
                            break;
                        }
                        graphics2D.drawRect(n6, n5, n4, n3);
                        break;
                    }
                    case TEXT: {
                        graphics2D.setFont(this.overlays.getFont(n2, graphics2D.getFont()));
                        graphics2D.drawString(this.overlays.getText(n2), n6, n5 + this.overlays.getHeight(n2));
                    }
                }
            }
            ++n2;
        }
        this.overlays.onAfterRender();
    }

    public void setOverlays(OverlayModel overlayModel) {
        this.overlays = overlayModel != null ? new DisplayWindowOverlayModel(overlayModel) : null;
    }

    public void setFreezeImage(boolean bl) {
        boolean bl2 = this.freezeImage;
        this.freezeImage = bl;
        if (bl2 && !bl && !this.buffer.contentsLost()) {
            this.buffer.show();
        }
    }

    public void pack() {
        if (this.viewportW > 0 && this.viewportH > 0 && !this.stretch && SwingUtilities.isEventDispatchThread()) {
            this.setPreferredSize(null);
            this.setPreferredSize(new Dimension((int)Math.ceil((float)this.viewportW * this.desiredScale * this.pixelAspectRatio), (int)Math.ceil((float)this.viewportH * this.desiredScale)));
        }
        this.scale = this.desiredScale;
    }

    public void setStretch(boolean bl) {
        this.stretch = bl;
        if (bl) {
            this.integerScaling = false;
        }
        this.repaint();
    }

    public boolean isStretch() {
        return this.stretch;
    }

    public void setFrameBlendingDisabled(boolean bl) {
        this.frameBlendingDisabled = bl;
    }

    public boolean isFrameBlendingDisabled() {
        return this.frameBlendingDisabled;
    }

    public void setScale(float f) {
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.desiredScale = f;
        this.pack();
    }

    public float getScale() {
        return this.scale >= 1.0f ? this.scale : this.desiredScale;
    }

    public void setPixelAspectRatio(float f) {
        this.pixelAspectRatio = f;
        this.pack();
    }

    public float getPixelAspectRatio() {
        return this.pixelAspectRatio;
    }

    public void setIntegerScaling(boolean bl) {
        this.integerScaling = bl;
        if (bl) {
            this.stretch = false;
        }
        this.repaint();
    }

    public boolean isIntegerScaling() {
        return this.integerScaling;
    }

    public void setFrameskip(int n) {
        this.frameskip = n;
    }

    public int getFrameskip() {
        return this.frameskip;
    }

    public void increaseFrameskip() {
        ++this.frameskip;
    }

    public void decreaseFrameskip() {
        if (this.frameskip > 0) {
            --this.frameskip;
        }
    }

    public int getFrameCount() {
        int n = this.frames;
        this.frames = 0;
        return n;
    }

    public int getFrameNumber() {
        return this.frames;
    }

    public void setFilterEnabled(boolean bl) {
        this.filterEnabled = bl;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setScanlinesEnabled(boolean bl) {
        this.scanlines = bl;
        if (bl) {
            this.scale = (int)this.scale;
        } else {
            float f = this.getScaleX();
            float f2 = this.getScaleY();
            float f3 = this.getScale();
            if (f < f2) {
                if (Math.abs(f - f3) > 0.01f) {
                    f3 = f;
                }
            } else if (Math.abs(f2 - f3) > 0.01f) {
                f3 = f2;
            }
            this.scale = f3;
        }
    }

    public boolean isScanlinesEnabled() {
        return this.scanlines;
    }

    public BufferedImage getCurrentImage(float f) {
        return this.getCurrentImage(f, false);
    }

    public BufferedImage getCurrentImage(float f, boolean bl) {
        return this.getCurrentImage(f, bl, null);
    }

    public BufferedImage getCurrentImage(float f, boolean bl, BufferedImage bufferedImage) {
        int[] nArray = DisplayWindow.asFraction(f);
        int n = bl ? this.viewportW - this.borderWidth : this.viewportW;
        int n2 = bl ? this.viewportH - this.borderHeight : this.viewportH;
        int n3 = bl ? this.viewportX + this.pixelsLeftBorder : this.viewportX;
        int n4 = bl ? this.viewportY + this.pixelsTopBorder : this.viewportY;
        int n5 = n * nArray[0];
        int n6 = n2 * nArray[1];
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n5, n6, this.backBuffer.getType());
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.backBuffer, 0, 0, n5, n6, n3, n4, n3 + n, n4 + n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void writeScreenToFile(File file, boolean bl) {
        try {
            ImageIO.write((RenderedImage)this.getCurrentImage(this.pixelAspectRatio, bl), "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeScreenToStream(OutputStream outputStream, boolean bl) {
        BufferedImage bufferedImage;
        this.screenRecorderImage = bufferedImage = this.getCurrentImage(1.0f, bl, this.screenRecorderImage);
        try {
            int n = 0;
            while (n < bufferedImage.getHeight()) {
                int n2 = 0;
                while (n2 < bufferedImage.getWidth()) {
                    int n3 = bufferedImage.getRGB(n2, n);
                    outputStream.write(n3 >> 16 & 0xFF);
                    outputStream.write(n3 >> 8 & 0xFF);
                    outputStream.write(n3 & 0xFF);
                    ++n2;
                }
                ++n;
            }
            ++this.recordedScreens;
        }
        catch (IOException iOException) {
            this.closeRecorderStream(this.screenRecorderStream);
            iOException.printStackTrace();
        }
    }

    private void closeRecorderStream(OutputStream outputStream) {
        if (!this.recordingScreen && outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.recordingScreen = false;
        this.screenRecorderStream = null;
        this.screenRecorderImage = null;
    }

    public void setScreenRecorderStream(OutputStream outputStream, boolean bl) {
        this.closeRecorderStream(this.screenRecorderStream);
        if (outputStream != null) {
            this.recordedScreens = 0;
        }
        this.screenRecorderStream = outputStream;
        this.screenRecorderCropBorders = bl;
    }

    public int getRecordedScreens() {
        return this.recordedScreens;
    }

    private static int[] asFraction(float f) {
        if (f < 0.0f) {
            int[] nArray = DisplayWindow.asFraction(-f);
            nArray[0] = -nArray[0];
            nArray[1] = -nArray[1];
            return nArray;
        }
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        double d5 = f;
        do {
            double d6 = Math.floor(d5);
            double d7 = d;
            d = d6 * d + d2;
            d2 = d7;
            d7 = d3;
            d3 = d6 * d3 + d4;
            d4 = d7;
            d5 = 1.0 / (d5 - d6);
        } while (Math.abs((double)f - d / d3) > (double)f * 0.001);
        return new int[]{(int)d, (int)d3};
    }

    @Override
    public void paint(Graphics graphics) {
        float f;
        super.paint(graphics);
        if (this.viewportW > 0 && this.viewportH > 0 && !this.stretch && this.isValid() && this.lastFrameMillis > 0L && System.currentTimeMillis() - this.lastFrameMillis > 50L) {
            f = Math.min(this.getScaleX(), this.getScaleY());
            this.scale = this.scanlines && f > 1.0f ? (float)((int)f) : f;
            if (this.integerScaling) {
                this.scale = Math.max(1, (int)this.scale);
            }
        }
        f = this.scale * this.pixelAspectRatio;
        float f2 = this.scale;
        int n = this.viewportH;
        int n2 = this.viewportY;
        BufferedImage bufferedImage = this.backBuffer;
        if (this.scanlines && this.scanlinesBackBuffer != null && this.scale >= 2.0f && this.scanlinesBackBuffer.getHeight() / this.height == (int)this.scale) {
            bufferedImage = this.scanlinesBackBuffer;
            f2 /= this.scale;
            n = (int)((float)n * this.scale);
            n2 = (int)((float)n2 * this.scale);
        }
        if (bufferedImage != null) {
            int n3 = (int)((float)this.viewportW * f);
            int n4 = (int)((float)n * f2);
            int n5 = (this.getWidth() - n3) / 2;
            int n6 = (this.getHeight() - n4) / 2;
            if (this.stretch) {
                if (this.scanlines && this.scale >= 2.0f) {
                    graphics.drawImage(bufferedImage, 0, n6, this.getWidth(), n6 + n4, this.viewportX, n2, this.viewportX + this.viewportW, n2 + n, null);
                } else {
                    graphics.drawImage(bufferedImage, 0, 0, this.getWidth(), this.getHeight(), this.viewportX, n2, this.viewportX + this.viewportW, n2 + n, null);
                }
            } else {
                graphics.drawImage(bufferedImage, n5, n6, n5 + n3, n6 + n4, this.viewportX, n2, this.viewportX + this.viewportW, n2 + n, null);
            }
        }
    }
}

