/*
 * Decompiled with CFR 0.152.
 */
package filesystem;

import filesystem.FAT;
import filesystem.FATUtilities;
import filesystem.File;
import filesystem.Time;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFAT
implements FAT {
    @Override
    public int getBytesPerLogicalSector() throws IOException {
        return this.readBytes(11, 2);
    }

    @Override
    public int getLogicalSectorsPerCluster() throws IOException {
        return this.readByte(13);
    }

    @Override
    public int getNumberOfReservedLogicalSectors() throws IOException {
        return this.readBytes(14, 2);
    }

    @Override
    public int getNumberOfFileAllocationTables() throws IOException {
        return this.readByte(16);
    }

    @Override
    public int getMaxNumberOfRootDirectories() throws IOException {
        return this.readBytes(17, 2);
    }

    @Override
    public int getTotalLogicalSectors() throws IOException {
        return this.readBytes(19, 2);
    }

    @Override
    public int getMediaDescriptor() throws IOException {
        return this.readByte(21);
    }

    @Override
    public int getLogicalSectorsPerFileAllocationTable() throws IOException {
        return this.readBytes(22, 2);
    }

    protected abstract int getBitsPerFATentry();

    protected int getNextCluster(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("There is no next cluster after a last cluster");
        }
        int n2 = this.getBitsPerFATentry();
        int n3 = this.getAddressOfFirstFileAllocationTable();
        int n4 = n * n2;
        int n5 = n3 + n4 / 8;
        int n6 = n2 == 12 ? (n4 % 8 == 4 ? this.readByte(n5 + 1) << 4 | this.readByte(n5) >> 4 : (this.readByte(n5 + 1) & 0xF) << 8 | this.readByte(n5)) : this.readBytes(n5, n2 / 8);
        return (long)n6 == ((1L << n2) - 1L & 0xFFFFFFFL) ? -1 : n6;
    }

    protected int getBytesPerCluster() throws IOException {
        return this.getBytesPerLogicalSector() * this.getLogicalSectorsPerCluster();
    }

    protected int getLogicalSectorOfRootDirectory() throws IOException {
        return FATUtilities.getLogicalSectorOfRootDirectory(this);
    }

    protected int getLogicalSectorOfDataArea() throws IOException {
        return FATUtilities.getLogicalSectorOfDataArea(this);
    }

    protected int getAddressOfFirstFileAllocationTable() throws IOException {
        return this.getNumberOfReservedLogicalSectors() * this.getBytesPerLogicalSector();
    }

    protected int getAddressOfRootDirectory() throws IOException {
        return this.getLogicalSectorOfRootDirectory() * this.getBytesPerLogicalSector();
    }

    protected int getSizeOfRootDirectory() throws IOException {
        return this.getMaxNumberOfRootDirectories() * 32;
    }

    protected int getAddressOfCluster(int n) throws IOException {
        if (n < 2) {
            throw new IllegalArgumentException();
        }
        return (n - 2) * this.getBytesPerCluster();
    }

    protected int readBytes(int n, int n2) throws IOException {
        int n3 = 0;
        while (n2-- > 0) {
            n3 = n3 << 8 | this.readByte(n + n2) & 0xFF;
        }
        return n3;
    }

    List<File> listFiles(final File file, int n, int n2) throws IOException {
        final int n3 = this.getLogicalSectorOfDataArea() * this.getBytesPerLogicalSector();
        ArrayList<File> arrayList = new ArrayList<File>();
        final AbstractFAT abstractFAT = this;
        int n4 = n;
        while (n4 < n2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = 0;
            while (n5 < 8) {
                stringBuffer.append((char)this.readByte(n4 + n5));
                ++n5;
            }
            String string = stringBuffer.toString().trim();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n6 = 8;
            while (n6 < 11) {
                stringBuffer2.append((char)this.readByte(n4 + n6));
                ++n6;
            }
            String string2 = stringBuffer2.toString().trim();
            final String string3 = (string.isEmpty() || string2.isEmpty() ? string : String.valueOf(string) + "." + string2).toLowerCase();
            final int n7 = this.readByte(n4 + 11);
            final int n8 = this.readByte(n4 + 27) << 8 | this.readByte(n4 + 26);
            final int n9 = this.readByte(n4 + 31) << 24 | this.readByte(n4 + 30) << 16 | this.readByte(n4 + 29) << 8 | this.readByte(n4 + 28);
            if (!string3.isEmpty() && string3.charAt(0) != '\u00e5' && (n7 & 8) == 0) {
                arrayList.add(new File(){

                    @Override
                    public void writeByte(int n, int n2) throws IOException {
                        abstractFAT.writeByte(this.mapAddress(n), n2);
                    }

                    @Override
                    public int readByte(int n) throws IOException {
                        return abstractFAT.readByte(this.mapAddress(n));
                    }

                    @Override
                    public int mapAddress(int n) throws IOException {
                        if (n < 0 || n >= n9) {
                            throw new ArrayIndexOutOfBoundsException(n);
                        }
                        int n2 = AbstractFAT.this.getBytesPerCluster();
                        int n32 = n8;
                        while (n >= n2) {
                            n32 = AbstractFAT.this.getNextCluster(n32);
                            n -= n2;
                        }
                        return n3 + AbstractFAT.this.getAddressOfCluster(n32) + n;
                    }

                    @Override
                    public List<File> listFiles() throws IOException {
                        return AbstractFAT.this.listFiles(this, AbstractFAT.this.getAddressOfCluster(n8), this.getSize());
                    }

                    @Override
                    public boolean isDirectory() {
                        return (n7 & 0x10) != 0;
                    }

                    @Override
                    public int getSize() throws IOException {
                        return n9;
                    }

                    @Override
                    public File getParent() {
                        return file;
                    }

                    @Override
                    public String getName() {
                        return string3;
                    }

                    @Override
                    public Time getLastModificationTime() {
                        throw new UnsupportedOperationException();
                    }

                    public String toString() {
                        return this.getName();
                    }
                });
            }
            n4 += 32;
        }
        return arrayList;
    }

    @Override
    public List<File> listFiles() throws IOException {
        return this.listFiles(null, this.getAddressOfRootDirectory(), this.getAddressOfRootDirectory() + this.getSizeOfRootDirectory());
    }

    private void printClusterChain(int n) throws IOException {
        if (n == 0) {
            System.out.print("VOLUME_LABEL");
        }
        while (n != 0) {
            System.out.print(n);
            n = this.getNextCluster(n);
            if (n <= 0) break;
            System.out.print(" -> ");
        }
        System.out.println();
    }

    private int determineSizeInClusters(int n) throws IOException {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n = this.getNextCluster(n);
        }
        return n2;
    }

    public void printFileClusters() throws IOException {
        this.printFileClusters("", this.getAddressOfRootDirectory(), this.getAddressOfRootDirectory() + this.getSizeOfRootDirectory());
    }

    private void printFileClusters(String string, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < 8) {
                stringBuffer.append((char)this.readByte(n3 + n4));
                ++n4;
            }
            String string2 = stringBuffer.toString().trim();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n5 = 8;
            while (n5 < 11) {
                stringBuffer2.append((char)this.readByte(n3 + n5));
                ++n5;
            }
            String string3 = stringBuffer2.toString().trim();
            String string4 = (string2.isEmpty() || string3.isEmpty() ? string2 : String.valueOf(string2) + "." + string3).toLowerCase();
            int n6 = this.readByte(n3 + 11);
            int n7 = this.readByte(n3 + 27) << 8 | this.readByte(n3 + 26);
            if (n7 > 0) {
                if (!string4.isEmpty()) {
                    System.out.print(String.valueOf(string) + string4 + ": ");
                    this.printClusterChain(n7);
                }
                if ((n6 & 0x10) != 0 && string4.charAt(0) != '.') {
                    int n8 = this.getLogicalSectorOfDataArea() * this.getBytesPerLogicalSector() + (n7 - 2) * this.getBytesPerCluster();
                    this.printFileClusters(String.valueOf(string) + string4 + "/", n8, n8 + this.determineSizeInClusters(n7) * this.getBytesPerCluster());
                }
            }
            n3 += 32;
        }
    }
}

