/*
 * Decompiled with CFR 0.152.
 */
package expressions;

public enum UnaryOperator {
    NOT("!"),
    READ_BYTE("@"),
    BANK_AT("&"),
    BANK_OF("&&"),
    NUMBER_PREFIX("#"),
    PLUS("+"),
    MINUS("-"),
    COMPLEMENT("~"),
    LOW_BYTE("<"),
    HIGH_BYTE(">"),
    BIG_ENDIAN_MARKER("?");

    private String operator;

    private UnaryOperator(String string2) {
        this.operator = string2;
    }

    public static UnaryOperator from(String string) {
        UnaryOperator[] unaryOperatorArray = UnaryOperator.values();
        int n = unaryOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            UnaryOperator unaryOperator = unaryOperatorArray[n2];
            if (unaryOperator.operator.equals(string)) {
                return unaryOperator;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown unary operator: " + string);
    }

    public String toString() {
        return this.operator;
    }
}

