/*
 * Decompiled with CFR 0.152.
 */
package expressions;

import expressions.ASTNode;
import expressions.BinaryOperator;
import expressions.BinaryOperatorNode;
import expressions.CallNode;
import expressions.FunctionProvider;
import expressions.Leaf;
import expressions.ParseException;
import expressions.Token;
import expressions.Tokenizer;
import expressions.UnaryOperator;
import expressions.UnaryOperatorNode;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class Expression {
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    protected final ASTNode root;

    public Expression(CharSequence charSequence, Tokenizer tokenizer) throws ParseException {
        this(charSequence, tokenizer, 10, false);
    }

    public Expression(CharSequence charSequence, Tokenizer tokenizer, int n, boolean bl) throws ParseException {
        this(charSequence, tokenizer, n, bl, false);
    }

    public Expression(CharSequence charSequence, Tokenizer tokenizer, int n, boolean bl, boolean bl2) throws ParseException {
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("expression must not be null or empty");
        }
        if (tokenizer == null) {
            throw new IllegalArgumentException("tokenizer must not be null");
        }
        try {
            ASTNode aSTNode = Expression.parse(tokenizer.tokenize(charSequence, n));
            this.root = bl ? Expression.maskSymbols(aSTNode, bl2) : aSTNode;
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException, charSequence);
        }
        if (this.root == null) {
            throw new ParseException("Syntax error in expression " + charSequence);
        }
    }

    protected Expression(ASTNode aSTNode) {
        this.root = aSTNode;
    }

    public Expression wrapInRead() {
        return new Expression(new UnaryOperatorNode(UnaryOperator.READ_BYTE, this.root));
    }

    public static Expression andExpressions(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(new BinaryOperatorNode(BinaryOperator.LOGICAL_AND, expression.root, expression2.root));
    }

    /*
     * Unable to fully structure code
     */
    private static ASTNode parse(Token[] var0) throws ParseException {
        var1_1 = new ArrayDeque<Boolean>();
        var2_2 = new ArrayDeque<Object>();
        var3_3 = new ArrayDeque<ASTNode>();
        var4_4 = true;
        var5_5 = false;
        var9_6 = var0;
        var8_7 = var0.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            block32: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                block31: {
                                    var6_9 = var9_6[var7_8];
                                    if (var4_4 && Expression.isUnaryOperator((Token)var6_9) && Expression.isBinaryOperator((Token)var6_9)) {
                                        var6_9 = new UnaryOperatorToken((Token)var6_9);
                                    }
                                    if (!var6_9.isNumber() && !var6_9.isIdentifier()) break block31;
                                    var3_3.push(Expression.createNode((Token)var6_9, var3_3));
                                    var4_4 = false;
                                    break block32;
                                }
                                if (!var6_9.isOperator()) break block33;
                                if (!(var4_4 && Expression.isUnaryOperator((Token)var6_9) || var6_9 instanceof UnaryOperatorToken)) {
                                    while (!var2_2.isEmpty() && ((Token)var2_2.peek()).isOperator() && (Expression.isLeftAssociative((Token)var6_9) && Expression.getPrecedence((Token)var6_9) <= Expression.getPrecedence((Token)var2_2.peek()) || Expression.isRightAssociative((Token)var6_9) && Expression.getPrecedence((Token)var6_9) < Expression.getPrecedence((Token)var2_2.peek()))) {
                                        var3_3.push(Expression.createNode((Token)var2_2.pop(), var3_3));
                                    }
                                }
                                var2_2.push(var6_9);
                                var4_4 = true;
                                break block32;
                            }
                            if (!Expression.isOpeningParenthesis((Token)var6_9)) break block34;
                            if (var5_5 && !var3_3.isEmpty() && var3_3.peek() instanceof Leaf) {
                                var3_3.push(new CallNode((ASTNode)var3_3.pop()));
                                var1_1.push(Boolean.TRUE);
                            } else {
                                var1_1.push(Boolean.FALSE);
                            }
                            var2_2.push(var6_9);
                            var4_4 = true;
                            break block32;
                        }
                        if (!Expression.isClosingParenthesis((Token)var6_9)) break block35;
                        while (!var2_2.isEmpty() && !Expression.isOpeningParenthesis((Token)var2_2.peek())) {
                            var3_3.push(Expression.createNode((Token)var2_2.pop(), var3_3));
                        }
                        if (var2_2.isEmpty()) {
                            throw new ParseException("Mismatched parenthesis encountered.");
                        }
                        var2_2.pop();
                        if (((Boolean)var1_1.pop()).booleanValue()) {
                            var10_10 = new ArrayDeque<ASTNode>();
                            while (!Expression.isOpenCall(var3_3)) {
                                var10_10.push((ASTNode)var3_3.pop());
                            }
                            var11_12 = (CallNode)var3_3.peek();
                            var11_12.setChildren(var10_10);
                        }
                        var4_4 = false;
                        break block32;
                    }
                    if (!"[".equals(var6_9.getToken())) break block36;
                    var2_2.push(var6_9);
                    var4_4 = true;
                    break block32;
                }
                if (!"]".equals(var6_9.getToken())) break block32;
                if ("^".equals(((Token)var2_2.peek()).getToken())) {
                    var2_2.pop();
                    var10_11 = true;
                } else {
                    var10_11 = false;
                }
                var11_13 = var0.length - 1;
                while (var11_13 >= 0 && var0[var11_13] != var6_9) {
                    --var11_13;
                }
                var12_14 = var11_13;
                var13_16 = 1;
                while (var11_13 > 0 && var13_16 > 0) {
                    var14_17 = var0[var11_13 - 1].getToken();
                    if ("]".equals(var14_17)) {
                        ++var13_16;
                    } else if ("[".equals(var14_17)) {
                        --var13_16;
                    }
                    --var11_13;
                }
                while (var11_13 < var12_14 && var0[var11_13].isParenthesis()) {
                    ++var11_13;
                }
                var13_15 = var11_13 < var12_14 ? (var11_13 + 1 < var12_14 && ":".equals(var0[var11_13 + 1].getToken()) ? new Leaf(var0[var11_13]) : new UnaryOperatorNode(UnaryOperator.BANK_OF, (ASTNode)new Leaf(var0[var11_13]))) : null;
                var14_17 = new StringBuilder();
                while ("?!".indexOf(((Token)var2_2.peek()).getToken()) >= 0) {
                    var14_17.append(((Token)var2_2.pop()).getToken());
                }
                var15_18 = var14_17.toString();
                if (!var2_2.isEmpty()) ** GOTO lbl95
                throw new ParseException("Mismatched memory access encountered.");
lbl-1000:
                // 1 sources

                {
                    var3_3.push(Expression.createNode((Token)var2_2.pop(), var3_3));
lbl95:
                    // 2 sources

                    ** while (!var2_2.isEmpty() && !"[".equals((Object)((Token)var2_2.peek()).getToken()) && !"^".equals((Object)((Token)var2_2.peek()).getToken()))
                }
lbl96:
                // 1 sources

                if (!"[".equals(((Token)var2_2.peek()).getToken())) {
                    throw new ParseException("Illegal token '" + ((Token)var2_2.peek()).getToken() + "' encountered in memory access.");
                }
                var2_2.pop();
                var18_21 = new BinaryOperatorNode(BinaryOperator.BINARY_AND, (ASTNode)var3_3.pop(), (ASTNode)new Leaf(new Token(0, "$ffff", 16)));
                var19_22 = var13_15 != null ? new BinaryOperatorNode(BinaryOperator.MAP_BANK, (ASTNode)var13_15, (ASTNode)var18_21) : var18_21;
                if (!var15_18.isEmpty()) {
                    var17_20 = var15_18.length() * 2;
                    var16_19 = var15_18.charAt(0) != '!';
                } else {
                    var16_19 = false;
                    var17_20 = 1;
                }
                if (var17_20 == 1) {
                    if (var10_11) {
                        var3_3.push(new BinaryOperatorNode(BinaryOperator.READ_LOCATION, (ASTNode)new Leaf(new Token(2, "^")), (ASTNode)var19_22));
                    } else {
                        var3_3.push(new UnaryOperatorNode(UnaryOperator.READ_BYTE, (ASTNode)var19_22));
                    }
                } else {
                    var3_3.push(new BinaryOperatorNode(BinaryOperator.READ_LOCATION, (ASTNode)new Leaf(new Token(2, String.valueOf(var17_20 == 4 ? (var16_19 ? "bedword" : "dword") : (var16_19 != false ? "beword" : "word")) + (var10_11 != false ? ".^" : ""))), (ASTNode)var19_22));
                }
                var4_4 = false;
            }
            var5_5 = var6_9.isIdentifier();
            ++var7_8;
        }
        while (!var2_2.isEmpty()) {
            if (Expression.isParenthesis((Token)var2_2.peek())) {
                throw new ParseException("Mismatched parenthesis encountered.");
            }
            if (!((Token)var2_2.peek()).isOperator()) continue;
            var3_3.push(Expression.createNode((Token)var2_2.pop(), var3_3));
        }
        if (var3_3.isEmpty()) {
            return null;
        }
        var6_9 = (ASTNode)var3_3.pop();
        if (!var3_3.isEmpty()) {
            return null;
        }
        return var6_9;
    }

    public Set<String> getVariableNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Expression.collectVariableNames(this.root, hashSet);
        return hashSet;
    }

    private static void collectVariableNames(ASTNode aSTNode, Set<String> set) {
        if (aSTNode == null) {
            throw new IllegalArgumentException("node must not be null.");
        }
        if (aSTNode instanceof Leaf) {
            Leaf leaf = (Leaf)aSTNode;
            Token token = leaf.getToken();
            if (token.isNumber()) {
                return;
            }
            if ("true".equals(token.getToken()) || "false".equals(token.getToken())) {
                return;
            }
            set.add(token.getToken());
        } else {
            ASTNode[] aSTNodeArray = aSTNode.getChildren();
            int n = aSTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode aSTNode2 = aSTNodeArray[n2];
                Expression.collectVariableNames(aSTNode2, set);
                ++n2;
            }
        }
    }

    public Set<Expression> getReadLocations(VariableProvider variableProvider) throws UnknownVariableException {
        HashSet<Expression> hashSet = new HashSet<Expression>();
        Expression.collectReadLocations(this.root, variableProvider, hashSet);
        return hashSet;
    }

    private static void collectReadLocations(ASTNode aSTNode, VariableProvider variableProvider, Set<Expression> set) throws UnknownVariableException {
        if (aSTNode == null) {
            throw new IllegalArgumentException("node must not be null.");
        }
        if (aSTNode instanceof Leaf) {
            return;
        }
        if (aSTNode instanceof UnaryOperatorNode) {
            UnaryOperator unaryOperator = ((UnaryOperatorNode)aSTNode).getOperator();
            if (unaryOperator == UnaryOperator.READ_BYTE) {
                set.add(new Expression(aSTNode.getChildren()[0]));
            }
            ASTNode[] aSTNodeArray = aSTNode.getChildren();
            int n = aSTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode aSTNode2 = aSTNodeArray[n2];
                Expression.collectReadLocations(aSTNode2, variableProvider, set);
                ++n2;
            }
        } else {
            ASTNode[] aSTNodeArray = aSTNode.getChildren();
            int n = aSTNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                ASTNode aSTNode3 = aSTNodeArray[n3];
                Expression.collectReadLocations(aSTNode3, variableProvider, set);
                ++n3;
            }
        }
    }

    public String getValueString(VariableProvider variableProvider, FunctionProvider functionProvider) {
        try {
            int n = (int)this.getValue(variableProvider, functionProvider, false);
            if (this.isBoolean(functionProvider)) {
                return n == 0 ? "false" : "true";
            }
            return String.format("$%X", n);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public int getValue(VariableProvider variableProvider, FunctionProvider functionProvider) throws UnknownVariableException {
        return (int)this.getValue(variableProvider, functionProvider, true);
    }

    public long getValue(VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        return Expression.getValue(this.root, variableProvider, functionProvider, bl);
    }

    public boolean isTrue(VariableProvider variableProvider, FunctionProvider functionProvider) throws UnknownVariableException {
        return this.isTrue(variableProvider, functionProvider, true);
    }

    public boolean isTrue(VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        return this.getValue(variableProvider, functionProvider, bl) != 0L;
    }

    private static long getValue(ASTNode aSTNode, VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        if (aSTNode == null) {
            throw new IllegalArgumentException("node must not be null.");
        }
        if (aSTNode instanceof Leaf) {
            return Expression.evaluate((Leaf)aSTNode, variableProvider, bl);
        }
        if (aSTNode instanceof BinaryOperatorNode) {
            return Expression.evaluate((BinaryOperatorNode)aSTNode, variableProvider, functionProvider, bl);
        }
        if (aSTNode instanceof UnaryOperatorNode) {
            return Expression.evaluate((UnaryOperatorNode)aSTNode, variableProvider, functionProvider, bl);
        }
        if (aSTNode instanceof CallNode) {
            return Expression.evaluate((CallNode)aSTNode, variableProvider, functionProvider, bl);
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    private static long evaluate(Leaf leaf, VariableProvider variableProvider, boolean bl) throws UnknownVariableException {
        Token token = leaf.getToken();
        if (token.isNumber()) {
            return token.getValue();
        }
        if ("true".equals(token.getToken())) {
            return 1L;
        }
        if ("false".equals(token.getToken())) {
            return 0L;
        }
        if (variableProvider == null) {
            throw new UnknownVariableException(token.getToken());
        }
        return variableProvider.getValue(token.getToken(), bl);
    }

    private static long evaluate(BinaryOperatorNode binaryOperatorNode, VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        ArrayDeque<ASTNode> arrayDeque = new ArrayDeque<ASTNode>();
        long[] lArray = new long[10];
        int n = 0;
        ASTNode aSTNode = null;
        arrayDeque.push(binaryOperatorNode);
        while (!arrayDeque.isEmpty()) {
            ASTNode aSTNode2 = (ASTNode)arrayDeque.peek();
            if (aSTNode2 instanceof BinaryOperatorNode) {
                long l;
                long l2;
                long l3;
                BinaryOperator binaryOperator = ((BinaryOperatorNode)aSTNode2).getOperator();
                if (binaryOperator == BinaryOperator.READ_LOCATION) {
                    if (n >= lArray.length) {
                        Arrays.copyOf(lArray, lArray.length + 10);
                    }
                    lArray[n++] = variableProvider.readLocation(aSTNode2.getChildren()[0].toString(), (int)Expression.getValue(aSTNode2.getChildren()[1], variableProvider, functionProvider, bl), bl);
                    aSTNode = aSTNode2;
                    arrayDeque.pop();
                    continue;
                }
                if (aSTNode == null && aSTNode2 instanceof BinaryOperatorNode) {
                    arrayDeque.push(aSTNode2.getChildren()[0]);
                    continue;
                }
                if (aSTNode2 instanceof BinaryOperatorNode && aSTNode == aSTNode2.getChildren()[0]) {
                    if (binaryOperator == BinaryOperator.LOGICAL_AND && lArray[n - 1] == 0L || binaryOperator == BinaryOperator.LOGICAL_OR && lArray[n - 1] != 0L) {
                        arrayDeque.pop();
                        aSTNode = aSTNode2;
                        lArray[n - 1] = lArray[n - 1] != 0L ? 1 : 0;
                        continue;
                    }
                    arrayDeque.push(aSTNode2.getChildren()[1]);
                    aSTNode = null;
                    continue;
                }
                if (bl) {
                    l3 = (int)lArray[--n];
                    l2 = (int)lArray[--n];
                } else {
                    l3 = lArray[--n] & 0xFFFFFFFFL;
                    l2 = lArray[--n] & 0xFFFFFFFFL;
                }
                block0 : switch (binaryOperator) {
                    case LOGICAL_AND: {
                        l = l2 != 0L && l3 != 0L ? 1 : 0;
                        break;
                    }
                    case LOGICAL_OR: {
                        l = l2 != 0L || l3 != 0L ? 1 : 0;
                        break;
                    }
                    case LOGICAL_XOR: {
                        l = l2 != 0L ^ l3 != 0L ? 1 : 0;
                        break;
                    }
                    default: {
                        switch (binaryOperator) {
                            case ADDITION: {
                                l = l2 + l3;
                                break block0;
                            }
                            case BINARY_AND: {
                                l = l2 & l3;
                                break block0;
                            }
                            case BINARY_OR: {
                                l = l2 | l3;
                                break block0;
                            }
                            case BINARY_XOR1: 
                            case BINARY_XOR2: {
                                l = l2 ^ l3;
                                break block0;
                            }
                            case DIVISION: {
                                l = l3 != 0L ? l2 / l3 : 0L;
                                break block0;
                            }
                            case EQUALS1: 
                            case EQUALS2: {
                                l = l2 == l3 ? 1 : 0;
                                break block0;
                            }
                            case GREATER_OR_EQUAL: {
                                l = l2 >= l3 ? 1 : 0;
                                break block0;
                            }
                            case GREATER_THAN: {
                                l = l2 > l3 ? 1 : 0;
                                break block0;
                            }
                            case LESS_OR_EQUAL: {
                                l = l2 <= l3 ? 1 : 0;
                                break block0;
                            }
                            case LESS_THAN: {
                                l = l2 < l3 ? 1 : 0;
                                break block0;
                            }
                            case MODULUS1: 
                            case MODULUS2: {
                                l = l3 != 0L ? l2 % l3 : l2;
                                break block0;
                            }
                            case PRODUCT: {
                                l = l2 * l3;
                                break block0;
                            }
                            case HIGH_PRODUCT: {
                                l = l2 * l3 >>> 32;
                                break block0;
                            }
                            case NOT_EQUALS: 
                            case NOT_EQUALS2: {
                                l = l2 != l3 ? 1 : 0;
                                break block0;
                            }
                            case SHIFT_LEFT: {
                                if (l3 < 0L || l3 >= 32L) {
                                    l = 0L;
                                    break block0;
                                }
                                l = l2 << (int)(l3 < 0L || l3 >= 32L ? 32L : l3);
                                break block0;
                            }
                            case SHIFT_RIGHT: {
                                if (l3 < 0L || l3 >= 32L) {
                                    l = bl && l2 < 0L ? -1 : 0;
                                    break block0;
                                }
                                l = l2 >> (int)l3;
                                break block0;
                            }
                            case SUBTRACTION: {
                                l = l2 - l3;
                                break block0;
                            }
                            case MAP_BANK: {
                                l = variableProvider.mapBank((int)l3, (int)l2);
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Unknown binary operator: " + (Object)((Object)binaryOperator));
                    }
                }
                if (n >= lArray.length) {
                    Arrays.copyOf(lArray, lArray.length + 10);
                }
                lArray[n++] = l;
                aSTNode = aSTNode2;
                arrayDeque.pop();
                continue;
            }
            if (n >= lArray.length) {
                Arrays.copyOf(lArray, lArray.length + 10);
            }
            lArray[n++] = Expression.getValue(aSTNode2, variableProvider, functionProvider, bl);
            aSTNode = aSTNode2;
            arrayDeque.pop();
        }
        return lArray[--n];
    }

    private static long evaluate(UnaryOperatorNode unaryOperatorNode, VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        UnaryOperator unaryOperator = unaryOperatorNode.getOperator();
        switch (unaryOperator) {
            case HIGH_BYTE: {
                return Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl) >> 8 & 0xFFL;
            }
            case LOW_BYTE: {
                return Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl) & 0xFFL;
            }
            case MINUS: {
                return -Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl);
            }
            case NOT: {
                return Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl) == 0L ? 1 : 0;
            }
            case NUMBER_PREFIX: 
            case PLUS: {
                return Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl);
            }
            case COMPLEMENT: {
                return Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case READ_BYTE: {
                return variableProvider.readValue((int)Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl), bl, false);
            }
            case BANK_AT: {
                return variableProvider.getBankAt((int)Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl));
            }
            case BANK_OF: {
                return Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, bl) >> 16;
            }
        }
        throw new IllegalArgumentException("Unknown unary operator: " + (Object)((Object)unaryOperator));
    }

    private static long evaluate(CallNode callNode, VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        ASTNode[] aSTNodeArray = callNode.getChildren();
        int[] nArray = new int[aSTNodeArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)Expression.getValue(aSTNodeArray[n], variableProvider, functionProvider, bl);
            ++n;
        }
        return functionProvider.call(callNode.getName(), nArray);
    }

    private boolean isBoolean(FunctionProvider functionProvider) {
        if (this.root instanceof Leaf) {
            Leaf leaf = (Leaf)this.root;
            Token token = leaf.getToken();
            return "true".equals(token.getToken()) || "false".equals(token.getToken());
        }
        if (this.root instanceof BinaryOperatorNode) {
            BinaryOperator binaryOperator = ((BinaryOperatorNode)this.root).getOperator();
            return binaryOperator.isBoolean();
        }
        if (this.root instanceof UnaryOperatorNode) {
            UnaryOperator unaryOperator = ((UnaryOperatorNode)this.root).getOperator();
            return unaryOperator == UnaryOperator.NOT;
        }
        if (this.root instanceof CallNode) {
            return functionProvider.isBoolean(((CallNode)this.root).getName());
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    public boolean isConstant(VariableProvider variableProvider, FunctionProvider functionProvider) throws UnknownVariableException {
        return Expression.isConstant(this.root, variableProvider, functionProvider);
    }

    private static boolean isConstant(ASTNode aSTNode, VariableProvider variableProvider, FunctionProvider functionProvider) throws UnknownVariableException {
        if (aSTNode == null) {
            throw new IllegalArgumentException("node must not be null.");
        }
        if (aSTNode instanceof Leaf) {
            Leaf leaf = (Leaf)aSTNode;
            Token token = leaf.getToken();
            if (token.isNumber() || "true".equals(token.getToken()) || "false".equals(token.getToken())) {
                return true;
            }
            return variableProvider.isConstant(token.getToken());
        }
        if (aSTNode instanceof BinaryOperatorNode) {
            BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)aSTNode;
            BinaryOperator binaryOperator = binaryOperatorNode.getOperator();
            if (binaryOperator != BinaryOperator.READ_LOCATION && Expression.isConstant(aSTNode.getChildren()[0], variableProvider, functionProvider)) {
                long l;
                long l2;
                long l3;
                if (binaryOperator == BinaryOperator.LOGICAL_OR ? (l3 = Expression.getValue(aSTNode.getChildren()[0], variableProvider, functionProvider, true)) != 0L : (binaryOperator == BinaryOperator.LOGICAL_AND ? (l2 = Expression.getValue(aSTNode.getChildren()[0], variableProvider, functionProvider, true)) == 0L : (binaryOperator == BinaryOperator.SHIFT_LEFT || binaryOperator == BinaryOperator.SHIFT_RIGHT || "*/#%&".indexOf(binaryOperator.toString().charAt(0)) >= 0) && (l = Expression.getValue(aSTNode.getChildren()[0], variableProvider, functionProvider, true)) == 0L)) {
                    return true;
                }
                return Expression.isConstant(aSTNode.getChildren()[1], variableProvider, functionProvider);
            }
            return false;
        }
        if (aSTNode instanceof UnaryOperatorNode) {
            UnaryOperatorNode unaryOperatorNode = (UnaryOperatorNode)aSTNode;
            return unaryOperatorNode.getOperator() != UnaryOperator.BANK_AT && Expression.isConstant(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider) && (unaryOperatorNode.getOperator() != UnaryOperator.READ_BYTE || variableProvider.isConstantRead((int)Expression.getValue(unaryOperatorNode.getChildren()[0], variableProvider, functionProvider, true)));
        }
        if (aSTNode instanceof CallNode) {
            ASTNode[] aSTNodeArray = aSTNode.getChildren();
            int n = aSTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode aSTNode2 = aSTNodeArray[n2];
                if (!Expression.isConstant(aSTNode2, variableProvider, functionProvider)) {
                    return false;
                }
                ++n2;
            }
            return functionProvider.isConstant(((CallNode)aSTNode).getName());
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    protected static ASTNode maskSymbols(ASTNode aSTNode, boolean bl) {
        return Expression.maskSymbols(aSTNode, null, bl);
    }

    protected static ASTNode maskSymbols(ASTNode aSTNode, ASTNode aSTNode2, boolean bl) {
        if (aSTNode == null) {
            throw new IllegalArgumentException("node must not be null.");
        }
        if (aSTNode instanceof Leaf) {
            Leaf leaf = (Leaf)aSTNode;
            Token token = leaf.getToken();
            if (!token.isIdentifier() || "true".equals(token.getToken()) || "false".equals(token.getToken())) {
                return aSTNode;
            }
            if (!bl && aSTNode2 == null) {
                return aSTNode;
            }
            return new BinaryOperatorNode(BinaryOperator.BINARY_AND, (ASTNode)leaf, (ASTNode)new Leaf(new Token(0, "$ffff", 16)));
        }
        if (aSTNode instanceof BinaryOperatorNode) {
            if (((BinaryOperatorNode)aSTNode).getOperator() == BinaryOperator.READ_LOCATION) {
                return aSTNode;
            }
            aSTNode.getChildren()[0] = Expression.maskSymbols(aSTNode.getChildren()[0], aSTNode, bl);
            aSTNode.getChildren()[1] = Expression.maskSymbols(aSTNode.getChildren()[1], aSTNode, bl);
            return aSTNode;
        }
        if (aSTNode instanceof UnaryOperatorNode) {
            if (((UnaryOperatorNode)aSTNode).getOperator() == UnaryOperator.READ_BYTE || ((UnaryOperatorNode)aSTNode).getOperator() == UnaryOperator.BANK_OF) {
                return aSTNode;
            }
            aSTNode.getChildren()[0] = Expression.maskSymbols(aSTNode.getChildren()[0], aSTNode, bl);
            return aSTNode;
        }
        if (aSTNode instanceof CallNode) {
            int n = 0;
            while (n < aSTNode.getChildren().length) {
                aSTNode.getChildren()[n] = Expression.maskSymbols(aSTNode.getChildren()[n], aSTNode, bl);
                ++n;
            }
            return aSTNode;
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    public Expression optimize(VariableProvider variableProvider, FunctionProvider functionProvider) throws UnknownVariableException {
        return this.optimize(variableProvider, functionProvider, true);
    }

    public Expression optimize(VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        return new Expression(Expression.optimize(this.root, variableProvider, functionProvider, bl));
    }

    protected static ASTNode optimize(ASTNode aSTNode, VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        if (aSTNode == null) {
            throw new IllegalArgumentException("node must not be null.");
        }
        if (Expression.isConstant(aSTNode, variableProvider, functionProvider)) {
            return new Leaf(new Token(0, Long.toString(Expression.getValue(aSTNode, variableProvider, functionProvider, bl))));
        }
        if (aSTNode instanceof Leaf) {
            return aSTNode;
        }
        if (aSTNode instanceof BinaryOperatorNode) {
            if (((BinaryOperatorNode)aSTNode).getOperator() != BinaryOperator.READ_LOCATION) {
                aSTNode.getChildren()[0] = Expression.optimize(aSTNode.getChildren()[0], variableProvider, functionProvider, bl);
            }
            aSTNode.getChildren()[1] = Expression.optimize(aSTNode.getChildren()[1], variableProvider, functionProvider, bl);
            return aSTNode;
        }
        if (aSTNode instanceof UnaryOperatorNode) {
            aSTNode.getChildren()[0] = Expression.optimize(aSTNode.getChildren()[0], variableProvider, functionProvider, bl);
            return aSTNode;
        }
        if (aSTNode instanceof CallNode) {
            int n = 0;
            while (n < aSTNode.getChildren().length) {
                aSTNode.getChildren()[n] = Expression.optimize(aSTNode.getChildren()[n], variableProvider, functionProvider, bl);
                ++n;
            }
            return aSTNode;
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    private static boolean isOpeningParenthesis(Token token) {
        return "(".equals(token.getToken());
    }

    private static boolean isClosingParenthesis(Token token) {
        return ")".equals(token.getToken());
    }

    private static boolean isOpenCall(Deque<ASTNode> deque) {
        return !deque.isEmpty() && deque.peek() instanceof CallNode && ((CallNode)deque.peek()).getChildren() == null;
    }

    private static boolean isParenthesis(Token token) {
        return Expression.isOpeningParenthesis(token) || Expression.isClosingParenthesis(token);
    }

    private static boolean isLeftAssociative(Token token) {
        return !"@@".equals(token.getToken());
    }

    private static boolean isRightAssociative(Token token) {
        return !Expression.isLeftAssociative(token);
    }

    private static ASTNode createNode(Token token, Deque<ASTNode> deque) throws ParseException {
        if (token.isNumber() || token.isIdentifier()) {
            return new Leaf(token);
        }
        if (token instanceof UnaryOperatorToken) {
            if (deque.isEmpty()) {
                throw new ParseException("The " + token + " operator needs 1 operand.");
            }
            return new UnaryOperatorNode(token.getToken(), deque.pop());
        }
        if (Expression.isBinaryOperator(token)) {
            if (deque.isEmpty()) {
                throw new ParseException("The " + token + " operator needs 2 operands.");
            }
            ASTNode aSTNode = deque.pop();
            if (deque.isEmpty()) {
                throw new ParseException("The " + token + " operator needs 2 operands.");
            }
            ASTNode aSTNode2 = deque.pop();
            return new BinaryOperatorNode(token.getToken(), aSTNode2, aSTNode);
        }
        if (Expression.isUnaryOperator(token)) {
            if (deque.isEmpty()) {
                throw new ParseException("The " + token + " operator needs 1 operand.");
            }
            return new UnaryOperatorNode(token.getToken(), deque.pop());
        }
        throw new ParseException("Illegal token encountered: " + token);
    }

    private static boolean isBinaryOperator(Token token) {
        if ("&&".equals(token.getToken())) {
            return true;
        }
        return "&#+-~<>".contains(token.getToken()) || !Expression.isUnaryOperator(token);
    }

    private static boolean isUnaryOperator(Token token) {
        if ("&&".equals(token.getToken())) {
            return true;
        }
        return "@!?&#+-~<>".contains(token.getToken());
    }

    private static int getPrecedence(Token token) {
        if (token instanceof UnaryOperatorToken || "@!".contains(token.getToken())) {
            return 13;
        }
        if (":".equals(token.getToken())) {
            return 12;
        }
        if ("@@".equals(token.getToken())) {
            return 11;
        }
        if ("<<".equals(token.getToken()) || ">>".equals(token.getToken())) {
            return 10;
        }
        if ("*/#%".contains(token.getToken()) || "**".equals(token.getToken())) {
            return 9;
        }
        if ("+-".contains(token.getToken())) {
            return 8;
        }
        if ("&".equals(token.getToken())) {
            return 7;
        }
        if ("^".equals(token.getToken())) {
            return 6;
        }
        if ("|".equals(token.getToken())) {
            return 5;
        }
        if ("=".equals(token.getToken()) || "==".equals(token.getToken()) || "!=".equals(token.getToken()) || "<>".equals(token.getToken())) {
            return 4;
        }
        if ("<>".contains(token.getToken()) || "<=".equals(token.getToken()) || ">=".equals(token.getToken())) {
            return 3;
        }
        if ("&&".equals(token.getToken())) {
            return 2;
        }
        if ("||".equals(token.getToken()) || "^^".equals(token.getToken())) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown operator: " + token);
    }

    public String toString() {
        return this.root.toString();
    }

    private static class UnaryOperatorToken
    extends Token {
        public UnaryOperatorToken(Token token) {
            super(1, token.getToken());
        }
    }
}

