/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.DefaultEventFilterModel;
import events.EventColorModel;
import events.EventFilterListener;
import events.EventFilterModel;
import events.EventModel;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import treetable.AbstractTreeTableModel;
import treetable.TreeTable;
import treetable.TreeTableModel;

public class EventViewerTable
extends JPanel
implements EventFilterListener {
    private final JRadioButton prevFrame;
    private final JCheckBox showReads;
    private final AbstractTableModel tableModel;
    private final TreeTable treeTable;
    private final JTable table;
    private EventModel model;
    private EventFilterModel filterModel;
    private EventColorModel eventColorModel;
    int[] filteredIndices = new int[0];
    int[] filteredRows = new int[0];
    int numberOfFilteredIndices;

    public EventViewerTable(EventModel eventModel) {
        this.setLayout(new BorderLayout());
        this.model = eventModel;
        final JScrollPane jScrollPane = new JScrollPane(){
            private Border defaultBorder;
            private Border defaultTitleBorderBorder;

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.defaultBorder == null) {
                    this.defaultBorder = this.getBorder();
                    if (this.defaultBorder instanceof TitledBorder) {
                        this.defaultTitleBorderBorder = ((TitledBorder)this.defaultBorder).getBorder();
                    }
                }
            }

            @Override
            public Color getForeground() {
                return EventViewerTable.this.getForeground();
            }

            @Override
            protected void paintBorder(Graphics graphics) {
                Border border = this.getBorder();
                Border border2 = EventViewerTable.this.getFilterBorder();
                if (border instanceof TitledBorder) {
                    ((TitledBorder)border).setTitleColor(this.getForeground());
                    ((TitledBorder)border).setBorder(border2 != null ? border2 : this.defaultTitleBorderBorder);
                } else {
                    this.setBorder(border2 != null ? border2 : this.defaultBorder);
                }
                super.paintBorder(graphics);
            }
        };
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Events to show"));
        this.filterModel = new DefaultEventFilterModel(eventModel);
        this.filterModel.addEventFilterListener(this);
        this.treeTable = new TreeTable(EventViewerTable.makeFilterModel(eventModel, this.filterModel)){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.width = jScrollPane.getMinimumSize().width;
                int n = this.getRowCount();
                int n2 = this.getColumnCount();
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n) {
                        n4 = Math.max(n4, this.getCellRenderer((int)n5, (int)n3).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n5, (int)n3), (boolean)false, (boolean)false, (int)n5, (int)n3).getPreferredSize().width) + this.getIntercellSpacing().width;
                        ++n5;
                    }
                    dimension.width += n4;
                    ++n3;
                }
                return dimension;
            }

            @Override
            public Font getFont() {
                return EventViewerTable.this.getFont();
            }

            @Override
            public Color getForeground() {
                Color color = EventViewerTable.this.getTableForeground();
                return color != null ? color : super.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                Color color = EventViewerTable.this.getSelectionForeground();
                return color != null ? color : super.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                Color color = EventViewerTable.this.getTableBackground();
                return color != null ? color : super.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                Color color = EventViewerTable.this.getSelectionBackground();
                return color != null ? color : super.getSelectionBackground();
            }
        };
        this.treeTable.setSelectionEnabled(false);
        this.treeTable.setShowGrid(false);
        this.treeTable.setFillsViewportHeight(true);
        this.treeTable.setTableHeader(null);
        this.treeTable.setIntercellSpacing(new Dimension());
        this.treeTable.setHideIcons(true);
        this.treeTable.expandFirstLevel();
        this.treeTable.getColumnModel().getColumn(1).setMaxWidth(this.treeTable.getCellRenderer((int)0, (int)1).getTableCellRendererComponent((JTable)this.treeTable, (Object)this.treeTable.getValueAt((int)0, (int)1), (boolean)false, (boolean)false, (int)0, (int)1).getPreferredSize().width);
        this.treeTable.setDefaultRenderer(Boolean.class, new TriStateRenderer());
        jScrollPane.setViewportView(this.treeTable);
        Container container = new Container();
        container.setLayout(new BorderLayout());
        Container container2 = new Container();
        container2.setLayout(new BorderLayout());
        Container container3 = new Container();
        container3.setLayout(new FlowLayout());
        container2.add((Component)container3, "North");
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    EventViewerTable.this.updateTable();
                }
            }
        };
        container3.add(new JLabel("Frame:"){

            @Override
            public Color getForeground() {
                return EventViewerTable.this.getForeground();
            }
        });
        this.prevFrame = new JRadioButton("Prev"){

            @Override
            public Color getForeground() {
                return EventViewerTable.this.getForeground();
            }
        };
        this.prevFrame.setOpaque(false);
        this.prevFrame.addItemListener(itemListener);
        container3.add(this.prevFrame);
        JRadioButton jRadioButton = new JRadioButton("Curr", true){

            @Override
            public Color getForeground() {
                return EventViewerTable.this.getForeground();
            }
        };
        jRadioButton.setOpaque(false);
        jRadioButton.addItemListener(itemListener);
        container3.add(jRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.prevFrame);
        buttonGroup.add(jRadioButton);
        this.showReads = new JCheckBox("Show Reads"){

            @Override
            public Color getForeground() {
                return EventViewerTable.this.getForeground();
            }
        };
        this.showReads.setOpaque(false);
        this.showReads.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public boolean isSelected() {
                return EventViewerTable.this.filterModel.isShowReads();
            }

            @Override
            public void setSelected(boolean bl) {
                EventViewerTable.this.filterModel.setShowReads(bl);
            }
        });
        this.showReads.addItemListener(itemListener);
        container2.add((Component)this.showReads, "South");
        container.add((Component)container2, "North");
        container.add((Component)jScrollPane, "Center");
        this.add((Component)container, "West");
        this.tableModel = this.makeTableModel();
        this.table = new JTable(this.tableModel){
            private boolean settingSize;

            @Override
            public void updateUI() {
                super.updateUI();
                this.packColumns();
            }

            private void packColumns() {
                int n;
                int n2;
                Object object;
                if (this.getTableHeader() == null) {
                    return;
                }
                EventViewerTable.this.updateFilters();
                ArrayList<String> arrayList = new ArrayList<String>();
                EventModel eventModel = EventViewerTable.this.getModel();
                int n3 = 0;
                while (n3 < eventModel.getNumberOfEventGroups()) {
                    object = eventModel.getEventTypes(n3);
                    int n4 = ((int[])object).length;
                    n2 = 0;
                    while (n2 < n4) {
                        n = object[n2];
                        arrayList.add(eventModel.getEventTypeName(n));
                        ++n2;
                    }
                    ++n3;
                }
                n3 = 0;
                n = EventViewerTable.this.getEventColorModel() != null ? 1 : 0;
                n2 = 0;
                while (n2 < this.getColumnCount() - 1) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(n2);
                    object = tableColumn.getHeaderRenderer();
                    if (object == null) {
                        object = this.getTableHeader().getDefaultRenderer();
                    }
                    int n5 = object.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)n2).getPreferredSize().width + 1;
                    if (n2 == 2 + n) {
                        for (String string : arrayList) {
                            Dimension dimension = this.getCellRenderer(0, n2).getTableCellRendererComponent(this, string, false, false, 0, n2).getPreferredSize();
                            n3 = Math.max(n3, dimension.height);
                            n5 = Math.max(n5, dimension.width) + this.getIntercellSpacing().width;
                        }
                    } else {
                        Dimension dimension = this.getCellRenderer(0, n2).getTableCellRendererComponent(this, this.getRowCount() > 0 ? this.getValueAt(0, n2) : (n2 == 5 + n ? " ROM00:0000 " : (n2 == 1 + n ? " 000 " : " 00 ")), false, false, 0, n2).getPreferredSize();
                        n3 = Math.max(n3, dimension.height);
                        n5 = Math.max(n5, dimension.width) + this.getIntercellSpacing().width;
                    }
                    tableColumn.setMaxWidth(Integer.MAX_VALUE);
                    tableColumn.setMinWidth(n5);
                    tableColumn.setMaxWidth(n5);
                    ++n2;
                }
                this.setRowHeight(n3);
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                super.tableChanged(tableModelEvent);
                if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == -1 && tableModelEvent.getFirstRow() == -1) {
                    this.packColumns();
                }
            }

            @Override
            public Font getFont() {
                return EventViewerTable.this.getFont();
            }

            @Override
            public Color getForeground() {
                Color color = EventViewerTable.this.getTableForeground();
                return color != null ? color : super.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                Color color = EventViewerTable.this.getSelectionForeground();
                return color != null ? color : super.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                Color color = EventViewerTable.this.getTableBackground();
                return color != null ? color : super.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                Color color = EventViewerTable.this.getSelectionBackground();
                return color != null ? color : super.getSelectionBackground();
            }

            @Override
            public Color getGridColor() {
                Color color = super.getGridColor();
                if (color != null && color.equals(Color.WHITE)) {
                    return Color.GRAY;
                }
                return color;
            }

            @Override
            public void setSize(Dimension dimension) {
                this.settingSize = dimension.getHeight() > (double)this.getParent().getHeight();
                super.setSize(dimension);
                this.settingSize = false;
            }

            @Override
            public boolean isShowing() {
                return !this.settingSize && super.isShowing();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics graphics) {
                EventModel eventModel = EventViewerTable.this.model;
                synchronized (eventModel) {
                    EventViewerTable.this.updateFilters();
                    super.paintComponent(graphics);
                }
            }
        };
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableColumn tableColumn;
                int n3;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 6 && (n3 = component.getPreferredSize().width + jTable.getIntercellSpacing().width) > (tableColumn = jTable.getColumnModel().getColumn(n2)).getWidth()) {
                    tableColumn.setMaxWidth(Integer.MAX_VALUE);
                    tableColumn.setMaxWidth(n3);
                    tableColumn.setMinWidth(n3);
                }
                return component;
            }
        });
        this.table.setDefaultRenderer(Color.class, new ColorRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.handlePopupTrigger(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.handlePopupTrigger(mouseEvent);
            }

            private void handlePopupTrigger(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu;
                    int n = EventViewerTable.this.table.rowAtPoint(mouseEvent.getPoint());
                    if (!this.isRowSelected(n)) {
                        EventViewerTable.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if ((jPopupMenu = EventViewerTable.this.getPopupMenu()) != null) {
                        jPopupMenu.show(EventViewerTable.this.table, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }

            private boolean isRowSelected(int n) {
                int[] nArray = EventViewerTable.this.table.getSelectedRows();
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray[n3];
                    if (n == n4) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
        });
        this.table.setFillsViewportHeight(true);
        EventViewerTable.restoreTraversalKeys(this.table);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.updateTable();
    }

    protected JPopupMenu getPopupMenu() {
        return null;
    }

    private static void restoreTraversalKeys(JTable jTable) {
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke("TAB"));
        jTable.setFocusTraversalKeys(0, hashSet);
        HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(jTable.getFocusTraversalKeys(1));
        hashSet2.add(KeyStroke.getKeyStroke("shift TAB"));
        jTable.setFocusTraversalKeys(1, hashSet2);
    }

    private static TreeTableModel makeFilterModel(final EventModel eventModel, final EventFilterModel eventFilterModel) {
        final EventGroup[] eventGroupArray = new EventGroup[eventModel.getNumberOfEventGroups()];
        int n = 0;
        while (n < eventGroupArray.length) {
            eventGroupArray[n] = new EventGroup(eventModel.getEventGroupName(n), eventModel.getEventTypes(n));
            ++n;
        }
        return new AbstractTreeTableModel(new Object()){

            @Override
            public int getChildCount(Object object) {
                if (object instanceof Integer) {
                    return 0;
                }
                if (object instanceof EventGroup) {
                    return ((EventGroup)object).getEventTypes().length;
                }
                return eventGroupArray.length;
            }

            @Override
            public Object getChild(Object object, int n) {
                if (object instanceof Integer) {
                    return null;
                }
                if (object instanceof EventGroup) {
                    return ((EventGroup)object).getEventTypes()[n];
                }
                return eventGroupArray[n];
            }

            @Override
            public void setValueAt(Object object, Object object2, int n) {
                if (n == 1 && object instanceof Boolean) {
                    Object object3;
                    Boolean bl = (Boolean)object;
                    if (object2 instanceof Integer) {
                        eventFilterModel.setEventTypeFilterEnabled((Integer)object2, bl);
                        object3 = this.findNodeParent(object2);
                        int n2 = 0;
                        while (n2 < eventGroupArray.length) {
                            if (eventGroupArray[n2] == object3) {
                                this.fireTreeNodesChanged(this, this.getPathToRoot(this.root), new int[]{n2}, eventGroupArray);
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (object2 instanceof EventGroup) {
                        object3 = (EventGroup)object2;
                        int[] nArray = ((EventGroup)object3).getEventTypes();
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            eventFilterModel.setEventTypeFilterEnabled(nArray[n3], bl);
                            ++n3;
                        }
                        int[] nArray2 = new int[nArray.length];
                        int n4 = 0;
                        while (n4 < nArray2.length) {
                            nArray2[n4] = n4;
                            ++n4;
                        }
                        Object[] objectArray = new Object[nArray.length];
                        int n5 = 0;
                        while (n5 < objectArray.length) {
                            objectArray[n5] = nArray[n5];
                            ++n5;
                        }
                        this.fireTreeNodesChanged(this, this.getPathToRoot(object2), nArray2, objectArray);
                    }
                }
            }

            protected Object[] getPathToRoot(Object object) {
                return this.getPathToRoot(object, 0);
            }

            private Object[] getPathToRoot(Object object, int n) {
                if (object == null) {
                    return new Object[n];
                }
                Object[] objectArray = this.getPathToRoot(this.findNodeParent(object), ++n);
                objectArray[objectArray.length - n] = object;
                return objectArray;
            }

            private Object findNodeParent(Object object) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    int n2 = 0;
                    while (n2 < eventGroupArray.length) {
                        int[] nArray = eventModel.getEventTypes(n2);
                        int n3 = nArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int n5 = nArray[n4];
                            if (n5 == n) {
                                return eventGroupArray[n2];
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                if (object instanceof EventGroup) {
                    return this.root;
                }
                return null;
            }

            @Override
            public boolean isCellEditable(Object object, int n) {
                return n == 1;
            }

            @Override
            public Object getValueAt(Object object, int n) {
                if (object instanceof Integer) {
                    return n == 0 ? eventModel.getEventTypeName((Integer)object) : Boolean.valueOf(eventFilterModel.isEventTypeFilterEnabled((Integer)object));
                }
                if (object instanceof EventGroup) {
                    if (n == 0) {
                        return object.toString();
                    }
                    EventGroup eventGroup = (EventGroup)object;
                    int[] nArray = eventGroup.getEventTypes();
                    Boolean bl = eventFilterModel.isEventTypeFilterEnabled(nArray[0]);
                    int n2 = 1;
                    while (n2 < nArray.length) {
                        if (eventFilterModel.isEventTypeFilterEnabled(nArray[n2]) != bl.booleanValue()) {
                            bl = null;
                            break;
                        }
                        ++n2;
                    }
                    return bl;
                }
                return null;
            }

            @Override
            public String getColumnName(int n) {
                return null;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return n == 0 ? int[].class : Boolean.class;
            }
        };
    }

    private AbstractTableModel makeTableModel() {
        return new AbstractTableModel(){
            private final Timer throttleFireTableDataChanged = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doFireTableDataChanged();
                }
            });
            private final Runnable throttleFireTableDataChangedRunnable = new Runnable(){
                private long lastRestart;

                @Override
                public void run() {
                    if (!throttleFireTableDataChanged.isRunning()) {
                        long l = System.currentTimeMillis();
                        if (l - this.lastRestart >= (long)(throttleFireTableDataChanged.getDelay() * 2)) {
                            this.doFireTableDataChanged();
                        }
                        this.lastRestart = l;
                        throttleFireTableDataChanged.restart();
                    }
                }
            };
            private final String[] COLUMN_NAMES = new String[]{"Scanline", "Dot", "Event", "Old Value", "New Value", "PC", "Details"};
            private final String[] HEX_STRINGS = new String[256];
            {
                char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
                char[] cArray2 = new char[]{'0', '0'};
                int n = 0;
                while (n < this.HEX_STRINGS.length) {
                    cArray2[0] = cArray[n >> 4];
                    cArray2[1] = cArray[n & 0xF];
                    this.HEX_STRINGS[n] = new String(cArray2);
                    ++n;
                }
                this.throttleFireTableDataChanged.setRepeats(false);
            }

            @Override
            public Object getValueAt(int n, int n2) {
                EventColorModel eventColorModel = EventViewerTable.this.getEventColorModel();
                if (eventColorModel == null) {
                    ++n2;
                }
                switch (n2) {
                    case 0: {
                        return eventColorModel != null ? eventColorModel.getColor(EventViewerTable.this.getModel().getEventType(EventViewerTable.this.getFrame(), EventViewerTable.this.filteredIndices[n])) : null;
                    }
                    case 1: {
                        return EventViewerTable.this.getModel().getScanline(EventViewerTable.this.getFrame(), EventViewerTable.this.filteredIndices[n]);
                    }
                    case 2: {
                        int n3 = EventViewerTable.this.getModel().getDot(EventViewerTable.this.getFrame(), EventViewerTable.this.filteredIndices[n]);
                        return n3 >= 0 ? Integer.valueOf(n3) : null;
                    }
                    case 3: {
                        return EventViewerTable.this.getModel().getEventName(EventViewerTable.this.getFrame(), EventViewerTable.this.filteredIndices[n]);
                    }
                    case 4: {
                        int n4 = EventViewerTable.this.getModel().getOldValue(EventViewerTable.this.getFrame(), EventViewerTable.this.filteredIndices[n]);
                        return n4 >= 0 ? (n4 >= 256 ? String.valueOf(this.HEX_STRINGS[n4 >> 8]) + this.HEX_STRINGS[n4 & 0xFF] : this.HEX_STRINGS[n4]) : null;
                    }
                    case 5: {
                        int n5 = EventViewerTable.this.getModel().getNewValue(EventViewerTable.this.getFrame(), EventViewerTable.this.filteredIndices[n]);
                        return n5 >= 0 ? (n5 >= 256 ? String.valueOf(this.HEX_STRINGS[n5 >> 8]) + this.HEX_STRINGS[n5 & 0xFF] : this.HEX_STRINGS[n5]) : null;
                    }
                    case 6: {
                        return EventViewerTable.this.getModel().getPCasString(EventViewerTable.this.getFrame(), EventViewerTable.this.filteredIndices[n]);
                    }
                    case 7: {
                        return EventViewerTable.this.getModel().getDetails(EventViewerTable.this.getFrame(), EventViewerTable.this.filteredIndices[n]);
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public int getRowCount() {
                return EventViewerTable.this.numberOfFilteredIndices;
            }

            @Override
            public String getColumnName(int n) {
                if (EventViewerTable.this.getEventColorModel() != null) {
                    if (n == 0) {
                        return null;
                    }
                    --n;
                }
                return this.COLUMN_NAMES[n];
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (EventViewerTable.this.getEventColorModel() != null && n == 0) {
                    return Color.class;
                }
                return super.getColumnClass(n);
            }

            protected void doFireTableDataChanged() {
                super.fireTableDataChanged();
            }

            @Override
            public void fireTableDataChanged() {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.throttleFireTableDataChangedRunnable.run();
                } else {
                    SwingUtilities.invokeLater(this.throttleFireTableDataChangedRunnable);
                }
            }

            @Override
            public int getColumnCount() {
                return EventViewerTable.this.getEventColorModel() != null ? this.COLUMN_NAMES.length + 1 : this.COLUMN_NAMES.length;
            }
        };
    }

    public void updateTable() {
        int n = this.getFrame();
        int n2 = this.model.getNumberOfEvents(n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.isEventFilterEnabled(n, n4)) {
                ++n3;
            }
            ++n4;
        }
        if (n3 != this.numberOfFilteredIndices) {
            this.tableModel.fireTableDataChanged();
            if (this.numberOfFilteredIndices == 0) {
                this.numberOfFilteredIndices = 1;
            }
        } else {
            this.tableModel.fireTableRowsUpdated(0, n3);
        }
    }

    protected void updateFilters() {
        int n = this.getFrame();
        int n2 = this.model.getNumberOfEvents(n);
        int[] nArray = this.filteredIndices.length < n2 ? new int[n2] : this.filteredIndices;
        int[] nArray2 = this.filteredRows.length < n2 ? new int[n2] : this.filteredRows;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.isEventFilterEnabled(n, n4)) {
                nArray2[n4] = n3;
                nArray[n3++] = n4;
            } else {
                nArray2[n4] = -1;
            }
            ++n4;
        }
        n4 = n3 != this.numberOfFilteredIndices ? 1 : 0;
        this.numberOfFilteredIndices = n3;
        this.filteredIndices = nArray;
        this.filteredRows = nArray2;
        if (n4 != 0) {
            this.tableModel.fireTableDataChanged();
        }
    }

    protected boolean isEventFilterEnabled(int n, int n2) {
        int n3 = this.model.getEventType(n, n2);
        return this.filterModel.isEventTypeFilterEnabled(n3) && (this.filterModel.isShowReads() || !this.model.isRead(n, n2));
    }

    public void setModel(EventModel eventModel) {
        this.model = eventModel;
        this.filterModel.removeEventFilterListener(this);
        this.filterModel = new DefaultEventFilterModel(eventModel);
        this.filterModel.addEventFilterListener(this);
        this.treeTable.setModel(EventViewerTable.makeFilterModel(eventModel, this.filterModel));
        this.treeTable.getColumnModel().getColumn(1).setMaxWidth(this.treeTable.getCellRenderer((int)0, (int)1).getTableCellRendererComponent((JTable)this.treeTable, (Object)this.treeTable.getValueAt((int)0, (int)1), (boolean)false, (boolean)false, (int)0, (int)1).getPreferredSize().width);
        this.treeTable.expandFirstLevel();
        this.updateTable();
    }

    public EventModel getModel() {
        return this.model;
    }

    public void setEventColorModel(EventColorModel eventColorModel) {
        this.eventColorModel = eventColorModel;
        this.tableModel.fireTableStructureChanged();
    }

    public EventColorModel getEventColorModel() {
        return this.eventColorModel;
    }

    public EventFilterModel getFilterModel() {
        return this.filterModel;
    }

    public int getFrame() {
        return this.prevFrame.isSelected() ? -1 : 0;
    }

    public int getSelectedEvent() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        return this.filteredIndices[n];
    }

    public boolean isEventSelected(int n) {
        return n < this.filteredRows.length && this.table.isRowSelected(this.filteredRows[n]);
    }

    public void setEventSelected(int n, boolean bl) {
        int n2 = this.filteredRows[n];
        if (bl) {
            this.table.getSelectionModel().addSelectionInterval(n2, n2);
        } else {
            this.table.getSelectionModel().removeSelectionInterval(n2, n2);
        }
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public void scrollEventToVisible(int n) {
        int n2 = this.filteredRows[n];
        this.table.scrollRectToVisible(this.table.getCellRect(n2, 0, true));
    }

    public Color getTableForeground() {
        return null;
    }

    protected Color getSelectionForeground() {
        return null;
    }

    public Color getTableBackground() {
        return null;
    }

    protected Color getSelectionBackground() {
        return null;
    }

    protected Border getFilterBorder() {
        return null;
    }

    @Override
    public void eventFilterChanged(int n, boolean bl) {
        this.updateTable();
    }

    static class ColorRenderer
    extends JPanel
    implements TableCellRenderer,
    UIResource {
        private Color color;

        ColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Color) {
                this.color = (Color)object;
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private static class EventGroup {
        private final String name;
        private final int[] eventTypes;

        public EventGroup(String string, int[] nArray) {
            this.name = string;
            this.eventTypes = nArray;
        }

        public int[] getEventTypes() {
            return this.eventTypes;
        }

        public String toString() {
            return this.name;
        }
    }

    static class TriStateRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        boolean semiChecked;

        public TriStateRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.setModel(new JToggleButton.ToggleButtonModel(){

                @Override
                public boolean isArmed() {
                    return TriStateRenderer.this.semiChecked || super.isArmed();
                }

                @Override
                public boolean isPressed() {
                    return TriStateRenderer.this.semiChecked || super.isPressed();
                }

                @Override
                public boolean isSelected() {
                    return TriStateRenderer.this.semiChecked || super.isSelected();
                }
            });
        }

        private void setSemiChecked() {
            this.semiChecked = true;
            this.revalidate();
        }

        @Override
        public void setSelected(boolean bl) {
            this.semiChecked = false;
            super.setSelected(bl);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            if (object == null) {
                this.setSemiChecked();
            } else {
                this.setSelected((Boolean)object);
            }
            this.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }
}

