/*
 * Decompiled with CFR 0.152.
 */
package components.video;

import components.video.TMS9918A;
import java.util.BitSet;

public class SMS2VDP
extends TMS9918A {
    private int hCounter;
    private int th0fallingCycle;
    private int th0risingCycle;
    private int th1fallingCycle;
    private int th1risingCycle;
    private final BitSet updateHcounterCycle = new BitSet(228);

    public SMS2VDP(int n) {
        super(n, new int[16384], new int[32], new int[11]);
    }

    @Override
    protected int makeModeBits() {
        return (this.regs[0] & 4) << 1 | super.makeModeBits();
    }

    @Override
    public String getModeName(int n) {
        switch (n) {
            case 9: 
            case 13: {
                return "Invalid text mode";
            }
            case 11: {
                return "M4 (224 lines)";
            }
            case 14: {
                return "M4 (240 lines)";
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                return "M4";
            }
        }
        return super.getModeName(n);
    }

    public boolean isVertScrollInhibited() {
        return (this.regs[0] & 0x80) != 0;
    }

    public boolean isHorizScrollInhibited() {
        return (this.regs[0] & 0x40) != 0;
    }

    public boolean isLeftColumnBlank() {
        return (this.regs[0] & 0x20) != 0;
    }

    private int getHCounter() {
        return this.hCounter;
    }

    private int getVCounter(int n) {
        this.update(n);
        this.timer += n;
        return (this.getLine() >= this.getScreenHeight() + this.getLinesBottomBorder() + 3 ? this.getLine() - (this.getScanlines() - 256) : this.getLine()) & 0xFF;
    }

    public int readCounter(int n, int n2) {
        switch (n & 1) {
            case 0: {
                return this.getVCounter(n2);
            }
            case 1: {
                this.update(n2);
                int n3 = this.updateHcounterCycle.nextSetBit(0);
                while (n3 >= 0 && 228 - this.timer >= n3) {
                    this.hCounter = SMS2VDP.calcHcounter(n3);
                    n3 = this.updateHcounterCycle.nextSetBit(n3 + 1);
                }
                this.timer += n2;
                return this.getHCounter() >> 1;
            }
        }
        return 255;
    }

    private static final int calcHcounter(int n) {
        if (n > 212) {
            return n * 342 / 228 + 147 & 0x1FF;
        }
        return n * 342 / 228 - 23 & 0x1FF;
    }

    public void updateHcounter(int n) {
        this.update(n);
        this.updateHcounterAt(228 - this.timer);
        this.timer += n;
    }

    public boolean isTH0low(int n) {
        this.update(n);
        boolean bl = 228 - this.timer >= this.th0fallingCycle && 228 - this.timer < this.th0risingCycle;
        this.timer += n;
        return bl;
    }

    public boolean isTH1low(int n) {
        this.update(n);
        boolean bl = 228 - this.timer >= this.th1fallingCycle && 228 - this.timer < this.th1risingCycle;
        this.timer += n;
        return bl;
    }

    public void setTH0cycles(int n, int n2) {
        this.updateHcounterAtX(n);
        int n3 = SMS2VDP.pixelToCycles(n);
        if (n3 < this.th0fallingCycle) {
            this.th0fallingCycle = n3;
        }
        if ((n3 = SMS2VDP.pixelToCycles(n2)) > this.th0risingCycle) {
            this.th0risingCycle = n3;
        }
    }

    public void setTH1cycles(int n, int n2) {
        this.updateHcounterAtX(n);
        int n3 = SMS2VDP.pixelToCycles(n);
        if (n3 < this.th1fallingCycle) {
            this.th1fallingCycle = n3;
        }
        if ((n3 = SMS2VDP.pixelToCycles(n2)) > this.th1risingCycle) {
            this.th1risingCycle = n3;
        }
    }

    private void updateHcounterAtX(int n) {
        this.updateHcounterAt(SMS2VDP.pixelToCycles(n));
    }

    private void updateHcounterAt(int n) {
        this.updateHcounterCycle.set(Math.max(0, n));
    }

    private void resetTHlines() {
        this.th0fallingCycle = 228;
        this.th0risingCycle = 0;
        this.th1fallingCycle = 228;
        this.th1risingCycle = 0;
        if (!this.updateHcounterCycle.isEmpty()) {
            this.hCounter = SMS2VDP.calcHcounter(this.updateHcounterCycle.length() - 1);
        }
        this.updateHcounterCycle.clear();
    }

    @Override
    protected void latchValues() {
        super.latchValues();
        if (this.line <= this.height) {
            if (--this.counter < 0) {
                this.counter = this.regs[10];
                this.lineInterruptPending = true;
                if (this.isLineInterruptEnabled()) {
                    if (this.timer < 0) {
                        this.fireOutputAvailable(1114303, 2);
                    } else {
                        this.lineInterruptDelayed = true;
                    }
                }
            }
        } else {
            this.counter = this.regs[10];
        }
    }

    @Override
    protected void renderLine() {
        this.resetTHlines();
        super.renderLine();
    }

    @Override
    protected boolean isLineInterruptEnabled() {
        return (this.regs[0] & 0x10) != 0;
    }

    public boolean isSpriteShiftEnabled() {
        return (this.regs[0] & 8) != 0;
    }

    @Override
    public int getHorizontalScroll() {
        if (this.getLine() < 16 && this.isHorizScrollInhibited()) {
            return 0;
        }
        return super.getHorizontalScroll();
    }

    @Override
    public int getVerticalScroll() {
        return super.getVerticalScroll();
    }

    @Override
    public void setSpriteCollisionX(int n) {
        if (n < 8 && this.isLeftColumnBlank()) {
            return;
        }
        super.setSpriteCollisionX(n);
    }

    @Override
    public int getSpritePatternAddress() {
        if ((this.getModeBits() & 8) != 0) {
            return (this.regs[6] & 4) << 11;
        }
        return super.getSpritePatternAddress();
    }

    @Override
    protected int makeSATaddress() {
        if ((this.getModeBits() & 8) != 0) {
            return (this.regs[5] & 0x7E) << 7;
        }
        return super.makeSATaddress();
    }

    @Override
    public int getSpritesDoneY() {
        return this.getScreenHeight() + 16;
    }

    public int getBackDropColor(int n) {
        return super.getBackDropColor(n, 0);
    }

    @Override
    public int getColorTableMask() {
        return 16383;
    }

    @Override
    public int getPatternGeneratorTableAddress() {
        switch (this.getModeBits()) {
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return 0;
            }
        }
        return super.getPatternGeneratorTableAddress();
    }

    @Override
    public int getPatternGeneratorTableMask() {
        return 16383;
    }

    @Override
    public int getScreenHeight() {
        switch (this.getModeBits()) {
            case 11: {
                return 224;
            }
            case 14: {
                return 240;
            }
        }
        return super.getScreenHeight();
    }

    @Override
    public int getScreenMapBaseAddress() {
        if (this.getScreenHeight() > 192) {
            return super.getScreenMapBaseAddress() & 0x3000 | 0x700;
        }
        if ((this.makeModeBits() & 8) != 0) {
            return super.getScreenMapBaseAddress() & 0x3800;
        }
        return super.getScreenMapBaseAddress();
    }

    @Override
    public int getScreenMapBaseAddress(int n) {
        if (this.getScreenHeight() > 192) {
            return super.getScreenMapBaseAddress(n) & 0x3000 | 0x700;
        }
        if ((this.getModeBits() & 8) != 0) {
            return super.getScreenMapBaseAddress(n) & 0x3800;
        }
        return super.getScreenMapBaseAddress(n);
    }

    @Override
    public void reset() {
        this.hCounter = 0;
        this.updateHcounterCycle.clear();
        super.reset();
    }
}

