/*
 * Decompiled with CFR 0.152.
 */
package components.video;

import components.OutputListener;
import components.cpu.LR35902;
import components.video.GBCLCDController;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.LinkedList;

public class GBLCDController {
    public static final int SIGNATURE = 0x110000;
    public static final int INACCESSIBLE_VRAM = 0x110100;
    public static final int INACCESSIBLE_PALETTE = 0x110101;
    public static final int INACCESSIBLE_OAM = 0x110102;
    public static final int TURN_OFF_LCD_OUTSIDE_VBLANK = 0x110103;
    public static final int OAM_BUG = 0x110104;
    public static final int VRAM_WRITE = 0x110000;
    public static final int VRAM_READ = 0x110001;
    public static final int OAM_WRITE = 0x110002;
    public static final int OAM_READ = 0x110003;
    public static final int RENDER_FRAME = 0x110010;
    public static final int DMA_MASK = 32768;
    public static final int VRAM_CHANGE_MASK = 16384;
    public static final int ADDRESS_MASK = 16383;
    public static final int DATA_OFFSET = 16;
    public static final int DATA_MASK = 0xFF0000;
    protected static final int[] CYCLES = new int[]{204, 456, 80, 172};
    private final LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    protected int timerMode;
    private int mode3additionalTime;
    protected int line153cycles;
    private boolean firstFrame;
    private boolean lineMainPart;
    protected boolean lineLastCycle;
    private boolean mode3lastCycles;
    protected boolean hdmaReady;
    private boolean wySatisfied;
    private boolean wxSatisfied;
    private int windowLine;
    protected int cyclesSinceLastFrame;
    private final int[] dmaWritesDuringMode2 = new int[40];
    private int firstDmaWriteDuringMode2;
    private int lastDmaWriteDuringMode2;
    private final int[] dmaWritesDuringMode3 = new int[40];
    private int firstDmaWriteDuringMode3;
    private int lastDmaWriteDuringMode3;
    private final int[][] cycleOffsets = new int[154][176];
    private final int[] mode3cycles = new int[154];
    private final int[] mode3dotMapping = new int[160];
    private final int[] mode3buckets = new int[22];
    private int[] currentCycleOffsets = this.cycleOffsets[0];
    protected int[] vram;
    protected final int[] oam = new int[160];
    private final int[] spriteBuffer = new int[10];
    private int spriteCount;
    private int regLCDC;
    protected final int[] lcdc = new int[this.currentCycleOffsets.length];
    private final boolean[] bgDisplayEnabled = new boolean[this.currentCycleOffsets.length];
    private final boolean[] objDisplayEnabled = new boolean[this.currentCycleOffsets.length];
    private int regSTAT;
    private int regSCY;
    private int regSCX;
    private int regLY;
    private int regLYC;
    private int regWY;
    private int regWX;
    private int scxLow;
    private final int[] scx = new int[this.currentCycleOffsets.length];
    private final int[] scy = new int[this.currentCycleOffsets.length];
    private final int[] wx = new int[this.currentCycleOffsets.length];
    private int windowEnabledWX;
    private int regBGP;
    private int regOBP0;
    private int regOBP1;
    protected final int[] bgp = new int[this.currentCycleOffsets.length];
    protected final int[] obp0 = new int[this.currentCycleOffsets.length];
    protected final int[] obp1 = new int[this.currentCycleOffsets.length];
    private int regDMA;

    public GBLCDController() {
        this.vram = new int[8192];
    }

    public int[] getVRAM() {
        return this.vram;
    }

    public int[] getOAM() {
        return this.oam;
    }

    public int getSpriteBufferX(int n) {
        return this.spriteBuffer[n] >> 8 & 0xFF;
    }

    public int getSpriteBufferY(int n) {
        return this.spriteBuffer[n] >> 16 & 0xFF;
    }

    public int getSpriteBufferIndex(int n) {
        return this.spriteBuffer[n] & 0xFF;
    }

    public int getSpriteTileNumber(int n, int n2) {
        if (n2 >= this.firstDmaWriteDuringMode3 && n2 <= this.lastDmaWriteDuringMode3) {
            return this.dmaWritesDuringMode3[n2 / 4];
        }
        return this.oam[n << 2 | 2];
    }

    public int getSpriteAttributes(int n, int n2) {
        if (n2 >= this.firstDmaWriteDuringMode3 && n2 <= this.lastDmaWriteDuringMode3) {
            return this.dmaWritesDuringMode3[n2 / 4];
        }
        return this.oam[n << 2 | 3];
    }

    public int getSpriteCount() {
        return this.spriteCount;
    }

    public int getMode() {
        return 0;
    }

    public int mixWithTileSelReset(int n, int n2, int n3) {
        return n3;
    }

    public boolean isBGDisplayEnabled(int n) {
        return this.bgDisplayEnabled[n];
    }

    public boolean isBGPriorityOverride(int n) {
        return !this.bgDisplayEnabled[n];
    }

    public boolean isOBJDisplayEnabled(int n) {
        return this.objDisplayEnabled[n];
    }

    public int getOBJHeight(int n) {
        if ((this.lcdc[n + 3] & 4) != 0) {
            return 16;
        }
        return 8;
    }

    public int getBGTileMapDisplayAddress() {
        return (this.regLCDC & 8) != 0 ? 7168 : 6144;
    }

    public int getBGTileMapDisplayAddress(int n) {
        if ((this.lcdc[n << 3 | 3] & 8) != 0) {
            return 7168;
        }
        return 6144;
    }

    public int getBGandWindowDataAddress() {
        return (this.regLCDC & 0x10) != 0 ? 0 : 2048;
    }

    public int getBGandWindowDataAddress(int n, int n2) {
        if ((this.lcdc[Math.max(0, n + 5 + n2)] & 0x10) != 0) {
            return 0;
        }
        return 2048;
    }

    public boolean isWindowDisplayEnabled(int n) {
        return (this.lcdc[n << 3] & 0x20) != 0;
    }

    public int getWindowTileMapDisplayAddress() {
        return (this.regLCDC & 0x40) != 0 ? 7168 : 6144;
    }

    public int getWindowTileMapDisplayAddress(int n) {
        if ((this.lcdc[n << 3 | 3] & 0x40) != 0) {
            return 7168;
        }
        return 6144;
    }

    public boolean isLCDDisplayEnabled() {
        return (this.regLCDC & 0x80) != 0;
    }

    public void updateWySatisfied(int n) {
        if (this.regWY == n && (this.regLCDC & 0x20) != 0) {
            this.wySatisfied = true;
        }
    }

    public boolean isWySatisfied() {
        return this.wySatisfied;
    }

    public int getWindowLine() {
        return this.windowLine;
    }

    public void incWindowLine() {
        ++this.windowLine;
    }

    public boolean isFirstFrame() {
        return this.firstFrame;
    }

    public boolean isOBJxBasedPriority() {
        return true;
    }

    public int getRegLCDC() {
        return this.regLCDC;
    }

    public int getRegSTAT() {
        return this.regSTAT;
    }

    public int getSCY(int n) {
        return this.getSCY(n, 0);
    }

    public int getSCY(int n, int n2) {
        int n3 = this.scy[Math.max(0, n)];
        if ((n3 & 0x1000) == 0) {
            n3 = this.scy[Math.max(0, n + n2)];
        }
        return n3 & 0xFF;
    }

    public int getRegSCY() {
        return this.regSCY;
    }

    public int getSCX(int n) {
        return this.scx[n << 3];
    }

    public int getSCXlow() {
        return this.scxLow;
    }

    public int getRegSCX() {
        return this.regSCX;
    }

    public int getRegLY() {
        return this.regLY;
    }

    public int getRegLYC() {
        return this.regLYC;
    }

    public int getRegWY() {
        return this.regWY;
    }

    public int getRegWX() {
        return this.regWX;
    }

    public int getWX(int n) {
        return this.wx[n];
    }

    public int getWindowEnabledWX() {
        return this.windowEnabledWX;
    }

    public int getRegBGP() {
        return this.regBGP;
    }

    public int getRegBGP(int n) {
        return this.bgp[n];
    }

    public int getRegOBP0() {
        return this.regOBP0;
    }

    public int getRegOBP0(int n) {
        return this.obp0[n];
    }

    public int getRegOBP1() {
        return this.regOBP1;
    }

    public int getRegOBP1(int n) {
        return this.obp1[n];
    }

    public int getRegDMA() {
        return this.regDMA;
    }

    public long getBGP(int n, int n2) {
        return this.getRegBGP(n);
    }

    public long getOBP(int n) {
        if (n == 1) {
            return this.regOBP1;
        }
        return this.regOBP0;
    }

    public void setBGP(int n, long l) {
        this.regBGP = (int)l;
    }

    public void setOBP(int n, long l) {
        if (n == 1) {
            this.regOBP1 = (int)l;
        } else {
            this.regOBP0 = (int)l;
        }
    }

    public int readPort(int n, int n2) {
        this.update(n2);
        if (n == 65) {
            if (this.regLY == 153) {
                if (this.line153cycles > 4 && this.timerMode <= 4 && !(this instanceof GBCLCDController)) {
                    this.fireOutputAvailable(65, this.regSTAT & 0xFFFFFFFC, n2);
                }
            } else if (this.mode3lastCycles) {
                this.fireOutputAvailable(65, this.regSTAT & 0xFFFFFFFC, n2);
            }
        } else if (n == 68) {
            if (this.regLY == 153) {
                if (this.line153cycles > 0 || !(this instanceof GBCLCDController)) {
                    this.fireOutputAvailable(n, 0, n2);
                }
            } else if (this.lineLastCycle) {
                this.fireOutputAvailable(n, this.regLY + 1, n2);
            }
        }
        this.timerMode += n2;
        this.cyclesSinceLastFrame -= n2;
        return 255;
    }

    public void processInput(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = n3 != this.timerMode || n != 67 && n != 75;
        if (bl) {
            this.update(n3);
        }
        switch (n) {
            case 64: {
                boolean bl3;
                if (((n2 ^ this.regLCDC) & 0x80) != 0) {
                    this.regLCDC = n2;
                    this.fireOutputAvailable(64, (this.regLCDC & 0x80) << 1 | this.regLCDC, n3);
                    if ((n2 & 0x80) != 0) {
                        this.wySatisfied = false;
                        this.firstFrame = true;
                        this.setRegSTAT(this.regSTAT | 2, false, n3);
                        this.timerMode = CYCLES[2];
                    } else {
                        if ((this.regSTAT & 3) != 1 && n3 != 0) {
                            this.fireTurnOffLcdOutsideVblank();
                        }
                        this.cyclesSinceLastFrame = 0;
                        this.setRegSTAT(this.regSTAT & 0xFFFFFFFC, false, n3);
                        this.hdmaReady = true;
                        this.timerMode = CYCLES[0];
                    }
                    this.regLY = 0;
                    this.fireOutputAvailable(68, 0, n3);
                }
                boolean bl4 = ((this.regLCDC ^ n2) & 2) != 0;
                this.regLCDC = n2;
                if ((n2 & 0x20) != 0 && this.regLY == this.regWY) {
                    this.wySatisfied = true;
                }
                if ((this.regSTAT & 3) != 3) break;
                int n4 = this.calcCurrentDot() - 80;
                int n5 = this.toScreenDot(this.regLY, n4);
                boolean bl5 = bl3 = n5 >= 0 && (n5 & 0x100) != 0;
                if (bl3) {
                    n5 = (n5 & 0xFFFFFEFF) - 8;
                }
                if (n5 + 12 < this.lcdc.length) {
                    Arrays.fill(this.lcdc, Math.max(0, n5 + 12), this.lcdc.length, this.regLCDC);
                }
                if ((n5 = this.toScreenDot(this.regLY, n4 + 1)) <= 0 || (n5 & 0x100) != 0) {
                    n5 = (n5 & 0xFFFFFEFF) - 8;
                    --n5;
                }
                if (n5 + 1 < this.bgDisplayEnabled.length) {
                    Arrays.fill(this.bgDisplayEnabled, Math.max(0, n5 + 1), this.bgDisplayEnabled.length, (this.regLCDC & 1) != 0);
                }
                if (n5 + 1 < this.objDisplayEnabled.length) {
                    Arrays.fill(this.objDisplayEnabled, Math.max(0, n5 + 1), this.objDisplayEnabled.length, (this.regLCDC & 2) != 0);
                }
                if (!bl4 || n5 < 0 || (n2 & 2) != 0 || this instanceof GBCLCDController) break;
                int n6 = this.scxLow;
                int[] nArray = this.mode3buckets;
                int n7 = this.wySatisfied && this.isWindowDisplayEnabled(0) && this.regWX <= 166 ? this.regWX - 7 & 7 : 0;
                int n8 = 0;
                while (n8 < this.spriteCount) {
                    int n9 = this.getSpriteBufferIndex(n8);
                    int n10 = this.oam[n9 << 2 | 1];
                    if (n10 >= n5 + 9 && n10 < 168) {
                        int n11 = n10 > this.regWX ? -n7 : 0;
                        int n12 = n10 + n6 >> 3;
                        nArray[n12] = Math.max(nArray[n12], 5 - (n10 + n6 + n11 & 7));
                        int n13 = n10 + n6;
                        this.currentCycleOffsets[n13] = this.currentCycleOffsets[n13] - 6;
                        this.timerMode -= this.mode3additionalTime & 0xFFFFFFFC;
                        this.mode3additionalTime -= 6;
                        this.timerMode += this.mode3additionalTime & 0xFFFFFFFC;
                        this.mode3cycles[this.regLY] = CYCLES[3] + this.mode3additionalTime;
                    }
                    ++n8;
                }
                break;
            }
            case 65: {
                this.setRegSTAT(n2 & 0x78 | this.regSTAT & 3, true, n3);
                break;
            }
            case 66: {
                boolean bl6;
                this.regSCY = n2;
                if ((this.regSTAT & 3) != 3) break;
                int n14 = this.calcCurrentDot() - 80;
                int n15 = this.toScreenDot(this.regLY, n14);
                boolean bl7 = bl6 = n15 >= 0 && (n15 & 0x100) != 0;
                if (bl6) {
                    n15 = (n15 & 0xFFFFFEFF) - 8;
                    n15 = this instanceof GBCLCDController ? --n15 : (n15 += 4);
                } else {
                    ++n15;
                }
                if (n15 < -8) {
                    n15 += 4;
                }
                if (this instanceof GBCLCDController) {
                    n15 += 2;
                }
                if ((n15 = Math.max(0, n15)) >= this.scy.length) break;
                int n16 = this.toScreenDot(this.regLY, n14 - 2);
                if (n16 >= 0) {
                    // empty if block
                }
                Arrays.fill(this.scy, n15, this.scy.length, this.regSCY);
                break;
            }
            case 67: {
                boolean bl8;
                this.regSCX = n2;
                if ((this.regSTAT & 3) != 3 || CYCLES[3] + this.mode3additionalTime - this.timerMode == 0) {
                    this.scxLow = n2 & 7;
                }
                if ((this.regSTAT & 3) != 3) break;
                int n17 = this.toScreenDot(this.regLY, this.calcCurrentDot() - 80);
                boolean bl9 = bl8 = n17 >= 0 && (n17 & 0x100) != 0;
                if (bl8) {
                    n17 = (n17 & 0xFFFFFEFF) - 8;
                }
                n17 += 9;
                if (this instanceof GBCLCDController) {
                    n17 += 2;
                }
                if ((n17 = Math.max(0, n17)) >= this.scx.length) break;
                Arrays.fill(this.scx, n17, this.scx.length, this.regSCX);
                break;
            }
            case 68: {
                this.fireOutputAvailable(n, this.regLY, n3);
                break;
            }
            case 69: {
                if (this.regLYC == n2) break;
                if ((this.lineLastCycle || this.regLY == 153 && this.line153cycles == 4) && this instanceof GBCLCDController) {
                    this.regLY = (this.regLY + 1) % 154;
                    if (this.regLY == 153) {
                        this.line153cycles = 0;
                    }
                    this.updateCoincidenceFlag();
                    this.regLY = (this.regLY + 153) % 154;
                }
                this.regLYC = n2;
                if ((this.regSTAT & 3) > 1 || this.timerMode > 4 || this.lineMainPart && (this.timerMode > 4 || !(this instanceof GBCLCDController)) || this.regLY == 153 && this.line153cycles == 0 && this.timerMode == 4 && !(this instanceof GBCLCDController)) {
                    this.updateCoincidenceFlag();
                }
                if (this.regLY != 153 || this.line153cycles != 0) break;
                this.line153cycles += 4;
                this.timerMode += 4;
                break;
            }
            case 70: {
                this.regDMA = n2;
                this.fireOutputAvailable(n, this.regDMA, n3);
                break;
            }
            case 71: {
                this.regBGP = n2;
                if ((this.regSTAT & 3) == 3) {
                    boolean bl10;
                    int n18 = this.toScreenDot(this.regLY, this.calcCurrentDot() - 80);
                    boolean bl11 = bl10 = n18 >= 0 && (n18 & 0x100) != 0;
                    n18 = bl10 ? (n18 & 0xFFFFFEFF) - 8 : ++n18;
                    n18 = Math.max(0, n18);
                    if (n18 < this.bgp.length) {
                        Arrays.fill(this.bgp, n18, this.bgp.length, this.regBGP);
                        if (!bl10 && n18 > 0 && !(this instanceof GBCLCDController)) {
                            int n19 = n18;
                            this.bgp[n19] = this.bgp[n19] | this.bgp[n18 - 1];
                        }
                    }
                }
                this.fireOutputAvailable(n, n2, n3);
                break;
            }
            case 72: {
                this.regOBP0 = n2;
                if ((this.regSTAT & 3) == 3) {
                    boolean bl12;
                    int n20 = this.toScreenDot(this.regLY, this.calcCurrentDot() - 80);
                    boolean bl13 = bl12 = n20 >= 0 && (n20 & 0x100) != 0;
                    n20 = bl12 ? (n20 & 0xFFFFFEFF) - 8 : ++n20;
                    n20 = Math.max(0, n20);
                    if (n20 < this.obp0.length) {
                        Arrays.fill(this.obp0, n20, this.obp0.length, this.regOBP0);
                    }
                }
                this.fireOutputAvailable(n, n2, n3);
                break;
            }
            case 73: {
                this.regOBP1 = n2;
                if ((this.regSTAT & 3) == 3) {
                    boolean bl14;
                    int n21 = this.toScreenDot(this.regLY, this.calcCurrentDot() - 80);
                    boolean bl15 = bl14 = n21 >= 0 && (n21 & 0x100) != 0;
                    n21 = bl14 ? (n21 & 0xFFFFFEFF) - 8 : ++n21;
                    n21 = Math.max(0, n21);
                    if (n21 < this.obp1.length) {
                        Arrays.fill(this.obp1, n21, this.obp1.length, this.regOBP1);
                    }
                }
                this.fireOutputAvailable(n, n2, n3);
                break;
            }
            case 74: {
                this.regWY = n2;
                break;
            }
            case 75: {
                boolean bl16;
                int n22;
                if (this.wySatisfied && !this.wxSatisfied && this.regWX <= 166 && (this.regSTAT & 3) == 3 && (n22 = this.calcCurrentDot() - 80) < this.lcdc.length && this.isWindowDisplayEnabled(n22 >> 3)) {
                    if (n22 - 3 >= this.regWX) {
                        this.wxSatisfied = true;
                    } else {
                        int n23 = this.windowEnabledWX + 1;
                        this.currentCycleOffsets[n23] = this.currentCycleOffsets[n23] - 6;
                        if (n22 - 3 < n2) {
                            int n24 = n2 + 1;
                            this.currentCycleOffsets[n24] = this.currentCycleOffsets[n24] + 6;
                            this.windowEnabledWX = n2;
                        } else {
                            this.timerMode -= this.mode3additionalTime & 0xFFFFFFFC;
                            this.mode3additionalTime -= 6;
                            this.timerMode += this.mode3additionalTime & 0xFFFFFFFC;
                            this.mode3cycles[this.regLY] = CYCLES[3] + this.mode3additionalTime;
                            this.windowEnabledWX = 167;
                        }
                    }
                }
                this.regWX = n2;
                if ((this.regSTAT & 3) != 3) break;
                n22 = this.toScreenDot(this.regLY, this.calcCurrentDot() - 80);
                boolean bl17 = bl16 = n22 >= 0 && (n22 & 0x100) != 0;
                n22 = bl16 ? (n22 & 0xFFFFFEFF) - 8 : ++n22;
                n22 = Math.max(0, n22);
                if (n22 >= this.wx.length) break;
                Arrays.fill(this.wx, n22, this.wx.length, this.regWX);
            }
        }
        if (bl) {
            this.timerMode += n3;
            this.cyclesSinceLastFrame -= n3;
        }
    }

    public final int readByte(int n, int n2) {
        this.update(n2);
        if (n < 40960) {
            int n3 = this.readVRAM(n & 0x1FFF);
            this.timerMode += n2;
            this.cyclesSinceLastFrame -= n2;
            return n3;
        }
        boolean bl = this.isOamReadInaccessible();
        if ((n &= 0xFF) < this.oam.length) {
            this.fireOutputAvailable(0x110003, n);
        }
        if (bl) {
            this.handleOamReadBug(n);
            this.fireInaccessibleOam(n);
            this.timerMode += n2;
            this.cyclesSinceLastFrame -= n2;
            return 255;
        }
        this.timerMode += n2;
        this.cyclesSinceLastFrame -= n2;
        return this.readOAM(n);
    }

    private boolean isOamReadInaccessible() {
        return !this.isFirstLine0() && (this.regSTAT & 3) == 2 || (this.regSTAT & 3) == 3 && this.timerMode >= 4 || (this.regSTAT & 3) == 0 && this.lineLastCycle;
    }

    private boolean isVramReadInaccessible() {
        return (this.regSTAT & 3) == 3 && this.timerMode > 2 || (this.regSTAT & 3) == 2 && this.timerMode <= 4 && !this.isFirstLine0();
    }

    protected int readOAM(int n) {
        if (n >= this.oam.length) {
            return 0;
        }
        return this.oam[n];
    }

    protected int readVRAM(int n) {
        boolean bl = this.isVramReadInaccessible();
        this.fireOutputAvailable(0x110001, n);
        if (bl) {
            this.fireInaccessibleVram(n);
            return 255;
        }
        return this.vram[n];
    }

    private boolean isFirstLine0() {
        return this.firstFrame && this.regLY == 0;
    }

    public boolean isOddMode0() {
        return this.isFirstLine0() && (this.regSTAT & 3) == 2;
    }

    public int peekByte(int n) {
        if (n < 40960) {
            return this.peekVRAM(n & 0x1FFF);
        }
        return this.isOamReadInaccessible() ? 255 : this.readOAM(n & 0xFF);
    }

    protected int peekVRAM(int n) {
        return this.isVramReadInaccessible() ? 255 : this.vram[n];
    }

    public void pokeByte(int n, int n2) {
        if (n < 40960) {
            this.pokeVRAM(n & 0x1FFF, n2);
        } else if (n < this.oam.length && !this.isOamWriteInaccessible()) {
            this.oam[n & 0xFF] = n2;
        }
    }

    protected boolean isVramWriteInaccessible() {
        return (this.regSTAT & 3) == 3;
    }

    private boolean isOamWriteInaccessible() {
        return !this.isFirstLine0() && (this.regSTAT & 3) == 2 && (this.timerMode > 4 || this instanceof GBCLCDController) || (this.regSTAT & 3) == 3 && this.timerMode >= 4 || this.lineLastCycle && (this.regSTAT & 3) == 0 && this instanceof GBCLCDController;
    }

    protected void pokeVRAM(int n, int n2) {
        if (!this.isVramWriteInaccessible()) {
            this.vram[n] = n2;
        }
    }

    public final void processWrite(int n, int n2, int n3, boolean bl) {
        this.update(n3);
        if (n < 40960) {
            this.writeVRAM(n & 0x1FFF, n2, bl);
        } else {
            int n4;
            n &= 0xFF;
            int n5 = this.regSTAT & 3;
            if (bl) {
                if (n5 == 2) {
                    if (this.timerMode <= CYCLES[2]) {
                        n4 = (CYCLES[2] - this.timerMode) / 2;
                        if (n4 < this.firstDmaWriteDuringMode2) {
                            this.firstDmaWriteDuringMode2 = n4;
                        }
                        this.dmaWritesDuringMode2[n4] = n;
                        this.lastDmaWriteDuringMode2 = n4;
                    }
                } else if (n5 == 3 && (n4 = this.toScreenDot(this.regLY, this.calcCurrentDot() - 80) & Integer.MAX_VALUE) < 160) {
                    if (n4 < this.firstDmaWriteDuringMode3) {
                        this.firstDmaWriteDuringMode3 = n4;
                    }
                    this.dmaWritesDuringMode3[n4 / 4] = n2;
                    this.lastDmaWriteDuringMode3 = n4;
                }
            }
            int n6 = n4 = !bl && this.isOamWriteInaccessible() ? 1 : 0;
            if (n4 != 0) {
                this.handleOamWriteBug(n);
            }
            if (n < this.oam.length) {
                this.fireOutputAvailable(0x110002, n2 << 16 | (bl ? 32768 : 0) | (this.oam[n] != n2 ? 0x4000 | n : n));
                if (n4 == 0) {
                    this.oam[n] = n2;
                } else {
                    this.fireInaccessibleOam(n);
                }
            }
        }
        this.timerMode += n3;
        this.cyclesSinceLastFrame -= n3;
    }

    protected void writeVRAM(int n, int n2, boolean bl) {
        boolean bl2 = !bl && this.isVramWriteInaccessible();
        this.fireOutputAvailable(0x110000, n2 << 16 | (bl ? 32768 : 0) | (this.vram[n] != n2 ? 0x4000 | n : n));
        if (!bl2) {
            this.vram[n] = n2;
        } else {
            this.fireInaccessibleVram(n);
        }
    }

    public void reset() {
        this.regLCDC = 0;
        this.fireOutputAvailable(64, 0);
        Arrays.fill(this.vram, 0);
        int n = 0;
        while (n < this.vram.length) {
            this.fireOutputAvailable(0x110000, this.vram[n] << 16 | 0x4000 | n);
            ++n;
        }
        this.regDMA = 255;
        this.regSTAT = 132;
        this.timerMode = CYCLES[1];
        this.mode3additionalTime = 0;
        this.firstFrame = false;
        this.lineMainPart = false;
        this.lineLastCycle = false;
        this.mode3lastCycles = false;
        this.regSCY = 0;
        this.fireOutputAvailable(66, 0);
        this.regSCX = 0;
        this.fireOutputAvailable(67, 0);
        this.regLY = 0;
        this.fireOutputAvailable(68, 0);
        this.regLYC = 0;
        this.fireOutputAvailable(69, 0);
        this.regBGP = 252;
        this.fireOutputAvailable(71, 252);
        this.regOBP0 = 255;
        this.fireOutputAvailable(72, 255);
        this.regOBP1 = 255;
        this.fireOutputAvailable(73, 255);
        this.regWY = 0;
        this.fireOutputAvailable(74, 0);
        this.regWX = 0;
        this.fireOutputAvailable(75, 0);
    }

    public void update(int n) {
        if (!this.isLCDDisplayEnabled()) {
            this.timerMode = Math.max(CYCLES[2], this.timerMode - n);
            this.cyclesSinceLastFrame += n;
            return;
        }
        this.timerMode -= n;
        while (this.timerMode <= 0) {
            int n2 = this.regSTAT & 3;
            if (n2 <= 1) {
                if (this.lineLastCycle) {
                    this.lineLastCycle = false;
                    ++this.timerMode;
                    continue;
                }
                if (this.lineMainPart) {
                    if (this.timerMode == 0) {
                        this.clearCoincidenceFlagOnLineLastCycles();
                    }
                    if (this.regLY <= 143) {
                        this.fireOutputAvailable(65, (this.regLY == 143 || this.timerMode > -2 ? 512 : 0) | this.regSTAT | 2, n);
                    }
                    this.timerMode += 3;
                    this.lineMainPart = false;
                    this.hdmaReady = false;
                    this.lineLastCycle = true;
                    continue;
                }
                if (this.regLY == 153 && this.line153cycles <= 4) {
                    this.line153cycles += 4;
                    this.updateCoincidenceFlag();
                    this.timerMode += this.line153cycles == 8 ? CYCLES[n2] - this.line153cycles : 4;
                    continue;
                }
                this.regLY = (this.regLY + 1) % 154;
                if (this.regLY == 153) {
                    this.wySatisfied = false;
                    this.firstFrame = false;
                    this.windowLine = 0;
                    this.fireOutputAvailable(68, this.regLY, n);
                    this.line153cycles = 0;
                    this.updateCoincidenceFlag();
                    this.timerMode += 4;
                    continue;
                }
                if (this.regLY >= 144) {
                    this.setRegSTAT(this.regSTAT & 0xF8 | 1, false, n);
                    this.lineMainPart = true;
                    this.timerMode -= 4;
                } else {
                    this.setRegSTAT(this.regSTAT & 0xF8 | 2, false, n);
                }
                this.fireOutputAvailable(68, this.regLY, n);
            } else {
                if (n2 == 3) {
                    if (this.mode3lastCycles || (this.mode3additionalTime & 3) == 0) {
                        this.timerMode -= this.mode3additionalTime;
                        this.mode3lastCycles = false;
                    } else {
                        this.hdmaReady = (this.mode3additionalTime & 3) == 1;
                        this.timerMode += this.mode3additionalTime & 3;
                        this.mode3lastCycles = true;
                        if ((this.mode3additionalTime & 3) == 3) continue;
                        this.fireOutputAvailable(65, this.regSTAT & 0xFFFFFFFC, n);
                        continue;
                    }
                }
                this.setRegSTAT(this.regSTAT & 0xFC | n2 + 1 & 3, false, n);
                if ((this.regSTAT & 3) == 3) {
                    this.propagateState();
                    this.fillSpriteBuffer();
                    this.updateWySatisfied(this.regLY);
                    this.mode3additionalTime = this.calcAdditionalMode3time();
                    this.mode3cycles[this.regLY] = CYCLES[3] + this.mode3additionalTime;
                    this.timerMode += this.mode3additionalTime & 0xFFFFFFFC;
                } else if ((this.regSTAT & 3) == 0) {
                    this.firstDmaWriteDuringMode2 = Integer.MAX_VALUE;
                    this.firstDmaWriteDuringMode3 = Integer.MAX_VALUE;
                    this.hdmaReady = true;
                    this.lineMainPart = true;
                    this.timerMode -= 4;
                }
            }
            this.timerMode += CYCLES[this.regSTAT & 3];
        }
    }

    public int getCyclesSinceLastFrame() {
        return this.cyclesSinceLastFrame;
    }

    public void resetCyclesSinceLastFrame() {
        this.cyclesSinceLastFrame = 0;
    }

    private void fillSpriteBuffer() {
        this.fillSpriteBuffer(this.regLY);
    }

    public void fillSpriteBuffer(int n) {
        int n2 = 0;
        int[] nArray = this.oam;
        int n3 = (this.regLCDC & 4) != 0 ? 16 : 8;
        int n4 = 0;
        while (n4 < 40) {
            int n5 = n4 >= this.firstDmaWriteDuringMode2 && n4 <= this.lastDmaWriteDuringMode2 ? this.dmaWritesDuringMode2[n4] / 4 : n4;
            int n6 = nArray[n5 << 2];
            int n7 = nArray[(n4 == 0 ? n5 : n4) << 2 | 1];
            int n8 = n - (n6 - 16);
            if (n8 >= 0 && n8 < n3) {
                this.spriteBuffer[n2] = n6 << 16 | n7 << 8 | n5;
                if (++n2 == this.spriteBuffer.length) break;
            }
            ++n4;
        }
        this.spriteCount = n2;
    }

    private int calcAdditionalMode3time() {
        int n;
        this.currentCycleOffsets = this.cycleOffsets[this.regLY];
        Arrays.fill(this.currentCycleOffsets, 0);
        int n2 = this.scxLow;
        int[] nArray = this.mode3buckets;
        Arrays.fill(nArray, 0);
        int n3 = n2;
        this.currentCycleOffsets[0] = n2;
        if (this.wySatisfied && this.isWindowDisplayEnabled(0) && this.regWX <= 166) {
            if (this.regWX == 0 && this.currentCycleOffsets[0] > 0) {
                this.currentCycleOffsets[0] = this.currentCycleOffsets[0] + 1;
                ++n3;
            }
            int n4 = this.regWX + 1;
            this.currentCycleOffsets[n4] = this.currentCycleOffsets[n4] + 6;
            n = this.regWX - 7 & 7;
            n3 += 6;
        } else {
            n = 0;
        }
        if (!this.isFirstLine0() && (this instanceof GBCLCDController || this.isOBJDisplayEnabled(0))) {
            int n5;
            boolean bl = false;
            int n6 = 0;
            while (n6 < this.spriteCount) {
                n5 = this.getSpriteBufferIndex(n6);
                int n7 = this.oam[n5 << 2 | 1];
                if (n7 < 168) {
                    if (n7 == 0) {
                        bl = true;
                    }
                    int n8 = n7 > this.regWX ? -n : 0;
                    int n9 = n7 + n2 >> 3;
                    nArray[n9] = Math.max(nArray[n9], 5 - (n7 + n2 + n8 & 7));
                    int n10 = n7 + n2;
                    this.currentCycleOffsets[n10] = this.currentCycleOffsets[n10] + 6;
                    n3 += 6;
                }
                ++n6;
            }
            if (bl) {
                n6 = Math.min(5, n2);
                this.currentCycleOffsets[0] = this.currentCycleOffsets[0] + n6;
                n3 += n6;
            }
            n6 = 0;
            while (n6 < nArray.length) {
                if (nArray[n6] > 0) {
                    n3 += nArray[n6];
                    n5 = 0;
                    while (n5 < 8) {
                        if (this.currentCycleOffsets[n6 << 3 | n5] >= 6) {
                            int n11 = n6 << 3 | n5;
                            this.currentCycleOffsets[n11] = this.currentCycleOffsets[n11] + nArray[n6];
                            break;
                        }
                        ++n5;
                    }
                }
                ++n6;
            }
        }
        return n3;
    }

    private void setRegSTAT(int n, boolean bl, int n2) {
        int n3;
        int n4 = n3 = this.mode3lastCycles ? 0 : n & 3;
        if (bl) {
            if (!(this instanceof GBCLCDController)) {
                this.fireOutputAvailable(65, 0x300 | (0xF8 | (this.isCoincidenceFlag() ? 4 : 0) | n & 3) & 0xFFFFFFFC | n3, n2);
            }
            this.regSTAT = 0x80 | (this.isCoincidenceFlag() ? n | 4 : n & 0xFFFFFFFB);
            this.fireOutputAvailable(65, 0x100 | this.regSTAT & 0xFFFFFFFC | n3, n2);
        } else {
            this.regSTAT = 0x80 | (this.isCoincidenceFlag() ? n | 4 : n & 0xFFFFFFFB);
            this.fireOutputAvailable(65, this.regSTAT & 0xFFFFFFFC | n3, n2);
        }
    }

    protected void clearCoincidenceFlagOnLineLastCycles() {
        this.fireOutputAvailable(65, 0x400 | (this.regSTAT &= 0xFFFFFFFB));
    }

    protected boolean isCoincidenceFlag() {
        if (!this.isLCDDisplayEnabled()) {
            return (this.regSTAT & 4) != 0;
        }
        int n = this.regLY;
        if (n == 153 && this.line153cycles > 0) {
            int n2 = n = this.line153cycles >= 8 ? 0 : -1;
        }
        return n == this.regLYC;
    }

    private void updateCoincidenceFlag() {
        if (this.isLCDDisplayEnabled()) {
            int n = this.mode3lastCycles ? 0 : this.regSTAT & 3;
            this.regSTAT = this.isCoincidenceFlag() ? this.regSTAT | 4 : this.regSTAT & 0xFFFFFFFB;
            this.fireOutputAvailable(65, this.regSTAT & 0xFFFFFFFC | n);
        }
    }

    private void propagateState() {
        this.wxSatisfied = false;
        this.scxLow = this.regSCX & 7;
        this.windowEnabledWX = this.regWX;
        Arrays.fill(this.scx, this.regSCX);
        Arrays.fill(this.scy, this.regSCY);
        Arrays.fill(this.wx, this.regWX);
        Arrays.fill(this.bgp, this.regBGP);
        Arrays.fill(this.obp0, this.regOBP0);
        Arrays.fill(this.obp1, this.regOBP1);
        Arrays.fill(this.lcdc, this.regLCDC);
        Arrays.fill(this.bgDisplayEnabled, (this.regLCDC & 1) != 0);
        Arrays.fill(this.objDisplayEnabled, (this.regLCDC & 2) != 0);
    }

    public int getTimer() {
        return this.timerMode;
    }

    public int getMode3cycles(int n) {
        return this.mode3cycles[n];
    }

    public int toScreenDot(int n, int n2) {
        if (n2 < 12) {
            return -12;
        }
        n2 -= 4;
        int[] nArray = this.cycleOffsets[n];
        int n3 = 0;
        while (n3 <= n2 && n3 < nArray.length) {
            if (nArray[n3] > 0 && n3 > (n2 -= nArray[n3]) && n3 - n2 <= nArray[n3]) {
                return 0x100 | n3;
            }
            ++n3;
        }
        return n2 - 8;
    }

    public int calcCurrentDot() {
        int n = (this.timerMode <= 0 && !this.lineMainPart && !this.mode3lastCycles ? this.regSTAT - 1 : this.regSTAT) & 3;
        if (n == 1) {
            return this.timerMode <= 0 ? -this.timerMode : CYCLES[1] - this.timerMode;
        }
        if (n == 2) {
            return CYCLES[2] - this.calcDotsInModeLeft();
        }
        if (n == 3) {
            return 456 - (CYCLES[0] - this.mode3additionalTime) - this.calcDotsInModeLeft();
        }
        return 456 - this.calcDotsInModeLeft();
    }

    public int calcDotsInModeLeft() {
        if (this.regLY == 153 && this.line153cycles < 8) {
            return CYCLES[1] - this.line153cycles;
        }
        int n = (this.timerMode <= 0 && !this.lineMainPart ? this.regSTAT - 1 : this.regSTAT) & 3;
        if (n == 3) {
            return this.mode3lastCycles ? this.timerMode : this.timerMode + (this.mode3additionalTime & 3);
        }
        if (n == 1) {
            return (153 - this.regLY) * CYCLES[1] + this.timerMode;
        }
        if (n == 0) {
            return (this.regLCDC & 0x80) == 0 ? 456 : this.timerMode + (this.lineMainPart ? 4 : 1);
        }
        return this.timerMode;
    }

    public int calcDotsUntilVBlank() {
        int n = this.calcDotsInModeLeft();
        int n2 = (this.timerMode <= 0 && !this.lineMainPart ? this.regSTAT - 1 : this.regSTAT) & 3;
        int n3 = n;
        if (n2 == 2) {
            n3 += CYCLES[3] + CYCLES[0];
        } else if (n2 == 3) {
            n3 += CYCLES[0];
        }
        if (this.regLY >= 144) {
            return n3 + 144 * CYCLES[1];
        }
        return n3 + (144 - (this.regLY + 1)) * CYCLES[1];
    }

    public LR35902.OamBugHandler createOamBugHandler() {
        return new LR35902.OamBugHandler(){

            @Override
            public void handleOamBugIncRead(int n) {
                GBLCDController.this.update(n);
                int n2 = GBLCDController.this.getCurrentOamRow() + 8;
                GBLCDController.this.timerMode += n;
                GBLCDController.this.cyclesSinceLastFrame -= n;
                if (n2 >= 32 && n2 < 152) {
                    GBLCDController.this.oam[n2 - 8] = GBLCDController.getOamReadIncreasePattern(GBLCDController.this.oam[n2 - 16], GBLCDController.this.oam[n2 - 8], GBLCDController.this.oam[n2], GBLCDController.this.oam[n2 - 4]);
                    GBLCDController.this.oam[n2 - 7] = GBLCDController.getOamReadIncreasePattern(GBLCDController.this.oam[n2 - 15], GBLCDController.this.oam[n2 - 7], GBLCDController.this.oam[n2 + 1], GBLCDController.this.oam[n2 - 3]);
                    int n3 = 0;
                    while (n3 < 8) {
                        int n4 = GBLCDController.this.oam[n2 - 8 + n3];
                        GBLCDController.this.oam[n2 - 16 + n3] = n4;
                        GBLCDController.this.oam[n2 + n3] = n4;
                        ++n3;
                    }
                    GBLCDController.this.fireOamBugTriggered(n2);
                }
            }

            @Override
            public void handleOamBugInc(int n) {
                GBLCDController.this.update(n);
                int n2 = GBLCDController.this.getCurrentOamRow();
                GBLCDController.this.timerMode += n;
                GBLCDController.this.cyclesSinceLastFrame -= n;
                if (n2 >= 8) {
                    GBLCDController.this.oam[n2] = GBLCDController.getOamBugPattern(GBLCDController.this.oam[n2], GBLCDController.this.oam[n2 - 8], GBLCDController.this.oam[n2 - 4]);
                    GBLCDController.this.oam[n2 + 1] = GBLCDController.getOamBugPattern(GBLCDController.this.oam[n2 + 1], GBLCDController.this.oam[n2 - 7], GBLCDController.this.oam[n2 - 3]);
                    int n3 = 2;
                    while (n3 < 8) {
                        GBLCDController.this.oam[n2 + n3] = GBLCDController.this.oam[n2 - 8 + n3];
                        ++n3;
                    }
                    GBLCDController.this.fireOamBugTriggered(n2);
                }
            }
        };
    }

    protected void handleOamReadBug(int n) {
        int n2;
        this.handleOamBug();
        if (n < this.oam.length && (n2 = this.getCurrentOamRow() + 8) == 160) {
            this.oam[158] = GBLCDController.getOamBugPattern(this.oam[156], this.oam[158], this.oam[n & 0xF8 | 6]);
            this.oam[159] = GBLCDController.getOamBugPattern(this.oam[157], this.oam[159], this.oam[n & 0xF8 | 7]);
            int n3 = 0;
            while (n3 < 8) {
                this.oam[n & 0xF8 | n3] = this.oam[0x98 | n3];
                ++n3;
            }
            this.fireOamBugTriggered(152);
        }
    }

    protected void handleOamWriteBug(int n) {
        this.handleOamBug();
    }

    private void handleOamBug() {
        int n = this.getCurrentOamRow() + 8;
        if (n >= 8 && n < 160) {
            this.oam[n - 8] = this.oam[n] = GBLCDController.getOamReadPattern(this.oam[n], this.oam[n - 8], this.oam[n - 4]);
            int n2 = GBLCDController.getOamReadPattern(this.oam[n + 1], this.oam[n - 7], this.oam[n - 3]);
            this.oam[n + 1] = n2;
            this.oam[n - 7] = n2;
            int n3 = 2;
            while (n3 < 8) {
                this.oam[n + n3] = this.oam[n - 8 + n3];
                ++n3;
            }
            this.fireOamBugTriggered(n);
        }
    }

    static int getOamBugPattern(int n, int n2, int n3) {
        return (n ^ n3) & (n2 ^ n3) ^ n3;
    }

    static int getOamReadPattern(int n, int n2, int n3) {
        return n2 | n & n3;
    }

    static int getOamReadIncreasePattern(int n, int n2, int n3, int n4) {
        return n2 & (n | n3 | n4) | n & n3 & n4;
    }

    int getCurrentOamRow() {
        if ((this.regSTAT & 3) != 2 || this.timerMode < 4) {
            return -1;
        }
        return (CYCLES[2] - this.timerMode & 0xFFFFFFFC) * 2;
    }

    protected final void fireInaccessibleVram(int n) {
        this.fireOutputAvailable(0x110100, 0x8000 | n);
    }

    private final void fireInaccessibleOam(int n) {
        this.fireOutputAvailable(0x110102, 0xFE00 | n);
    }

    private final void fireTurnOffLcdOutsideVblank() {
        this.fireOutputAvailable(0x110103, 0);
    }

    private final void fireOamBugTriggered(int n) {
        this.fireOutputAvailable(0x110104, 0xFE00 | n);
    }

    protected final void fireOutputAvailable(int n, int n2) {
        this.fireOutputAvailable(n, n2, 0);
    }

    protected final void fireOutputAvailable(int n, int n2, int n3) {
        OutputListener[] outputListenerArray = this.listeners;
        int n4 = this.listeners.length;
        int n5 = 0;
        while (n5 < n4) {
            OutputListener outputListener = outputListenerArray[n5];
            outputListener.outputAvailable(n, n2, n3);
            ++n5;
        }
    }

    public final void addOutputListener(OutputListener outputListener) {
        if (!this.listenerList.contains(outputListener)) {
            this.listenerList.addFirst(outputListener);
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public final void removeOutputListener(OutputListener outputListener) {
        if (this.listenerList.remove(outputListener)) {
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getTimer() {
                return GBLCDController.this.timerMode;
            }

            @Override
            public int[] getVram() {
                return GBLCDController.this.vram;
            }

            @Override
            public int[] getOam() {
                return GBLCDController.this.oam;
            }

            @Override
            public int getRegLCDC() {
                return GBLCDController.this.regLCDC;
            }

            @Override
            public int getRegSTAT() {
                return GBLCDController.this.regSTAT;
            }

            @Override
            public int getRegSCY() {
                return GBLCDController.this.regSCY;
            }

            @Override
            public int getRegSCX() {
                return GBLCDController.this.regSCX;
            }

            @Override
            public int getRegLY() {
                return GBLCDController.this.regLY;
            }

            @Override
            public int getRegLYC() {
                return GBLCDController.this.regLYC;
            }

            @Override
            public int getRegWY() {
                return GBLCDController.this.regWY;
            }

            @Override
            public int getRegWX() {
                return GBLCDController.this.regWX;
            }

            @Override
            public int getRegBGP() {
                return GBLCDController.this.regBGP;
            }

            @Override
            public int getRegOBP0() {
                return GBLCDController.this.regOBP0;
            }

            @Override
            public int getRegOBP1() {
                return GBLCDController.this.regOBP1;
            }

            @Override
            public int getRegDMA() {
                return GBLCDController.this.regDMA;
            }

            @Override
            public int getMode3additionalTime() {
                return GBLCDController.this.mode3additionalTime;
            }

            @Override
            public int getLine153cycles() {
                return GBLCDController.this.line153cycles;
            }

            @Override
            public boolean isFirstFrame() {
                return GBLCDController.this.firstFrame;
            }

            @Override
            public boolean isLineMainPart() {
                return GBLCDController.this.lineMainPart;
            }

            @Override
            public boolean isLineLastCycle() {
                return GBLCDController.this.lineLastCycle;
            }

            @Override
            public boolean isMode3lastCycles() {
                return GBLCDController.this.mode3lastCycles;
            }

            @Override
            public boolean isHdmaReady() {
                return GBLCDController.this.hdmaReady;
            }

            @Override
            public boolean isWySatisfied() {
                return GBLCDController.this.wySatisfied;
            }

            @Override
            public int getWindowLine() {
                return GBLCDController.this.windowLine;
            }

            @Override
            public int getRegBGPI() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRegOBPI() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRegOPRI() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasCGBpalettes() {
                return false;
            }

            @Override
            public long getBGP(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getOBP(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRegVBK() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRegHDMA1() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRegHDMA2() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRegHDMA3() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRegHDMA4() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRegHDMA5() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getMode() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setState(State state, boolean bl) {
        this.timerMode = state.getTimer();
        Arrays.fill(this.vram, 0);
        System.arraycopy(state.getVram(), 0, this.vram, 0, Math.min(state.getVram().length, this.vram.length));
        if (state.getVram().length < this.vram.length) {
            Arrays.fill(this.vram, state.getVram().length, this.vram.length, 0);
        }
        System.arraycopy(state.getOam(), 0, this.oam, 0, this.oam.length);
        this.regLCDC = state.getRegLCDC();
        this.propagateState();
        this.regSTAT = state.getRegSTAT();
        this.regSCY = state.getRegSCY();
        Arrays.fill(this.scy, this.regSCY);
        this.regSCX = state.getRegSCX();
        this.regLY = state.getRegLY();
        this.regLYC = state.getRegLYC();
        this.regWY = state.getRegWY();
        this.regWX = state.getRegWX();
        this.regBGP = state.getRegBGP();
        this.regOBP0 = state.getRegOBP0();
        this.regOBP1 = state.getRegOBP1();
        this.regDMA = state.getRegDMA();
        this.mode3additionalTime = state.getMode3additionalTime();
        this.line153cycles = state.getLine153cycles();
        this.firstFrame = state.isFirstFrame();
        this.lineMainPart = state.isLineMainPart();
        this.lineLastCycle = state.isLineLastCycle();
        this.mode3lastCycles = state.isMode3lastCycles();
        this.hdmaReady = state.isHdmaReady();
        this.wySatisfied = state.isWySatisfied();
        this.windowLine = state.getWindowLine();
        if (!bl) {
            this.fireOutputAvailable(0x110010, 0);
        }
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getTimer();

        public int[] getVram();

        public int[] getOam();

        public int getRegLCDC();

        public int getRegSTAT();

        public int getRegSCY();

        public int getRegSCX();

        public int getRegLY();

        public int getRegLYC();

        public int getRegWY();

        public int getRegWX();

        public int getRegBGP();

        public int getRegOBP0();

        public int getRegOBP1();

        public int getRegDMA();

        public int getRegBGPI();

        public int getRegOBPI();

        public int getRegOPRI();

        public boolean hasCGBpalettes();

        public long getBGP(int var1);

        public long getOBP(int var1);

        public int getRegVBK();

        public int getRegHDMA1();

        public int getRegHDMA2();

        public int getRegHDMA3();

        public int getRegHDMA4();

        public int getRegHDMA5();

        public int getMode();

        public boolean isHdmaReady();

        public boolean isWySatisfied();

        public int getWindowLine();

        public int getMode3additionalTime();

        public int getLine153cycles();

        public boolean isFirstFrame();

        public boolean isLineMainPart();

        public boolean isLineLastCycle();

        public boolean isMode3lastCycles();
    }

    protected static class StateClone
    implements State {
        private int timerMode;
        private final int[] vram;
        private final int[] oam = new int[160];
        private int regLCDC;
        private int regSTAT;
        private int regSCY;
        private int regSCX;
        private int regLY;
        private int regLYC;
        private int regWY;
        private int regWX;
        private int regBGP;
        private int regOBP0;
        private int regOBP1;
        private int regDMA;
        private boolean hdmaReady;
        private boolean wySatisfied;
        private int windowLine;
        private int mode3additionalTime;
        private int line153cycles;
        private boolean firstFrame;
        private boolean lineMainPart;
        private boolean lineLastCycle;
        private boolean mode3lastCycles;

        public StateClone(State state) {
            this.vram = new int[state.getVram().length];
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            this.timerMode = state.getTimer();
            System.arraycopy(state.getVram(), 0, this.vram, 0, this.vram.length);
            System.arraycopy(state.getOam(), 0, this.oam, 0, this.oam.length);
            this.regLCDC = state.getRegLCDC();
            this.regSTAT = state.getRegSTAT();
            this.regSCY = state.getRegSCY();
            this.regSCX = state.getRegSCX();
            this.regLY = state.getRegLY();
            this.regLYC = state.getRegLYC();
            this.regWY = state.getRegWY();
            this.regWX = state.getRegWX();
            this.regBGP = state.getRegBGP();
            this.regOBP0 = state.getRegOBP0();
            this.regOBP1 = state.getRegOBP1();
            this.regDMA = state.getRegDMA();
            this.hdmaReady = state.isHdmaReady();
            this.wySatisfied = state.isWySatisfied();
            this.windowLine = state.getWindowLine();
            this.mode3additionalTime = state.getMode3additionalTime();
            this.line153cycles = state.getLine153cycles();
            this.firstFrame = state.isFirstFrame();
            this.lineMainPart = state.isLineMainPart();
            this.lineLastCycle = state.isLineLastCycle();
            this.mode3lastCycles = state.isMode3lastCycles();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getTimer() {
            return this.timerMode;
        }

        @Override
        public int[] getVram() {
            return this.vram;
        }

        @Override
        public int[] getOam() {
            return this.oam;
        }

        @Override
        public int getRegLCDC() {
            return this.regLCDC;
        }

        @Override
        public int getRegSTAT() {
            return this.regSTAT;
        }

        @Override
        public int getRegSCY() {
            return this.regSCY;
        }

        @Override
        public int getRegSCX() {
            return this.regSCX;
        }

        @Override
        public int getRegLY() {
            return this.regLY;
        }

        @Override
        public int getRegLYC() {
            return this.regLYC;
        }

        @Override
        public int getRegWY() {
            return this.regWY;
        }

        @Override
        public int getRegWX() {
            return this.regWX;
        }

        @Override
        public int getRegBGP() {
            return this.regBGP;
        }

        @Override
        public int getRegOBP0() {
            return this.regOBP0;
        }

        @Override
        public int getRegOBP1() {
            return this.regOBP1;
        }

        @Override
        public int getRegDMA() {
            return this.regDMA;
        }

        @Override
        public int getMode3additionalTime() {
            return this.mode3additionalTime;
        }

        @Override
        public int getLine153cycles() {
            return this.line153cycles;
        }

        @Override
        public boolean isFirstFrame() {
            return this.firstFrame;
        }

        @Override
        public boolean isLineMainPart() {
            return this.lineMainPart;
        }

        @Override
        public boolean isLineLastCycle() {
            return this.lineLastCycle;
        }

        @Override
        public boolean isMode3lastCycles() {
            return this.mode3lastCycles;
        }

        @Override
        public boolean isHdmaReady() {
            return this.hdmaReady;
        }

        @Override
        public boolean isWySatisfied() {
            return this.wySatisfied;
        }

        @Override
        public int getWindowLine() {
            return this.windowLine;
        }

        @Override
        public int getRegBGPI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegOBPI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegOPRI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasCGBpalettes() {
            return false;
        }

        @Override
        public long getBGP(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getOBP(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegVBK() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegHDMA1() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegHDMA2() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegHDMA3() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegHDMA4() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegHDMA5() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMode() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

