/*
 * Decompiled with CFR 0.152.
 */
package components.sound;

import components.OutputListener;
import components.sound.GBCSoundController;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.LinkedList;

public class GBSoundController {
    public static final int WAVE_RAM_CORRUPTION = 40;
    private static final int PHASE_CYCLES = 8192;
    private static final int[][] DUTY_PATTERN;
    private final LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    private VinProvider vinProvider;
    private int phase;
    private int noiseCounter;
    private int noiseCounterOffset;
    private boolean noiseCounterJustReloaded;
    private int regLinearFeedbackShift = 1;
    private int sweepFrequency;
    private int sweepAddend;
    private int sweepCounter;
    private int sweepRestartHold;
    private boolean sweepUnshifted;
    private int delaySweepCalc;
    private final int[] delayEnvelope = new int[4];
    private final int[] volume = new int[4];
    private final boolean[] envelopeCanClock = new boolean[4];
    private boolean waveChannelJustEnabled;
    private final int[] output = new int[4];
    private final int[] counter = new int[4];
    private final int[] generatorPhase = new int[4];
    private final int[] sample = new int[4];
    private final int[] samples = new int[4];
    private int cycleOffset;
    private int regNR10;
    private int regNR11;
    private int regNR12;
    private int regNR13;
    private int regNR14;
    private int regNR21;
    private int regNR22;
    private int regNR23;
    private int regNR24;
    private int regNR30;
    private int regNR31;
    private int regNR32;
    private int regNR33;
    private int regNR34;
    protected final int[] wavePatternRAM = new int[]{172, 221, 218, 72, 54, 2, 207, 22, 44, 4, 229, 44, 172, 221, 218, 72};
    private int regNR41;
    private int regNR42;
    private int regNR43;
    private int regNR44;
    private int regNR50;
    private int regNR51;
    private int regNR52;
    private EnableState enableState;
    private int prevCycles;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[8];
        nArray[7] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[7] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArrayArray[3] = nArray4;
        DUTY_PATTERN = nArrayArray;
    }

    private void clockSweep() {
        this.sweepCounter = this.sweepCounter + 1 & 7;
        this.calculateSweep(true);
    }

    private void calculateSweep(boolean bl) {
        if (!bl) {
            if (this.sweepRestartHold <= 0) {
                this.sweepFrequency = (this.regNR14 & 7) << 8 | this.regNR13;
            }
            if ((this.regNR10 & 8) != 0) {
                this.sweepAddend ^= 0x7FF;
            }
        }
        int n = this.sweepFrequency + this.sweepAddend + ((this.regNR10 & 8) >> 3);
        if (!bl && (this.regNR10 & 8) == 0 && n > 2047) {
            this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFFE);
        }
        if (bl && this.sweepCounter == 7 && (this.regNR10 & 0x70) != 0) {
            if ((this.regNR10 & 7) != 0) {
                this.regNR13 = n & 0xFF;
                this.regNR14 = this.regNR14 & 0xF8 | n >> 8 & 7;
            }
            if (this.sweepRestartHold <= 0) {
                this.sweepAddend = ((this.regNR14 & 7) << 8 | this.regNR13) >> (this.regNR10 & 7);
            }
            this.sweepUnshifted = (this.regNR10 & 7) == 0;
            this.delaySweepCalc = (this.regNR10 & 7) * 4 + 4;
            this.sweepCounter = this.regNR10 >> 4 & 7 ^ 7;
        }
    }

    private boolean isLengthCounterEnabled(int n) {
        switch (n) {
            case 0: {
                return (this.regNR14 & 0x40) != 0;
            }
            case 1: {
                return (this.regNR24 & 0x40) != 0;
            }
            case 2: {
                return (this.regNR34 & 0x40) != 0;
            }
            case 3: {
                return (this.regNR44 & 0x40) != 0;
            }
        }
        return false;
    }

    private void clockLengthCounter(int n) {
        switch (n) {
            case 0: {
                if ((this.regNR11 & 0x3F) < 63) {
                    ++this.regNR11;
                    break;
                }
                this.regNR11 &= 0xC0;
                this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFFE);
                break;
            }
            case 1: {
                if ((this.regNR21 & 0x3F) < 63) {
                    ++this.regNR21;
                    break;
                }
                this.regNR21 &= 0xC0;
                this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFFD);
                break;
            }
            case 2: {
                if (this.regNR31 < 255) {
                    ++this.regNR31;
                    break;
                }
                this.regNR31 = 0;
                this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFFB);
                break;
            }
            case 3: {
                if ((this.regNR41 & 0x3F) < 63) {
                    ++this.regNR41;
                    break;
                }
                this.regNR41 &= 0xC0;
                this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFF7);
            }
        }
    }

    private void clockLengthCounters() {
        if (this.isLengthCounterEnabled(0)) {
            this.clockLengthCounter(0);
        }
        if (this.isLengthCounterEnabled(1)) {
            this.clockLengthCounter(1);
        }
        if (this.isLengthCounterEnabled(2)) {
            this.clockLengthCounter(2);
        }
        if (this.isLengthCounterEnabled(3)) {
            this.clockLengthCounter(3);
        }
    }

    private void clockEnvelope(int n, boolean bl) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this.regNR12;
                break;
            }
            case 1: {
                n2 = this.regNR22;
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                n2 = this.regNR42;
            }
        }
        if ((n2 & 7) == 0 && this.delayEnvelope[n] == 0) {
            return;
        }
        if (bl && (!this.isChannelEnabled(n) || (n2 & 7) == 0 || this.delayEnvelope[n] != 0)) {
            return;
        }
        if (!this.envelopeCanClock[n]) {
            return;
        }
        this.envelopeCanClock[n] = false;
        this.delayEnvelope[n] = Math.max(0, this.delayEnvelope[n] - 1);
        if (this.delayEnvelope[n] == 0) {
            this.delayEnvelope[n] = n2 & 7;
            int n3 = this.volume[n];
            if ((n2 & 8) != 0) {
                if (this.volume[n] < 15) {
                    int n4 = n;
                    this.volume[n4] = this.volume[n4] + 1;
                }
            } else if (this.volume[n] > 0) {
                int n5 = n;
                this.volume[n5] = this.volume[n5] - 1;
            }
            if (this.isChannelEnabled(n) && n3 != 0) {
                this.sample[n] = this.sample[n] / n3 * this.volume[n];
            }
        }
    }

    private void clockEnvelope(boolean bl) {
        this.clockEnvelope(0, bl);
        this.clockEnvelope(1, bl);
        this.clockEnvelope(3, bl);
    }

    private void applyZombieVolume(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 = this.regNR12;
                break;
            }
            case 1: {
                n3 = this.regNR22;
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                n3 = this.regNR42;
            }
        }
        if ((n2 & 8) != 0) {
            int n4 = n;
            this.volume[n4] = this.volume[n4] + 1;
        }
        if (((n3 ^ n2) & 8) != 0) {
            this.volume[n] = 16 - this.volume[n];
        }
        if ((n2 & 7) != 0 && (n3 & 7) == 0 && this.volume[n] > 0 && (n2 & 8) == 0) {
            int n5 = n;
            this.volume[n5] = this.volume[n5] - 1;
        }
        if ((n3 & 7) != 0 && (n2 & 8) != 0) {
            int n6 = n;
            this.volume[n6] = this.volume[n6] - 1;
        }
        int n7 = n;
        this.volume[n7] = this.volume[n7] & 0xF;
    }

    private int calcNextLFSRNumber() {
        boolean bl = ((this.regLinearFeedbackShift ^ this.regLinearFeedbackShift >> 1 ^ 1) & 1) != 0;
        this.regLinearFeedbackShift >>= 1;
        this.regLinearFeedbackShift = bl ? (this.regLinearFeedbackShift |= (this.regNR43 & 8) != 0 ? 16448 : 16384) : (this.regLinearFeedbackShift &= ~((this.regNR43 & 8) != 0 ? 16448 : 16384));
        return this.regLinearFeedbackShift & 1;
    }

    public boolean isDACEnabled(int n) {
        switch (n) {
            case 0: {
                return (this.regNR12 & 0xF8) != 0;
            }
            case 1: {
                return (this.regNR22 & 0xF8) != 0;
            }
            case 2: {
                return (this.regNR30 & 0x80) != 0;
            }
            case 3: {
                return (this.regNR42 & 0xF8) != 0;
            }
        }
        return false;
    }

    private void initChannel(int n, int n2) {
        boolean bl = this.isChannelEnabled(n);
        if (this.isDACEnabled(n)) {
            this.fireOutputAvailable(38, this.regNR52 |= 1 << n);
        } else {
            this.fireOutputAvailable(38, this.regNR52 &= ~(1 << n));
        }
        int n3 = this.counter[n];
        this.counter[n] = this.getCyclesPerUpdate(n);
        if (!bl) {
            this.output[n] = 0;
            this.sample[n] = 0;
        }
        this.envelopeCanClock[n] = false;
        switch (n) {
            case 0: {
                this.sweepCounter = this.regNR10 >> 4 & 7 ^ 7;
                this.sweepFrequency = 0;
                this.sweepAddend = (this.regNR10 & 7) != 0 ? ((this.regNR14 & 7) << 8 | this.regNR13) >> (this.regNR10 & 7) : 0;
                this.sweepRestartHold = 8;
                if ((this.regNR10 & 7) != 0) {
                    this.sweepUnshifted = false;
                }
                if ((this.regNR10 & 7) != 0) {
                    this.delaySweepCalc = (this.regNR10 & 7) * 4 + 4;
                    if (bl) {
                        ++this.delaySweepCalc;
                    }
                }
            }
            case 1: {
                this.volume[n] = (n == 0 ? this.regNR12 : this.regNR22) >> 4;
                this.delayEnvelope[n] = (n == 0 ? this.regNR12 : this.regNR22) & 7;
                int n4 = n;
                this.counter[n4] = this.counter[n4] + (8 + (8192 - n2 & 3));
                if (!bl) break;
                int n5 = n;
                this.counter[n5] = this.counter[n5] - 4;
                break;
            }
            case 2: {
                if (bl && !(this instanceof GBCSoundController) && this.isDACEnabled(n) && n3 == 1) {
                    int n6 = this.generatorPhase[n] + 1 >> 1 & 0xF;
                    if (n6 < 4) {
                        this.wavePatternRAM[0] = this.wavePatternRAM[n6];
                    } else {
                        System.arraycopy(this.wavePatternRAM, n6 & 0xFFFFFFFC, this.wavePatternRAM, 0, 4);
                    }
                }
                this.waveChannelJustEnabled = true;
                this.generatorPhase[n] = 0;
                int n7 = n;
                this.counter[n7] = this.counter[n7] + 5;
                break;
            }
            case 3: {
                this.volume[n] = this.regNR42 >> 4;
                this.delayEnvelope[n] = this.regNR42 & 7;
                this.regLinearFeedbackShift = 0;
                if ((this.regNR43 & 7) == 0) {
                    int n8 = n;
                    this.counter[n8] = this.counter[n8] + ((8192 - n2 & 3) - 2);
                } else {
                    int n9 = n;
                    this.counter[n9] = this.counter[n9] - (8192 - n2 >> 1 & 3 ^ 3) * 2;
                    if ((this.regNR43 & 7) == 1 && (8192 - n2 >> 1 & 3) < 2) {
                        this.noiseCounterOffset = 4;
                        int n10 = n;
                        this.counter[n10] = this.counter[n10] + 4;
                    }
                }
                int n11 = n;
                this.counter[n11] = this.counter[n11] + 10;
            }
        }
    }

    private int[] getDutyPattern(int n) {
        switch (n) {
            case 0: {
                return DUTY_PATTERN[this.regNR11 >> 6];
            }
            case 1: {
                return DUTY_PATTERN[this.regNR21 >> 6];
            }
        }
        return null;
    }

    private int getWavePatternSample(int n) {
        return this.wavePatternRAM[n >> 1] >> (((n ^ 1) & 1) << 2) & 0xF;
    }

    public int getTerminalVolume(boolean bl) {
        return (this.regNR50 >> (bl ? 0 : 4) & 7) + 1;
    }

    public boolean isVinEnabled(boolean bl) {
        return (this.regNR50 & 1 << (bl ? 3 : 7)) != 0;
    }

    public boolean isTerminalEnabled(boolean bl, int n) {
        return (this.regNR51 & 1 << (bl ? n : 4 + n)) != 0;
    }

    public boolean isChannelEnabled(int n) {
        return (this.regNR52 & 1 << n) != 0;
    }

    private int getCyclesPerUpdate(int n) {
        switch (n) {
            case 0: {
                return 2048 - ((this.regNR14 & 7) << 8 | this.regNR13) << 2;
            }
            case 1: {
                return 2048 - ((this.regNR24 & 7) << 8 | this.regNR23) << 2;
            }
            case 2: {
                return 2048 - ((this.regNR34 & 7) << 8 | this.regNR33) << 1;
            }
            case 3: {
                int n2 = (this.regNR43 & 7) * 8;
                return n2 != 0 ? n2 : 4;
            }
        }
        return 0;
    }

    protected int getWaveChannelIndex(int n) {
        if (this.isChannelEnabled(2)) {
            if (!(this instanceof GBCSoundController) && (this.waveChannelJustEnabled || this.counter[2] == 1 || this.counter[2] == this.getCyclesPerUpdate(2))) {
                return -1;
            }
            n = this.generatorPhase[2] >> 1;
        }
        return n & 0xF;
    }

    protected boolean isSoundEnabled() {
        return (this.regNR52 & 0x80) != 0;
    }

    public int readPort(int n, int n2) {
        this.fireOutputAvailable(39, 8192 - n2);
        if (n == 38) {
            return this.regNR52;
        }
        if (n == 118) {
            return this.sample[1] << 4 | this.sample[0];
        }
        if (n == 119) {
            return this.sample[3] << 4 | this.sample[2];
        }
        return this.readWavePattern(n);
    }

    public int readWavePattern(int n) {
        int n2 = this.getWaveChannelIndex(n & 0xF);
        if (n2 >= 0) {
            return this.wavePatternRAM[n2];
        }
        return 255;
    }

    public void processInput(int n, int n2, int n3) {
        if (!this.isSoundEnabled() && n < 38) {
            if ((n - 16) % 5 != 1 || n == 37) {
                return;
            }
            if (n <= 22) {
                n2 &= 0x3F;
            }
        }
        if (n3 >= 0) {
            this.fireOutputAvailable(39, 8192 - n3);
            this.prevCycles = n3;
        } else {
            n3 = this.prevCycles;
        }
        if (n != 38) {
            n3 += this.cycleOffset;
        }
        switch (n) {
            case 16: {
                if ((n2 & 8) == 0 && this.sweepFrequency + this.sweepAddend + ((this.regNR10 & 8) >> 3) > 2047) {
                    this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFFE);
                }
                this.regNR10 = n2;
                this.fireOutputAvailable(n, 0x80 | this.regNR10);
                this.calculateSweep(true);
                break;
            }
            case 17: {
                this.regNR11 = n2;
                this.fireOutputAvailable(n, this.regNR11 | 0x3F);
                break;
            }
            case 18: {
                if ((n2 & 7) == 0 && (this.regNR12 & 7) != 0) {
                    this.delayEnvelope[0] = 0;
                }
                if ((n2 & 0xF8) == 0) {
                    this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFFE);
                } else if ((this.regNR52 & 1) != 0) {
                    this.applyZombieVolume(0, n2);
                }
                this.regNR12 = n2;
                this.fireOutputAvailable(n, n2);
                break;
            }
            case 19: {
                this.regNR13 = n2;
                this.fireOutputAvailable(n, 255);
                break;
            }
            case 20: {
                if ((n2 & 0x40) != 0 && (this.phase & 1) != 0) {
                    if ((this.regNR14 & 0x40) == 0 && ((this.regNR11 & 0x3F) > 0 || (this.regNR14 & 0x80) != 0)) {
                        this.clockLengthCounter(0);
                    }
                    if ((n2 & 0x80) != 0 && (this.regNR11 & 0x3F) == 0) {
                        this.clockLengthCounter(0);
                    }
                }
                this.regNR14 = n2;
                if ((this.regNR14 & 0x80) != 0) {
                    this.initChannel(0, n3);
                }
                this.fireOutputAvailable(n, this.regNR14 | 0xBF);
                break;
            }
            case 22: {
                this.regNR21 = n2;
                this.fireOutputAvailable(n, this.regNR21 | 0x3F);
                break;
            }
            case 23: {
                if ((n2 & 7) == 0 && (this.regNR22 & 7) != 0) {
                    this.delayEnvelope[1] = 0;
                }
                if ((n2 & 0xF8) == 0) {
                    this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFFD);
                } else if ((this.regNR52 & 2) != 0) {
                    this.applyZombieVolume(1, n2);
                }
                this.regNR22 = n2;
                this.fireOutputAvailable(n, n2);
                break;
            }
            case 24: {
                this.regNR23 = n2;
                this.fireOutputAvailable(n, 255);
                break;
            }
            case 25: {
                if ((n2 & 0x40) != 0 && (this.phase & 1) != 0) {
                    if ((this.regNR24 & 0x40) == 0 && ((this.regNR21 & 0x3F) > 0 || (this.regNR24 & 0x80) != 0)) {
                        this.clockLengthCounter(1);
                    }
                    if ((n2 & 0x80) != 0 && (this.regNR21 & 0x3F) == 0) {
                        this.clockLengthCounter(1);
                    }
                }
                this.regNR24 = n2;
                if ((this.regNR24 & 0x80) != 0) {
                    this.initChannel(1, n3);
                }
                this.fireOutputAvailable(n, this.regNR24 | 0xBF);
                break;
            }
            case 26: {
                this.regNR30 = n2;
                if (!this.isDACEnabled(2)) {
                    this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFFB);
                }
                this.fireOutputAvailable(n, this.regNR30 | 0x7F);
                break;
            }
            case 27: {
                this.regNR31 = n2;
                this.fireOutputAvailable(n, 255);
                break;
            }
            case 28: {
                this.regNR32 = n2;
                this.fireOutputAvailable(n, this.regNR32 | 0x9F);
                break;
            }
            case 29: {
                this.regNR33 = n2;
                this.fireOutputAvailable(n, 255);
                break;
            }
            case 30: {
                if ((n2 & 0x40) != 0 && (this.phase & 1) != 0) {
                    if ((this.regNR34 & 0x40) == 0 && (this.regNR31 > 0 || (this.regNR34 & 0x80) != 0)) {
                        this.clockLengthCounter(2);
                    }
                    if ((n2 & 0x80) != 0 && this.regNR31 == 0) {
                        this.clockLengthCounter(2);
                    }
                }
                this.regNR34 = n2;
                if ((this.regNR34 & 0x80) != 0) {
                    this.initChannel(2, n3);
                }
                this.fireOutputAvailable(n, this.regNR34 | 0xBF);
                break;
            }
            case 32: {
                this.regNR41 = n2;
                this.fireOutputAvailable(n, 255);
                break;
            }
            case 33: {
                if ((n2 & 7) == 0 && (this.regNR42 & 7) != 0) {
                    this.delayEnvelope[3] = 0;
                }
                if ((n2 & 0xF8) == 0) {
                    this.fireOutputAvailable(38, this.regNR52 &= 0xFFFFFFF7);
                } else if ((this.regNR52 & 8) != 0) {
                    this.applyZombieVolume(3, n2);
                }
                this.regNR42 = n2;
                this.fireOutputAvailable(n, n2);
                break;
            }
            case 34: {
                if ((this.noiseCounter >> (this.regNR43 >> 4) & 1) < (this.noiseCounter >> (n2 >> 4) & 1)) {
                    this.output[3] = this.calcNextLFSRNumber();
                    this.sample[3] = this.output[3] * this.volume[3];
                }
                this.regNR43 = n2;
                if (this.noiseCounterJustReloaded) {
                    this.counter[3] = this.getCyclesPerUpdate(3);
                    if ((this.regNR43 & 7) > 0) {
                        switch (8192 - n3 >> 1 & 3) {
                            case 0: {
                                this.counter[3] = this.counter[3] + 2;
                                break;
                            }
                            case 2: {
                                this.counter[3] = this.counter[3] - 2;
                                break;
                            }
                            case 3: {
                                this.counter[3] = this.counter[3] - 4;
                            }
                        }
                    }
                    this.noiseCounterOffset = 0;
                }
                this.fireOutputAvailable(n, n2);
                break;
            }
            case 35: {
                if ((n2 & 0x40) != 0 && (this.phase & 1) != 0) {
                    if ((this.regNR44 & 0x40) == 0 && ((this.regNR41 & 0x3F) > 0 || (this.regNR44 & 0x80) != 0)) {
                        this.clockLengthCounter(3);
                    }
                    if ((n2 & 0x80) != 0 && (this.regNR41 & 0x3F) == 0) {
                        this.clockLengthCounter(3);
                    }
                }
                this.regNR44 = n2;
                if ((this.regNR44 & 0x80) != 0) {
                    this.initChannel(3, n3);
                }
                this.fireOutputAvailable(n, this.regNR44 | 0xBF);
                break;
            }
            case 36: {
                this.regNR50 = n2;
                this.fireOutputAvailable(n, n2);
                break;
            }
            case 37: {
                this.regNR51 = n2;
                this.fireOutputAvailable(n, n2);
                break;
            }
            case 38: {
                if (((this.regNR52 ^ n2) & 0x80) != 0) {
                    this.reset();
                    this.cycleOffset = n3 & 7;
                }
                this.regNR52 = n2 & 0x80 | 0x70 | this.regNR52 & 0xF;
                this.fireOutputAvailable(n, this.regNR52);
                break;
            }
            default: {
                int n4 = this.getWaveChannelIndex(n & 0xF);
                if (n >= 48 && n < 64 && n4 >= 0) {
                    this.wavePatternRAM[n4] = n2;
                    if ((n4 & 0xF) != (n & 0xF)) {
                        this.fireOutputAvailable(40, n4);
                    }
                }
                this.fireOutputAvailable(n, n2);
            }
        }
    }

    public void update(int n) {
        this.fireOutputAvailable(39, 8192 - n);
    }

    public int getSamples(int n) {
        return this.samples[n];
    }

    public void channelDisabled(int n) {
        this.sample[n] = 0;
        this.samples[n] = 0;
    }

    public void advanceChannels(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < this.counter.length) {
            this.advanceChannel(n2, n);
            ++n2;
        }
    }

    private void advanceChannel(int n, int n2) {
        if (n == 0) {
            if (this.sweepRestartHold > 0) {
                this.sweepRestartHold -= n2;
            }
            if (this.delaySweepCalc > 0 && ((this.regNR10 & 7) != 0 || this.sweepUnshifted || this.delaySweepCalc <= 4)) {
                this.delaySweepCalc -= n2;
                if (this.delaySweepCalc <= 0) {
                    this.calculateSweep(false);
                }
            }
        }
        if (!this.isChannelEnabled(n)) {
            return;
        }
        int n3 = this.counter[n];
        int n4 = n;
        this.counter[n4] = this.counter[n4] - n2;
        int n5 = this.getCyclesPerUpdate(n);
        switch (n) {
            case 0: 
            case 1: {
                int n6 = this.getDutyPattern(n)[this.generatorPhase[n]] * n3;
                while (this.counter[n] <= 0) {
                    int n7 = n;
                    this.counter[n7] = this.counter[n7] + n5;
                    this.generatorPhase[n] = this.generatorPhase[n] + 1 & 7;
                    this.output[n] = this.getDutyPattern(n)[this.generatorPhase[n]];
                    n6 += this.output[n] * n5;
                }
                this.samples[n] = (n6 -= this.getDutyPattern(n)[this.generatorPhase[n]] * this.counter[n]) * this.volume[n];
                this.sample[n] = this.output[n] * this.volume[n];
                break;
            }
            case 2: {
                int n8 = this.getWavePatternSample(this.generatorPhase[n]) * n3;
                while (this.counter[n] <= 0) {
                    this.waveChannelJustEnabled = false;
                    int n9 = n;
                    this.counter[n9] = this.counter[n9] + n5;
                    this.generatorPhase[n] = this.generatorPhase[n] + 1 & 0x1F;
                    this.output[n] = this.getWavePatternSample(this.generatorPhase[n]);
                    n8 += this.output[n] * n5;
                }
                int n10 = (this.regNR32 >> 5 & 3) - 1;
                this.samples[n] = (n8 -= this.getWavePatternSample(this.generatorPhase[n]) * this.counter[n]) >> n10;
                this.sample[n] = this.output[n] >> n10;
                break;
            }
            case 3: {
                int n11 = this.output[n] * n3;
                this.noiseCounterJustReloaded = false;
                while (this.counter[n] <= 0) {
                    int n12 = this.noiseCounter >> (this.regNR43 >> 4) & 1;
                    this.noiseCounter = this.noiseCounter + 1 & 0x3FFF;
                    if (this.regNR43 >> 4 < 14 && n12 < (this.noiseCounter >> (this.regNR43 >> 4) & 1)) {
                        this.output[n] = this.calcNextLFSRNumber();
                    }
                    n11 += this.output[n] * n5;
                    this.noiseCounterJustReloaded = this.counter[n] == 0;
                    int n13 = n;
                    this.counter[n13] = this.counter[n13] + (n5 + this.noiseCounterOffset);
                    this.noiseCounterOffset = 0;
                }
                this.samples[n] = (n11 -= this.output[n] * this.counter[n]) * this.volume[n];
                this.sample[n] = this.output[n] * this.volume[n];
            }
        }
    }

    public void reset() {
        this.phase = 0;
        this.regNR10 = 128;
        this.fireOutputAvailable(16, 128);
        this.fireOutputAvailable(17, 63);
        this.regNR12 = 0;
        this.fireOutputAvailable(18, 0);
        this.regNR13 = 0;
        this.fireOutputAvailable(19, 255);
        this.regNR14 = 191;
        this.fireOutputAvailable(20, 191);
        this.fireOutputAvailable(22, 63);
        this.regNR22 = 0;
        this.fireOutputAvailable(23, 0);
        this.regNR23 = 0;
        this.fireOutputAvailable(24, 255);
        this.regNR24 = 191;
        this.fireOutputAvailable(25, 191);
        this.regNR30 = 127;
        this.fireOutputAvailable(26, 127);
        this.fireOutputAvailable(27, 255);
        this.regNR32 = 159;
        this.fireOutputAvailable(28, 159);
        this.regNR33 = 0;
        this.fireOutputAvailable(29, 255);
        this.regNR34 = 191;
        this.fireOutputAvailable(30, 191);
        this.fireOutputAvailable(32, 255);
        this.regNR42 = 0;
        this.fireOutputAvailable(33, 0);
        this.regNR43 = 0;
        this.fireOutputAvailable(34, 0);
        this.regNR44 = 191;
        this.fireOutputAvailable(35, 191);
        this.regNR50 = 0;
        this.fireOutputAvailable(36, 0);
        this.regNR51 = 0;
        this.fireOutputAvailable(37, 0);
        this.regNR52 = 0;
        this.fireOutputAvailable(38, 0);
        Arrays.fill(this.volume, 0);
        Arrays.fill(this.generatorPhase, 0);
        this.noiseCounter = 0;
    }

    protected void resetLengths() {
        this.regNR11 = 0;
        this.regNR21 = 0;
        this.regNR31 = 0;
        this.regNR41 = 0;
    }

    public void delayEnable() {
        this.enableState = EnableState.DELAYED;
        this.phase = 1;
    }

    public void resync(int n) {
        if (this.isSoundEnabled()) {
            this.fireOutputAvailable(39, 8192 - n);
            this.fireOutputAvailable(39, -1);
        }
    }

    public void clock(boolean bl) {
        if (this.isSoundEnabled()) {
            if (!bl) {
                this.fireOutputAvailable(39, 8190);
            }
            if (this.enableState == EnableState.DELAYED) {
                this.enableState = EnableState.ENABLING;
            } else {
                if (this.enableState == EnableState.ENABLING) {
                    this.enableState = EnableState.ENABLED;
                } else {
                    this.phase = this.phase + 1 & 7;
                }
                switch (this.phase) {
                    case 3: 
                    case 7: {
                        this.clockSweep();
                    }
                    case 1: 
                    case 5: {
                        this.clockLengthCounters();
                        break;
                    }
                    case 0: {
                        this.clockEnvelope(false);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        this.clockEnvelope(true);
                    }
                }
            }
            if (!bl) {
                this.fireOutputAvailable(39, 8192);
                this.fireOutputAvailable(39, -1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void risingClock() {
        block8: {
            if (!this.isSoundEnabled()) break block8;
            int n = 0;
            while (n < this.delayEnvelope.length) {
                block9: {
                    int n2 = 0;
                    switch (n) {
                        case 0: {
                            n2 = this.regNR12;
                            break;
                        }
                        case 1: {
                            n2 = this.regNR22;
                            break;
                        }
                        case 2: {
                            break block9;
                        }
                        case 3: {
                            n2 = this.regNR42;
                        }
                    }
                    if (this.isChannelEnabled(n)) {
                        this.envelopeCanClock[n] = (n2 & 7) != 0;
                    }
                }
                ++n;
            }
        }
    }

    public void setVinProvider(VinProvider vinProvider) {
        this.vinProvider = vinProvider;
    }

    public VinProvider getVinProvider() {
        return this.vinProvider;
    }

    protected void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = this.listeners;
        int n3 = this.listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        if (!this.listenerList.contains(outputListener)) {
            this.listenerList.addFirst(outputListener);
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public void removeOutputListener(OutputListener outputListener) {
        if (this.listenerList.remove(outputListener)) {
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new CloneState(this);
            }

            @Override
            public int getPhase() {
                return GBSoundController.this.phase;
            }

            @Override
            public int getSweepCounter() {
                return GBSoundController.this.sweepCounter;
            }

            @Override
            public int getSweepFrequency() {
                return GBSoundController.this.sweepFrequency;
            }

            @Override
            public int getSweepAddend() {
                return GBSoundController.this.sweepAddend;
            }

            @Override
            public int getSweepRestartHold() {
                return GBSoundController.this.sweepRestartHold;
            }

            @Override
            public boolean isSweepUnshifted() {
                return GBSoundController.this.sweepUnshifted;
            }

            @Override
            public int getDelayEnvelope(int n) {
                return GBSoundController.this.delayEnvelope[n];
            }

            @Override
            public boolean isEnvelopeCanClock(int n) {
                return GBSoundController.this.envelopeCanClock[n];
            }

            @Override
            public int getVolume(int n) {
                return GBSoundController.this.volume[n];
            }

            @Override
            public int getLength(int n) {
                switch (n) {
                    case 0: {
                        return 64 - (this.getRegNR11() & 0x3F);
                    }
                    case 1: {
                        return 64 - (this.getRegNR21() & 0x3F);
                    }
                    case 2: {
                        return 256 - this.getRegNR31();
                    }
                    case 3: {
                        return 64 - (this.getRegNR41() & 0x3F);
                    }
                }
                return 0;
            }

            @Override
            public int getRegNR10() {
                return GBSoundController.this.regNR10;
            }

            @Override
            public int getRegNR11() {
                return GBSoundController.this.regNR11;
            }

            @Override
            public int getRegNR12() {
                return GBSoundController.this.regNR12;
            }

            @Override
            public int getRegNR13() {
                return GBSoundController.this.regNR13;
            }

            @Override
            public int getRegNR14() {
                return GBSoundController.this.regNR14;
            }

            @Override
            public int getRegNR21() {
                return GBSoundController.this.regNR21;
            }

            @Override
            public int getRegNR22() {
                return GBSoundController.this.regNR22;
            }

            @Override
            public int getRegNR23() {
                return GBSoundController.this.regNR23;
            }

            @Override
            public int getRegNR24() {
                return GBSoundController.this.regNR24;
            }

            @Override
            public int getRegNR30() {
                return GBSoundController.this.regNR30;
            }

            @Override
            public int getRegNR31() {
                return GBSoundController.this.regNR31;
            }

            @Override
            public int getRegNR32() {
                return GBSoundController.this.regNR32;
            }

            @Override
            public int getRegNR33() {
                return GBSoundController.this.regNR33;
            }

            @Override
            public int getRegNR34() {
                return GBSoundController.this.regNR34;
            }

            @Override
            public int getRegNR41() {
                return GBSoundController.this.regNR41;
            }

            @Override
            public int getRegNR42() {
                return GBSoundController.this.regNR42;
            }

            @Override
            public int getRegNR43() {
                return GBSoundController.this.regNR43;
            }

            @Override
            public int getRegNR44() {
                return GBSoundController.this.regNR44;
            }

            @Override
            public int getRegNR50() {
                return GBSoundController.this.regNR50;
            }

            @Override
            public int getRegNR51() {
                return GBSoundController.this.regNR51;
            }

            @Override
            public int getRegNR52() {
                return GBSoundController.this.regNR52;
            }

            @Override
            public int[] getWavePatternRAM() {
                return GBSoundController.this.wavePatternRAM;
            }

            @Override
            public int getNoiseCounter() {
                return GBSoundController.this.noiseCounter;
            }

            @Override
            public int getNoiseCounterOffset() {
                return GBSoundController.this.noiseCounterOffset;
            }

            @Override
            public boolean isNoiseCounterJustReloaded() {
                return GBSoundController.this.noiseCounterJustReloaded;
            }

            @Override
            public int getRegLinearFeedbackShift() {
                return GBSoundController.this.regLinearFeedbackShift;
            }

            @Override
            public EnableState getEnableState() {
                return GBSoundController.this.enableState;
            }

            @Override
            public boolean isWaveChannelJustEnabled() {
                return GBSoundController.this.waveChannelJustEnabled;
            }

            @Override
            public int getOutput(int n) {
                return GBSoundController.this.output[n];
            }

            @Override
            public int getCounter(int n) {
                return GBSoundController.this.counter[n];
            }

            @Override
            public int getGeneratorPhase(int n) {
                return GBSoundController.this.generatorPhase[n];
            }

            @Override
            public int getSample(int n) {
                return GBSoundController.this.sample[n];
            }

            @Override
            public int getSamples(int n) {
                return GBSoundController.this.samples[n];
            }
        };
    }

    public void setState(State state) {
        this.phase = state.getPhase();
        this.sweepCounter = state.getSweepCounter();
        this.sweepFrequency = state.getSweepFrequency();
        this.sweepAddend = state.getSweepAddend();
        this.sweepRestartHold = state.getSweepRestartHold();
        int n = 0;
        while (n < this.delayEnvelope.length) {
            this.delayEnvelope[n] = state.getDelayEnvelope(n);
            ++n;
        }
        n = 0;
        while (n < this.envelopeCanClock.length) {
            this.envelopeCanClock[n] = state.isEnvelopeCanClock(n);
            ++n;
        }
        n = 0;
        while (n < this.volume.length) {
            this.volume[n] = state.getVolume(n);
            ++n;
        }
        this.regNR10 = state.getRegNR10();
        this.regNR11 = state.getRegNR11();
        this.regNR12 = state.getRegNR12();
        this.regNR13 = state.getRegNR13();
        this.regNR14 = state.getRegNR14();
        this.regNR21 = state.getRegNR21();
        this.regNR22 = state.getRegNR22();
        this.regNR23 = state.getRegNR23();
        this.regNR24 = state.getRegNR24();
        this.regNR30 = state.getRegNR30();
        this.regNR31 = state.getRegNR31();
        this.regNR32 = state.getRegNR32();
        this.regNR33 = state.getRegNR33();
        this.regNR34 = state.getRegNR34();
        this.regNR41 = state.getRegNR41();
        this.regNR42 = state.getRegNR42();
        this.regNR43 = state.getRegNR43();
        this.regNR44 = state.getRegNR44();
        this.regNR50 = state.getRegNR50();
        this.regNR51 = state.getRegNR51();
        this.regNR52 = state.getRegNR52();
        System.arraycopy(state.getWavePatternRAM(), 0, this.wavePatternRAM, 0, this.wavePatternRAM.length);
        this.regLinearFeedbackShift = state.getRegLinearFeedbackShift();
        this.enableState = state.getEnableState();
    }

    private static class CloneState
    implements State {
        private int phase;
        private int sweepCounter;
        private int sweepFrequency;
        private int sweepAddend;
        private int sweepRestartHold;
        private boolean sweepUnshifted;
        private final int[] delayEnvelope = new int[4];
        private final boolean[] envelopeCanClock = new boolean[4];
        private final int[] volume = new int[4];
        private int regNR10;
        private int regNR11;
        private int regNR12;
        private int regNR13;
        private int regNR14;
        private int regNR21;
        private int regNR22;
        private int regNR23;
        private int regNR24;
        private int regNR30;
        private int regNR31;
        private int regNR32;
        private int regNR33;
        private int regNR34;
        private int regNR41;
        private int regNR42;
        private int regNR43;
        private int regNR44;
        private int regNR50;
        private int regNR51;
        private int regNR52;
        private int[] wavePatternRAM;
        private int regLinearFeedbackShift;
        private int noiseCounter;
        private int noiseCounterOffset;
        private boolean noiseCounterJustReloaded;
        private EnableState enableState;
        private boolean waveChannelJustEnabled;
        private final int[] output = new int[4];
        private final int[] counter = new int[4];
        private final int[] generatorPhase = new int[4];
        private final int[] sample = new int[4];
        private final int[] samples = new int[4];

        public CloneState(State state) {
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            this.phase = state.getPhase();
            this.sweepCounter = state.getSweepCounter();
            this.sweepFrequency = state.getSweepFrequency();
            this.sweepAddend = state.getSweepAddend();
            this.sweepRestartHold = state.getSweepRestartHold();
            this.sweepUnshifted = state.isSweepUnshifted();
            int n = 0;
            while (n < this.delayEnvelope.length) {
                this.delayEnvelope[n] = state.getDelayEnvelope(n);
                ++n;
            }
            n = 0;
            while (n < this.envelopeCanClock.length) {
                this.envelopeCanClock[n] = state.isEnvelopeCanClock(n);
                ++n;
            }
            n = 0;
            while (n < this.volume.length) {
                this.volume[n] = state.getVolume(n);
                ++n;
            }
            this.regNR10 = state.getRegNR10();
            this.regNR11 = state.getRegNR11();
            this.regNR12 = state.getRegNR12();
            this.regNR13 = state.getRegNR13();
            this.regNR14 = state.getRegNR14();
            this.regNR21 = state.getRegNR21();
            this.regNR22 = state.getRegNR22();
            this.regNR23 = state.getRegNR23();
            this.regNR24 = state.getRegNR24();
            this.regNR30 = state.getRegNR30();
            this.regNR31 = state.getRegNR31();
            this.regNR32 = state.getRegNR32();
            this.regNR33 = state.getRegNR33();
            this.regNR34 = state.getRegNR34();
            this.regNR41 = state.getRegNR41();
            this.regNR42 = state.getRegNR42();
            this.regNR43 = state.getRegNR43();
            this.regNR44 = state.getRegNR44();
            this.regNR50 = state.getRegNR50();
            this.regNR51 = state.getRegNR51();
            this.regNR52 = state.getRegNR52();
            this.wavePatternRAM = new int[state.getWavePatternRAM().length];
            System.arraycopy(state.getWavePatternRAM(), 0, this.wavePatternRAM, 0, this.wavePatternRAM.length);
            this.regLinearFeedbackShift = state.getRegLinearFeedbackShift();
            this.noiseCounter = state.getNoiseCounter();
            this.noiseCounterOffset = state.getNoiseCounterOffset();
            this.noiseCounterJustReloaded = state.isNoiseCounterJustReloaded();
            this.enableState = state.getEnableState();
            this.waveChannelJustEnabled = state.isWaveChannelJustEnabled();
            n = 0;
            while (n < this.output.length) {
                this.output[n] = state.getOutput(n);
                ++n;
            }
            n = 0;
            while (n < this.counter.length) {
                this.counter[n] = state.getCounter(n);
                ++n;
            }
            n = 0;
            while (n < this.generatorPhase.length) {
                this.generatorPhase[n] = state.getGeneratorPhase(n);
                ++n;
            }
            n = 0;
            while (n < this.sample.length) {
                this.sample[n] = state.getSample(n);
                ++n;
            }
            n = 0;
            while (n < this.samples.length) {
                this.samples[n] = state.getSamples(n);
                ++n;
            }
        }

        @Override
        public State clone() {
            return new CloneState(this);
        }

        @Override
        public int getPhase() {
            return this.phase;
        }

        @Override
        public int getSweepCounter() {
            return this.sweepCounter;
        }

        @Override
        public int getSweepFrequency() {
            return this.sweepFrequency;
        }

        @Override
        public int getSweepAddend() {
            return this.sweepAddend;
        }

        @Override
        public int getSweepRestartHold() {
            return this.sweepRestartHold;
        }

        @Override
        public boolean isSweepUnshifted() {
            return this.sweepUnshifted;
        }

        @Override
        public int getDelayEnvelope(int n) {
            return this.delayEnvelope[n];
        }

        @Override
        public boolean isEnvelopeCanClock(int n) {
            return this.envelopeCanClock[n];
        }

        @Override
        public int getVolume(int n) {
            return this.volume[n];
        }

        @Override
        public int getLength(int n) {
            switch (n) {
                case 0: {
                    return 64 - (this.getRegNR11() & 0x3F);
                }
                case 1: {
                    return 64 - (this.getRegNR21() & 0x3F);
                }
                case 2: {
                    return 256 - this.getRegNR31();
                }
                case 3: {
                    return 64 - (this.getRegNR41() & 0x3F);
                }
            }
            return 0;
        }

        @Override
        public int getRegNR10() {
            return this.regNR10;
        }

        @Override
        public int getRegNR11() {
            return this.regNR11;
        }

        @Override
        public int getRegNR12() {
            return this.regNR12;
        }

        @Override
        public int getRegNR13() {
            return this.regNR13;
        }

        @Override
        public int getRegNR14() {
            return this.regNR14;
        }

        @Override
        public int getRegNR21() {
            return this.regNR21;
        }

        @Override
        public int getRegNR22() {
            return this.regNR22;
        }

        @Override
        public int getRegNR23() {
            return this.regNR23;
        }

        @Override
        public int getRegNR24() {
            return this.regNR24;
        }

        @Override
        public int getRegNR30() {
            return this.regNR30;
        }

        @Override
        public int getRegNR31() {
            return this.regNR31;
        }

        @Override
        public int getRegNR32() {
            return this.regNR32;
        }

        @Override
        public int getRegNR33() {
            return this.regNR33;
        }

        @Override
        public int getRegNR34() {
            return this.regNR34;
        }

        @Override
        public int getRegNR41() {
            return this.regNR41;
        }

        @Override
        public int getRegNR42() {
            return this.regNR42;
        }

        @Override
        public int getRegNR43() {
            return this.regNR43;
        }

        @Override
        public int getRegNR44() {
            return this.regNR44;
        }

        @Override
        public int getRegNR50() {
            return this.regNR50;
        }

        @Override
        public int getRegNR51() {
            return this.regNR51;
        }

        @Override
        public int getRegNR52() {
            return this.regNR52;
        }

        @Override
        public int[] getWavePatternRAM() {
            return this.wavePatternRAM;
        }

        @Override
        public int getNoiseCounter() {
            return this.noiseCounter;
        }

        @Override
        public int getNoiseCounterOffset() {
            return this.noiseCounterOffset;
        }

        @Override
        public boolean isNoiseCounterJustReloaded() {
            return this.noiseCounterJustReloaded;
        }

        @Override
        public int getRegLinearFeedbackShift() {
            return this.regLinearFeedbackShift;
        }

        @Override
        public EnableState getEnableState() {
            return this.enableState;
        }

        @Override
        public boolean isWaveChannelJustEnabled() {
            return this.waveChannelJustEnabled;
        }

        @Override
        public int getOutput(int n) {
            return this.output[n];
        }

        @Override
        public int getCounter(int n) {
            return this.counter[n];
        }

        @Override
        public int getGeneratorPhase(int n) {
            return this.generatorPhase[n];
        }

        @Override
        public int getSample(int n) {
            return this.sample[n];
        }

        @Override
        public int getSamples(int n) {
            return this.samples[n];
        }
    }

    public static enum EnableState {
        ENABLED,
        ENABLING,
        DELAYED;

    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getPhase();

        public int getSweepCounter();

        public int getSweepFrequency();

        public int getSweepAddend();

        public int getSweepRestartHold();

        public boolean isSweepUnshifted();

        public int getDelayEnvelope(int var1);

        public boolean isEnvelopeCanClock(int var1);

        public int getVolume(int var1);

        public int getLength(int var1);

        public int getRegNR10();

        public int getRegNR11();

        public int getRegNR12();

        public int getRegNR13();

        public int getRegNR14();

        public int getRegNR21();

        public int getRegNR22();

        public int getRegNR23();

        public int getRegNR24();

        public int getRegNR30();

        public int getRegNR31();

        public int getRegNR32();

        public int getRegNR33();

        public int getRegNR34();

        public int getRegNR41();

        public int getRegNR42();

        public int getRegNR43();

        public int getRegNR44();

        public int getRegNR50();

        public int getRegNR51();

        public int getRegNR52();

        public int[] getWavePatternRAM();

        public int getNoiseCounter();

        public int getNoiseCounterOffset();

        public boolean isNoiseCounterJustReloaded();

        public int getRegLinearFeedbackShift();

        public EnableState getEnableState();

        public boolean isWaveChannelJustEnabled();

        public int getOutput(int var1);

        public int getCounter(int var1);

        public int getGeneratorPhase(int var1);

        public int getSample(int var1);

        public int getSamples(int var1);
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }

    public static interface VinProvider {
        public void preAdvance(int var1);

        public void advance(int var1);

        public int getSamples();
    }
}

