/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Properties;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.JTextComponent;

public class HistoryBox
extends JComboBox<String> {
    private final DefaultComboBoxModel<String> history = new DefaultComboBoxModel();
    private final String historyName;
    private final int historySize;

    public HistoryBox(String string, int n) {
        super.setEditor(new BasicComboBoxEditor());
        final JTextComponent jTextComponent = this.getEditorComponent();
        this.setModel(this.history);
        this.historyName = string;
        this.historySize = n;
        this.setEditable(true);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                HistoryBox.this.selectAll();
                String string = HistoryBox.this.getText();
                String string2 = string.toUpperCase();
                Object object = HistoryBox.this.getSelectedItem();
                if (object != null && object.toString().toUpperCase().startsWith(string2)) {
                    return;
                }
                int n = 0;
                while (n < HistoryBox.this.getItemCount()) {
                    if (((String)HistoryBox.this.getItemAt(n)).toUpperCase().startsWith(string2)) {
                        HistoryBox.this.setSelectedIndex(n);
                        return;
                    }
                    ++n;
                }
                HistoryBox.this.setSelectedIndex(-1);
                jTextComponent.setText(string);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jTextComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                HistoryBox.this.selectAll();
            }
        });
    }

    public void rememberCurrentText() {
        String string = this.getText();
        if (string != null && !string.isEmpty()) {
            this.history.removeElement(string);
            this.history.insertElementAt(string, 0);
            this.setSelectedIndex(0);
            if (this.history.getSize() > this.historySize) {
                this.history.removeElementAt(this.history.getSize() - 1);
            }
        }
    }

    public String getText() {
        return this.getEditorComponent().getText();
    }

    public void selectAll() {
        this.getEditorComponent().selectAll();
    }

    public void loadHistory(Properties properties) {
        this.history.removeAllElements();
        int n = 0;
        while (n < this.historySize) {
            String string = properties.getProperty(String.valueOf(this.historyName) + n);
            if (string == null) break;
            this.history.addElement(string);
            ++n;
        }
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void saveHistory(Properties properties) {
        int n = 0;
        while (n < this.history.getSize()) {
            properties.setProperty(String.valueOf(this.historyName) + n, this.history.getElementAt(n));
            ++n;
        }
    }

    private JTextComponent getEditorComponent() {
        return (JTextComponent)this.getEditor().getEditorComponent();
    }

    @Override
    public void setEditor(ComboBoxEditor comboBoxEditor) {
        if (this.getEditor() != null) {
            throw new UnsupportedOperationException("The editor of a HistoryBox must not be changed.");
        }
        super.setEditor(comboBoxEditor);
    }
}

