/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class FontUtilities {
    private FontUtilities() {
    }

    public static Font getDefaultFont() {
        Font font = UIManager.getFont("defaultFont");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public static int getDefaultFontSize() {
        return FontUtilities.getDefaultFont().getSize();
    }

    public static void setDefaultFontSize(int n) {
        FontUtilities.scaleFonts((float)n / FontUtilities.getDefaultFont().getSize2D());
    }

    public static void scaleFonts(float f) {
        if (Math.abs(f - 1.0f) > 0.001f) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            Enumeration enumeration = uIDefaults.keys();
            HashSet hashSet = new HashSet();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object object = UIManager.get(k);
                if (!hashSet.add(k) || !(object instanceof Font)) continue;
                Font font = (Font)object;
                uIDefaults.put(k, new FontUIResource(font.getName(), font.getStyle(), Math.round(font.getSize2D() * f)));
            }
            FontUtilities.updateComponentTreeUI();
        }
    }

    public static int getTableFontSize() {
        return UIManager.getFont("Table.font").getSize();
    }

    public static void setTableFontSize(int n) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!k.equals("Table.font")) continue;
            Font font = (Font)object;
            uIDefaults.put(k, new FontUIResource(font.getName(), font.getStyle(), n));
        }
        FontUtilities.updateComponentTreeUI();
    }

    public static String getTableFontName() {
        return UIManager.getFont("Table.font").getName();
    }

    public static void setTableFont(String string) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!k.equals("Table.font")) continue;
            Font font = (Font)object;
            uIDefaults.put(k, new FontUIResource(string, font.getStyle(), font.getSize()));
        }
        FontUtilities.updateComponentTreeUI();
    }

    private static void updateComponentTreeUI() {
        Window[] windowArray = Window.getOwnerlessWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window window = windowArray[n2];
            Window[] windowArray2 = window.getOwnedWindows();
            int n3 = windowArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Window window2 = windowArray2[n4];
                if (window2.isShowing()) {
                    SwingUtilities.updateComponentTreeUI(window2);
                }
                ++n4;
            }
            SwingUtilities.updateComponentTreeUI(window);
            ++n2;
        }
    }

    public static Iterable<String> getMonospaceFontNames() {
        final String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                final int n = FontUtilities.getDefaultFontSize();
                return new Iterator<String>(){
                    private int index;
                    private String nextName = this.findNext();

                    @Override
                    public boolean hasNext() {
                        return this.nextName != null;
                    }

                    @Override
                    public String next() {
                        String string = this.nextName;
                        this.nextName = this.findNext();
                        return string;
                    }

                    private String findNext() {
                        while (this.index < stringArray.length) {
                            String string;
                            if ("Monospaced".equals(string = stringArray[this.index++]) || !FontUtilities.isMonospace(new Font(string, 0, n))) continue;
                            return string;
                        }
                        return null;
                    }
                };
            }
        };
        return iterable;
    }

    public static Font ensureMonospaceFont(Font font) {
        if (font == null || FontUtilities.isMonospace(font)) {
            return font;
        }
        return font instanceof FontUIResource ? new FontUIResource("Monospaced", font.getStyle(), font.getSize()) : new Font("Monospaced", font.getStyle(), font.getSize());
    }

    static boolean isMonospace(Font font) {
        if (font == null || !font.canDisplay('W') || !font.canDisplay('\'') || font.getNumGlyphs() >= 10000) {
            return false;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        return font.getStringBounds("W", fontRenderContext).getWidth() == font.getStringBounds("'", fontRenderContext).getWidth();
    }

    public static boolean isFontAvailable(String string) {
        Font font = new Font(string, 0, 1);
        return font.getName().equals(font.getFamily());
    }
}

