/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serialize;

import com.sun.org.apache.xml.internal.serialize.EncodingInfo;
import com.sun.org.apache.xml.internal.serialize.Encodings;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;

public class OutputFormat {
    private String _method;
    private String _version;
    private int _indent = 0;
    private String _encoding = "UTF-8";
    private EncodingInfo _encodingInfo = null;
    private boolean _allowJavaNames = false;
    private String _mediaType;
    private String _doctypeSystem;
    private String _doctypePublic;
    private boolean _omitXmlDeclaration = false;
    private boolean _omitDoctype = false;
    private boolean _omitComments = false;
    private boolean _stripComments = false;
    private boolean _standalone = false;
    private String[] _cdataElements;
    private String[] _nonEscapingElements;
    private String _lineSeparator = "\n";
    private int _lineWidth = 72;
    private boolean _preserve = false;
    private boolean _preserveEmptyAttributes = false;

    public OutputFormat() {
    }

    public OutputFormat(String method, String encoding, boolean indenting) {
        this.setMethod(method);
        this.setEncoding(encoding);
        this.setIndenting(indenting);
    }

    public OutputFormat(Document doc) {
        this.setMethod(OutputFormat.whichMethod(doc));
        this.setDoctype(OutputFormat.whichDoctypePublic(doc), OutputFormat.whichDoctypeSystem(doc));
        this.setMediaType(OutputFormat.whichMediaType(this.getMethod()));
    }

    public OutputFormat(Document doc, String encoding, boolean indenting) {
        this(doc);
        this.setEncoding(encoding);
        this.setIndenting(indenting);
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public int getIndent() {
        return this._indent;
    }

    public boolean getIndenting() {
        return this._indent > 0;
    }

    public void setIndent(int indent) {
        this._indent = indent < 0 ? 0 : indent;
    }

    public void setIndenting(boolean on) {
        if (on) {
            this._indent = 4;
            this._lineWidth = 72;
        } else {
            this._indent = 0;
            this._lineWidth = 0;
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
        this._encodingInfo = null;
    }

    public void setEncoding(EncodingInfo encInfo) {
        this._encoding = encInfo.getIANAName();
        this._encodingInfo = encInfo;
    }

    public EncodingInfo getEncodingInfo() throws UnsupportedEncodingException {
        if (this._encodingInfo == null) {
            this._encodingInfo = Encodings.getEncodingInfo(this._encoding, this._allowJavaNames);
        }
        return this._encodingInfo;
    }

    public void setAllowJavaNames(boolean allow) {
        this._allowJavaNames = allow;
    }

    public boolean setAllowJavaNames() {
        return this._allowJavaNames;
    }

    public String getMediaType() {
        return this._mediaType;
    }

    public void setMediaType(String mediaType) {
        this._mediaType = mediaType;
    }

    public void setDoctype(String publicId, String systemId) {
        this._doctypePublic = publicId;
        this._doctypeSystem = systemId;
    }

    public String getDoctypePublic() {
        return this._doctypePublic;
    }

    public String getDoctypeSystem() {
        return this._doctypeSystem;
    }

    public boolean getOmitComments() {
        return this._omitComments;
    }

    public void setOmitComments(boolean omit) {
        this._omitComments = omit;
    }

    public boolean getOmitDocumentType() {
        return this._omitDoctype;
    }

    public void setOmitDocumentType(boolean omit) {
        this._omitDoctype = omit;
    }

    public boolean getOmitXMLDeclaration() {
        return this._omitXmlDeclaration;
    }

    public void setOmitXMLDeclaration(boolean omit) {
        this._omitXmlDeclaration = omit;
    }

    public boolean getStandalone() {
        return this._standalone;
    }

    public void setStandalone(boolean standalone) {
        this._standalone = standalone;
    }

    public String[] getCDataElements() {
        return this._cdataElements;
    }

    public boolean isCDataElement(String tagName) {
        if (this._cdataElements == null) {
            return false;
        }
        for (int i = 0; i < this._cdataElements.length; ++i) {
            if (!this._cdataElements[i].equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public void setCDataElements(String[] cdataElements) {
        this._cdataElements = cdataElements;
    }

    public String[] getNonEscapingElements() {
        return this._nonEscapingElements;
    }

    public boolean isNonEscapingElement(String tagName) {
        if (this._nonEscapingElements == null) {
            return false;
        }
        for (int i = 0; i < this._nonEscapingElements.length; ++i) {
            if (!this._nonEscapingElements[i].equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public void setNonEscapingElements(String[] nonEscapingElements) {
        this._nonEscapingElements = nonEscapingElements;
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator == null ? "\n" : lineSeparator;
    }

    public boolean getPreserveSpace() {
        return this._preserve;
    }

    public void setPreserveSpace(boolean preserve) {
        this._preserve = preserve;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this._lineWidth = lineWidth <= 0 ? 0 : lineWidth;
    }

    public boolean getPreserveEmptyAttributes() {
        return this._preserveEmptyAttributes;
    }

    public void setPreserveEmptyAttributes(boolean preserve) {
        this._preserveEmptyAttributes = preserve;
    }

    public char getLastPrintable() {
        if (this.getEncoding() != null && this.getEncoding().equalsIgnoreCase("ASCII")) {
            return '\u00ff';
        }
        return '\uffff';
    }

    public static String whichMethod(Document doc) {
        if (doc instanceof HTMLDocument) {
            return "html";
        }
        for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equalsIgnoreCase("html")) {
                    return "html";
                }
                if (node.getNodeName().equalsIgnoreCase("root")) {
                    return "fop";
                }
                return "xml";
            }
            if (node.getNodeType() != 3) continue;
            String value = node.getNodeValue();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == ' ' || value.charAt(i) == '\n' || value.charAt(i) == '\t' || value.charAt(i) == '\r') continue;
                return "xml";
            }
        }
        return "xml";
    }

    public static String whichDoctypePublic(Document doc) {
        DocumentType doctype = doc.getDoctype();
        if (doctype != null) {
            try {
                return doctype.getPublicId();
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (doc instanceof HTMLDocument) {
            return "-//W3C//DTD XHTML 1.0 Strict//EN";
        }
        return null;
    }

    public static String whichDoctypeSystem(Document doc) {
        DocumentType doctype = doc.getDoctype();
        if (doctype != null) {
            try {
                return doctype.getSystemId();
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (doc instanceof HTMLDocument) {
            return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
        }
        return null;
    }

    public static String whichMediaType(String method) {
        if (method.equalsIgnoreCase("xml")) {
            return "text/xml";
        }
        if (method.equalsIgnoreCase("html")) {
            return "text/html";
        }
        if (method.equalsIgnoreCase("xhtml")) {
            return "text/html";
        }
        if (method.equalsIgnoreCase("text")) {
            return "text/plain";
        }
        if (method.equalsIgnoreCase("fop")) {
            return "application/pdf";
        }
        return null;
    }

    public static class DTD {
        public static final String HTMLPublicId = "-//W3C//DTD HTML 4.01//EN";
        public static final String HTMLSystemId = "http://www.w3.org/TR/html4/strict.dtd";
        public static final String XHTMLPublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
        public static final String XHTMLSystemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
    }

    public static class Defaults {
        public static final int Indent = 4;
        public static final String Encoding = "UTF-8";
        public static final int LineWidth = 72;
    }
}

