/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import assembler.SourceMap;
import dap.AbstractDebugAdapter;
import dap.DebugAdapter;
import dap.messages.events.StoppedEvent;
import dap.messages.requests.EvaluateRequest;
import dap.messages.requests.InitializeRequest;
import dap.messages.requests.VariablesRequest;
import dap.types.DebugThread;
import dap.types.EvaluateResult;
import dap.types.ExceptionBreakpointsFilter;
import dap.types.Scope;
import dap.types.Source;
import dap.types.SourceBreakpoint;
import dap.types.SourceResult;
import dap.types.StackFrame;
import dap.types.StackFrameFormat;
import dap.types.SteppingGranularity;
import dap.types.ValueFormat;
import disassembler.CDBException;
import disassembler.CDBSourceMap;
import disassembler.CSourceMap;
import disassembler.Symbols;
import disassembler.Z80Disassembler;
import evscript.EvscriptSourceMap;
import expressions.ParseException;
import expressions.UnknownVariableException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import json.JSONArray;
import platform.Emulicious;
import platform.debugger.Breakpoint;
import platform.debugger.BreakpointWindow;
import platform.debugger.Debugger;
import platform.debugger.SystemDebugger;
import sdcc.CDBParser;
import sdcc.cdb.FunctionRecord;
import sdcc.cdb.LinkerCRecord;
import sdcc.cdb.LinkerSymbolEndRecord;
import sdcc.cdb.LinkerSymbolRecord;
import sdcc.cdb.ModuleRecord;
import sdcc.cdb.Record;
import sdcc.cdb.SymbolRecord;
import sdcc.cdb.SymbolicRecord;
import sdcc.cdb.TypeChainRecord;
import sdcc.cdb.TypeRecord;
import variables.Variable;
import variables.Variables;

public class DAPDebugger
extends AbstractDebugAdapter
implements SystemDebugger.SystemListener,
SystemDebugger.BreakpointListener,
SystemDebugger.MessageReceiver {
    private static final int DUMMY_THREAD_ID = 1;
    private static final DebugThread[] DUMMY_THREAD = new DebugThread[]{new DebugThread(1, "Thread")};
    private static final int SOURCE_REFERENCE_DISASSEMBLY = 1;
    private static final StackFrame[] NO_STACK_FRAMES = new StackFrame[0];
    static final dap.types.Variable[] NO_VARIABLES = new dap.types.Variable[0];
    static Debugger debugger;
    private static SystemDebugger systemDebugger;
    private static DAPDebugger instance;
    private static Exception lastException;
    private boolean launched;
    private boolean launching;
    private boolean clientLinesStartAt1;
    private boolean clientColumnsStartAt1;
    private boolean wasSuspended;
    private boolean pausing;
    private boolean cDebugging;
    private final Map<String, CSymbol> cGlobals = new HashMap<String, CSymbol>();
    final Map<Integer, CSymbol> cGlobalsByAddress = new HashMap<Integer, CSymbol>();
    final Map<String, List<TypeRecord.TypeMember>> cStructMembers = new HashMap<String, List<TypeRecord.TypeMember>>();
    final Map<String, List<CSymbol>> cLocals = new HashMap<String, List<CSymbol>>();
    private final Map<Integer, String> cLevels = new HashMap<Integer, String>();
    private final Map<String, String> cFunctionModules = new HashMap<String, String>();
    private boolean cStepOver;
    private boolean cStepOnceMore;
    private int cStepOverLine;
    private int cStepOutDepth;
    private int cStepOutPrevDepth;
    private final Map<CExpression, Integer> cStructuredVariableReferences = new HashMap<CExpression, Integer>();
    private final Map<Integer, CExpression> cStructuredVariables = new HashMap<Integer, CExpression>();
    private final Map<Integer, Integer> cStructuredVariableStackFrameAddresses = new HashMap<Integer, Integer>();
    private final Map<String, Integer> cScopeReferences = new HashMap<String, Integer>();
    private final Map<Integer, CScope> cScopes = new HashMap<Integer, CScope>();
    private SourceBreakpoint[] disassemblyBreakpoints = new SourceBreakpoint[0];
    private int[] disassemblyBreakpointLines = new int[0];
    private final Map<String, SourceBreakpoint[]> sourceBreakpoints = new HashMap<String, SourceBreakpoint[]>();
    private final Map<String, int[]> breakpointLines = new HashMap<String, int[]>();
    private int variableRefCounter;
    private final Map<Integer, Integer> stackFrameReferences = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> stackFrameBackReferences = new HashMap<Integer, Integer>();
    private final Map<Variable[], Integer> systemVariablesReferences = new HashMap<Variable[], Integer>();
    private final Map<Integer, Variable[]> systemVariablesBackReferences = new HashMap<Integer, Variable[]>();
    private final Map<Integer, String> evaluateExpressions = new HashMap<Integer, String>();
    private final DebugAdapter.Capabilities capabilities = new DebugAdapter.AbstractCapabilities(){

        @Override
        public boolean supportsEvaluateForHovers() {
            return true;
        }

        @Override
        public boolean supportsLogPoints() {
            return true;
        }

        @Override
        public boolean supportsConditionalBreakpoints() {
            return true;
        }

        @Override
        public boolean supportsStepBack() {
            return true;
        }

        @Override
        public ExceptionBreakpointsFilter[] getExceptionBreakpointFilters() {
            if (debugger == null) {
                return DAPDebugger.loadExceptionBreakpointFilters();
            }
            String[] stringArray = debugger.getAllExceptionBreakpointDescriptions();
            ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray = new ExceptionBreakpointsFilter[stringArray.length];
            int[] nArray = debugger.getErrorBreakpointMapping();
            int[] nArray2 = new int[nArray.length];
            int n = 0;
            while (n < nArray2.length) {
                nArray2[n] = systemDebugger.getErrorCodes()[nArray[n]];
                ++n;
            }
            n = exceptionBreakpointsFilterArray.length - nArray2.length;
            int n2 = 0;
            while (n2 < exceptionBreakpointsFilterArray.length) {
                exceptionBreakpointsFilterArray[n2] = new ExceptionBreakpointsFilter("Exception" + (n2 >= n ? nArray2[n2 - n] : n2 - n), stringArray[n2], null, debugger.isExceptionBreakpointEnabled(n2));
                ++n2;
            }
            return exceptionBreakpointsFilterArray;
        }
    };

    private DAPDebugger(int n) throws IOException {
        super(n);
    }

    public static void create(int n) throws IOException {
        if (instance == null) {
            try {
                lastException = null;
                instance = new DAPDebugger(n);
            }
            catch (IOException iOException) {
                lastException = iOException;
                throw iOException;
            }
        }
    }

    public static void dispose() {
        if (instance != null) {
            instance.close();
            if (systemDebugger != null) {
                systemDebugger.removeSystemListener(instance);
                systemDebugger.removeMessageReceiver(instance);
                systemDebugger.removeBreakpointListener(instance);
            }
        }
        instance = null;
    }

    public static void setDebugger(Debugger debugger, SystemDebugger systemDebugger) {
        if (instance != null) {
            if (DAPDebugger.systemDebugger != null) {
                DAPDebugger.systemDebugger.removeSystemListener(instance);
                DAPDebugger.systemDebugger.removeMessageReceiver(instance);
                DAPDebugger.systemDebugger.removeBreakpointListener(instance);
            }
            if (systemDebugger == null) {
                instance.sendTerminatedEvent();
            }
        }
        DAPDebugger.debugger = debugger;
        DAPDebugger.systemDebugger = systemDebugger;
        if (instance != null && debugger != null && instance.isConnected()) {
            instance.sendInitializedEvent();
            DAPDebugger.updateExceptionBreakpointsFilters();
        }
    }

    private static void updateExceptionBreakpointsFilters() {
        ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray;
        ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray2 = DAPDebugger.loadExceptionBreakpointFilters();
        boolean bl = exceptionBreakpointsFilterArray2.length != (exceptionBreakpointsFilterArray = DAPDebugger.instance.capabilities.getExceptionBreakpointFilters()).length;
        int n = 0;
        while (!bl && n < exceptionBreakpointsFilterArray.length) {
            if (!exceptionBreakpointsFilterArray[n].getString("label").equals(exceptionBreakpointsFilterArray2[n].getString("label"))) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("exceptionBreakpointFilters", instance.createExceptionBreakpointFiltersArray());
            instance.sendCapabilitiesEvent(hashMap);
            instance.saveExceptionBreakpointFilters();
            instance.sendOutputEvent("WARNING: Due to the way your remote debugger works, the list of exception breakpoints might be incorrect. Start a new debugging session to work with updated exception breakpoints.\n");
        }
    }

    public static boolean isTailCall(int n, int n2) {
        return instance != null && DAPDebugger.instance.cDebugging && DAPDebugger.instance.cGlobalsByAddress.containsKey(n);
    }

    public static String getStatus() {
        if (instance == null) {
            return lastException != null ? "Error: " + lastException.getMessage() : "Disabled";
        }
        return instance.isConnected() ? "Connected" : "Listening";
    }

    public static boolean isLaunching() {
        return instance != null && DAPDebugger.instance.launching;
    }

    private JSONArray createExceptionBreakpointFiltersArray() {
        ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray = this.capabilities.getExceptionBreakpointFilters();
        if (exceptionBreakpointsFilterArray == null) {
            return new JSONArray();
        }
        JSONArray jSONArray = new JSONArray();
        ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray2 = exceptionBreakpointsFilterArray;
        int n = exceptionBreakpointsFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionBreakpointsFilter exceptionBreakpointsFilter = exceptionBreakpointsFilterArray2[n2];
            jSONArray.add(exceptionBreakpointsFilter);
            ++n2;
        }
        return jSONArray;
    }

    private void saveExceptionBreakpointFilters() {
        StringBuilder stringBuilder = new StringBuilder();
        ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray = this.capabilities.getExceptionBreakpointFilters();
        int n = exceptionBreakpointsFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionBreakpointsFilter exceptionBreakpointsFilter = exceptionBreakpointsFilterArray[n2];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(exceptionBreakpointsFilter.getString("filter")).append(":").append(exceptionBreakpointsFilter.getString("label")).append(':').append(exceptionBreakpointsFilter.getBoolean("default"));
            ++n2;
        }
        Emulicious.getProperties().setProperty("DAPExceptionBreakpointFilters", stringBuilder.toString());
    }

    static ExceptionBreakpointsFilter[] loadExceptionBreakpointFilters() {
        String string = Emulicious.getProperties().getProperty("DAPExceptionBreakpointFilters");
        if (string == null) {
            String[] stringArray = BreakpointWindow.getExceptionDescriptions();
            ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray = new ExceptionBreakpointsFilter[stringArray.length];
            int n = 0;
            while (n < exceptionBreakpointsFilterArray.length) {
                exceptionBreakpointsFilterArray[n] = new ExceptionBreakpointsFilter("Exception" + (n - exceptionBreakpointsFilterArray.length), stringArray[n], null, true);
                ++n;
            }
            return exceptionBreakpointsFilterArray;
        }
        ArrayList<ExceptionBreakpointsFilter> arrayList = new ArrayList<ExceptionBreakpointsFilter>();
        String[] stringArray = string.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            String[] stringArray2 = string2.split(":");
            try {
                arrayList.add(new ExceptionBreakpointsFilter(stringArray2[0], stringArray2[1], null, Boolean.parseBoolean(stringArray2[2])));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return arrayList.toArray(new ExceptionBreakpointsFilter[arrayList.size()]);
    }

    @Override
    protected void sendStoppedEvent(StoppedEvent.Reason reason, int n) {
        if (!this.cDebugging || debugger.getCurrentFile() != null || systemDebugger.isExceptionHit()) {
            super.sendStoppedEvent(reason, n);
        }
    }

    private void sendStoppedEvent(StoppedEvent.Reason reason) {
        this.sendStoppedEvent(reason, 1);
    }

    private void sendStoppedEventException(String string, String string2) {
        this.sendStoppedEvent(StoppedEvent.Reason.EXCEPTION, string2, 1, string);
    }

    private void sendContinuedEvent() {
        this.sendContinuedEvent(1);
    }

    @Override
    public DebugAdapter.Capabilities initialize(InitializeRequest initializeRequest) {
        this.clientLinesStartAt1 = initializeRequest.isLinesStartAt1();
        this.clientColumnsStartAt1 = initializeRequest.isColumnsStartAt1();
        return this.capabilities;
    }

    @Override
    protected void sendInitializedEvent() {
        super.sendInitializedEvent();
    }

    private int toClientLine(int n) {
        return this.clientLinesStartAt1 ? n + 1 : n;
    }

    private int toClientColumn(int n) {
        return this.clientColumnsStartAt1 ? n + 1 : n;
    }

    private int fromClientLine(int n) {
        return this.clientLinesStartAt1 ? n - 1 : n;
    }

    private int fromClientColumn(int n) {
        return this.clientColumnsStartAt1 ? n - 1 : n;
    }

    @Override
    public void disconnect(boolean bl, Boolean bl2) {
        if (debugger != null) {
            debugger.setDisableBringToTopUponSuspend(false);
            systemDebugger.setSuspendOnMappedLinesOnly(false);
            systemDebugger.removeSystemListener(this);
            systemDebugger.removeMessageReceiver(this);
            systemDebugger.removeBreakpointListener(this);
            Debugger.setDAPdebugging(false);
            Debugger.setForceLoadSources(false);
            Debugger.setForceSuspendOnOpen(false);
            if (this.launched || bl2 != null && bl2.booleanValue()) {
                Emulicious.unloadROM();
            }
        }
    }

    @Override
    public String launch(boolean bl, Map<String, String> map) {
        String string = map.get("program");
        if (string == null) {
            return "For launch requests the field 'program' must be set. Please check your launch configuration.";
        }
        File file = new File(DAPDebugger.fixWSLpath(string));
        Debugger.setDAPdebugging(true);
        Debugger.setForceLoadSources(true);
        Debugger.setForceSuspendOnOpen(true);
        try {
            this.launching = true;
            while (!Emulicious.isReady()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Emulicious.openFile(file, map.get("system"), bl, !bl);
        }
        finally {
            this.launching = false;
        }
        this.start(Boolean.parseBoolean(map.get("stopOnEntry")), true, map.get("additionalSrcFolders"));
        return null;
    }

    private static String fixWSLpath(String string) {
        String string2;
        if (string.startsWith("/mnt/") && !new File(string).exists() && new File(string2 = string.replaceFirst("/mnt/(.)/", "$1:/")).exists()) {
            string = string2;
        }
        return string;
    }

    @Override
    public void attach(Map<String, String> map) {
        Debugger.setDAPdebugging(true);
        Debugger.setForceLoadSources(true);
        if (Emulicious.openDebugger(true)) {
            if (debugger != null && this.isConnected()) {
                this.sendInitializedEvent();
                DAPDebugger.updateExceptionBreakpointsFilters();
            }
            this.start(false, false, map.get("additionalSrcFolders"));
        } else {
            Debugger.setDAPdebugging(false);
            Debugger.setForceLoadSources(false);
            this.sendTerminatedEvent();
        }
    }

    private static void addSrcFolders(String string) {
        if (string != null) {
            String[] stringArray = string.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                debugger.addSrcFolder(new File(string2));
                ++n2;
            }
        }
    }

    private void start(boolean bl, boolean bl2, String string) {
        if (systemDebugger != null) {
            this.launched = bl2;
            debugger.linesToString();
            SourceMap sourceMap = Z80Disassembler.getSourceMap();
            this.cDebugging = sourceMap instanceof CSourceMap;
            if (this.cDebugging) {
                DAPDebugger.addSrcFolders(string);
                if (sourceMap instanceof CDBSourceMap) {
                    CDBSourceMap cDBSourceMap = (CDBSourceMap)sourceMap;
                    if (!cDBSourceMap.isValid()) {
                        throw new CDBException("CDB file is invalid.\nIf the CDB file is empty, you likely just forgot to pass the --debug commandline flag to SDCC's compiler frontend.");
                    }
                    Set<String> set = cDBSourceMap.determineFilesNotFound();
                    if (!set.isEmpty()) {
                        String string2 = set.toString();
                        this.sendOutputEvent("WARNING: Failed to locate the following source files:\n         " + string2.substring(1, string2.length() - 1) + "\n         If you want to debug any of these files, make sure to add their containing folder via the additionalSrcFolders setting in your launch.json.\n");
                    }
                } else {
                    this.sendOutputEvent("WARNING: Failed to locate CDB file for your C project.\n         Only limitted C debugging is supported this way.\n         For a better experience, make sure to make SDCC generate a CDB file and that it is located in the same folder as your ROM.\n");
                }
                this.parseSymbolsFromCDBfile();
            }
            systemDebugger.setSuspendOnMappedLinesOnly(this.cDebugging || Z80Disassembler.getSourceMap() instanceof EvscriptSourceMap);
            if (bl2 && !bl) {
                systemDebugger.resume();
            }
            if (Debugger.isSuspended()) {
                this.sendStoppedEvent(StoppedEvent.Reason.ENTRY);
            }
            this.wasSuspended = Debugger.isSuspended();
            debugger.setDisableBringToTopUponSuspend(true);
            systemDebugger.clearBreakpoints();
            this.sourceBreakpoints.clear();
            this.breakpointLines.clear();
            this.disassemblyBreakpoints = new SourceBreakpoint[0];
            this.disassemblyBreakpointLines = new int[0];
            this.clearVariableReferences();
            systemDebugger.addSystemListener(this);
            systemDebugger.addMessageReceiver(this);
            systemDebugger.addBreakpointListener(this);
        }
    }

    private void clearVariableReferences() {
        this.cStructuredVariables.clear();
        this.cStructuredVariableReferences.clear();
        this.cStructuredVariableStackFrameAddresses.clear();
        this.cScopes.clear();
        this.cScopeReferences.clear();
        this.stackFrameReferences.clear();
        this.stackFrameBackReferences.clear();
        this.systemVariablesReferences.clear();
        this.systemVariablesBackReferences.clear();
        this.evaluateExpressions.clear();
        this.variableRefCounter = 1;
    }

    private int createStackFrameReference(int n) {
        Integer n2 = this.stackFrameReferences.get(n);
        if (n2 != null) {
            this.stackFrameBackReferences.put(n2, n);
            return n2;
        }
        int n3 = this.variableRefCounter++;
        this.stackFrameReferences.put(n, n3);
        this.stackFrameBackReferences.put(n3, n);
        return n3;
    }

    private int createSystemVariablesReference(Variable[] variableArray) {
        Integer n = this.systemVariablesReferences.get(variableArray);
        if (n != null) {
            this.systemVariablesBackReferences.put(n, variableArray);
            return n;
        }
        int n2 = this.variableRefCounter++;
        this.systemVariablesReferences.put(variableArray, n2);
        this.systemVariablesBackReferences.put(n2, variableArray);
        return n2;
    }

    @Override
    public DebugThread[] getThreads() {
        return DUMMY_THREAD;
    }

    @Override
    public boolean resume(int n) {
        this.wasSuspended = false;
        this.clearVariableReferences();
        if (systemDebugger != null) {
            systemDebugger.resume();
            return true;
        }
        return false;
    }

    @Override
    public void pause(int n) {
        this.wasSuspended = false;
        if (systemDebugger != null) {
            this.pausing = true;
            systemDebugger.suspend();
            if (systemDebugger.isSuspended() && !this.wasSuspended) {
                this.changeOccurred();
            }
        }
    }

    @Override
    public void next(int n, SteppingGranularity steppingGranularity) {
        this.wasSuspended = false;
        this.clearVariableReferences();
        if (systemDebugger != null) {
            if (this.cDebugging) {
                this.stepOverC();
                return;
            }
            systemDebugger.stepOver();
        }
    }

    @Override
    public void stepIn(int n, SteppingGranularity steppingGranularity) {
        this.wasSuspended = false;
        this.clearVariableReferences();
        if (systemDebugger != null) {
            systemDebugger.stepInto();
        }
    }

    @Override
    public void stepOut(int n, SteppingGranularity steppingGranularity) {
        this.wasSuspended = false;
        this.clearVariableReferences();
        if (systemDebugger != null) {
            if (this.cDebugging) {
                this.stepOutC();
            } else {
                systemDebugger.stepReturn();
            }
        }
    }

    @Override
    public void stepBack(int n, SteppingGranularity steppingGranularity) {
        this.wasSuspended = false;
        this.clearVariableReferences();
        if (systemDebugger != null) {
            systemDebugger.stepBack();
        }
        if (!this.wasSuspended) {
            this.changeOccurred();
        }
    }

    @Override
    public void reverseContinue(int n) {
        this.wasSuspended = false;
        this.clearVariableReferences();
        this.changeOccurred();
    }

    @Override
    public StackFrame[] getStackFrames(int n, int n2, int n3, StackFrameFormat stackFrameFormat) {
        if (debugger == null) {
            return NO_STACK_FRAMES;
        }
        Deque<Debugger.StackFrame> deque = this.getCurrentStackFrames();
        File file = debugger.getCurrentFile();
        if (this.cDebugging && file == null && !systemDebugger.isExceptionHit()) {
            return NO_STACK_FRAMES;
        }
        if (deque.isEmpty()) {
            return new StackFrame[]{new StackFrame(0, "Unknown", DAPDebugger.sourceForFile(file), this.toClientLine(debugger.getCurrentLineNumber()), 0)};
        }
        StackFrame[] stackFrameArray = new StackFrame[deque.size()];
        int n4 = stackFrameArray.length;
        for (Debugger.StackFrame stackFrame : deque) {
            stackFrameArray[--n4] = new StackFrame(n4, this.getStackFrameDisplayName(stackFrame), DAPDebugger.sourceForFile(stackFrame.getFile()), this.toClientLine(stackFrame.getLineNumber()), 0);
        }
        return stackFrameArray;
    }

    private String getStackFrameDisplayName(Debugger.StackFrame stackFrame) {
        if (stackFrame == null) {
            return null;
        }
        if (!this.cDebugging) {
            return stackFrame.getName();
        }
        String string = DAPDebugger.extractNameFromCDBline(stackFrame.getName());
        if (!string.isEmpty() && string.charAt(0) == '_') {
            CSymbol cSymbol = this.cGlobals.get(string.substring(1));
            return String.valueOf(cSymbol != null ? cSymbol.getName() : string) + "()";
        }
        return string;
    }

    private static String extractNameFromCDBline(String string) {
        if (string.isEmpty() || string.charAt(0) != 'F') {
            return string;
        }
        int n = string.indexOf(36);
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf(36, n + 1);
        if (n2 < 0) {
            return string;
        }
        return "_" + string.substring(n + 1, n2);
    }

    private static Source sourceForFile(File file) {
        return file != null ? new Source(file) : new Source(Emulicious.getROMfile(), 1);
    }

    private Debugger.StackFrame getStackFrame(int n) {
        Deque<Debugger.StackFrame> deque = this.getCurrentStackFrames();
        while (n > 0 && !deque.isEmpty()) {
            deque.removeLast();
            --n;
        }
        if (deque.isEmpty()) {
            return null;
        }
        return deque.getLast();
    }

    private Deque<Debugger.StackFrame> getCurrentStackFrames() {
        Deque<Debugger.StackFrame> deque = debugger.getCurrentStackFrames();
        if (this.cDebugging) {
            ArrayDeque<Debugger.StackFrame> arrayDeque = new ArrayDeque<Debugger.StackFrame>();
            for (Debugger.StackFrame stackFrame : deque) {
                String string = stackFrame.getName();
                if (string.isEmpty() || string.charAt(0) == '_' && !this.cGlobals.containsKey(string.substring(1))) continue;
                arrayDeque.addLast(stackFrame);
            }
            if (!deque.isEmpty() && (arrayDeque.isEmpty() || arrayDeque.getLast() != deque.getLast())) {
                arrayDeque.addLast(deque.getLast());
            }
            return arrayDeque;
        }
        return deque;
    }

    @Override
    public Scope[] getScopes(int n) {
        if (this.cDebugging) {
            return this.getScopesC(n);
        }
        ArrayList<Scope> arrayList = new ArrayList<Scope>();
        Variables variables = systemDebugger.getSystemVariables();
        if (variables != null) {
            int n2 = 0;
            String[] stringArray = variables.getScopes();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                if ("Registers".equals(string)) {
                    arrayList.add(new Scope(string, Scope.PresentationHint.REGISTERS, this.createSystemVariablesReference(variables.getVariables(n2++)), false));
                    Debugger.StackFrame stackFrame = this.getStackFrame(n);
                    if (stackFrame != null) {
                        arrayList.add(new Scope("Stackframe", Scope.PresentationHint.LOCALS, this.createStackFrameReference(n), false));
                    }
                } else {
                    arrayList.add(new Scope(string, Scope.PresentationHint.GLOBALS, this.createSystemVariablesReference(variables.getVariables(n2++)), false));
                }
                ++n4;
            }
        }
        return arrayList.toArray(new Scope[arrayList.size()]);
    }

    @Override
    public dap.types.Variable[] getVariables(int n, VariablesRequest.Filter filter, int n2, int n3, ValueFormat valueFormat) {
        if (this.cDebugging) {
            return this.getVariablesC(n, filter, n2, n3, valueFormat);
        }
        String string = this.evaluateExpressions.get(n);
        if (string != null) {
            try {
                return new dap.types.Variable[]{new dap.types.Variable("@" + string, debugger.parseExpression(string).wrapInRead().getValueString(), null, "@" + string), new dap.types.Variable("word @@(" + string + ")", debugger.parseExpression("word @@(" + string + ")").getValueString(), null, "word @@(" + string + ")")};
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
        Integer n4 = this.stackFrameBackReferences.get(n);
        if (n4 != null) {
            String[] stringArray = systemDebugger.getRegisterNames();
            Debugger.StackFrame stackFrame = this.getStackFrame(n4);
            dap.types.Variable[] variableArray = new dap.types.Variable[stackFrame.size()];
            int n5 = 0;
            while (n5 < variableArray.length) {
                int n6 = stackFrame.getSource(n5);
                if (n6 >= 0) {
                    String string2 = n6 >= stringArray.length ? "  (??)" : "  (" + stringArray[n6] + ")";
                    variableArray[n5] = new dap.types.Variable(String.format("$%04X", stackFrame.getAddress(n5)), String.valueOf(String.format("$%04X", stackFrame.getValue(n5))) + string2);
                } else {
                    variableArray[n5] = new dap.types.Variable(String.format("$%04X", stackFrame.getAddress(n5)), String.format("$%04X", stackFrame.getValue(n5)));
                }
                ++n5;
            }
            return variableArray;
        }
        Variable[] variableArray = this.systemVariablesBackReferences.get(n);
        if (variableArray != null) {
            dap.types.Variable[] variableArray2 = new dap.types.Variable[variableArray.length];
            int n7 = 0;
            while (n7 < variableArray2.length) {
                variableArray2[n7] = this.toVariable(variableArray[n7]);
                ++n7;
            }
            return variableArray2;
        }
        return NO_VARIABLES;
    }

    private dap.types.Variable toVariable(Variable variable) {
        Variable[] variableArray = variable.getVariables();
        int n = variableArray.length > 0 ? this.createSystemVariablesReference(variableArray) : 0;
        String string = variable.getValue() != null ? variable.getValue() : " [" + variable.getVariables().length + "]";
        return new dap.types.Variable(variable.getName(), string, variable.getType(), n);
    }

    @Override
    public SourceResult getSource(Source source, int n) {
        return new SourceResult(debugger.linesToString(), null);
    }

    @Override
    public EvaluateResult evaluate(String string, int n, EvaluateRequest.Context context, ValueFormat valueFormat) {
        if (this.cDebugging) {
            return this.evaluateC(string, n, context, valueFormat);
        }
        try {
            Debugger.Expression expression = debugger.parseExpression(string);
            int n2 = expression.getValue();
            String string2 = systemDebugger.isRAMaddress(n2) ? debugger.getRamLabel(systemDebugger.mapAddress(n2)) : null;
            int n3 = this.variableRefCounter++;
            this.evaluateExpressions.put(n3, string);
            return string2 != null ? new EvaluateResult(String.valueOf(string) + " = " + expression.getValueString() + " (" + string2 + ")", n3) : new EvaluateResult(String.valueOf(string) + " = " + expression.getValueString(), n3);
        }
        catch (ParseException parseException) {
            return new EvaluateResult(parseException.getMessage());
        }
        catch (UnknownVariableException unknownVariableException) {
            if (context == EvaluateRequest.Context.HOVER) {
                return new EvaluateResult(string);
            }
            return new EvaluateResult(unknownVariableException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public dap.types.Breakpoint[] setExceptionBreakpoints(String[] var1_1) {
        if (DAPDebugger.debugger == null) {
            var2_2 = new dap.types.Breakpoint[var1_1.length];
            var3_4 = 0;
            while (var3_4 < var2_2.length) {
                var2_2[var3_4] = new dap.types.Breakpoint("Adapter not ready.", null, -1);
                ++var3_4;
            }
            return var2_2;
        }
        var2_3 = new dap.types.Breakpoint[var1_1.length];
        var3_5 = new boolean[DAPDebugger.debugger.getAllExceptionBreakpointDescriptions().length];
        var4_6 = DAPDebugger.debugger.getErrorBreakpointMapping();
        var5_7 = new int[var4_6.length];
        var6_8 = 0;
        while (var6_8 < var5_7.length) {
            var5_7[var6_8] = DAPDebugger.systemDebugger.getErrorCodes()[var4_6[var6_8]];
            ++var6_8;
        }
        var6_8 = var3_5.length - var5_7.length;
        var7_9 = 0;
        while (var7_9 < var1_1.length) {
            try {
                block9: {
                    var8_10 = Integer.parseInt(var1_1[var7_9].substring("Exception".length()));
                    if (var8_10 >= 0) break block9;
                    var3_5[var8_10 + var6_8] = true;
                    ** GOTO lbl36
                }
                var9_12 = 0;
                while (var9_12 < var5_7.length) {
                    if (var5_7[var9_12] == var8_10) break;
                    ++var9_12;
                }
                if (var9_12 >= var5_7.length) {
                    var2_3[var7_9] = new dap.types.Breakpoint(false);
                } else {
                    var3_5[var9_12 + var6_8] = true;
lbl36:
                    // 2 sources

                    var2_3[var7_9] = new dap.types.Breakpoint(true);
                }
            }
            catch (Exception var8_11) {
                var8_11.printStackTrace();
                var2_3[var7_9] = new dap.types.Breakpoint(false);
            }
            ++var7_9;
        }
        DAPDebugger.debugger.setExceptionBreakpointsSuspend(var3_5);
        return var2_3;
    }

    @Override
    public dap.types.Breakpoint[] setBreakpoints(Source source, SourceBreakpoint[] sourceBreakpointArray, int[] nArray, boolean bl) {
        dap.types.Breakpoint[] breakpointArray;
        File file;
        if (systemDebugger == null) {
            dap.types.Breakpoint[] breakpointArray2 = new dap.types.Breakpoint[sourceBreakpointArray.length];
            int n = 0;
            while (n < breakpointArray2.length) {
                breakpointArray2[n] = new dap.types.Breakpoint("Adapter not ready.", source, -1);
                ++n;
            }
            return breakpointArray2;
        }
        systemDebugger.clearBreakpoints();
        int n = source.getSourceReference();
        String string = n > 0 ? null : source.getPath();
        File file2 = file = string != null ? new File(string) : null;
        if (string != null) {
            this.sourceBreakpoints.put(string, sourceBreakpointArray);
            this.breakpointLines.put(string, nArray);
        } else {
            this.disassemblyBreakpoints = sourceBreakpointArray;
            this.disassemblyBreakpointLines = nArray;
        }
        if (sourceBreakpointArray != null) {
            int n2;
            SourceBreakpoint[] sourceBreakpointArray2;
            File file3;
            if (n > 0) {
                for (Map.Entry<String, SourceBreakpoint[]> entry : this.sourceBreakpoints.entrySet()) {
                    file3 = new File(entry.getKey());
                    sourceBreakpointArray2 = entry.getValue();
                    n2 = 0;
                    while (n2 < sourceBreakpointArray2.length) {
                        this.addBreakpoint(file3, sourceBreakpointArray2[n2]);
                        ++n2;
                    }
                }
            } else {
                int n3 = 0;
                while (n3 < this.disassemblyBreakpoints.length) {
                    this.addBreakpoint(null, this.disassemblyBreakpoints[n3]);
                    ++n3;
                }
                for (Map.Entry<String, SourceBreakpoint[]> entry : this.sourceBreakpoints.entrySet()) {
                    if (entry.getKey().equals(string)) continue;
                    file3 = new File(entry.getKey());
                    sourceBreakpointArray2 = entry.getValue();
                    n2 = 0;
                    while (n2 < sourceBreakpointArray2.length) {
                        this.addBreakpoint(file3, sourceBreakpointArray2[n2]);
                        ++n2;
                    }
                }
            }
            breakpointArray = new dap.types.Breakpoint[sourceBreakpointArray.length];
            int n4 = 0;
            while (n4 < breakpointArray.length) {
                breakpointArray[n4] = new dap.types.Breakpoint(this.addBreakpoint(file, sourceBreakpointArray[n4]), source, sourceBreakpointArray[n4].getLine());
                ++n4;
            }
        } else if (nArray != null) {
            int n5;
            int[] nArray2;
            File file4;
            if (n > 0) {
                for (Map.Entry<String, int[]> entry : this.breakpointLines.entrySet()) {
                    file4 = new File(entry.getKey());
                    nArray2 = entry.getValue();
                    n5 = 0;
                    while (n5 < nArray2.length) {
                        this.addBreakpoint(file4, nArray2[n5]);
                        ++n5;
                    }
                }
            } else {
                int n6 = 0;
                while (n6 < this.disassemblyBreakpointLines.length) {
                    this.addBreakpoint(null, this.disassemblyBreakpointLines[n6]);
                    ++n6;
                }
                for (Map.Entry<String, int[]> entry : this.breakpointLines.entrySet()) {
                    if (entry.getKey().equals(string)) continue;
                    file4 = new File(entry.getKey());
                    nArray2 = entry.getValue();
                    n5 = 0;
                    while (n5 < nArray2.length) {
                        this.addBreakpoint(file4, nArray2[n5]);
                        ++n5;
                    }
                }
            }
            breakpointArray = new dap.types.Breakpoint[nArray.length];
            int n7 = 0;
            while (n7 < breakpointArray.length) {
                breakpointArray[n7] = new dap.types.Breakpoint(this.addBreakpoint(file, nArray[n7]), source, nArray[n7]);
                ++n7;
            }
        } else {
            breakpointArray = NO_BREAKPOINTS;
        }
        return breakpointArray;
    }

    private String addBreakpoint(File file, SourceBreakpoint sourceBreakpoint) {
        return debugger.addBreakpoint(file, this.fromClientLine(sourceBreakpoint.getLine()), sourceBreakpoint.getCondition(), sourceBreakpoint.getLogMessage(), sourceBreakpoint.getLogMessage() == null);
    }

    private String addBreakpoint(File file, int n) {
        return debugger.addBreakpoint(file, this.fromClientLine(n));
    }

    @Override
    public void reset() {
    }

    @Override
    public void changeOccurred() {
        boolean bl = Debugger.isSuspended();
        if (bl && !this.wasSuspended) {
            if (this.cDebugging) {
                if (this.cStepOnceMore) {
                    this.cStepOnceMore = false;
                    if (!systemDebugger.isBreakpointHit()) {
                        systemDebugger.stepInto();
                        return;
                    }
                }
                if (this.cStepOutDepth > 0) {
                    Deque<Debugger.StackFrame> deque = this.getCurrentStackFrames();
                    if (deque.size() >= this.cStepOutDepth && deque.size() != this.cStepOutPrevDepth) {
                        this.cStepOutPrevDepth = deque.size();
                        systemDebugger.stepReturn();
                        return;
                    }
                    this.cStepOutDepth = 0;
                    this.cStepOutPrevDepth = 0;
                }
                if (debugger.getCurrentLineNumber() == this.cStepOverLine) {
                    systemDebugger.stepInto();
                    return;
                }
                if (this.cStepOver) {
                    this.cStepOver = false;
                    this.cStepOverLine = -1;
                    if (this.stepOutC(this.cGlobalsByAddress.get(systemDebugger.getAddress()))) {
                        return;
                    }
                }
            }
            if (systemDebugger.isExceptionHit()) {
                this.sendStoppedEventException(systemDebugger.getBreakpointMessage(), systemDebugger.getBreakpointMessage());
            } else {
                this.sendStoppedEvent(systemDebugger.isBreakpointHit() ? StoppedEvent.Reason.BREAKPOINT : (this.pausing ? StoppedEvent.Reason.PAUSE : StoppedEvent.Reason.STEP));
            }
            this.pausing = false;
        } else if (!bl && this.wasSuspended) {
            this.clearVariableReferences();
            this.sendContinuedEvent();
        }
        if (!this.cDebugging || debugger.getCurrentFile() != null || systemDebugger.isExceptionHit()) {
            this.wasSuspended = bl;
        }
    }

    @Override
    public void executingInstruction() {
    }

    @Override
    public void instructionExecuted() {
    }

    @Override
    public void memoryChanged(int n) {
    }

    @Override
    public void callExecuted(int n, int n2) {
    }

    @Override
    public void stackReadOccurred(int n) {
    }

    @Override
    public void stackWriteOccurred(int n, int n2) {
    }

    @Override
    public void interruptTaken(int n, int n2) {
    }

    @Override
    public void interruptExited(int n) {
    }

    @Override
    public void frameFinished() {
    }

    @Override
    public void messageReceived(String string) {
        this.sendOutputEvent(string);
    }

    @Override
    public void alert(String string) {
        this.sendOutputEvent("ALERT: " + string);
    }

    @Override
    public void breakpointHit(Breakpoint breakpoint, int n, int n2, String string) {
        this.sendOutputEvent(String.valueOf(systemDebugger.cpuAddressToString(n2).trim()) + ": " + string + "\n");
    }

    @Override
    public void breakpointHitCleared() {
    }

    @Override
    public void breakpointsCleared() {
    }

    @Override
    public void breakpointAdded(Breakpoint breakpoint) {
    }

    @Override
    public void breakpointChanged(Breakpoint breakpoint) {
    }

    @Override
    public void breakpointRemoved(Breakpoint breakpoint, int n, boolean bl) {
    }

    int createCStructuredVariableReference(CExpression cExpression, int n) {
        Integer n2 = this.cStructuredVariableReferences.get(cExpression);
        if (n2 != null) {
            this.cStructuredVariableStackFrameAddresses.put(n2, n);
            return n2;
        }
        int n3 = this.variableRefCounter++;
        this.cStructuredVariables.put(n3, cExpression);
        this.cStructuredVariableReferences.put(cExpression, n3);
        this.cStructuredVariableStackFrameAddresses.put(n3, n);
        return n3;
    }

    private int getStackFramePointerC(int n) {
        Debugger.StackFrame stackFrame = this.getStackFrame(n);
        if (stackFrame != null) {
            String string = stackFrame.getName();
            CSymbol cSymbol = this.cGlobals.get(!string.isEmpty() && string.charAt(0) == '_' ? string.substring(1) : string);
            if (cSymbol != null) {
                try {
                    if (debugger.isSDCCsaveFramePointer(DAPDebugger.mapCDBAddress(cSymbol))) {
                        return stackFrame.getBegin() - 2;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            }
            return stackFrame.getBegin();
        }
        return -1;
    }

    private int createCScopeReference(int n, String string) {
        Integer n2 = this.cStructuredVariableReferences.get(string);
        if (n2 != null) {
            return n2;
        }
        int n3 = this.variableRefCounter++;
        this.cScopes.put(n3, new CScope(string, this.getStackFramePointerC(n)));
        this.cScopeReferences.put(string, n3);
        return n3;
    }

    private void parseSymbolsFromCDBfile() {
        this.cGlobals.clear();
        this.cGlobalsByAddress.clear();
        this.cStructMembers.clear();
        this.cLocals.clear();
        this.cLevels.clear();
        File file = Debugger.findSourceFile(true);
        String string = file.getName();
        File file2 = new File(file.getParentFile(), String.valueOf(string.substring(0, string.lastIndexOf(46))) + ".cdb");
        if (!file2.exists()) {
            file2 = new File(new File(file2.getParentFile(), "build"), file2.getName());
        }
        if (!file2.exists()) {
            file2 = new File(Emulicious.getROMfile().getParentFile(), String.valueOf(Emulicious.getROMfile().getName().substring(0, Emulicious.getROMfile().getName().lastIndexOf(46))) + ".cdb");
        }
        try {
            String string2 = null;
            for (Record record : CDBParser.parse(file2)) {
                List<CSymbol> list;
                Object object;
                Record record2;
                if (record instanceof SymbolRecord) {
                    record2 = (SymbolRecord)record;
                    CSymbol cSymbol = new CSymbol((SymbolicRecord)record2);
                    String string3 = ((SymbolRecord)record2).getScope();
                    if (string3.charAt(0) == 'L') {
                        if (((SymbolRecord)record2).getName().matches("sloc\\d+") || ((SymbolRecord)record2).getName().matches("__\\d+") && ((SymbolRecord)record2).getName().length() == 12) continue;
                        object = string3.substring(1);
                        list = this.cLocals.get(object);
                        if (list == null) {
                            list = new ArrayList<CSymbol>();
                            this.cLocals.put((String)object, list);
                        }
                        list.add(cSymbol);
                        continue;
                    }
                    object = this.cGlobals.put(((SymbolRecord)record2).getName(), cSymbol);
                    if (object != null && ((SymbolRecord)record2).getTypeRecord().getSize() == 0) {
                        this.cGlobals.put(((SymbolRecord)record2).getName(), (CSymbol)object);
                    }
                    if (!(record instanceof FunctionRecord)) continue;
                    this.cFunctionModules.put(((SymbolRecord)record2).getName(), string2);
                    continue;
                }
                if (record instanceof LinkerSymbolRecord) {
                    record2 = (LinkerSymbolRecord)record;
                    String string4 = ((LinkerSymbolRecord)record2).getScope();
                    if (string4.charAt(0) == 'L') {
                        String string5 = string4.substring(1);
                        object = this.cLocals.get(string5);
                        if (object == null) continue;
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            list = (CSymbol)iterator.next();
                            if (!((LinkerSymbolRecord)record2).getName().equals(((CSymbol)((Object)list)).getName())) continue;
                            ((CSymbol)((Object)list)).setAddress(((LinkerSymbolRecord)record2).getAddress());
                        }
                        continue;
                    }
                    int n = DAPDebugger.mapCDBAddress((LinkerSymbolRecord)record2);
                    object = this.cGlobals.get(((LinkerSymbolRecord)record2).getName());
                    if (object != null) {
                        ((CSymbol)object).setAddress(((LinkerSymbolRecord)record2).getAddress());
                        this.cGlobalsByAddress.put(n, (CSymbol)object);
                        continue;
                    }
                    list = new CSymbol((SymbolicRecord)record2);
                    this.cGlobals.put(((LinkerSymbolRecord)record2).getName(), (CSymbol)((Object)list));
                    this.cGlobalsByAddress.put(n, (CSymbol)((Object)list));
                    continue;
                }
                if (record instanceof LinkerSymbolEndRecord) {
                    record2 = (LinkerSymbolEndRecord)record;
                    CSymbol cSymbol = this.cGlobals.get(((LinkerSymbolEndRecord)record2).getName());
                    if (cSymbol == null) continue;
                    cSymbol.setEnd(DAPDebugger.mapCDBAddress((LinkerSymbolEndRecord)record2));
                    continue;
                }
                if (record instanceof TypeRecord) {
                    record2 = (TypeRecord)record;
                    this.cStructMembers.put(((TypeRecord)record2).getName(), ((TypeRecord)record2).getMembers());
                    continue;
                }
                if (record instanceof LinkerCRecord) {
                    record2 = (LinkerCRecord)record;
                    int n = DAPDebugger.mapCDBAddress(((LinkerCRecord)record2).getEndAddress(), null);
                    this.cLevels.put(n, String.valueOf(((LinkerCRecord)record2).getLevel()) + "$" + ((LinkerCRecord)record2).getBlock());
                    continue;
                }
                if (!(record instanceof ModuleRecord)) continue;
                record2 = (ModuleRecord)record;
                string2 = ((ModuleRecord)record2).getFilename();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static int mapCDBAddress(CSymbol cSymbol) {
        SymbolicRecord symbolicRecord = cSymbol.getRecord();
        if (symbolicRecord instanceof LinkerSymbolRecord) {
            return DAPDebugger.mapCDBAddress((LinkerSymbolRecord)symbolicRecord);
        }
        if (symbolicRecord instanceof LinkerSymbolEndRecord) {
            return DAPDebugger.mapCDBAddress((LinkerSymbolEndRecord)symbolicRecord);
        }
        return DAPDebugger.mapCDBAddress(cSymbol.getAddress(), "_" + symbolicRecord.getName());
    }

    private static int mapCDBAddress(LinkerSymbolRecord linkerSymbolRecord) {
        return DAPDebugger.mapCDBAddress(linkerSymbolRecord.getAddress(), String.valueOf(linkerSymbolRecord.getScope()) + "$" + linkerSymbolRecord.getName() + "$" + linkerSymbolRecord.getLevel() + "$" + linkerSymbolRecord.getBlock());
    }

    private static int mapCDBAddress(LinkerSymbolEndRecord linkerSymbolEndRecord) {
        return DAPDebugger.mapCDBAddress(linkerSymbolEndRecord.getAddress(), "X" + linkerSymbolEndRecord.getScope() + "$" + linkerSymbolEndRecord.getName() + "$" + linkerSymbolEndRecord.getLevel() + "$" + linkerSymbolEndRecord.getBlock());
    }

    private static int mapCDBAddress(int n, String string) {
        if ((n & 0xFFFF) >= 49152) {
            return n;
        }
        List<Symbols.Symbol> list = debugger.getSymbols().get(string);
        if (list != null && !list.isEmpty()) {
            return Z80Disassembler.mapAddress(list.get(0).getAddress(), list.get(0).getBank());
        }
        return Z80Disassembler.mapAddress(n & 0xFFFF, n / 65536);
    }

    private void stepOverC() {
        this.cStepOver = true;
        this.cStepOverLine = debugger.getCurrentLineNumber();
        systemDebugger.stepInto();
    }

    private void stepOutC() {
        Deque<Debugger.StackFrame> deque = this.getCurrentStackFrames();
        if (deque.size() <= 1) {
            this.stepOverC();
            return;
        }
        this.cStepOutDepth = deque.size();
        Debugger.StackFrame stackFrame = deque.getLast();
        String string = stackFrame.getName();
        if (!string.isEmpty() && string.charAt(0) == '_') {
            CSymbol cSymbol = this.cGlobals.get(string.substring(1));
            if (cSymbol != null) {
                if (!this.stepOutC(cSymbol)) {
                    this.stepOverC();
                }
            } else {
                systemDebugger.stepReturn();
            }
        } else {
            this.stepOverC();
        }
    }

    private boolean stepOutC(CSymbol cSymbol) {
        if (cSymbol != null && !"main".equals(cSymbol.getName())) {
            if (systemDebugger.getAddress() >= cSymbol.getAddress() && systemDebugger.getAddress() < cSymbol.getEnd()) {
                this.cStepOnceMore = true;
                systemDebugger.runToAddress(cSymbol.getEnd(), true);
            } else {
                systemDebugger.stepReturn();
            }
            return true;
        }
        return false;
    }

    private Scope[] getScopesC(int n) {
        Variables variables;
        ArrayList<Scope> arrayList = new ArrayList<Scope>();
        String string = this.getFrameScopeC(n);
        if (string != null) {
            arrayList.add(new Scope("Locals", Scope.PresentationHint.LOCALS, this.createCScopeReference(n, string), false));
        }
        if ((variables = systemDebugger.getSystemVariables()) != null) {
            int n2 = 0;
            String[] stringArray = variables.getScopes();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string2 = stringArray[n4];
                if (!"Registers".equals(string2)) {
                    arrayList.add(new Scope(string2, Scope.PresentationHint.GLOBALS, this.createSystemVariablesReference(variables.getVariables(n2)), false));
                }
                ++n2;
                ++n4;
            }
        }
        return arrayList.toArray(new Scope[arrayList.size()]);
    }

    private String getFrameScopeC(int n) {
        int n2;
        String string;
        Debugger.StackFrame stackFrame = this.getStackFrame(n);
        String string2 = this.getStackFrameDisplayName(stackFrame);
        if (string2 == null) {
            return null;
        }
        File file = stackFrame.getFile();
        if (file == null) {
            return null;
        }
        int n3 = string2.indexOf(40);
        String string3 = this.cLevels.get(stackFrame.getAddress());
        String string4 = DAPDebugger.extractNameFromCDBline(stackFrame.getName());
        if (!string4.isEmpty() && string4.charAt(0) == '_') {
            string4 = string4.substring(1);
        }
        if ((string = this.cFunctionModules.get(string4)) == null && (n2 = file.getName().lastIndexOf(46)) >= 0) {
            string = file.getName().substring(0, n2);
        }
        return n3 >= 0 ? String.valueOf(string) + "." + string2.substring(0, n3) + (string3 != null ? "." + string3 : "") : null;
    }

    private dap.types.Variable[] getVariablesC(int n, VariablesRequest.Filter filter, int n2, int n3, ValueFormat valueFormat) {
        dap.types.Variable[] variableArray;
        Variable[] variableArray2;
        try {
            variableArray2 = this.cScopes.get(n);
            if (variableArray2 != null) {
                List<CSymbol> list = variableArray2.getLocals();
                if (list != null) {
                    int n4;
                    Object object;
                    HashMap<Object, ArrayList<CSymbol>> hashMap = new HashMap<Object, ArrayList<CSymbol>>();
                    for (CSymbol object22 : list) {
                        String[] stringArray = ((SymbolRecord)object22.getRecord()).getRegisters();
                        if (stringArray == null) continue;
                        object = stringArray;
                        n4 = stringArray.length;
                        int exception = 0;
                        while (exception < n4) {
                            String string = object[exception];
                            ArrayList<CSymbol> arrayList = (ArrayList<CSymbol>)hashMap.get(string);
                            if (arrayList == null) {
                                arrayList = new ArrayList<CSymbol>();
                                hashMap.put(string, arrayList);
                            }
                            arrayList.add(object22);
                            ++exception;
                        }
                    }
                    HashSet hashSet = new HashSet();
                    ArrayList arrayList = new ArrayList();
                    for (CSymbol cSymbol : list) {
                        try {
                            String[] stringArray = ((SymbolRecord)cSymbol.getRecord()).getRegisters();
                            n4 = hashSet.contains(cSymbol) ? 1 : 0;
                            if (n4 == 0 && stringArray != null) {
                                String[] stringArray2 = stringArray;
                                int n5 = stringArray.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    object = stringArray2[n6];
                                    List list2 = (List)hashMap.get(object);
                                    if (list2.size() > 1) {
                                        hashSet.addAll(list2);
                                        arrayList.add(new CVariable(cSymbol, list2.toString(), true).getVariable(variableArray2.getStackFrameAddress()));
                                        n4 = 1;
                                        break;
                                    }
                                    ++n6;
                                }
                            }
                            if (n4 != 0) continue;
                            arrayList.add(new CVariable(cSymbol).getVariable(variableArray2.getStackFrameAddress()));
                        }
                        catch (Exception exception) {
                            arrayList.add(new dap.types.Variable(cSymbol.getName(), "Failed to evaluate: " + exception.getMessage()));
                        }
                    }
                    return arrayList.toArray(new dap.types.Variable[arrayList.size()]);
                }
                return NO_VARIABLES;
            }
            variableArray = this.cStructuredVariables.get(n);
            if (variableArray != null) {
                return variableArray.getVariables(this.cStructuredVariableStackFrameAddresses.get(n));
            }
        }
        catch (CExpressionException cExpressionException) {
            cExpressionException.printStackTrace();
        }
        variableArray2 = this.systemVariablesBackReferences.get(n);
        if (variableArray2 != null) {
            variableArray = new dap.types.Variable[variableArray2.length];
            int n8 = 0;
            while (n8 < variableArray.length) {
                variableArray[n8] = this.toVariable(variableArray2[n8]);
                ++n8;
            }
            return variableArray;
        }
        return NO_VARIABLES;
    }

    private EvaluateResult evaluateC(String string, int n, EvaluateRequest.Context context, ValueFormat valueFormat) {
        if (context == EvaluateRequest.Context.HOVER && !string.isEmpty() && string.charAt(0) == '&') {
            string = string.substring(1);
        }
        try {
            return new EvaluateResult(this.cExpressionFrom(string, n).getVariable(this.getStackFramePointerC(n)));
        }
        catch (CExpressionException cExpressionException) {
            return new EvaluateResult(cExpressionException.getMessage());
        }
    }

    private CSymbol cSymbolForName(String string, int n) {
        List<CSymbol> list;
        Object object;
        String string2 = this.getFrameScopeC(n);
        if (string2 == null) {
            return this.cGlobals.get(string);
        }
        int n2 = string2.lastIndexOf(46);
        String string3 = string2;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        try {
            int n6 = string2.indexOf(36);
            object = n6 >= 0 ? string2.substring(n2 + 1, n6) : string2.substring(n2 + 1);
            int n7 = ((String)object).indexOf(95);
            if (n7 >= 0) {
                n3 = Integer.parseInt(((String)object).substring(0, n7));
                n4 = Integer.parseInt(((String)object).substring(n7 + 1));
            } else {
                n3 = Integer.parseInt((String)object);
            }
            string3 = string2.substring(0, n2);
            if (n6 >= 0) {
                n5 = Integer.parseInt(string2.substring(n6 + 1));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((list = this.cLocals.get(string3)) != null) {
            object = null;
            for (CSymbol cSymbol : list) {
                if (n3 <= cSymbol.getLevel() && (n3 != cSymbol.getLevel() || n4 <= cSymbol.getSubLevel() && (n4 != cSymbol.getSubLevel() || n5 < cSymbol.getBlock())) || !cSymbol.getName().equals(string) || object != null && cSymbol.getLevel() <= ((CSymbol)object).getLevel()) continue;
                object = cSymbol;
            }
            if (object != null) {
                return object;
            }
        }
        return this.cGlobals.get(string);
    }

    private CExpression cExpressionFrom(String string, int n) throws CExpressionException {
        String[] stringArray = DAPDebugger.tokenizeCExpression(string);
        CSymbol cSymbol = this.cSymbolForName(stringArray[0], n);
        if (cSymbol == null || !cSymbol.hasSymbol()) {
            throw new CExpressionException("Unknown symbol: " + stringArray[0]);
        }
        CExpression cExpression = new CVariable(cSymbol);
        int n2 = 1;
        while (n2 < stringArray.length) {
            if (stringArray[n2].charAt(0) == '[') {
                int n3 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length() - 1));
                cExpression = new CArrayElement(cExpression, n3);
            } else {
                switch (stringArray[n2 - 1].charAt(0)) {
                    case '.': {
                        cExpression = new CStructField(cExpression, stringArray[n2], false);
                        break;
                    }
                    case '-': {
                        cExpression = new CStructField(cExpression, stringArray[n2], true);
                    }
                }
            }
            ++n2;
        }
        return cExpression;
    }

    private static String[] tokenizeCExpression(String string) throws CExpressionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (c) {
                case '[': {
                    if (n < n2) {
                        arrayList.add(string.substring(n, n2));
                    }
                    n = n2;
                    while (n2 < string.length() && string.charAt(n2) != ']') {
                        ++n2;
                    }
                    if (n2 >= string.length()) {
                        throw new CExpressionException("Missing closing square bracket");
                    }
                    arrayList.add(string.substring(n, n2 + 1));
                    n = n2 + 1;
                    break;
                }
                case '.': {
                    if (n < n2) {
                        arrayList.add(string.substring(n, n2));
                    }
                    arrayList.add(".");
                    n = n2 + 1;
                    break;
                }
                case '-': {
                    if (n2 + 1 >= string.length() || string.charAt(n2 + 1) != '>') break;
                    if (n < n2) {
                        arrayList.add(string.substring(n, n2));
                    }
                    arrayList.add("->");
                    n = ++n2 + 1;
                    break;
                }
                default: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    throw new CExpressionException("Illegal character encountered: " + c);
                }
            }
            ++n2;
        }
        if (n < string.length()) {
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    class CArrayElement
    extends CExpression {
        private final CExpression array;
        private final TypeChainRecord elementType;
        private final int index;

        public CArrayElement(CExpression cExpression, int n) {
            this.array = cExpression;
            this.elementType = cExpression.getType().getElementType();
            this.index = n;
        }

        @Override
        int getValue(int n) throws CExpressionException {
            int n2 = this.array.getValue(n);
            if (n2 == 0) {
                throw new CExpressionException("The value of '" + this.array + "' is NULL");
            }
            return n2 + this.index * this.elementType.getSize();
        }

        @Override
        TypeChainRecord getType() {
            return this.elementType;
        }

        public int hashCode() {
            return this.array.hashCode() * 31 + this.index;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CArrayElement cArrayElement = (CArrayElement)object;
            return this.array.equals(cArrayElement.array) && this.index == cArrayElement.index;
        }

        public String toString() {
            return String.valueOf(this.array.toString()) + "[" + this.index + "]";
        }
    }

    abstract class CExpression {
        CExpression() {
        }

        abstract int getValue(int var1) throws CExpressionException;

        abstract TypeChainRecord getType();

        public String getValueString(int n) throws CExpressionException {
            TypeChainRecord typeChainRecord = this.getType();
            if (typeChainRecord.isStruct()) {
                return typeChainRecord.getName();
            }
            if (typeChainRecord.isArray()) {
                return typeChainRecord.arrayDimensionsToString();
            }
            int n2 = this.getValue(n);
            int n3 = typeChainRecord.getElementSize();
            try {
                if (n3 == 4) {
                    int n4 = debugger.parseExpression("dword @@($" + Integer.toHexString(n2) + ")").getValue();
                    if (typeChainRecord.isCodePointer()) {
                        CSymbol cSymbol = DAPDebugger.this.cGlobalsByAddress.get(n4);
                        if (cSymbol != null) {
                            return String.valueOf(cSymbol.getName()) + "()";
                        }
                        return n4 == 0 ? "NULL" : String.format("$%08X", n4);
                    }
                    if (typeChainRecord.isPointer()) {
                        return n4 == 0 ? "NULL" : String.format("$%08X", n4);
                    }
                    if (typeChainRecord.isSigned() && (n4 & Integer.MIN_VALUE) != 0) {
                        return Integer.toString(n4);
                    }
                    return Long.toString((long)n4 & 0xFFFFFFFFL);
                }
                if (n3 == 2) {
                    int n5 = debugger.parseExpression("word @@($" + Integer.toHexString(n2) + ")").getValue();
                    if (typeChainRecord.isCodePointer()) {
                        CSymbol cSymbol = DAPDebugger.this.cGlobalsByAddress.get(n5);
                        if (cSymbol != null) {
                            return String.valueOf(cSymbol.getName()) + "()";
                        }
                        return n5 == 0 ? "NULL" : String.format("$%04X", n5);
                    }
                    if (typeChainRecord.isPointer()) {
                        return n5 == 0 ? "NULL" : String.format("$%04X", n5);
                    }
                    if (typeChainRecord.isSigned() && (n5 & 0x8000) != 0) {
                        return Short.toString((short)n5);
                    }
                    return Integer.toString(n5);
                }
                int n6 = debugger.parseExpression("@($" + Integer.toHexString(n2) + ")").getValue();
                if (typeChainRecord.isSigned() && (n6 & 0x80) != 0) {
                    return Byte.toString((byte)n6);
                }
                return Integer.toString(n6);
            }
            catch (UnknownVariableException unknownVariableException) {
                throw new CExpressionException(unknownVariableException);
            }
            catch (ParseException parseException) {
                throw new CExpressionException(parseException);
            }
        }

        protected int getPointerValue(int n) throws CExpressionException {
            try {
                return debugger.parseExpression("word @@(" + this.getValue(n) + ")").getValue();
            }
            catch (UnknownVariableException unknownVariableException) {
                throw new CExpressionException(unknownVariableException);
            }
            catch (ParseException parseException) {
                throw new CExpressionException(parseException);
            }
        }

        public dap.types.Variable getVariable(int n) throws CExpressionException {
            return this.getVariable(n, null);
        }

        protected dap.types.Variable getVariable(int n, String string) throws CExpressionException {
            String string2 = this.toString();
            if (this.getType().isPointer() && this.getPointerValue(n) == 0) {
                return new dap.types.Variable(string != null ? string : string2, "NULL");
            }
            return new dap.types.Variable(string != null ? string : string2, this.getValueString(n), this.typeToString(), string2, this.getType().isArray() || this.getType().isStruct() ? DAPDebugger.this.createCStructuredVariableReference(this, n) : 0);
        }

        protected String typeToString() {
            return this.getType().toString();
        }

        public dap.types.Variable[] getVariables(int n) throws CExpressionException {
            TypeChainRecord typeChainRecord = this.getType();
            if (typeChainRecord.isPointer() && this.getPointerValue(n) == 0) {
                return NO_VARIABLES;
            }
            if (typeChainRecord.isArray()) {
                dap.types.Variable[] variableArray = new dap.types.Variable[typeChainRecord.getNumberOfElements()];
                int n2 = 0;
                while (n2 < variableArray.length) {
                    variableArray[n2] = new CArrayElement(this, n2).getVariable(n, " [" + n2 + "]");
                    ++n2;
                }
                return variableArray;
            }
            if (typeChainRecord.isStruct()) {
                String string = typeChainRecord.getName();
                if (!string.isEmpty() && string.charAt(string.length() - 1) == '*') {
                    string = string.substring(0, string.length() - 1);
                }
                List<TypeRecord.TypeMember> list = DAPDebugger.this.cStructMembers.get(string);
                dap.types.Variable[] variableArray = new dap.types.Variable[list.size()];
                int n3 = 0;
                while (n3 < variableArray.length) {
                    variableArray[n3] = new CStructField(this, list.get(n3).getRecord().getName(), typeChainRecord.isPointer()).getVariable(n, list.get(n3).getRecord().getName());
                    ++n3;
                }
                return variableArray;
            }
            throw new CExpressionException("getVariables should only be called for arrays and structs");
        }
    }

    static class CExpressionException
    extends Exception {
        public CExpressionException(String string) {
            super(string);
        }

        public CExpressionException(Throwable throwable) {
            super(throwable);
        }
    }

    class CScope {
        private final String name;
        private final int level;
        private final int subLevel;
        private final int block;
        private final int stackFrameAddress;

        public CScope(String string, int n) {
            int n2 = string.lastIndexOf(46);
            String string2 = string;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            try {
                int n6 = string.indexOf(36);
                String string3 = n6 >= 0 ? string.substring(n2 + 1, n6) : string.substring(n2 + 1);
                int n7 = string3.indexOf(95);
                if (n7 >= 0) {
                    n3 = Integer.parseInt(string3.substring(0, n7));
                    n4 = Integer.parseInt(string3.substring(n7 + 1));
                } else {
                    n3 = Integer.parseInt(string3);
                }
                string2 = string.substring(0, n2);
                if (n6 >= 0) {
                    n5 = Integer.parseInt(string.substring(n6 + 1));
                }
            }
            catch (NumberFormatException numberFormatException) {}
            this.name = string2;
            this.level = n3;
            this.subLevel = n4;
            this.block = n5;
            this.stackFrameAddress = n;
        }

        public String getName() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public int getSubLevel() {
            return this.subLevel;
        }

        public int getBlock() {
            return this.block;
        }

        public int getStackFrameAddress() {
            return this.stackFrameAddress;
        }

        public List<CSymbol> getLocals() {
            List<CSymbol> list = DAPDebugger.this.cLocals.get(this.getName());
            if (list == null) {
                return null;
            }
            ArrayList<CSymbol> arrayList = new ArrayList<CSymbol>();
            for (CSymbol cSymbol : list) {
                if (this.getLevel() <= cSymbol.getLevel() && (this.getLevel() != cSymbol.getLevel() || this.getSubLevel() <= cSymbol.getSubLevel() && (this.getSubLevel() != cSymbol.getSubLevel() || this.getBlock() < cSymbol.getBlock()))) continue;
                int n = -1;
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    if (cSymbol.getName().equals(((CSymbol)arrayList.get(n2)).getName())) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                if (n >= 0) {
                    if (cSymbol.getLevel() <= ((CSymbol)arrayList.get(n)).getLevel()) continue;
                    arrayList.set(n, cSymbol);
                    continue;
                }
                arrayList.add(cSymbol);
            }
            return arrayList;
        }

        public String toString() {
            return this.getLevel() < Integer.MAX_VALUE ? String.valueOf(this.getName()) + "." + this.getLevel() + (this.getSubLevel() < Integer.MAX_VALUE ? "_" + this.getSubLevel() : "") + (this.getBlock() < Integer.MAX_VALUE ? "$" + this.getBlock() : "") : this.getName();
        }
    }

    class CStructField
    extends CExpression {
        private final CExpression struct;
        private final TypeRecord.TypeMember field;
        private final boolean dereference;

        public CStructField(CExpression cExpression, String string, boolean bl) throws CExpressionException {
            List<TypeRecord.TypeMember> list;
            this.struct = cExpression;
            TypeRecord.TypeMember typeMember = null;
            String string2 = cExpression.getType().getName();
            if (!string2.isEmpty() && string2.charAt(string2.length() - 1) == '*') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if ((list = DAPDebugger.this.cStructMembers.get(string2)) == null) {
                throw new CExpressionException("Unknown struct type: " + string2);
            }
            for (TypeRecord.TypeMember typeMember2 : list) {
                if (!typeMember2.getRecord().getName().equals(string)) continue;
                typeMember = typeMember2;
                break;
            }
            if (typeMember == null) {
                throw new CExpressionException("Field '" + string + "' is not a field of " + string2);
            }
            this.field = typeMember;
            this.dereference = bl;
        }

        @Override
        int getValue(int n) throws CExpressionException {
            int n2;
            int n3 = n2 = this.dereference ? this.struct.getPointerValue(n) : this.struct.getValue(n);
            if (n2 == 0) {
                throw new CExpressionException("The value of '" + this.struct + "' is NULL");
            }
            return n2 + this.field.getOffset();
        }

        @Override
        TypeChainRecord getType() {
            return this.field.getRecord().getTypeRecord();
        }

        public int hashCode() {
            return (this.struct.hashCode() * 31 + (this.dereference ? 1231 : 1237)) * 31 + this.field.getRecord().getName().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CStructField cStructField = (CStructField)object;
            return this.dereference == cStructField.dereference && this.struct.equals(cStructField.struct) && this.field.getRecord().getName().equals(cStructField.field.getRecord().getName());
        }

        public String toString() {
            return String.valueOf(this.struct.toString()) + (this.dereference ? "->" : ".") + this.field.getRecord().getName();
        }
    }

    static class CSymbol {
        private final SymbolicRecord record;
        private int address;
        private int end = -1;

        public CSymbol(SymbolicRecord symbolicRecord) {
            this.record = symbolicRecord;
            if (symbolicRecord instanceof LinkerSymbolRecord) {
                this.address = ((LinkerSymbolRecord)symbolicRecord).getAddress();
            }
        }

        public int getAddress() {
            return this.address;
        }

        public void setAddress(int n) {
            this.address = n;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n) {
            this.end = n;
        }

        public String getName() {
            return this.record.getName();
        }

        public String getScope() {
            return this.record.getScope();
        }

        public int getLevel() {
            String string = this.getRecord().getLevel();
            int n = string.indexOf(95);
            return Integer.parseInt(n >= 0 ? string.substring(0, n) : string);
        }

        public int getSubLevel() {
            String string = this.getRecord().getLevel();
            int n = string.indexOf(95);
            return Integer.parseInt(string.substring(n + 1));
        }

        public int getBlock() {
            return this.getRecord().getBlock();
        }

        public boolean hasSymbol() {
            return this.getRecord() instanceof SymbolRecord;
        }

        public SymbolicRecord getRecord() {
            return this.record;
        }

        public int hashCode() {
            return this.getName().hashCode() * 31 + this.getScope().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CSymbol cSymbol = (CSymbol)object;
            return cSymbol.getName().equals(this.getName()) && cSymbol.getScope().equals(this.getScope());
        }

        public String toString() {
            return this.getName();
        }
    }

    class CVariable
    extends CExpression {
        private final CSymbol symbol;
        private final String displayName;
        private final boolean sharedLocation;

        public CVariable(CSymbol cSymbol) {
            this(cSymbol, null, false);
        }

        public CVariable(CSymbol cSymbol, String string, boolean bl) {
            if (!cSymbol.hasSymbol()) {
                throw new IllegalArgumentException("Symbol '" + cSymbol.getName() + "' has no symbol record. Variables require a symbol record.");
            }
            this.symbol = cSymbol;
            this.displayName = string;
            this.sharedLocation = bl;
        }

        @Override
        int getValue(int n) throws CExpressionException {
            SymbolRecord symbolRecord = (SymbolRecord)this.symbol.getRecord();
            if (symbolRecord.getRegisters() != null) {
                throw new CExpressionException(symbolRecord.getRegisters().length > 0 ? "Variable is in register " + symbolRecord.getRegisters()[0] : "Eliminated by Optimization");
            }
            if (symbolRecord.isOnStack()) {
                return n + symbolRecord.getStack();
            }
            return this.symbol.getAddress();
        }

        @Override
        protected int getPointerValue(int n) throws CExpressionException {
            SymbolRecord symbolRecord = (SymbolRecord)this.symbol.getRecord();
            String[] stringArray = symbolRecord.getRegisters();
            if (stringArray != null && stringArray.length == 2) {
                try {
                    return debugger.parseExpression(String.valueOf(stringArray[1]) + " << 8 | " + stringArray[0]).getValue();
                }
                catch (UnknownVariableException unknownVariableException) {
                    throw new CExpressionException(unknownVariableException);
                }
                catch (ParseException parseException) {
                    throw new CExpressionException(parseException);
                }
            }
            return super.getPointerValue(n);
        }

        @Override
        TypeChainRecord getType() {
            return ((SymbolRecord)this.symbol.getRecord()).getTypeRecord();
        }

        @Override
        public String getValueString(int n) throws CExpressionException {
            SymbolRecord symbolRecord = (SymbolRecord)this.symbol.getRecord();
            String[] stringArray = symbolRecord.getRegisters();
            if (stringArray != null) {
                if (stringArray.length == 0) {
                    return "Eliminated by Optimization";
                }
                try {
                    if (stringArray.length == 2) {
                        int n2 = debugger.parseExpression(String.valueOf(stringArray[1]) + " << 8 | " + stringArray[0]).getValue();
                        TypeChainRecord typeChainRecord = this.getType();
                        if (typeChainRecord.isArray() || typeChainRecord.isStruct()) {
                            return super.getValueString(n);
                        }
                        if (typeChainRecord.isCodePointer()) {
                            CSymbol cSymbol = DAPDebugger.this.cGlobalsByAddress.get(n2);
                            if (cSymbol != null) {
                                return String.valueOf(cSymbol.getName()) + "()";
                            }
                            return n2 == 0 ? "NULL" : String.format("$%04X", n2);
                        }
                        if (typeChainRecord.isPointer()) {
                            return n2 == 0 ? "NULL" : String.format("$%04X", n2);
                        }
                        if (typeChainRecord.isSigned() && (n2 & 0x8000) != 0) {
                            return String.valueOf(Short.toString((short)n2)) + " (value in register)";
                        }
                        return String.valueOf(Integer.toString(n2)) + " (value in register)";
                    }
                    int n3 = debugger.parseExpression(stringArray[0]).getValue();
                    if (this.getType().isSigned() && (n3 & 0x80) != 0) {
                        return String.valueOf(Byte.toString((byte)n3)) + " (value in register)";
                    }
                    return String.valueOf(Integer.toString(n3)) + " (value in register)";
                }
                catch (UnknownVariableException unknownVariableException) {
                    throw new CExpressionException(unknownVariableException);
                }
                catch (ParseException parseException) {
                    throw new CExpressionException(parseException);
                }
            }
            return super.getValueString(n);
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CVariable cVariable = (CVariable)object;
            return this.symbol.equals(cVariable.symbol);
        }

        @Override
        protected String typeToString() {
            return this.sharedLocation ? String.valueOf(super.typeToString()) + " (sharing same location)" : super.typeToString();
        }

        public String toString() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return this.symbol.toString();
        }
    }
}

