/*
 * Decompiled with CFR 0.152.
 */
package msx;

import components.cartridge.MSXCartridge;
import msx.MSXDevice;
import system.MSX;

public class ExpandedSlot
implements MSXDevice {
    private static final MSXDevice[] NO_DEVICES = new MSXDevice[]{new NoDevice()};
    public static final ExpandedSlot EMPTY = new ExpandedSlot(new MSXDevice[0]);
    private final MSXDevice[] devices;
    private int secondarySlotRegister;

    public ExpandedSlot(MSXDevice ... mSXDeviceArray) {
        this.devices = mSXDeviceArray.length == 0 ? NO_DEVICES : mSXDeviceArray;
        int n = 0;
        while (n < this.devices.length) {
            if (this.devices[n] == null) {
                this.devices[n] = NO_DEVICES[0];
            }
            ++n;
        }
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        if (n == 65535) {
            this.secondarySlotRegister = n2;
        } else {
            this.getDevice(n).writeByte(n, n2, n3);
        }
    }

    @Override
    public int readByte(int n, int n2) {
        if (n == 65535) {
            return this.secondarySlotRegister ^ 0xFF;
        }
        return this.getDevice(n).readByte(n, n2);
    }

    @Override
    public int getByte(int n) {
        if (n == 65535) {
            return this.secondarySlotRegister ^ 0xFF;
        }
        return this.getDevice(n).getByte(n);
    }

    public boolean isROMaddress(int n) {
        if (n < 0 || n > 65535) {
            return false;
        }
        MSXDevice mSXDevice = this.getDevice(n);
        if (!(mSXDevice instanceof MSXCartridge)) {
            return false;
        }
        MSXCartridge mSXCartridge = (MSXCartridge)mSXDevice;
        return mSXCartridge.isROMaddress(n);
    }

    public boolean isRAMaddress(int n) {
        return n >= 0 && n <= 65535 && this.getDevice(n) instanceof MSX.RamMapper;
    }

    public boolean isSRAMaddress(int n) {
        if (n < 0 || n > 65535) {
            return false;
        }
        MSXDevice mSXDevice = this.getDevice(n);
        if (!(mSXDevice instanceof MSXCartridge)) {
            return false;
        }
        MSXCartridge mSXCartridge = (MSXCartridge)mSXDevice;
        return mSXCartridge.isSRAMaddress(n);
    }

    public int getSlot(int n) {
        return Math.min(this.devices.length - 1, this.secondarySlotRegister >> n * 2 & 3);
    }

    public MSXDevice getDevice(int n) {
        return this.devices[this.getSlot(n >> 14)];
    }

    public void printSecondarySlots() {
        System.out.println("Seconday slots: " + this.getSlot(0) + " " + this.getSlot(1) + " " + this.getSlot(2) + " " + this.getSlot(3));
    }

    @Override
    public void reset() {
        this.secondarySlotRegister = 0;
        MSXDevice[] mSXDeviceArray = this.devices;
        int n = this.devices.length;
        int n2 = 0;
        while (n2 < n) {
            MSXDevice mSXDevice = mSXDeviceArray[n2];
            mSXDevice.reset();
            ++n2;
        }
    }

    static final class NoDevice
    implements MSXDevice {
        NoDevice() {
        }

        @Override
        public int readByte(int n, int n2) {
            return 255;
        }

        @Override
        public int getByte(int n) {
            return this.readByte(n, 0);
        }

        @Override
        public void writeByte(int n, int n2, int n3) {
        }

        @Override
        public void reset() {
        }
    }
}

