/*
 * Decompiled with CFR 0.152.
 */
package dap.messages;

import dap.messages.ProtocolMessage;
import dap.messages.requests.AttachRequest;
import dap.messages.requests.ContinueRequest;
import dap.messages.requests.DisconnectRequest;
import dap.messages.requests.EvaluateRequest;
import dap.messages.requests.GoToRequest;
import dap.messages.requests.InitializeRequest;
import dap.messages.requests.LaunchRequest;
import dap.messages.requests.NextRequest;
import dap.messages.requests.PauseRequest;
import dap.messages.requests.RestartFrameRequest;
import dap.messages.requests.ReverseContinueRequest;
import dap.messages.requests.ScopesRequest;
import dap.messages.requests.SetBreakpointsRequest;
import dap.messages.requests.SetExceptionBreakpoints;
import dap.messages.requests.SourceRequest;
import dap.messages.requests.StackTraceRequest;
import dap.messages.requests.StepBackRequest;
import dap.messages.requests.StepInRequest;
import dap.messages.requests.StepOutRequest;
import dap.messages.requests.ThreadsRequest;
import dap.messages.requests.VariablesRequest;
import json.JSONObject;

public abstract class Request
extends ProtocolMessage {
    private final String command;
    private final JSONObject arguments;

    @Override
    public String getType() {
        return "request";
    }

    public Request(JSONObject jSONObject) {
        super(jSONObject);
        this.command = jSONObject.getString("command");
        this.arguments = jSONObject.getObjectOptional("arguments");
    }

    protected JSONObject getArguments() {
        return this.arguments;
    }

    public String getCommand() {
        return this.command;
    }

    protected static Request from(JSONObject jSONObject) {
        String string = jSONObject.getString("command");
        if ("initialize".equals(string)) {
            return new InitializeRequest(jSONObject);
        }
        if ("launch".equals(string)) {
            return new LaunchRequest(jSONObject);
        }
        if ("attach".equals(string)) {
            return new AttachRequest(jSONObject);
        }
        if ("disconnect".equals(string)) {
            return new DisconnectRequest(jSONObject);
        }
        if ("setBreakpoints".equals(string)) {
            return new SetBreakpointsRequest(jSONObject);
        }
        if ("setExceptionBreakpoints".equals(string)) {
            return new SetExceptionBreakpoints(jSONObject);
        }
        if ("continue".equals(string)) {
            return new ContinueRequest(jSONObject);
        }
        if ("next".equals(string)) {
            return new NextRequest(jSONObject);
        }
        if ("stepIn".equals(string)) {
            return new StepInRequest(jSONObject);
        }
        if ("stepOut".equals(string)) {
            return new StepOutRequest(jSONObject);
        }
        if ("stepBack".equals(string)) {
            return new StepBackRequest(jSONObject);
        }
        if ("reverseContinue".equals(string)) {
            return new ReverseContinueRequest(jSONObject);
        }
        if ("restartFrame".equals(string)) {
            return new RestartFrameRequest(jSONObject);
        }
        if ("goto".equals(string)) {
            return new GoToRequest(jSONObject);
        }
        if ("pause".equals(string)) {
            return new PauseRequest(jSONObject);
        }
        if ("stackTrace".equals(string)) {
            return new StackTraceRequest(jSONObject);
        }
        if ("scopes".equals(string)) {
            return new ScopesRequest(jSONObject);
        }
        if ("variables".equals(string)) {
            return new VariablesRequest(jSONObject);
        }
        if ("source".equals(string)) {
            return new SourceRequest(jSONObject);
        }
        if ("threads".equals(string)) {
            return new ThreadsRequest(jSONObject);
        }
        if ("evaluate".equals(string)) {
            return new EvaluateRequest(jSONObject);
        }
        throw new IllegalArgumentException("Unhandled request: " + string);
    }
}

