/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AwtUtilities;
import java.awt.Image;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class MacUtilities {
    private static Object getApplication() throws Exception {
        Class<?> clazz = Class.forName("com.apple.eawt.Application");
        Method method = clazz.getMethod("getApplication", new Class[0]);
        return method.invoke(null, new Object[0]);
    }

    public static void setQuitHandler(final Runnable runnable) throws Exception {
        try {
            AwtUtilities.setQuitHandler(runnable);
        }
        catch (Exception exception) {
            Object object = MacUtilities.getApplication();
            Class<?> clazz = Class.forName("com.apple.eawt.QuitHandler");
            Object object2 = Proxy.newProxyInstance(MacUtilities.class.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

                @Override
                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    Class<?> clazz = Class.forName("com.apple.eawt.QuitResponse");
                    Method method2 = clazz.getMethod("performQuit", new Class[0]);
                    runnable.run();
                    method2.invoke(objectArray[1], new Object[0]);
                    return null;
                }
            });
            Class<?> clazz2 = Class.forName("com.apple.eawt.Application");
            Method method = clazz2.getMethod("setQuitHandler", clazz);
            method.invoke(object, object2);
        }
    }

    public static void setDockIconImage(Image image) throws Exception {
        try {
            AwtUtilities.setIconImage(image);
        }
        catch (Exception exception) {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Method method = clazz.getMethod("setDockIconImage", Image.class);
            method.invoke(MacUtilities.getApplication(), image);
        }
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }
}

