/*
 * Decompiled with CFR 0.152.
 */
package assembler;

import java.util.ArrayList;
import java.util.List;

public class EnumTrie {
    private final Node root = new Node();

    public EnumTrie(Class<? extends Enum<?>> clazz) {
        Enum<?>[] enumArray = clazz.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> enum_ = enumArray[n2];
            this.put(enum_.toString(), enum_);
            ++n2;
        }
    }

    private Enum<?> put(String string, Enum<?> enum_) {
        int n = string.length();
        Node node = this.root;
        int n2 = 0;
        while (n2 < n) {
            byte by = (byte)string.charAt(n2);
            Node node2 = node.getNext(by);
            if (node2 != null) {
                node = node2;
            } else {
                Node node3 = new Node();
                node.setNext(by, node3);
                node = node3;
            }
            ++n2;
        }
        Enum<?> enum_2 = node.value;
        node.value = enum_;
        return enum_2;
    }

    public <T extends Enum<?>> T get(CharSequence charSequence) {
        return this.get(charSequence, false);
    }

    public <T extends Enum<?>> T get(CharSequence charSequence, boolean bl) {
        Node node = this.root;
        Node node2 = null;
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = charSequence.charAt(n2);
            if (n3 < 48 || n3 >= 128 || !Character.isJavaIdentifierPart((char)n3)) break;
            Node node3 = node.getNext((byte)(bl || n3 < 97 ? n3 : n3 & 0xFFFFFFDF));
            if (node3 == null) {
                return null;
            }
            node = node3;
            if (node.value != null) {
                node2 = node;
            }
            ++n2;
        }
        return (T)(node2 != null ? node2.value : null);
    }

    private List<String> collectEntries(Node node, String string, List<String> list) {
        if (node != null) {
            if (node.value != null) {
                list.add(String.valueOf(string) + " = " + node.value);
            }
            if (node.next != null) {
                int n = 0;
                while (n < node.next.length) {
                    this.collectEntries(node.next[n], String.valueOf(string) + (char)(n + 1), list);
                    ++n;
                }
            }
        }
        return list;
    }

    public String toString() {
        return this.collectEntries(this.root, "", new ArrayList<String>()).toString();
    }

    static class Node {
        Enum<?> value;
        Node[] next;

        Node() {
        }

        Node getNext(byte by) {
            if (this.next == null) {
                return null;
            }
            return this.next[by - 48 & 0x7F];
        }

        void setNext(byte by, Node node) {
            if (this.next == null) {
                this.next = new Node[80];
            }
            this.next[by - 48 & 0x7F] = node;
        }
    }
}

