/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import expressions.ParseException;
import expressions.UnknownVariableException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import overlays.OverlayModel;
import platform.debugger.Breakpoint;
import platform.debugger.Debugger;
import platform.debugger.SystemDebugger;

public class DebuggerOverlayTable
extends JTable
implements SystemDebugger.BreakpointListener {
    private final DefaultCellEditor editorType;
    private final DefaultCellEditor editorTrigger;
    private final Debugger debugger;
    private final DebuggerOverlayModel overlays = new DebuggerOverlayModel();

    public DebuggerOverlayTable(Debugger debugger) {
        super(DebuggerOverlayTable.createModel(debugger));
        this.debugger = debugger;
        this.editorType = new DefaultCellEditor(this.createDebuggerComboBox((Object[])OverlayModel.OverlayType.values()));
        this.editorTrigger = new DefaultCellEditor(this.createDebuggerComboBox(new Object[]{"VBlank", "PrevVBlank", "Breakpoint"}));
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    DebuggerOverlayTable.this.showPopupMenu(mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    DebuggerOverlayTable.this.showPopupMenu(mouseEvent.getPoint());
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "delete");
        this.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (DebuggerOverlayTable.this.getSelectedRow() >= 0 && DebuggerOverlayTable.this.getSelectedRow() < DebuggerOverlayTable.this.getRowCount() - 1) {
                    ((DefaultTableModel)DebuggerOverlayTable.this.getModel()).removeRow(DebuggerOverlayTable.this.getSelectedRow());
                }
            }
        });
        ((DefaultCellEditor)this.getDefaultEditor(Object.class)).setClickCountToStart(1);
        this.setSurrendersFocusOnKeystroke(true);
        this.updateUI();
        this.setFillsViewportHeight(true);
    }

    private JComboBox<Object> createDebuggerComboBox(Object[] objectArray) {
        return new JComboBox<Object>(objectArray){
            {
                this.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                        Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                        component.setForeground(bl ? DebuggerOverlayTable.this.debugger.getTableSelectionForeground() : DebuggerOverlayTable.this.getForeground());
                        component.setBackground(bl ? DebuggerOverlayTable.this.debugger.getTableSelectionBackground() : DebuggerOverlayTable.this.getBackground());
                        return component;
                    }
                });
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        DebuggerOverlayTable.this.getCellEditor().stopCellEditing();
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    }
                });
            }

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (!this.isPopupVisible()) {
                    this.requestFocusInWindow();
                    this.showPopup();
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }

            @Override
            public Font getFont() {
                return DebuggerOverlayTable.this.getFont();
            }
        };
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setEnabled(true);
            if (n2 == 0 && n == this.getRowCount() - 1) {
                jLabel.setText("Add new Overlay");
            } else if (n < this.getRowCount() - 1 && !this.isCellEditable(n, n2)) {
                jLabel.setText("N/A");
                jLabel.setEnabled(false);
            }
        }
        return component;
    }

    void showPopupMenu(Point point) {
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        InputEvent inputEvent;
        int n3;
        if (eventObject instanceof KeyEvent && ((n3 = ((KeyEvent)(inputEvent = (KeyEvent)eventObject)).getKeyCode()) >= 116 && n3 <= 120 || n3 == 27)) {
            return false;
        }
        if (eventObject instanceof MouseEvent && ((inputEvent = (MouseEvent)eventObject).getModifiers() & (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 2 | 1)) != 0) {
            return false;
        }
        return super.editCellAt(n, n2, eventObject);
    }

    @Override
    public Color getGridColor() {
        Color color = super.getGridColor();
        if (color != null && color.equals(Color.WHITE)) {
            return Color.GRAY;
        }
        return color;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            Component component2 = jComboBox.getEditor().getEditorComponent();
            component2.setFont(this.getFont());
            component2.setForeground(this.getSelectionForeground());
            component2.setBackground(this.getSelectionBackground());
        } else {
            component.setFont(this.getFont());
            component.setForeground(this.getSelectionForeground());
            component.setBackground(this.getSelectionBackground());
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setCaretColor(component.getForeground());
            }
        }
        return component;
    }

    @Override
    public void updateUI() {
        if (this.editorType == null) {
            super.updateUI();
            return;
        }
        this.getColumnModel().getColumn(0).setCellEditor(this.editorType);
        this.getColumnModel().getColumn(12).setCellEditor(this.editorTrigger);
        super.updateUI();
        Dimension dimension = this.getCellRenderer(this.getRowCount() - 1, 0).getTableCellRendererComponent(this, "Add new Overlay", false, false, this.getRowCount() - 1, 0).getPreferredSize();
        this.setRowHeight(dimension.height);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        int n = dimension.width;
        tableColumn.setPreferredWidth(n + this.getIntercellSpacing().width);
        tableColumn.setMaxWidth(Integer.MAX_VALUE);
        tableColumn.setMinWidth(n + this.getIntercellSpacing().width);
        tableColumn.setMaxWidth(n + this.getIntercellSpacing().width);
        int n2 = 1;
        while (n2 < this.getColumnCount()) {
            tableColumn = this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getTableHeader().getDefaultRenderer();
            }
            n = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)n2).getPreferredSize().width;
            tableColumn.setMaxWidth(Integer.MAX_VALUE);
            tableColumn.setPreferredWidth(128);
            if (this.getColumnClass(n2) == Boolean.class) {
                tableColumn.setMinWidth(n + this.getIntercellSpacing().width);
                tableColumn.setMaxWidth(n + this.getIntercellSpacing().width);
            }
            ++n2;
        }
    }

    private static TableModel createModel(final Debugger debugger) {
        return new DefaultTableModel(new Object[]{"Type", "Condition", "X", "Y", "Width", "Height", "Window Coords", "Thickness", "Color (ARGB)", "Use Alpha", "Fill", "Text", "Trigger"}, 0){
            {
                super(objectArray, n);
                super.addRow(new Object[this.getColumnCount()]);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n >= this.getRowCount() - 1) {
                    return n == this.getRowCount() - 1 && n2 == 0;
                }
                OverlayModel.OverlayType overlayType = (OverlayModel.OverlayType)((Object)this.getValueAt(n, 0));
                if (n2 == 11 && overlayType != OverlayModel.OverlayType.TEXT) {
                    return false;
                }
                return n2 != 4 && n2 != 7 && n2 != 10 || overlayType != OverlayModel.OverlayType.TEXT;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return OverlayModel.OverlayType.class;
                }
                if (n == 6 || n == 9 || n == 10) {
                    return Boolean.class;
                }
                return super.getColumnClass(n);
            }

            @Override
            public void addRow(Object[] objectArray) {
                super.addRow(new Object[this.getColumnCount()]);
                int n = 0;
                while (n < this.getColumnCount()) {
                    try {
                        this.setValueAt(objectArray[n], this.getRowCount() - 2, n);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ++n;
                }
            }

            @Override
            public void removeRow(int n) {
                if (n < this.getRowCount() - 1) {
                    super.removeRow(n);
                }
            }

            @Override
            public void setRowCount(int n) {
                super.setRowCount(n);
                if (n <= 0) {
                    super.addRow(new Object[this.getColumnCount()]);
                }
            }

            @Override
            public void setValueAt(Object object, final int n, final int n2) {
                try {
                    if (n2 == 12) {
                        if (object == null) {
                            super.setValueAt("VBlank", n, n2);
                        } else {
                            final Object object2 = this.getValueAt(n, n2);
                            super.setValueAt(object, n, n2);
                            if ("Breakpoint".equals(object)) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        int n3 = Debugger.openBreakpointSelectionWindow();
                                        if (n3 >= 0) {
                                            this.setValueAt("Breakpoint" + n3, n, n2);
                                        } else {
                                            this.setValueAt(object2, n, n2);
                                        }
                                    }
                                });
                            }
                        }
                    } else if (n2 == 11) {
                        if (object != null) {
                            super.setValueAt(debugger.parseConcatenatedExpression(object.toString()), n, n2);
                        }
                    } else if (object != null && this.getColumnClass(n2) != Boolean.class && this.getColumnClass(n2) != OverlayModel.OverlayType.class) {
                        super.setValueAt(debugger.parseExpression(object.toString()), n, n2);
                    } else {
                        super.setValueAt(object, n, n2);
                        if (n2 == 0 && n == this.getRowCount() - 1) {
                            if (object != null) {
                                super.addRow(new Object[this.getColumnCount()]);
                                this.setValueAt("true", n, 1);
                                this.setValueAt("0", n, 2);
                                this.setValueAt("0", n, 3);
                                this.setValueAt("16", n, 4);
                                this.setValueAt("16", n, 5);
                                this.setValueAt(Boolean.FALSE, n, 6);
                                this.setValueAt("1", n, 7);
                                this.setValueAt("$ffffff", n, 8);
                                this.setValueAt(Boolean.FALSE, n, 9);
                                this.setValueAt(Boolean.FALSE, n, 10);
                                this.setValueAt("\"TEXT\"", n, 11);
                                this.setValueAt("VBlank", n, 12);
                            }
                        } else if (n2 == 0) {
                            this.fireTableRowsUpdated(n, n);
                        }
                    }
                }
                catch (ParseException parseException) {
                    super.setValueAt(object, n, n2);
                }
            }
        };
    }

    private static String toColumnKey(String string) {
        return string != null ? string.replace(" ", "") : null;
    }

    private int indexOfColumnWithKey(String string) {
        if (string == null) {
            return -1;
        }
        int n = this.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            String string2 = DebuggerOverlayTable.toColumnKey(this.getColumnName(n2));
            if (string.equals(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean load(File file) {
        ((DefaultTableModel)this.getModel()).setRowCount(0);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            Object[] objectArray3 = bufferedReader.readLine();
            while (objectArray3 != null) {
                try {
                    String[] stringArray = objectArray3.split(" ");
                    Object[] objectArray2 = new Object[this.getColumnCount()];
                    int n = 0;
                    while (n < stringArray.length) {
                        String[] stringArray2 = stringArray[n].split("=");
                        if (stringArray2.length == 2) {
                            String string = stringArray2[1].replace("%20", " ").replace("%3d", "=");
                            int n2 = this.indexOfColumnWithKey(stringArray2[0]);
                            if (n2 >= 0) {
                                objectArray2[n2] = this.getColumnClass(n2) == Boolean.class ? Boolean.valueOf(Boolean.parseBoolean(string)) : (this.getColumnClass(n2) == OverlayModel.OverlayType.class ? OverlayModel.OverlayType.valueOf(string) : string);
                            }
                        }
                        ++n;
                    }
                    arrayList.add(objectArray2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                objectArray3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            for (Object[] objectArray3 : arrayList) {
                ((DefaultTableModel)this.getModel()).addRow(objectArray3);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public void save(File file) {
        if (this.getRowCount() > 1) {
            try {
                String[] stringArray = new String[this.getColumnCount()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = DebuggerOverlayTable.toColumnKey(this.getColumnName(n));
                    ++n;
                }
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                int n2 = 0;
                while (n2 < this.getRowCount() - 1) {
                    try {
                        printWriter.print(String.valueOf(stringArray[0]) + "=" + this.getValueAt(n2, 0).toString().replace(" ", "%20").replace("=", "%3d"));
                        int n3 = 1;
                        while (n3 < stringArray.length) {
                            printWriter.print(" " + stringArray[n3] + "=" + this.getValueAt(n2, n3).toString().replace(" ", "%20").replace("=", "%3d"));
                            ++n3;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    printWriter.println();
                    ++n2;
                }
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            file.delete();
        }
    }

    public OverlayModel getOverlays() {
        return this.overlays;
    }

    @Override
    public void breakpointHit(Breakpoint breakpoint, int n, int n2, String string) {
        this.overlays.breakpointHit(n);
    }

    @Override
    public void breakpointHitCleared() {
    }

    @Override
    public void breakpointsCleared() {
    }

    @Override
    public void breakpointAdded(Breakpoint breakpoint) {
    }

    @Override
    public void breakpointRemoved(Breakpoint breakpoint, int n, boolean bl) {
    }

    @Override
    public void breakpointChanged(Breakpoint breakpoint) {
    }

    private class DebuggerOverlayModel
    implements OverlayModel {
        private final ArrayList<Overlay> overlays = new ArrayList();

        private DebuggerOverlayModel() {
        }

        /*
         * Unable to fully structure code
         */
        public void update(int var1_1) {
            block15: {
                block17: {
                    block16: {
                        while (var1_1 >= this.overlays.size()) {
                            this.overlays.add(new Overlay());
                        }
                        var2_2 = this.overlays.get(var1_1);
                        try {
                            var2_2.setType((OverlayModel.OverlayType)DebuggerOverlayTable.this.getValueAt(var1_1, 0));
                            var2_2.setX(((Debugger.Expression)DebuggerOverlayTable.this.getValueAt(var1_1, 2)).getValue());
                            var2_2.setY(((Debugger.Expression)DebuggerOverlayTable.this.getValueAt(var1_1, 3)).getValue());
                            var2_2.setWidth(((Debugger.Expression)DebuggerOverlayTable.this.getValueAt(var1_1, 4)).getValue());
                            var2_2.setHeight(((Debugger.Expression)DebuggerOverlayTable.this.getValueAt(var1_1, 5)).getValue());
                            var2_2.setThickness(((Debugger.Expression)DebuggerOverlayTable.this.getValueAt(var1_1, 7)).getValue());
                            var2_2.setColor(((Debugger.Expression)DebuggerOverlayTable.this.getValueAt(var1_1, 8)).getValue());
                            var2_2.setText(((Debugger.Expression)DebuggerOverlayTable.this.getValueAt(var1_1, 11)).getValueString());
                            var2_2.setVisible(((Debugger.Expression)DebuggerOverlayTable.this.getValueAt(var1_1, 1)).isTrue());
                            var2_2.setUseWindowCoords(DebuggerOverlayTable.this.getValueAt(var1_1, 6) == Boolean.TRUE);
                            break block15;
                        }
                        catch (Exception var3_3) {
                            var2_2.setType(OverlayModel.OverlayType.TEXT);
                            var2_2.setX(0);
                            var2_2.setY(var1_1 * 16);
                            var2_2.setWidth(0);
                            var2_2.setHeight(16);
                            var2_2.setThickness(1);
                            var2_2.setColor(0xFF0000);
                            if (!(var3_3 instanceof ClassCastException)) break block16;
                            var4_4 = false;
                            var5_6 = 1;
                            ** while (!var4_4 && var5_6 < DebuggerOverlayTable.this.getColumnCount())
                        }
lbl-1000:
                        // 1 sources

                        {
                            var6_8 = DebuggerOverlayTable.this.getValueAt(var1_1, var5_6);
                            if (var6_8 != null && !(var6_8 instanceof Boolean) && !(var6_8 instanceof Debugger.Expression)) {
                                try {
                                    DebuggerOverlayTable.access$0(DebuggerOverlayTable.this).parseExpression(var6_8.toString());
                                }
                                catch (ParseException var7_10) {
                                    var2_2.setText("Error in Overlay (Column: " + DebuggerOverlayTable.this.getColumnName(var5_6) + "): " + var7_10.getMessage());
                                    var4_4 = true;
                                }
                            }
                            ++var5_6;
                            continue;
                        }
lbl41:
                        // 1 sources

                        if (!var4_4) {
                            var2_2.setText("Error in Overlay: " + var3_3.getMessage());
                        }
                        break block17;
                    }
                    if (var3_3 instanceof UnknownVariableException) {
                        var4_5 = false;
                        var5_7 = 1;
                        while (!var4_5 && var5_7 < DebuggerOverlayTable.this.getColumnCount()) {
                            var6_9 = DebuggerOverlayTable.this.getValueAt(var1_1, var5_7);
                            if (var6_9 instanceof Debugger.Expression) {
                                try {
                                    ((Debugger.Expression)var6_9).getValue();
                                }
                                catch (UnknownVariableException var7_11) {
                                    var2_2.setText("Error in Overlay (Column: " + DebuggerOverlayTable.this.getColumnName(var5_7) + "): " + var7_11.getMessage());
                                    var4_5 = true;
                                }
                            }
                            ++var5_7;
                        }
                        if (!var4_5) {
                            var2_2.setText("Error in Overlay: " + var3_3.getMessage());
                        }
                    } else {
                        var2_2.setText("Error in Overlay: " + var3_3.getMessage());
                    }
                }
                var2_2.setVisible(true);
                var2_2.setUseWindowCoords(true);
            }
        }

        @Override
        public int getOverlayCount() {
            return this.overlays.size();
        }

        @Override
        public OverlayModel.OverlayType getType(int n) {
            return this.overlays.get(n).getType();
        }

        @Override
        public int getX(int n) {
            return this.overlays.get(n).getX();
        }

        @Override
        public int getY(int n) {
            return this.overlays.get(n).getY();
        }

        @Override
        public int getWidth(int n) {
            return this.overlays.get(n).getWidth();
        }

        @Override
        public int getHeight(int n) {
            return this.overlays.get(n).getHeight();
        }

        @Override
        public int getThickness(int n) {
            return this.overlays.get(n).getThickness();
        }

        @Override
        public int getColor(int n) {
            return this.overlays.get(n).getColor();
        }

        @Override
        public String getText(int n) {
            return this.overlays.get(n).getText();
        }

        @Override
        public boolean isVisible(int n) {
            return this.overlays.get(n).isVisible();
        }

        @Override
        public boolean useWindowCoords(int n) {
            return this.overlays.get(n).useWindowCoords();
        }

        @Override
        public boolean hasAlpha(int n) {
            return DebuggerOverlayTable.this.getValueAt(n, 9) == Boolean.TRUE;
        }

        @Override
        public boolean isFill(int n) {
            return DebuggerOverlayTable.this.getValueAt(n, 10) == Boolean.TRUE;
        }

        @Override
        public void onBeforeRender() {
            int n = 0;
            while (n < DebuggerOverlayTable.this.getRowCount() - 1) {
                if ("VBlank".equals(DebuggerOverlayTable.this.getValueAt(n, 12))) {
                    this.update(n);
                }
                ++n;
            }
        }

        @Override
        public void onAfterRender() {
            int n = 0;
            while (n < DebuggerOverlayTable.this.getRowCount() - 1) {
                if ("PrevVBlank".equals(DebuggerOverlayTable.this.getValueAt(n, 12))) {
                    this.update(n);
                }
                ++n;
            }
        }

        public void breakpointHit(int n) {
            int n2 = 0;
            while (n2 < DebuggerOverlayTable.this.getRowCount() - 1) {
                String string = DebuggerOverlayTable.this.getValueAt(n2, 12).toString();
                if (string.startsWith("Breakpoint")) {
                    try {
                        int n3 = Integer.parseInt(string.substring("Breakpoint".length()));
                        if (n3 == n) {
                            this.update(n2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++n2;
            }
        }
    }

    private class Overlay {
        private OverlayModel.OverlayType type;
        private int x;
        private int y;
        private int width;
        private int height;
        private int thickness;
        private int color;
        private String text;
        private boolean visible;
        private boolean useWindowCoords;

        private Overlay() {
        }

        public OverlayModel.OverlayType getType() {
            return this.type;
        }

        public void setType(OverlayModel.OverlayType overlayType) {
            this.type = overlayType;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int n) {
            this.height = n;
        }

        public int getThickness() {
            return this.thickness;
        }

        public void setThickness(int n) {
            this.thickness = n;
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int n) {
            this.color = n;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public boolean useWindowCoords() {
            return this.useWindowCoords;
        }

        public void setUseWindowCoords(boolean bl) {
            this.useWindowCoords = bl;
        }
    }
}

