/*
 * Decompiled with CFR 0.152.
 */
package components.sound;

import components.OutputListener;
import java.lang.instrument.UnmodifiableClassException;
import java.util.LinkedList;

public class YM2413 {
    public static final int SIGNATURE = 0x330000;
    public static final int REGISTER_WRITE = 0x330000;
    public static final int UPDATE = 3342463;
    private static final int ENV_BITS = 10;
    private static final double ENV_STEP = 0.125;
    private static final int MAX_ATT_INDEX = 255;
    private static final int MIN_ATT_INDEX = 0;
    private static final int SIN_BITS = 10;
    private static final int SIN_LEN = 1024;
    private static final int SIN_MASK = 1023;
    private static final int TL_RES_LEN = 256;
    private static final int[] ksl_tab = new int[]{YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.75), YM2413.DV(1.125), YM2413.DV(1.5), YM2413.DV(1.875), YM2413.DV(2.25), YM2413.DV(2.625), YM2413.DV(3.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(1.125), YM2413.DV(1.875), YM2413.DV(2.625), YM2413.DV(3.0), YM2413.DV(3.75), YM2413.DV(4.125), YM2413.DV(4.5), YM2413.DV(4.875), YM2413.DV(5.25), YM2413.DV(5.625), YM2413.DV(6.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(1.875), YM2413.DV(3.0), YM2413.DV(4.125), YM2413.DV(4.875), YM2413.DV(5.625), YM2413.DV(6.0), YM2413.DV(6.75), YM2413.DV(7.125), YM2413.DV(7.5), YM2413.DV(7.875), YM2413.DV(8.25), YM2413.DV(8.625), YM2413.DV(9.0), YM2413.DV(0.0), YM2413.DV(0.0), YM2413.DV(3.0), YM2413.DV(4.875), YM2413.DV(6.0), YM2413.DV(7.125), YM2413.DV(7.875), YM2413.DV(8.625), YM2413.DV(9.0), YM2413.DV(9.75), YM2413.DV(10.125), YM2413.DV(10.5), YM2413.DV(10.875), YM2413.DV(11.25), YM2413.DV(11.625), YM2413.DV(12.0), YM2413.DV(0.0), YM2413.DV(3.0), YM2413.DV(6.0), YM2413.DV(7.875), YM2413.DV(9.0), YM2413.DV(10.125), YM2413.DV(10.875), YM2413.DV(11.625), YM2413.DV(12.0), YM2413.DV(12.75), YM2413.DV(13.125), YM2413.DV(13.5), YM2413.DV(13.875), YM2413.DV(14.25), YM2413.DV(14.625), YM2413.DV(15.0), YM2413.DV(0.0), YM2413.DV(6.0), YM2413.DV(9.0), YM2413.DV(10.875), YM2413.DV(12.0), YM2413.DV(13.125), YM2413.DV(13.875), YM2413.DV(14.625), YM2413.DV(15.0), YM2413.DV(15.75), YM2413.DV(16.125), YM2413.DV(16.5), YM2413.DV(16.875), YM2413.DV(17.25), YM2413.DV(17.625), YM2413.DV(18.0), YM2413.DV(0.0), YM2413.DV(9.0), YM2413.DV(12.0), YM2413.DV(13.875), YM2413.DV(15.0), YM2413.DV(16.125), YM2413.DV(16.875), YM2413.DV(17.625), YM2413.DV(18.0), YM2413.DV(18.75), YM2413.DV(19.125), YM2413.DV(19.5), YM2413.DV(19.875), YM2413.DV(20.25), YM2413.DV(20.625), YM2413.DV(21.0)};
    private static final int[] sl_tab = new int[]{YM2413.SC(0), YM2413.SC(1), YM2413.SC(2), YM2413.SC(3), YM2413.SC(4), YM2413.SC(5), YM2413.SC(6), YM2413.SC(7), YM2413.SC(8), YM2413.SC(9), YM2413.SC(10), YM2413.SC(11), YM2413.SC(12), YM2413.SC(13), YM2413.SC(14), YM2413.SC(15)};
    private static final int[][] eg_inc;
    private static final int[] eg_rate_select;
    private static final int[] eg_rate_shift;
    private static final int[] mul_tab;
    private static final int TL_TAB_LEN = 5632;
    private static final int[] tl;
    private static final int[][] sin;
    private static final int LFO_AM_TAB_ELEMENTS = 210;
    private static final LFOAMIndex LFO_AM_TAB_ELEMENTS_INDEX;
    private static final int[] lfo_am_table;
    private static final byte[][] lfo_pm_table;
    private static final int[][] table;
    private final int CLOCK_FREQ;
    private final Channel[] channels = new Channel[9];
    private int eg_cnt;
    private int noise_rng;
    private int idleSamples;
    private final LFOAMIndex lfo_am_cnt = new LFOAMIndex();
    private final LFOPMIndex lfo_pm_cnt = new LFOPMIndex();
    private final int[][] inst_tab = new int[19][8];
    private final int[] regs = new int[64];
    private int latchedRegister;
    private final LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];

    static {
        int[][] nArrayArray = new int[15][];
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[5] = 1;
        nArray[7] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[7] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArrayArray[3] = nArray4;
        nArrayArray[4] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        nArrayArray[5] = new int[]{1, 1, 1, 2, 1, 1, 1, 2};
        nArrayArray[6] = new int[]{1, 2, 1, 2, 1, 2, 1, 2};
        nArrayArray[7] = new int[]{1, 2, 2, 2, 1, 2, 2, 2};
        nArrayArray[8] = new int[]{2, 2, 2, 2, 2, 2, 2, 2};
        nArrayArray[9] = new int[]{2, 2, 2, 4, 2, 2, 2, 4};
        nArrayArray[10] = new int[]{2, 4, 2, 4, 2, 4, 2, 4};
        nArrayArray[11] = new int[]{2, 4, 4, 4, 2, 4, 4, 4};
        nArrayArray[12] = new int[]{4, 4, 4, 4, 4, 4, 4, 4};
        nArrayArray[13] = new int[]{8, 8, 8, 8, 8, 8, 8, 8};
        nArrayArray[14] = new int[8];
        eg_inc = nArrayArray;
        int[] nArray5 = new int[96];
        nArray5[0] = 14;
        nArray5[1] = 14;
        nArray5[2] = 14;
        nArray5[3] = 14;
        nArray5[4] = 14;
        nArray5[5] = 14;
        nArray5[6] = 14;
        nArray5[7] = 14;
        nArray5[8] = 14;
        nArray5[9] = 14;
        nArray5[10] = 14;
        nArray5[11] = 14;
        nArray5[12] = 14;
        nArray5[13] = 14;
        nArray5[14] = 14;
        nArray5[15] = 14;
        nArray5[17] = 1;
        nArray5[18] = 2;
        nArray5[19] = 3;
        nArray5[21] = 1;
        nArray5[22] = 2;
        nArray5[23] = 3;
        nArray5[25] = 1;
        nArray5[26] = 2;
        nArray5[27] = 3;
        nArray5[29] = 1;
        nArray5[30] = 2;
        nArray5[31] = 3;
        nArray5[33] = 1;
        nArray5[34] = 2;
        nArray5[35] = 3;
        nArray5[37] = 1;
        nArray5[38] = 2;
        nArray5[39] = 3;
        nArray5[41] = 1;
        nArray5[42] = 2;
        nArray5[43] = 3;
        nArray5[45] = 1;
        nArray5[46] = 2;
        nArray5[47] = 3;
        nArray5[49] = 1;
        nArray5[50] = 2;
        nArray5[51] = 3;
        nArray5[53] = 1;
        nArray5[54] = 2;
        nArray5[55] = 3;
        nArray5[57] = 1;
        nArray5[58] = 2;
        nArray5[59] = 3;
        nArray5[61] = 1;
        nArray5[62] = 2;
        nArray5[63] = 3;
        nArray5[65] = 1;
        nArray5[66] = 2;
        nArray5[67] = 3;
        nArray5[68] = 4;
        nArray5[69] = 5;
        nArray5[70] = 6;
        nArray5[71] = 7;
        nArray5[72] = 8;
        nArray5[73] = 9;
        nArray5[74] = 10;
        nArray5[75] = 11;
        nArray5[76] = 12;
        nArray5[77] = 12;
        nArray5[78] = 12;
        nArray5[79] = 12;
        nArray5[80] = 12;
        nArray5[81] = 12;
        nArray5[82] = 12;
        nArray5[83] = 12;
        nArray5[84] = 12;
        nArray5[85] = 12;
        nArray5[86] = 12;
        nArray5[87] = 12;
        nArray5[88] = 12;
        nArray5[89] = 12;
        nArray5[90] = 12;
        nArray5[91] = 12;
        nArray5[92] = 12;
        nArray5[93] = 12;
        nArray5[94] = 12;
        nArray5[95] = 12;
        eg_rate_select = nArray5;
        int[] nArray6 = new int[96];
        nArray6[16] = 13;
        nArray6[17] = 13;
        nArray6[18] = 13;
        nArray6[19] = 13;
        nArray6[20] = 12;
        nArray6[21] = 12;
        nArray6[22] = 12;
        nArray6[23] = 12;
        nArray6[24] = 11;
        nArray6[25] = 11;
        nArray6[26] = 11;
        nArray6[27] = 11;
        nArray6[28] = 10;
        nArray6[29] = 10;
        nArray6[30] = 10;
        nArray6[31] = 10;
        nArray6[32] = 9;
        nArray6[33] = 9;
        nArray6[34] = 9;
        nArray6[35] = 9;
        nArray6[36] = 8;
        nArray6[37] = 8;
        nArray6[38] = 8;
        nArray6[39] = 8;
        nArray6[40] = 7;
        nArray6[41] = 7;
        nArray6[42] = 7;
        nArray6[43] = 7;
        nArray6[44] = 6;
        nArray6[45] = 6;
        nArray6[46] = 6;
        nArray6[47] = 6;
        nArray6[48] = 5;
        nArray6[49] = 5;
        nArray6[50] = 5;
        nArray6[51] = 5;
        nArray6[52] = 4;
        nArray6[53] = 4;
        nArray6[54] = 4;
        nArray6[55] = 4;
        nArray6[56] = 3;
        nArray6[57] = 3;
        nArray6[58] = 3;
        nArray6[59] = 3;
        nArray6[60] = 2;
        nArray6[61] = 2;
        nArray6[62] = 2;
        nArray6[63] = 2;
        nArray6[64] = 1;
        nArray6[65] = 1;
        nArray6[66] = 1;
        nArray6[67] = 1;
        eg_rate_shift = nArray6;
        mul_tab = new int[]{YM2413.ML(0.5), YM2413.ML(1.0), YM2413.ML(2.0), YM2413.ML(3.0), YM2413.ML(4.0), YM2413.ML(5.0), YM2413.ML(6.0), YM2413.ML(7.0), YM2413.ML(8.0), YM2413.ML(9.0), YM2413.ML(10.0), YM2413.ML(10.0), YM2413.ML(12.0), YM2413.ML(12.0), YM2413.ML(15.0), YM2413.ML(15.0)};
        tl = YM2413.makeTlTab();
        sin = YM2413.makeSinTab();
        LFO_AM_TAB_ELEMENTS_INDEX = new LFOAMIndex(210);
        int[] nArray7 = new int[210];
        nArray7[7] = 1;
        nArray7[8] = 1;
        nArray7[9] = 1;
        nArray7[10] = 1;
        nArray7[11] = 2;
        nArray7[12] = 2;
        nArray7[13] = 2;
        nArray7[14] = 2;
        nArray7[15] = 3;
        nArray7[16] = 3;
        nArray7[17] = 3;
        nArray7[18] = 3;
        nArray7[19] = 4;
        nArray7[20] = 4;
        nArray7[21] = 4;
        nArray7[22] = 4;
        nArray7[23] = 5;
        nArray7[24] = 5;
        nArray7[25] = 5;
        nArray7[26] = 5;
        nArray7[27] = 6;
        nArray7[28] = 6;
        nArray7[29] = 6;
        nArray7[30] = 6;
        nArray7[31] = 7;
        nArray7[32] = 7;
        nArray7[33] = 7;
        nArray7[34] = 7;
        nArray7[35] = 8;
        nArray7[36] = 8;
        nArray7[37] = 8;
        nArray7[38] = 8;
        nArray7[39] = 9;
        nArray7[40] = 9;
        nArray7[41] = 9;
        nArray7[42] = 9;
        nArray7[43] = 10;
        nArray7[44] = 10;
        nArray7[45] = 10;
        nArray7[46] = 10;
        nArray7[47] = 11;
        nArray7[48] = 11;
        nArray7[49] = 11;
        nArray7[50] = 11;
        nArray7[51] = 12;
        nArray7[52] = 12;
        nArray7[53] = 12;
        nArray7[54] = 12;
        nArray7[55] = 13;
        nArray7[56] = 13;
        nArray7[57] = 13;
        nArray7[58] = 13;
        nArray7[59] = 14;
        nArray7[60] = 14;
        nArray7[61] = 14;
        nArray7[62] = 14;
        nArray7[63] = 15;
        nArray7[64] = 15;
        nArray7[65] = 15;
        nArray7[66] = 15;
        nArray7[67] = 16;
        nArray7[68] = 16;
        nArray7[69] = 16;
        nArray7[70] = 16;
        nArray7[71] = 17;
        nArray7[72] = 17;
        nArray7[73] = 17;
        nArray7[74] = 17;
        nArray7[75] = 18;
        nArray7[76] = 18;
        nArray7[77] = 18;
        nArray7[78] = 18;
        nArray7[79] = 19;
        nArray7[80] = 19;
        nArray7[81] = 19;
        nArray7[82] = 19;
        nArray7[83] = 20;
        nArray7[84] = 20;
        nArray7[85] = 20;
        nArray7[86] = 20;
        nArray7[87] = 21;
        nArray7[88] = 21;
        nArray7[89] = 21;
        nArray7[90] = 21;
        nArray7[91] = 22;
        nArray7[92] = 22;
        nArray7[93] = 22;
        nArray7[94] = 22;
        nArray7[95] = 23;
        nArray7[96] = 23;
        nArray7[97] = 23;
        nArray7[98] = 23;
        nArray7[99] = 24;
        nArray7[100] = 24;
        nArray7[101] = 24;
        nArray7[102] = 24;
        nArray7[103] = 25;
        nArray7[104] = 25;
        nArray7[105] = 25;
        nArray7[106] = 25;
        nArray7[107] = 26;
        nArray7[108] = 26;
        nArray7[109] = 26;
        nArray7[110] = 25;
        nArray7[111] = 25;
        nArray7[112] = 25;
        nArray7[113] = 25;
        nArray7[114] = 24;
        nArray7[115] = 24;
        nArray7[116] = 24;
        nArray7[117] = 24;
        nArray7[118] = 23;
        nArray7[119] = 23;
        nArray7[120] = 23;
        nArray7[121] = 23;
        nArray7[122] = 22;
        nArray7[123] = 22;
        nArray7[124] = 22;
        nArray7[125] = 22;
        nArray7[126] = 21;
        nArray7[127] = 21;
        nArray7[128] = 21;
        nArray7[129] = 21;
        nArray7[130] = 20;
        nArray7[131] = 20;
        nArray7[132] = 20;
        nArray7[133] = 20;
        nArray7[134] = 19;
        nArray7[135] = 19;
        nArray7[136] = 19;
        nArray7[137] = 19;
        nArray7[138] = 18;
        nArray7[139] = 18;
        nArray7[140] = 18;
        nArray7[141] = 18;
        nArray7[142] = 17;
        nArray7[143] = 17;
        nArray7[144] = 17;
        nArray7[145] = 17;
        nArray7[146] = 16;
        nArray7[147] = 16;
        nArray7[148] = 16;
        nArray7[149] = 16;
        nArray7[150] = 15;
        nArray7[151] = 15;
        nArray7[152] = 15;
        nArray7[153] = 15;
        nArray7[154] = 14;
        nArray7[155] = 14;
        nArray7[156] = 14;
        nArray7[157] = 14;
        nArray7[158] = 13;
        nArray7[159] = 13;
        nArray7[160] = 13;
        nArray7[161] = 13;
        nArray7[162] = 12;
        nArray7[163] = 12;
        nArray7[164] = 12;
        nArray7[165] = 12;
        nArray7[166] = 11;
        nArray7[167] = 11;
        nArray7[168] = 11;
        nArray7[169] = 11;
        nArray7[170] = 10;
        nArray7[171] = 10;
        nArray7[172] = 10;
        nArray7[173] = 10;
        nArray7[174] = 9;
        nArray7[175] = 9;
        nArray7[176] = 9;
        nArray7[177] = 9;
        nArray7[178] = 8;
        nArray7[179] = 8;
        nArray7[180] = 8;
        nArray7[181] = 8;
        nArray7[182] = 7;
        nArray7[183] = 7;
        nArray7[184] = 7;
        nArray7[185] = 7;
        nArray7[186] = 6;
        nArray7[187] = 6;
        nArray7[188] = 6;
        nArray7[189] = 6;
        nArray7[190] = 5;
        nArray7[191] = 5;
        nArray7[192] = 5;
        nArray7[193] = 5;
        nArray7[194] = 4;
        nArray7[195] = 4;
        nArray7[196] = 4;
        nArray7[197] = 4;
        nArray7[198] = 3;
        nArray7[199] = 3;
        nArray7[200] = 3;
        nArray7[201] = 3;
        nArray7[202] = 2;
        nArray7[203] = 2;
        nArray7[204] = 2;
        nArray7[205] = 2;
        nArray7[206] = 1;
        nArray7[207] = 1;
        nArray7[208] = 1;
        nArray7[209] = 1;
        lfo_am_table = nArray7;
        byte[][] byArrayArray = new byte[8][];
        byArrayArray[0] = new byte[8];
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[4] = -1;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 2;
        byArray2[1] = 1;
        byArray2[3] = -1;
        byArray2[4] = -2;
        byArray2[5] = -1;
        byArray2[7] = 1;
        byArrayArray[2] = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[0] = 3;
        byArray3[1] = 1;
        byArray3[3] = -1;
        byArray3[4] = -3;
        byArray3[5] = -1;
        byArray3[7] = 1;
        byArrayArray[3] = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = 4;
        byArray4[1] = 2;
        byArray4[3] = -2;
        byArray4[4] = -4;
        byArray4[5] = -2;
        byArray4[7] = 2;
        byArrayArray[4] = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[0] = 5;
        byArray5[1] = 2;
        byArray5[3] = -2;
        byArray5[4] = -5;
        byArray5[5] = -2;
        byArray5[7] = 2;
        byArrayArray[5] = byArray5;
        byte[] byArray6 = new byte[8];
        byArray6[0] = 6;
        byArray6[1] = 3;
        byArray6[3] = -3;
        byArray6[4] = -6;
        byArray6[5] = -3;
        byArray6[7] = 3;
        byArrayArray[6] = byArray6;
        byte[] byArray7 = new byte[8];
        byArray7[0] = 7;
        byArray7[1] = 3;
        byArray7[3] = -3;
        byArray7[4] = -7;
        byArray7[5] = -3;
        byArray7[7] = 3;
        byArrayArray[7] = byArray7;
        lfo_pm_table = byArrayArray;
        int[][] nArrayArray2 = new int[19][];
        nArrayArray2[0] = new int[8];
        int[] nArray8 = new int[8];
        nArray8[0] = 113;
        nArray8[1] = 97;
        nArray8[2] = 30;
        nArray8[3] = 23;
        nArray8[4] = 208;
        nArray8[5] = 120;
        nArray8[7] = 23;
        nArrayArray2[1] = nArray8;
        nArrayArray2[2] = new int[]{19, 65, 26, 13, 216, 247, 35, 19};
        int[] nArray9 = new int[8];
        nArray9[0] = 19;
        nArray9[1] = 1;
        nArray9[2] = 153;
        nArray9[4] = 242;
        nArray9[5] = 196;
        nArray9[6] = 17;
        nArray9[7] = 35;
        nArrayArray2[3] = nArray9;
        nArrayArray2[4] = new int[]{49, 97, 14, 7, 168, 100, 112, 39};
        int[] nArray10 = new int[8];
        nArray10[0] = 50;
        nArray10[1] = 33;
        nArray10[2] = 30;
        nArray10[3] = 6;
        nArray10[4] = 224;
        nArray10[5] = 118;
        nArray10[7] = 40;
        nArrayArray2[5] = nArray10;
        int[] nArray11 = new int[8];
        nArray11[0] = 49;
        nArray11[1] = 34;
        nArray11[2] = 22;
        nArray11[3] = 5;
        nArray11[4] = 224;
        nArray11[5] = 113;
        nArray11[7] = 24;
        nArrayArray2[6] = nArray11;
        nArrayArray2[7] = new int[]{33, 97, 29, 7, 130, 129, 16, 7};
        int[] nArray12 = new int[8];
        nArray12[0] = 35;
        nArray12[1] = 33;
        nArray12[2] = 45;
        nArray12[3] = 20;
        nArray12[4] = 162;
        nArray12[5] = 114;
        nArray12[7] = 7;
        nArrayArray2[8] = nArray12;
        nArrayArray2[9] = new int[]{97, 97, 27, 6, 100, 101, 16, 23};
        nArrayArray2[10] = new int[]{65, 97, 11, 24, 133, 247, 113, 7};
        nArrayArray2[11] = new int[]{19, 1, 131, 17, 250, 228, 16, 4};
        nArrayArray2[12] = new int[]{23, 193, 36, 7, 248, 248, 34, 18};
        nArrayArray2[13] = new int[]{97, 80, 12, 5, 194, 245, 32, 66};
        nArrayArray2[14] = new int[]{1, 1, 85, 3, 201, 149, 3, 2};
        nArrayArray2[15] = new int[]{97, 65, 137, 3, 241, 228, 64, 19};
        nArrayArray2[16] = new int[]{1, 1, 24, 15, 223, 248, 106, 109};
        int[] nArray13 = new int[8];
        nArray13[0] = 1;
        nArray13[1] = 1;
        nArray13[4] = 200;
        nArray13[5] = 216;
        nArray13[6] = 167;
        nArray13[7] = 72;
        nArrayArray2[17] = nArray13;
        int[] nArray14 = new int[8];
        nArray14[0] = 5;
        nArray14[1] = 1;
        nArray14[4] = 248;
        nArray14[5] = 170;
        nArray14[6] = 89;
        nArray14[7] = 85;
        nArrayArray2[18] = nArray14;
        table = nArrayArray2;
    }

    private static final int DV(double d) {
        return (int)(d / 0.1875);
    }

    private static final int SC(int n) {
        return (int)((double)n / 0.125);
    }

    private static final int ML(double d) {
        return (int)(2.0 * d);
    }

    private static final int[] makeTlTab() {
        int[] nArray = new int[5632];
        int n = 0;
        while (n < 256) {
            double d = 65536.0 / Math.pow(2.0, (double)(n + 1) * 0.03125 / 8.0);
            int n2 = (int)d;
            n2 >>= 4;
            n2 = (n2 >> 1) + (n2 & 1);
            int n3 = 0;
            while (n3 < 11) {
                nArray[n * 2 + 0 + n3 * 2 * 256] = n2 >> n3;
                nArray[n * 2 + 1 + n3 * 2 * 256] = -(n2 >> n3);
                ++n3;
            }
            ++n;
        }
        return nArray;
    }

    private static final double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    private static final int[][] makeSinTab() {
        int[][] nArray = new int[2][1024];
        int n = 0;
        while (n < 256) {
            double d = Math.sin((double)(n * 2 + 1) * Math.PI / 1024.0);
            int n2 = (int)Math.round(YM2413.log2(d) * -256.0);
            nArray[0][n] = 2 * n2;
            ++n;
        }
        n = 0;
        while (n < 256) {
            nArray[0][256 + n] = nArray[0][255 - n];
            ++n;
        }
        n = 0;
        while (n < 512) {
            nArray[0][512 + n] = nArray[0][n] | 1;
            ++n;
        }
        n = 0;
        while (n < 512) {
            nArray[1][n] = nArray[0][n];
            ++n;
        }
        n = 0;
        while (n < 512) {
            nArray[1][n + 512] = 5632;
            ++n;
        }
        return nArray;
    }

    static final FreqIndex fnumToIncrement(int n) {
        int n2 = (n & 0x1C00) >> 10;
        FreqIndex freqIndex = new FreqIndex(n & 0x3FF);
        freqIndex.shiftRightAssign(11 - n2);
        return freqIndex;
    }

    private static final int genPhaseHighHat(int n, int n2, int n3) {
        boolean bl;
        if ((n2 & 0x28) != 0) {
            bl = true;
        } else {
            boolean bl2 = (n & 0x80) != 0;
            boolean bl3 = (n & 8) != 0;
            boolean bl4 = (n & 4) != 0;
            bl = bl4 ^ bl2 | bl3;
        }
        if ((n3 & 1) != 0) {
            return bl ? 720 : 52;
        }
        return bl ? 564 : 208;
    }

    private static final int genPhaseSnare(int n, int n2) {
        return (n & 0x100) + 256 ^ (n2 & 1) << 8;
    }

    private static final int genPhaseCymbal(int n, int n2) {
        if ((n2 & 0x28) != 0) {
            return 768;
        }
        boolean bl = (n & 0x80) != 0;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 4) != 0;
        return bl3 != bl || bl2 ? 768 : 256;
    }

    public YM2413(int n) {
        this.CLOCK_FREQ = n;
        int n2 = 0;
        while (n2 < this.channels.length) {
            this.channels[n2] = new Channel();
            ++n2;
        }
        this.reset();
    }

    private void updateCustomInstrument(int n, int n2) {
        this.inst_tab[0][n] = n2;
        int n3 = this.isRhythm() ? 6 : 9;
        int n4 = 0;
        while (n4 < n3) {
            Channel channel = this.channels[n4];
            if ((this.regs[48 + n4] & 0xF0) == 0) {
                channel.updateInstrumentPart(n, n2);
            }
            ++n4;
        }
    }

    private void setRhythmFlags(int n) {
        Channel channel = this.channels[6];
        Channel channel2 = this.channels[7];
        Channel channel3 = this.channels[8];
        int n2 = this.regs[14];
        if (((n2 ^ n) & 0x20) != 0) {
            if ((n2 & 0x20) != 0) {
                channel.updateInstrument(this.inst_tab[16]);
                channel2.updateInstrument(this.inst_tab[17]);
                channel2.mod.setTotalLevel(channel2, this.regs[55] >> 4 << 2);
                channel3.updateInstrument(this.inst_tab[18]);
                channel3.mod.setTotalLevel(channel3, this.regs[56] >> 4 << 2);
            } else {
                channel.updateInstrument(this.inst_tab[this.regs[54] >> 4]);
                channel2.updateInstrument(this.inst_tab[this.regs[55] >> 4]);
                channel3.updateInstrument(this.inst_tab[this.regs[56] >> 4]);
                channel.mod.setKeyOff(Slot.KeyPart.RHYTHM);
                channel.car.setKeyOff(Slot.KeyPart.RHYTHM);
                channel2.mod.setKeyOff(Slot.KeyPart.RHYTHM);
                channel2.car.setKeyOff(Slot.KeyPart.RHYTHM);
                channel3.mod.setKeyOff(Slot.KeyPart.RHYTHM);
                channel3.car.setKeyOff(Slot.KeyPart.RHYTHM);
            }
        }
        if ((n2 & 0x20) != 0) {
            channel.mod.setKeyOnOff(Slot.KeyPart.RHYTHM, (n2 & 0x10) != 0);
            channel.car.setKeyOnOff(Slot.KeyPart.RHYTHM, (n2 & 0x10) != 0);
            channel2.mod.setKeyOnOff(Slot.KeyPart.RHYTHM, (n2 & 1) != 0);
            channel2.car.setKeyOnOff(Slot.KeyPart.RHYTHM, (n2 & 8) != 0);
            channel3.mod.setKeyOnOff(Slot.KeyPart.RHYTHM, (n2 & 4) != 0);
            channel3.car.setKeyOnOff(Slot.KeyPart.RHYTHM, (n2 & 2) != 0);
        }
    }

    public void reset() {
        this.eg_cnt = 0;
        this.noise_rng = 1;
        this.idleSamples = 0;
        int n = 0;
        while (n < 19) {
            int n2 = 0;
            while (n2 < 8) {
                this.inst_tab[n][n2] = table[n][n2];
                ++n2;
            }
            ++n;
        }
        this.writeReg(15, 0);
        n = 63;
        while (n >= 16) {
            this.writeReg(n, 0);
            --n;
        }
        this.resetOperators();
    }

    private void resetOperators() {
        Channel[] channelArray = this.channels;
        int n = this.channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            channel.mod.resetOperators();
            channel.car.resetOperators();
            ++n2;
        }
    }

    private boolean isRhythm() {
        return (this.regs[14] & 0x20) != 0;
    }

    private Channel getChannelForReg(int n) {
        int n2 = (n & 0xF) % 9;
        return this.channels[n2];
    }

    public static float getAmplificationFactor() {
        return 4.8828125E-4f;
    }

    public void generateChannels(float[][] fArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = this.isRhythm() ? 6 : 9;
        int n5 = 0;
        while (n5 < n4) {
            if (this.channels[n5].car.isActive()) {
                n3 |= 1 << n5;
            } else {
                fArray[n5] = null;
            }
            ++n5;
        }
        int n6 = n5 = (this.regs[15] & 4) != 0 ? 1 : 0;
        if (this.isRhythm()) {
            fArray[6] = null;
            fArray[7] = null;
            fArray[8] = null;
            n2 = 6;
            while (n2 < 9) {
                if (this.channels[n2].car.isActive()) {
                    n3 |= 1 << n2;
                } else {
                    fArray[n2 + 3] = null;
                }
                ++n2;
            }
            if (this.channels[7].mod.isActive()) {
                n3 |= 0x10000;
            } else {
                fArray[12] = null;
            }
            if (this.channels[8].mod.isActive()) {
                n3 |= 0x20000;
            } else {
                fArray[13] = null;
            }
        } else {
            fArray[9] = null;
            fArray[10] = null;
            fArray[11] = null;
            fArray[12] = null;
            fArray[13] = null;
        }
        if (n3 != 0) {
            this.idleSamples = 0;
        } else {
            if (this.idleSamples > this.CLOCK_FREQ / 360) {
                return;
            }
            this.idleSamples += n;
        }
        n2 = 0;
        while (n2 < n) {
            int n7;
            this.lfo_am_cnt.inc();
            if (this.lfo_am_cnt.equals(LFO_AM_TAB_ELEMENTS_INDEX)) {
                this.lfo_am_cnt.assign(0);
            }
            int n8 = lfo_am_table[this.lfo_am_cnt.toInt()] >> 1;
            int n9 = this.lfo_pm_cnt.toInt() & 7;
            int n10 = 0;
            while (n10 < n4) {
                Channel channel = this.channels[n10];
                n7 = channel.mod.calc_slot_mod(channel, this.eg_cnt, false, n9, n8, n5 != 0);
                if ((n3 >> n10 & 1) != 0) {
                    float[] fArray2 = fArray[n10];
                    int n11 = n2;
                    fArray2[n11] = fArray2[n11] + (float)channel.calcOutput(this.eg_cnt, n9, n8, n7, n5 != 0);
                }
                ++n10;
            }
            if (this.isRhythm()) {
                Slot slot;
                Channel channel = this.channels[6];
                int n12 = channel.mod.calc_slot_mod(this.channels[6], this.eg_cnt, true, n9, n8, n5 != 0);
                if ((n3 & 0x40) != 0) {
                    float[] fArray3 = fArray[9];
                    int n13 = n2;
                    fArray3[n13] = fArray3[n13] + (float)(2 * channel.calcOutput(this.eg_cnt, n9, n8, n12, n5 != 0));
                }
                this.channels[7].car.calc_phase(this.channels[7], n9, n5 != 0);
                n7 = this.channels[7].mod.calc_phase(this.channels[7], n9, n5 != 0);
                int n14 = this.channels[8].car.calc_phase(this.channels[8], n9, n5 != 0);
                int n15 = this.channels[8].mod.calc_phase(this.channels[8], n9, n5 != 0);
                if ((n3 & 0x80) != 0) {
                    slot = this.channels[7].car;
                    float[] fArray4 = fArray[10];
                    int n16 = n2;
                    fArray4[n16] = fArray4[n16] + (float)(2 * slot.calcOutput(this.channels[7], this.eg_cnt, true, n8, YM2413.genPhaseSnare(n7, this.noise_rng)));
                }
                if ((n3 & 0x100) != 0) {
                    slot = this.channels[8].car;
                    float[] fArray5 = fArray[11];
                    int n17 = n2;
                    fArray5[n17] = fArray5[n17] + (float)(2 * slot.calcOutput(this.channels[8], this.eg_cnt, true, n8, YM2413.genPhaseCymbal(n7, n14)));
                }
                if ((n3 & 0x10000) != 0) {
                    slot = this.channels[7].mod;
                    float[] fArray6 = fArray[12];
                    int n18 = n2;
                    fArray6[n18] = fArray6[n18] + (float)(2 * slot.calcOutput(this.channels[7], this.eg_cnt, true, n8, YM2413.genPhaseHighHat(n7, n14, this.noise_rng)));
                }
                if ((n3 & 0x20000) != 0) {
                    slot = this.channels[8].mod;
                    float[] fArray7 = fArray[13];
                    int n19 = n2;
                    fArray7[n19] = fArray7[n19] + (float)(2 * slot.calcOutput(this.channels[8], this.eg_cnt, true, n8, n15));
                }
            }
            this.lfo_pm_cnt.inc();
            ++this.eg_cnt;
            if ((this.noise_rng & 1) != 0) {
                this.noise_rng ^= 0x800302;
            }
            this.noise_rng >>= 1;
            ++n2;
        }
    }

    public void writeReg(int n, int n2) {
        this.fireOutputAvailable(0x330000, n2 << 6 | n);
        int n3 = this.regs[n];
        this.regs[n] = n2;
        switch (n & 0xF0) {
            case 0: {
                switch (n & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.updateCustomInstrument(n, n2);
                        break;
                    }
                    case 14: {
                        this.setRhythmFlags(n3);
                    }
                }
                break;
            }
            case 16: {
                Channel channel = this.getChannelForReg(n);
                channel.setFrequencyLow(n2);
                break;
            }
            case 32: {
                Channel channel = this.getChannelForReg(n);
                channel.mod.setKeyOnOff(Slot.KeyPart.MAIN, (n2 & 0x10) != 0);
                channel.car.setKeyOnOff(Slot.KeyPart.MAIN, (n2 & 0x10) != 0);
                channel.setSustain((n2 & 0x20) != 0);
                channel.setFrequencyHigh(n2 & 0xF);
                break;
            }
            case 48: {
                Channel channel = this.getChannelForReg(n);
                channel.car.setTotalLevel(channel, (n2 & 0xF) << 2);
                int n4 = (n & 0xF) % 9;
                if (this.isRhythm() && n4 >= 6) {
                    if (n4 <= 6) break;
                    channel.mod.setTotalLevel(channel, n2 >> 4 << 2);
                    break;
                }
                if ((n3 & 0xF0) == (n2 & 0xF0)) break;
                channel.updateInstrument(this.inst_tab[n2 >> 4]);
                break;
            }
        }
    }

    public int peekReg(int n) {
        return this.regs[n];
    }

    public void processInput(int n, int n2, int n3) {
        this.fireOutputAvailable(3342463, n3);
        switch (n) {
            case 0: {
                this.latchedRegister = n2 & 0x3F;
                break;
            }
            case 1: {
                this.writeReg(this.latchedRegister, n2);
            }
        }
    }

    protected void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = this.listeners;
        int n3 = this.listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        if (!this.listenerList.contains(outputListener)) {
            this.listenerList.addFirst(outputListener);
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public void removeOutputListener(OutputListener outputListener) {
        if (this.listenerList.remove(outputListener)) {
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getReg(int n) {
                return YM2413.this.regs[n];
            }

            @Override
            public int getLatchedRegister() {
                return YM2413.this.latchedRegister;
            }
        };
    }

    public void setState(State state) {
        int n = this.regs.length - 1;
        while (n >= 0) {
            this.writeReg(n, state.getReg(n));
            --n;
        }
        this.latchedRegister = state.getLatchedRegister();
    }

    private static class Channel {
        public final Slot mod = new Slot();
        public final Slot car = new Slot(this.mod);
        private int block_fnum = 0;
        private FreqIndex fc = new FreqIndex();
        private int ksl_base = 0;
        private boolean sus = false;

        public final int calcOutput(int n, int n2, int n3, int n4, boolean bl) {
            int n5 = this.car.calc_phase(this, n2, bl) + n4;
            return this.car.calcOutput(this, n, true, n3, n5);
        }

        public void setFrequency(int n) {
            if (this.block_fnum != n) {
                this.block_fnum = n;
                this.ksl_base = ksl_tab[this.block_fnum >> 5];
                this.fc = YM2413.fnumToIncrement(this.block_fnum * 2);
            }
            this.mod.updateFrequency(this);
            this.car.updateFrequency(this);
        }

        public void setFrequencyLow(int n) {
            this.setFrequency(this.block_fnum & 0xF00 | n);
        }

        public void setFrequencyHigh(int n) {
            this.setFrequency(n << 8 | this.block_fnum & 0xFF);
        }

        public int getBlockFNum() {
            return this.block_fnum;
        }

        public FreqIndex getFrequencyIncrement() {
            return this.fc;
        }

        public int getKeyScaleLevelBase() {
            return this.ksl_base;
        }

        public int getKeyCode() {
            return (this.block_fnum & 0xF00) >> 8;
        }

        public boolean isSustained() {
            return this.sus;
        }

        public void setSustain(boolean bl) {
            this.sus = bl;
        }

        public void updateInstrumentPart(int n, int n2) {
            switch (n) {
                case 0: {
                    this.mod.setFrequencyMultiplier(n2 & 0xF);
                    this.mod.setKeyScaleRate((n2 & 0x10) != 0);
                    this.mod.setEnvelopeSustained((n2 & 0x20) != 0);
                    this.mod.setVibrato((n2 & 0x40) != 0);
                    this.mod.setAmplitudeModulation((n2 & 0x80) != 0);
                    this.mod.updateGenerators(this);
                    break;
                }
                case 1: {
                    this.car.setFrequencyMultiplier(n2 & 0xF);
                    this.car.setKeyScaleRate((n2 & 0x10) != 0);
                    this.car.setEnvelopeSustained((n2 & 0x20) != 0);
                    this.car.setVibrato((n2 & 0x40) != 0);
                    this.car.setAmplitudeModulation((n2 & 0x80) != 0);
                    this.car.updateGenerators(this);
                    break;
                }
                case 2: {
                    this.mod.setKeyScaleLevel(this, n2 >> 6);
                    this.mod.setTotalLevel(this, n2 & 0x3F);
                    break;
                }
                case 3: {
                    this.mod.setWaveform((n2 & 8) >> 3);
                    this.mod.setFeedbackShift(n2 & 7);
                    this.car.setKeyScaleLevel(this, n2 >> 6);
                    this.car.setWaveform((n2 & 0x10) >> 4);
                    break;
                }
                case 4: {
                    this.mod.setAttackRate(this, n2 >> 4);
                    this.mod.setDecayRate(this, n2 & 0xF);
                    break;
                }
                case 5: {
                    this.car.setAttackRate(this, n2 >> 4);
                    this.car.setDecayRate(this, n2 & 0xF);
                    break;
                }
                case 6: {
                    this.mod.setSustainLevel(n2 >> 4);
                    this.mod.setReleaseRate(this, n2 & 0xF);
                    break;
                }
                case 7: {
                    this.car.setSustainLevel(n2 >> 4);
                    this.car.setReleaseRate(this, n2 & 0xF);
                }
            }
        }

        public void updateInstrument(int[] nArray) {
            int n = 0;
            while (n < 8) {
                this.updateInstrumentPart(n, nArray[n]);
                ++n;
            }
        }
    }

    public static abstract class FixedPoint<T> {
        private final int FRACTION_BITS;
        private final int ONE;
        private final float INV_ONE_F;
        private final double INV_ONE_D;
        private final int FRACTION_MASK;
        private int value;

        protected FixedPoint(int n, int n2, boolean bl) {
            this.FRACTION_BITS = n;
            this.ONE = 1 << this.FRACTION_BITS;
            this.INV_ONE_F = 1.0f / (float)this.ONE;
            this.INV_ONE_D = 1.0 / (double)this.ONE;
            this.FRACTION_MASK = this.ONE - 1;
            this.value = bl ? n2 : n2 << this.FRACTION_BITS;
        }

        protected FixedPoint(int n, int n2) {
            this(n, n2, false);
        }

        protected abstract T create(int var1);

        public int toInt() {
            return this.value >> this.FRACTION_BITS;
        }

        public float toFloat() {
            return (float)this.value * this.INV_ONE_F;
        }

        public double toDouble() {
            return (double)this.value * this.INV_ONE_D;
        }

        public T floor() {
            return this.create(this.value & ~this.FRACTION_MASK);
        }

        public void shiftRightAssign(int n) {
            this.value >>= n;
        }

        public void addAssign(FixedPoint<T> fixedPoint) {
            this.value += fixedPoint.value;
        }

        public T multiply(int n) {
            return this.create(this.value * n);
        }

        public void multiplyAssign(int n) {
            this.value *= n;
        }

        public void inc() {
            ++this.value;
        }

        public void assign(int n) {
            this.value = n << this.FRACTION_BITS;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.value;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FixedPoint fixedPoint = (FixedPoint)object;
            return this.value == fixedPoint.value;
        }

        public String toString() {
            return Double.toString(this.toFloat());
        }
    }

    private static class FreqIndex
    extends FixedPoint<FreqIndex> {
        private FreqIndex(int n, boolean bl) {
            super(16, n, bl);
        }

        public FreqIndex(int n) {
            super(16, n);
        }

        public FreqIndex() {
            this(0);
        }

        @Override
        protected FreqIndex create(int n) {
            return new FreqIndex(n, true);
        }
    }

    private static class LFOAMIndex
    extends FixedPoint<LFOAMIndex> {
        private LFOAMIndex(int n, boolean bl) {
            super(16, n, bl);
        }

        public LFOAMIndex(int n) {
            super(6, n);
        }

        public LFOAMIndex() {
            this(0);
        }

        @Override
        protected LFOAMIndex create(int n) {
            return new LFOAMIndex(n, true);
        }
    }

    private static class LFOPMIndex
    extends FixedPoint<LFOPMIndex> {
        private LFOPMIndex(int n, boolean bl) {
            super(16, n, bl);
        }

        public LFOPMIndex(int n) {
            super(10, n);
        }

        public LFOPMIndex() {
            this(0);
        }

        @Override
        protected LFOPMIndex create(int n) {
            return new LFOPMIndex(n, true);
        }
    }

    private static class Slot {
        private int[] wavetable;
        private final FreqIndex phase = new FreqIndex();
        private FreqIndex freq = new FreqIndex();
        private int TL;
        private int TLL;
        private int egout;
        private int sl;
        private EnvelopeState state;
        private final int[] op1_out = new int[2];
        private boolean eg_sustain;
        private int fb_shift = 0;
        private int key;
        private int[] eg_sel_dp;
        private int[] eg_sel_ar;
        private int[] eg_sel_dr;
        private int[] eg_sel_rr;
        private int[] eg_sel_rs;
        private int eg_mask_dp;
        private int eg_mask_ar;
        private int eg_mask_dr;
        private int eg_mask_rr;
        private int eg_mask_rs;
        private int eg_sh_dp;
        private int eg_sh_ar;
        private int eg_sh_dr;
        private int eg_sh_rr;
        private int eg_sh_rs;
        private int ar;
        private int dr;
        private int rr;
        private int KSR;
        private int ksl;
        private int mul;
        private int AMmask;
        private boolean vib;
        private final Slot mod;

        public Slot() {
            this(null);
        }

        public Slot(Slot slot) {
            this.op1_out[1] = 0;
            this.op1_out[0] = 0;
            this.sl = 0;
            this.egout = 0;
            this.TLL = 0;
            this.TL = 0;
            this.eg_sel_rs = eg_inc[0];
            this.eg_sel_rr = this.eg_sel_rs;
            this.eg_sel_dr = this.eg_sel_rs;
            this.eg_sel_ar = this.eg_sel_rs;
            this.eg_sel_dp = this.eg_sel_rs;
            this.eg_mask_rs = 0;
            this.eg_mask_rr = 0;
            this.eg_mask_dr = 0;
            this.eg_mask_ar = 0;
            this.eg_mask_dp = 0;
            this.eg_sustain = false;
            this.setEnvelopeState(EnvelopeState.EG_OFF);
            this.vib = false;
            this.wavetable = sin[0];
            this.mod = slot;
        }

        protected void finishDumpPhase() {
            if (this.state != EnvelopeState.EG_OFF) {
                this.egout = 255;
                this.setEnvelopeState(EnvelopeState.EG_ATTACK);
                this.phase.assign(0);
            }
        }

        public final int calc_envelope(Channel channel, int n, boolean bl) {
            switch (this.state) {
                case EG_DUMP: {
                    if ((n & this.eg_mask_dp) != 0) break;
                    this.egout += this.eg_sel_dp[n >> this.eg_sh_dp & 7];
                    if (this.egout < 255) break;
                    this.finishDumpPhase();
                    if (this.mod == null) break;
                    this.mod.finishDumpPhase();
                    break;
                }
                case EG_ATTACK: {
                    if ((n & this.eg_mask_ar) != 0) break;
                    this.egout += ~this.egout * this.eg_sel_ar[n >> this.eg_sh_ar & 7] >> 2;
                    if (this.egout > 0) break;
                    this.egout = 0;
                    this.setEnvelopeState(EnvelopeState.EG_DECAY);
                    break;
                }
                case EG_DECAY: {
                    if ((n & this.eg_mask_dr) != 0) break;
                    this.egout += this.eg_sel_dr[n >> this.eg_sh_dr & 7];
                    if (this.egout < this.sl) break;
                    this.setEnvelopeState(EnvelopeState.EG_SUSTAIN);
                    break;
                }
                case EG_SUSTAIN: {
                    if (this.eg_sustain || (n & this.eg_mask_rr) != 0) break;
                    this.egout += this.eg_sel_rr[n >> this.eg_sh_rr & 7];
                    if (this.egout < 255) break;
                    this.egout = 255;
                    break;
                }
                case EG_RELEASE: {
                    int n2;
                    if (!bl) break;
                    boolean bl2 = !this.eg_sustain || channel.isSustained();
                    int n3 = n2 = bl2 ? this.eg_mask_rs : this.eg_mask_rr;
                    if ((n & n2) != 0) break;
                    int n4 = bl2 ? this.eg_sh_rs : this.eg_sh_rr;
                    int[] nArray = bl2 ? this.eg_sel_rs : this.eg_sel_rr;
                    this.egout += nArray[n >> n4 & 7];
                    if (this.egout < 255) break;
                    this.egout = 255;
                    this.setEnvelopeState(EnvelopeState.EG_OFF);
                    break;
                }
            }
            return this.egout;
        }

        public final int calc_phase(Channel channel, int n, boolean bl) {
            if (bl) {
                this.phase.assign(0);
            }
            if (this.vib) {
                byte by = lfo_pm_table[(channel.getBlockFNum() & 0x1FF) >> 6][n];
                FreqIndex freqIndex = YM2413.fnumToIncrement(channel.getBlockFNum() * 2 + by);
                freqIndex.multiplyAssign(this.mul);
                this.phase.addAssign(freqIndex);
            } else {
                this.phase.addAssign(this.freq);
            }
            return this.phase.toInt();
        }

        public final void updateTotalLevel(Channel channel) {
            this.TLL = this.TL + (channel.getKeyScaleLevelBase() >> this.ksl);
        }

        public final void updateAttackRate(int n) {
            if (this.ar + n < 78) {
                this.eg_sh_ar = eg_rate_shift[this.ar + n];
                this.eg_sel_ar = eg_inc[eg_rate_select[this.ar + n]];
            } else {
                this.eg_sh_ar = 0;
                this.eg_sel_ar = eg_inc[13];
            }
            this.eg_mask_ar = (1 << this.eg_sh_ar) - 1;
        }

        public final void updateDecayRate(int n) {
            this.eg_sh_dr = eg_rate_shift[this.dr + n];
            this.eg_sel_dr = eg_inc[eg_rate_select[this.dr + n]];
            this.eg_mask_dr = (1 << this.eg_sh_dr) - 1;
        }

        public final void updateReleaseRate(int n) {
            this.eg_sh_rr = eg_rate_shift[this.rr + n];
            this.eg_sel_rr = eg_inc[eg_rate_select[this.rr + n]];
            this.eg_mask_rr = (1 << this.eg_sh_rr) - 1;
        }

        public final int calcOutput(Channel channel, int n, boolean bl, int n2, int n3) {
            int n4 = this.calc_envelope(channel, n, bl);
            int n5 = this.TLL + n4 + (n2 & this.AMmask) << 5;
            int n6 = n5 + this.wavetable[n3 & 0x3FF];
            return n6 < 5632 ? tl[n6] : 0;
        }

        public final int calc_slot_mod(Channel channel, int n, boolean bl, int n2, int n3, boolean bl2) {
            int n4 = this.calc_phase(channel, n2, bl2);
            if (this.fb_shift != 0) {
                n4 += this.op1_out[0] + this.op1_out[1] >> this.fb_shift;
            }
            this.op1_out[0] = this.op1_out[1];
            this.op1_out[1] = this.calcOutput(channel, n, bl, n3, n4);
            return this.op1_out[0] << 1;
        }

        public void setKeyOn(KeyPart keyPart) {
            if (this.key == 0) {
                this.setEnvelopeState(EnvelopeState.EG_DUMP);
            }
            this.key |= keyPart.ordinal();
        }

        public void setKeyOff(KeyPart keyPart) {
            if (this.key != 0) {
                this.key &= ~keyPart.ordinal();
                if (this.key == 0 && this.isActive()) {
                    this.setEnvelopeState(EnvelopeState.EG_RELEASE);
                }
            }
        }

        public void setKeyOnOff(KeyPart keyPart, boolean bl) {
            if (bl) {
                this.setKeyOn(keyPart);
            } else {
                this.setKeyOff(keyPart);
            }
        }

        public boolean isActive() {
            return this.state != EnvelopeState.EG_OFF;
        }

        private void setEnvelopeState(EnvelopeState envelopeState) {
            this.state = envelopeState;
        }

        public void setFrequencyMultiplier(int n) {
            this.mul = mul_tab[n];
        }

        public void setKeyScaleRate(boolean bl) {
            this.KSR = bl ? 0 : 2;
        }

        public void setEnvelopeSustained(boolean bl) {
            this.eg_sustain = bl;
        }

        public void setVibrato(boolean bl) {
            this.vib = bl;
        }

        public void setAmplitudeModulation(boolean bl) {
            this.AMmask = bl ? -1 : 0;
        }

        public void setTotalLevel(Channel channel, int n) {
            this.TL = n << 1;
            this.updateTotalLevel(channel);
        }

        public void setKeyScaleLevel(Channel channel, int n) {
            this.ksl = n != 0 ? 3 - n : 31;
            this.updateTotalLevel(channel);
        }

        public void setWaveform(int n) {
            this.wavetable = sin[n];
        }

        public void setFeedbackShift(int n) {
            this.fb_shift = n != 0 ? 8 - n : 0;
        }

        public void setAttackRate(Channel channel, int n) {
            int n2 = channel.getKeyCode() >> this.KSR;
            this.ar = n != 0 ? 16 + (n << 2) : 0;
            this.updateAttackRate(n2);
        }

        public void setDecayRate(Channel channel, int n) {
            int n2 = channel.getKeyCode() >> this.KSR;
            this.dr = n != 0 ? 16 + (n << 2) : 0;
            this.updateDecayRate(n2);
        }

        public void setReleaseRate(Channel channel, int n) {
            int n2 = channel.getKeyCode() >> this.KSR;
            this.rr = n != 0 ? 16 + (n << 2) : 0;
            this.updateReleaseRate(n2);
        }

        public void setSustainLevel(int n) {
            this.sl = sl_tab[n];
        }

        public void updateFrequency(Channel channel) {
            this.updateTotalLevel(channel);
            this.updateGenerators(channel);
        }

        public void resetOperators() {
            this.wavetable = sin[0];
            this.setEnvelopeState(EnvelopeState.EG_OFF);
            this.egout = 255;
        }

        public void updateGenerators(Channel channel) {
            this.freq = (FreqIndex)channel.getFrequencyIncrement().multiply(this.mul);
            int n = channel.getKeyCode() >> this.KSR;
            this.updateAttackRate(n);
            this.updateDecayRate(n);
            this.updateReleaseRate(n);
            int n2 = channel.isSustained() ? 36 : 44;
            this.eg_sh_rs = eg_rate_shift[n2 + n];
            this.eg_sel_rs = eg_inc[eg_rate_select[n2 + n]];
            this.eg_sh_dp = eg_rate_shift[68 + n];
            this.eg_sel_dp = eg_inc[eg_rate_select[68 + n]];
            this.eg_mask_rs = (1 << this.eg_sh_rs) - 1;
            this.eg_mask_dp = (1 << this.eg_sh_dp) - 1;
        }

        private static enum EnvelopeState {
            EG_DUMP,
            EG_ATTACK,
            EG_DECAY,
            EG_SUSTAIN,
            EG_RELEASE,
            EG_OFF;

        }

        private static enum KeyPart {
            NONE,
            MAIN,
            RHYTHM;

        }
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getReg(int var1);

        public int getLatchedRegister();
    }

    private static class StateClone
    implements State {
        private final int[] regs = new int[64];
        private int latchedRegister;

        public StateClone(State state) {
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            int n = 0;
            while (n < this.regs.length) {
                this.regs[n] = state.getReg(n);
                ++n;
            }
            this.latchedRegister = state.getLatchedRegister();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getReg(int n) {
            return this.regs[n];
        }

        @Override
        public int getLatchedRegister() {
            return this.latchedRegister;
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

