/*
 * Decompiled with CFR 0.152.
 */
package sstates.gameboy;

import components.cartridge.GBCartridge;
import components.cpu.LR35902;
import components.sound.GBSoundController;
import components.video.GBLCDController;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import platform.Emulicious;
import sstates.gameboy.GBSaveState;
import system.GameBoy;
import system.GameBoyColor;

public class BESSSaveState
extends GBSaveState {
    protected static final String FOOTER = "BESS";
    private String emulatorName;
    private String romTitle;
    private int globalChecksum;
    private int versionMajor;
    private int versionMinor;
    private String modelIdentifier;
    protected int[] regs = new int[6];
    protected boolean ime;
    protected int ie;
    protected ExecutionState executionState;
    protected int[] memory = new int[128];
    protected int[] ram;
    protected int[] vram;
    protected int[] mbcRam;
    protected int[] oam;
    protected int[] hram;
    protected int[] bgp;
    protected int[] obp;
    protected boolean[] wramInitialized;
    protected boolean[] hramInitialized;
    protected int[] xoam;
    protected int[] mbcWrites;
    protected int[] rtc;
    protected long rtcTimestamp;
    protected long huc3Timestamp;
    protected int[] huc3;
    protected boolean huc3Alarm;
    protected int[][] sgb;
    protected int sgbMultiplayer;

    private BESSSaveState() {
    }

    public BESSSaveState(GameBoy gameBoy) {
        this.emulatorName = Emulicious.TITLE;
        this.versionMajor = 1;
        this.versionMinor = 1;
        this.modelIdentifier = gameBoy instanceof GameBoyColor ? "CCE " : "GDC ";
        GameBoy.State state = gameBoy.getState();
        this.setCPUstate(state.getCPUstate());
        if (state.isStopped()) {
            this.executionState = ExecutionState.STOPPED;
        }
        this.ie = state.getHRam()[255];
        this.ram = new int[state.getWRam().length];
        System.arraycopy(state.getWRam(), 0, this.ram, 0, this.ram.length);
        this.wramInitialized = new boolean[state.getWRamInitialized().length];
        System.arraycopy(state.getWRamInitialized(), 0, this.wramInitialized, 0, this.wramInitialized.length);
        System.arraycopy(state.getHRam(), 0, this.memory, 0, this.memory.length);
        this.hramInitialized = new boolean[state.getHRamInitialized().length];
        System.arraycopy(state.getHRamInitialized(), 0, this.hramInitialized, 0, this.hramInitialized.length);
        this.memory[4] = state.getCounter() >> 8;
        if (gameBoy instanceof GameBoyColor) {
            this.memory[112] = 0xF8 | state.getRegSVBK();
            this.memory[77] = state.isDoubleSpeed() ? 254 : 126;
        }
        this.memory[80] = state.isBootROMenabled() ? 254 : 255;
        this.hram = new int[127];
        System.arraycopy(state.getHRam(), 128, this.hram, 0, this.hram.length);
        this.setLCDstate(state.getLCDstate());
        this.setSoundState(state.getSoundState());
        this.setCartridgeState(state.getCartridgeState().toWriteBased());
    }

    private void setCPUstate(LR35902.State state) {
        this.regs[0] = state.getRegPC();
        this.regs[1] = state.getRegAF();
        this.regs[2] = state.getRegBC();
        this.regs[3] = state.getRegDE();
        this.regs[4] = state.getRegHL();
        this.regs[5] = state.getRegSP();
        this.ime = state.isFlagIME();
        this.executionState = state.isHalted() ? ExecutionState.HALTED : ExecutionState.RUNNING;
    }

    private void setLCDstate(GBLCDController.State state) {
        this.vram = new int[state.getVram().length];
        System.arraycopy(state.getVram(), 0, this.vram, 0, this.vram.length);
        this.memory[74] = state.getRegWY();
        this.memory[75] = state.getRegWX();
        this.memory[65] = state.getRegSTAT();
        this.memory[66] = state.getRegSCY();
        this.memory[67] = state.getRegSCX();
        this.memory[73] = state.getRegOBP1();
        this.memory[72] = state.getRegOBP0();
        this.memory[69] = state.getRegLYC();
        this.memory[68] = state.getRegLY();
        this.memory[64] = state.getRegLCDC();
        this.memory[70] = state.getRegDMA();
        this.memory[71] = state.getRegBGP();
        try {
            int n;
            long l;
            this.memory[76] = state.getMode();
            this.memory[79] = 0xFE | state.getRegVBK();
            this.memory[85] = state.getRegHDMA5();
            this.memory[84] = 255;
            this.memory[83] = 255;
            this.memory[82] = 255;
            this.memory[81] = 255;
            this.memory[108] = 0xFE | state.getRegOPRI();
            this.memory[106] = 0x40 | state.getRegOBPI();
            this.memory[104] = 0x40 | state.getRegBGPI();
            this.obp = new int[64];
            int n2 = 0;
            while (n2 < this.obp.length) {
                l = state.getOBP(n2 / 8);
                n = 0;
                while (n < 8) {
                    this.obp[n2 + n] = (int)(l & 0xFFL);
                    l >>= 8;
                    ++n;
                }
                n2 += 8;
            }
            this.bgp = new int[64];
            n2 = 0;
            while (n2 < this.bgp.length) {
                l = state.getBGP(n2 / 8);
                n = 0;
                while (n < 8) {
                    this.bgp[n2 + n] = (int)(l & 0xFFL);
                    l >>= 8;
                    ++n;
                }
                n2 += 8;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        this.oam = new int[state.getOam().length];
        System.arraycopy(state.getOam(), 0, this.oam, 0, this.oam.length);
    }

    private void setSoundState(GBSoundController.State state) {
        System.arraycopy(state.getWavePatternRAM(), 0, this.memory, 48, state.getWavePatternRAM().length);
        this.memory[38] = state.getRegNR52();
        this.memory[37] = state.getRegNR51();
        this.memory[36] = state.getRegNR50();
        this.memory[35] = state.getRegNR44() | 0xBF;
        this.memory[34] = state.getRegNR43();
        this.memory[33] = state.getRegNR42();
        this.memory[32] = 255;
        this.memory[30] = state.getRegNR34() | 0xBF;
        this.memory[29] = 255;
        this.memory[28] = state.getRegNR32() | 0x9F;
        this.memory[27] = 255;
        this.memory[26] = state.getRegNR30() | 0x7F;
        this.memory[25] = state.getRegNR24() | 0xBF;
        this.memory[24] = 255;
        this.memory[23] = state.getRegNR22();
        this.memory[22] = state.getRegNR21() | 0x3F;
        this.memory[20] = state.getRegNR14() | 0xBF;
        this.memory[19] = 255;
        this.memory[18] = state.getRegNR12();
        this.memory[17] = state.getRegNR11() | 0x3F;
        this.memory[16] = 0x80 | state.getRegNR10();
    }

    private void setCartridgeState(GBCartridge.WriteBasedState writeBasedState) {
        int[] nArray = writeBasedState.getWrites();
        if (nArray != null) {
            this.mbcWrites = new int[nArray.length];
            System.arraycopy(nArray, 0, this.mbcWrites, 0, this.mbcWrites.length);
        }
        this.mbcRam = new int[writeBasedState.getRAM().length];
        System.arraycopy(writeBasedState.getRAM(), 0, this.mbcRam, 0, this.mbcRam.length);
    }

    private static int readPointer(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[4 + FOOTER.length()];
        randomAccessFile.seek(randomAccessFile.length() - (long)byArray.length);
        randomAccessFile.read(byArray);
        return FOOTER.equals(new String(byArray, 4, 4)) ? BESSSaveState.readInt(byArray, 0) : -1;
    }

    private static int readInt(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 0] & 0xFF;
    }

    private static void readBuffer(int[] nArray, int n, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(n);
        byte[] byArray = new byte[nArray.length];
        randomAccessFile.read(byArray);
        int n2 = 0;
        while (n2 < byArray.length) {
            nArray[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
    }

    public static BESSSaveState from(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n = BESSSaveState.readPointer(randomAccessFile);
        if (n < 0) {
            randomAccessFile.close();
            return null;
        }
        long l = randomAccessFile.length();
        BESSSaveState bESSSaveState = new BESSSaveState();
        byte[] byArray = new byte[8];
        randomAccessFile.seek(n);
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int[] nArray = null;
        try {
            int n9;
            boolean bl2 = false;
            while (!bl2) {
                if (randomAccessFile.read(byArray) != byArray.length) {
                    throw new IllegalArgumentException("Unexpected EOF encountered");
                }
                n9 = Math.min((int)(l - randomAccessFile.getFilePointer()), BESSSaveState.readInt(byArray, 4));
                byte[] byArray2 = new byte[n9];
                randomAccessFile.read(byArray2);
                IllegalArgumentException illegalArgumentException = null;
                try {
                    switch (Block.valueOf(new String(byArray, 0, 4).trim())) {
                        case NAME: {
                            bESSSaveState.emulatorName = new String(byArray2);
                            break;
                        }
                        case INFO: {
                            bESSSaveState.romTitle = new String(byArray2, 0, 16);
                            bESSSaveState.globalChecksum = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF;
                            break;
                        }
                        case CORE: {
                            if (bl) {
                                illegalArgumentException = new IllegalArgumentException("Duplicate CORE block");
                                break;
                            }
                            bl = true;
                            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN);
                            bESSSaveState.versionMajor = byteBuffer.getShort() & 0xFFFF;
                            bESSSaveState.versionMinor = byteBuffer.getShort() & 0xFFFF;
                            byte[] byArray3 = new byte[4];
                            byteBuffer.get(byArray3);
                            bESSSaveState.modelIdentifier = new String(byArray3);
                            int n10 = 0;
                            while (n10 < bESSSaveState.regs.length) {
                                bESSSaveState.regs[n10] = byteBuffer.getShort() & 0xFFFF;
                                ++n10;
                            }
                            bESSSaveState.ime = byteBuffer.get() != 0;
                            bESSSaveState.ie = byteBuffer.get() & 0xFF;
                            bESSSaveState.executionState = ExecutionState.values()[(byteBuffer.get() & 0xFF) % ExecutionState.values().length];
                            byteBuffer.get();
                            byte[] byArray4 = new byte[bESSSaveState.memory.length];
                            byteBuffer.get(byArray4);
                            int n11 = 0;
                            while (n11 < byArray4.length) {
                                bESSSaveState.memory[n11] = byArray4[n11] & 0xFF;
                                ++n11;
                            }
                            n11 = byteBuffer.getInt();
                            if (n11 < 0) {
                                illegalArgumentException = new IllegalArgumentException("Negative size for RAM");
                                break;
                            }
                            n2 = byteBuffer.getInt();
                            bESSSaveState.ram = new int[n11];
                            n11 = byteBuffer.getInt();
                            if (n11 < 0) {
                                illegalArgumentException = new IllegalArgumentException("Negative size for VRAM");
                                break;
                            }
                            n3 = byteBuffer.getInt();
                            bESSSaveState.vram = new int[n11];
                            n11 = byteBuffer.getInt();
                            if (n11 < 0) {
                                illegalArgumentException = new IllegalArgumentException("Negative size for MBC RAM");
                                break;
                            }
                            n4 = byteBuffer.getInt();
                            bESSSaveState.mbcRam = new int[n11];
                            n11 = byteBuffer.getInt();
                            if (n11 < 0) {
                                illegalArgumentException = new IllegalArgumentException("Negative size for OAM");
                                break;
                            }
                            n5 = byteBuffer.getInt();
                            bESSSaveState.oam = new int[n11];
                            n11 = byteBuffer.getInt();
                            if (n11 < 0) {
                                illegalArgumentException = new IllegalArgumentException("Negative size for HRAM");
                                break;
                            }
                            n6 = byteBuffer.getInt();
                            bESSSaveState.hram = new int[n11];
                            n11 = byteBuffer.getInt();
                            if (n11 < 0) {
                                illegalArgumentException = new IllegalArgumentException("Negative size for BGP");
                                break;
                            }
                            n7 = byteBuffer.getInt();
                            bESSSaveState.bgp = new int[n11];
                            n11 = byteBuffer.getInt();
                            if (n11 < 0) {
                                illegalArgumentException = new IllegalArgumentException("Negative size for OBP");
                                break;
                            }
                            n8 = byteBuffer.getInt();
                            bESSSaveState.obp = new int[n11];
                            break;
                        }
                        case XOAM: {
                            ByteBuffer byteBuffer;
                            if (n9 == 96) {
                                byteBuffer = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN);
                                bESSSaveState.xoam = new int[n9];
                                int n12 = 0;
                                while (n12 < bESSSaveState.xoam.length) {
                                    bESSSaveState.xoam[n12] = byteBuffer.get() & 0xFF;
                                    ++n12;
                                }
                                break;
                            }
                            illegalArgumentException = new IllegalArgumentException("Invalid length of XOAM: " + n9);
                            break;
                        }
                        case MBC: {
                            ByteBuffer byteBuffer;
                            if (n9 % 3 == 0) {
                                byteBuffer = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN);
                                bESSSaveState.mbcWrites = new int[n9 / 3 * 2];
                                int n13 = 0;
                                while (n13 < bESSSaveState.mbcWrites.length) {
                                    bESSSaveState.mbcWrites[n13] = byteBuffer.getShort() & 0xFFFF;
                                    bESSSaveState.mbcWrites[n13 + 1] = byteBuffer.get() & 0xFF;
                                    n13 += 2;
                                }
                                break;
                            }
                            illegalArgumentException = new IllegalArgumentException("Invalid length of MBC (not a multiple of 3): " + n9);
                            break;
                        }
                        case RTC: {
                            ByteBuffer byteBuffer;
                            if (n9 == 48) {
                                byteBuffer = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN);
                                bESSSaveState.rtc = new int[(n9 - 8) / 4];
                                int n14 = 0;
                                while (n14 < bESSSaveState.rtc.length) {
                                    bESSSaveState.rtc[n14] = byteBuffer.getInt();
                                    ++n14;
                                }
                                bESSSaveState.rtcTimestamp = byteBuffer.getLong();
                                break;
                            }
                            illegalArgumentException = new IllegalArgumentException("Invalid length of RTC: " + n9);
                            break;
                        }
                        case HUC3: {
                            ByteBuffer byteBuffer;
                            if (n9 == 17) {
                                byteBuffer = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN);
                                bESSSaveState.huc3Timestamp = byteBuffer.getLong();
                                bESSSaveState.huc3 = new int[(n9 - 9) / 2];
                                int n15 = 0;
                                while (n15 < bESSSaveState.huc3.length) {
                                    bESSSaveState.huc3[n15] = byteBuffer.getShort() & 0xFFFF;
                                    ++n15;
                                }
                                bESSSaveState.huc3Alarm = byteBuffer.get() != 0;
                                break;
                            }
                            illegalArgumentException = new IllegalArgumentException("Invalid length of HUC3: " + n9);
                            break;
                        }
                        case SGB: {
                            ByteBuffer byteBuffer;
                            if (n9 == 57) {
                                byteBuffer = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN);
                                nArray = new int[(n9 - 1) / 4];
                                int n16 = 0;
                                while (n16 < nArray.length) {
                                    nArray[n16] = byteBuffer.getInt();
                                    ++n16;
                                }
                                bESSSaveState.sgbMultiplayer = byteBuffer.get() & 0xFF;
                                break;
                            }
                            illegalArgumentException = new IllegalArgumentException("Invalid length of SGB: " + n9);
                            break;
                        }
                        case END: {
                            if (n9 != 0) {
                                illegalArgumentException = new IllegalArgumentException("END block with non-zero length: " + n9);
                            }
                            bl2 = true;
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException2) {}
                if (illegalArgumentException == null) continue;
                throw illegalArgumentException;
            }
            if (!bl) {
                throw new IllegalArgumentException("Missing CORE block");
            }
            System.out.println("Loading BESS Savestate version " + bESSSaveState.versionMajor + "." + bESSSaveState.versionMinor + " for " + bESSSaveState.modelIdentifier + " from " + bESSSaveState.emulatorName);
            if (nArray != null) {
                bESSSaveState.sgb = new int[nArray.length / 2][];
                n9 = 0;
                while (n9 < bESSSaveState.sgb.length) {
                    bESSSaveState.sgb[n9] = new int[nArray[n9 * 2]];
                    BESSSaveState.readBuffer(bESSSaveState.sgb[n9], nArray[n9 * 2 + 1], randomAccessFile);
                    ++n9;
                }
            }
            BESSSaveState.readBuffer(bESSSaveState.ram, n2, randomAccessFile);
            BESSSaveState.readBuffer(bESSSaveState.vram, n3, randomAccessFile);
            BESSSaveState.readBuffer(bESSSaveState.mbcRam, n4, randomAccessFile);
            BESSSaveState.readBuffer(bESSSaveState.oam, n5, randomAccessFile);
            BESSSaveState.readBuffer(bESSSaveState.hram, n6, randomAccessFile);
            BESSSaveState.readBuffer(bESSSaveState.bgp, n7, randomAccessFile);
            BESSSaveState.readBuffer(bESSSaveState.obp, n8, randomAccessFile);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            randomAccessFile.close();
            throw illegalArgumentException;
        }
        randomAccessFile.close();
        bESSSaveState.wramInitialized = new boolean[bESSSaveState.ram.length];
        Arrays.fill(bESSSaveState.wramInitialized, true);
        bESSSaveState.hramInitialized = new boolean[bESSSaveState.hram.length];
        Arrays.fill(bESSSaveState.hramInitialized, true);
        return bESSSaveState;
    }

    @Override
    public void writeToFile(File file) throws IOException {
        int n;
        int[] nArray;
        int n2;
        int n3;
        int n4;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int n5 = n4 = 0;
        int n6 = n4 += BESSSaveState.writeBuffer(bufferedOutputStream, this.ram);
        int n7 = n4 += BESSSaveState.writeBuffer(bufferedOutputStream, this.vram);
        int n8 = n4 += BESSSaveState.writeBuffer(bufferedOutputStream, this.mbcRam);
        int n9 = n4 += BESSSaveState.writeBuffer(bufferedOutputStream, this.oam);
        int n10 = n3 = this.bgp != null ? (n4 += BESSSaveState.writeBuffer(bufferedOutputStream, this.hram)) : 0;
        if (this.bgp != null) {
            n4 += BESSSaveState.writeBuffer(bufferedOutputStream, this.bgp);
        }
        int n11 = n2 = this.obp != null ? n4 : 0;
        if (this.obp != null) {
            n4 += BESSSaveState.writeBuffer(bufferedOutputStream, this.obp);
        }
        int[] nArray2 = nArray = this.sgb != null ? new int[this.sgb.length] : null;
        if (nArray != null) {
            n = 0;
            while (n < nArray.length) {
                nArray[n] = n4;
                n4 += BESSSaveState.writeBuffer(bufferedOutputStream, this.sgb[n]);
                ++n;
            }
        }
        n = n4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(208).order(ByteOrder.LITTLE_ENDIAN);
        BESSSaveState.putBlockHeader(Block.NAME, Emulicious.TITLE.length(), byteBuffer);
        byteBuffer.put(Emulicious.TITLE.getBytes());
        BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        if (this.romTitle != null) {
            BESSSaveState.putBlockHeader(Block.INFO, 18, byteBuffer);
            byteBuffer.put(this.romTitle.getBytes());
            byteBuffer.putShort((short)this.globalChecksum);
            BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        }
        BESSSaveState.putBlockHeader(Block.CORE, 208, byteBuffer);
        byteBuffer.putShort((short)this.versionMajor);
        byteBuffer.putShort((short)this.versionMinor);
        byteBuffer.put(this.modelIdentifier.getBytes());
        int n12 = 0;
        while (n12 < this.regs.length) {
            byteBuffer.putShort((short)this.regs[n12]);
            ++n12;
        }
        byteBuffer.put((byte)(this.ime ? 1 : 0));
        byteBuffer.put((byte)this.ie);
        byteBuffer.put((byte)this.executionState.ordinal());
        byteBuffer.put((byte)0);
        BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        BESSSaveState.writeBuffer(bufferedOutputStream, this.memory);
        byteBuffer.putInt(this.ram.length);
        byteBuffer.putInt(n5);
        byteBuffer.putInt(this.vram.length);
        byteBuffer.putInt(n6);
        byteBuffer.putInt(this.mbcRam.length);
        byteBuffer.putInt(n7);
        byteBuffer.putInt(this.oam.length);
        byteBuffer.putInt(n8);
        byteBuffer.putInt(this.hram.length);
        byteBuffer.putInt(n9);
        byteBuffer.putInt(this.bgp != null ? this.bgp.length : 0);
        byteBuffer.putInt(n3);
        byteBuffer.putInt(this.obp != null ? this.obp.length : 0);
        byteBuffer.putInt(n2);
        BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        if (this.xoam != null) {
            BESSSaveState.putBlockHeader(Block.XOAM, this.xoam.length, byteBuffer);
            BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
            BESSSaveState.writeBuffer(bufferedOutputStream, this.xoam);
        }
        if (this.mbcWrites != null) {
            BESSSaveState.putBlockHeader(Block.MBC, this.mbcWrites.length / 2 * 3, byteBuffer);
            n12 = 0;
            while (n12 < this.mbcWrites.length) {
                byteBuffer.putShort((short)this.mbcWrites[n12]);
                byteBuffer.put((byte)this.mbcWrites[n12 + 1]);
                n12 += 2;
            }
            BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        }
        if (this.rtc != null) {
            BESSSaveState.putBlockHeader(Block.RTC, this.rtc.length * 4 + 8, byteBuffer);
            n12 = 0;
            while (n12 < this.rtc.length) {
                byteBuffer.putInt(this.rtc[n12]);
                ++n12;
            }
            byteBuffer.putLong(this.rtcTimestamp);
            BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        }
        if (this.huc3 != null) {
            BESSSaveState.putBlockHeader(Block.HUC3, 8 + this.huc3.length * 2 + 1, byteBuffer);
            byteBuffer.putLong(this.huc3Timestamp);
            n12 = 0;
            while (n12 < this.huc3.length) {
                byteBuffer.putShort((short)this.huc3[n12]);
                ++n12;
            }
            byteBuffer.put((byte)(this.huc3Alarm ? 1 : 0));
            BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        }
        if (nArray != null) {
            BESSSaveState.putBlockHeader(Block.SGB, this.sgb.length * 2 * 4 + 1, byteBuffer);
            n12 = 0;
            while (n12 < this.sgb.length) {
                byteBuffer.putInt(this.sgb[n12].length);
                byteBuffer.putInt(nArray[n12]);
                ++n12;
            }
            byteBuffer.put((byte)this.sgbMultiplayer);
            BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        }
        BESSSaveState.putBlockHeader(Block.END, 0, byteBuffer);
        BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        byteBuffer.putInt(n);
        BESSSaveState.writeByteBuffer(bufferedOutputStream, byteBuffer);
        bufferedOutputStream.write(FOOTER.getBytes());
        bufferedOutputStream.close();
    }

    private static void putBlockHeader(Block block, int n, ByteBuffer byteBuffer) {
        byteBuffer.put(block.toString().getBytes());
        byteBuffer.putInt(n);
    }

    private static void writeByteBuffer(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        outputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        byteBuffer.clear();
    }

    private static int writeBuffer(OutputStream outputStream, int[] nArray) throws IOException {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        outputStream.write(byArray);
        return byArray.length;
    }

    @Override
    public GameBoy.State getState() {
        final int[] nArray = new int[]{204, 456, 80, 172};
        return new GameBoy.UnmodifiableState(){

            @Override
            public GameBoy.State clone() {
                return this;
            }

            @Override
            public boolean isPrevSTATline() {
                return false;
            }

            @Override
            public boolean isDoubleSpeed() {
                return (BESSSaveState.this.memory[77] & 0x80) != 0;
            }

            @Override
            public boolean isDmgMode() {
                return (BESSSaveState.this.memory[76] & 4) != 0;
            }

            @Override
            public boolean isBootROMenabled() {
                return (BESSSaveState.this.memory[80] & 1) == 0;
            }

            @Override
            public boolean isStopped() {
                return BESSSaveState.this.executionState == ExecutionState.STOPPED;
            }

            @Override
            public int getDmaCounter() {
                return 0;
            }

            @Override
            public int getDmaSource() {
                return 0;
            }

            @Override
            public int getTimerDMA() {
                return 0;
            }

            @Override
            public boolean isDmaJustStarted() {
                return false;
            }

            @Override
            public boolean isDmaStillRunning() {
                return false;
            }

            @Override
            public int[] getWRam() {
                return BESSSaveState.this.ram;
            }

            @Override
            public GameBoy.TIMAState getTimaState() {
                return GameBoy.TIMAState.REGULAR;
            }

            @Override
            public GBSoundController.State getSoundState() {
                return new GBSoundController.UnmodifiableState(){

                    @Override
                    public GBSoundController.State clone() {
                        return this;
                    }

                    @Override
                    public boolean isWaveChannelJustEnabled() {
                        return false;
                    }

                    @Override
                    public int[] getWavePatternRAM() {
                        int[] nArray = new int[16];
                        int n = 0;
                        while (n < nArray.length) {
                            nArray[n] = (this).BESSSaveState.this.memory[48 + n];
                            ++n;
                        }
                        return nArray;
                    }

                    @Override
                    public int getVolume(int n) {
                        return 0;
                    }

                    @Override
                    public int getSample(int n) {
                        return 0;
                    }

                    @Override
                    public int getLength(int n) {
                        return 0;
                    }

                    @Override
                    public int getRegNR52() {
                        return (this).BESSSaveState.this.memory[38];
                    }

                    @Override
                    public int getRegNR51() {
                        return (this).BESSSaveState.this.memory[37];
                    }

                    @Override
                    public int getRegNR50() {
                        return (this).BESSSaveState.this.memory[36];
                    }

                    @Override
                    public int getRegNR44() {
                        return (this).BESSSaveState.this.memory[35];
                    }

                    @Override
                    public int getRegNR43() {
                        return (this).BESSSaveState.this.memory[34];
                    }

                    @Override
                    public int getRegNR42() {
                        return (this).BESSSaveState.this.memory[33];
                    }

                    @Override
                    public int getRegNR41() {
                        return (this).BESSSaveState.this.memory[32];
                    }

                    @Override
                    public int getRegNR34() {
                        return (this).BESSSaveState.this.memory[30];
                    }

                    @Override
                    public int getRegNR33() {
                        return (this).BESSSaveState.this.memory[29];
                    }

                    @Override
                    public int getRegNR32() {
                        return (this).BESSSaveState.this.memory[28];
                    }

                    @Override
                    public int getRegNR31() {
                        return (this).BESSSaveState.this.memory[27];
                    }

                    @Override
                    public int getRegNR30() {
                        return (this).BESSSaveState.this.memory[26];
                    }

                    @Override
                    public int getRegNR24() {
                        return (this).BESSSaveState.this.memory[25];
                    }

                    @Override
                    public int getRegNR23() {
                        return (this).BESSSaveState.this.memory[24];
                    }

                    @Override
                    public int getRegNR22() {
                        return (this).BESSSaveState.this.memory[23];
                    }

                    @Override
                    public int getRegNR21() {
                        return (this).BESSSaveState.this.memory[22];
                    }

                    @Override
                    public int getRegNR14() {
                        return (this).BESSSaveState.this.memory[20];
                    }

                    @Override
                    public int getRegNR13() {
                        return (this).BESSSaveState.this.memory[19];
                    }

                    @Override
                    public int getRegNR12() {
                        return (this).BESSSaveState.this.memory[18];
                    }

                    @Override
                    public int getRegNR11() {
                        return (this).BESSSaveState.this.memory[17];
                    }

                    @Override
                    public int getRegNR10() {
                        return (this).BESSSaveState.this.memory[16];
                    }

                    @Override
                    public int getNoiseCounter() {
                        return 0;
                    }

                    @Override
                    public int getNoiseCounterOffset() {
                        return 0;
                    }

                    @Override
                    public boolean isNoiseCounterJustReloaded() {
                        return false;
                    }

                    @Override
                    public int getRegLinearFeedbackShift() {
                        return 0;
                    }

                    @Override
                    public int getPhase() {
                        return 0;
                    }

                    @Override
                    public int getOutput(int n) {
                        return 0;
                    }

                    @Override
                    public int getGeneratorPhase(int n) {
                        return 0;
                    }

                    @Override
                    public int getSweepFrequency() {
                        return 0;
                    }

                    @Override
                    public int getSweepAddend() {
                        return 0;
                    }

                    @Override
                    public int getSweepRestartHold() {
                        return 0;
                    }

                    @Override
                    public boolean isSweepUnshifted() {
                        return false;
                    }

                    @Override
                    public GBSoundController.EnableState getEnableState() {
                        return GBSoundController.EnableState.ENABLED;
                    }

                    @Override
                    public int getSweepCounter() {
                        return 0;
                    }

                    @Override
                    public int getDelayEnvelope(int n) {
                        return 0;
                    }

                    @Override
                    public boolean isEnvelopeCanClock(int n) {
                        return false;
                    }

                    @Override
                    public int getCounter(int n) {
                        return 0;
                    }

                    @Override
                    public int getSamples(int n) {
                        return 0;
                    }
                };
            }

            @Override
            public int getSerialCounter() {
                return 0;
            }

            @Override
            public boolean[] getWRamInitialized() {
                return BESSSaveState.this.wramInitialized;
            }

            @Override
            public boolean[] getHRamInitialized() {
                return BESSSaveState.this.hramInitialized;
            }

            @Override
            public int getRegSVBK() {
                return BESSSaveState.this.memory[112];
            }

            @Override
            public GBLCDController.State getLCDstate() {
                return new GBLCDController.UnmodifiableState(){

                    @Override
                    public GBLCDController.State clone() {
                        return this;
                    }

                    @Override
                    public boolean isMode3lastCycles() {
                        return false;
                    }

                    @Override
                    public boolean isLineMainPart() {
                        return (this.getRegSTAT() & 3) == 0;
                    }

                    @Override
                    public boolean isLineLastCycle() {
                        return false;
                    }

                    @Override
                    public boolean isFirstFrame() {
                        return false;
                    }

                    @Override
                    public boolean isHdmaReady() {
                        return false;
                    }

                    @Override
                    public boolean isWySatisfied() {
                        return false;
                    }

                    @Override
                    public int getWindowLine() {
                        return 0;
                    }

                    @Override
                    public int[] getVram() {
                        return (this).BESSSaveState.this.vram;
                    }

                    @Override
                    public int getTimer() {
                        return nArray[this.getRegSTAT() & 3];
                    }

                    @Override
                    public int getRegWY() {
                        return (this).BESSSaveState.this.memory[74];
                    }

                    @Override
                    public int getRegWX() {
                        return (this).BESSSaveState.this.memory[75];
                    }

                    @Override
                    public int getRegVBK() {
                        return (this).BESSSaveState.this.memory[79];
                    }

                    @Override
                    public int getRegSTAT() {
                        return (this).BESSSaveState.this.memory[65];
                    }

                    @Override
                    public int getRegSCY() {
                        return (this).BESSSaveState.this.memory[66];
                    }

                    @Override
                    public int getRegSCX() {
                        return (this).BESSSaveState.this.memory[67];
                    }

                    @Override
                    public int getRegOPRI() {
                        return (this).BESSSaveState.this.memory[108];
                    }

                    @Override
                    public int getRegOBPI() {
                        return (this).BESSSaveState.this.memory[106];
                    }

                    @Override
                    public int getRegOBP1() {
                        return (this).BESSSaveState.this.memory[73];
                    }

                    @Override
                    public int getRegOBP0() {
                        return (this).BESSSaveState.this.memory[72];
                    }

                    @Override
                    public int getRegLYC() {
                        return (this).BESSSaveState.this.memory[69];
                    }

                    @Override
                    public int getRegLY() {
                        return (this).BESSSaveState.this.memory[68];
                    }

                    @Override
                    public int getRegLCDC() {
                        return (this).BESSSaveState.this.memory[64];
                    }

                    @Override
                    public int getRegHDMA5() {
                        return (this).BESSSaveState.this.memory[85];
                    }

                    @Override
                    public int getRegHDMA4() {
                        return (this).BESSSaveState.this.memory[84];
                    }

                    @Override
                    public int getRegHDMA3() {
                        return (this).BESSSaveState.this.memory[83];
                    }

                    @Override
                    public int getRegHDMA2() {
                        return (this).BESSSaveState.this.memory[82];
                    }

                    @Override
                    public int getRegHDMA1() {
                        return (this).BESSSaveState.this.memory[81];
                    }

                    @Override
                    public int getRegDMA() {
                        return (this).BESSSaveState.this.memory[70];
                    }

                    @Override
                    public int getRegBGPI() {
                        return (this).BESSSaveState.this.memory[104];
                    }

                    @Override
                    public int getRegBGP() {
                        return (this).BESSSaveState.this.memory[71];
                    }

                    @Override
                    public int[] getOam() {
                        return (this).BESSSaveState.this.oam;
                    }

                    @Override
                    public boolean hasCGBpalettes() {
                        return (this).BESSSaveState.this.bgp != null && (this).BESSSaveState.this.obp != null;
                    }

                    @Override
                    public long getOBP(int n) {
                        if ((this).BESSSaveState.this.obp == null || n * 8 + 7 >= (this).BESSSaveState.this.obp.length) {
                            return 0L;
                        }
                        return (long)(this).BESSSaveState.this.obp[n * 8 + 7] << 56 | (long)(this).BESSSaveState.this.obp[n * 8 + 6] << 48 | (long)(this).BESSSaveState.this.obp[n * 8 + 5] << 40 | (long)(this).BESSSaveState.this.obp[n * 8 + 4] << 32 | (long)(this).BESSSaveState.this.obp[n * 8 + 3] << 24 | (long)(this).BESSSaveState.this.obp[n * 8 + 2] << 16 | (long)(this).BESSSaveState.this.obp[n * 8 + 1] << 8 | (long)(this).BESSSaveState.this.obp[n * 8];
                    }

                    @Override
                    public int getMode3additionalTime() {
                        return 0;
                    }

                    @Override
                    public int getMode() {
                        return (this).BESSSaveState.this.memory[76];
                    }

                    @Override
                    public int getLine153cycles() {
                        return 0;
                    }

                    @Override
                    public long getBGP(int n) {
                        if ((this).BESSSaveState.this.bgp == null || n * 8 + 7 >= (this).BESSSaveState.this.bgp.length) {
                            return 0L;
                        }
                        return (long)(this).BESSSaveState.this.bgp[n * 8 + 7] << 56 | (long)(this).BESSSaveState.this.bgp[n * 8 + 6] << 48 | (long)(this).BESSSaveState.this.bgp[n * 8 + 5] << 40 | (long)(this).BESSSaveState.this.bgp[n * 8 + 4] << 32 | (long)(this).BESSSaveState.this.bgp[n * 8 + 3] << 24 | (long)(this).BESSSaveState.this.bgp[n * 8 + 2] << 16 | (long)(this).BESSSaveState.this.bgp[n * 8 + 1] << 8 | (long)(this).BESSSaveState.this.bgp[n * 8];
                    }
                };
            }

            @Override
            public int[] getHRam() {
                int[] nArray2 = new int[256];
                System.arraycopy(BESSSaveState.this.memory, 0, nArray2, 0, BESSSaveState.this.memory.length);
                System.arraycopy(BESSSaveState.this.hram, 0, nArray2, 128, BESSSaveState.this.hram.length);
                nArray2[255] = BESSSaveState.this.ie;
                return nArray2;
            }

            @Override
            public int getCounter() {
                return BESSSaveState.this.memory[4] << 8;
            }

            @Override
            public GBCartridge.State getCartridgeState() {
                return new GBCartridge.UnmodifiableWriteBasedState(){

                    @Override
                    public GBCartridge.State clone() {
                        return this;
                    }

                    @Override
                    public GBCartridge.WriteBasedState toWriteBased() {
                        return this;
                    }

                    @Override
                    public int[] getWrites() {
                        return (this).BESSSaveState.this.mbcWrites;
                    }

                    @Override
                    public int[] getRAM() {
                        return (this).BESSSaveState.this.mbcRam;
                    }

                    @Override
                    public int getClockCycles() {
                        return 0;
                    }

                    @Override
                    public int getClockSeconds() {
                        return (this).BESSSaveState.this.rtc[0];
                    }

                    @Override
                    public int getClockMinutes() {
                        return (this).BESSSaveState.this.rtc[1];
                    }

                    @Override
                    public int getClockLatchedSeconds() {
                        return (this).BESSSaveState.this.rtc[6];
                    }

                    @Override
                    public int getClockLatchedMinutes() {
                        return (this).BESSSaveState.this.rtc[7];
                    }

                    @Override
                    public int getClockLatchedHours() {
                        return (this).BESSSaveState.this.rtc[8];
                    }

                    @Override
                    public int getClockLatchedDays() {
                        return (this).BESSSaveState.this.rtc[9];
                    }

                    @Override
                    public int getClockLatchedControl() {
                        return (this).BESSSaveState.this.rtc[10];
                    }

                    @Override
                    public Date getClockLastTime() {
                        return new Date((this).BESSSaveState.this.rtcTimestamp * 1000L);
                    }

                    @Override
                    public int getClockHours() {
                        return (this).BESSSaveState.this.rtc[3];
                    }

                    @Override
                    public int getClockDays() {
                        return (this).BESSSaveState.this.rtc[4];
                    }

                    @Override
                    public int getClockControl() {
                        return (this).BESSSaveState.this.rtc[5];
                    }
                };
            }

            @Override
            public LR35902.State getCPUstate() {
                return new LR35902.UnmodifiableState(){

                    @Override
                    public LR35902.State clone() {
                        return this;
                    }

                    @Override
                    public boolean isSkip() {
                        return false;
                    }

                    @Override
                    public boolean isJustHalted() {
                        return false;
                    }

                    @Override
                    public boolean isHalted() {
                        return (this).BESSSaveState.this.executionState == ExecutionState.HALTED;
                    }

                    @Override
                    public boolean isLockedUp() {
                        return false;
                    }

                    @Override
                    public boolean isFlagIME() {
                        return (this).BESSSaveState.this.ime;
                    }

                    @Override
                    public boolean isAfterEI() {
                        return false;
                    }

                    @Override
                    public int getRegPC() {
                        return (this).BESSSaveState.this.regs[0];
                    }

                    @Override
                    public int getRegAF() {
                        return (this).BESSSaveState.this.regs[1];
                    }

                    @Override
                    public int getRegBC() {
                        return (this).BESSSaveState.this.regs[2];
                    }

                    @Override
                    public int getRegDE() {
                        return (this).BESSSaveState.this.regs[3];
                    }

                    @Override
                    public int getRegHL() {
                        return (this).BESSSaveState.this.regs[4];
                    }

                    @Override
                    public int getRegSP() {
                        return (this).BESSSaveState.this.regs[5];
                    }

                    @Override
                    public int getCycleCount() {
                        return 0;
                    }
                };
            }
        };
    }

    protected static enum Block {
        NAME,
        CORE,
        INFO,
        XOAM,
        MBC,
        RTC,
        HUC3,
        SGB,
        END;


        public String toString() {
            String string = this.name();
            if (string.length() < 4) {
                StringBuilder stringBuilder = new StringBuilder(string);
                int n = 4 - string.length();
                while (n > 0) {
                    stringBuilder.append(' ');
                    --n;
                }
                return stringBuilder.toString();
            }
            return string;
        }
    }

    private static enum ExecutionState {
        RUNNING,
        HALTED,
        STOPPED;

    }
}

