/*
 * Decompiled with CFR 0.152.
 */
package platform.viewers;

import common.CheckBoxMenuItem;
import common.ClickableJLabel;
import common.MacUtilities;
import common.ScreenUtilities;
import common.WindowsUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import output.TilemapRenderer;
import output.ViewerCache;
import platform.DisplayWindow;
import platform.Emulicious;
import platform.MemoryTracer;
import platform.MemoryTracerWindow;
import platform.viewers.TileViewer;
import platform.viewers.VideoViewer;
import platform.viewers.ViewerWindow;

public class TilemapViewer {
    static TilemapRenderer tilemapRenderer;
    static final Cursor HAND_CURSOR;
    static final Cursor DEFAULT_CURSOR;
    final Window owner;
    final Window window;
    private final ViewerWindow viewerWindow = new ViewerWindow();
    final JCheckBox autoRefresh = new JCheckBox("Auto Refresh");
    private final JComboBox<String> baseAddressSelection;
    private final JComboBox<String> tileBaseAddressSelection;
    private final JLabel displayOnMode = new JLabel();
    private final JLabel scrollHscrollV = new JLabel();
    private final JCheckBox autoPalette = new JCheckBox("Auto Palette", true);
    private final ClickableJLabel index = new ClickableJLabel("0 ($0)"){

        @Override
        protected boolean canClick(int n) {
            return true;
        }

        @Override
        protected void indexClicked(int n) {
            Emulicious.openMemoryEditorVRAM(tilemapRenderer.getVRAMAddressOfTilemapEntry(TilemapViewer.this.getIndex(), TilemapViewer.this.getSelectedBaseAddress(), TilemapViewer.this.viewerCache));
        }
    };
    private final JLabel tile = new JLabel();
    private final JPanel tileIndex = new JPanel(new BorderLayout());
    private final JLabel attributes = new JLabel();
    private final JPanel tileAttributes = new JPanel(new BorderLayout());
    private final MemoryTracerWindow.SourceLabel sourceTile = MemoryTracerWindow.createSourceLabel();
    private final MemoryTracerWindow.SourceLabel sourceAttributes = MemoryTracerWindow.createSourceLabel();
    JPanel north;
    JPanel west;
    JPanel east;
    final FlowLayout northFlowLayout = new FlowLayout();
    final GridLayout northGridLayout = new GridLayout();
    Dimension dimension;
    int selectedIndex;
    private int scrollH = 0;
    private boolean displayOn = false;
    String[] baseAddressNames;
    String[] tileBaseAddressNames;
    int[] tilemapData;
    private long[] sources;
    private String modeName;
    private final ViewerCache viewerCache = new ViewerCache();
    private static TilemapViewer viewer;
    private final Timer refreshTimer = new Timer(50, new ActionListener(){
        private int exceptionCounter;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TilemapViewer.refresh();
                this.exceptionCounter = 0;
            }
            catch (RuntimeException runtimeException) {
                if (++this.exceptionCounter >= 2) {
                    TilemapViewer.this.autoRefresh.setSelected(false);
                    throw runtimeException;
                }
                runtimeException.printStackTrace();
            }
        }
    });
    private final BaseAddressSelectionModel baseAddressSelectionModel;

    static {
        HAND_CURSOR = Cursor.getPredefinedCursor(12);
        DEFAULT_CURSOR = Cursor.getDefaultCursor();
    }

    private TilemapViewer(Window window, boolean bl) {
        Component component;
        this.window = bl ? new JFrame() : new JDialog();
        this.owner = window;
        final ViewerWindow viewerWindow = this.viewerWindow;
        final Timer timer = this.refreshTimer;
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Tilemap Viewer");
        this.window.setIconImages(window.getIconImages());
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            protected void validateTree() {
                TilemapViewer.this.updateNorthLayout();
                super.validateTree();
            }
        };
        this.northFlowLayout.setHgap(2);
        this.north = new JPanel(this.northFlowLayout);
        jPanel.add((Component)this.north, "North");
        this.west = new JPanel(new GridLayout(4, 1, 0, 8));
        jPanel.add((Component)this.west, "West");
        this.east = new JPanel(new GridLayout(4, 1, 0, 8));
        this.east.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.west.setBorder(this.east.getBorder());
        jPanel.add((Component)this.east, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.autoRefresh);
        jPanel2.add(this.createRefreshButton());
        jPanel.add((Component)jPanel2, "South");
        this.baseAddressNames = tilemapRenderer.getBaseAddressNames();
        this.baseAddressSelectionModel = new BaseAddressSelectionModel();
        this.baseAddressSelection = new JComboBox<String>((ComboBoxModel)this.baseAddressSelectionModel){
            private final JList<String> DUMMY_LIST;
            {
                this.DUMMY_LIST = new JList();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (!MacUtilities.isMacOS() && !WindowsUtilities.isWindows()) {
                    dimension.height = this.getRenderer().getListCellRendererComponent(this.DUMMY_LIST, this.getSelectedItem().toString(), (int)0, (boolean)false, (boolean)false).getPreferredSize().height;
                }
                return dimension;
            }
        };
        if (this.baseAddressSelection.getComponentCount() > 0 && (component = this.baseAddressSelection.getComponent(0)) instanceof JComponent) {
            ((JComponent)component).setBorder(null);
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).setMargin(new Insets(0, 0, 0, 0));
            }
        }
        this.baseAddressSelection.setMaximumRowCount(10);
        this.tileBaseAddressNames = tilemapRenderer.getTileBaseAddressNames();
        this.tileBaseAddressSelection = new JComboBox<String>(this.tileBaseAddressNames){
            private final JList<String> DUMMY_LIST;
            {
                this.DUMMY_LIST = new JList();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (!MacUtilities.isMacOS() && !WindowsUtilities.isWindows()) {
                    dimension.height = this.getRenderer().getListCellRendererComponent(this.DUMMY_LIST, this.getSelectedItem().toString(), (int)0, (boolean)false, (boolean)false).getPreferredSize().height;
                }
                return dimension;
            }
        };
        if (this.tileBaseAddressSelection.getComponentCount() > 0 && (component = this.tileBaseAddressSelection.getComponent(0)) instanceof JComponent) {
            ((JComponent)component).setBorder(null);
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).setMargin(new Insets(0, 0, 0, 0));
            }
        }
        this.tileBaseAddressSelection.setMaximumRowCount(10);
        this.window.setLayout(new BorderLayout());
        component = new JPanel(new BorderLayout());
        ((Container)component).add(viewerWindow, "Center");
        ((JComponent)component).setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel(" | Source: "), "West");
        jPanel3.add(this.sourceTile);
        this.tileIndex.add((Component)this.tile, "West");
        this.tileIndex.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JLabel(" | Source: "), "West");
        jPanel4.add(this.sourceAttributes);
        this.tileAttributes.add((Component)this.attributes, "West");
        this.tileAttributes.add((Component)jPanel4, "Center");
        this.updateInfoPanel();
        this.window.add(component, "Center");
        this.window.add((Component)jPanel, "South");
        viewerWindow.setBackground(this.window.getBackground());
        viewerWindow.setIntegerScaling(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TilemapViewerIntegerScaling")));
        viewerWindow.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Dimension dimension = tilemapRenderer.getTilemapDimension(TilemapViewer.isShowGrid());
                int n = tilemapRenderer.getTilemapTileWidth(TilemapViewer.isShowGrid());
                int n2 = tilemapRenderer.getTilemapTileHeight(TilemapViewer.isShowGrid());
                int n3 = viewerWindow.toScreenX(mouseEvent.getX());
                int n4 = viewerWindow.toScreenY(mouseEvent.getY());
                if (n3 >= 0 && n3 < dimension.width && n4 >= 0 && n4 < dimension.height) {
                    int n5 = n4 / n2 * ((dimension.width - 1) / n + 1) + n3 / n;
                    viewerWindow.setHighlightCursor(n3 - n3 % n, n4 - n4 % n2, n - (TilemapViewer.isShowGrid() ? 1 : 0), n2 - (TilemapViewer.isShowGrid() ? 1 : 0));
                    TilemapViewer.this.updateLabels(n5, dimension);
                    viewerWindow.setCursor(HAND_CURSOR);
                    TilemapViewer.this.dimension = dimension;
                    TileViewer.setHighlightedTile(tilemapRenderer.getTilemapEntryTile(n5, TilemapViewer.this.tilemapData, TilemapViewer.this.viewerCache));
                } else {
                    viewerWindow.setCursor(DEFAULT_CURSOR);
                    viewerWindow.hideHighlightCursor();
                    TilemapViewer.this.updateLabels(TilemapViewer.this.selectedIndex, dimension);
                    TileViewer.setHighlightedTile(-1);
                }
            }
        });
        viewerWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = tilemapRenderer.getTilemapDimension(TilemapViewer.isShowGrid());
                int n = tilemapRenderer.getTilemapTileWidth(TilemapViewer.isShowGrid());
                int n2 = tilemapRenderer.getTilemapTileHeight(TilemapViewer.isShowGrid());
                int n3 = viewerWindow.toScreenX(mouseEvent.getX());
                int n4 = viewerWindow.toScreenY(mouseEvent.getY());
                if (n3 >= 0 && n3 < dimension.width && n4 >= 0 && n4 < dimension.height) {
                    int n5 = n4 / n2 * ((dimension.width - 1) / n + 1) + n3 / n;
                    viewerWindow.setSelectionCursor(n3 - n3 % n, n4 - n4 % n2, n - (TilemapViewer.isShowGrid() ? 1 : 0), n2 - (TilemapViewer.isShowGrid() ? 1 : 0));
                    TilemapViewer.this.updateLabels(n5, dimension);
                    viewerWindow.setCursor(HAND_CURSOR);
                    TilemapViewer.this.selectedIndex = n5;
                    TilemapViewer.this.dimension = dimension;
                    TileViewer.setSelectedTile(tilemapRenderer.getTilemapEntryTile(n5, TilemapViewer.this.tilemapData, TilemapViewer.this.viewerCache));
                } else {
                    viewerWindow.setCursor(DEFAULT_CURSOR);
                    viewerWindow.hideHighlightCursor();
                    TilemapViewer.this.updateLabels(TilemapViewer.this.selectedIndex, dimension);
                    TileViewer.setSelectedTile(-1);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                viewerWindow.setCursor(DEFAULT_CURSOR);
                viewerWindow.hideHighlightCursor();
                TilemapViewer.this.updateLabels(TilemapViewer.this.selectedIndex, TilemapViewer.this.dimension);
                TileViewer.setHighlightedTile(-1);
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                timer.stop();
            }
        });
        this.autoRefresh.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                if (jCheckBox.isSelected()) {
                    timer.restart();
                } else {
                    timer.stop();
                }
            }
        });
        this.autoRefresh.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("AutoRefresh" + this.getClass().getSimpleName())));
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = this.makeMenuView();
        jMenuBar.add(jMenu);
        if (tilemapRenderer != null) {
            viewerWindow.setDimensions(tilemapRenderer.getTilemapDimension(TilemapViewer.isShowGrid()));
        }
        viewerWindow.setScale(1.0f);
        this.window.pack();
        this.window.setMinimumSize(this.window.getSize());
        if (viewer == null || !viewer.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                viewerWindow.setScale(1.5f);
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    void updateNorthLayout() {
        if (this.north.getWidth() > 0) {
            if (!(this.north.getLayout() instanceof FlowLayout)) {
                this.north.setLayout(this.northFlowLayout);
            }
            if (this.north.getLayout() instanceof FlowLayout && this.north.getWidth() < this.north.getPreferredSize().width) {
                this.northGridLayout.setRows(3);
                this.northGridLayout.setColumns(1);
                this.north.setLayout(this.northGridLayout);
            }
        }
    }

    private void updateInfoPanel() {
        JPanel jPanel;
        this.updateBaseAddressNames();
        this.north.removeAll();
        this.west.removeAll();
        this.east.removeAll();
        int n = tilemapRenderer.hasTilemapAttributes() ? 5 : 4;
        ((GridLayout)this.west.getLayout()).setRows(n);
        ((GridLayout)this.east.getLayout()).setRows(n);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(new JLabel("Base Address:"));
        jPanel2.add(this.baseAddressSelection);
        this.north.add(jPanel2);
        if (this.tileBaseAddressNames.length > 0) {
            jPanel = new JPanel(new FlowLayout(1, 0, 0));
            jPanel.add(new JLabel("Tile Base Address:"));
            jPanel.add(this.tileBaseAddressSelection);
            this.north.add(jPanel);
        }
        jPanel = new JPanel(new FlowLayout(1, 0, 0));
        jPanel.add(this.autoPalette);
        this.north.add(jPanel);
        this.west.add(new JLabel("Display / Mode: "));
        this.east.add(this.displayOnMode);
        this.west.add(new JLabel("Horiz. / Vert. scroll: "));
        this.east.add(this.scrollHscrollV);
        this.west.add(new JLabel("Index: "));
        this.east.add(this.index);
        this.west.add(new JLabel("Tile Index: "));
        this.east.add(this.tileIndex);
        if (tilemapRenderer.hasTilemapAttributes()) {
            this.west.add(new JLabel("Attributes: "));
            this.east.add(this.tileAttributes);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private Container getContentPane() {
        return this.window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)this.window)).getContentPane() : null;
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private JMenu makeMenuView() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('v');
        final CheckBoxMenuItem checkBoxMenuItem = new CheckBoxMenuItem("Always Scale to Integer Multiples", this.viewerWindow.isIntegerScaling());
        checkBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TilemapViewer.setIntegerScaling(checkBoxMenuItem.isSelected());
            }
        });
        jMenu.add(checkBoxMenuItem);
        final CheckBoxMenuItem checkBoxMenuItem2 = new CheckBoxMenuItem("Show Grid", TilemapViewer.isShowGrid());
        checkBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.getProperties().setProperty("TilemapViewerShowGrid", Boolean.toString(checkBoxMenuItem2.isSelected()));
            }
        });
        jMenu.add(checkBoxMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Combine Video Viewers");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoViewer.open(TilemapViewer.this.owner, "Tilemap", false);
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    void updateLabels(int n, Dimension dimension) {
        this.updateLabels(n, tilemapRenderer.isModeNameDependsOnIndex(), dimension);
    }

    void updateLabels(int n, boolean bl, Dimension dimension) {
        if (dimension != null && this.tilemapData != null && n < this.tilemapData.length) {
            this.displayOn = tilemapRenderer.isDisplayOn(n);
            this.scrollH = tilemapRenderer.getHorizontalScroll(n);
            if (bl) {
                this.modeName = tilemapRenderer.getModeName(n);
            }
            int n2 = tilemapRenderer.getVRAMAddressOfTilemapEntry(n, this.getSelectedBaseAddress(), this.viewerCache);
            int n3 = tilemapRenderer.getVRAMAddressOfTilemapEntryAttributes(n, this.getSelectedBaseAddress(), this.viewerCache);
            int n4 = tilemapRenderer.getTilemapTileWidth(TilemapViewer.isShowGrid());
            String string = tilemapRenderer.getCPUAddressOfTilemapEntry(n, this.getSelectedBaseAddress(), this.viewerCache);
            int n5 = (dimension.width - 1) / n4 + 1;
            if (string != null) {
                this.index.setText(String.format("%d ($%X) @ VRAM %s | row: %d | column: %d", n, n, string, n / n5, n % n5));
            } else {
                this.index.setText(String.format("%d ($%X) @ VRAM %04X | row: %d | column: %d", n, n, n2, n / n5, n % n5));
            }
            int n6 = tilemapRenderer.getTilemapEntryTile(n, this.tilemapData, this.viewerCache);
            int n7 = tilemapRenderer.getTileVRAMaddress(n6);
            String string2 = tilemapRenderer.getTileCPUaddress(n6);
            if (string2 != null) {
                this.tile.setText(String.format("%d ($%X) @ VRAM %s", n6, n6 & 0xFF, string2));
            } else {
                this.tile.setText(String.format("%d ($%X) @ VRAM %04X", n6, n6 & 0xFF, n7));
            }
            this.attributes.setText(tilemapRenderer.getTilemapEntryAttributes(n, this.tilemapData));
            if (this.sources != null && n2 < this.sources.length) {
                this.sourceTile.setSource(this.sources[n2]);
            } else {
                this.sourceTile.setSource(0L);
            }
            if (this.sources != null && n3 < this.sources.length) {
                this.sourceAttributes.setSource(this.sources[n3]);
            } else {
                this.sourceAttributes.setSource(0L);
            }
        }
        this.displayOnMode.setText(String.valueOf(this.displayOn ? "on" : "off") + (this.modeName != null ? " / " + this.modeName : ""));
        this.scrollHscrollV.setText(String.format("$%02X / $%02X | %d / %d", this.scrollH, tilemapRenderer.getVerticalScroll(), this.scrollH, tilemapRenderer.getVerticalScroll()));
    }

    private void updateBaseAddressNames() {
        int n = this.baseAddressSelection.getSelectedIndex();
        this.baseAddressNames = tilemapRenderer.getBaseAddressNames();
        this.baseAddressSelectionModel.fireBaseAddressesChanged();
        if (n < this.baseAddressSelection.getItemCount()) {
            this.baseAddressSelection.setSelectedIndex(n);
        } else {
            this.baseAddressSelection.setSelectedIndex(0);
        }
        this.tileBaseAddressNames = tilemapRenderer.getTileBaseAddressNames();
        this.tileBaseAddressSelection.setModel(new DefaultComboBoxModel<String>(this.tileBaseAddressNames));
    }

    int getSelectedBaseAddress() {
        return this.baseAddressSelection.getSelectedIndex();
    }

    int getSelectedTileBaseAddress() {
        return this.tileBaseAddressSelection.getSelectedIndex();
    }

    private JButton createRefreshButton() {
        JButton jButton = new JButton("Refresh"){

            @Override
            public Dimension getPreferredSize() {
                return TilemapViewer.this.autoRefresh.getPreferredSize();
            }
        };
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TilemapViewer.refresh();
            }
        });
        return jButton;
    }

    int getIndex() {
        return Integer.parseInt(this.index.getText().substring(0, this.index.getText().indexOf(32)));
    }

    static void setShowGrid(boolean bl) {
        Emulicious.getProperties().setProperty("TilemapViewerShowGrid", Boolean.toString(bl));
    }

    static boolean isShowGrid() {
        return Boolean.parseBoolean(Emulicious.getProperties().getProperty("TilemapViewerShowGrid"));
    }

    static void setIntegerScaling(boolean bl) {
        if (viewer != null) {
            TilemapViewer.viewer.viewerWindow.setIntegerScaling(bl);
            Emulicious.getProperties().setProperty("TilemapViewerIntegerScaling", Boolean.toString(bl));
        }
    }

    static boolean isIntegerScaling() {
        return Boolean.parseBoolean(Emulicious.getProperties().getProperty("TilemapViewerIntegerScaling"));
    }

    public static boolean isOpen() {
        return viewer != null && viewer.isVisible();
    }

    public static void open(Window window, boolean bl) {
        if (VideoViewer.isCombined()) {
            VideoViewer.open(window, "Tilemap", bl);
        } else {
            if (viewer == null) {
                viewer = new TilemapViewer(window, Emulicious.isUseFrames());
                viewer.setVisible(true);
            } else if (!bl) {
                viewer.setVisible(true);
            }
            if (viewer.isShowing() && TilemapViewer.viewer.autoRefresh.isSelected()) {
                TilemapViewer.viewer.refreshTimer.restart();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TilemapViewer.refresh();
                }
            });
        }
    }

    static Container stealContentPane(Window window) {
        if (viewer == null) {
            viewer = new TilemapViewer(window, false);
        }
        if (TilemapViewer.viewer.autoRefresh.isSelected()) {
            TilemapViewer.viewer.refreshTimer.restart();
        }
        Container container = viewer.getContentPane();
        viewer.dispose();
        return container;
    }

    static void stopRefreshTimer() {
        if (viewer != null) {
            TilemapViewer.viewer.refreshTimer.stop();
        }
    }

    static void restartRefreshTimer() {
        if (viewer != null && TilemapViewer.viewer.autoRefresh.isSelected()) {
            TilemapViewer.viewer.refreshTimer.restart();
        }
    }

    public static void setTilemapRenderer(TilemapRenderer tilemapRenderer) {
        TilemapViewer.tilemapRenderer = tilemapRenderer;
        if (tilemapRenderer != null && viewer != null) {
            viewer.updateInfoPanel();
        }
    }

    public static void close() {
        if (viewer != null) {
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Open", "" + viewer.isVisible());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "X", "" + viewer.getX());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Y", "" + viewer.getY());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Width", "" + viewer.getWidth());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Height", "" + viewer.getHeight());
            if (TilemapViewer.viewer.autoRefresh.isSelected()) {
                Emulicious.getProperties().remove("AutoRefresh" + viewer.getClass().getSimpleName());
            } else {
                Emulicious.getProperties().setProperty("AutoRefresh" + viewer.getClass().getSimpleName(), "false");
            }
            TilemapViewer.viewer.refreshTimer.stop();
            TilemapViewer.viewer.autoRefresh.setSelected(false);
            viewer.dispose();
            viewer = null;
        }
    }

    static void refresh() {
        if (viewer != null && TilemapViewer.viewer.viewerWindow.isShowing()) {
            if (tilemapRenderer.getBaseAddressNames() != TilemapViewer.viewer.baseAddressNames) {
                viewer.updateBaseAddressNames();
            }
            TilemapViewer.viewer.tilemapData = tilemapRenderer.getTilemapData(viewer.getSelectedBaseAddress(), TilemapViewer.viewer.tilemapData, TilemapViewer.viewer.viewerCache);
            TilemapViewer.viewer.sources = MemoryTracer.getVRAMSources(TilemapViewer.viewer.sources);
            Dimension dimension = tilemapRenderer.getTilemapDimension(TilemapViewer.isShowGrid());
            TilemapViewer.viewer.viewerWindow.setDimensions(dimension);
            TilemapViewer.viewer.viewerWindow.fill(DisplayWindow.COLOR_GRAY);
            tilemapRenderer.renderTilemap(TilemapViewer.viewer.viewerWindow, viewer.getSelectedBaseAddress(), viewer.getSelectedTileBaseAddress(), TilemapViewer.isShowGrid(), TilemapViewer.viewer.autoPalette.isSelected(), TilemapViewer.viewer.viewerCache);
            TilemapViewer.viewer.viewerWindow.repaint();
            viewer.updateLabels(viewer.getIndex(), true, dimension);
        }
    }

    class BaseAddressSelectionModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private Object selectedItem = this.getElementAt(0);

        BaseAddressSelectionModel() {
        }

        @Override
        public int getSize() {
            return TilemapViewer.this.baseAddressNames.length;
        }

        @Override
        public String getElementAt(int n) {
            return TilemapViewer.this.baseAddressNames[n];
        }

        public void fireBaseAddressesChanged() {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selectedItem = object;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }
    }
}

