/*
 * Decompiled with CFR 0.152.
 */
package platform.viewers;

import common.ScreenUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import output.PaletteRenderer;
import platform.Emulicious;
import platform.MemoryTracer;
import platform.MemoryTracerWindow;
import platform.viewers.VideoViewer;
import platform.viewers.ViewerWindow;

public class PaletteViewer {
    static PaletteRenderer paletteRenderer;
    static final Cursor HAND_CURSOR;
    static final Cursor DEFAULT_CURSOR;
    private final ViewerWindow viewerWindow = new ViewerWindow();
    final JCheckBox autoRefresh = new JCheckBox("Auto Refresh");
    private final JLabel index = new JLabel("0 ($0)");
    private final JLabel color = new JLabel();
    private final JLabel redGreenBlue = new JLabel();
    private final MemoryTracerWindow.SourceLabel source = MemoryTracerWindow.createSourceLabel();
    private final JPanel infoPanel = new JPanel();
    private final JButton refreshButton = PaletteViewer.createRefreshButton();
    int selectedIndex = -1;
    final Window window;
    private long[] sources;
    private static PaletteViewer viewer;
    private final Timer refreshTimer = new Timer(50, new ActionListener(){
        private int exceptionCounter;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PaletteViewer.refresh();
                this.exceptionCounter = 0;
            }
            catch (RuntimeException runtimeException) {
                if (++this.exceptionCounter >= 2) {
                    PaletteViewer.this.autoRefresh.setSelected(false);
                    throw runtimeException;
                }
                runtimeException.printStackTrace();
            }
        }
    });

    static {
        HAND_CURSOR = Cursor.getPredefinedCursor(12);
        DEFAULT_CURSOR = Cursor.getDefaultCursor();
    }

    private PaletteViewer(Window window, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        final ViewerWindow viewerWindow = this.viewerWindow;
        final Timer timer = this.refreshTimer;
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Palette Viewer");
        this.window.setIconImages(window.getIconImages());
        this.window.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)viewerWindow, "Center");
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.window.add((Component)jPanel, "Center");
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.window.add((Component)this.infoPanel, "South");
        this.updateInfoPanel();
        viewerWindow.setBackground(this.window.getBackground());
        viewerWindow.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Dimension dimension = paletteRenderer.getPaletteDimension(viewerWindow);
                int n = viewerWindow.toScreenX(mouseEvent.getX());
                int n2 = viewerWindow.toScreenY(mouseEvent.getY());
                int n3 = paletteRenderer.getColorEntrySize();
                int n4 = paletteRenderer.getColorAt(n, n2, viewerWindow);
                if (n >= 0 && (double)n < dimension.getWidth() && n2 >= 0 && paletteRenderer.isColorValid(n4)) {
                    viewerWindow.setHighlightCursor(paletteRenderer.getColorX(n4, viewerWindow), paletteRenderer.getColorY(n4, viewerWindow), n3, n3);
                    PaletteViewer.this.updateLabels(n4);
                    viewerWindow.setCursor(HAND_CURSOR);
                } else {
                    viewerWindow.setCursor(DEFAULT_CURSOR);
                    viewerWindow.hideHighlightCursor();
                    PaletteViewer.this.updateLabels(PaletteViewer.this.selectedIndex);
                }
            }
        });
        viewerWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = paletteRenderer.getPaletteDimension(viewerWindow);
                int n = viewerWindow.toScreenX(mouseEvent.getX());
                int n2 = viewerWindow.toScreenY(mouseEvent.getY());
                int n3 = paletteRenderer.getColorEntrySize();
                int n4 = paletteRenderer.getColorAt(n, n2, viewerWindow);
                if (n >= 0 && (double)n < dimension.getWidth() && n2 >= 0 && paletteRenderer.isColorValid(n4)) {
                    viewerWindow.setSelectionCursor(paletteRenderer.getColorX(n4, viewerWindow), paletteRenderer.getColorY(n4, viewerWindow), n3, n3);
                    PaletteViewer.this.updateLabels(n4);
                    PaletteViewer.this.selectedIndex = n4;
                    viewerWindow.setCursor(HAND_CURSOR);
                } else {
                    viewerWindow.setCursor(DEFAULT_CURSOR);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                viewerWindow.setCursor(DEFAULT_CURSOR);
                viewerWindow.hideHighlightCursor();
                PaletteViewer.this.updateLabels(PaletteViewer.this.selectedIndex);
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                timer.stop();
            }
        });
        this.autoRefresh.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                if (jCheckBox.isSelected()) {
                    timer.restart();
                } else {
                    timer.stop();
                }
            }
        });
        this.autoRefresh.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("AutoRefresh" + this.getClass().getSimpleName())));
        if (paletteRenderer != null) {
            viewerWindow.setDimensions(paletteRenderer.getPaletteDimension(viewerWindow));
        }
        viewerWindow.setScale(1.0f);
        this.window.pack();
        this.window.setMinimumSize(this.window.getSize());
        if (viewer == null || !viewer.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                viewerWindow.setScale(3.0f);
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private Container getContentPane() {
        return this.window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)this.window)).getContentPane() : null;
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    void updateLabels(int n) {
        if (paletteRenderer.isColorValid(n)) {
            this.index.setText(String.format("%d ($%X)", n, n));
            this.color.setText(String.format(paletteRenderer.getBytesPerColor() == 2 ? "%04X" : "%02X", paletteRenderer.getColor(n)));
            this.redGreenBlue.setText(String.valueOf(paletteRenderer.getRed(n)) + " / " + paletteRenderer.getGreen(n) + " / " + paletteRenderer.getBlue(n));
            if (this.sources != null && n < this.sources.length) {
                this.source.setSource(this.sources[n]);
            } else {
                this.source.setSource(0L);
            }
        }
    }

    private void updateInfoPanel() {
        this.infoPanel.removeAll();
        this.infoPanel.setLayout(new GridLayout(paletteRenderer.hideColorIndex() ? 4 : 5, 2));
        if (!paletteRenderer.hideColorIndex()) {
            this.infoPanel.add(new JLabel("Index: "));
            this.infoPanel.add(this.index);
        }
        this.infoPanel.add(new JLabel("Color: "));
        this.infoPanel.add(this.color);
        this.infoPanel.add(new JLabel("Red / Green / Blue: "));
        this.infoPanel.add(this.redGreenBlue);
        this.infoPanel.add(new JLabel("Source: "));
        this.infoPanel.add(this.source);
        this.infoPanel.add(this.autoRefresh);
        this.infoPanel.add(this.refreshButton);
    }

    private static JButton createRefreshButton() {
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaletteViewer.refresh();
            }
        });
        return jButton;
    }

    static void setHighlightedColor(int n) {
        if (viewer != null && paletteRenderer != null) {
            if (n < 0) {
                n = PaletteViewer.viewer.selectedIndex;
            }
            int n2 = paletteRenderer.getColorEntrySize();
            if (paletteRenderer.isColorValid(n)) {
                PaletteViewer.viewer.viewerWindow.setHighlightCursor(paletteRenderer.getColorX(n, PaletteViewer.viewer.viewerWindow), paletteRenderer.getColorY(n, PaletteViewer.viewer.viewerWindow), n2, n2);
            } else {
                PaletteViewer.viewer.viewerWindow.hideHighlightCursor();
            }
            viewer.updateLabels(n);
        }
    }

    static void setSelectedColor(int n) {
        if (viewer != null && paletteRenderer != null && paletteRenderer.isColorValid(n)) {
            int n2 = paletteRenderer.getColorEntrySize();
            PaletteViewer.viewer.selectedIndex = n;
            PaletteViewer.viewer.viewerWindow.setSelectionCursor(paletteRenderer.getColorX(n, PaletteViewer.viewer.viewerWindow), paletteRenderer.getColorY(n, PaletteViewer.viewer.viewerWindow), n2, n2);
            viewer.updateLabels(n);
        }
    }

    public static boolean isOpen() {
        return viewer != null && viewer.isVisible();
    }

    public static void open(Window window, boolean bl) {
        if (VideoViewer.isCombined()) {
            VideoViewer.open(window, "Palettes", bl);
        } else {
            if (viewer == null) {
                viewer = new PaletteViewer(window, Emulicious.isUseFrames());
                viewer.setVisible(true);
            } else if (!bl) {
                viewer.setVisible(true);
            }
            if (viewer.isShowing() && PaletteViewer.viewer.autoRefresh.isSelected()) {
                PaletteViewer.viewer.refreshTimer.restart();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteViewer.refresh();
                }
            });
        }
    }

    static Container stealContentPane(Window window) {
        if (viewer == null) {
            viewer = new PaletteViewer(window, false);
        }
        if (PaletteViewer.viewer.autoRefresh.isSelected()) {
            PaletteViewer.viewer.refreshTimer.restart();
        }
        Container container = viewer.getContentPane();
        viewer.dispose();
        return container;
    }

    static void stopRefreshTimer() {
        if (viewer != null) {
            PaletteViewer.viewer.refreshTimer.stop();
        }
    }

    static void restartRefreshTimer() {
        if (viewer != null && PaletteViewer.viewer.autoRefresh.isSelected()) {
            PaletteViewer.viewer.refreshTimer.restart();
        }
    }

    public static void setPaletteRenderer(PaletteRenderer paletteRenderer) {
        PaletteViewer.paletteRenderer = paletteRenderer;
        if (paletteRenderer != null && viewer != null) {
            viewer.updateInfoPanel();
        }
    }

    public static void close() {
        if (viewer != null) {
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Open", "" + viewer.isVisible());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "X", "" + viewer.getX());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Y", "" + viewer.getY());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Width", "" + viewer.getWidth());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Height", "" + viewer.getHeight());
            if (PaletteViewer.viewer.autoRefresh.isSelected()) {
                Emulicious.getProperties().remove("AutoRefresh" + viewer.getClass().getSimpleName());
            } else {
                Emulicious.getProperties().setProperty("AutoRefresh" + viewer.getClass().getSimpleName(), "false");
            }
            PaletteViewer.viewer.refreshTimer.stop();
            PaletteViewer.viewer.autoRefresh.setSelected(false);
            viewer.dispose();
            viewer = null;
        }
    }

    static void refresh() {
        if (viewer != null && PaletteViewer.viewer.viewerWindow.isShowing()) {
            PaletteViewer.viewer.sources = MemoryTracer.getColorSources(PaletteViewer.viewer.sources);
            PaletteViewer.viewer.viewerWindow.setDimensions(paletteRenderer.getPaletteDimension(PaletteViewer.viewer.viewerWindow));
            PaletteViewer.viewer.viewerWindow.fill(PaletteViewer.viewer.viewerWindow.getBackgroundRGB());
            paletteRenderer.renderPalettes(PaletteViewer.viewer.viewerWindow);
            PaletteViewer.viewer.viewerWindow.repaint();
            viewer.updateLabels(Integer.parseInt(PaletteViewer.viewer.index.getText().substring(0, PaletteViewer.viewer.index.getText().indexOf(32))));
        }
    }
}

