/*
 * Decompiled with CFR 0.152.
 */
package messages;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IllegalFormatException;
import system.DebuggableSystem;

public final class Z80MessageParser {
    private Z80MessageParser() {
    }

    public static String parseMessage(DebuggableSystem debuggableSystem) {
        String string;
        block84: {
            int n;
            int n2;
            block85: {
                block83: {
                    int n3 = debuggableSystem.getPC();
                    int n4 = n3 + 2 + debuggableSystem.peekByte(n3 + 1);
                    n2 = debuggableSystem.peekByte(n3 + 5) << 8 | debuggableSystem.peekByte(n3 + 4);
                    n = n3 + 6;
                    if (n2 != 0) break block83;
                    char[] cArray = new char[n4 - n + 1];
                    int n5 = 0;
                    while (n5 < cArray.length - 1) {
                        cArray[n5] = (char)debuggableSystem.peekByte(n + n5);
                        ++n5;
                    }
                    cArray[cArray.length - 1] = 10;
                    string = new String(cArray);
                    break block84;
                }
                if (n2 < 512) break block85;
                int n6 = debuggableSystem.getRegisterValue(2);
                StringBuilder stringBuilder = new StringBuilder();
                int n7 = debuggableSystem.getRegisterValue(1);
                int n8 = -1;
                int n9 = 0;
                while (n9 < 4096) {
                    block82: {
                        char c;
                        block86: {
                            c = (char)debuggableSystem.peekByte(n6 + n9);
                            if (c == '\u0000') break;
                            if (n8 >= 0 || c != '%') break block86;
                            block1 : switch ((char)debuggableSystem.peekByte(n6 + ++n9)) {
                                case 'h': {
                                    switch ((char)debuggableSystem.peekByte(n6 + ++n9)) {
                                        case 'x': {
                                            stringBuilder.append(Integer.toHexString(debuggableSystem.peekByte(n7++)));
                                            break block1;
                                        }
                                        case 'X': {
                                            stringBuilder.append(Integer.toHexString(debuggableSystem.peekByte(n7++)).toUpperCase());
                                            break block1;
                                        }
                                        case 'o': {
                                            stringBuilder.append(String.format("%o", debuggableSystem.peekByte(n7++)));
                                            break block1;
                                        }
                                        case 'b': {
                                            stringBuilder.append(Integer.toBinaryString((byte)debuggableSystem.peekByte(n7++)));
                                            break block1;
                                        }
                                        case 'u': {
                                            stringBuilder.append(debuggableSystem.peekByte(n7++));
                                            break block1;
                                        }
                                        case 'd': 
                                        case 'i': {
                                            stringBuilder.append((byte)debuggableSystem.peekByte(n7++));
                                            break block1;
                                        }
                                        case 'n': {
                                            break block1;
                                        }
                                    }
                                    stringBuilder.append('h').append((char)debuggableSystem.peekByte(n6 + n9));
                                    n8 = n9;
                                    break;
                                }
                                case 'l': {
                                    switch ((char)debuggableSystem.peekByte(n6 + ++n9)) {
                                        case 'x': {
                                            stringBuilder.append(Integer.toHexString(debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8 | debuggableSystem.peekByte(n7++) << 16 | debuggableSystem.peekByte(n7++) << 24));
                                            break block1;
                                        }
                                        case 'X': {
                                            stringBuilder.append(Integer.toHexString(debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8 | debuggableSystem.peekByte(n7++) << 16 | debuggableSystem.peekByte(n7++) << 24).toUpperCase());
                                            break block1;
                                        }
                                        case 'o': {
                                            stringBuilder.append(String.format("%o", debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8 | debuggableSystem.peekByte(n7++) << 16 | debuggableSystem.peekByte(n7++) << 24));
                                            break block1;
                                        }
                                        case 'b': {
                                            stringBuilder.append(Long.toBinaryString((long)debuggableSystem.peekByte(n7++) | (long)debuggableSystem.peekByte(n7++) << 8 | (long)debuggableSystem.peekByte(n7++) << 16 | (long)debuggableSystem.peekByte(n7++) << 24));
                                            break block1;
                                        }
                                        case 'u': {
                                            stringBuilder.append((long)debuggableSystem.peekByte(n7++) | (long)debuggableSystem.peekByte(n7++) << 8 | (long)debuggableSystem.peekByte(n7++) << 16 | (long)debuggableSystem.peekByte(n7++) << 24);
                                            break block1;
                                        }
                                        case 'd': 
                                        case 'i': {
                                            stringBuilder.append(debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8 | debuggableSystem.peekByte(n7++) << 16 | debuggableSystem.peekByte(n7++) << 24);
                                            break block1;
                                        }
                                        case 'f': {
                                            stringBuilder.append(ByteBuffer.wrap(new byte[]{(byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++)}).order(ByteOrder.LITTLE_ENDIAN).getDouble());
                                            break block1;
                                        }
                                        case 'l': {
                                            switch ((char)debuggableSystem.peekByte(n6 + ++n9)) {
                                                case 'x': {
                                                    stringBuilder.append(Long.toHexString((long)debuggableSystem.peekByte(n7++) | (long)debuggableSystem.peekByte(n7++) << 8 | (long)debuggableSystem.peekByte(n7++) << 16 | (long)debuggableSystem.peekByte(n7++) << 24 | (long)debuggableSystem.peekByte(n7++) << 32 | (long)debuggableSystem.peekByte(n7++) << 40 | (long)debuggableSystem.peekByte(n7++) << 48 | (long)debuggableSystem.peekByte(n7++) << 54));
                                                    break block1;
                                                }
                                                case 'X': {
                                                    stringBuilder.append(Long.toHexString((long)debuggableSystem.peekByte(n7++) | (long)debuggableSystem.peekByte(n7++) << 8 | (long)debuggableSystem.peekByte(n7++) << 16 | (long)debuggableSystem.peekByte(n7++) << 24 | (long)debuggableSystem.peekByte(n7++) << 32 | (long)debuggableSystem.peekByte(n7++) << 40 | (long)debuggableSystem.peekByte(n7++) << 48 | (long)debuggableSystem.peekByte(n7++) << 54).toUpperCase());
                                                    break block1;
                                                }
                                                case 'o': {
                                                    stringBuilder.append(String.format("%o", (long)debuggableSystem.peekByte(n7++) | (long)debuggableSystem.peekByte(n7++) << 8 | (long)debuggableSystem.peekByte(n7++) << 16 | (long)debuggableSystem.peekByte(n7++) << 24 | (long)debuggableSystem.peekByte(n7++) << 32 | (long)debuggableSystem.peekByte(n7++) << 40 | (long)debuggableSystem.peekByte(n7++) << 48 | (long)debuggableSystem.peekByte(n7++) << 54));
                                                    break block1;
                                                }
                                                case 'b': {
                                                    stringBuilder.append(Long.toBinaryString((long)debuggableSystem.peekByte(n7++) | (long)debuggableSystem.peekByte(n7++) << 8 | (long)debuggableSystem.peekByte(n7++) << 16 | (long)debuggableSystem.peekByte(n7++) << 24 | (long)debuggableSystem.peekByte(n7++) << 32 | (long)debuggableSystem.peekByte(n7++) << 40 | (long)debuggableSystem.peekByte(n7++) << 48 | (long)debuggableSystem.peekByte(n7++) << 54));
                                                    break block1;
                                                }
                                                case 'd': 
                                                case 'i': {
                                                    stringBuilder.append((long)debuggableSystem.peekByte(n7++) | (long)debuggableSystem.peekByte(n7++) << 8 | (long)debuggableSystem.peekByte(n7++) << 16 | (long)debuggableSystem.peekByte(n7++) << 24 | (long)debuggableSystem.peekByte(n7++) << 32 | (long)debuggableSystem.peekByte(n7++) << 40 | (long)debuggableSystem.peekByte(n7++) << 48 | (long)debuggableSystem.peekByte(n7++) << 54);
                                                    break block1;
                                                }
                                                case 'u': {
                                                    stringBuilder.append(((long)debuggableSystem.peekByte(n7++) | (long)debuggableSystem.peekByte(n7++) << 8 | (long)debuggableSystem.peekByte(n7++) << 16 | (long)debuggableSystem.peekByte(n7++) << 24 | (long)debuggableSystem.peekByte(n7++) << 32 | (long)debuggableSystem.peekByte(n7++) << 40 | (long)debuggableSystem.peekByte(n7++) << 48 | (long)debuggableSystem.peekByte(n7++) << 54) & Long.MAX_VALUE);
                                                    break block1;
                                                }
                                                case 'n': {
                                                    break block1;
                                                }
                                            }
                                            stringBuilder.append("ll").append((char)debuggableSystem.peekByte(n6 + n9));
                                            n8 = n9;
                                            break block1;
                                        }
                                        case 'n': {
                                            break block1;
                                        }
                                    }
                                    stringBuilder.append('l').append((char)debuggableSystem.peekByte(n6 + n9));
                                    n8 = n9;
                                    break;
                                }
                                case 'c': {
                                    stringBuilder.append((char)debuggableSystem.peekByte(n7++));
                                    ++n7;
                                    break;
                                }
                                case 'f': {
                                    stringBuilder.append(ByteBuffer.wrap(new byte[]{(byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++)}).order(ByteOrder.LITTLE_ENDIAN).getFloat());
                                    break;
                                }
                                case 'e': 
                                case 'g': {
                                    stringBuilder.append(String.format("%" + c, Float.valueOf(ByteBuffer.wrap(new byte[]{(byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++), (byte)debuggableSystem.peekByte(n7++)}).order(ByteOrder.LITTLE_ENDIAN).getFloat())));
                                    break;
                                }
                                case 'u': {
                                    stringBuilder.append(debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8);
                                    break;
                                }
                                case 'd': 
                                case 'i': {
                                    stringBuilder.append((short)(debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8));
                                    break;
                                }
                                case 'x': {
                                    stringBuilder.append(Integer.toHexString(debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8));
                                    break;
                                }
                                case 'X': 
                                case 'p': {
                                    stringBuilder.append(Integer.toHexString(debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8).toUpperCase());
                                    break;
                                }
                                case 'o': {
                                    stringBuilder.append(String.format("%o", debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8));
                                    break;
                                }
                                case 'b': {
                                    stringBuilder.append(Integer.toBinaryString(debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8));
                                    break;
                                }
                                case 's': {
                                    int n10;
                                    char c2 = debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8;
                                    int n11 = 0;
                                    while (n11 < 4096) {
                                        if ((n10 = (int)debuggableSystem.peekByte(c2++)) != 0) {
                                            stringBuilder.append((char)n10);
                                            ++n11;
                                            continue;
                                        }
                                        break block82;
                                    }
                                    break block82;
                                }
                                case 'n': {
                                    break;
                                }
                                case '%': {
                                    stringBuilder.append('%');
                                    break;
                                }
                                default: {
                                    int n10;
                                    int n11;
                                    char c2;
                                    try {
                                        c2 = (char)debuggableSystem.peekByte(n6 + n9);
                                        if (c2 >= '0' && c2 <= '9' || "+-# ".indexOf(c2) >= 0) {
                                            int n12;
                                            n11 = n9 - 1;
                                            while ((char)debuggableSystem.peekByte(n6 + n11) != '%') {
                                                --n11;
                                            }
                                            c2 = (char)debuggableSystem.peekByte(n6 + n9);
                                            while (c2 >= '0' && c2 <= '9' || "+-# ".indexOf(c2) >= 0) {
                                                c2 = (char)debuggableSystem.peekByte(n6 + ++n9);
                                            }
                                            n10 = n9;
                                            c2 = (char)debuggableSystem.peekByte(n6 + n9);
                                            if (c2 == 's') {
                                                int n13;
                                                StringBuilder stringBuilder2 = new StringBuilder();
                                                n12 = debuggableSystem.peekByte(n7++) | debuggableSystem.peekByte(n7++) << 8;
                                                int n14 = 0;
                                                while (n14 < 4096) {
                                                    if ((n13 = (int)debuggableSystem.peekByte(n12++)) == 0) break;
                                                    stringBuilder2.append((char)n13);
                                                    ++n14;
                                                }
                                                String string2 = stringBuilder2.toString();
                                                stringBuilder2.setLength(0);
                                                n13 = n11;
                                                while (n13 < n9) {
                                                    stringBuilder2.append((char)debuggableSystem.peekByte(n6 + n13));
                                                    ++n13;
                                                }
                                                stringBuilder2.append(c2);
                                                stringBuilder.append(String.format(stringBuilder2.toString(), string2));
                                                break;
                                            }
                                            int n15 = 2;
                                            if (c2 == 'h') {
                                                n15 = 1;
                                                c2 = (char)debuggableSystem.peekByte(n6 + ++n9);
                                            } else if (c2 == 'l') {
                                                n15 = 4;
                                                if ((c2 = (char)((char)debuggableSystem.peekByte(n6 + ++n9))) == 'l') {
                                                    n15 = 8;
                                                    c2 = (char)debuggableSystem.peekByte(n6 + ++n9);
                                                }
                                            }
                                            if (c2 == 'i') {
                                                c2 = 'd';
                                            }
                                            int n3 = n12 = c2 == 'd' ? 1 : 0;
                                            if (c2 == 'u') {
                                                c2 = 'd';
                                            }
                                            long l = 0L;
                                            int n17 = 0;
                                            while (n17 < n15) {
                                                l += (long)(debuggableSystem.peekByte(n7++) << 8 * n17);
                                                ++n17;
                                            }
                                            if (n12 != 0) {
                                                switch (n15) {
                                                    case 1: {
                                                        l = (byte)l;
                                                        break;
                                                    }
                                                    case 2: {
                                                        l = (short)l;
                                                        break;
                                                    }
                                                    case 4: {
                                                        l = (int)l;
                                                    }
                                                }
                                            } else if (n15 < 8) {
                                                l &= (1L << n15 * 8) - 1L;
                                            }
                                            if (c2 == 'b') {
                                                n17 = n11 + '\u0001';
                                                if ((char)debuggableSystem.peekByte(n6 + n17) == '-') {
                                                    StringBuilder stringBuilder3 = new StringBuilder();
                                                    n17 = n11;
                                                    while (n17 < n10) {
                                                        stringBuilder3.append((char)debuggableSystem.peekByte(n6 + n17));
                                                        ++n17;
                                                    }
                                                    stringBuilder3.append('s');
                                                    stringBuilder.append(String.format(stringBuilder3.toString(), Long.toBinaryString(l)));
                                                    break;
                                                }
                                                if ((char)debuggableSystem.peekByte(n6 + n17) == ' ' || (char)debuggableSystem.peekByte(n6 + n17) == '0') {
                                                    char c3 = (char)debuggableSystem.peekByte(n6 + n17);
                                                    StringBuilder stringBuilder4 = new StringBuilder("%");
                                                    ++n17;
                                                    while (n17 < n10) {
                                                        stringBuilder4.append((char)debuggableSystem.peekByte(n6 + n17));
                                                        ++n17;
                                                    }
                                                    stringBuilder4.append('s');
                                                    stringBuilder.append(String.format(stringBuilder4.toString(), Long.toBinaryString(l)).replace(' ', c3));
                                                    break;
                                                }
                                                break block82;
                                            }
                                            StringBuilder stringBuilder5 = new StringBuilder();
                                            int n18 = n11;
                                            while (n18 < n10) {
                                                stringBuilder5.append((char)debuggableSystem.peekByte(n6 + n18));
                                                ++n18;
                                            }
                                            stringBuilder5.append(c2);
                                            stringBuilder.append(String.format(stringBuilder5.toString(), l));
                                            break;
                                        }
                                    }
                                    catch (IllegalFormatException illegalFormatException) {}
                                    n8 = n9;
                                    stringBuilder.append('%').append((char)debuggableSystem.peekByte(n6 + n9));
                                    break;
                                }
                            }
                            break block82;
                        }
                        stringBuilder.append(c);
                    }
                    ++n9;
                }
                string = n8 >= 0 ? "Unsupported format specifier '" + (char)debuggableSystem.peekByte(n6 + n8) + "' encountered at position " + n8 + " in \"" + stringBuilder.toString().replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t") + "\"" : stringBuilder.toString();
                break block84;
            }
            if (n2 >= 256) {
                int n19 = debuggableSystem.getRegisterValue(n2 & 7);
                StringBuilder stringBuilder = new StringBuilder();
                int n20 = 0;
                while (n20 < 4096) {
                    char c = (char)debuggableSystem.peekByte(n19 + n20);
                    if (c == '\u0000') break;
                    stringBuilder.append(c);
                    ++n20;
                }
                string = stringBuilder.append('\n').toString();
            } else {
                int n21 = debuggableSystem.peekByte(n + 1) << 8 | debuggableSystem.peekByte(n);
                int n22 = debuggableSystem.peekByte(n + 3) << 8 | debuggableSystem.peekByte(n + 2);
                StringBuilder stringBuilder = new StringBuilder();
                int n23 = 0;
                while (n23 < 4096) {
                    char c = (char)debuggableSystem.getByte(n21 + n23, n22);
                    if (c == '\u0000') break;
                    stringBuilder.append(c);
                    ++n23;
                }
                string = stringBuilder.append('\n').toString();
            }
        }
        return string;
    }
}

