/*
 * Decompiled with CFR 0.152.
 */
package filesystem;

import filesystem.AbstractFAT;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import util.map.HashMap;

public class FAT1632
extends AbstractFAT {
    private boolean fat16;
    private final ArrayList<File> allFiles = new ArrayList();
    private final RootDirectory rootDir = new RootDirectory();
    final Map<File, File> parents = new IdentityHashMap<File, File>();
    private final HashMap<MemoryMappedFile> memoryMappedFiles = new HashMap();
    private boolean supportVFAT = true;

    public void addFile(File file) {
        this.addFileToFiles(file, this.rootDir);
    }

    private void addFileToFiles(File file, File file2) {
        this.allFiles.add(file);
        this.parents.put(file, file2);
        if (!(file2 instanceof AbstractDirectory)) {
            throw new IllegalArgumentException("Cannot add files to " + file2);
        }
        ((AbstractDirectory)file2).addFile(file);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray[n2];
                this.addFileToFiles(file3, file);
                ++n2;
            }
        }
    }

    public File findFile(String string) {
        if (string == null) {
            return null;
        }
        for (File file : this.allFiles) {
            if (!string.equals(file.getName())) continue;
            return file;
        }
        return null;
    }

    private static int indexOfSameShortName(File[] fileArray, File file) {
        String string;
        int n = file.getName().lastIndexOf(46);
        String string2 = string = n >= 0 ? file.getName().substring(0, n).replace(" ", "") : file.getName().replace(" ", "");
        if (string.length() <= 8) {
            return -1;
        }
        int n2 = 0;
        File[] fileArray2 = fileArray;
        int n3 = fileArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string3;
            File file2 = fileArray2[n4];
            int n5 = file2.getName().lastIndexOf(46);
            String string4 = string3 = n5 >= 0 ? file2.getName().substring(0, n5).replace(" ", "") : file2.getName().replace(" ", "");
            if (string3.length() > 8 && string3.substring(0, 6 - (n2 + 1) / 10).equalsIgnoreCase(string.substring(0, 6 - (n2 + 1) / 10))) {
                ++n2;
            }
            if (file2 == file) break;
            ++n4;
        }
        return n2;
    }

    private static char getVFATFilenameCharacter(File file, int n, char c) {
        return FAT1632.getCharacterAt(String.valueOf(file.getName()) + '\u0000', n, c);
    }

    private static char getFilenameWithoutExtensionCharacter(File file, int n, char c, int n2) {
        int n3;
        if (n2 >= 0) {
            n3 = n - (6 - n2 / 10 + 1);
            if (n3 == -1) {
                return '~';
            }
            if (n3 >= 0) {
                return n3 <= n2 / 10 ? Integer.toString(n2).charAt(n3) : c;
            }
        }
        if ((n3 = file.getName().lastIndexOf(46)) < 0) {
            return FAT1632.getCharacterAt(file.getName().replace(" ", ""), n, c);
        }
        return FAT1632.getCharacterAt(file.getName().substring(0, n3).replace(" ", ""), n, c);
    }

    private static char getFileExtensionCharacter(File file, int n, char c) {
        int n2 = file.getName().lastIndexOf(46);
        if (n2 < 0) {
            return c;
        }
        return FAT1632.getCharacterAt(file.getName().substring(n2 + 1), n, c);
    }

    private static char getFileSystemTypeCharacter(int n) {
        return FAT1632.getCharacterAt("FAT32", n, ' ');
    }

    private static char getCharacterAt(String string, int n, char c) {
        if (n >= string.length()) {
            return c;
        }
        return string.charAt(n);
    }

    private static int calcFilenameChecksum(File file) {
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            n = ((n & 1) << 7) + ((n & 0xFF) >>> 1) + Character.toUpperCase(FAT1632.getFilenameWithoutExtensionCharacter(file, n2, ' ', -1));
            ++n2;
        }
        n2 = 8;
        while (n2 < 11) {
            n = ((n & 1) << 7) + ((n & 0xFF) >>> 1) + Character.toUpperCase(FAT1632.getFileExtensionCharacter(file, n2 & 3, ' '));
            ++n2;
        }
        return n & 0xFF;
    }

    private static int getByteOfValue(int n, int n2) {
        return n >> 8 * n2 & 0xFF;
    }

    @Override
    public int getBytesPerLogicalSector() {
        return 512;
    }

    @Override
    public int getLogicalSectorsPerCluster() {
        return 1;
    }

    @Override
    public int getNumberOfReservedLogicalSectors() {
        return 32;
    }

    @Override
    public int getNumberOfFileAllocationTables() {
        return 2;
    }

    @Override
    public int getTotalLogicalSectors() {
        return this.getLogicalSectorsPerFileAllocationTable() * this.getBytesPerLogicalSector() / 4;
    }

    @Override
    public int getMediaDescriptor() {
        return 248;
    }

    @Override
    public int getLogicalSectorsPerFileAllocationTable() {
        return 96;
    }

    private static int getClusterNumberOfRootDirectoryStart() {
        return 2;
    }

    private static int getLogicalSectorNumberOfFSinformationSector() {
        return 1;
    }

    @Override
    protected int getAddressOfFirstFileAllocationTable() {
        return this.getNumberOfReservedLogicalSectors() * this.getBytesPerLogicalSector();
    }

    @Override
    protected int getAddressOfRootDirectory() {
        return (this.getNumberOfReservedLogicalSectors() + this.getNumberOfFileAllocationTables() * this.getLogicalSectorsPerFileAllocationTable()) * this.getBytesPerLogicalSector();
    }

    @Override
    protected int getSizeOfRootDirectory() {
        if (this.fat16) {
            return 16384;
        }
        return 512;
    }

    private int getAddressOfDataArea() {
        return this.getAddressOfRootDirectory() + this.getSizeOfRootDirectory();
    }

    private static int getLastKnownNumberOfFreeDataClusters() {
        return -1;
    }

    private static int getNumberOfMostRecentlyKnownToBeAllocatedCluster() {
        return -1;
    }

    public void setFAT16(boolean bl) {
        this.fat16 = bl;
    }

    @Override
    public int readByte(int n) {
        switch (n) {
            case 11: 
            case 12: {
                return FAT1632.getByteOfValue(this.getBytesPerLogicalSector(), n & 1 ^ 1);
            }
            case 13: {
                return this.getLogicalSectorsPerCluster();
            }
            case 14: {
                return this.getNumberOfReservedLogicalSectors();
            }
            case 16: {
                return this.getNumberOfFileAllocationTables();
            }
            case 19: 
            case 20: {
                return this.fat16 ? FAT1632.getByteOfValue(this.getTotalLogicalSectors(), n & 1 ^ 1) : 0;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return FAT1632.getByteOfValue(this.getTotalLogicalSectors(), n & 3 ^ 3);
            }
            case 21: {
                return this.getMediaDescriptor();
            }
            case 22: 
            case 23: {
                if (!this.fat16) {
                    return 0;
                }
            }
            case 36: 
            case 37: {
                return FAT1632.getByteOfValue(this.getLogicalSectorsPerFileAllocationTable(), n & 1);
            }
            case 44: {
                return FAT1632.getClusterNumberOfRootDirectoryStart();
            }
            case 48: {
                return FAT1632.getLogicalSectorNumberOfFSinformationSector();
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                return FAT1632.getFileSystemTypeCharacter(n - 82);
            }
            case 510: {
                return 85;
            }
            case 511: {
                return 170;
            }
        }
        if (!this.fat16) {
            switch (n - 512) {
                case 0: {
                    return 82;
                }
                case 1: {
                    return 82;
                }
                case 2: {
                    return 97;
                }
                case 3: {
                    return 65;
                }
                case 484: {
                    return 114;
                }
                case 485: {
                    return 114;
                }
                case 486: {
                    return 65;
                }
                case 487: {
                    return 97;
                }
                case 488: 
                case 489: 
                case 490: 
                case 491: {
                    return FAT1632.getByteOfValue(FAT1632.getLastKnownNumberOfFreeDataClusters(), (n & 0x1FF) - 488);
                }
                case 492: 
                case 493: 
                case 494: 
                case 495: {
                    return FAT1632.getByteOfValue(FAT1632.getNumberOfMostRecentlyKnownToBeAllocatedCluster(), (n & 0x1FF) - 492);
                }
                case 508: {
                    return 0;
                }
                case 509: {
                    return 0;
                }
                case 510: {
                    return 85;
                }
                case 511: {
                    return 170;
                }
            }
        }
        if ((n -= this.getAddressOfFirstFileAllocationTable()) < 0) {
            return 0;
        }
        int n2 = this.getLogicalSectorsPerFileAllocationTable() * this.getBytesPerLogicalSector();
        int n3 = this.getNumberOfFileAllocationTables() - 1;
        while (n3 > 0) {
            if (n >= n2) {
                n -= n2;
            }
            --n3;
        }
        if (n < n2) {
            return this.readFAT(n);
        }
        n3 = this.getSizeOfRootDirectory();
        if ((n -= n2) < n3) {
            return this.readDirectoryEntry(this.rootDir, n);
        }
        return this.readDataArea(n - n3);
    }

    private int readFAT(int n) {
        int n2 = this.getBitsPerFATentry();
        int n3 = n * 8 / n2;
        if (n2 == 12) {
            switch (n % 3) {
                case 0: {
                    return this.readNextCluster(n3) & 0xFF;
                }
                case 1: {
                    return (this.readNextCluster(n3 + 1) & 0xF) << 4 | (this.readNextCluster(n3) & 0xF00) >> 8;
                }
            }
            return (this.readNextCluster(n3) & 0xFF0) >> 4;
        }
        return this.readNextCluster(n3) >> n * 8 % n2 & 0xFF;
    }

    private int readNextCluster(int n) {
        switch (n) {
            case 0: {
                return 0xFFFFFF9;
            }
            case 1: {
                return 0xFFFFFFF;
            }
        }
        int n2 = 2;
        if (!this.fat16) {
            n2 += this.getSizeInClusters(this.rootDir);
        }
        for (File file : this.allFiles) {
            int n3 = this.getSizeInClusters(file);
            int n4 = n2 + n3 - 1;
            if (n == n4) {
                return 0xFFFFFFF;
            }
            if (n < n4) {
                return n + 1;
            }
            n2 += n3;
        }
        return 0;
    }

    private int getSizeOnDisk(File file) {
        return this.getSizeInClusters(file) * this.getBytesPerCluster();
    }

    private int getSizeInClusters(File file) {
        return (file.getSize() - 1) / this.getBytesPerCluster() + 1;
    }

    @Override
    protected int getBytesPerCluster() {
        try {
            return super.getBytesPerCluster();
        }
        catch (IOException iOException) {
            return 512;
        }
    }

    @Override
    public void writeByte(int n, int n2) {
        int n3 = this.getLogicalSectorsPerFileAllocationTable() * this.getBytesPerLogicalSector();
        if (n >= this.getAddressOfFirstFileAllocationTable() + n3 && n - (this.getAddressOfFirstFileAllocationTable() + n3) < n3) {
            n -= n3;
        }
        if (n >= this.getAddressOfFirstFileAllocationTable() && n < this.getAddressOfFirstFileAllocationTable() + n3) {
            n -= this.getAddressOfFirstFileAllocationTable();
        }
        if (n >= this.getAddressOfRootDirectory() && n < this.getAddressOfRootDirectory() + this.getSizeOfRootDirectory()) {
            File file;
            n -= this.getAddressOfRootDirectory();
            File[] fileArray = this.rootDir.listFiles();
            int n4 = fileArray.length;
            int n5 = 0;
            while (n5 < n4) {
                file = fileArray[n5];
                if (!(file instanceof MemoryMappedFile)) {
                    n -= (file.getName().length() / 13 + 2) * 32;
                }
                ++n5;
            }
            if (n >= 0) {
                file = this.memoryMappedFiles.get(n / 32);
                MemoryMappedFile memoryMappedFile = null;
                n4 = n / 32;
                while (n4 >= 0 && memoryMappedFile == null) {
                    memoryMappedFile = this.memoryMappedFiles.get(n4);
                    --n4;
                }
                if (memoryMappedFile != null && n / 32 - ++n4 < memoryMappedFile.getDirectoryEntryOffset() / 32) {
                    file = memoryMappedFile;
                }
                if (file == null) {
                    if ((n & 0x1F) != 0 || n2 == 0 || n2 == 46) {
                        return;
                    }
                    file = new MemoryMappedFile();
                    this.memoryMappedFiles.put(n / 32, (MemoryMappedFile)file);
                    this.addFile(file);
                    n4 = n / 32;
                }
                ((MemoryMappedFile)file).writeEntry((n / 32 - n4) * 32 | n & 0x1F, n2);
            }
        }
        if ((n -= this.getAddressOfDataArea()) < 0) {
            return;
        }
        for (File file : this.allFiles) {
            if (n < this.getSizeOnDisk(file)) {
                file.writeByte(n, n2);
                return;
            }
            n -= this.getSizeOnDisk(file);
        }
    }

    private int readDataArea(int n) {
        for (File file : this.allFiles) {
            if (n < this.getSizeOnDisk(file)) {
                return file.readByte(n);
            }
            n -= this.getSizeOnDisk(file);
        }
        return 0;
    }

    private int getClusterNumber(File file) {
        int n = 2;
        if (file == this.rootDir) {
            return n;
        }
        if (!this.fat16) {
            n += this.getSizeInClusters(this.rootDir);
        }
        for (File file2 : this.allFiles) {
            if (file2 == file) {
                return n;
            }
            n += this.getSizeInClusters(file2);
        }
        throw new IllegalArgumentException(file + " is not part of this FAT.");
    }

    int getSizeOfDirectoryEntry(File file) {
        if (!this.supportVFAT) {
            return 32;
        }
        return (file.getName().length() / 13 + 2) * 32;
    }

    private int readDirectoryEntry(File file, int n) {
        File[] fileArray;
        if (file != this.rootDir) {
            if (n < 64) {
                if ((n & 0x1F) <= n / 32) {
                    return 46;
                }
                if ((n & 0x1F) < 11) {
                    return 32;
                }
                if ((n & 0x1F) == 11) {
                    return 16;
                }
                if ((n & 0x1E) == 26) {
                    if (n / 32 == 0) {
                        return FAT1632.getByteOfValue(this.getClusterNumber(file), n & 1);
                    }
                    if (file.getParent() == this.rootDir) {
                        return 0;
                    }
                    return FAT1632.getByteOfValue(this.getClusterNumber(file.getParent()), n & 1);
                }
                return 0;
            }
            n -= 64;
        }
        File[] fileArray2 = fileArray = file.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray2[n3];
            int n4 = this.getSizeOfDirectoryEntry(file2) / 32 - 1 - ((n & 0xFFFFFFE0) >> 5);
            if (n4 == 0) {
                switch (n & 0x1F) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return Character.toUpperCase(FAT1632.getFilenameWithoutExtensionCharacter(file2, n & 7, ' ', FAT1632.indexOfSameShortName(fileArray, file2)));
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        return Character.toUpperCase(FAT1632.getFileExtensionCharacter(file2, n & 3, ' '));
                    }
                    case 11: {
                        if (file2.isDirectory()) {
                            return 16;
                        }
                        return 32;
                    }
                    case 26: 
                    case 27: {
                        return FAT1632.getByteOfValue(this.getClusterNumber(file2), n & 1);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        if (file2.isDirectory()) {
                            return 0;
                        }
                        return FAT1632.getByteOfValue(file2.getSize(), n & 3);
                    }
                }
                return 0;
            }
            if (this.supportVFAT && n4 >= 0) {
                switch (n & 0x1F) {
                    case 0: {
                        if ((n & 0xFFFFFFE0) == 0) {
                            return 0x40 | n4;
                        }
                        return n4;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        return FAT1632.getByteOfValue(FAT1632.getVFATFilenameCharacter(file2, 13 * (n4 - 1) + ((n - 1 & 0x1F) >> 1), '\uffff'), n - 1 & 1);
                    }
                    case 11: {
                        return 15;
                    }
                    case 13: {
                        return FAT1632.calcFilenameChecksum(file2);
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        return FAT1632.getByteOfValue(FAT1632.getVFATFilenameCharacter(file2, 13 * (n4 - 1) + ((n & 0x1F) >> 1) - 2, '\uffff'), n & 1);
                    }
                    case 26: {
                        return 0;
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        return FAT1632.getByteOfValue(FAT1632.getVFATFilenameCharacter(file2, 13 * (n4 - 1) + ((n & 0x1F) >> 1) - 3, '\uffff'), n & 1);
                    }
                }
                return 0;
            }
            n -= this.getSizeOfDirectoryEntry(file2);
            ++n3;
        }
        return 0;
    }

    public void writeToFile(java.io.File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.writeToStream(fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    @Override
    protected int getBitsPerFATentry() {
        return this.fat16 ? 16 : 32;
    }

    @Override
    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[this.getTotalLogicalSectors() * this.getBytesPerLogicalSector()];
        int n = 0;
        while (n < byArray.length) {
            if (n != 22) {
                byArray[n] = (byte)this.readByte(n);
            }
            ++n;
        }
        outputStream.write(byArray);
    }

    public abstract class AbstractDirectory
    implements File {
        private final HashMap<MemoryMappedFile> memoryMappedFiles = new HashMap();
        private final ArrayList<File> files = new ArrayList();

        public void addFile(File file) {
            if (!this.files.contains(file)) {
                this.files.add(file);
            }
        }

        @Override
        public final int readByte(int n) {
            return FAT1632.this.readDirectoryEntry(this, n);
        }

        @Override
        public void writeByte(int n, int n2) {
            File file;
            n -= 64;
            File[] fileArray = this.listFiles();
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                file = fileArray[n4];
                if (!(file instanceof MemoryMappedFile)) {
                    n -= (file.getName().length() / 13 + 2) * 32;
                }
                ++n4;
            }
            if (n < 0) {
                return;
            }
            file = this.memoryMappedFiles.get(n / 32);
            MemoryMappedFile memoryMappedFile = null;
            n3 = n / 32;
            while (n3 >= 0 && memoryMappedFile == null) {
                memoryMappedFile = this.memoryMappedFiles.get(n3);
                --n3;
            }
            if (memoryMappedFile != null && n / 32 - ++n3 <= memoryMappedFile.getDirectoryEntryOffset() / 32) {
                file = memoryMappedFile;
            }
            if (file == null) {
                if ((n & 0x1F) != 0 || n2 == 0 || n2 == 46) {
                    return;
                }
                file = new MemoryMappedFile();
                this.memoryMappedFiles.put(n / 32, (MemoryMappedFile)file);
                this.files.add(file);
                FAT1632.this.allFiles.add(file);
                n3 = n / 32;
            }
            ((MemoryMappedFile)file).writeEntry((n / 32 - n3) * 32 | n & 0x1F, n2);
        }

        @Override
        public int getSize() {
            int n = 64;
            if (FAT1632.this.supportVFAT) {
                File[] fileArray = this.listFiles();
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file = fileArray[n3];
                    n += FAT1632.this.getSizeOfDirectoryEntry(file);
                    ++n3;
                }
            } else {
                n += this.listFiles().length * 32;
            }
            return n;
        }

        @Override
        public File[] listFiles() {
            return this.files.toArray(new File[this.files.size()]);
        }

        @Override
        public final boolean isDirectory() {
            return true;
        }

        @Override
        public File getParent() {
            return FAT1632.this.parents.get(this);
        }

        public String toString() {
            return String.valueOf(this.getName()) + "/";
        }
    }

    public abstract class AbstractFile
    implements File {
        @Override
        public final boolean isDirectory() {
            return false;
        }

        @Override
        public final File[] listFiles() {
            return new File[0];
        }

        @Override
        public File getParent() {
            return FAT1632.this.parents.get(this);
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface File {
        public String getName();

        public int getSize();

        public int readByte(int var1);

        public void writeByte(int var1, int var2);

        public boolean isDirectory();

        public File[] listFiles();

        public File getParent();
    }

    private class MemoryMappedFile
    implements File {
        private final int[] entry = new int[512];
        private int[] bytes;
        private final HashMap<MemoryMappedFile> memoryMappedFiles = new HashMap();
        private final ArrayList<File> files = new ArrayList();

        private MemoryMappedFile() {
        }

        @Override
        public String getName() {
            String string = "";
            if (this.entry[11] == 15) {
                int n = 0;
                int n2 = this.entry[0] & 0x3F;
                while (n2 > 0) {
                    String string2 = "";
                    int n3 = 1;
                    while (n3 < 11 && (this.entry[n + n3 + 1] << 8 | this.entry[n + n3]) != 65535) {
                        string2 = String.valueOf(string2) + (char)(this.entry[n + n3 + 1] << 8 | this.entry[n + n3]);
                        n3 += 2;
                    }
                    n3 = 14;
                    while (n3 < 26 && (this.entry[n + n3 + 1] << 8 | this.entry[n + n3]) != 65535) {
                        string2 = String.valueOf(string2) + (char)(this.entry[n + n3 + 1] << 8 | this.entry[n + n3]);
                        n3 += 2;
                    }
                    n3 = 28;
                    while (n3 < 32 && (this.entry[n + n3 + 1] << 8 | this.entry[n + n3]) != 65535) {
                        string2 = String.valueOf(string2) + (char)(this.entry[n + n3 + 1] << 8 | this.entry[n + n3]);
                        n3 += 2;
                    }
                    string = String.valueOf(string2) + string;
                    n += 32;
                    --n2;
                }
            } else {
                int n = 0;
                while (n < 11) {
                    string = String.valueOf(string) + (char)this.entry[n];
                    ++n;
                }
            }
            return string.trim();
        }

        @Override
        public int getSize() {
            if (this.isDirectory()) {
                int n = 0;
                File[] fileArray = this.listFiles();
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file = fileArray[n3];
                    n += (file.getName().length() / 13 + 2) * 32;
                    ++n3;
                }
                return (n | FAT1632.this.getBytesPerLogicalSector() - 1) + 1;
            }
            int n = this.getDirectoryEntryOffset();
            return this.entry[n | 0x1F] << 24 | this.entry[n | 0x1E] << 16 | this.entry[n | 0x1D] << 8 | this.entry[n | 0x1C];
        }

        @Override
        public int readByte(int n) {
            if (this.isDirectory()) {
                return FAT1632.this.readDirectoryEntry(this, n);
            }
            return this.bytes == null ? 0 : this.bytes[n];
        }

        @Override
        public void writeByte(int n, int n2) {
            if (this.isDirectory()) {
                MemoryMappedFile memoryMappedFile = this.memoryMappedFiles.get(n / 32);
                MemoryMappedFile memoryMappedFile2 = null;
                int n3 = n / 32;
                while (n3 >= 0 && memoryMappedFile2 == null) {
                    memoryMappedFile2 = this.memoryMappedFiles.get(n3);
                    --n3;
                }
                if (memoryMappedFile2 != null && n / 32 - ++n3 <= memoryMappedFile2.getDirectoryEntryOffset() / 32) {
                    memoryMappedFile = memoryMappedFile2;
                }
                if (memoryMappedFile == null) {
                    if ((n & 0x1F) != 0 || n2 == 0 || n2 == 46) {
                        return;
                    }
                    memoryMappedFile = new MemoryMappedFile();
                    this.memoryMappedFiles.put(n / 32, memoryMappedFile);
                    this.files.add(memoryMappedFile);
                    FAT1632.this.allFiles.add(memoryMappedFile);
                    n3 = n / 32;
                }
                memoryMappedFile.writeEntry((n / 32 - n3) * 32 | n & 0x1F, n2);
            } else {
                if (this.bytes == null) {
                    this.bytes = new int[this.getSize()];
                }
                this.bytes[n] = n2;
            }
        }

        private int getDirectoryEntryOffset() {
            if (this.entry[11] != 15) {
                return 0;
            }
            return (this.entry[0] & 0x3F) * 32;
        }

        public void writeEntry(int n, int n2) {
            this.entry[n & 0x1FF] = n2;
        }

        @Override
        public boolean isDirectory() {
            return this.entry[this.getDirectoryEntryOffset() | 0xB] == 16;
        }

        @Override
        public File[] listFiles() {
            return this.files.toArray(new File[this.files.size()]);
        }

        @Override
        public File getParent() {
            return FAT1632.this.parents.get(this);
        }

        public String toString() {
            if (this.isDirectory()) {
                return String.valueOf(this.getName()) + "/";
            }
            return this.getName();
        }
    }

    class RootDirectory
    extends AbstractDirectory {
        RootDirectory() {
        }

        @Override
        public String getName() {
            return "";
        }
    }
}

