/*
 * Decompiled with CFR 0.152.
 */
package components.input;

import components.input.ButtonInputProvider;

public class GBJoypad {
    public static final int GBKEY_A = 0;
    public static final int GBKEY_B = 1;
    public static final int GBKEY_SELECT = 2;
    public static final int GBKEY_START = 3;
    public static final int GBKEY_RIGHT = 4;
    public static final int GBKEY_LEFT = 5;
    public static final int GBKEY_UP = 6;
    public static final int GBKEY_DOWN = 7;
    public static final int GBKEY_END = 8;
    private final boolean ALLOW_PRESSING_OPPOSITE_DIRECTIONS;
    private final ButtonInputProvider buttonInputProvider;
    private final int delay;
    private final boolean[] buttonDownOverride = new boolean[8];

    public GBJoypad(ButtonInputProvider buttonInputProvider, int n, boolean bl) {
        if (buttonInputProvider == null) {
            throw new IllegalArgumentException("buttonInputProvider must not be null");
        }
        this.buttonInputProvider = buttonInputProvider;
        this.delay = n;
        this.ALLOW_PRESSING_OPPOSITE_DIRECTIONS = bl;
    }

    public ButtonInputProvider getInputProvider() {
        return this.buttonInputProvider;
    }

    public void setState(long l) {
        int n = 0;
        while (n < this.buttonDownOverride.length) {
            this.setButtonDownOverride(n, (l & 1L << n) != 0L);
            ++n;
        }
    }

    public void setButtonDownOverride(int n, boolean bl) {
        if (n >= 0 && n < this.buttonDownOverride.length) {
            this.buttonDownOverride[n] = bl;
        }
    }

    public int getState() {
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            if (this.isButtonDown(n2)) {
                n |= 1 << n2;
            }
            ++n2;
        }
        return n;
    }

    public int getKeyStates(int n, int n2) {
        return this.getKeyStates(n, n2, this.delay);
    }

    public int getKeyStates(int n, int n2, int n3) {
        n = n3 > this.delay ? n2 : (n &= n2);
        if (((n |= 0xCF) & 0x20) == 0) {
            if (this.isButtonDown(0)) {
                n &= 0xFFFFFFFE;
            }
            if (this.isButtonDown(1)) {
                n &= 0xFFFFFFFD;
            }
            if ((n2 & 0x20) == 0) {
                if (this.isButtonDown(2)) {
                    n &= 0xFFFFFFFB;
                }
                if (this.isButtonDown(3)) {
                    n &= 0xFFFFFFF7;
                }
            } else if (n3 > this.delay / 2 || (n & 3) == 0) {
                n |= 3;
            }
        }
        if ((n & 0x10) == 0) {
            if (!this.ALLOW_PRESSING_OPPOSITE_DIRECTIONS) {
                if (this.isButtonDown(4)) {
                    n &= 0xFFFFFFFE;
                } else if (this.isButtonDown(5)) {
                    n &= 0xFFFFFFFD;
                }
                if (this.isButtonDown(6)) {
                    n &= 0xFFFFFFFB;
                } else if (this.isButtonDown(7)) {
                    n &= 0xFFFFFFF7;
                }
            } else {
                if (this.isButtonDown(4)) {
                    n &= 0xFFFFFFFE;
                }
                if (this.isButtonDown(5)) {
                    n &= 0xFFFFFFFD;
                }
                if (this.isButtonDown(6)) {
                    n &= 0xFFFFFFFB;
                }
                if (this.isButtonDown(7)) {
                    n &= 0xFFFFFFF7;
                }
            }
            if ((n2 & 0x10) != 0 && (n & 3) != 3 && (n & 0xC) != 12) {
                n |= 0x10;
            }
        }
        return n;
    }

    public boolean isButtonDown(int n) {
        boolean bl = this.buttonInputProvider.isButtonDown(n);
        if (bl) {
            this.buttonDownOverride[n] = false;
        }
        return bl || this.buttonDownOverride[n];
    }
}

