/*
 * Decompiled with CFR 0.152.
 */
package sstates;

import components.cartridge.SMSCartridge;
import components.cpu.Z80;
import components.sound.SN76489;
import components.sound.YM2413;
import components.video.TMS9918A;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import sstates.SaveState;
import system.EmulatableSystem;
import system.GameGear;
import system.MasterSystem;

public class MekaSaveState
implements SaveState {
    private static final String signature = "MEKA";
    private static final int MEKA_SAVESTATE_MIN_VERSION = 5;
    private static final int MEKA_SAVESTATE_VERSION = 14;
    private Driver driver;
    private int crc;
    protected final int[] regs = new int[14];
    protected int interruptFlipFlops;
    protected int iPeriod = 228;
    protected int iCount;
    protected int iBackup;
    protected short iRequest = (short)-1;
    protected final int[] vdpRegs = new int[16];
    protected int vdpRegStatus;
    protected int vdpRegAddress;
    protected int vdpHiByteNext;
    protected int vdpAccessFirst;
    protected int vdpReadLatch;
    protected int vdpPal;
    protected int country;
    protected int vdpCounter;
    protected int lineInterruptPending;
    protected int nmiPending;
    protected int regGlasses;
    protected int sramPages;
    protected int regSramMapper;
    protected int fmMagic;
    protected int fmReg;
    protected final int[] mapperRegs = new int[4];
    protected int inputMode = 7;
    protected int vdpLine;
    protected final int[] ram = new int[8192];
    protected final int[] vram = new int[16384];
    protected final int[] cram = new int[32];
    protected final boolean[] ramInitialized = new boolean[this.ram.length];
    protected final int[] gearToGear = new int[]{255, 255, 255};
    protected int psgLatch;
    protected int psgStereo = 255;
    protected int psgNoiseShiftReg;
    protected final int[] psgRegs = new int[8];
    protected final int[] fmRegs = new int[64];
    protected int port3F = 255;
    protected int[] cartRAM = new int[0];

    public MekaSaveState(MasterSystem masterSystem, int n) {
        this.crc = n;
        this.driver = masterSystem instanceof GameGear ? Driver.GG : Driver.SMS;
        MasterSystem.State state = masterSystem.getState();
        System.arraycopy(state.getRam(), 0, this.ram, 0, Math.min(state.getRam().length, this.ram.length));
        System.arraycopy(state.getRamInitialized(), 0, this.ramInitialized, 0, this.ramInitialized.length);
        this.regGlasses = state.getReg3Dglasses();
        this.port3F = state.getPort3F();
        this.fmMagic = (state.isFmEnabled() == state.isPsgEnabled() ? 2 : 0) | (state.isFmEnabled() ? 1 : 0);
        this.setCartridgeState(state.getCartridgeState());
        this.setCPUstate(state.getCPUstate());
        this.setVDPstate(state.getVDPstate());
        this.setPSGstate(state.getPSGstate());
        this.setFMstate(state.getFMstate());
    }

    public MekaSaveState(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[signature.length()];
        bufferedInputStream.read(byArray);
        String string = new String(byArray);
        if (!signature.equals(string)) {
            bufferedInputStream.close();
            throw new UnsupportedOperationException("Invalid signature!");
        }
        bufferedInputStream.read();
        int n = bufferedInputStream.read();
        if (n > 14) {
            bufferedInputStream.close();
            throw new UnsupportedOperationException("Invalid version number!");
        }
        System.out.println("Loading savestate with version " + Integer.toHexString(n));
        if (n < 5) {
            bufferedInputStream.close();
            throw new UnsupportedOperationException("Invalid version number!");
        }
        switch (bufferedInputStream.read()) {
            case 0: {
                this.driver = Driver.SMS;
                break;
            }
            case 1: {
                this.driver = Driver.GG;
            }
        }
        byArray = new byte[(int)file.length() - byArray.length - 2];
        bufferedInputStream.read(byArray);
        bufferedInputStream.close();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        if (n >= 12) {
            this.crc = byteBuffer.getInt();
        }
        this.readSMS(byteBuffer);
        int n2 = 0;
        while (n2 < this.mapperRegs.length) {
            this.mapperRegs[n2] = byteBuffer.get() & 0xFF;
            ++n2;
        }
        if (n < 14) {
            this.mapperRegs[3] = 0;
        }
        if (n >= 13) {
            this.vdpLine = byteBuffer.getShort() & 0xFFFF;
        }
        byArray = new byte[this.ram.length];
        byteBuffer.get(byArray);
        n2 = 0;
        while (n2 < this.ram.length) {
            this.ram[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        Arrays.fill(this.ramInitialized, true);
        byArray = new byte[this.vram.length];
        byteBuffer.get(byArray);
        n2 = 0;
        while (n2 < this.vram.length) {
            this.vram[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        switch (this.driver) {
            case SMS: {
                byArray = new byte[this.cram.length];
                byteBuffer.get(byArray);
                n2 = 0;
                while (n2 < this.cram.length) {
                    this.cram[n2] = byArray[n2] & 0xFF;
                    ++n2;
                }
                break;
            }
            case GG: {
                byArray = new byte[2 * this.cram.length];
                byteBuffer.get(byArray);
                n2 = 0;
                while (n2 < this.cram.length) {
                    this.cram[n2] = (byArray[2 * n2 + 1] & 0xFF) << 8 | byArray[2 * n2] & 0xFF;
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.gearToGear.length) {
                    this.gearToGear[n2] = byteBuffer.get() & 0xFF;
                    ++n2;
                }
                break;
            }
        }
        if (n >= 8) {
            this.readPSG(byteBuffer);
        } else {
            n2 = 1;
            while (n2 < this.psgRegs.length) {
                this.psgRegs[n2] = 15;
                n2 += 2;
            }
        }
        if (n >= 3) {
            n2 = 0;
            while (n2 < this.fmRegs.length) {
                this.fmRegs[n2] = byteBuffer.get() & 0xFF;
                ++n2;
            }
        }
        if (n >= 4) {
            this.port3F = byteBuffer.get() & 0xFF;
        }
        if (n < 7) {
            this.sramPages *= 2;
        }
        this.cartRAM = new int[this.sramPages * 8192];
        byArray = new byte[this.cartRAM.length];
        byteBuffer.get(byArray);
        n2 = 0;
        while (n2 < this.cartRAM.length) {
            this.cartRAM[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        if (n < 10) {
            this.interruptFlipFlops = this.interruptFlipFlops & 0xB7 | ((this.interruptFlipFlops & 0x40) != 0 ? 8 : 0);
        }
    }

    @Override
    public void writeToFile(File file) throws IOException {
        System.out.println("Saving savestate with version d");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(signature.getBytes());
        bufferedOutputStream.write(26);
        bufferedOutputStream.write(13);
        switch (this.driver) {
            case SMS: {
                bufferedOutputStream.write(0);
                break;
            }
            case GG: {
                bufferedOutputStream.write(1);
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(512).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(this.crc);
        this.writeSMS(byteBuffer);
        int n = 0;
        while (n < 4) {
            byteBuffer.put((byte)this.mapperRegs[n]);
            ++n;
        }
        byteBuffer.putShort((short)this.vdpLine);
        bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        byteBuffer.clear();
        byte[] byArray = new byte[this.ram.length];
        int n2 = 0;
        while (n2 < this.ram.length) {
            byArray[n2] = (byte)this.ram[n2];
            ++n2;
        }
        bufferedOutputStream.write(byArray);
        byArray = new byte[this.vram.length];
        n2 = 0;
        while (n2 < this.vram.length) {
            byArray[n2] = (byte)this.vram[n2];
            ++n2;
        }
        bufferedOutputStream.write(byArray);
        switch (this.driver) {
            case SMS: {
                byArray = new byte[this.cram.length];
                n2 = 0;
                while (n2 < this.cram.length) {
                    byArray[n2] = (byte)this.cram[n2];
                    ++n2;
                }
                bufferedOutputStream.write(byArray);
                break;
            }
            case GG: {
                n2 = 0;
                while (n2 < this.cram.length) {
                    byteBuffer.putShort((short)this.cram[n2]);
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.gearToGear.length) {
                    byteBuffer.put((byte)this.gearToGear[n2]);
                    ++n2;
                }
                break;
            }
        }
        this.writePSG(byteBuffer);
        n2 = 0;
        while (n2 < this.fmRegs.length) {
            byteBuffer.put((byte)this.fmRegs[n2]);
            ++n2;
        }
        byteBuffer.put((byte)this.port3F);
        bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        byArray = new byte[this.cartRAM.length];
        n2 = 0;
        while (n2 < this.cartRAM.length) {
            byArray[n2] = (byte)this.cartRAM[n2];
            ++n2;
        }
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.write("EOF".getBytes());
        bufferedOutputStream.close();
    }

    private void readSMS(ByteBuffer byteBuffer) {
        this.readZ80(byteBuffer);
        int n = 0;
        while (n < this.vdpRegs.length) {
            this.vdpRegs[n] = byteBuffer.get() & 0xFF;
            ++n;
        }
        byteBuffer.get();
        this.vdpRegStatus = byteBuffer.get() & 0xFF;
        this.vdpRegAddress = byteBuffer.getShort() & 0xFFFF;
        this.vdpHiByteNext = byteBuffer.get() & 0xFF;
        this.vdpAccessFirst = byteBuffer.get() & 0xFF;
        this.vdpReadLatch = byteBuffer.get() & 0xFF;
        this.vdpPal = byteBuffer.get() & 0xFF;
        this.country = byteBuffer.get() & 0xFF;
        this.vdpCounter = byteBuffer.getInt();
        byteBuffer.position(byteBuffer.position() + 3);
        this.lineInterruptPending = byteBuffer.get() & 0xFF;
        this.nmiPending = byteBuffer.get() & 0xFF;
        this.regGlasses = byteBuffer.get() & 0xFF;
        this.sramPages = byteBuffer.get() & 0xFF;
        this.regSramMapper = byteBuffer.get() & 0xFF;
        this.fmMagic = byteBuffer.get() & 0xFF;
        this.fmReg = byteBuffer.get() & 0xFF;
        this.inputMode = byteBuffer.get() & 0xFF;
    }

    private void writeSMS(ByteBuffer byteBuffer) {
        this.writeZ80(byteBuffer);
        int n = 0;
        while (n < this.vdpRegs.length) {
            byteBuffer.put((byte)this.vdpRegs[n]);
            ++n;
        }
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)this.vdpRegStatus);
        byteBuffer.putShort((short)this.vdpRegAddress);
        byteBuffer.put((byte)this.vdpHiByteNext);
        byteBuffer.put((byte)this.vdpAccessFirst);
        byteBuffer.put((byte)this.vdpReadLatch);
        byteBuffer.put((byte)this.vdpPal);
        byteBuffer.put((byte)this.country);
        byteBuffer.putInt(this.vdpCounter);
        byteBuffer.position(byteBuffer.position() + 3);
        byteBuffer.put((byte)this.lineInterruptPending);
        byteBuffer.put((byte)this.nmiPending);
        byteBuffer.put((byte)this.regGlasses);
        byteBuffer.put((byte)this.sramPages);
        byteBuffer.put((byte)this.regSramMapper);
        byteBuffer.put((byte)this.fmMagic);
        byteBuffer.put((byte)this.fmReg);
        byteBuffer.put((byte)this.inputMode);
    }

    private void readZ80(ByteBuffer byteBuffer) {
        int n = 0;
        while (n < 12) {
            this.regs[n] = byteBuffer.getShort() & 0xFFFF;
            ++n;
        }
        this.interruptFlipFlops = byteBuffer.get() & 0xFF;
        this.regs[12] = byteBuffer.get() & 0xFF;
        this.regs[13] = byteBuffer.get() & 0xFF;
        byteBuffer.get();
        this.iPeriod = byteBuffer.getInt();
        this.iCount = byteBuffer.getInt();
        this.iBackup = byteBuffer.getInt();
        this.iRequest = byteBuffer.getShort();
        byteBuffer.position(byteBuffer.position() + 1 + 1 + 2 + 1 + 4 + 1);
    }

    private void writeZ80(ByteBuffer byteBuffer) {
        int n = 0;
        while (n < 12) {
            byteBuffer.putShort((short)this.regs[n]);
            ++n;
        }
        byteBuffer.put((byte)this.interruptFlipFlops);
        byteBuffer.put((byte)this.regs[12]);
        byteBuffer.put((byte)this.regs[13]);
        byteBuffer.put((byte)0);
        byteBuffer.putInt(this.iPeriod);
        byteBuffer.putInt(this.iCount);
        byteBuffer.putInt(this.iBackup);
        byteBuffer.putShort(this.iRequest);
        byteBuffer.position(byteBuffer.position() + 1 + 1 + 2 + 1 + 4 + 1);
    }

    private void readPSG(ByteBuffer byteBuffer) {
        int n = 0;
        while (n < this.psgRegs.length) {
            this.psgRegs[n] = byteBuffer.getShort();
            ++n;
        }
        this.psgLatch = byteBuffer.get() & 0xFF;
        this.psgStereo = byteBuffer.get() & 0xFF;
        this.psgNoiseShiftReg = byteBuffer.getShort() & 0xFFFF;
        byteBuffer.position(byteBuffer.position() + this.psgRegs.length / 2 * 7);
    }

    private void writePSG(ByteBuffer byteBuffer) {
        int n = 0;
        while (n < this.psgRegs.length) {
            byteBuffer.putShort((short)this.psgRegs[n]);
            ++n;
        }
        byteBuffer.put((byte)this.psgLatch);
        byteBuffer.put((byte)this.psgStereo);
        byteBuffer.putShort((short)this.psgNoiseShiftReg);
        byteBuffer.position(byteBuffer.position() + this.psgRegs.length / 2 * 7);
    }

    public void setCPUstate(Z80.State state) {
        this.regs[0] = state.getRegAF();
        this.regs[1] = state.getRegBC();
        this.regs[2] = state.getRegDE();
        this.regs[3] = state.getRegHL();
        this.regs[4] = state.getRegIX();
        this.regs[5] = state.getRegIY();
        this.regs[6] = state.getRegPC();
        this.regs[7] = state.getRegSP();
        this.regs[8] = state.getRegAFex();
        this.regs[9] = state.getRegBCex();
        this.regs[10] = state.getRegDEex();
        this.regs[11] = state.getRegHLex();
        this.regs[12] = state.getRegI();
        this.regs[13] = state.getRegRbit7() | state.getRegR() & 0x7F;
        if (state.isNmiPending()) {
            this.nmiPending = 1;
        }
        int n = state.getInterruptMode() << 1;
        if (state.isInterruptFlipFlop1()) {
            n |= 1;
        }
        if (state.isInterruptFlipFlop2()) {
            n |= 8;
        }
        if (state.isAfterEI()) {
            n |= 0x20;
        }
        if (state.isHalted()) {
            n |= 0x80;
        }
        this.interruptFlipFlops = n;
    }

    public void setVDPstate(TMS9918A.State state) {
        int n = 0;
        while (n < this.vdpRegs.length) {
            this.vdpRegs[n] = state.getReg(n);
            ++n;
        }
        System.arraycopy(state.getCram(), 0, this.cram, 0, this.cram.length);
        System.arraycopy(state.getVram(), 0, this.vram, 0, this.vram.length);
        this.vdpHiByteNext = state.isHiByteNext() ? 1 : 0;
        this.vdpLine = state.getLine();
        this.vdpRegAddress = state.getRegAddress();
        this.vdpRegStatus = state.getRegStatus();
        this.vdpPal = state.getRegCode() >> 1 & state.getRegCode() & 1;
        this.vdpReadLatch = state.getBuffer();
        this.vdpAccessFirst = state.getRegAddress() & 0xFF;
        this.vdpCounter = state.getCounter();
        this.iCount = state.getTimer();
        this.lineInterruptPending = state.isLineInterruptPending() ? 1 : 0;
    }

    public void setPSGstate(SN76489.State state) {
        int n = 0;
        while (n < 3) {
            this.psgRegs[n * 2] = state.getRegTone(n);
            ++n;
        }
        this.psgRegs[6] = state.getRegNoise();
        n = 0;
        while (n < 4) {
            this.psgRegs[n * 2 + 1] = state.getRegVolume(n);
            ++n;
        }
        this.psgStereo = state.getRegStereo();
        this.psgLatch = state.getLatchedRegister();
        this.psgNoiseShiftReg = state.getRegLinearFeedbackShift();
    }

    public void setFMstate(YM2413.State state) {
        int n = 0;
        while (n < this.fmRegs.length) {
            this.fmRegs[n] = state.getReg(n);
            ++n;
        }
        this.fmReg = state.getLatchedRegister();
    }

    public void setCartridgeState(SMSCartridge.State state) {
        this.mapperRegs[3] = state.getFrame3ROMPageNumber();
        this.mapperRegs[2] = state.getFrame2ROMPageNumber();
        this.mapperRegs[1] = state.getFrame1ROMPageNumber();
        this.mapperRegs[0] = state.getFrame0ROMPageNumber();
        this.sramPages = state.getRAM().length / 8192;
        int[] nArray = state.getRAM();
        this.cartRAM = new int[nArray.length];
        System.arraycopy(nArray, 0, this.cartRAM, 0, nArray.length);
        int n = state.getRamPageNumber() << 2;
        if (state.isRamWriteProtect()) {
            n |= 0x10;
        }
        if (state.isRamEnabled()) {
            n |= 8;
        }
        this.regSramMapper = n;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public int getCrc() {
        return this.crc;
    }

    public int getInterruptFlipFlops() {
        return this.interruptFlipFlops;
    }

    public int getICount() {
        return this.iCount;
    }

    public int getVdpRegStatus() {
        return this.vdpRegStatus;
    }

    public int getVdpRegAddress() {
        return this.vdpRegAddress;
    }

    public int getVdpHiByteNext() {
        return this.vdpHiByteNext;
    }

    public int getVdpAccessFirst() {
        return this.vdpAccessFirst;
    }

    public int getVdpReadLatch() {
        return this.vdpReadLatch;
    }

    public int getVdpPal() {
        return this.vdpPal;
    }

    public int getCountry() {
        return this.country;
    }

    public void setCountry(int n) {
        this.country = n;
    }

    public int getVdpCounter() {
        return this.vdpCounter;
    }

    public int getLineInterruptPending() {
        return this.lineInterruptPending;
    }

    public int getNmiPending() {
        return this.nmiPending;
    }

    public int getRegGlasses() {
        return this.regGlasses;
    }

    public int getSramPages() {
        return this.sramPages;
    }

    public int getRegSramMapper() {
        return this.regSramMapper;
    }

    public int getFmMagic() {
        return this.fmMagic;
    }

    public void setFmMagic(int n) {
        this.fmMagic = n;
    }

    public int getFmReg() {
        return this.fmReg;
    }

    public void setFmReg(int n) {
        this.fmReg = n;
    }

    public int getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(int n) {
        this.inputMode = n;
    }

    public int getVdpLine() {
        return this.vdpLine;
    }

    public void setGearToGear(int[] nArray) {
        System.arraycopy(nArray, 0, this.gearToGear, 0, nArray.length);
    }

    public int getPsgLatch() {
        return this.psgLatch;
    }

    public int getPsgStereo() {
        return this.psgStereo;
    }

    public int getPsgNoiseShiftReg() {
        return this.psgNoiseShiftReg;
    }

    public int getPort3F() {
        return this.port3F;
    }

    @Override
    public EmulatableSystem.State getState() {
        return new MasterSystem.UnmodifiableState(){

            @Override
            public MasterSystem.State clone() {
                return this;
            }

            @Override
            public TMS9918A.State getVDPstate() {
                return new TMS9918A.UnmodifiableState(){

                    @Override
                    public TMS9918A.State clone() {
                        return this;
                    }

                    @Override
                    public int getTimer() {
                        return MekaSaveState.this.getICount();
                    }

                    @Override
                    public boolean isLineInterruptPending() {
                        return MekaSaveState.this.getLineInterruptPending() != 0;
                    }

                    @Override
                    public boolean isHiByteNext() {
                        return MekaSaveState.this.getVdpHiByteNext() != 0;
                    }

                    @Override
                    public int[] getVram() {
                        return (this).MekaSaveState.this.vram;
                    }

                    @Override
                    public int getReg(int n) {
                        return (this).MekaSaveState.this.vdpRegs[n];
                    }

                    @Override
                    public int getRegStatus() {
                        return MekaSaveState.this.getVdpRegStatus();
                    }

                    @Override
                    public int getRegCode() {
                        return MekaSaveState.this.getVdpPal() != 0 ? 3 : 0;
                    }

                    @Override
                    public int getRegAddress() {
                        return MekaSaveState.this.getVdpRegAddress();
                    }

                    @Override
                    public int getLine() {
                        return MekaSaveState.this.getVdpLine();
                    }

                    @Override
                    public int[] getCram() {
                        return (this).MekaSaveState.this.cram;
                    }

                    @Override
                    public int getCounter() {
                        return MekaSaveState.this.getVdpCounter();
                    }

                    @Override
                    public int getBuffer() {
                        return MekaSaveState.this.getVdpReadLatch();
                    }

                    @Override
                    public int getCramLatch() {
                        return MekaSaveState.this.getVdpReadLatch();
                    }
                };
            }

            @Override
            public boolean isCartridgeEnabled() {
                return true;
            }

            @Override
            public boolean isCardEnabled() {
                return false;
            }

            @Override
            public boolean isBiosEnabled() {
                return false;
            }

            @Override
            public boolean isRamEnabled() {
                return true;
            }

            @Override
            public boolean isIoEnabled() {
                return true;
            }

            @Override
            public boolean isPsgEnabled() {
                return (MekaSaveState.this.getFmMagic() & 2) >> 1 == (MekaSaveState.this.getFmMagic() & 1);
            }

            @Override
            public boolean isFmEnabled() {
                return (MekaSaveState.this.getFmMagic() & 1) != 0;
            }

            @Override
            public int getReg3Dglasses() {
                return MekaSaveState.this.regGlasses;
            }

            @Override
            public int[] getRam() {
                return MekaSaveState.this.ram;
            }

            @Override
            public int getPort3F() {
                return MekaSaveState.this.port3F;
            }

            @Override
            public SN76489.State getPSGstate() {
                return new SN76489.UnmodifiableState(){

                    @Override
                    public SN76489.State clone() {
                        return this;
                    }

                    @Override
                    public int getRegVolume(int n) {
                        return (this).MekaSaveState.this.psgRegs[n * 2 + 1];
                    }

                    @Override
                    public int getRegTone(int n) {
                        return (this).MekaSaveState.this.psgRegs[n * 2];
                    }

                    @Override
                    public int getRegStereo() {
                        return MekaSaveState.this.getDriver() == Driver.GG ? MekaSaveState.this.getPsgStereo() : 255;
                    }

                    @Override
                    public int getRegNoise() {
                        return (this).MekaSaveState.this.psgRegs[6];
                    }

                    @Override
                    public int getRegLinearFeedbackShift() {
                        return (this).MekaSaveState.this.psgNoiseShiftReg;
                    }

                    @Override
                    public int getLatchedRegister() {
                        return (this).MekaSaveState.this.psgLatch;
                    }
                };
            }

            @Override
            public YM2413.State getFMstate() {
                return new YM2413.UnmodifiableState(){

                    @Override
                    public YM2413.State clone() {
                        return this;
                    }

                    @Override
                    public int getReg(int n) {
                        return (this).MekaSaveState.this.fmRegs[n];
                    }

                    @Override
                    public int getLatchedRegister() {
                        return MekaSaveState.this.getFmReg();
                    }
                };
            }

            @Override
            public SMSCartridge.State getCartridgeState() {
                return new SMSCartridge.UnmodifiableState(){

                    @Override
                    public SMSCartridge.State clone() {
                        return this;
                    }

                    @Override
                    public int getFrame3ROMPageNumber() {
                        return (this).MekaSaveState.this.mapperRegs[3];
                    }

                    @Override
                    public int getFrame2ROMPageNumber() {
                        return (this).MekaSaveState.this.mapperRegs[2];
                    }

                    @Override
                    public int getFrame1ROMPageNumber() {
                        return (this).MekaSaveState.this.mapperRegs[1];
                    }

                    @Override
                    public int getFrame0ROMPageNumber() {
                        return (this).MekaSaveState.this.mapperRegs[0];
                    }

                    @Override
                    public int getRamPageNumber() {
                        return ((this).MekaSaveState.this.regSramMapper & 4) >> 2;
                    }

                    @Override
                    public boolean isRamWriteProtect() {
                        return ((this).MekaSaveState.this.regSramMapper & 0x10) != 0;
                    }

                    @Override
                    public boolean isRamEnabled() {
                        return ((this).MekaSaveState.this.regSramMapper & 8) != 0;
                    }

                    @Override
                    public int[] getRAM() {
                        return (this).MekaSaveState.this.cartRAM;
                    }
                };
            }

            @Override
            public Z80.State getCPUstate() {
                return new Z80.UnmodifiableState(){

                    @Override
                    public Z80.State clone() {
                        return this;
                    }

                    @Override
                    public boolean isPinNMI() {
                        return false;
                    }

                    @Override
                    public boolean isPinINT() {
                        return false;
                    }

                    @Override
                    public boolean isNmiPending() {
                        return MekaSaveState.this.getNmiPending() != 0;
                    }

                    @Override
                    public boolean isInterruptFlipFlop2() {
                        return (MekaSaveState.this.getInterruptFlipFlops() & 8) != 0;
                    }

                    @Override
                    public boolean isInterruptFlipFlop1() {
                        return (MekaSaveState.this.getInterruptFlipFlops() & 1) != 0;
                    }

                    @Override
                    public boolean isHalted() {
                        return (MekaSaveState.this.getInterruptFlipFlops() & 0x80) != 0;
                    }

                    @Override
                    public boolean isAfterEI() {
                        return (MekaSaveState.this.getInterruptFlipFlops() & 0x20) != 0;
                    }

                    @Override
                    public int getRegWZ() {
                        return 0;
                    }

                    @Override
                    public int getRegSP() {
                        return (this).MekaSaveState.this.regs[7];
                    }

                    @Override
                    public int getRegRbit7() {
                        return (this).MekaSaveState.this.regs[13] & 0x80;
                    }

                    @Override
                    public int getRegR() {
                        return (this).MekaSaveState.this.regs[13] & 0x7F;
                    }

                    @Override
                    public int getRegPC() {
                        return (this).MekaSaveState.this.regs[6];
                    }

                    @Override
                    public int getRegIY() {
                        return (this).MekaSaveState.this.regs[5];
                    }

                    @Override
                    public int getRegIX() {
                        return (this).MekaSaveState.this.regs[4];
                    }

                    @Override
                    public int getRegI() {
                        return (this).MekaSaveState.this.regs[12];
                    }

                    @Override
                    public int getRegHLex() {
                        return (this).MekaSaveState.this.regs[11];
                    }

                    @Override
                    public int getRegHL() {
                        return (this).MekaSaveState.this.regs[3];
                    }

                    @Override
                    public int getRegDEex() {
                        return (this).MekaSaveState.this.regs[10];
                    }

                    @Override
                    public int getRegDE() {
                        return (this).MekaSaveState.this.regs[2];
                    }

                    @Override
                    public int getRegBCex() {
                        return (this).MekaSaveState.this.regs[9];
                    }

                    @Override
                    public int getRegBC() {
                        return (this).MekaSaveState.this.regs[1];
                    }

                    @Override
                    public int getRegAFex() {
                        return (this).MekaSaveState.this.regs[8];
                    }

                    @Override
                    public int getRegAF() {
                        return (this).MekaSaveState.this.regs[0];
                    }

                    @Override
                    public int getInterruptMode() {
                        return (MekaSaveState.this.getInterruptFlipFlops() & 6) >> 1;
                    }

                    @Override
                    public int getCycleCount() {
                        return 0;
                    }
                };
            }

            @Override
            public boolean[] getRamInitialized() {
                return MekaSaveState.this.ramInitialized;
            }
        };
    }

    private static enum Driver {
        SMS,
        GG;

    }
}

