/*
 * Decompiled with CFR 0.152.
 */
package platform;

import common.CheckBoxMenuItem;
import common.FileChangeWatcher;
import common.FileChooser;
import common.HistoryBox;
import common.ImprovedTabbedPaneUI;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import components.OutputListener;
import hexeditor.AbstractHexEditorModel;
import hexeditor.DefaultHexEditorAnnotationModel;
import hexeditor.DefaultHexEditorColorModel;
import hexeditor.DefaultHexEditorStyleModel;
import hexeditor.HexEditor;
import hexeditor.HexEditorSelectionEvent;
import hexeditor.HexEditorSelectionListener;
import hexeditor.HexEditorSelectionModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.RootPaneContainer;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import patching.IPS;
import platform.AnonymousLabelRejector;
import platform.Emulicious;
import platform.GoToDialog;
import platform.LabelProvider;
import platform.LabelProviderUtilities;
import platform.MemoryEditorModel;
import platform.SourceProvider;
import util.map.HashIntMap;
import util.map.HashMap;
import util.map.IntMap;
import util.map.Map;
import util.set.IntHashSet;
import util.set.IntSet;
import util.string.StringUtilities;

public class MemoryEditor
extends JPanel {
    public static final int EVENT_ID_ROM_CHANGED = 0;
    public static final int EVENT_ID_RAM_CHANGED = 1;
    public static final int EVENT_ID_VRAM_CHANGED = 2;
    public static final int EVENT_ID_SRAM_CHANGED = 3;
    public static final int EVENT_ID_PAL_CHANGED = 4;
    public static final int EVENT_ID_CPU_BYTE_CHANGED = 5;
    public static final int EVENT_ID_ADDITIONAL_CHANGED = 6;
    private static final int ANNOTATION_VRAM_ADDRESS = -1;
    private static final Color UNINITIALIZED_COLOR = Color.GRAY;
    private static final Color CODE_COLOR = new Color(1462127);
    private static final Color TILE_COLOR = new Color(13828113);
    private static final Color PALETTE_COLOR = new Color(44493);
    private static final Color TILEMAP_COLOR = new Color(7478898);
    private static final Color SPRITE_COLOR = new Color(9706551);
    private static final Color SOUND_COLOR = new Color(0x808080);
    private static FindDialog findDialog;
    private static MemoryEditorWindow window;
    private static LinkedList<OutputListener> listenerList;
    private static OutputListener[] listeners;
    final MemoryEditorModel model;
    private MemoryEditorModel.MemoryModel[] additionalMemoryModels;
    private final JLabel statusBarLabel = new JLabel(" "){
        private final Graphics2D dummyGraphics;
        {
            this.dummyGraphics = new BufferedImage(1, 1, 2).createGraphics();
        }

        @Override
        public Dimension getPreferredSize() {
            this.paint(this.dummyGraphics);
            return super.getPreferredSize();
        }

        @Override
        public Font getFont() {
            return MemoryEditor.this.getFont();
        }

        @Override
        public Color getForeground() {
            Container container = MemoryEditor.this.getParent();
            return container != null ? container.getForeground() : super.getForeground();
        }
    };
    private final JTabbedPane tabbedPane;
    private final FlowLayout followRegisterPanelFlowLayout = new FlowLayout(1, 0, 0);
    private final GridLayout followRegisterPanelGridLayout = new GridLayout();
    private final Container followRegisterContainer = new Container(){
        private Font prevMemoryEditorFont;
        private Font font;
        {
            this.setLayout(MemoryEditor.this.followRegisterPanelFlowLayout);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.width = 0;
            return dimension;
        }

        @Override
        public Font getFont() {
            Font font = MemoryEditor.this.getFont();
            if (font != this.prevMemoryEditorFont) {
                this.font = font.deriveFont(font.getStyle());
                this.prevMemoryEditorFont = font;
            }
            return this.font;
        }

        @Override
        public Color getForeground() {
            Container container = MemoryEditor.this.getParent();
            return container != null ? container.getForeground() : super.getForeground();
        }
    };
    private HexEditorPanel romPanel;
    private HexEditorPanel ramPanel;
    private HexEditorPanel cpuPanel;
    private HexEditorPanel palPanel;
    private HexEditorPanel vramPanel;
    private HexEditorPanel[] additionalPanels;
    private Color selectionForeground = null;
    private Color selectionBackground = null;
    private final int tabPlacement;
    private HexEditorPanel sramPanel;
    private JButton followRegisterButton;
    private final ChangeWatcher changeWatcher;
    private boolean selectingFollowRegister;
    private int followRegister = -1;
    private JRadioButton buttonFollowRegisterNone;
    private final IntMap romAnnotations = new HashIntMap();
    private final IntMap ramAnnotations = new HashIntMap();
    private final IntMap vramAnnotations = new HashIntMap();
    private final IntMap sramAnnotations = new HashIntMap();
    private IntMap[] additionalMemoryAnnotations = new IntMap[0];
    private boolean showRegisters;
    private boolean showLabels;
    private boolean showDebuggerHighlighting;
    private File romFile;
    private File ramFile;
    private File vramFile;
    private File sramFile;
    private File palFile;
    private File tableFile;
    Map<String> table;
    IntSet tablePrefixBytes;
    FileChangeWatcher tableFileChangeWatcher;

    static {
        listenerList = new LinkedList();
        listeners = new OutputListener[0];
    }

    private MemoryEditor(MemoryEditorModel memoryEditorModel, int n, int n2, boolean bl) {
        this.model = memoryEditorModel;
        this.changeWatcher = new ChangeWatcher(64);
        this.tabPlacement = n;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBackground(null);
        this.showLabels = Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorShowLabels"));
        this.showRegisters = Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorShowRegisters"));
        this.showDebuggerHighlighting = Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorShowDebuggerHighlighting"));
        Container container = new Container();
        container.setLayout(new BorderLayout());
        this.add((Component)container, "Center");
        this.tabbedPane = new JTabbedPane(n, n2){
            JTabbedPane parentPane;

            @Override
            public void setUI(TabbedPaneUI tabbedPaneUI) {
                Container container = MemoryEditor.this.getParent();
                if (container instanceof JTabbedPane) {
                    this.parentPane = (JTabbedPane)container;
                    if (this.parentPane.getUI() instanceof ImprovedTabbedPaneUI) {
                        final ImprovedTabbedPaneUI improvedTabbedPaneUI = (ImprovedTabbedPaneUI)this.parentPane.getUI();
                        tabbedPaneUI = new ImprovedTabbedPaneUI(){

                            @Override
                            public Color getLightHighlight() {
                                return improvedTabbedPaneUI.getLightHighlight();
                            }

                            @Override
                            public Color getShadow() {
                                return improvedTabbedPaneUI.getShadow();
                            }

                            @Override
                            public Color getDarkShadow() {
                                return improvedTabbedPaneUI.getDarkShadow();
                            }

                            @Override
                            protected void paintContentBorder(Graphics graphics, int n, int n2) {
                                Color color = (Color)UIManager.getDefaults().remove("TabbedPane.contentAreaColor");
                                super.paintContentBorder(graphics, n, -1);
                                UIManager.put("TabbedPane.contentAreaColor", color);
                            }
                        };
                    }
                }
                super.setUI(tabbedPaneUI);
            }

            @Override
            public Color getBackground() {
                return this.parentPane != null ? this.parentPane.getBackground() : super.getBackground();
            }

            @Override
            public Color getForeground() {
                return this.parentPane != null ? this.parentPane.getForeground() : super.getForeground();
            }

            @Override
            public Color getBackgroundAt(int n) {
                Color color = this.parentPane != null ? this.parentPane.getBackgroundAt(0) : null;
                return color != null ? color : super.getBackgroundAt(n);
            }

            @Override
            public Color getForegroundAt(int n) {
                Color color = this.parentPane != null ? this.parentPane.getForegroundAt(0) : null;
                return color != null ? color : super.getForegroundAt(n);
            }
        };
        this.updateModel();
        container.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HexEditorPanel hexEditorPanel = MemoryEditor.this.getCurrentPanel();
                if (hexEditorPanel != null) {
                    hexEditorPanel.clearSelection();
                }
                MemoryEditor.this.statusBarLabel.setText(" ");
                if (!MemoryEditor.this.selectingFollowRegister) {
                    MemoryEditor.this.buttonFollowRegisterNone.setSelected(true);
                    MemoryEditor.this.setFollowRegister(-1);
                }
            }
        });
        this.statusBarLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            private void handleMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    HexEditorPanel hexEditorPanel = MemoryEditor.this.getCurrentPanel();
                    int n = hexEditorPanel.getFirstSelectedAddress();
                    if (n < 0) {
                        return;
                    }
                    int n2 = hexEditorPanel.getLastSelectedAddress();
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    MenuItem menuItem = new MenuItem(n == n2 ? "Copy Address" : "Copy Address Range");
                    jPopupMenu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            MemoryEditor.this.copySelectedAddressToClipboard();
                        }
                    });
                    jPopupMenu.show(MemoryEditor.this.statusBarLabel, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        if (bl) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(null);
            jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel.setOpaque(false);
            jPanel.add(this.statusBarLabel);
            container.add((Component)jPanel, "South");
        }
        this.add((Component)this.followRegisterContainer, "South");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tabbedPane.updateUI();
    }

    @Override
    public Font getFont() {
        return this.romPanel != null ? this.romPanel.getFont() : super.getFont();
    }

    @Override
    protected void validateTree() {
        boolean bl = this.getCurrentPanel().isSelectedAddressVisible();
        if (this.followRegisterContainer.getWidth() > 0) {
            if (!(this.followRegisterContainer.getLayout() instanceof FlowLayout)) {
                this.followRegisterContainer.setLayout(this.followRegisterPanelFlowLayout);
            }
            if (this.followRegisterContainer.getLayout() instanceof FlowLayout && this.followRegisterContainer.getWidth() < this.followRegisterContainer.getPreferredSize().width) {
                this.followRegisterPanelGridLayout.setRows(2);
                this.followRegisterPanelGridLayout.setColumns((this.followRegisterContainer.getComponentCount() + 1) / 2);
                this.followRegisterContainer.setLayout(this.followRegisterPanelGridLayout);
            }
        }
        if (this.tabbedPane.getHeight() > 0 && this.tabPlacement != 3 && this.tabPlacement != 1) {
            if (this.tabbedPane.getHeight() <= this.calcMinimumTabHeaderHeight()) {
                this.tabbedPane.setTabPlacement(3);
            } else {
                this.tabbedPane.setTabPlacement(this.tabPlacement);
            }
        }
        super.validateTree();
        if (bl && !this.getCurrentPanel().isSelectedAddressVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemoryEditor.this.getCurrentPanel().scrollSelectedAddressToVisible();
                }
            });
        }
    }

    public static MemoryEditor create(MemoryEditorModel memoryEditorModel) {
        return MemoryEditor.create(memoryEditorModel, 1, 0, true);
    }

    public static MemoryEditor create(MemoryEditorModel memoryEditorModel, int n, int n2, boolean bl) {
        return new MemoryEditor(memoryEditorModel, n, n2, bl);
    }

    public JLabel getStatusBarLabel() {
        return this.statusBarLabel;
    }

    public JButton createFollowRegisterButton() {
        final JButton jButton = new JButton("   ", new Icon(){
            final Color DARK_YELLOW = new Color(128, 128, 0);

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                int[] nArray = new int[]{n + 3, n + 3, n + 10};
                int[] nArray2 = new int[]{n2, n2 + 9, n2 + 4};
                graphics.setColor(Color.YELLOW);
                graphics.fillPolygon(nArray, nArray2, nArray.length);
                graphics.setColor(this.DARK_YELLOW);
                graphics.drawPolygon(nArray, nArray2, nArray.length);
                graphics.setColor(this.DARK_YELLOW);
                graphics.drawRect(n, n2 + 2, 3, 5);
                graphics.setColor(Color.YELLOW);
                graphics.fillRect(n + 1, n2 + 3, 4, 3);
                graphics.setColor(color);
            }

            @Override
            public int getIconWidth() {
                return 8;
            }

            @Override
            public int getIconHeight() {
                return 8;
            }
        }){

            @Override
            public Color getForeground() {
                Container container = this.getParent();
                return container != null && container.getParent() != null ? container.getParent().getForeground() : super.getForeground();
            }
        };
        jButton.setToolTipText("Follow Register");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n = 0;
                while (n < MemoryEditor.this.followRegisterContainer.getComponentCount()) {
                    Component component = MemoryEditor.this.followRegisterContainer.getComponent(n);
                    if (component instanceof JRadioButton) {
                        JRadioButton jRadioButton = (JRadioButton)component;
                        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(jRadioButton.getText());
                        jRadioButtonMenuItem.setModel(jRadioButton.getModel());
                        jPopupMenu.add(jRadioButtonMenuItem);
                    }
                    ++n;
                }
                jPopupMenu.show(jButton, jButton.getX() + jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getY() + jButton.getHeight());
            }
        });
        this.followRegisterButton = jButton;
        return this.followRegisterButton;
    }

    private HexEditorPanel addRomHexEditorPanel() {
        ArrayMemoryModel arrayMemoryModel = new ArrayMemoryModel("ROM", this.model.getROM(), 0){

            @Override
            public boolean hasLabel(int n) {
                return MemoryEditor.this.model.hasLabel(n);
            }

            @Override
            public List<String> getLabels(int n) {
                if (MemoryEditor.this.model.hasLabel(n)) {
                    return MemoryEditor.this.model.getLabels(n);
                }
                return null;
            }

            @Override
            public String getSource(int n) {
                return null;
            }

            @Override
            public boolean isInitialized(int n) {
                return true;
            }

            @Override
            public String addressToString(int n) {
                return MemoryEditor.this.model.romAddressToString(n);
            }
        };
        AbstractDataTypeProvider abstractDataTypeProvider = new AbstractDataTypeProvider(){

            @Override
            public boolean hasDataType(int n) {
                return MemoryEditor.this.model.hasDataType(n);
            }

            @Override
            public boolean isCode(int n) {
                return MemoryEditor.this.model.isCode(n);
            }

            @Override
            public boolean isTileData(int n) {
                return MemoryEditor.this.model.isTileData(n);
            }

            @Override
            public boolean isPaletteData(int n) {
                return MemoryEditor.this.model.isPaletteData(n);
            }

            @Override
            public boolean isTilemapData(int n) {
                return MemoryEditor.this.model.isTilemapData(n);
            }

            @Override
            public boolean isSpriteData(int n) {
                return MemoryEditor.this.model.isSpriteData(n);
            }

            @Override
            public boolean isSoundData(int n) {
                return MemoryEditor.this.model.isSoundData(n);
            }
        };
        BackgroundColorProvider backgroundColorProvider = new BackgroundColorProvider(){

            @Override
            public Color getBackground(int n) {
                return MemoryEditor.this.model.getBackgroundROM(n);
            }
        };
        IntMap intMap = this.romAnnotations;
        PopupMenuProvider popupMenuProvider = new PopupMenuProvider(){

            @Override
            public void showPopupMenu(int n, int n2, Component component, Point point) {
                MemoryEditor.this.model.showPopupMenuROM(n, n2, component, point);
            }
        };
        return this.addHexEditorPanel(arrayMemoryModel, abstractDataTypeProvider, backgroundColorProvider, intMap, popupMenuProvider);
    }

    private HexEditorPanel addRamHexEditorPanel() {
        ArrayMemoryModel arrayMemoryModel = new ArrayMemoryModel("RAM", this.model.getRAM(), 1){

            @Override
            public int length() {
                return MemoryEditor.this.model.getRAMlength();
            }

            @Override
            public boolean hasLabel(int n) {
                return MemoryEditor.this.model.hasRAMlabel(n);
            }

            @Override
            public List<String> getLabels(int n) {
                return MemoryEditor.this.model.getRAMlabels(n);
            }

            @Override
            public String getSource(int n) {
                return MemoryEditor.this.model.sourceToString(MemoryEditor.this.model.getRAMsource(n));
            }

            @Override
            public boolean isInitialized(int n) {
                return MemoryEditor.this.model.isRamInitialized(n);
            }

            @Override
            public String addressToString(int n) {
                return MemoryEditor.this.model.ramAddressToString(n);
            }
        };
        AbstractDataTypeProvider abstractDataTypeProvider = new AbstractDataTypeProvider(){

            @Override
            public boolean isCode(int n) {
                return MemoryEditor.this.model.isRAMcode(n);
            }

            @Override
            public boolean isTileData(int n) {
                return MemoryEditor.this.model.isTileDataInRAM(n);
            }

            @Override
            public boolean isPaletteData(int n) {
                return MemoryEditor.this.model.isPaletteDataInRAM(n);
            }

            @Override
            public boolean isTilemapData(int n) {
                return MemoryEditor.this.model.isTilemapDataInRAM(n);
            }

            @Override
            public boolean isSpriteData(int n) {
                return MemoryEditor.this.model.isSpriteDataInRAM(n);
            }

            @Override
            public boolean isSoundData(int n) {
                return MemoryEditor.this.model.isSoundDataInRAM(n);
            }
        };
        BackgroundColorProvider backgroundColorProvider = new BackgroundColorProvider(){

            @Override
            public Color getBackground(int n) {
                return MemoryEditor.this.model.getBackgroundRAM(n);
            }
        };
        IntMap intMap = this.ramAnnotations;
        PopupMenuProvider popupMenuProvider = new PopupMenuProvider(){

            @Override
            public void showPopupMenu(int n, int n2, Component component, Point point) {
                MemoryEditor.this.model.showPopupMenuRAM(n, n2, component, point);
            }
        };
        return this.addHexEditorPanel(arrayMemoryModel, abstractDataTypeProvider, backgroundColorProvider, intMap, popupMenuProvider);
    }

    private HexEditorPanel addVramHexEditorPanel() {
        ArrayMemoryModel arrayMemoryModel = new ArrayMemoryModel("VRAM", this.model.getVRAM(), 2){

            @Override
            public boolean hasLabel(int n) {
                return MemoryEditor.this.model.hasVRAMlabel(n);
            }

            @Override
            public List<String> getLabels(int n) {
                return MemoryEditor.this.model.getVRAMlabels(n);
            }

            @Override
            public String getSource(int n) {
                return MemoryEditor.this.model.traceToString(MemoryEditor.this.model.getVRAMsource(n));
            }

            @Override
            public boolean isInitialized(int n) {
                return MemoryEditor.this.model.isVramInitialized(n);
            }

            @Override
            public String addressToString(int n) {
                return MemoryEditor.this.model.vramAddressToString(n);
            }
        };
        BackgroundColorProvider backgroundColorProvider = new BackgroundColorProvider(){

            @Override
            public Color getBackground(int n) {
                return MemoryEditor.this.model.getBackgroundVRAM(n);
            }
        };
        IntMap intMap = this.vramAnnotations;
        PopupMenuProvider popupMenuProvider = new PopupMenuProvider(){

            @Override
            public void showPopupMenu(int n, int n2, Component component, Point point) {
                MemoryEditor.this.model.showPopupMenuVRAM(n, n2, component, point);
            }
        };
        return this.addHexEditorPanel(arrayMemoryModel, null, backgroundColorProvider, intMap, popupMenuProvider);
    }

    private HexEditorPanel addSramHexEditorPanel() {
        ArrayMemoryModel arrayMemoryModel = new ArrayMemoryModel("SRAM", this.model.getSRAM(), 3){

            @Override
            public boolean hasLabel(int n) {
                return MemoryEditor.this.model.hasSRAMlabel(n);
            }

            @Override
            public List<String> getLabels(int n) {
                if (MemoryEditor.this.model.hasSRAMlabel(n)) {
                    return MemoryEditor.this.model.getSRAMlabels(n);
                }
                return null;
            }

            @Override
            public String getSource(int n) {
                return MemoryEditor.this.model.sourceToString(MemoryEditor.this.model.getSRAMsource(n));
            }

            @Override
            public boolean isInitialized(int n) {
                return MemoryEditor.this.model.isSramInitialized(n);
            }

            @Override
            public String addressToString(int n) {
                return MemoryEditor.this.model.sramAddressToString(n);
            }
        };
        AbstractDataTypeProvider abstractDataTypeProvider = new AbstractDataTypeProvider(){

            @Override
            public boolean isCode(int n) {
                return false;
            }

            @Override
            public boolean isTileData(int n) {
                return MemoryEditor.this.model.isTileDataInSRAM(n);
            }

            @Override
            public boolean isPaletteData(int n) {
                return MemoryEditor.this.model.isPaletteDataInSRAM(n);
            }

            @Override
            public boolean isTilemapData(int n) {
                return MemoryEditor.this.model.isTilemapDataInSRAM(n);
            }

            @Override
            public boolean isSpriteData(int n) {
                return MemoryEditor.this.model.isSpriteDataInSRAM(n);
            }

            @Override
            public boolean isSoundData(int n) {
                return MemoryEditor.this.model.isSoundDataInSRAM(n);
            }
        };
        BackgroundColorProvider backgroundColorProvider = new BackgroundColorProvider(){

            @Override
            public Color getBackground(int n) {
                return MemoryEditor.this.model.getBackgroundSRAM(n);
            }
        };
        IntMap intMap = this.sramAnnotations;
        PopupMenuProvider popupMenuProvider = new PopupMenuProvider(){

            @Override
            public void showPopupMenu(int n, int n2, Component component, Point point) {
                MemoryEditor.this.model.showPopupMenuSRAM(n, n2, component, point);
            }
        };
        return this.addHexEditorPanel(arrayMemoryModel, abstractDataTypeProvider, backgroundColorProvider, intMap, popupMenuProvider);
    }

    private HexEditorPanel addCpuHexEditorPanel() {
        MemoryEditorModel.MemoryModel memoryModel = new MemoryEditorModel.MemoryModel(){

            @Override
            public String getName() {
                return "CPU";
            }

            @Override
            public int length() {
                return MemoryEditor.this.model.getMemoryLength();
            }

            @Override
            public int readByte(int n) {
                return MemoryEditor.this.model.getByte(n);
            }

            @Override
            public void writeByte(int n, int n2) {
                MemoryEditor.this.model.setByte(n, n2);
                MemoryEditor.fireOutputAvailable(5, n2);
            }

            @Override
            public boolean hasLabel(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    return MemoryEditor.this.model.getMemoryName(n) != null;
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.hasLabel(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.hasRAMlabel(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.hasSRAMlabel(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isVRAMaddress(n)) {
                    return MemoryEditor.this.model.hasVRAMlabel(MemoryEditor.this.model.mapAddress(n));
                }
                return MemoryEditor.this.model.getMemoryName(n) != null;
            }

            @Override
            public List<String> getLabels(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    String string = MemoryEditor.this.model.getMemoryName(n);
                    return string != null ? Arrays.asList(string) : null;
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.getLabels(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.getRAMlabels(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.getSRAMlabels(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isVRAMaddress(n)) {
                    return MemoryEditor.this.model.getVRAMlabels(MemoryEditor.this.model.mapAddress(n));
                }
                String string = MemoryEditor.this.model.getMemoryName(n);
                return string != null ? Arrays.asList(string) : null;
            }

            @Override
            public String getSource(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    return null;
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.traceToString(MemoryEditor.this.model.getRAMsource(MemoryEditor.this.model.mapAddress(n)));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.traceToString(MemoryEditor.this.model.getSRAMsource(MemoryEditor.this.model.mapAddress(n)));
                }
                if (MemoryEditor.this.model.isVRAMaddress(n)) {
                    return MemoryEditor.this.model.traceToString(MemoryEditor.this.model.getVRAMsource(MemoryEditor.this.model.mapAddress(n)));
                }
                return null;
            }

            @Override
            public boolean isInitialized(int n) {
                return MemoryEditor.this.model.isCpuMemoryInitialized(n);
            }

            @Override
            public String addressToString(int n) {
                return MemoryEditor.this.model.cpuAddressToString(n);
            }
        };
        AbstractDataTypeProvider abstractDataTypeProvider = new AbstractDataTypeProvider(){

            @Override
            public boolean isCode(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    return false;
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.isCode(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.isRAMcode(MemoryEditor.this.model.mapAddress(n));
                }
                return false;
            }

            @Override
            public boolean isTileData(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    return false;
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.isTileData(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.isTileDataInRAM(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.isTileDataInSRAM(MemoryEditor.this.model.mapAddress(n));
                }
                return false;
            }

            @Override
            public boolean isPaletteData(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    return false;
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.isPaletteData(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.isPaletteDataInRAM(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.isPaletteDataInSRAM(MemoryEditor.this.model.mapAddress(n));
                }
                return false;
            }

            @Override
            public boolean isTilemapData(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    return false;
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.isTilemapData(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.isTilemapDataInRAM(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.isTilemapDataInSRAM(MemoryEditor.this.model.mapAddress(n));
                }
                return false;
            }

            @Override
            public boolean isSpriteData(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    return false;
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.isSpriteData(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.isSpriteDataInRAM(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.isSpriteDataInSRAM(MemoryEditor.this.model.mapAddress(n));
                }
                return false;
            }

            @Override
            public boolean isSoundData(int n) {
                if (MemoryEditor.this.model.getAdditionalMemoryLocationAt(n) != null) {
                    return false;
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.isSoundData(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.isSoundDataInRAM(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.isSoundDataInSRAM(MemoryEditor.this.model.mapAddress(n));
                }
                return false;
            }
        };
        BackgroundColorProvider backgroundColorProvider = new BackgroundColorProvider(){

            @Override
            public Color getBackground(int n) {
                String string = MemoryEditor.this.model.getAdditionalMemoryLocationAt(n);
                if (string != null) {
                    return MemoryEditor.this.model.getBackgroundAdditionalMemoryModel(string, MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.model.getBackgroundROM(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.model.getBackgroundRAM(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.model.getBackgroundSRAM(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isVRAMaddress(n)) {
                    return MemoryEditor.this.model.getBackgroundVRAM(MemoryEditor.this.model.mapAddress(n));
                }
                return null;
            }
        };
        IntMap intMap = new IntMap(){

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int remove(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int put(int n, int n2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BitSet keyBitSet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int get(int n) {
                int n2 = MemoryEditor.this.indexOfAdditionalMemory(MemoryEditor.this.model.getAdditionalMemoryLocationAt(n));
                if (n2 >= 0 && n2 < MemoryEditor.this.additionalMemoryAnnotations.length) {
                    return MemoryEditor.this.additionalMemoryAnnotations[n2].get(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isROMaddress(n)) {
                    return MemoryEditor.this.romAnnotations.get(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isRAMaddress(n)) {
                    return MemoryEditor.this.ramAnnotations.get(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    return MemoryEditor.this.sramAnnotations.get(MemoryEditor.this.model.mapAddress(n));
                }
                if (MemoryEditor.this.model.isVRAMaddress(n)) {
                    return MemoryEditor.this.vramAnnotations.get(MemoryEditor.this.model.mapAddress(n));
                }
                return Integer.MIN_VALUE;
            }

            @Override
            public Set<IntMap.Entry> entrySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsValue(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsKey(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
        PopupMenuProvider popupMenuProvider = new PopupMenuProvider(){

            @Override
            public void showPopupMenu(int n, int n2, Component component, Point point) {
                String string = MemoryEditor.this.model.getAdditionalMemoryLocationAt(n);
                if (string != null) {
                    MemoryEditor.this.model.showPopupMenuAdditionalMemoryModel(string, MemoryEditor.this.model.mapAddress(n), MemoryEditor.this.model.mapAddress(n2), component, point);
                } else if (MemoryEditor.this.model.isROMaddress(n)) {
                    MemoryEditor.this.model.showPopupMenuROM(MemoryEditor.this.model.mapAddress(n), MemoryEditor.this.model.mapAddress(n2), component, point);
                } else if (MemoryEditor.this.model.isRAMaddress(n)) {
                    MemoryEditor.this.model.showPopupMenuRAM(MemoryEditor.this.model.mapAddress(n), MemoryEditor.this.model.mapAddress(n2), component, point);
                } else if (MemoryEditor.this.model.isSRAMaddress(n)) {
                    MemoryEditor.this.model.showPopupMenuSRAM(MemoryEditor.this.model.mapAddress(n), MemoryEditor.this.model.mapAddress(n2), component, point);
                } else if (MemoryEditor.this.model.isVRAMaddress(n)) {
                    MemoryEditor.this.model.showPopupMenuVRAM(MemoryEditor.this.model.mapAddress(n), MemoryEditor.this.model.mapAddress(n2), component, point);
                }
            }
        };
        return this.addHexEditorPanel(memoryModel, abstractDataTypeProvider, backgroundColorProvider, intMap, popupMenuProvider);
    }

    private HexEditorPanel addPalHexEditorPanel() {
        MemoryEditorModel.MemoryModel memoryModel = new MemoryEditorModel.MemoryModel(){

            @Override
            public String getName() {
                return "Palettes";
            }

            @Override
            public int length() {
                return MemoryEditor.this.model.getNumberOfPaletteBytes();
            }

            @Override
            public int readByte(int n) {
                return MemoryEditor.this.model.getPaletteByte(n);
            }

            @Override
            public void writeByte(int n, int n2) {
                MemoryEditor.this.model.setPaletteByte(n, n2);
                MemoryEditor.fireOutputAvailable(4, n);
            }

            @Override
            public boolean hasLabel(int n) {
                return this.getLabels(n) != null;
            }

            @Override
            public List<String> getLabels(int n) {
                String string = MemoryEditor.this.model.getPaletteName(n);
                return string != null ? Arrays.asList(string) : null;
            }

            @Override
            public String getSource(int n) {
                return MemoryEditor.this.model.traceToString(MemoryEditor.this.model.getColorSource(n));
            }

            @Override
            public boolean isInitialized(int n) {
                return MemoryEditor.this.model.isPaletteInitialized(n);
            }

            @Override
            public String addressToString(int n) {
                return MemoryEditor.this.model.palAddressToString(n);
            }
        };
        PopupMenuProvider popupMenuProvider = new PopupMenuProvider(){

            @Override
            public void showPopupMenu(int n, int n2, Component component, Point point) {
                MemoryEditor.this.model.showPopupMenuAdditionalMemoryModel("Palettes", n, n2, component, point);
            }
        };
        BackgroundColorProvider backgroundColorProvider = new BackgroundColorProvider(){

            @Override
            public Color getBackground(int n) {
                return MemoryEditor.this.model.getBackgroundAdditionalMemoryModel("Palettes", n);
            }
        };
        return this.addHexEditorPanel(memoryModel, null, backgroundColorProvider, null, popupMenuProvider);
    }

    private HexEditorPanel addAdditionalHexEditorPanel(int n) {
        final MemoryEditorModel.MemoryModel memoryModel = this.additionalMemoryModels[n];
        PopupMenuProvider popupMenuProvider = new PopupMenuProvider(){

            @Override
            public void showPopupMenu(int n, int n2, Component component, Point point) {
                MemoryEditor.this.model.showPopupMenuAdditionalMemoryModel(memoryModel.getName(), n, n2, component, point);
            }
        };
        BackgroundColorProvider backgroundColorProvider = new BackgroundColorProvider(){

            @Override
            public Color getBackground(int n) {
                return MemoryEditor.this.model.getBackgroundAdditionalMemoryModel(memoryModel.getName(), n);
            }
        };
        return this.addHexEditorPanel(this.additionalMemoryModels[n], null, backgroundColorProvider, this.additionalMemoryAnnotations[n], popupMenuProvider);
    }

    private HexEditorPanel addHexEditorPanel(MemoryEditorModel.MemoryModel memoryModel, DataTypeProvider dataTypeProvider, BackgroundColorProvider backgroundColorProvider, IntMap intMap, PopupMenuProvider popupMenuProvider) {
        final HexEditorPanel hexEditorPanel = new HexEditorPanel(memoryModel, dataTypeProvider, backgroundColorProvider, intMap, popupMenuProvider);
        JScrollPane jScrollPane = new JScrollPane(hexEditorPanel){

            @Override
            protected JViewport createViewport() {
                return new JViewport(){

                    @Override
                    public Color getBackground() {
                        return hexEditorPanel.getBackground();
                    }
                };
            }

            @Override
            protected void paintBorder(Graphics graphics) {
                Container container = MemoryEditor.this.getParent();
                if (container instanceof JTabbedPane) {
                    Border border = ((JTabbedPane)container).getBorder();
                    if (this.getBorder() != border) {
                        this.setBorder(border);
                    }
                }
                super.paintBorder(graphics);
            }
        };
        if (this.table != null) {
            hexEditorPanel.updateCharWidth(this.table.values());
        }
        hexEditorPanel.setHideAnnotations(!this.showRegisters);
        this.tabbedPane.addTab(memoryModel.getName(), jScrollPane);
        return hexEditorPanel;
    }

    public void dispose() {
        this.updateModel(null);
    }

    public void updateModel() {
        this.updateModel(Emulicious.getROMfile());
    }

    private void updateModel(File file) {
        this.additionalMemoryModels = this.model.getAdditionalMemoryModels();
        this.romFile = null;
        this.ramFile = null;
        this.vramFile = null;
        this.sramFile = null;
        this.palFile = null;
        this.tableFile = null;
        this.changeWatcher.reset();
        this.romAnnotations.clear();
        this.ramAnnotations.clear();
        this.vramAnnotations.clear();
        this.sramAnnotations.clear();
        this.additionalMemoryAnnotations = new IntMap[0];
        if (file != null) {
            File file2 = new File(String.valueOf(file.getPath()) + ".tbl");
            if (!file2.exists()) {
                file2 = new File(String.valueOf(file.getPath().substring(0, file.getPath().lastIndexOf(46))) + ".tbl");
            }
            this.table = this.loadTable(file2);
            this.tabbedPane.removeAll();
            this.cpuPanel = this.addCpuHexEditorPanel();
            this.romPanel = this.addRomHexEditorPanel();
            this.romPanel.setDisplayOffsets(Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorDisplayFileOffsetsForROM")));
            this.ramPanel = this.addRamHexEditorPanel();
            this.vramPanel = this.addVramHexEditorPanel();
            this.palPanel = this.addPalHexEditorPanel();
            if (this.model.hasSRAM()) {
                this.sramPanel = this.addSramHexEditorPanel();
                this.sramPanel.setDisplayOffsets(Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorDisplayFileOffsetsForSRAM")));
            }
            this.additionalMemoryAnnotations = new IntMap[this.additionalMemoryModels.length];
            int n = 0;
            while (n < this.additionalMemoryAnnotations.length) {
                this.additionalMemoryAnnotations[n] = new HashIntMap();
                ++n;
            }
            this.additionalPanels = new HexEditorPanel[this.additionalMemoryModels.length];
            n = 0;
            while (n < this.additionalPanels.length) {
                this.additionalPanels[n] = this.addAdditionalHexEditorPanel(n);
                ++n;
            }
            this.followRegisterContainer.removeAll();
            this.followRegisterContainer.add(new JLabel("Follow Register: "){

                @Override
                public Font getFont() {
                    return MemoryEditor.this.followRegisterContainer.getFont();
                }

                @Override
                public Color getForeground() {
                    return MemoryEditor.this.followRegisterContainer.getForeground();
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            final Insets insets = new Insets(0, 0, 0, 0);
            this.buttonFollowRegisterNone = new JRadioButton("None", true){

                @Override
                public Font getFont() {
                    return MemoryEditor.this.followRegisterContainer.getFont();
                }

                @Override
                public Color getForeground() {
                    return MemoryEditor.this.followRegisterContainer.getForeground();
                }

                @Override
                public Insets getMargin() {
                    return insets;
                }
            };
            this.buttonFollowRegisterNone.setOpaque(false);
            this.buttonFollowRegisterNone.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        MemoryEditor.this.setFollowRegister(-1);
                        MemoryEditor.this.selectFollowRegister();
                        MemoryEditor.this.buttonFollowRegisterNone.requestFocusInWindow();
                    }
                }
            });
            buttonGroup.add(this.buttonFollowRegisterNone);
            this.followRegisterContainer.add(this.buttonFollowRegisterNone);
            int n2 = 0;
            while (n2 < this.model.getRegisterNames().length) {
                if (this.model.canFollowRegister(n2)) {
                    final int n3 = n2;
                    final JRadioButton jRadioButton = new JRadioButton(this.model.getRegisterNames()[n3]){

                        @Override
                        public Font getFont() {
                            return MemoryEditor.this.followRegisterContainer.getFont();
                        }

                        @Override
                        public Color getForeground() {
                            return MemoryEditor.this.followRegisterContainer.getForeground();
                        }

                        @Override
                        public Insets getMargin() {
                            return insets;
                        }
                    };
                    jRadioButton.setOpaque(false);
                    jRadioButton.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent itemEvent) {
                            if (itemEvent.getStateChange() == 1) {
                                MemoryEditor.this.setFollowRegister(n3);
                                MemoryEditor.this.selectFollowRegister();
                                jRadioButton.requestFocusInWindow();
                            }
                        }
                    });
                    buttonGroup.add(jRadioButton);
                    this.followRegisterContainer.add(jRadioButton);
                }
                ++n2;
            }
            if (this.model.getVRAMaddress() >= 0) {
                final JRadioButton jRadioButton = new JRadioButton("VA"){

                    @Override
                    public Font getFont() {
                        return MemoryEditor.this.followRegisterContainer.getFont();
                    }

                    @Override
                    public Color getForeground() {
                        return MemoryEditor.this.followRegisterContainer.getForeground();
                    }

                    @Override
                    public Insets getMargin() {
                        return insets;
                    }
                };
                jRadioButton.setOpaque(false);
                jRadioButton.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            MemoryEditor.this.setFollowRegister(-2);
                            MemoryEditor.this.selectFollowRegister();
                            jRadioButton.requestFocusInWindow();
                        }
                    }
                });
                buttonGroup.add(jRadioButton);
                this.followRegisterContainer.add(jRadioButton);
            }
            this.repaint();
        } else {
            this.table = null;
            this.cpuPanel = null;
            this.romPanel = null;
            this.ramPanel = null;
            this.vramPanel = null;
            this.palPanel = null;
            this.sramPanel = null;
            this.additionalPanels = null;
        }
    }

    private Map<String> loadTable(File file) {
        return this.loadTable(file, Boolean.parseBoolean(Emulicious.getProperties().getProperty("ReloadTableFileOnChange")));
    }

    private Map<String> loadTable(File file, boolean bl) {
        try {
            if (!bl || this.tableFileChangeWatcher != null && file != this.tableFileChangeWatcher.getFile()) {
                this.removeTableFileChangeWatcher();
            }
            HashMap<String> hashMap = new HashMap<String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            this.tablePrefixBytes = new IntHashSet();
            String string = bufferedReader.readLine();
            while (string != null) {
                try {
                    int n = string.indexOf(61);
                    if (n > 0) {
                        int n2 = Integer.parseInt(string.substring(0, n), 16);
                        hashMap.put(n2, string.substring(n + 1));
                        if (n2 >= 256) {
                            int n3 = n2 >> 8;
                            do {
                                this.tablePrefixBytes.add(n3);
                            } while ((n3 >>= 8) > 0);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            System.out.println("Tablefile loaded: " + file.getName());
            this.tableFile = file;
            if (bl) {
                this.createTableFileChangeWatcher();
            }
            return hashMap;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.tablePrefixBytes = null;
        return null;
    }

    private void reloadTable() {
        this.table = this.loadTable(this.tableFile);
        this.updateCharWidth(this.table != null ? this.table.values() : null);
    }

    private void unloadTable() {
        this.removeTableFileChangeWatcher();
        this.table = null;
        this.tablePrefixBytes = null;
        this.updateCharWidth(null);
    }

    String getTableSymbolAt(MemoryEditorModel.MemoryModel memoryModel, int n) {
        int n2 = memoryModel.readByte(n);
        int n3 = n < 3 ? -n : -3;
        while (n3 < 0) {
            int n4 = this.getLongestPotentialMatchAt(memoryModel, n + n3);
            int n5 = MemoryEditor.getPrefixLength(n4);
            if (this.table.containsKey(n4)) {
                if (n5 >= -n3) {
                    return " ";
                }
                n3 += n5;
            }
            ++n3;
        }
        n3 = this.getLongestPotentialMatchAt(memoryModel, n);
        while (n3 != 0) {
            String string = this.table.get(n3);
            if (string != null) {
                return string;
            }
            n3 >>>= 8;
        }
        return this.table.get(n2);
    }

    private static int getPrefixLength(int n) {
        int n2 = 0;
        while ((n >>>= 8) != 0) {
            ++n2;
        }
        return n2;
    }

    private int getLongestPotentialMatchAt(MemoryEditorModel.MemoryModel memoryModel, int n) {
        if (n >= memoryModel.length()) {
            return 0;
        }
        int n2 = memoryModel.readByte(n);
        int n3 = 1;
        while (n3 <= 4 && n + n3 < memoryModel.length() && this.tablePrefixBytes.contains(n2)) {
            n2 = n2 << 8 | memoryModel.readByte(n + n3);
            ++n3;
        }
        return n2;
    }

    void createTableFileChangeWatcher() {
        if (this.tableFileChangeWatcher == null) {
            this.tableFileChangeWatcher = new FileChangeWatcher(this.tableFile);
            this.tableFileChangeWatcher.startWatching(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MemoryEditor.this.tableFileChangeWatcher.getFile().exists()) {
                        MemoryEditor.this.reloadTable();
                    }
                }
            });
        }
    }

    void removeTableFileChangeWatcher() {
        if (this.tableFileChangeWatcher != null) {
            this.tableFileChangeWatcher.stopWatching();
            this.tableFileChangeWatcher = null;
        }
    }

    void updateCharWidth(Collection<String> collection) {
        this.romPanel.updateCharWidth(collection);
        this.ramPanel.updateCharWidth(collection);
        this.vramPanel.updateCharWidth(collection);
        this.cpuPanel.updateCharWidth(collection);
        this.palPanel.updateCharWidth(collection);
        if (this.sramPanel != null) {
            this.sramPanel.updateCharWidth(collection);
        }
        HexEditorPanel[] hexEditorPanelArray = this.additionalPanels;
        int n = this.additionalPanels.length;
        int n2 = 0;
        while (n2 < n) {
            HexEditorPanel hexEditorPanel = hexEditorPanelArray[n2];
            hexEditorPanel.updateCharWidth(collection);
            ++n2;
        }
    }

    void setHideAnnotations(boolean bl) {
        this.romPanel.setHideAnnotations(bl);
        this.ramPanel.setHideAnnotations(bl);
        this.vramPanel.setHideAnnotations(bl);
        this.cpuPanel.setHideAnnotations(bl);
        this.palPanel.setHideAnnotations(bl);
        if (this.sramPanel != null) {
            this.sramPanel.setHideAnnotations(bl);
        }
        HexEditorPanel[] hexEditorPanelArray = this.additionalPanels;
        int n = this.additionalPanels.length;
        int n2 = 0;
        while (n2 < n) {
            HexEditorPanel hexEditorPanel = hexEditorPanelArray[n2];
            hexEditorPanel.setHideAnnotations(bl);
            ++n2;
        }
    }

    void updateAnnotations() {
        String[] stringArray = this.model.getRegisterNames();
        this.romAnnotations.clear();
        this.ramAnnotations.clear();
        this.vramAnnotations.clear();
        this.sramAnnotations.clear();
        IntMap[] intMapArray = this.additionalMemoryAnnotations;
        int n = this.additionalMemoryAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            IntMap intMap = intMapArray[n2];
            intMap.clear();
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (!this.model.isAdditionalRegister(n3)) {
                n2 = this.model.getRegisterValue(n3);
                n = this.indexOfAdditionalMemory(this.model.getAdditionalMemoryLocationAt(n2));
                if (n >= 0 && n < this.additionalMemoryAnnotations.length) {
                    this.additionalMemoryAnnotations[n].put(this.model.mapAddress(n2), n3);
                } else if (this.model.isROMaddress(n2)) {
                    this.romAnnotations.put(this.model.mapAddress(n2), n3);
                } else if (this.model.isRAMaddress(n2)) {
                    this.ramAnnotations.put(this.model.mapAddress(n2), n3);
                } else if (this.model.isVRAMaddress(n2)) {
                    this.vramAnnotations.put(this.model.mapAddress(n2), n3);
                } else if (this.model.isSRAMaddress(n2)) {
                    this.sramAnnotations.put(this.model.mapAddress(n2), n3);
                }
            }
            ++n3;
        }
        n3 = this.model.getVRAMaddress();
        if (n3 >= 0) {
            this.vramAnnotations.put(this.model.mapAddress(n3), -1);
        }
    }

    int indexOfAdditionalMemory(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.additionalMemoryModels.length) {
                if (string.equals(this.additionalMemoryModels[n].getName())) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public void setFollowRegisterContainerVisible(boolean bl) {
        this.followRegisterContainer.setVisible(bl);
    }

    void setFollowRegister(int n) {
        this.followRegister = n;
        if (this.followRegisterButton != null) {
            this.followRegisterButton.setText(n < 0 ? (n == -2 ? "VA" : "   ") : this.model.getRegisterNames()[n]);
        }
    }

    void selectFollowRegister() {
        this.selectingFollowRegister = true;
        if (this.followRegister >= 0) {
            int n = this.model.getRegisterValue(this.followRegister);
            if (this.getCurrentPanel() == this.cpuPanel) {
                this.cpuPanel.setSelectedAddress(n, false);
            } else {
                int n2 = this.indexOfAdditionalMemory(this.model.getAdditionalMemoryLocationAt(n));
                if (n2 >= 0 && n2 < this.additionalPanels.length) {
                    this.additionalPanels[n2].setSelectedAddress(this.model.mapAddress(n));
                } else if (this.model.isROMaddress(n)) {
                    this.romPanel.setSelectedAddress(this.model.mapAddress(n), false);
                } else if (this.model.isRAMaddress(n)) {
                    this.ramPanel.setSelectedAddress(this.model.mapAddress(n), false);
                } else if (this.model.isVRAMaddress(n)) {
                    this.vramPanel.setSelectedAddress(this.model.mapAddress(n), false);
                } else if (this.model.isSRAMaddress(n)) {
                    this.sramPanel.setSelectedAddress(this.model.mapAddress(n), false);
                } else {
                    this.cpuPanel.setSelectedAddress(n, false);
                }
            }
        } else if (this.followRegister == -2) {
            this.vramPanel.setSelectedAddress(this.model.getVRAMaddress(), false);
        }
        this.selectingFollowRegister = false;
    }

    public void update() {
        if (!this.isShowing()) {
            return;
        }
        try {
            if (this.sramPanel == null && this.model.hasSRAM()) {
                this.sramPanel = this.addSramHexEditorPanel();
                this.sramPanel.setForeground(this.romPanel.getForeground());
                this.sramPanel.setBackground(this.romPanel.getBackground());
                this.sramPanel.setDisplayOffsets(Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorDisplayFileOffsetsForSRAM")));
            } else if (this.sramPanel != null && !this.model.hasSRAM()) {
                this.tabbedPane.remove(this.sramPanel);
            }
            this.updateAnnotations();
            this.selectFollowRegister();
            this.updateStatusBar();
            this.getCurrentPanel().hexEditor.repaint();
            if (this.getCurrentPanel() == this.cpuPanel) {
                this.cpuPanel.addressColumn.repaint();
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void romChanged() {
        this.changeWatcher.reset();
        this.changeWatcher.clearChangesFlag();
        this.changeWatcher.setRomHasChanges(true);
    }

    void updateStatusBar() {
        if (!this.statusBarLabel.isShowing()) {
            return;
        }
        HexEditorPanel hexEditorPanel = this.getCurrentPanel();
        int n = hexEditorPanel.getFirstSelectedAddress();
        if (n < 0) {
            this.statusBarLabel.setText(" ");
        } else {
            String string;
            int n2 = hexEditorPanel.getLastSelectedAddress();
            if (n == n2) {
                Color color;
                String string2;
                List<String> list;
                int n3 = hexEditorPanel.getValueAt(n);
                boolean bl = hexEditorPanel.isInitialized(n);
                LabelProvider labelProvider = hexEditorPanel.getLabelProvider();
                List<String> list2 = list = labelProvider != null ? labelProvider.getLabels(n) : null;
                String string3 = !(list == null || list.isEmpty() || list.size() <= 1 && list.get(0).isEmpty()) ? (list.size() > 1 ? String.valueOf(list.get(0)) + ", " + list.get(1) + (list.size() > 2 ? ", ..." : "") : list.get(0)) : null;
                int n4 = string3 != null ? Math.min(string3.length(), string3.indexOf(10) & Integer.MAX_VALUE) : -1;
                String string4 = string3 != null ? " (" + string3.substring(0, n4) + ")" : "";
                DataTypeProvider dataTypeProvider = hexEditorPanel.getDataTypeProvider();
                if (dataTypeProvider != null) {
                    if (!dataTypeProvider.hasDataType(n)) {
                        string2 = "Unknown";
                        color = null;
                    } else if (dataTypeProvider.isTileData(n)) {
                        string2 = "Tile";
                        color = TILE_COLOR;
                    } else if (dataTypeProvider.isPaletteData(n)) {
                        string2 = "Palette";
                        color = PALETTE_COLOR;
                    } else if (dataTypeProvider.isTilemapData(n)) {
                        string2 = "Tilemap";
                        color = TILEMAP_COLOR;
                    } else if (dataTypeProvider.isSpriteData(n)) {
                        string2 = "Sprite";
                        color = SPRITE_COLOR;
                    } else if (dataTypeProvider.isSoundData(n)) {
                        string2 = "Sound";
                        color = SOUND_COLOR;
                    } else if (dataTypeProvider.isCode(n)) {
                        string2 = "Code";
                        color = CODE_COLOR;
                    } else {
                        string2 = "Unknown";
                        color = null;
                    }
                } else {
                    string2 = null;
                    color = null;
                }
                String string5 = color != null ? "<font color='#" + Integer.toHexString(0x1000000 | color.getRGB() & 0xFFFFFF).substring(1) + "'>" + string2 + "</font>" : string2;
                String string6 = string2 != null ? "   <b>Data&nbsp;type</b>:&nbsp;" + string5 : "";
                SourceProvider sourceProvider = hexEditorPanel.getSourceProvider();
                String string7 = sourceProvider != null ? sourceProvider.getSource(n) : null;
                String string8 = string7 != null ? "   <b>Source</b>:&nbsp;" + string7 : "";
                string = String.valueOf(String.format(hexEditorPanel.FORMAT_ADDRESS_AND_VALUE_WITH_LABELS, hexEditorPanel.addressToString(n), string4, n3, Integer.toBinaryString(0x100 | n3).substring(1), n3 >= 100 ? Integer.toString(n3) : (n3 >= 10 ? "&nbsp;" + Integer.toString(n3) : "&nbsp;&nbsp;" + Integer.toString(n3)), bl ? "" : "&nbsp;(uninitialized)")) + string6 + string8;
                string = "<html>" + string.replace("  ", " &nbsp;") + "</html>";
            } else {
                string = String.format("<html>" + hexEditorPanel.FORMAT_ADDRESS_WITH_LABEL + "&nbsp;-&nbsp;" + hexEditorPanel.FORMAT_ADDRESS + "&nbsp;(%d&nbsp;bytes)</html>", hexEditorPanel.addressToString(n), hexEditorPanel.addressToString(n2), n2 - n + 1);
            }
            this.statusBarLabel.setText(string);
        }
    }

    String selectionToString() {
        HexEditorPanel hexEditorPanel = this.getCurrentPanel();
        int n = hexEditorPanel.getFirstSelectedAddress();
        if (n < 0) {
            return "";
        }
        int n2 = hexEditorPanel.getLastSelectedAddress();
        if (n == n2) {
            return hexEditorPanel.addressToString(n);
        }
        return String.valueOf(hexEditorPanel.addressToString(n)) + " - " + hexEditorPanel.addressToString(n2) + " (" + (n2 - n + 1) + " bytes)";
    }

    public JMenu makeMenuFile(final Window window) {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('f');
        final MenuItem menuItem = new MenuItem("Save", 115);
        jMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HexEditorPanel hexEditorPanel = MemoryEditor.this.getCurrentPanel();
                    if (hexEditorPanel == MemoryEditor.this.romPanel) {
                        if (MemoryEditor.this.romFile == null) {
                            MemoryEditor.this.showSaveROMFileChooser(window);
                        } else if (MemoryEditor.this.romFile.getName().toLowerCase().endsWith(".ips")) {
                            MemoryEditor.this.saveIPS(MemoryEditor.this.romFile);
                        } else {
                            MemoryEditor.this.saveROM(MemoryEditor.this.romFile);
                        }
                    } else if (hexEditorPanel == MemoryEditor.this.ramPanel) {
                        if (MemoryEditor.this.ramFile == null) {
                            MemoryEditor.this.showSaveRAMFileChooser(window);
                        } else {
                            MemoryEditor.this.saveRAM(MemoryEditor.this.ramFile);
                        }
                    } else if (hexEditorPanel == MemoryEditor.this.vramPanel) {
                        if (MemoryEditor.this.vramFile == null) {
                            MemoryEditor.this.showSaveVRAMFileChooser(window);
                        } else {
                            MemoryEditor.this.saveVRAM(MemoryEditor.this.vramFile);
                        }
                    } else if (hexEditorPanel == MemoryEditor.this.sramPanel) {
                        if (MemoryEditor.this.sramFile == null) {
                            MemoryEditor.this.showSaveSRAMFileChooser(window);
                        } else {
                            MemoryEditor.this.saveSRAM(MemoryEditor.this.sramFile);
                        }
                    } else if (hexEditorPanel == MemoryEditor.this.palPanel) {
                        if (MemoryEditor.this.palFile == null) {
                            MemoryEditor.this.showSavePalettesFileChooser(window);
                        } else {
                            MemoryEditor.this.savePalettes(MemoryEditor.this.palFile);
                        }
                    }
                }
                catch (IOException iOException) {
                    window.showMessageDialog("An error occured while saving: " + iOException.getMessage(), "Error saving file", 0);
                }
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem("Save As...", 97);
        jMenu.add(menuItem2);
        menuItem2.setAction(new AbstractAction(menuItem2.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block9: {
                    try {
                        HexEditorPanel hexEditorPanel = MemoryEditor.this.getCurrentPanel();
                        if (hexEditorPanel == MemoryEditor.this.romPanel) {
                            MemoryEditor.this.showSaveROMFileChooser(window);
                            break block9;
                        }
                        if (hexEditorPanel == MemoryEditor.this.ramPanel) {
                            MemoryEditor.this.showSaveRAMFileChooser(window);
                            break block9;
                        }
                        if (hexEditorPanel == MemoryEditor.this.vramPanel) {
                            MemoryEditor.this.showSaveVRAMFileChooser(window);
                            break block9;
                        }
                        if (hexEditorPanel == MemoryEditor.this.sramPanel) {
                            MemoryEditor.this.showSaveSRAMFileChooser(window);
                            break block9;
                        }
                        if (hexEditorPanel == MemoryEditor.this.palPanel) {
                            MemoryEditor.this.showSavePalettesFileChooser(window);
                            break block9;
                        }
                        int n = 0;
                        while (n < MemoryEditor.this.additionalPanels.length) {
                            if (hexEditorPanel == MemoryEditor.this.additionalPanels[n]) {
                                MemoryEditor.this.showSaveAdditionalMemoryFileChooser(window, n);
                                break;
                            }
                            ++n;
                        }
                    }
                    catch (IOException iOException) {
                        window.showMessageDialog("An error occured while saving: " + iOException.getMessage(), "Error saving file", 0);
                    }
                }
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        MenuItem menuItem3 = new MenuItem("Save Selection As...", 99);
        jMenu.add(menuItem3);
        menuItem3.setAction(new AbstractAction(menuItem3.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MemoryEditor.this.showSaveSelectionFileChooser(window);
                }
                catch (IOException iOException) {
                    window.showMessageDialog("An error occured while saving: " + iOException.getMessage(), "Error saving file", 0);
                }
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        jMenu.addSeparator();
        MenuItem menuItem4 = new MenuItem("Load Table File...", 116);
        jMenu.add(menuItem4);
        menuItem4.setAction(new AbstractAction(menuItem4.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.showTableFileChooser(window);
            }
        });
        menuItem4 = new MenuItem("Reload Table File");
        jMenu.add(menuItem4);
        menuItem4.setAction(new AbstractAction(menuItem4.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.reloadTable();
            }
        });
        final CheckBoxMenuItem checkBoxMenuItem = new CheckBoxMenuItem("Reload Table File On Change", Boolean.parseBoolean(Emulicious.getProperties().getProperty("ReloadTableFileOnChange")));
        jMenu.add(checkBoxMenuItem);
        checkBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.getProperties().setProperty("ReloadTableFileOnChange", Boolean.toString(checkBoxMenuItem.isSelected()));
                if (checkBoxMenuItem.isSelected()) {
                    MemoryEditor.this.createTableFileChangeWatcher();
                } else {
                    MemoryEditor.this.removeTableFileChangeWatcher();
                }
            }
        });
        menuItem4 = new MenuItem("Unload Table File");
        jMenu.add(menuItem4);
        menuItem4.setAction(new AbstractAction(menuItem4.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.unloadTable();
            }
        });
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                boolean bl = MemoryEditor.this.canSave();
                menuItem.setEnabled(bl);
                menuItem2.setEnabled(bl);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    public JMenu makeMenuEdit(final Window window) {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem("Undo", 117);
        jMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.undo();
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem("Redo", 114);
        jMenu.add(menuItem2);
        menuItem2.setAction(new AbstractAction(menuItem2.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.redo();
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        final MenuItem menuItem3 = new MenuItem("Copy", 99);
        jMenu.add(menuItem3);
        menuItem3.setAction(new AbstractAction(menuItem3.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.getCurrentPanel().copyToClipboard();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem4 = new MenuItem("Copy Text", 116);
        jMenu.add(menuItem4);
        menuItem4.setAction(new AbstractAction(menuItem4.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.getCurrentPanel().copyTextToClipboard();
            }
        });
        menuItem4.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        final MenuItem menuItem5 = new MenuItem("Paste", 112);
        jMenu.add(menuItem5);
        menuItem5.setAction(new AbstractAction(menuItem5.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.getCurrentPanel().pasteFromClipboard();
            }
        });
        menuItem5.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        MenuItem menuItem6 = new MenuItem("Find...", 102);
        jMenu.add(menuItem6);
        menuItem6.setAction(new AbstractAction(menuItem6.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.openFindDialog(window);
            }
        });
        menuItem6.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(MemoryEditor.this.canUndo());
                menuItem2.setEnabled(MemoryEditor.this.canRedo());
                menuItem3.setEnabled(MemoryEditor.this.getCurrentPanel().canCopyToClipboard());
                menuItem4.setEnabled(MemoryEditor.this.getCurrentPanel().canCopyToClipboard());
                menuItem5.setEnabled(MemoryEditor.this.getCurrentPanel().canPasteFromClipboard());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
                menuItem3.setEnabled(true);
                menuItem4.setEnabled(true);
                menuItem5.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    public JMenu makeMenuView() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('v');
        Emulicious.addFontMenus(jMenu);
        jMenu.addSeparator();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Registers");
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setAction(new AbstractAction(jCheckBoxMenuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem.isSelected()) {
                    Emulicious.getProperties().setProperty("MemoryEditorShowRegisters", "false");
                } else {
                    Emulicious.getProperties().remove("MemoryEditorShowRegisters");
                }
                MemoryEditor.this.showRegisters = jCheckBoxMenuItem.isSelected();
                MemoryEditor.this.setHideAnnotations(!MemoryEditor.this.showRegisters);
                MemoryEditor.this.tabbedPane.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Show Labels");
        jMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.setAction(new AbstractAction(jCheckBoxMenuItem2.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem2.isSelected()) {
                    Emulicious.getProperties().setProperty("MemoryEditorShowLabels", "false");
                } else {
                    Emulicious.getProperties().remove("MemoryEditorShowLabels");
                }
                MemoryEditor.this.showLabels = jCheckBoxMenuItem2.isSelected();
                MemoryEditor.this.tabbedPane.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Show Debugger Highlighting");
        jMenu.add(jCheckBoxMenuItem3);
        jCheckBoxMenuItem3.setAction(new AbstractAction(jCheckBoxMenuItem3.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem3.isSelected()) {
                    Emulicious.getProperties().setProperty("MemoryEditorShowDebuggerHighlighting", "false");
                } else {
                    Emulicious.getProperties().remove("MemoryEditorShowDebuggerHighlighting");
                }
                MemoryEditor.this.showDebuggerHighlighting = jCheckBoxMenuItem3.isSelected();
                MemoryEditor.this.tabbedPane.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Display File Offsets For ROM");
        jMenu.add(jCheckBoxMenuItem4);
        jCheckBoxMenuItem4.setAction(new AbstractAction(jCheckBoxMenuItem4.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem4.isSelected()) {
                    Emulicious.getProperties().setProperty("MemoryEditorDisplayFileOffsetsForROM", "true");
                } else {
                    Emulicious.getProperties().remove("MemoryEditorDisplayFileOffsetsForROM");
                }
                MemoryEditor.this.romPanel.setDisplayOffsets(jCheckBoxMenuItem4.isSelected());
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem("Display File Offsets For SRAM");
        jMenu.add(jCheckBoxMenuItem5);
        jCheckBoxMenuItem5.setAction(new AbstractAction(jCheckBoxMenuItem5.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem5.isSelected()) {
                    Emulicious.getProperties().setProperty("MemoryEditorDisplayFileOffsetsForSRAM", "true");
                } else {
                    Emulicious.getProperties().remove("MemoryEditorDisplayFileOffsetsForSRAM");
                }
                if (MemoryEditor.this.sramPanel != null) {
                    MemoryEditor.this.sramPanel.setDisplayOffsets(jCheckBoxMenuItem5.isSelected());
                }
            }
        });
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jCheckBoxMenuItem.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorShowRegisters")));
                jCheckBoxMenuItem2.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorShowLabels")));
                jCheckBoxMenuItem3.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorShowDebuggerHighlighting")));
                jCheckBoxMenuItem4.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorDisplayFileOffsetsForROM")));
                jCheckBoxMenuItem5.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryEditorDisplayFileOffsetsForSRAM")));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    public JMenu makeMenuNavigate(final Window window) {
        JMenu jMenu = new JMenu("Navigate");
        jMenu.setMnemonic('n');
        MenuItem menuItem = new MenuItem("Go To", 103);
        jMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditor.this.openGoToDialog(window);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return jMenu;
    }

    private static String hexToText(String string, boolean bl) {
        if ((string = string.replaceAll("\\s", "")).length() % 2 != 0) {
            string = "0" + string;
        }
        String string2 = "";
        try {
            if (bl) {
                int n = string.length() - 2;
                while (n >= 0) {
                    string2 = String.valueOf(string2) + (char)Integer.parseInt(string.substring(n, n + 2), 16);
                    n -= 2;
                }
            } else {
                int n = 0;
                while (n < string.length()) {
                    string2 = String.valueOf(string2) + (char)Integer.parseInt(string.substring(n, n + 2), 16);
                    n += 2;
                }
            }
            return string2;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    String findPrevHex(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string2 = MemoryEditor.hexToText(string, bl);
        if (string2 == null) {
            return "Input invalid";
        }
        return this.findPrev(string2, true, false, bl2, bl3, bl4);
    }

    String findPrev(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return this.getCurrentPanel().findPrev(string, bl, bl2, bl3, bl4, bl5);
    }

    String findNextHex(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string2 = MemoryEditor.hexToText(string, bl);
        if (string2 == null) {
            return "Input invalid";
        }
        return this.findNext(string2, true, false, bl2, bl3, bl4, bl5);
    }

    String findNext(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return this.getCurrentPanel().findNext(string, bl, bl2, bl3, bl4, bl5, bl6);
    }

    static int indexOfRegEx(CharSequence charSequence, String string, boolean bl, boolean bl2, boolean bl3, int n) {
        if (!bl2 && !bl3) {
            return bl ? StringUtilities.indexOf(charSequence, string, n) : StringUtilities.indexOfIgnoreCase(charSequence, string, n);
        }
        Pattern pattern = !bl3 ? Pattern.compile("\\b" + Pattern.quote(string) + "\\b") : (bl2 ? (bl ? Pattern.compile("\\b" + string + "\\b") : Pattern.compile("\\b" + string + "\\b", 2)) : (bl ? Pattern.compile(string) : Pattern.compile(string, 2)));
        Matcher matcher = pattern.matcher(charSequence);
        if (!matcher.find(n)) {
            return -1;
        }
        return matcher.start();
    }

    private static int lastIndexOfRegEx(CharSequence charSequence, String string, boolean bl, boolean bl2, boolean bl3, int n) {
        if (!bl2 && !bl3) {
            return bl ? StringUtilities.lastIndexOf(charSequence, string, n) : StringUtilities.lastIndexOfIgnoreCase(charSequence, string, n);
        }
        Pattern pattern = !bl3 ? Pattern.compile("\\b" + Pattern.quote(string) + "\\b") : (bl2 ? (bl ? Pattern.compile("\\b" + string + "\\b") : Pattern.compile("\\b" + string + "\\b", 2)) : (bl ? Pattern.compile(string) : Pattern.compile(string, 2)));
        int n2 = -1;
        Matcher matcher = pattern.matcher(charSequence);
        matcher.region(0, n);
        while (matcher.find()) {
            n2 = matcher.start();
        }
        return n2;
    }

    public int getFirstSelectedAddress() {
        return this.getCurrentPanel().getFirstSelectedAddress();
    }

    HexEditorPanel getCurrentPanel() {
        JScrollPane jScrollPane = (JScrollPane)this.tabbedPane.getSelectedComponent();
        return (HexEditorPanel)(jScrollPane != null ? jScrollPane.getViewport().getView() : this.tabbedPane.getTabComponentAt(0));
    }

    boolean canUndo() {
        return this.changeWatcher.canUndo();
    }

    boolean canRedo() {
        return this.changeWatcher.canRedo();
    }

    void undo() {
        this.changeWatcher.undo();
    }

    void redo() {
        this.changeWatcher.redo();
    }

    boolean canSave() {
        HexEditorPanel hexEditorPanel = this.getCurrentPanel();
        int n = 0;
        while (n < this.additionalPanels.length) {
            if (hexEditorPanel == this.additionalPanels[n]) {
                return true;
            }
            ++n;
        }
        return hexEditorPanel == this.romPanel || hexEditorPanel == this.ramPanel || hexEditorPanel == this.vramPanel || hexEditorPanel == this.sramPanel || hexEditorPanel == this.palPanel;
    }

    void copySelectedAddressToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                HexEditorPanel hexEditorPanel = MemoryEditor.this.getCurrentPanel();
                int n = hexEditorPanel.getFirstSelectedAddress();
                if (n < 0) {
                    return "";
                }
                int n2 = hexEditorPanel.getLastSelectedAddress();
                if (n == n2) {
                    return String.format(hexEditorPanel.FORMAT_ADDRESS, hexEditorPanel.addressToString(n));
                }
                return String.format(String.valueOf(hexEditorPanel.FORMAT_ADDRESS) + " - " + hexEditorPanel.FORMAT_ADDRESS, hexEditorPanel.addressToString(n), hexEditorPanel.addressToString(n2));
            }
        }, null);
    }

    public void openFindDialog(Window window) {
        FindDialog.open(window, this);
    }

    public void openGoToDialog(Window window) {
        final HexEditorPanel hexEditorPanel = this.getCurrentPanel();
        final LabelProvider labelProvider = hexEditorPanel.getLabelProvider();
        List<String> list = labelProvider != null ? LabelProviderUtilities.getAllLabels(labelProvider, hexEditorPanel.getMemoryLength(), AnonymousLabelRejector.getInstance()) : Collections.emptyList();
        int n = hexEditorPanel.getFirstSelectedAddress();
        String string = GoToDialog.open(window, "Enter Address (HEX) or label:", list, new DocumentListener(){
            private String prevText;

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                try {
                    String string;
                    block6: {
                        string = document.getText(0, document.getLength());
                        if (!string.equals(this.prevText)) {
                            try {
                                String[] stringArray = string.split(":");
                                if (stringArray.length > 2) {
                                    throw new NumberFormatException();
                                }
                                int n = stringArray.length == 2 ? Integer.parseInt(stringArray[0], 16) : (hexEditorPanel == MemoryEditor.this.romPanel || hexEditorPanel == MemoryEditor.this.cpuPanel ? -1 : 0);
                                int n2 = Integer.parseInt(stringArray.length == 2 ? stringArray[1] : string, 16);
                                hexEditorPanel.goTo(n2, n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                int n = LabelProviderUtilities.getLabelAddress(labelProvider, hexEditorPanel.getMemoryLength(), string);
                                if (n < 0) break block6;
                                hexEditorPanel.setSelectedAddress(n);
                            }
                        }
                    }
                    this.prevText = string;
                }
                catch (BadLocationException badLocationException) {}
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        if (string == null) {
            hexEditorPanel.setSelectedAddress(n);
        }
    }

    public static void openCPUaddress(Window window, MemoryEditorModel memoryEditorModel, int n, int n2) {
        MemoryEditor.open(window, memoryEditorModel, true, false);
        MemoryEditor.window.getEditor().cpuPanel.setSelectedAddress(n, n2);
    }

    public static void openROMaddress(Window window, MemoryEditorModel memoryEditorModel, int n, int n2) {
        MemoryEditor.open(window, memoryEditorModel, true, false);
        MemoryEditor.window.getEditor().romPanel.setSelectedAddress(n, n2);
    }

    public static void openRAMaddress(Window window, MemoryEditorModel memoryEditorModel, int n, int n2) {
        MemoryEditor.open(window, memoryEditorModel, true, false);
        MemoryEditor.window.getEditor().ramPanel.setSelectedAddress(n, n2);
    }

    public static void openSRAMaddress(Window window, MemoryEditorModel memoryEditorModel, int n, int n2) {
        if (MemoryEditor.window.getEditor().sramPanel != null) {
            MemoryEditor.open(window, memoryEditorModel, true, false);
            MemoryEditor.window.getEditor().sramPanel.setSelectedAddress(n, n2);
        }
    }

    public static void openVRAMaddress(Window window, MemoryEditorModel memoryEditorModel, int n, int n2) {
        MemoryEditor.open(window, memoryEditorModel, true, false);
        MemoryEditor.window.getEditor().vramPanel.setSelectedAddress(n, n2);
    }

    public static void openAddressAdditionalMemory(Window window, MemoryEditorModel memoryEditorModel, String string, int n, int n2) {
        int n3 = MemoryEditor.indexOfAdditionalMemory(memoryEditorModel, string);
        if (n3 >= 0) {
            MemoryEditor.open(window, memoryEditorModel, true, false);
            MemoryEditor.window.getEditor().additionalPanels[n3].setSelectedAddress(n, n2);
        }
    }

    private static int indexOfAdditionalMemory(MemoryEditorModel memoryEditorModel, String string) {
        int n = 0;
        while (n < memoryEditorModel.getAdditionalMemoryModels().length) {
            if (memoryEditorModel.getAdditionalMemoryModels()[n].getName().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void open(Window window, MemoryEditorModel memoryEditorModel, boolean bl) {
        MemoryEditor.open(window, memoryEditorModel, false, bl);
    }

    private static void open(Window window, MemoryEditorModel memoryEditorModel, boolean bl, boolean bl2) {
        if (MemoryEditor.window == null) {
            MemoryEditor.window = new MemoryEditorWindow(window, memoryEditorModel, bl, Emulicious.isUseFrames());
            MemoryEditor.window.setVisible(true);
        } else if (!bl2) {
            MemoryEditor.window.setVisible(true);
        }
        if (MemoryEditor.window.isShowing()) {
            MemoryEditor.window.refreshTimer.restart();
        }
    }

    public static void systemUpdated() {
        if (window != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    window.updateModel();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public String getNameOfSelectedTab() {
        int n = Math.max(0, this.tabbedPane.getSelectedIndex());
        return this.tabbedPane.getTitleAt(n).replace("*", "");
    }

    public void selectTabByName(String string, String string2, int n) {
        int n2 = 0;
        while (n2 < this.tabbedPane.getTabCount()) {
            if (this.tabbedPane.getTitleAt(n2).replace("*", "").equals(string)) {
                this.tabbedPane.setSelectedIndex(n2);
                this.getCurrentPanel().setSelectedAddress(n);
                if (string2 != null) {
                    final String[] stringArray = string2.split(",");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MemoryEditor.this.getCurrentPanel().scrollRectToVisible(new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
                        }
                    });
                }
                return;
            }
            ++n2;
        }
    }

    public String getTabVisibleRect() {
        HexEditorPanel hexEditorPanel = this.getCurrentPanel();
        Rectangle rectangle = hexEditorPanel.getVisibleRect();
        return String.valueOf(rectangle.x) + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    }

    int calcMinimumTabHeaderHeight() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabbedPane.getTabCount()) {
            Rectangle rectangle = this.tabbedPane.getUI().getTabBounds(this.tabbedPane, n2);
            n += rectangle.height;
            ++n2;
        }
        return n;
    }

    public void setEditorForeground(Color color) {
        this.romPanel.setForeground(color);
        this.ramPanel.setForeground(color);
        this.cpuPanel.setForeground(color);
        this.palPanel.setForeground(color);
        this.vramPanel.setForeground(color);
        if (this.sramPanel != null) {
            this.sramPanel.setForeground(color);
        }
        HexEditorPanel[] hexEditorPanelArray = this.additionalPanels;
        int n = this.additionalPanels.length;
        int n2 = 0;
        while (n2 < n) {
            HexEditorPanel hexEditorPanel = hexEditorPanelArray[n2];
            hexEditorPanel.setForeground(color);
            ++n2;
        }
        this.statusBarLabel.setText(" ");
        this.updateStatusBar();
    }

    public void setEditorBackground(Color color) {
        this.romPanel.setBackground(color);
        this.ramPanel.setBackground(color);
        this.cpuPanel.setBackground(color);
        this.palPanel.setBackground(color);
        this.vramPanel.setBackground(color);
        if (this.sramPanel != null) {
            this.sramPanel.setBackground(color);
        }
        HexEditorPanel[] hexEditorPanelArray = this.additionalPanels;
        int n = this.additionalPanels.length;
        int n2 = 0;
        while (n2 < n) {
            HexEditorPanel hexEditorPanel = hexEditorPanelArray[n2];
            hexEditorPanel.setBackground(color);
            ++n2;
        }
    }

    public void setSelectionForeground(Color color) {
        this.selectionForeground = color;
    }

    public void setSelectionBackground(Color color) {
        this.selectionBackground = color;
    }

    public static void close() {
        if (window != null) {
            Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "Open", "" + window.isVisible());
            Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "X", "" + window.getX());
            Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "Y", "" + window.getY());
            Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "Width", "" + window.getWidth());
            Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "Height", "" + window.getHeight());
            Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "SelectedTab", window.getEditor().getNameOfSelectedTab());
            Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "TabVisibleRect", window.getEditor().getTabVisibleRect());
            Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "SelectedAddress", "" + window.getEditor().getFirstSelectedAddress());
            if (findDialog != null) {
                findDialog.saveState(Emulicious.getProperties());
            }
            window.refreshTimer.stop();
            window.editor.dispose();
            window.dispose();
            window = null;
            if (findDialog != null) {
                findDialog.dispose();
            }
            findDialog = null;
        }
    }

    private void showTableFileChooser(Component component) {
        File file = Emulicious.getROMfile().getParentFile();
        if (this.tableFile != null) {
            file = this.tableFile.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        fileChooser.setSelectedFile(this.tableFile);
        fileChooser.setDialogTitle("Load Table File...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Table files (*.tbl)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith("tbl") || file.isDirectory();
            }
        });
        if (fileChooser.showOpenDialog(component) == 0) {
            this.table = this.loadTable(fileChooser.getSelectedFile());
            this.updateCharWidth(this.table != null ? this.table.values() : null);
        }
    }

    private void showSavePalettesFileChooser(Component component) throws IOException {
        File file = Emulicious.getROMfile().getParentFile();
        if (this.palFile != null) {
            file = this.palFile.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        fileChooser.setDialogTitle("Save Palettes As...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Palette files (*.pal)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".pal") || file.isDirectory();
            }
        });
        if (this.palFile != null) {
            fileChooser.setSelectedFile(this.palFile);
        } else {
            String string = Emulicious.getROMfile().getName();
            string = string.substring(0, string.lastIndexOf(46));
            fileChooser.setSelectedFile(new File(String.valueOf(string) + ".pal"));
        }
        if (fileChooser.showSaveDialog(component) == 0) {
            this.savePalettes(fileChooser.getSelectedFile());
        }
    }

    private void showSaveSRAMFileChooser(Component component) throws IOException {
        File file = Emulicious.getROMfile().getParentFile();
        if (this.sramFile != null) {
            file = this.sramFile.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        fileChooser.setDialogTitle("Save SRAM As...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "SRAM files (*.sav)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sav") || file.isDirectory();
            }
        });
        if (this.sramFile != null) {
            fileChooser.setSelectedFile(this.sramFile);
        } else {
            String string = Emulicious.getROMfile().getName();
            string = string.substring(0, string.lastIndexOf(46));
            fileChooser.setSelectedFile(new File(String.valueOf(string) + ".sav"));
        }
        if (fileChooser.showSaveDialog(component) == 0) {
            this.saveSRAM(fileChooser.getSelectedFile());
        }
    }

    private void showSaveVRAMFileChooser(Component component) throws IOException {
        File file = Emulicious.getROMfile().getParentFile();
        if (this.vramFile != null) {
            file = this.vramFile.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        fileChooser.setDialogTitle("Save VRAM As...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "VRAM files (*.vrm)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".vrm") || file.isDirectory();
            }
        });
        if (this.vramFile != null) {
            fileChooser.setSelectedFile(this.vramFile);
        } else {
            String string = Emulicious.getROMfile().getName();
            string = string.substring(0, string.lastIndexOf(46));
            fileChooser.setSelectedFile(new File(String.valueOf(string) + ".vrm"));
        }
        if (fileChooser.showSaveDialog(component) == 0) {
            this.saveVRAM(fileChooser.getSelectedFile());
        }
    }

    private void showSaveRAMFileChooser(Component component) throws IOException {
        File file = Emulicious.getROMfile().getParentFile();
        if (this.ramFile != null) {
            file = this.ramFile.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        fileChooser.setDialogTitle("Save RAM As...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "RAM files (*.ram)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".ram") || file.isDirectory();
            }
        });
        if (this.ramFile != null) {
            fileChooser.setSelectedFile(this.ramFile);
        } else {
            String string = Emulicious.getROMfile().getName();
            string = string.substring(0, string.lastIndexOf(46));
            fileChooser.setSelectedFile(new File(String.valueOf(string) + ".ram"));
        }
        if (fileChooser.showSaveDialog(component) == 0) {
            this.saveRAM(fileChooser.getSelectedFile());
        }
    }

    private void showSaveROMFileChooser(Component component) throws IOException {
        File file = Emulicious.getROMfile().getParentFile();
        if (this.romFile != null) {
            file = this.romFile.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        fileChooser.setDialogTitle("Save ROM As...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "All supported files (*.sms;*.gg;*.gb;*.gbc;*.ips)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sms") || file.getName().toLowerCase().endsWith(".gg") || file.getName().toLowerCase().endsWith(".gb") || file.getName().toLowerCase().endsWith(".gbc") || file.getName().toLowerCase().endsWith(".ips") || file.isDirectory();
            }
        });
        if (this.romFile != null) {
            fileChooser.setSelectedFile(this.romFile);
        } else {
            String string = Emulicious.getROMfile().getName();
            string = string.substring(0, string.lastIndexOf(46));
            fileChooser.setSelectedFile(new File(String.valueOf(string) + ".ips"));
        }
        if (fileChooser.showSaveDialog(component) == 0) {
            if (fileChooser.getSelectedFile().getName().toLowerCase().endsWith(".ips")) {
                this.saveIPS(fileChooser.getSelectedFile());
            } else {
                this.saveROM(fileChooser.getSelectedFile());
            }
        }
    }

    private void showSaveAdditionalMemoryFileChooser(Component component, int n) throws IOException {
        File file = Emulicious.getROMfile().getParentFile();
        if (this.romFile != null) {
            file = this.romFile.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        fileChooser.setDialogTitle("Save " + this.additionalMemoryModels[n].getName() + " As...");
        FileFilter fileFilter = new FileFilter(){

            @Override
            public String getDescription() {
                return "Binary files (*.bin)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".bin") || file.isDirectory();
            }
        };
        fileChooser.addChoosableFileFilter(fileFilter);
        fileChooser.setFileFilter(fileFilter);
        String string = Emulicious.getROMfile().getName();
        string = string.substring(0, string.lastIndexOf(46));
        fileChooser.setSelectedFile(new File(String.valueOf(string) + ".bin"));
        if (fileChooser.showSaveDialog(component) == 0) {
            this.saveAdditionalMemory(fileChooser.getSelectedFile(), n);
        }
    }

    private void showSaveSelectionFileChooser(Component component) throws IOException {
        File file = Emulicious.getROMfile().getParentFile();
        if (this.romFile != null) {
            file = this.romFile.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        String string = this.getNameOfSelectedTab();
        fileChooser.setDialogTitle("Save " + string + " Selection (" + this.selectionToString() + ") As...");
        FileFilter fileFilter = new FileFilter(){

            @Override
            public String getDescription() {
                return "Binary files (*.bin)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".bin") || file.isDirectory();
            }
        };
        fileChooser.addChoosableFileFilter(fileFilter);
        fileChooser.setFileFilter(fileFilter);
        String string2 = Emulicious.getROMfile().getName();
        string2 = string2.substring(0, string2.lastIndexOf(46));
        fileChooser.setSelectedFile(new File(String.valueOf(string2) + ".bin"));
        if (fileChooser.showSaveDialog(component) == 0) {
            this.saveSelection(fileChooser.getSelectedFile());
        }
    }

    private void savePalettes(File file) throws IOException {
        int[] nArray = new int[this.model.getNumberOfPaletteBytes()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.model.getPaletteByte(n);
            ++n;
        }
        MemoryEditor.saveData(file, nArray);
        this.palFile = file;
    }

    private void saveSRAM(File file) throws IOException {
        MemoryEditor.saveData(file, this.model.getSRAM());
        this.sramFile = file;
    }

    private void saveVRAM(File file) throws IOException {
        MemoryEditor.saveData(file, this.model.getVRAM());
        this.vramFile = file;
    }

    private void saveRAM(File file) throws IOException {
        MemoryEditor.saveData(file, this.model.getRAM());
        this.ramFile = file;
    }

    private void saveROM(File file) throws IOException {
        MemoryEditor.saveData(file, this.model.getROM());
        this.romFile = file;
        this.changeWatcher.clearChangesFlag();
    }

    private void saveAdditionalMemory(File file, int n) throws IOException {
        MemoryEditorModel.MemoryModel memoryModel = this.additionalMemoryModels[n];
        int[] nArray = new int[memoryModel.length()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = memoryModel.readByte(n2);
            ++n2;
        }
        MemoryEditor.saveData(file, nArray);
    }

    private static void saveData(File file, int[] nArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        ((OutputStream)fileOutputStream).write(byArray);
        ((OutputStream)fileOutputStream).close();
    }

    private void saveIPS(File file) throws IOException {
        IPS iPS = new IPS(this.model.getROM(), Emulicious.getROMfile());
        iPS.writeToFile(file);
        this.romFile = file;
        this.changeWatcher.clearChangesFlag();
    }

    private void saveSelection(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int[] nArray = this.getCurrentPanel().getSelectedBytes();
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        ((OutputStream)fileOutputStream).write(byArray);
        ((OutputStream)fileOutputStream).close();
    }

    protected static final void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = listeners;
        int n3 = listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public static final void addOutputListener(OutputListener outputListener) {
        if (!listenerList.contains(outputListener)) {
            listenerList.addFirst(outputListener);
            listeners = listenerList.toArray(new OutputListener[listenerList.size()]);
        }
    }

    public static final void removeOutputListener(OutputListener outputListener) {
        if (listenerList.remove(outputListener)) {
            listeners = listenerList.toArray(new OutputListener[listenerList.size()]);
        }
    }

    private static abstract class AbstractDataTypeProvider
    implements DataTypeProvider {
        private AbstractDataTypeProvider() {
        }

        @Override
        public boolean hasDataType(int n) {
            return this.isCode(n) || this.isTileData(n) || this.isPaletteData(n) || this.isTilemapData(n) || this.isSpriteData(n) || this.isSoundData(n);
        }
    }

    private static abstract class ArrayMemoryModel
    implements MemoryEditorModel.MemoryModel {
        private final String name;
        private final int[] array;
        private final int eventID;

        public ArrayMemoryModel(String string, int[] nArray, int n) {
            this.name = string;
            this.array = nArray;
            this.eventID = n;
        }

        @Override
        public int readByte(int n) {
            return this.array[n];
        }

        @Override
        public void writeByte(int n, int n2) {
            this.array[n] = n2;
            if (this.eventID >= 0) {
                MemoryEditor.fireOutputAvailable(this.eventID, n);
            }
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static interface BackgroundColorProvider {
        public Color getBackground(int var1);
    }

    private final class Change {
        private HexEditorPanel editor;
        private int[] oldValues;
        private int address;

        public Change(HexEditorPanel hexEditorPanel, int n, int n2) {
            this.editor = hexEditorPanel;
            this.address = n;
            this.oldValues = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.oldValues[n3] = hexEditorPanel.getValueAt(n + n3);
                ++n3;
            }
        }

        public String toString() {
            return String.format("Address: %05X OldValue: %02X", this.address, this.oldValues[0]);
        }
    }

    private final class ChangeWatcher {
        private LinkedList<Change> undoStack = new LinkedList();
        private LinkedList<Change> redoStack = new LinkedList();
        private int size;
        private int savedNumRomChanges;

        public ChangeWatcher(int n) {
            this.size = n;
        }

        public void undo() {
            if (this.canUndo()) {
                Change change = this.undoStack.pop();
                int[] nArray = change.oldValues;
                this.redoStack.push(new Change(change.editor, change.address, nArray.length));
                change.editor.setValueAdjusting(true);
                int n = 0;
                while (n < nArray.length) {
                    change.editor.setValueAt(nArray[n], change.address + n);
                    ++n;
                }
                change.editor.setValueAdjusting(false);
                change.editor.setSelectedAddress(change.address, change.address + change.oldValues.length - 1);
                this.setRomHasChanges(this.countRomChanges() != this.savedNumRomChanges);
            }
        }

        public void redo() {
            if (this.canRedo()) {
                Change change = this.redoStack.pop();
                int[] nArray = change.oldValues;
                this.undoStack.push(new Change(change.editor, change.address, nArray.length));
                change.editor.setValueAdjusting(true);
                int n = 0;
                while (n < nArray.length) {
                    change.editor.setValueAt(nArray[n], change.address + n);
                    ++n;
                }
                change.editor.setValueAdjusting(false);
                change.editor.setSelectedAddress(change.address, change.address + change.oldValues.length - 1);
                this.setRomHasChanges(this.countRomChanges() != this.savedNumRomChanges);
            }
        }

        public boolean canUndo() {
            return !this.undoStack.isEmpty();
        }

        public boolean canRedo() {
            return !this.redoStack.isEmpty();
        }

        public void setRomHasChanges(boolean bl) {
            int n = 0;
            while (n < MemoryEditor.this.tabbedPane.getTabCount()) {
                Component component = MemoryEditor.this.tabbedPane.getComponentAt(n);
                if (component instanceof JScrollPane) {
                    Component component2 = ((JScrollPane)component).getViewport().getView();
                    if (MemoryEditor.this.romPanel.equals(component2)) {
                        if (bl) {
                            if (MemoryEditor.this.tabbedPane.getTitleAt(n).charAt(0) == '*') break;
                            MemoryEditor.this.tabbedPane.setTitleAt(n, "*" + MemoryEditor.this.tabbedPane.getTitleAt(n));
                            break;
                        }
                        MemoryEditor.this.tabbedPane.setTitleAt(n, MemoryEditor.this.tabbedPane.getTitleAt(n).replace("*", ""));
                        break;
                    }
                }
                ++n;
            }
        }

        public void clearChangesFlag() {
            this.setRomHasChanges(false);
            this.savedNumRomChanges = this.countRomChanges();
        }

        public void changeOccurring(Change change) {
            int n = this.countRomChanges();
            if (n < this.savedNumRomChanges) {
                this.savedNumRomChanges = -1;
            }
            this.undoStack.push(change);
            this.redoStack.clear();
            if (this.undoStack.size() > this.size) {
                this.undoStack.removeLast();
                if (n != this.savedNumRomChanges) {
                    this.savedNumRomChanges = -1;
                }
            }
            if (change.editor == MemoryEditor.this.romPanel) {
                this.setRomHasChanges(true);
            }
        }

        private int countRomChanges() {
            int n = 0;
            for (Change change : this.undoStack) {
                if (change.editor != MemoryEditor.this.romPanel) continue;
                ++n;
            }
            return n;
        }

        public void reset() {
            this.undoStack.clear();
            this.redoStack.clear();
            this.savedNumRomChanges = 0;
            this.setRomHasChanges(false);
        }
    }

    private static interface DataTypeProvider {
        public boolean isCode(int var1);

        public boolean isTileData(int var1);

        public boolean isPaletteData(int var1);

        public boolean isTilemapData(int var1);

        public boolean isSpriteData(int var1);

        public boolean isSoundData(int var1);

        public boolean hasDataType(int var1);
    }

    private static class FindDialog
    extends JDialog {
        private final HistoryBox find = new HistoryBox("MemoryEditorFind", 16);
        private final JCheckBox checkBoxCSorLE = new JCheckBox("Case sensitive");
        private final JCheckBox checkBoxWrapSearch = new JCheckBox("Wrap search");
        private final JCheckBox checkBoxWholeWord = new JCheckBox("Whole word");
        private final JCheckBox checkBoxSearchWhileTyping = new JCheckBox("Search while typing");
        private final JCheckBox checkBoxRegularExpression = new JCheckBox("Regular expression");
        private MemoryEditor editor;

        private FindDialog(Window window) {
            super(window, "Find");
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add(new JLabel("Find:"));
            jPanel.add(this.find);
            this.add((Component)jPanel, "North");
            JPanel jPanel2 = new JPanel(new GridLayout(4, 2));
            jPanel2.setBorder(BorderFactory.createTitledBorder("Options"));
            ButtonGroup buttonGroup = new ButtonGroup();
            final JRadioButton jRadioButton = new JRadioButton("Text", true);
            buttonGroup.add(jRadioButton);
            jPanel2.add(jRadioButton);
            JRadioButton jRadioButton2 = new JRadioButton("HEX", false);
            buttonGroup.add(jRadioButton2);
            jPanel2.add(jRadioButton2);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jRadioButton.isSelected()) {
                        FindDialog.this.checkBoxCSorLE.setText("Case sensitive");
                    } else {
                        FindDialog.this.checkBoxCSorLE.setText("Little endian");
                    }
                }
            };
            jRadioButton.addActionListener(actionListener);
            jRadioButton2.addActionListener(actionListener);
            jPanel2.add(this.checkBoxCSorLE);
            jPanel2.add(this.checkBoxWrapSearch);
            jPanel2.add(this.checkBoxWholeWord);
            jPanel2.add(this.checkBoxSearchWhileTyping);
            jPanel2.add(this.checkBoxRegularExpression);
            this.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 2));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            final JLabel jLabel = new JLabel();
            JButton jButton = new JButton("Find Previous");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jRadioButton.isSelected()) {
                        jLabel.setText(FindDialog.this.editor.findPrev(FindDialog.this.find.getText(), FindDialog.this.checkBoxCSorLE.isSelected(), true, FindDialog.this.checkBoxWholeWord.isSelected(), FindDialog.this.checkBoxRegularExpression.isSelected(), FindDialog.this.checkBoxWrapSearch.isSelected()));
                    } else {
                        jLabel.setText(FindDialog.this.editor.findPrevHex(FindDialog.this.find.getText(), FindDialog.this.checkBoxCSorLE.isSelected(), FindDialog.this.checkBoxWholeWord.isSelected(), FindDialog.this.checkBoxRegularExpression.isSelected(), FindDialog.this.checkBoxWrapSearch.isSelected()));
                    }
                    FindDialog.this.find.rememberCurrentText();
                }
            });
            JButton jButton2 = new JButton("Find Next");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jRadioButton.isSelected()) {
                        jLabel.setText(FindDialog.this.editor.findNext(FindDialog.this.find.getText(), FindDialog.this.checkBoxCSorLE.isSelected(), true, FindDialog.this.checkBoxWrapSearch.isSelected(), FindDialog.this.checkBoxWholeWord.isSelected(), FindDialog.this.checkBoxRegularExpression.isSelected(), false));
                    } else {
                        jLabel.setText(FindDialog.this.editor.findNextHex(FindDialog.this.find.getText(), FindDialog.this.checkBoxCSorLE.isSelected(), FindDialog.this.checkBoxWrapSearch.isSelected(), FindDialog.this.checkBoxWholeWord.isSelected(), FindDialog.this.checkBoxRegularExpression.isSelected(), false));
                    }
                    FindDialog.this.find.rememberCurrentText();
                }
            });
            JButton jButton3 = new JButton(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FindDialog.this.setVisible(false);
                }
            });
            this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "Close");
            this.getRootPane().getActionMap().put("Close", jButton3.getAction());
            this.setDefaultCloseOperation(1);
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            jPanel3.add(jLabel);
            jPanel3.add(jButton3);
            this.add((Component)jPanel3, "South");
            this.pack();
            this.getRootPane().setDefaultButton(jButton2);
            this.loadState(Emulicious.getProperties());
            JTextComponent jTextComponent = (JTextComponent)this.find.getEditor().getEditorComponent();
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                private void textChanged() {
                    if (FindDialog.this.checkBoxSearchWhileTyping.isSelected()) {
                        if (jRadioButton.isSelected()) {
                            jLabel.setText(FindDialog.this.editor.findNext(FindDialog.this.find.getText(), FindDialog.this.checkBoxCSorLE.isSelected(), true, FindDialog.this.checkBoxWrapSearch.isSelected(), FindDialog.this.checkBoxWholeWord.isSelected(), FindDialog.this.checkBoxRegularExpression.isSelected(), true));
                        } else if (FindDialog.this.find.getText().length() % 2 == 0) {
                            jLabel.setText(FindDialog.this.editor.findNextHex(FindDialog.this.find.getText(), FindDialog.this.checkBoxCSorLE.isSelected(), FindDialog.this.checkBoxWrapSearch.isSelected(), FindDialog.this.checkBoxWholeWord.isSelected(), FindDialog.this.checkBoxRegularExpression.isSelected(), true));
                        }
                    }
                }
            });
        }

        public void loadState(Properties properties) {
            this.find.loadHistory(Emulicious.getProperties());
            this.checkBoxCSorLE.setSelected(Boolean.parseBoolean(properties.getProperty("MemoryEditorFindCaseSensitive")));
            this.checkBoxWrapSearch.setSelected(Boolean.parseBoolean(properties.getProperty("MemoryEditorFindWrapSearch")));
            this.checkBoxWholeWord.setSelected(Boolean.parseBoolean(properties.getProperty("MemoryEditorFindWholeWord")));
            this.checkBoxSearchWhileTyping.setSelected(Boolean.parseBoolean(properties.getProperty("MemoryEditorFindSearchWhileTyping")));
            this.checkBoxRegularExpression.setSelected(Boolean.parseBoolean(properties.getProperty("MemoryEditorFindRegularExpression")));
        }

        public void saveState(Properties properties) {
            this.find.saveHistory(properties);
            properties.setProperty("MemoryEditorFindCaseSensitive", Boolean.toString(this.checkBoxCSorLE.isSelected()));
            properties.setProperty("MemoryEditorFindWrapSearch", Boolean.toString(this.checkBoxWrapSearch.isSelected()));
            properties.setProperty("MemoryEditorFindWholeWord", Boolean.toString(this.checkBoxWholeWord.isSelected()));
            properties.setProperty("MemoryEditorFindSearchWhileTyping", Boolean.toString(this.checkBoxSearchWhileTyping.isSelected()));
            properties.setProperty("MemoryEditorFindRegularExpression", Boolean.toString(this.checkBoxRegularExpression.isSelected()));
        }

        private void setEditor(MemoryEditor memoryEditor) {
            this.editor = memoryEditor;
        }

        private static void open(Window window, MemoryEditor memoryEditor) {
            if (findDialog == null) {
                MemoryEditor.findDialog = new FindDialog(window);
            }
            findDialog.setLocationRelativeTo(window);
            findDialog.setEditor(memoryEditor);
            findDialog.find.requestFocus();
            findDialog.setVisible(true);
        }
    }

    private class HexEditorPanel
    extends JPanel
    implements Scrollable {
        private final MemoryEditorModel.MemoryModel memory;
        private final JList<String> addressColumn;
        private final HexEditor hexEditor;
        private final DataTypeProvider dataTypeProvider;
        private final String FORMAT_OFFSETS;
        private final String FORMAT_ADDRESS;
        private final String FORMAT_ADDRESS_WITH_LABEL;
        private final String FORMAT_ADDRESS_AND_VALUE_WITH_LABELS;
        private final String[] REGISTER_NAMES;
        private final MemoryCharSequence MEMORY_CHAR_SEQUENCE;
        private final MemoryCharSequence TABLE_BASED_MEMORY_CHAR_SEQUENCE;
        private boolean displayOffsets;
        private boolean valueAdjusting;

        public HexEditorPanel(final MemoryEditorModel.MemoryModel memoryModel, final DataTypeProvider dataTypeProvider, final BackgroundColorProvider backgroundColorProvider, final IntMap intMap, final PopupMenuProvider popupMenuProvider) {
            super(new BorderLayout());
            if (memoryModel == null) {
                throw new IllegalArgumentException("memory must not be null");
            }
            this.memory = memoryModel;
            this.dataTypeProvider = dataTypeProvider;
            this.MEMORY_CHAR_SEQUENCE = new MemoryCharSequence(memoryModel);
            this.TABLE_BASED_MEMORY_CHAR_SEQUENCE = new TableBasedMemoryCharSequence(memoryModel);
            int n = memoryModel.length() - 1;
            int n2 = 0;
            while (n > 0) {
                n /= 16;
                ++n2;
            }
            this.FORMAT_OFFSETS = "%0" + Math.max(1, n2) + "X";
            this.FORMAT_ADDRESS = "%s";
            this.FORMAT_ADDRESS_WITH_LABEL = "<b>Address</b>:&nbsp;" + this.FORMAT_ADDRESS;
            this.FORMAT_ADDRESS_AND_VALUE_WITH_LABELS = String.valueOf(this.FORMAT_ADDRESS_WITH_LABEL) + "%s   <b>Value</b>:&nbsp;$%02X&nbsp;|&nbsp;%%%s&nbsp;|&nbsp;%s%s";
            this.REGISTER_NAMES = MemoryEditor.this.model.getRegisterNames();
            this.hexEditor = new HexEditor(new AbstractHexEditorModel(){
                private int length;
                {
                    this.length = memoryModel2.length();
                }

                @Override
                public void setValueAt(int n, int n2, int n3) {
                    int n4 = n2 * 16 + n3;
                    if (!HexEditorPanel.this.valueAdjusting && n2 == HexEditorPanel.this.hexEditor.getFirstSelectedRow() && n3 == HexEditorPanel.this.hexEditor.getFirstSelectedColumn()) {
                        int n5 = HexEditorPanel.this.hexEditor.getFirstSelectedRow();
                        int n6 = HexEditorPanel.this.hexEditor.getFirstSelectedColumn();
                        int n7 = HexEditorPanel.this.hexEditor.getLastSelectedRow();
                        int n8 = HexEditorPanel.this.hexEditor.getLastSelectedColumn();
                        int n9 = this.getColumnCount(n5) - n6 + this.getColumnCount(n5) * (n7 - n5) - (this.getColumnCount(n7) - n8 - 1);
                        MemoryEditor.this.changeWatcher.changeOccurring(new Change(HexEditorPanel.this, n4, n9));
                    }
                    memoryModel.writeByte(n4, n & 0xFF);
                }

                @Override
                public String getSymbolAt(int n, int n2) {
                    if (((HexEditorPanel)HexEditorPanel.this).MemoryEditor.this.table != null) {
                        String string = MemoryEditor.this.getTableSymbolAt(memoryModel, this.indexAt(n, n2));
                        if (string != null && !string.isEmpty()) {
                            return string;
                        }
                        return ".";
                    }
                    if (this.getValueAt(n, n2) == 0) {
                        return ".";
                    }
                    return super.getSymbolAt(n, n2);
                }

                @Override
                public int getValueAt(int n, int n2) {
                    return memoryModel.readByte(this.indexAt(n, n2));
                }

                private int indexAt(int n, int n2) {
                    return n * 16 + n2;
                }

                @Override
                public int getRowCount() {
                    int n = memoryModel.length();
                    if (n != this.length) {
                        this.length = n;
                        this.fireModelChanged();
                    }
                    if (n == 0) {
                        return 0;
                    }
                    return (n - 15) / 16 + 1;
                }

                @Override
                public int getColumnCount(int n) {
                    if (n == this.getRowCount() - 1 && memoryModel.length() % 16 != 0) {
                        return memoryModel.length() % 16;
                    }
                    return 16;
                }
            });
            this.hexEditor.getSelectionModel().addHexEditorSelectionListener(new HexEditorSelectionListener(){

                @Override
                public void valueChanged(HexEditorSelectionEvent hexEditorSelectionEvent) {
                    MemoryEditor.this.updateStatusBar();
                }
            });
            this.hexEditor.setColorModel(new DefaultHexEditorColorModel(){

                @Override
                public Color getForegroundAt(int n, int n2) {
                    int n3 = n * 16 + n2;
                    if (!memoryModel.isInitialized(n3)) {
                        return UNINITIALIZED_COLOR;
                    }
                    if (dataTypeProvider == null || !dataTypeProvider.hasDataType(n3)) {
                        return null;
                    }
                    if (dataTypeProvider.isTileData(n3)) {
                        return TILE_COLOR;
                    }
                    if (dataTypeProvider.isPaletteData(n3)) {
                        return PALETTE_COLOR;
                    }
                    if (dataTypeProvider.isTilemapData(n3)) {
                        return TILEMAP_COLOR;
                    }
                    if (dataTypeProvider.isSpriteData(n3)) {
                        return SPRITE_COLOR;
                    }
                    if (dataTypeProvider.isSoundData(n3)) {
                        return SOUND_COLOR;
                    }
                    if (dataTypeProvider.isCode(n3)) {
                        return CODE_COLOR;
                    }
                    return null;
                }

                @Override
                public Color getBackgroundAt(int n, int n2) {
                    if (!MemoryEditor.this.showDebuggerHighlighting || backgroundColorProvider == null) {
                        return null;
                    }
                    int n3 = n * 16 + n2;
                    return backgroundColorProvider.getBackground(n3);
                }

                @Override
                public Color getSelectionForegroundAt(int n, int n2) {
                    if (MemoryEditor.this.selectionForeground == null) {
                        Color color = HexEditorPanel.this.getForeground();
                        MemoryEditor.this.selectionForeground = new Color(color.getRed() ^ 0xFF, color.getGreen() ^ 0xFF, color.getBlue() ^ 0xFF);
                    }
                    return MemoryEditor.this.selectionForeground;
                }

                @Override
                public Color getSelectionBackgroundAt(int n, int n2) {
                    if (MemoryEditor.this.selectionBackground == null) {
                        Color color = HexEditorPanel.this.getBackground();
                        MemoryEditor.this.selectionBackground = new Color(color.getRed() ^ 0xFF, color.getGreen() ^ 0xFF, color.getBlue() ^ 0xFF);
                    }
                    return MemoryEditor.this.selectionBackground;
                }
            });
            this.hexEditor.setStyleModel(new DefaultHexEditorStyleModel(){

                @Override
                public boolean isUnderlined(int n, int n2) {
                    if (!MemoryEditor.this.showLabels) {
                        return false;
                    }
                    int n3 = n * 16 + n2;
                    return memoryModel.hasLabel(n3);
                }

                @Override
                public boolean isBold(int n, int n2) {
                    int n3 = n * 16 + n2;
                    return dataTypeProvider != null && dataTypeProvider.hasDataType(n3);
                }
            });
            if (intMap != null) {
                this.hexEditor.setAnnotationModel(new DefaultHexEditorAnnotationModel(){

                    @Override
                    public String getAnnotation(int n, int n2) {
                        if (!MemoryEditor.this.showRegisters) {
                            return null;
                        }
                        int n3 = n * 16 + n2;
                        int n4 = intMap.get(n3);
                        if (n4 == Integer.MIN_VALUE) {
                            return null;
                        }
                        if (n4 == -1) {
                            return "VA";
                        }
                        return HexEditorPanel.this.REGISTER_NAMES[n4];
                    }
                });
            }
            this.hexEditor.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    int n = HexEditorPanel.this.hexEditor.rowAtPoint(mouseEvent.getPoint());
                    int n2 = HexEditorPanel.this.hexEditor.columnAtPoint(mouseEvent.getPoint());
                    if (n < 0 || n2 < 0) {
                        return;
                    }
                    int n3 = n * 16 + n2;
                    List<String> list = memoryModel.getLabels(n3);
                    if (list == null || list.isEmpty() || list.size() == 1 && list.get(0).isEmpty()) {
                        HexEditorPanel.this.hexEditor.setToolTipText(null);
                    } else {
                        StringBuilder stringBuilder = new StringBuilder("<html>");
                        int n4 = 0;
                        while (n4 < list.size()) {
                            if (n4 != 0) {
                                stringBuilder.append('\n');
                            }
                            stringBuilder.append(list.get(n4));
                            ++n4;
                        }
                        HexEditorPanel.this.hexEditor.setToolTipText(stringBuilder.append("</html>").toString().replace("\n", "<br />").replace(" ", "&nbsp;"));
                    }
                }
            });
            this.hexEditor.setCursorBlinkDelay(Emulicious.getProperties().getInt("MemoryEditorCursorBlinkDelay", 500));
            if (popupMenuProvider != null) {
                this.hexEditor.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            int n = HexEditorPanel.this.hexEditor.rowAtPoint(mouseEvent.getPoint());
                            int n2 = HexEditorPanel.this.hexEditor.columnAtPoint(mouseEvent.getPoint());
                            if (!HexEditorPanel.this.hexEditor.getSelectionModel().isSelected(n, n2)) {
                                HexEditorPanel.this.hexEditor.setSelection(n, n2);
                            }
                            int n3 = HexEditorPanel.this.hexEditor.getFirstSelectedRow() * 16 + HexEditorPanel.this.hexEditor.getFirstSelectedColumn();
                            int n4 = HexEditorPanel.this.hexEditor.getLastSelectedRow() * 16 + HexEditorPanel.this.hexEditor.getLastSelectedColumn();
                            popupMenuProvider.showPopupMenu(n3, n4, HexEditorPanel.this.hexEditor, mouseEvent.getPoint());
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            int n = HexEditorPanel.this.hexEditor.rowAtPoint(mouseEvent.getPoint());
                            int n2 = HexEditorPanel.this.hexEditor.columnAtPoint(mouseEvent.getPoint());
                            if (!HexEditorPanel.this.hexEditor.getSelectionModel().isSelected(n, n2)) {
                                HexEditorPanel.this.hexEditor.setSelection(n, n2);
                            }
                            int n3 = HexEditorPanel.this.hexEditor.getFirstSelectedRow() * 16 + HexEditorPanel.this.hexEditor.getFirstSelectedColumn();
                            int n4 = HexEditorPanel.this.hexEditor.getLastSelectedRow() * 16 + HexEditorPanel.this.hexEditor.getLastSelectedColumn();
                            popupMenuProvider.showPopupMenu(n3, n4, HexEditorPanel.this.hexEditor, mouseEvent.getPoint());
                        }
                    }
                });
            }
            this.addressColumn = this.makeAddressColumn();
            this.add(this.addressColumn, "West");
            this.add((Component)this.hexEditor, "Center");
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
            if (this.hexEditor != null) {
                this.hexEditor.setForeground(color);
            }
        }

        @Override
        public Color getForeground() {
            return this.hexEditor != null ? this.hexEditor.getForeground() : super.getForeground();
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            if (this.hexEditor != null) {
                this.hexEditor.setBackground(color);
            }
        }

        @Override
        public Color getBackground() {
            return this.hexEditor != null ? this.hexEditor.getBackground() : super.getBackground();
        }

        @Override
        public Font getFont() {
            return this.hexEditor != null ? this.hexEditor.getFont() : super.getFont();
        }

        private JList<String> makeAddressColumn() {
            AbstractListModel<String> abstractListModel = new AbstractListModel<String>(){
                private final HexEditor hexEditor;
                {
                    this.hexEditor = HexEditorPanel.this.hexEditor;
                }

                @Override
                public int getSize() {
                    return this.hexEditor.getModel().getRowCount();
                }

                @Override
                public String getElementAt(int n) {
                    return HexEditorPanel.this.addressToString(n * this.hexEditor.getModel().getColumnCount(0));
                }
            };
            JList<String> jList = new JList<String>((ListModel)abstractListModel){
                private final HexEditor hexEditor;
                private int prototypeCellValueLength;
                {
                    this.hexEditor = HexEditorPanel.this.hexEditor;
                }

                @Override
                public void setSelectedValue(Object object, boolean bl) {
                }

                @Override
                public void setSelectedIndex(int n) {
                }

                @Override
                public void setSelectedIndices(int[] nArray) {
                }

                @Override
                public void setSelectionInterval(int n, int n2) {
                }

                @Override
                public Color getForeground() {
                    return this.hexEditor != null ? this.hexEditor.getForeground() : super.getForeground();
                }

                @Override
                public Color getBackground() {
                    return this.hexEditor != null ? this.hexEditor.getBackground() : super.getBackground();
                }

                @Override
                public Font getFont() {
                    return this.hexEditor != null ? this.hexEditor.getFont() : super.getFont();
                }

                @Override
                public int getFixedCellWidth() {
                    String string = (String)this.getModel().getElementAt(0);
                    if (string != null) {
                        int n = this.getFontMetrics(this.getFont()).charWidth('0');
                        return (string.length() + 3) * n;
                    }
                    return this.hexEditor.getColumnWidth();
                }

                @Override
                public int getFixedCellHeight() {
                    return this.hexEditor.getRowHeight();
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    String string = (String)this.getModel().getElementAt(0);
                    if (string != null && string.length() != this.prototypeCellValueLength) {
                        this.setPrototypeCellValue(string);
                        this.prototypeCellValueLength = string.length();
                    }
                    super.paintComponent(graphics);
                }
            };
            jList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    if (component instanceof JComponent) {
                        ((JComponent)component).setBorder(null);
                    }
                    return component;
                }
            });
            jList.setFocusable(false);
            return jList;
        }

        public String findPrev(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            String string2;
            MemoryCharSequence memoryCharSequence = bl2 ? this.TABLE_BASED_MEMORY_CHAR_SEQUENCE : this.MEMORY_CHAR_SEQUENCE;
            int n = this.getFirstSelectedAddress() - 1;
            int n2 = MemoryEditor.lastIndexOfRegEx(memoryCharSequence, string, bl, bl3, bl4, n);
            if (bl5 && n2 < 0) {
                n2 = MemoryEditor.lastIndexOfRegEx(memoryCharSequence, string, bl, bl3, bl4, memoryCharSequence.length());
                string2 = "Wrapped search";
            } else {
                string2 = "";
            }
            if (n2 >= 0) {
                this.setSelectedAddress(n2);
                return string2;
            }
            return "Not Found";
        }

        public String findNext(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            String string2;
            MemoryCharSequence memoryCharSequence = bl2 ? this.TABLE_BASED_MEMORY_CHAR_SEQUENCE : this.MEMORY_CHAR_SEQUENCE;
            int n = this.getFirstSelectedAddress() + (!bl6 ? 1 : 0);
            int n2 = MemoryEditor.indexOfRegEx(memoryCharSequence, string, bl, bl4, bl5, n);
            if (bl3 && n2 < 0) {
                n2 = MemoryEditor.indexOfRegEx(memoryCharSequence, string, bl, bl4, bl5, 0);
                string2 = "Wrapped search";
            } else {
                string2 = "";
            }
            if (n2 >= 0) {
                this.setSelectedAddress(n2);
                return string2;
            }
            return "Not Found";
        }

        public void updateCharWidth(Collection<String> collection) {
            this.hexEditor.updateSymbolWidth(collection);
        }

        public void setHideAnnotations(boolean bl) {
            this.hexEditor.setHideAnnotations(bl);
        }

        public boolean canCopyToClipboard() {
            return this.hexEditor.canCopyToClipboard();
        }

        public void copyToClipboard() {
            this.hexEditor.copyToClipboard();
        }

        public void copyTextToClipboard() {
            this.hexEditor.copyTextToClipboard();
        }

        public boolean canPasteFromClipboard() {
            return this.hexEditor.canPasteFromClipboard();
        }

        public void pasteFromClipboard() {
            this.hexEditor.pasteFromClipboard();
        }

        public int getFirstSelectedAddress() {
            if (this.hexEditor.getSelectedRow() < 0) {
                return this.hexEditor.getSelectedRow();
            }
            return this.hexEditor.getFirstSelectedRow() * 16 + this.hexEditor.getFirstSelectedColumn();
        }

        public int getLastSelectedAddress() {
            if (this.hexEditor.getSelectedRow() < 0) {
                return this.hexEditor.getSelectedRow();
            }
            return this.hexEditor.getLastSelectedRow() * 16 + this.hexEditor.getLastSelectedColumn();
        }

        public void goTo(int n, int n2) {
            if (this.displayOffsets && n2 == 0) {
                this.setSelectedAddress(n);
            } else {
                this.setSelectedAddress(n2 >= 0 ? MemoryEditor.this.model.mapAddress(n, n2) : n);
            }
        }

        public void setSelectedAddress(int n) {
            this.setSelectedAddress(n, true);
        }

        public void setSelectedAddress(int n, boolean bl) {
            this.setSelectedAddress(n, n, bl);
        }

        public void setSelectedAddress(int n, int n2) {
            this.setSelectedAddress(n, n2, true);
        }

        public void setSelectedAddress(int n, int n2, boolean bl) {
            if (bl) {
                MemoryEditor.this.buttonFollowRegisterNone.setSelected(true);
                MemoryEditor.this.setFollowRegister(-1);
            }
            if (n2 >= this.getMemoryLength()) {
                n2 = this.getMemoryLength() - 1;
            }
            if (n <= n2) {
                Container container = this.getParent();
                while (container != null && !(container.getParent() instanceof JTabbedPane)) {
                    container = container.getParent();
                }
                if (container != null && container.getParent() instanceof JTabbedPane) {
                    JTabbedPane jTabbedPane = (JTabbedPane)container.getParent();
                    jTabbedPane.setSelectedComponent(container);
                }
                this.hexEditor.setSelection(n / 16, n % 16);
                this.hexEditor.setSelectionEnd(n2 / 16, n2 % 16);
            }
        }

        public int[] getSelectedBytes() {
            return this.hexEditor.getSelectedBytes();
        }

        public void scrollSelectedAddressToVisible() {
            HexEditorSelectionModel hexEditorSelectionModel = this.hexEditor.getSelectionModel();
            int n = hexEditorSelectionModel.getFirstSelectedRow();
            int n2 = hexEditorSelectionModel.getFirstSelectedColumn();
            int n3 = hexEditorSelectionModel.getLastSelectedRow();
            int n4 = hexEditorSelectionModel.getLastSelectedColumn();
            hexEditorSelectionModel.clearSelection();
            hexEditorSelectionModel.setSelection(n, n2, n3, n4);
        }

        public boolean isSelectedAddressVisible() {
            return this.getVisibleRect().contains(this.hexEditor.getCellRect(this.hexEditor.getSelectedRow(), this.hexEditor.getSelectedColumn()));
        }

        public void clearSelection() {
            this.hexEditor.clearSelection();
        }

        public boolean isInitialized(int n) {
            return this.memory.isInitialized(n);
        }

        public int getValueAt(int n) {
            return this.hexEditor.getModel().getValueAt(n / 16, n % 16);
        }

        public void setValueAdjusting(boolean bl) {
            this.valueAdjusting = bl;
        }

        public void setDisplayOffsets(boolean bl) {
            this.displayOffsets = bl;
            this.addressColumn.revalidate();
            this.addressColumn.repaint();
        }

        public void setValueAt(int n, int n2) {
            this.hexEditor.getModel().setValueAt(n, n2 / 16, n2 % 16);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            int n = this.hexEditor.getPreferredScrollableViewportSize().width + this.addressColumn.getPreferredScrollableViewportSize().width;
            return new Dimension(n, this.hexEditor.getPreferredScrollableViewportSize().height);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.hexEditor.getScrollableBlockIncrement(rectangle, n, n2);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.hexEditor.getScrollableTracksViewportHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.hexEditor.getScrollableTracksViewportWidth();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return this.hexEditor.getScrollableUnitIncrement(rectangle, n, n2);
        }

        public int getMemoryLength() {
            return this.memory.length();
        }

        public DataTypeProvider getDataTypeProvider() {
            return this.dataTypeProvider;
        }

        public LabelProvider getLabelProvider() {
            return this.memory;
        }

        public SourceProvider getSourceProvider() {
            return this.memory;
        }

        public String addressToString(int n) {
            if (this.displayOffsets) {
                return String.format(this.FORMAT_OFFSETS, n);
            }
            return this.memory.addressToString(n);
        }
    }

    private static class MemoryCharSequence
    implements CharSequence {
        protected final MemoryEditorModel.MemoryModel memory;

        public MemoryCharSequence(MemoryEditorModel.MemoryModel memoryModel) {
            this.memory = memoryModel;
        }

        @Override
        public int length() {
            return this.memory.length();
        }

        @Override
        public char charAt(int n) {
            return (char)this.memory.readByte(n);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MemoryEditorWindow {
        private final Timer refreshTimer = new Timer(Emulicious.getProperties().getInt("MemoryEditorUpdateMillis", 100), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryEditorWindow.this.editor.update();
            }
        });
        private final MemoryEditor editor;
        private final Window window;

        public MemoryEditorWindow(Window window, MemoryEditorModel memoryEditorModel, boolean bl, boolean bl2) {
            this.window = bl2 ? new JFrame() : new JDialog();
            this.setTitle(String.valueOf(Emulicious.TITLE) + " - Memory Editor");
            this.window.setIconImages(window.getIconImages());
            this.window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    MemoryEditorWindow.this.refreshTimer.stop();
                }
            });
            this.editor = MemoryEditor.create(memoryEditorModel);
            this.setContentPane(this.editor);
            if (!bl) {
                this.getEditor().selectTabByName(Emulicious.getProperties().getProperty("Window" + MemoryEditor.class.getSimpleName() + "SelectedTab"), Emulicious.getProperties().getProperty("Window" + MemoryEditor.class.getSimpleName() + "TabVisibleRect"), Emulicious.getProperties().getInt("Window" + MemoryEditor.class.getSimpleName() + "SelectedAddress", -1));
            }
            JMenuBar jMenuBar = new JMenuBar();
            this.setJMenuBar(jMenuBar);
            jMenuBar.add(this.makeMenuFile());
            jMenuBar.add(this.editor.makeMenuEdit(this.window));
            jMenuBar.add(this.editor.makeMenuView());
            jMenuBar.add(this.editor.makeMenuNavigate(this.window));
            if (this.window == null || !this.window.isVisible()) {
                try {
                    this.window.setSize(Emulicious.getProperties().getInt("Window" + MemoryEditor.class.getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + MemoryEditor.class.getSimpleName() + "Height"));
                }
                catch (NumberFormatException numberFormatException) {
                    this.window.pack();
                }
                try {
                    this.window.setLocation(Emulicious.getProperties().getInt("Window" + MemoryEditor.class.getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + MemoryEditor.class.getSimpleName() + "Y"));
                }
                catch (NumberFormatException numberFormatException) {
                    this.window.setLocationRelativeTo(window);
                }
            }
            if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
                this.window.setLocationRelativeTo(window);
            }
        }

        MemoryEditor getEditor() {
            return this.editor;
        }

        private void setTitle(String string) {
            if (this.window instanceof JFrame) {
                ((JFrame)this.window).setTitle(string);
            } else if (this.window instanceof JDialog) {
                ((JDialog)this.window).setTitle(string);
            }
        }

        private void setContentPane(Container container) {
            if (this.window instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)this.window)).setContentPane(container);
            }
        }

        private void setJMenuBar(JMenuBar jMenuBar) {
            if (this.window instanceof JFrame) {
                ((JFrame)this.window).setJMenuBar(jMenuBar);
            } else if (this.window instanceof JDialog) {
                ((JDialog)this.window).setJMenuBar(jMenuBar);
            }
        }

        private JMenu makeMenuFile() {
            JMenu jMenu = this.editor.makeMenuFile(this.window);
            jMenu.addSeparator();
            MenuItem menuItem = new MenuItem("Close", 108);
            jMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MemoryEditorWindow.this.refreshTimer.stop();
                    MemoryEditorWindow.this.setVisible(false);
                }
            });
            return jMenu;
        }

        void updateModel() {
            if (this.window != null) {
                Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "SelectedTab", this.getEditor().getNameOfSelectedTab());
                Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "TabVisibleRect", this.getEditor().getTabVisibleRect());
                Emulicious.getProperties().setProperty("Window" + MemoryEditor.class.getSimpleName() + "SelectedAddress", "" + this.getEditor().getFirstSelectedAddress());
            }
            this.refreshTimer.stop();
            this.getEditor().updateModel();
            this.getEditor().selectTabByName(Emulicious.getProperties().getProperty("Window" + MemoryEditor.class.getSimpleName() + "SelectedTab"), Emulicious.getProperties().getProperty("Window" + MemoryEditor.class.getSimpleName() + "TabVisibleRect"), Emulicious.getProperties().getInt("Window" + MemoryEditor.class.getSimpleName() + "SelectedAddress", -1));
            if (this.isShowing()) {
                this.refreshTimer.restart();
            }
        }

        void dispose() {
            this.window.dispose();
        }

        int getX() {
            return this.window.getX();
        }

        int getY() {
            return this.window.getY();
        }

        int getWidth() {
            return this.window.getWidth();
        }

        int getHeight() {
            return this.window.getHeight();
        }

        boolean isShowing() {
            return this.window.isShowing();
        }

        boolean isVisible() {
            return this.window.isVisible();
        }

        void setVisible(boolean bl) {
            this.window.setVisible(bl);
        }

        void showMessageDialog(Object object, String string, int n) {
            JOptionPane.showMessageDialog(this.window, object, string, n);
        }
    }

    private static interface PopupMenuProvider {
        public void showPopupMenu(int var1, int var2, Component var3, Point var4);
    }

    private class TableBasedMemoryCharSequence
    extends MemoryCharSequence {
        public TableBasedMemoryCharSequence(MemoryEditorModel.MemoryModel memoryModel) {
            super(memoryModel);
        }

        @Override
        public char charAt(int n) {
            if (MemoryEditor.this.table == null) {
                return super.charAt(n);
            }
            String string = MemoryEditor.this.getTableSymbolAt(this.memory, n);
            if (string != null && !string.isEmpty()) {
                return string.charAt(0);
            }
            return '\u0000';
        }
    }
}

