/*
 * Decompiled with CFR 0.152.
 */
package output;

import components.sound.GBSoundController;
import java.util.Arrays;
import platform.SoundOutput;

public class GBSoundOutput
extends SoundOutput {
    private static final String[] CHANNEL_NAMES = new String[]{"Channel 1", "Channel 2", "Wave Channel", "Noise Channel"};
    private static final String[] CHANNEL_NAMES_WITH_VIN = new String[CHANNEL_NAMES.length + 1];
    private final int[] CHANNEL_MIN_VALUES = new int[]{-120, -120, -120, -120, -480};
    private final int[] CHANNEL_MAX_VALUES = new int[]{120, 120, 120, 120, 480};
    private double HIGH_PASS_RATE = 1.0;
    private int boundsMultiplier = 1;
    private int valueShift = 5;
    private GBSoundController controller;
    private final int[] amplitude = new int[5];
    private final double[] capacitors = new double[8];
    private int prevCycles;
    private int subSampleCycles;
    private double sampleError;
    private double cyclesPerSample;
    private double highPassCoefficient;
    private final int sampleRate;
    private final boolean[] channelMuted = new boolean[5];
    private final int[] sample = new int[5];

    static {
        System.arraycopy(CHANNEL_NAMES, 0, CHANNEL_NAMES_WITH_VIN, 0, CHANNEL_NAMES.length);
        GBSoundOutput.CHANNEL_NAMES_WITH_VIN[GBSoundOutput.CHANNEL_NAMES_WITH_VIN.length - 1] = "Vin";
    }

    public GBSoundOutput(String string, int n, int n2) {
        super(string, n, n2, 2);
        this.sampleRate = n;
        this.cyclesPerSample = 4194304.0 / (double)n;
        this.buffer = new byte[this.getBufferSize()];
    }

    public void setHighPassCoefficient(double d) {
        int n;
        this.highPassCoefficient = d;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n2;
            this.CHANNEL_MIN_VALUES[n3] = this.CHANNEL_MIN_VALUES[n3] / this.boundsMultiplier;
            int n4 = n2++;
            this.CHANNEL_MAX_VALUES[n4] = this.CHANNEL_MAX_VALUES[n4] / this.boundsMultiplier;
        }
        this.HIGH_PASS_RATE = Math.pow(d, this.cyclesPerSample);
        this.boundsMultiplier = d >= 1.0 ? 1 : 2;
        n2 = 0;
        while (n2 < 4) {
            int n5 = n2;
            this.CHANNEL_MIN_VALUES[n5] = this.CHANNEL_MIN_VALUES[n5] * this.boundsMultiplier;
            int n6 = n2++;
            this.CHANNEL_MAX_VALUES[n6] = this.CHANNEL_MAX_VALUES[n6] * this.boundsMultiplier;
        }
        n2 = 0;
        int[] nArray = this.CHANNEL_MAX_VALUES;
        int n7 = this.CHANNEL_MAX_VALUES.length;
        int n8 = 0;
        while (n8 < n7) {
            n = nArray[n8];
            n2 += n;
            ++n8;
        }
        n = 0;
        while (n2 << 1 < Short.MAX_VALUE) {
            n2 <<= 1;
            ++n;
        }
        this.valueShift = n;
        Arrays.fill(this.capacitors, 0.0);
        this.fireBoundsChanged();
    }

    public void setController(GBSoundController gBSoundController) {
        this.controller = gBSoundController;
    }

    @Override
    public void setChannelMuted(int n, boolean bl) {
        if (n >= 0 && n < this.channelMuted.length) {
            this.channelMuted[n] = bl;
        }
    }

    @Override
    public String[] getChannelNames() {
        return this.controller != null && this.controller.getVinProvider() != null ? CHANNEL_NAMES_WITH_VIN : CHANNEL_NAMES;
    }

    @Override
    public int[] getChannelMinValues() {
        return this.CHANNEL_MIN_VALUES;
    }

    @Override
    public int[] getChannelMaxValues() {
        return this.CHANNEL_MAX_VALUES;
    }

    public void channelDisabled(int n) {
        this.amplitude[n] = 0;
        this.controller.channelDisabled(n);
    }

    @Override
    protected void updateCyclesPerSample(int n) {
        double d = 41943.04 * (double)n / (double)this.sampleRate;
        if (d >= 1.0) {
            this.cyclesPerSample = d;
        } else {
            System.err.println("Updating cycles per sample with throttle " + n + " would have lead to " + d);
        }
        this.setHighPassCoefficient(this.highPassCoefficient);
    }

    public void updateBuffer(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = (int)this.cyclesPerSample;
        int n6 = n - this.prevCycles;
        GBSoundController.VinProvider vinProvider = this.controller.getVinProvider();
        if (vinProvider != null) {
            n4 = this.subSampleCycles;
            double d = this.sampleError;
            n3 = n6;
            while (n3 >= n5 - n4) {
                if ((d += this.cyclesPerSample - (double)n5) >= 1.0) {
                    --n4;
                    d -= 1.0;
                }
                n2 = Math.max(0, n5 - n4);
                n3 -= n2;
                vinProvider.preAdvance(n2);
                n4 = 0;
            }
            if (n3 > 0) {
                vinProvider.preAdvance(n3);
            }
        }
        while (n6 >= n5 - this.subSampleCycles) {
            boolean bl;
            int n7;
            n4 = 0;
            int n8 = 0;
            this.sampleError += this.cyclesPerSample - (double)n5;
            if (this.sampleError >= 1.0) {
                --this.subSampleCycles;
                this.sampleError -= 1.0;
            }
            int n9 = Math.max(0, n5 - this.subSampleCycles);
            n3 = Math.max(n5, n9);
            this.controller.advanceChannels(n9);
            n6 -= n9;
            n2 = 0;
            while (n2 < 4) {
                n7 = this.controller.isChannelEnabled(n2) ? (this.sample[n2] + this.controller.getSamples(n2)) / n3 : this.amplitude[n2];
                this.sample[n2] = 0;
                this.amplitude[n2] = n7;
                bl = this.controller.isTerminalEnabled(false, n2);
                boolean bl2 = this.controller.isTerminalEnabled(true, n2);
                double d = bl ? (double)((15 - n7 * 2) * this.controller.getTerminalVolume(false)) : 0.0;
                double d2 = d - this.capacitors[n2 << 1];
                this.capacitors[n2 << 1] = d - d2 * this.HIGH_PASS_RATE;
                int n10 = (int)d2;
                double d3 = bl2 ? (double)((15 - n7 * 2) * this.controller.getTerminalVolume(true)) : 0.0;
                double d4 = d3 - this.capacitors[n2 << 1 | 1];
                this.capacitors[n2 << 1 | 1] = d3 - d4 * this.HIGH_PASS_RATE;
                int n11 = (int)d4;
                this.fireAmplitude(n2, false, n10);
                this.fireAmplitude(n2, true, n11);
                if (!this.channelMuted[n2]) {
                    n4 += n10;
                    n8 += n11;
                }
                ++n2;
            }
            if (vinProvider != null) {
                vinProvider.advance(n9);
                n2 = (this.sample[4] + vinProvider.getSamples()) / n3;
                this.sample[4] = 0;
                this.amplitude[4] = n2;
                n7 = this.controller.isVinEnabled(false) ? 1 : 0;
                bl = this.controller.isVinEnabled(true);
                this.fireAmplitude(4, false, (n2 - 60) * this.controller.getTerminalVolume(false));
                this.fireAmplitude(4, true, (n2 - 60) * this.controller.getTerminalVolume(true));
                if (!this.channelMuted[4]) {
                    if (n7 != 0) {
                        n4 += (n2 - 60) * this.controller.getTerminalVolume(false);
                    }
                    if (bl) {
                        n8 += (n2 - 60) * this.controller.getTerminalVolume(true);
                    }
                }
            }
            if (this.soundEnabled) {
                this.writeSample16bit(n4 << this.valueShift);
                this.writeSample16bit(n8 << this.valueShift);
            }
            this.subSampleCycles = 0;
        }
        if (n6 > 0) {
            this.controller.advanceChannels(n6);
            n4 = 0;
            while (n4 < 4) {
                int n12 = n4;
                this.sample[n12] = this.sample[n12] + this.controller.getSamples(n4);
                ++n4;
            }
            if (vinProvider != null) {
                vinProvider.advance(n6);
                this.sample[4] = this.sample[4] + vinProvider.getSamples();
            }
            this.subSampleCycles += n6;
        }
        this.prevCycles = n;
    }

    public void finishFrame() {
        this.play();
        this.prevCycles = 0;
    }
}

