/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.util.plugins.Plugins;

class DefaultControllerEnvironment
extends ControllerEnvironment {
    static String libPath;
    private static Logger log;
    private ArrayList<Controller> controllers;
    private Collection<String> loadedPluginNames = new ArrayList<String>();

    static {
        log = Logger.getLogger(DefaultControllerEnvironment.class.getName());
    }

    static void loadLibrary(final String string) {
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string2 = System.getProperty("net.java.games.input.librarypath");
                if (string2 != null) {
                    System.load(String.valueOf(string2) + File.separator + System.mapLibraryName(string));
                } else {
                    System.loadLibrary(string);
                }
                return null;
            }
        });
    }

    static String getPrivilegedProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    static String getPrivilegedProperty(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    @Override
    public Controller[] getControllers() {
        Object object;
        Object object2;
        if (this.controllers == null) {
            this.controllers = new ArrayList();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    return DefaultControllerEnvironment.this.scanControllers();
                }
            });
            object2 = String.valueOf(DefaultControllerEnvironment.getPrivilegedProperty("jinput.plugins", "")) + " " + DefaultControllerEnvironment.getPrivilegedProperty("net.java.games.input.plugins", "");
            if (!DefaultControllerEnvironment.getPrivilegedProperty("jinput.useDefaultPlugin", "true").toLowerCase().trim().equals("false") && !DefaultControllerEnvironment.getPrivilegedProperty("net.java.games.input.useDefaultPlugin", "true").toLowerCase().trim().equals("false")) {
                object = DefaultControllerEnvironment.getPrivilegedProperty("os.name", "").trim();
                if (((String)object).equals("Linux")) {
                    object2 = String.valueOf(object2) + " net.java.games.input.LinuxEnvironmentPlugin";
                } else if (((String)object).equals("Mac OS X")) {
                    object2 = String.valueOf(object2) + " net.java.games.input.OSXEnvironmentPlugin";
                } else if (((String)object).equals("Windows XP") || ((String)object).equals("Windows Vista") || ((String)object).equals("Windows 7") || ((String)object).equals("Windows 8") || ((String)object).equals("Windows 8.1") || ((String)object).equals("Windows 10")) {
                    object2 = String.valueOf(object2) + " net.java.games.input.DirectAndRawInputEnvironmentPlugin";
                } else if (((String)object).equals("Windows 98") || ((String)object).equals("Windows 2000")) {
                    object2 = String.valueOf(object2) + " net.java.games.input.DirectInputEnvironmentPlugin";
                } else if (((String)object).startsWith("Windows")) {
                    log.warning("Found unknown Windows version: " + (String)object);
                    log.warning("Attempting to use default windows plug-in.");
                    object2 = String.valueOf(object2) + " net.java.games.input.DirectAndRawInputEnvironmentPlugin";
                } else {
                    log.warning("Trying to use default plugin, OS name " + (String)object + " not recognised");
                }
            }
            object = new StringTokenizer((String)object2, " \t\n\r\f,;:");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                try {
                    if (this.loadedPluginNames.contains(string)) continue;
                    log.fine("Loading: " + string);
                    Class<?> clazz = Class.forName(string);
                    ControllerEnvironment controllerEnvironment = (ControllerEnvironment)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (controllerEnvironment.isSupported()) {
                        this.addControllers(controllerEnvironment.getControllers());
                        this.loadedPluginNames.add(controllerEnvironment.getClass().getName());
                        continue;
                    }
                    DefaultControllerEnvironment.log(String.valueOf(clazz.getName()) + " is not supported");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        object2 = new Controller[this.controllers.size()];
        object = this.controllers.iterator();
        int n = 0;
        while (object.hasNext()) {
            object2[n] = object.next();
            ++n;
        }
        return object2;
    }

    private Void scanControllers() {
        String string = DefaultControllerEnvironment.getPrivilegedProperty("jinput.controllerPluginPath");
        if (string == null) {
            string = "controller";
        }
        this.scanControllersAt(String.valueOf(DefaultControllerEnvironment.getPrivilegedProperty("java.home")) + File.separator + "lib" + File.separator + string);
        this.scanControllersAt(String.valueOf(DefaultControllerEnvironment.getPrivilegedProperty("user.dir")) + File.separator + string);
        return null;
    }

    private void scanControllersAt(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            Plugins plugins = new Plugins(file);
            Class[] classArray = plugins.getExtends(ControllerEnvironment.class);
            int n = 0;
            while (n < classArray.length) {
                try {
                    ControllerEnvironment.log("ControllerEnvironment " + classArray[n].getName() + " loaded by " + classArray[n].getClassLoader());
                    ControllerEnvironment controllerEnvironment = (ControllerEnvironment)classArray[n].getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (controllerEnvironment.isSupported()) {
                        this.addControllers(controllerEnvironment.getControllers());
                        this.loadedPluginNames.add(controllerEnvironment.getClass().getName());
                    } else {
                        DefaultControllerEnvironment.log(String.valueOf(classArray[n].getName()) + " is not supported");
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addControllers(Controller[] controllerArray) {
        int n = 0;
        while (n < controllerArray.length) {
            this.controllers.add(controllerArray[n]);
            ++n;
        }
    }

    @Override
    public boolean isSupported() {
        return true;
    }
}

