/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;

public abstract class AbstractController
implements Controller {
    static final int EVENT_QUEUE_DEPTH = 32;
    private static final Event event = new Event();
    private final String name;
    private final Component[] components;
    private final Controller[] children;
    private final Rumbler[] rumblers;
    private final Map<Component.Identifier, Component> id_to_components = new HashMap<Component.Identifier, Component>();
    private EventQueue event_queue = new EventQueue(32);

    protected AbstractController(String string, Component[] componentArray, Controller[] controllerArray, Rumbler[] rumblerArray) {
        this.name = string;
        this.components = componentArray;
        this.children = controllerArray;
        this.rumblers = rumblerArray;
        int n = componentArray.length - 1;
        while (n >= 0) {
            this.id_to_components.put(componentArray[n].getIdentifier(), componentArray[n]);
            --n;
        }
    }

    @Override
    public final Controller[] getControllers() {
        return this.children;
    }

    @Override
    public final Component[] getComponents() {
        return this.components;
    }

    @Override
    public final Component getComponent(Component.Identifier identifier) {
        return this.id_to_components.get(identifier);
    }

    @Override
    public final Rumbler[] getRumblers() {
        return this.rumblers;
    }

    @Override
    public Controller.PortType getPortType() {
        return Controller.PortType.UNKNOWN;
    }

    @Override
    public int getPortNumber() {
        return 0;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Controller.Type getType() {
        return Controller.Type.UNKNOWN;
    }

    @Override
    public final void setEventQueueSize(int n) {
        try {
            this.setDeviceEventQueueSize(n);
            this.event_queue = new EventQueue(n);
        }
        catch (IOException iOException) {
            ControllerEnvironment.log("Failed to create new event queue of size " + n + ": " + iOException);
        }
    }

    protected void setDeviceEventQueueSize(int n) throws IOException {
    }

    @Override
    public final EventQueue getEventQueue() {
        return this.event_queue;
    }

    protected abstract boolean getNextDeviceEvent(Event var1) throws IOException;

    protected void pollDevice() throws IOException {
    }

    @Override
    public synchronized boolean poll() {
        Component[] componentArray = this.getComponents();
        try {
            this.pollDevice();
            int n = 0;
            while (n < componentArray.length) {
                AbstractComponent abstractComponent = (AbstractComponent)componentArray[n];
                if (abstractComponent.isRelative()) {
                    abstractComponent.setPollData(0.0f);
                } else {
                    abstractComponent.resetHasPolled();
                }
                ++n;
            }
            while (this.getNextDeviceEvent(event)) {
                AbstractComponent abstractComponent = (AbstractComponent)event.getComponent();
                float f = event.getValue();
                if (abstractComponent.isRelative()) {
                    if (f == 0.0f) continue;
                    abstractComponent.setPollData(abstractComponent.getPollData() + f);
                } else {
                    if (f == abstractComponent.getEventValue()) continue;
                    abstractComponent.setEventValue(f);
                }
                if (this.event_queue.isFull()) continue;
                this.event_queue.add(event);
            }
            return true;
        }
        catch (IOException iOException) {
            ControllerEnvironment.log("Failed to poll device: " + iOException.getMessage());
            return false;
        }
    }
}

