/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import assembler.rgbds.RGBDSMapFile;
import disassembler.Section;
import disassembler.SectionProvider;
import java.util.ArrayList;
import java.util.List;
import util.map.HashMap;
import util.map.Map;

public class RGBDSSectionProvider
implements SectionProvider {
    private final Map<RGBDSSection> romSections = new HashMap<RGBDSSection>();
    private final Map<RGBDSSection> ramSections = new HashMap<RGBDSSection>();
    private final java.util.Map<String, RGBDSSection> sections = new java.util.HashMap<String, RGBDSSection>();
    private final List<? extends Section>[] emptyRomSections;

    public RGBDSSectionProvider(RGBDSMapFile rGBDSMapFile) {
        List[] listArray = new List[rGBDSMapFile.getBanks().size()];
        for (RGBDSMapFile.Bank bank : rGBDSMapFile.getBanks()) {
            int n = bank.getBankNumber();
            for (RGBDSMapFile.Section section : bank.getSections()) {
                Object object;
                RGBDSSection rGBDSSection = new RGBDSSection(section, bank);
                int n2 = section.getOrg();
                boolean bl = rGBDSSection.type.startsWith("ROM");
                if (bl) {
                    this.romSections.put(n * 16384 | n2 & 0x3FFF, rGBDSSection);
                } else if (rGBDSSection.type.startsWith("WRAM")) {
                    this.ramSections.put((n2 >= 53248 ? Math.max(1, n) : 0) * 4096 | n2 & 0xFFF, rGBDSSection);
                } else if ("HRAM".equals(rGBDSSection.type)) {
                    this.ramSections.put(n2, rGBDSSection);
                }
                String string = section.getName();
                if (string != null) {
                    this.sections.put(string, rGBDSSection);
                    continue;
                }
                if (!bl) continue;
                while (n > listArray.length) {
                    object = new List[listArray.length << 1];
                    System.arraycopy(listArray, 0, object, 0, listArray.length);
                    listArray = object;
                }
                object = listArray[n];
                if (object == null) {
                    listArray[n] = object = new ArrayList();
                }
                object.add(rGBDSSection);
            }
        }
        this.emptyRomSections = listArray;
    }

    @Override
    public Section getRomSection(int n) {
        return this.romSections.get(n);
    }

    @Override
    public Section getRamSection(int n) {
        return this.ramSections.get(n);
    }

    @Override
    public int getSectionAddress(String string) {
        RGBDSSection rGBDSSection = this.sections.get(string.trim());
        if (rGBDSSection == null) {
            return -1;
        }
        if (rGBDSSection.org < 16384) {
            return rGBDSSection.org;
        }
        return Math.max(1, rGBDSSection.bank) * 16384 | rGBDSSection.org & 0x3FFF;
    }

    @Override
    public int getSectionEnd(String string) {
        RGBDSSection rGBDSSection = this.sections.get(string);
        if (rGBDSSection == null) {
            return -1;
        }
        if (rGBDSSection.org < 16384) {
            return rGBDSSection.org + rGBDSSection.size;
        }
        return (Math.max(1, rGBDSSection.bank) * 16384 | rGBDSSection.org & 0x3FFF) + rGBDSSection.size;
    }

    @Override
    public int getNumberOfSections() {
        return this.sections.size();
    }

    @Override
    public List<? extends Section>[] getEmptyRomSections() {
        return this.emptyRomSections;
    }

    class RGBDSSection
    implements Section {
        final String name;
        final int org;
        final int size;
        final int bank;
        final String type;

        public RGBDSSection(String string, int n, int n2, int n3, String string2) {
            this.name = string;
            this.org = n;
            this.size = n2;
            this.bank = n3;
            this.type = string2;
        }

        public RGBDSSection(RGBDSMapFile.Section section, RGBDSMapFile.Bank bank) {
            this(section.getName(), section.getOrg(), section.getSize(), bank.getBankNumber(), bank.getType());
        }

        @Override
        public int getOrg() {
            return this.org;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        public String toString() {
            if (this.name == null) {
                return "; EMPTY space from " + Integer.toHexString(this.bank * 16384 | this.org & 0x3FFF).toUpperCase() + " to " + Integer.toHexString((this.bank * 16384 | this.org & 0x3FFF) + this.size - 1).toUpperCase() + " (" + this.size + " bytes)";
            }
            return "SECTION \"" + this.name + "\", " + (this.bank == 0 ? String.valueOf(this.type) + "[$" + Integer.toHexString(this.org) + "]" : String.valueOf(this.type) + "[$" + Integer.toHexString(this.org) + "], BANK[$" + Integer.toHexString(this.bank) + "]");
        }
    }
}

